#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
    Variables
    Temp_TH4 => Store the TH4 value
    Temp_TL4 => Store the TL4 value
    ****************************************************************/
    uint8_t Temp_TH4 = 0, Temp_TL4 = 0;

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);

    /****************************************************************
     *  Timer4 Initialized
     *  LED Toggle time => (1/(SYSCLK/12)) * 60000) = 0.06 S
     ****************************************************************/
    __DRV_TIMER4_Mode_Select(TIMER4_MODE1_16BIT_AUTORELOAD_WITH_EXTERNAL_INTERRUPT);
    __DRV_TIMER4_Clock_Source_Select(TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12);

    while (1)
    {
        /****************************************************************
         *  Timer4 Global control running
         *  Run to 0xEA60(60000) -> stop running -> Inverse P55(LED4) -> Reload 0x0000
         ****************************************************************/
        __DRV_TIMER_Globel_Enable_Cmd(TR4E);
        while (Temp_TH4 < 0xEA || Temp_TL4 < 0x60)
        {
            Temp_TH4 = DRV_TIMER4_GetTH4();
            Temp_TL4 = DRV_TIMER4_GetTL4();
        }
        __DRV_TIMER_Globel_Stop_Cmd(T4SC);
        Temp_TH4 = Temp_TL4 = 0;
        __DRV_GPIO_InversePinP5(P55);
        __DRV_TIMER_Globel_Reload_Cmd(T4RLC);
    }
}
