#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"
#include "MG82F6D64_INT_DRV.h"
#include "MG82F6D64_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P46 used for T3CKO Pin
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);
    __DRV_GPIO_P4ModeSelect(P46_PushPull);

    /****************************************************************
     *  Timer3 Initialized
     ****************************************************************/
    __DRV_TIMER3_Mode_Select(TIMER3_SPLIT_MODE4_8BIT_PWM);
    __DRV_TIMER3_Clock_Source_Select(TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER3_SetLowByte(25);
    __DRV_TIMER3_SetRCAP3L(25);
    __DRV_TIMER3_Clock_Out_Cmd(MW_ENABLE);
    __DRV_TIMER3_Run_Cmd(MW_ENABLE);

    while (1)
    {
        /****************************************************************
         *  Timer3 PWM Signal output
         *  T3CKO(P46) output to LED_D4(P55)
         ****************************************************************/
        __DRV_GPIO_WriteP5(P55, P46);
    }
}
