#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"
#include "MG82F6D64_INT_DRV.h"
#include "MG82F6D64_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

/****************************************************************
Variables
Timer3 overflow Interrupt(TH3) => TF3_Flag
Timer3 external Interrupt      => EXF3_Flag
Timer3 overflow Interrupt(TL3) => TF3L_Flag
****************************************************************/
unsigned char TF3_Flag, EXF3_Flag, TF3L_Flag;

void main()
{
    /****************************************************************
     *  Interrupt Initialized
     *  1. Enable Timer3 interrupt (ET3) = Enable;
     *  2. Global enables all interrupts (EA) = Enable;
     ****************************************************************/
    __DRV_TIMER3_IT_Cmd(MW_ENABLE);
    __DRV_INT_ITEA_Enable();

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P00 used for T3EX Pin
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);
    __DRV_GPIO_P0ModeSelect(P00_OpenDrainPullUp);

    /****************************************************************
     *  Timer3 Initialized
     *  1. Capture Source = T3EX Pin
     *  2. Capture Edge = FALLING
     ****************************************************************/
    __DRV_TIMER3_Capture_Source_Select(TIMER3_CAPTURE_SOURCE_T3EX_PIN);
    __DRV_TIMER3_Capture_Source_Dectect(Timer3_FALLING_EDGE);

    /****************************************************************
     *  Timer3 External Trigger
     *  Trigger source = T3EX Pin(P00)
     ****************************************************************/
    __DRV_GPIO_WriteP0(P00, 1);

    while (1)
    {
        __DRV_GPIO_WriteP0(P00, 0);
        if (EXF3_Flag == 1)
        {
            __DRV_GPIO_InversePinP5(P55);
            __DRV_GPIO_WriteP0(P00, 1);
            delay_ms(50);
            EXF3_Flag = 0;
        }
    }
}

/****************************************************************
Timer3 interrupt
The Timer3 has TF3, EXF3, TF3L flags to trigger the Timer3 interrupt.
****************************************************************/
void TIMER3_TF3_EXF3_TF3L_ISR(void) interrupt TIMER3_ISR_VECTOR
{
    if (DRV_TIMER3_GetTF3() == 1)
    {
        TF3_Flag = 1;
        DRV_TIMER3_ClearTF3();
    }

    if (DRV_TIMER3_GetTF3L() == 1)
    {
        TF3L_Flag = 1;
        DRV_TIMER3_ClearTF3L();
    }

    if (DRV_TIMER3_GetEXF3() == 1)
    {
        EXF3_Flag = 1;
        DRV_TIMER3_ClearEXF3();
    }
}
