#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"
#include "MG82F6D64_Timer_DRV.h"
#include "MG82F6D64_INT_DRV.h"
#include "MG82F6D64_INT_VECTOR.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)

void main()
{
    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4
     *  2. P10 used for T2CKO Pin
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull);
    __DRV_GPIO_P1ModeSelect(P10_PushPull);

    /****************************************************************
     *  Timer2 Initialized
     ****************************************************************/
    __DRV_TIMER2_Mode_Select(TIMER2_SPLIT_MODE4_8BIT_PWM);
    __DRV_TIMER2_Clock_Source_Select(TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12);
    __DRV_TIMER2_SetLowByte(254);
    __DRV_TIMER2_SetRCAP2L(254);
    __DRV_TIMER2_Clock_Out_Cmd(MW_ENABLE);
    __DRV_TIMER2_Run_Cmd(MW_ENABLE);

    while (1)
    {
        /****************************************************************
         *  Timer2 PWM Signal output
         *  T2CKO(P10) output to LED_D4(P55)
         ****************************************************************/
        __DRV_GPIO_WriteP5(P55, P10);
    }
}
