#include <intrins.h>
#include "REG_MG82F6D64.h"
#include "TYPEDEF.h"
#include "MG82F6D64_COMMON_DRV.h"
#include "MG82F6D64_GPIO_DRV.h"

/**
 ******************************************************************************
 * do-while template
 ******************************************************************************
 */
#define MWT( __stuff__ )  do { __stuff__ } while (0)


/****************************************************************
 *  Function : delay_ms
 *  When CPU clock at 12 MHz delay time is about 1mS.
 ****************************************************************/
void delay_ms(uint16_t dly)
{
    uint16_t dly1;
    while (dly--)
    {
        dly1 = 627;
        while (dly1--);
    }
}

void main()
{
    /****************************************************************
     *  Variable declaration
     ****************************************************************/
    uint8_t Led[3] = {0x20, 0x40, 0x80}, ShiftMode = 0;
    s8 i = 0;

    /****************************************************************
     *  GPIO Initialized
     *  1. P55 used for LED_D4.
     *  2. P56 used for LED_D5.
     *  3. P57 used for LED_D6.
     *  4. P70 used for switch led flash director.
     ****************************************************************/
    __DRV_GPIO_P5ModeSelect(P55_PushPull | P56_PushPull | P57_PushPull);
    __DRV_GPIO_P7ModeSelect(P70_OpenDrainPullUp);

    while (1)
    {
        /****************************************************************
         *  Shift LED
         *  1. Connect P70 to VCC or GND to choice the led flash direction.
         ****************************************************************/
        __DRV_GPIO_ReadP7(ShiftMode);
        if (ShiftMode == 0x00)
        {
            for (i = 2; i >= 0; i--)
            {
                __DRV_GPIO_WriteP5(P5, ~Led[i]);
                delay_ms(500);
            }
        }
        else if (ShiftMode == 0x01)
        {
            for (i = 0; i < 3; i++)
            {
                __DRV_GPIO_WriteP5(P5, ~Led[i]);
                delay_ms(500);
            }
        }
    }
}
