/*********************************************************************
    Ŀ:MG82F6D64-DEMO
			԰ʹ MG82F6D64 LQFP64_V10 EV Board (TH210A)
			CpuCLK=12MHz, SysCLK=12MHz
			
				0LIN Slave
			ע

    ʱ:
    ޸־:
    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D64.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D64.H"
#include ".\include\API_Uart_BRGRL_MG82F6D64.H"

/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		12000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.36MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/
#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0			P55
#define LED_R			P56
#define LED_G_1			P57

#define LIN_TXD			P31
#define LIN_RXD			P30

#define LIN_TIME_MAX				10

#define LIN_SYNC_BYTE				0x55

#define LIN_AUTO_BAUDRATE_FLAG		0		// 0->ֹԶУ׼             1->ʹԶУ׼			

#define LIN_PID_MASTER_TX_MSG0		0x10		
#define LIN_PID_MASTER_TX_MSG1		0x11	

#define LIN_PID_MASTER_RX_MSG0		0x21
#define LIN_PID_MASTER_RX_MSG1		0x31




// LIN״̬
typedef enum
{
  LIN_IDLE_BREAK=0,
  LIN_SYNC,
  LIN_PID,
  LIN_MASTER_RX_DATA,
  LIN_MASTER_RX_CHECKSUM,
  LIN_MASTER_RX_DONE,
  LIN_MASTER_TX_DATA,
  LIN_MASTER_TX_CHECKSUM,
  LIN_MASTER_TX_DONE,
  LIN_ERR
}LIN_State;

// LINģʽ
typedef enum
{
  	LIN_MODE_MASTER_TX=0,
	LIN_MODE_MASTER_RX,
	LIN_MODE_SLAVE_TX,
	LIN_MODE_SLAVE_RX
}LIN_Mode;

// ֡ṹ
typedef struct
{
	LIN_Mode Mode;
  	LIN_State State;
  	u8 PID ;
  	u8 Data[8];
  	u8 DataLength;
  	u8 DataInx;
  	u8 Check;
} LIN_Frame ;

#define BIT(A,B)      ((A>>B)&0x01)   // A Ϊ 

idata LIN_Frame LINFrame;

// ӻPID( Уֵ)
typedef struct
{
  	u8 SPIDMTx0_P;		// ӻPID 0,
  	u8 SPIDMTx1_P;		// ӻPID 1,
  	u8 SPIDMRx0_P;		// ӻPID 0,մӷ
  	u8 SPIDMRx1_P;		// ӻPID 1,մӷ
} LIN_SlavePID_Def ;
idata LIN_SlavePID_Def LINSlavePID;

u8 LedTime;
u8 LINOverTime;

void LIN_Slave_StartFrame(void);
u8 LIN_CalcParity(u8 id);
u8 LIN_CalcChecksum(u8 id,u8 *lindata,u8 length);
u8 LIN_CalcChecksum_INT(u8 id,u8 *lindata,u8 length);

/***********************************************************************************
:	u8 LIN_CalcChecksum_INT(uint8 id,uint8 *data,uint8 length)
: LINУͼ ڴڽжϣ
:	
ز:	  
*************************************************************************************/
u8 LIN_CalcChecksum_INT(u8 id,u8 *lindata,u8 length)
{
	u8 i;
	u16 check_sum = 0;
	//0x3C 0x3D ʹñ׼У
	if(id != 0x3c && id != 0x7d)  //ʹǿУ
	{
	 	check_sum  = id ;
	} 
	else //ʹñ׼У
	{
	 	check_sum = 0 ;
	}
	for (i = 0; i < length; i++) 
	{    
	  	check_sum += *(lindata++);
	  
	  	if (check_sum > 0xFF)      //λ
	  	{
	  		check_sum -= 0xFF;
	  	}
	}
	return (~check_sum);  //ȡ
}

/***********************************************************************************
:   void INT_UART0(void)
:UART0 жϷ
		 
:   
ز:     
*************************************************************************************/
void INT_UART0(void) interrupt INT_VECTOR_UART0
{
	u8 x;
	_push_(SFRPI);
	SFR_SetPage(0);
	if(RI0==1)
	{
		// LINͨ״̬
		if(LINFrame.State==LIN_IDLE_BREAK)
		{
			if((S0CFG1&SBF0)!=0)
			{ // Rx Break done
				UART0_LIN_ClrSBF0();
				#if (LIN_AUTO_BAUDRATE_FLAG==TRUE)
				{
					UART0_LIN_AutoBR();
					while(LIN_TXD==0);
					LINFrame.State=LIN_PID;				// ԶУʱ,SYNC(0x55)УգһPID
				}
				#else
				{
					UART0_LIN_DisAutoBR();		
					LINFrame.State=LIN_SYNC;			// ԶУʱ,SYNC(0x55)ᱻգһSYNC(0x55)
				}
				#endif
				LINOverTime=LIN_TIME_MAX;
			}
		}
		/**/
		else if(LINFrame.State==LIN_SYNC)
		{ // Rx SYNC done
			x=S0BUF;
			if(x == LIN_SYNC_BYTE)
			{
				LINFrame.State++;
				LINOverTime=LIN_TIME_MAX;
			}
			else
			{
				LINFrame.State=LIN_ERR;
			}
		}
		/**/
		else if(LINFrame.State==LIN_PID)
		{ // Rx PID done
			LINOverTime=LIN_TIME_MAX;
			LINFrame.PID = S0BUF;
			if((LINFrame.PID == LINSlavePID.SPIDMRx0_P)||(LINFrame.PID == LINSlavePID.SPIDMRx1_P))
			{ // PID for Master get msg 
					// Lin salve data init
					for(x = 0 ;x<8;x++)
					{
						LINFrame.Data[x] = 0x58+x ;
					}
					LINFrame.DataLength=8;
					LINFrame.Check = LIN_CalcChecksum_INT(LINFrame.PID, &LINFrame.Data[0], LINFrame.DataLength);
					LINFrame.DataInx=1;
					// send first data
					UART0_LIN_SetTX();
					S0BUF=LINFrame.Data[0];
					LINFrame.State=LIN_MASTER_RX_DATA;
			}
			else if((LINFrame.PID == LINSlavePID.SPIDMTx0_P)||(LINFrame.PID == LINSlavePID.SPIDMTx1_P))
			{// PID for Master send msg 
				LINFrame.State=LIN_MASTER_TX_DATA;
				LINFrame.DataInx=0;
			}
			else 
			{// PID error
				LINFrame.State=LIN_ERR;
			}

		}
		else if(LINFrame.State==LIN_MASTER_TX_DATA)
		{
			LINOverTime=LIN_TIME_MAX;
			LINFrame.Data[LINFrame.DataInx] = S0BUF;
			LINFrame.DataInx++;
			if(LINFrame.DataInx>=LINFrame.DataLength)
			{
				LINFrame.State++;
			}

		}
		else if(LINFrame.State==LIN_MASTER_TX_CHECKSUM)
		{
			LINOverTime=LIN_TIME_MAX;
			LINFrame.Check=S0BUF;
			LINFrame.State++;
		}
		else if(LINFrame.State==LIN_MASTER_TX_DONE)
		{
			
		}
		else
		{
			LINFrame.State=LIN_ERR;
		}
		RI0 = 0;
	}
	else
	{
		TI0 = 0;
		if(LINFrame.State==LIN_MASTER_RX_DATA)
		{
			LINOverTime=LIN_TIME_MAX;
			S0BUF=LINFrame.Data[LINFrame.DataInx];
			LINFrame.DataInx++;
			if(LINFrame.DataInx>=LINFrame.DataLength)
			{
				LINFrame.State++;
			}
		}
		else if(LINFrame.State==LIN_MASTER_RX_CHECKSUM)
		{
			LINOverTime=LIN_TIME_MAX;
			S0BUF=LINFrame.Check;
			LINFrame.State++;
			
		}
		else if(LINFrame.State==LIN_MASTER_RX_DONE)
		{
			
		}
		else
		{
			LINFrame.State=LIN_ERR;
		}
	}
	_pop_(SFRPI);
}

/***********************************************************************************
:   void INT_T0(void)
:T0 жϷ
		 1ms
:   
ز:     
*************************************************************************************/
void INT_T0(void) interrupt INT_VECTOR_T0
{
	TH0=TIMER_12T_1ms_TH;
	TL0=TIMER_12T_1ms_TL;

	if(LedTime!=0) LedTime--;
	if(LINOverTime!=0) LINOverTime--;
}

/*************************************************
:     void DelayXus(u16 xUs)
:   	ʱ򣬵λΪus
:     u8 Us -> *1us  (1~255)
:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
:     void DelayXms(u16 xMs)
:     ʱ򣬵λΪms
:     u16 xMs -> *1ms  (1~65535)
:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
:   void InitUart0_LIN(void)
:   Uart0ʼ Ϊ LIN
:   
ز:     
*************************************************************************************/
void InitUart0_LIN(void)
{
	
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetModeLIN();					// ôLIN ģʽ				
	UART0_EnReception();				// չ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk

	// S0BRG Value
	UART0_SetS0BRGValue(S0BRG_BRGRL_19200_2X_12000000_1T);
	
	UART0_EnS0BRG();					// S0BRGʱ
	
	
}

/***********************************************************************************
:   void InitTimer0(void)
:Timer0ʼ
		 T0Ϊ16λʱ,ʱΪSysclk/192 6us~393216us	
:   
ز:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_SYSCLKDiv12();					// T0ʱԴΪ SYSCLK/12
	TM_SetT0Gate_Disable();

	TM_SetT0LowByte(TIMER_12T_1ms_TL);		// T08λ
	TM_SetT0HighByte(TIMER_12T_1ms_TH);		// T08λ

	TM_EnableT0();							// ʹT0
}


/***********************************************************************************
:   void InitInterrupt(void)
:   жϳʼ
:   
ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnUART0();				// ʹUART0ж
	INT_EnTIMER0();				// ʹT0ж
}	

/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT2|BIT3|BIT4|BIT5|BIT6|BIT7);					// P52,P53,P54,P55,P56,P57Ϊ
	PORT_SetP3QuasiBi(BIT0|BIT1|BIT3|BIT4|BIT5);						//  P30,P31,P33,P34,P35 Ϊ׼˫
}

/***********************************************************************************
:   void InitClock(void)
:   ʱӳʼ	
:   
ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==36000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// CKMIx6,x8,x12
	CLK_SetCKM_x6x8x12();	
	// SysClk=36MHz CpuClk=18MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx6, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4_X6|OSCIn_IHRCO);
#else
	// CKMIx6,x8,x12
	CLK_SetCKM_x6x8x12();	
	// SysClk=36MHz CpuClk=18MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx6, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4_X6|OSCIn_IHRCO);
#endif
#endif


#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitTimer0();
	InitUart0_LIN();
	InitInterrupt();
}


/*
*************************************************************************************
*  Function
*
*************************************************************************************
*/
/***********************************************************************************
:   void LIN_Slave_StartFrame(void)
:   LIN ʼ
:   
ز:     
*************************************************************************************/
void LIN_Slave_StartFrame(void)
{
	// S0BRG Value, ʼĿ겨ʲ̫
	UART0_SetS0BRGValue(S0BRG_BRGRL_19200_2X_12000000_1T);
	UART0_LIN_SetRX();
	UART0_LIN_WaitSYNC();

	LINFrame.State=LIN_IDLE_BREAK;
}

/***********************************************************************************
:	uint8 LIN_CalcParity(uint8 id)
: LINżУ
:	
ز:	  
*************************************************************************************/
u8 LIN_CalcParity(u8 id)
{
	u8 parity, p0,p1;
	parity=id; 
	p0=(BIT(parity,0)^BIT(parity,1)^BIT(parity,2)^BIT(parity,4))<<6;     //żУλ
	p1=(!(BIT(parity,1)^BIT(parity,3)^BIT(parity,4)^BIT(parity,5)))<<7;  //Уλ
	parity|=(p0|p1);
	return parity;
}

/***********************************************************************************
:	u8 LIN_CalcChecksum(uint8 id,uint8 *data,uint8 length)
: LINУͼ
:	
ز:	  
*************************************************************************************/
u8 LIN_CalcChecksum(u8 id,u8 *lindata,u8 length)
{
	u8 i;
	u16 check_sum = 0;
	//0x3C 0x3D ʹñ׼У
	if(id != 0x3c && id != 0x7d)  //ʹǿУ
	{
	 	check_sum  = id ;
	} 
	else //ʹñ׼У
	{
	 	check_sum = 0 ;
	}
	for (i = 0; i < length; i++) 
	{    
	  	check_sum += *(lindata++);
	  
	  	if (check_sum > 0xFF)      //λ
	  	{
	  		check_sum -= 0xFF;
	  	}
	}
	return (~check_sum);  //ȡ
}

/*
*************************************************************************************
*/ 

void main()
{

	InitSystem();
	
	LED_G_0 =0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0 =1;LED_G_1=1;LED_R=1;	

	LINSlavePID.SPIDMTx0_P=LIN_CalcParity(LIN_PID_MASTER_TX_MSG0);
	LINSlavePID.SPIDMTx1_P=LIN_CalcParity(LIN_PID_MASTER_TX_MSG1);
	LINSlavePID.SPIDMRx0_P=LIN_CalcParity(LIN_PID_MASTER_RX_MSG0);
	LINSlavePID.SPIDMRx1_P=LIN_CalcParity(LIN_PID_MASTER_RX_MSG1);

	INT_EnAll();
	LIN_Slave_StartFrame();

	while(1)
    {
		if(LedTime==0)
		{
			LedTime=100;
			LED_G_0 = !LED_G_0;	
		}
		if(LINFrame.State==LIN_MASTER_RX_DONE)
		{
			LED_G_1=0;
			DelayXms(2);
			LED_G_1=1;
			DelayXms(2);
			LIN_Slave_StartFrame();
			
		}
		if(LINFrame.State==LIN_MASTER_TX_DONE)
		{
			// У
			if(LINFrame.Check == LIN_CalcChecksum(LINFrame.PID, &LINFrame.Data[0], LINFrame.DataLength))
			{ // Уɹ
				LED_R=0;
				DelayXms(2);
				LED_R=1;
				DelayXms(2);
			}
			LIN_Slave_StartFrame();
			
		}

		if(LINFrame.State==LIN_ERR)
		{
			LIN_Slave_StartFrame();
			
		}

		if((LINFrame.State != LIN_IDLE_BREAK)&&(LINOverTime ==0))
		{
			LINFrame.State = LIN_ERR;
		}
    }

}


