/*********************************************************************
    Ŀ:MG82F6D64-DEMO
			԰ʹ MG82F6D64 LQFP64_V10 EV Board (TH210A)
			CpuCLK=24MHz, SysCLK=48MHz
	
			SPI(nSS/P14,MOSI/P15,MISO/P16,SPICLK/P17)дEN25Q32A
			SPIΪ24MHz
			DMADMAĲ
	ע

    ʱ:
    ޸־:
    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D64.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D64.H"
#include ".\include\API_Uart_BRGRL_MG82F6D64.H"

/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		48000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.36MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/
//#define MCU_CPUCLK		(MCU_SYSCLK)
#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define TIMER_12T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) /256) 			
#define TIMER_12T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(12000000)))) %256)

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57

#define SPI_nSS		P14

// SPI
#define Dummy_Data					0xFF
#define FLASH_BLOCK_SIZE			(64L*1024L)					// 64K Byte

#define FLASH_TEST_START_ADDRESS	0x00000000
#define FLASH_TEST_SIZE_MAX			(1024L*1024L)				// 1M Byte

xdata u8 TestBuf[512];
u16 TestBufCnt;

/*************************************************
:     void DelayXus(u16 xUs)
:   	ʱ򣬵λΪus
ú:        
:     u8 Us -> *1us  (1~255)
:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
:     void DelayXms(u16 xMs)
:     ʱ򣬵λΪms
:     u16 xMs -> *1ms  (1~65535)
:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
:void SendByte(u8 tByte)
:0
: u8 tByte: ͵
ز:     
*************************************************************************************/
void SendByte(u8 tByte)
{
	bit bES0;
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}

/***********************************************************************************
:void SendStr(u8* PStr)
:ַ
: u8* PStr:ַʼַ
ز:     
*************************************************************************************/
void SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

/***********************************************************************************
:   void SendHex(u8 ToSend)
:ַʽ16
: u8 ToSend: ͵16  
ز:     
*************************************************************************************/
void SendHex(u8 ToSend)
{
	u8 x;
//	SendByte(' ');
//	SendByte('0');
//	SendByte('x');
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}

/***********************************************************************************
:   void SendDW2DEC(u8 ToSend)
:10
: u32 ToSend: ͵16 (4ֽ) 
ز:     
*************************************************************************************/
void SendDW2DEC(u32 ToSend)
{
	bit bFlag;
	u8 x;
	bFlag=0;
	x=ToSend/1000000000L;
	ToSend=ToSend%1000000000L;
	if(x!=0)
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/100000000L;
	ToSend=ToSend%100000000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/10000000L;
	ToSend=ToSend%10000000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/1000000L;
	ToSend=ToSend%1000000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/100000L;
	ToSend=ToSend%100000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/10000L;
	ToSend=ToSend%10000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/1000L;
	ToSend=ToSend%1000L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/100L;
	ToSend=ToSend%100L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend/10L;
	if((x!=0)||(bFlag==TRUE))
	{	bFlag=TRUE;
		SendByte('0'+x);
	}
	
	x=ToSend%10L;
	SendByte('0'+x);
		
}

/***********************************************************************************
:   void ResetCounter()
:ü
:  
ز:     
*************************************************************************************/
void ResetCounter()
{
	// رT0,T1
	TM_GlobalSTOP(TIMER0_GLOBAL_BIT|TIMER1_GLOBAL_BIT);
	TM_SetT0HighByte(0);
	TM_SetT0LowByte(0);
	TM_SetT1HighByte(0);
	TM_SetT1LowByte(0);
	// ʹT0,T1
	TM_GlobalStart(TIMER0_GLOBAL_BIT|TIMER1_GLOBAL_BIT);
}
/***********************************************************************************
:   void SendCounter()
:
:  
ز:     
*************************************************************************************/
void SendCounter()
{
	DWordTypeDef dwTime;
	TM_GlobalSTOP(TIMER0_GLOBAL_BIT|TIMER1_GLOBAL_BIT);
	dwTime.B.BHigh=TH0;
	dwTime.B.BMHigh=TL0;
	dwTime.B.BMLow=TH1;
	dwTime.B.BLow=TL1;
	SendStr("\nTIME: ");
	SendDW2DEC(dwTime.DW);
}

/***********************************************************************************
:   void InitUart0(void)
:   Uart0ʼ
		 ʹS0BRGΪԴ
:   
ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk

	// S0BRG Value
	UART0_SetS0BRGValue(S0BRG_BRGRL_115200_2X_48000000_1T);
	
	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
:   void InitTimer0(void)
:Timer0ʼ
		 T0Ϊ16λʱ,ʱΪSysclk/192 6us~393216us	
:   
ز:     
*************************************************************************************/
void InitTimer0(void)
{
	TM_SetT0Mode_1_16BIT_TIMER();			// T0ģʽΪ16λģʽ
	TM_SetT0Clock_T1OF();					// T0ʱԴΪ T1OF
	TM_SetT0Gate_Disable();
	TM_SetT0LowByte(0);						// T08λ
	TM_SetT0HighByte(0);					// T08λ
	//TM_EnableT0();						// ʹT0
}

/***********************************************************************************
:   void InitTimer1(void)
:Timer1ʼ
		 T1Ϊ16λʱ,ʱΪSysclk/48 1.5us~98304us 
:   
ز:     
*************************************************************************************/
void InitTimer1(void)
{
	TM_SetT1Mode_1_16BIT_TIMER();			// T1ģʽΪ16λģʽ
	TM_SetT1Clock_SYSCLKDiv48();			// T1ʱԴΪ SYSCLK/48
	TM_SetT1Gate_Disable();
	TM_SetT1LowByte(0);						// T18λ
	TM_SetT1HighByte(0);					// T18λ
	//TM_EnableT1();						// ʹT1
}

/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);					// P55,P56,P57Ϊ(LED)
	PORT_SetP1PushPull(BIT5|BIT7);						// P15(MOSI),P17(SPICLK)Ϊ 
	PORT_SetP1OpenDrainPu(BIT6);	// P16(MISO)Ϊ׼˫
	PORT_SetP1PushPull(BIT4);							// P14Ϊ nSS
	PORT_P14P15P16P17_HighDrive();  
	PORT_P1_EnFastDrive(BIT4|BIT5|BIT6|BIT7);
}

/***********************************************************************************
:   void InitSPI_Master(void)
:   SPIʼ
:   
ز:     
*************************************************************************************/
void InitSPI_Master(void)
{
	
	SPI_Enable();									// ʹSPI
	SPI_SelectMASTERByMSTRbit();					// MASTER
	SPI_SetClock(SPI_CLK_SYSCLK_4);					// SPIʱ SYSCLK/4 48M/4=12M
	SPI_SetCPOL_0();								// SPICLKʼƽ CPOL=0 ͵ƽ
	SPI_SetDataMSB();								// ݴλ MSB λǰ
	SPI_SetCPHA_0();								// ò͸ıģʽ CPHA=1 ǰظı,ز
	SPI_SetUseP14P15P16P17P53P54();					// IO nSS/P14,MOSI/P15,MISO/P16,SPICLK/P17

}

/***********************************************************************************
:   void InitClock(void)
:   ʱӳʼ	
:   
ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==36000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// CKMIx6,x8,x12
	CLK_SetCKM_x6x8x12();	
	// SysClk=36MHz CpuClk=18MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx6, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4_X6|OSCIn_IHRCO);
#else
	// CKMIx6,x8,x12
	CLK_SetCKM_x6x8x12();	
	// SysClk=36MHz CpuClk=18MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx6, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4_X6|OSCIn_IHRCO);
#endif
#endif


#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}

/***********************************************************************************
:   u8 SPITransceiver(u8 ToSend)
:   SPIģʽշ
:   u8 SPI_DATA: ͵
ز:   u8 :յ  
*************************************************************************************/
u8 SPITransceiver(u8 SPI_DATA)
{
	SPI_SendData(SPI_DATA);							// SPI 
	while(SPI_ChkCompleteFlag()==0);				// ȴSPI
	SPI_ClearCompleteFlag();						// SPI ɱ־
	return SPI_GetData();							// ؽյ
}

/***********************************************************************************
:   void InitDMA_XRAM_TO_SPI(void)
:DMAʼ ͨSPIXRAM 
:   
ز:     
*************************************************************************************/
void InitDMA_XRAM_TO_SPI()
{
	DMA_Disable();									// ֹͣDMA
	DMA_SetSource_XRAM();							// ԴΪXRAM
	DMA_SetDestination_SPI0TX();					// ĿΪSPI TX
	DMA_SetXRAMStartaddr((u16)(&TestBuf[0]));		// XRAMʼַ
	DMA_SetXRAMStartaddrRL((u16)(&TestBuf[0]));		// XRAMʼֵַ
	DMA_SetCount(65536-256);						// üֵ Ϊ256
	DMA_SetCountRL(65536-256);						// üֵ Ϊ256
	DMA_SetTrig_Software();							// DMA
	DMA_DisDCF0Int();								// ֹDMAɱ־DCF0ж
	DMA_DisLoop();									// ֹѭ
	DMA_Enable();									// ʹDMA
}

/***********************************************************************************
:   void InitDMA_SPI_TO_XRAM(void)
:DMAʼ ͨSPIȡݴ洢XRAM
:   
ز:     
*************************************************************************************/
void InitDMA_SPI_TO_XRAM()
{
	DMA_Disable();									// ֹͣDMA
	DMA_SetSource_SPI0RX();							// ԴΪSPI RX
	DMA_SetDestination_XRAM();						// ĿΪXRAM
	DMA_SetXRAMStartaddr((u16)(&TestBuf[0]));		// XRAMʼַ
	DMA_SetXRAMStartaddrRL((u16)(&TestBuf[0]));		// XRAMʼֵַ
	DMA_SetCount(65536-512);						// üֵ Ϊ512
	DMA_SetCountRL(65536-512);						// üֵ Ϊ512
	DMA_SetTrig_Software();							// DMA
	DMA_DisDCF0Int();								// ֹDMAɱ־DCF0ж
	DMA_DisLoop();									// ֹѭ
	DMA_Enable();									// ʹDMA
}

/*
*************************************************************************************
*  SPI FLASH EN25Q32A
*
*************************************************************************************
*/

/***********************************************************************************
:	u8 EN25Q32A_Flash_1ByteRead (u32 Address)
:	ȡEN25Q32AַָһBYTE 

:	uint32_t Address: 24λַָ 0x00000000 ~ 0xFFFFFFFF
ز: uint8_t ȡ	  
*************************************************************************************/
u8 EN25Q32A_Flash_1ByteRead (u32 Address)
{ 
	u8 x;
	SPI_nSS = 0;
    
    /* Write command */
    SPITransceiver(0x03);
	
    /* Write address */
    SPITransceiver((u8)(Address>>16));
    SPITransceiver((u8)(Address>>8));
    SPITransceiver((u8)(Address));
    
    /* Read data */
    x=SPITransceiver(Dummy_Data);

	SPI_nSS = 1;

    return  x;
}


/***********************************************************************************
:	void EN25Q32A_Flash_MultiBytesRead (u32 Address, u8 *BufferAddreass, u32 Length)
:	ȡEN25Q32AַָĶBYTE 

:	  u32 Address: 24λַָ 0x00000000 ~ 0xFFFFFFFF
		  u8 *BufferAddreass: 洢ȡݵĻַ
		  u16 Length: ȡݵĳ
ز: 
*************************************************************************************/
void EN25Q32A_Flash_MultiBytesRead (u32 Address, u8 *BufferAddreass, u16 Length)
{
	SPI_nSS = 0;
    /* Write command */
    SPITransceiver(0x03);
	
    /* Write address */
    SPITransceiver((u8)(Address>>16));
    SPITransceiver((u8)(Address>>8));
    SPITransceiver((u8)(Address));
    
    /* Read data */
    while(Length !=0)
	{
		*BufferAddreass=SPITransceiver(Dummy_Data);
        BufferAddreass ++;
        Length--;
	}
	SPI_nSS = 1;
}

/***********************************************************************************
:	u32 EN25Q32A_Flash_Read_ID (void)
:	ȡEN25Q32A ID 

:	
ز: uint32_t ȡID 
*************************************************************************************/
u32 EN25Q32A_Flash_Read_ID (void)
{
	DWordTypeDef RDAT;
    
    SPI_nSS = 0;
    /* Write command */
    SPITransceiver(0x9F);
    
    /* Read ID */
    RDAT.B.BMHigh=SPITransceiver(Dummy_Data);
    RDAT.B.BMLow=SPITransceiver(Dummy_Data);
    RDAT.B.BLow=SPITransceiver(Dummy_Data);
	SPI_nSS  = 1;
    
    return RDAT.DW;
}

/***********************************************************************************
:	void EN25Q32A_Flash_Write_Enable (void)
: ʹдFlash

:	
ز: 
*************************************************************************************/
void EN25Q32A_Flash_Write_Enable(void)
{
	u8 RDAT;
	
    
  Re_Flash_Write_Enable:
    /* Write enable */
	SPI_nSS  = 0;
	SPITransceiver(0x06);
	SPI_nSS  = 1;

    /* Read status register */
	SPI_nSS  = 0;
	SPITransceiver(0x05);			//RDSR
   
	RDAT = SPITransceiver(Dummy_Data);                                  // Get received data

	SPI_nSS  = 1;
	
    /* Check WEL == 1 */
	if((RDAT & 0x02) == 0x00)
		goto Re_Flash_Write_Enable;
}

/***********************************************************************************
:	void EN25Q32A_Flash_Check_Busy(void)
:	EN25Q32AǷæ

:	
ز: 
*************************************************************************************/
void EN25Q32A_Flash_Check_Busy(void)
{
	u8 RDAT;
    
    
    /* Read status register */
	Re_Flash_Check_Busy:
	SPI_nSS  = 0;
	SPITransceiver(0x05);							//RDSR

	RDAT = SPITransceiver(Dummy_Data);                                  // Get received data
	
    /* Check erase or write complete */
	SPI_nSS  = 1;
	if((RDAT & 0x01) == 0x01)			//WIP, write in progress
		goto Re_Flash_Check_Busy;
}

/***********************************************************************************
:	void EN25Q32A_Flash_Write_Status(u8 uStatus)
:	  д״̬

:	u8 uStatus:Ҫд״̬

ز: 
*************************************************************************************/ 
void EN25Q32A_Flash_Write_Status(u8 uStatus)
{
   EN25Q32A_Flash_Write_Enable();
    
	SPI_nSS  = 0;
	SPITransceiver(0x01);                               			// Write Status Register(WRSR) command 
                
	
    /* Write Status */
    SPITransceiver(uStatus);
	
	SPI_nSS  = 1;
   
}


/***********************************************************************************
:	void EN25Q32A_Flash_Page_Program(u32 Addr, u8 *DataSource, u16 Length)
:	EN25Q32A д

:	u32 Addr: дʼַ. 0x00000000 ~ 0xFFFFFFFF.
		  u8 *DataSource: дݻʼַ. 
		  u16 Length: дݳ, 256ֽ
ز: 
*************************************************************************************/ 
void EN25Q32A_Flash_Page_Program(u32 Addr, u8 *DataSource, u16 Length)
{
    EN25Q32A_Flash_Write_Enable();
    
	SPI_nSS  = 0;
	SPITransceiver( 0x02);                               // Write command 
	
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
	
	while(Length!=0)                                            // Write Data
	{
		SPITransceiver(*DataSource);
        DataSource++;
		Length--;
	}
	
	SPI_nSS  = 1;
   
	EN25Q32A_Flash_Check_Busy();                                       // Wait program complete
}

/***********************************************************************************
:	void EN25Q32A_Flash_Read_Start(u32 Addr)
:	EN25Q32A 

:	u32Addr: дʼַ. 0x00000000 ~ 0xFFFFFFFF.
ز: 
*************************************************************************************/ 
void EN25Q32A_Flash_Read_Start(u32 Addr)
{

	SPI_nSS  = 0;
   
    /* Write command */
    SPITransceiver(0x03);
	
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
    
	
}
/***********************************************************************************
:	void EN25Q32A_Flash_Read_Stop(void)
:	EN25Q32A ֹͣ

:	
ز: 
*************************************************************************************/ 
void EN25Q32A_Flash_Read_Stop()
{

	SPI_nSS  = 1;
}

/***********************************************************************************
:	void EN25Q32A_Flash_Page_Program_Start(u32 Addr)
:	EN25Q32A ҳд

:	u32Addr: дʼַ. 0x00000000 ~ 0xFFFFFFFF.
ز: 
*************************************************************************************/ 
void EN25Q32A_Flash_Page_Program_Start(u32 Addr)
{

    EN25Q32A_Flash_Write_Enable();
    
	SPI_nSS  = 0;
	SPITransceiver( 0x02);                               // Write command 
                
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
    
	
}

/***********************************************************************************
:	void EN25Q32A_Flash_Program_One_Word(u16 wData)
:	EN25Q32A дһWORD(16bit)

:	u16 wData: д
ز: 
*************************************************************************************/ 
void EN25Q32A_Flash_Program_One_Word(u16 wData)

{
    SPITransceiver((u8)(wData>>8));
    SPITransceiver((u8)(wData));
}

/***********************************************************************************
:	void EN25Q32A_Flash_Page_Program_Stop(void)
:	EN25Q32A ֹͣҳд

:	
ز: 
*************************************************************************************/ 
void EN25Q32A_Flash_Page_Program_Stop()
{

	SPI_nSS  = 1;
	EN25Q32A_Flash_Check_Busy();                                       // Wait program complete
}

/***********************************************************************************
:	void EN25Q32A_Flash_Block_Erase(u32 Addr)
:	EN25Q32A 

:	u32 Addr: ҪBlock ĵַ.

ز: 
*************************************************************************************/ 
void EN25Q32A_Flash_Block_Erase(u32 Addr)
{
    EN25Q32A_Flash_Write_Enable();
    
	SPI_nSS  = 0;
	SPITransceiver(0xD8);                               			// Block Erase command 
                
	
    /* Write address */
    SPITransceiver((u8)(Addr>>16));
    SPITransceiver((u8)(Addr>>8));
    SPITransceiver((u8)(Addr));
	
	SPI_nSS  = 1;
   
	EN25Q32A_Flash_Check_Busy();                                       // Wait Block Erase complete
}

/*
*************************************************************************************
*/ 

/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitSPI_Master();
	InitUart0_S0BRG();
	InitTimer0();
	InitTimer1();
}


void main()
{
	u32 i;
	
	DWordTypeDef dwTemp;
	
    InitSystem();
	
	SendStr("\nHello!");
	LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_1=1;LED_R=1;


	
	dwTemp.DW=EN25Q32A_Flash_Read_ID();
	SendStr("\nEN25Q32A ID: ");
	SendHex(dwTemp.B.BMHigh);
	SendHex(dwTemp.B.BMLow);
	SendHex(dwTemp.B.BLow);

	// д
	EN25Q32A_Flash_Write_Status(0x00);

	// DMA
	SendStr("\nEN25Q32A Erase...");
	i=FLASH_TEST_SIZE_MAX/FLASH_BLOCK_SIZE;
	// Flash
	dwTemp.DW=FLASH_TEST_START_ADDRESS;
	ResetCounter();
	while(i!=0)
	{
		LED_R = !LED_R;
		EN25Q32A_Flash_Block_Erase(dwTemp.DW);
		dwTemp.DW=dwTemp.DW+FLASH_BLOCK_SIZE;
		i--;
	}
	SendCounter();
	for(i=0;i<256;i++)
	{
		TestBuf[i]=i;
	}
	// дFlash
	SendStr("\nEN25Q32A Write 1M");
	i=FLASH_TEST_SIZE_MAX/256;		
	dwTemp.DW=FLASH_TEST_START_ADDRESS;
	ResetCounter();
	while(i!=0)
	{
		LED_R = !LED_R;
		EN25Q32A_Flash_Page_Program(dwTemp.DW,&TestBuf[0],256);
		dwTemp.DW=dwTemp.DW+256;
		i--;
	}
	SendCounter();
	// Flash
	SendStr("\nEN25Q32A Read 1M");
	i=FLASH_TEST_SIZE_MAX/512;		
	dwTemp.DW=FLASH_TEST_START_ADDRESS;
	ResetCounter();
	while(i!=0)
	{
		LED_R = !LED_R;
		EN25Q32A_Flash_MultiBytesRead(dwTemp.DW,&TestBuf[0],512);
		dwTemp.DW=dwTemp.DW+512;
		i--;
	}
	SendCounter();


	// DMA
	SendStr("\nEN25Q32A Erase...");
	i=FLASH_TEST_SIZE_MAX/FLASH_BLOCK_SIZE;
	// Flash
	dwTemp.DW=FLASH_TEST_START_ADDRESS;
	ResetCounter();
	while(i!=0)
	{
		LED_R = !LED_R;
		EN25Q32A_Flash_Block_Erase(dwTemp.DW);
		dwTemp.DW=dwTemp.DW+FLASH_BLOCK_SIZE;
		i--;
	}
	SendCounter();
	for(i=0;i<256;i++)
	{
		TestBuf[i]=i;
	}
	// дFlash
	SendStr("\nDMA EN25Q32A Write 1M");
	i=FLASH_TEST_SIZE_MAX/256;		
	dwTemp.DW=FLASH_TEST_START_ADDRESS;
	InitDMA_XRAM_TO_SPI();					// DMA,XRAM256ݵSPI
	ResetCounter();
	while(i!=0)
	{
		LED_R = !LED_R;
		EN25Q32A_Flash_Page_Program_Start(dwTemp.DW);
		DMA_ClearCompleteFlag();			// DMAɱ־
		DMA_Start();						// DMA ʼ256ֽڵ
		while(DMA_ChkCompleteFlag()==0)		// ȴDMA
		{

		}
		while(SPI_ChkCompleteFlag()==0);	// ȴһݷ
		SPI_ClearCompleteFlag();			// SPIɱ־
		EN25Q32A_Flash_Page_Program_Stop();
		dwTemp.DW=dwTemp.DW+256;
		i--;
	}
	SendCounter();
	// Flash
	SendStr("\nDMA EN25Q32A Read 1M");
	i=FLASH_TEST_SIZE_MAX/512;		
	dwTemp.DW=FLASH_TEST_START_ADDRESS;
	InitDMA_SPI_TO_XRAM();					// DMA,SPIȡ512ݵXRAM
	ResetCounter();
	EN25Q32A_Flash_Read_Start(dwTemp.DW);
	while(i!=0)
	{
		LED_R = !LED_R;
		DMA_ClearCompleteFlag();			// DMAɱ־
		DMA_Start();						// DMA ʼSPIȡ512ֽڵ
		while(DMA_ChkCompleteFlag()==0)		// ȴDMA
		{

		}
		i--;
	}
	EN25Q32A_Flash_Read_Stop();				
	SendCounter();
	
	
    while(1)
    {
    	DelayXms(100);
		LED_G_1 = !LED_G_1;
    }
}


