/*********************************************************************
    Ŀ:MG82F6D64-DEMO
			԰ʹ MG82F6D64 LQFP64_V10 EV Board (TH210A)
			CpuCLK=32MHz, SysCLK=32MHz
	
			ʹPCA0ADCת, ADCֵͨDMA͵XRAM
	ע

    ʱ:
    ޸־:
    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MG82F6D64.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MG82F6D64.H"
#include ".\include\API_Uart_BRGRL_MG82F6D64.H"

/*************************************************
ϵͳʱSysClk (MAX.50MHz)
ѡ: 
	11059200,12000000,
	22118400,24000000,
	29491200,32000000,
	44236800,48000000
*************************************************/
#define MCU_SYSCLK		32000000
/*************************************************/
/*************************************************
CPUʱ CpuClk (MAX.36MHz)
	1) CpuCLK=SysCLK
	2) CpuClk=SysClk/2
*************************************************/

#define MCU_CPUCLK		(MCU_SYSCLK)
//#define MCU_CPUCLK		(MCU_SYSCLK/2)

#define TIMER_1T_1ms_TH	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) /256) 			
#define TIMER_1T_1ms_TL	((65536-(u16)(float)(1000*((float)(MCU_SYSCLK)/(float)(1000000)))) %256)

#define LED_G_0		P55
#define LED_R		P56
#define LED_G_1		P57


#define PWM_MIN			(0*4)
#define PWM_MAX			(1024*4)
#define PWM_3_4			(768*4)
#define PWM_2_4			(512*4)
#define PWM_1_4			(256*4)
#define PWM_LOW			(62*4)
#define PWM_HINT		(64*4)

#define PCA_RELOAD		(PWM_MAX)

#define PCA_C           (65536)       	

#define PCA_CL(x)		(u8)((~(u16)x)+1) 
#define PCA_CH(x)     	(u8)(((~(u16)x)+1)>>8)         


#define TEST_ADC_DATA_CNT		16

xdata WordTypeDef TestBuf[TEST_ADC_DATA_CNT];
u8 TestBufLen;
xdata WordTypeDef ADCBuf[TEST_ADC_DATA_CNT];
u8 ADCBufLen;
u8 ChannelInx;
bit bAdcDMAFlag;

/***********************************************************************************
:   void SendByte(u8 tByte)
:ͨUARTһֽ
: 
		u8 tByte: ͵
ز:

*************************************************************************************/
void SendByte(u8 tByte)
{
	bit bES0;
	bES0=ES0;
	ES0=0;
	S0BUF=tByte;
	while(TI0==0);
	TI0=0;
	ES0=bES0;
}

/***********************************************************************************
:   void SendStr(u8* PStr)
:ͨUARTַ
: 
		u8* PStr: ַַ  
ز:

*************************************************************************************/
void SendStr(u8* PStr)
{
	while(*PStr != 0)
	{
		SendByte(*PStr);
		PStr ++;
	}
}

/***********************************************************************************
:   void SendHex(u8 ToSend)
:ͨUARTASCII뷢16Ƶ
: 
		u8 ToSend: ͵16  
ز:

*************************************************************************************/
void SendHex(u8 ToSend)
{
	u8 x;
	x = ToSend >> 4;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		SendByte('0'+x);
	}
	else
	{
		SendByte('A'-10+x);
	}
}

/***********************************************************************************
:   void INT_PCA(void)
:PCA жϷ
		 
:   
ز:     
*************************************************************************************/
void INT_PCA(void) interrupt INT_VECTOR_PCA
{
	_push_(SFRPI);
	SFRPI=0;
	if(CF)
	{
		CF=0;
		LED_R=!LED_R;
	}
	_pop_(SFRPI);
}



/***********************************************************************************
:   void INT_DMA(void)
:DMA жϷ
		 
:   
ز:     
*************************************************************************************/
void INT_DMA(void) interrupt INT_VECTOR_DMA
{
	u8 i;
	_push_(SFRPI);
	SFRPI=0;
	LED_G_1=!LED_G_1;
	bAdcDMAFlag=TRUE;
	DMACR0=DMACR0&(~DCF0);		// жϱ־λ
	for(i=0;i<(TEST_ADC_DATA_CNT);i++)
	{
		ADCBuf[i].B.BHigh=TestBuf[i].B.BLow;
		ADCBuf[i].B.BLow=TestBuf[i].B.BHigh;
	}
	_pop_(SFRPI);
}


/*************************************************
:     void DelayXus(u16 xUs)
:   	ʱ򣬵λΪus
ú:        
:     u8 Us -> *1us  (1~255)
:     
*************************************************/
void DelayXus(u8 xUs)
{
	while(xUs!=0)
	{
#if (MCU_CPUCLK>=11059200)
		_nop_();
#endif
#if (MCU_CPUCLK>=14745600)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=16000000)
		_nop_();
#endif

#if (MCU_CPUCLK>=22118400)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=24000000)
		_nop_();
		_nop_();
#endif		
#if (MCU_CPUCLK>=29491200)
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
		_nop_();
#endif
#if (MCU_CPUCLK>=32000000)
		_nop_();
		_nop_();
#endif

		xUs--;
	}
}

/*************************************************
:     void DelayXms(u16 xMs)
:     ʱ򣬵λΪms
:     u16 xMs -> *1ms  (1~65535)
:     
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		CLRWDT();
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		DelayXus(200);
		xMs--;
		
	}
}

/***********************************************************************************
:   void InitUart0(void)
:   Uart0ʼ
		 ʹS0BRGΪԴ
:   
ز:     
*************************************************************************************/
void InitUart0_S0BRG(void)
{
	
	UART0_SetAccess_S0CR1();			// SFR 0xB9ַǷS0CR1
	UART0_SetMode8bitUARTVar();			// 8λ ɱ䲨
	UART0_EnReception();				// ʹܽ
	UART0_SetBRGFromS0BRG();			// òԴΪ S0BRG
	UART0_SetS0BRGBaudRateX2();			// 2x
	UART0_SetS0BRGSelSYSCLK();			// S0BRGʱΪSysclk
	UART0_SetRxTxP30P31();				// RXD/TXD ΪP30/P31
	// S0BRG Value
	UART0_SetS0BRGValue(S0BRG_BRGRL_115200_2X_32000000_1T);
	
	UART0_EnS0BRG();					// S0BRGʱ
}

/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP5PushPull(BIT5|BIT6|BIT7);		//  P55,P56,P57Ϊ(LED)
	PORT_SetP1AInputOnly(BIT0|BIT1|BIT5);			// P10(AIN0),P11(AIN1),P15(AIN5)Ϊģ
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);		// P22(CEX0),P24(CEX2),P26(CEX4)Ϊ
	PORT_SetP3PushPull(BIT3|BIT4|BIT5);				// P33(CEX1),P34(CEX3),P35(CEX5)Ϊ
}

/***********************************************************************************
:   void InitPWM(void)
:   PWMʼ
		PCAʱ: 96MHz
		CH0(P22)/CH1(P33),CH2(P24)/CH3(P34),CH4(P26)/CH5(P35)
		3Ի,,Ķ,ֱΪ2048
		PWMƵ: 96MHz/(2048*4)=11.718KHz
:   
ز:     
*************************************************************************************/
void InitPWM(void)
{
	PCA_SetCLOCK_CKMIX16();			// 96MHz
	
	PCA_CH0_SetMode_PWM();
	PCA_CH1_SetMode_PWM();
	PCA_CH2_SetMode_PWM();
	PCA_CH3_SetMode_PWM();
	PCA_CH4_SetMode_PWM();
	PCA_CH5_SetMode_PWM();

	PCA_CH0_SetPWM_16Bit();
	PCA_CH1_SetPWM_16Bit();
	PCA_CH2_SetPWM_16Bit();
	PCA_CH3_SetPWM_16Bit();
	PCA_CH4_SetPWM_16Bit();
	PCA_CH5_SetPWM_16Bit();

	PCA_CH01_SetPWM_EnBufferMode();		// CH0,CH1 ʹܻģʽ
	PCA_CH23_SetPWM_EnBufferMode();		// CH2,CH3 ʹܻģʽ
	PCA_CH45_SetPWM_EnBufferMode();		// CH4,CH5 ʹܻģʽ
	PCA_CH01_SetPWM_EnDeadTime();		// CH0,CH1 ʹ
	PCA_CH23_SetPWM_EnDeadTime();		// CH2,CH3 ʹ
	PCA_CH45_SetPWM_EnDeadTime();		// CH2,CH3 ʹ

	PCA_SetPWM_CenterAligned();			// Ķ
	PCA_SetCenterAligned_EnVar();		// Ķʹܿɱ
	PCA_SetCenterAligned_CFonTop();		// ĶCFڶλ

	PCA_SetDeadTimePreScaler_SysclkDiv8();	// ԤƵ SysClk/8
	PCA_SetDeadTimePeriod(4);			// ʱ 4*(1/PreScaler)=4*(1/(Sysclk/8))=32/Sysclk

	// PWMռձȱȽֵ
	PCA_CH0_SetValue(PCA_CH(PWM_1_4),PCA_CL(PWM_1_4));
	PCA_CH1_SetValue(PCA_CH(PWM_1_4),PCA_CL(PWM_1_4));
	PCA_CH2_SetValue(PCA_CH(PWM_2_4),PCA_CL(PWM_2_4));
	PCA_CH3_SetValue(PCA_CH(PWM_2_4),PCA_CL(PWM_2_4));
	PCA_CH4_SetValue(PCA_CH(PWM_3_4),PCA_CL(PWM_3_4));
	PCA_CH5_SetValue(PCA_CH(PWM_3_4),PCA_CL(PWM_3_4));

	// PWMƵ
	PCA_SetCounter(PCA_C-PCA_RELOAD);
	PCA_SetCounterReload(PCA_C-PCA_RELOAD);


	// ʹPWM
	PCA_SetPWM0_EnOutput();					
	PCA_SetPWM1_EnOutput();
	PCA_SetPWM2_EnOutput();
	PCA_SetPWM3_EnOutput();
	PCA_SetPWM4_EnOutput();
	PCA_SetPWM5_EnOutput();

	PCA_SetCEX0CEX2CEX4_P22P24P26();	// CEX0:P22,CEX2:P24,CEX4:P26
	PCA_SetCEX1CEX3CEX5_P33P34P35();	// CEX1:P33,CEX2:P34,CEX4:P35
	PCA_CF_EnInterrupt();				// ʹCFж

	PCA_EnPCACounter();					// ʹPCA, 
		
}


/***********************************************************************************
:   void InitADC(void)
:   ADCʼ
:   
ز:     
*************************************************************************************/
void InitADC(void)
{
	ADC_Enable();									// ʹADC
	ADC_SetClock_SYSCLKDiv2();						// ADCתʱΪ SYSCLK       ת= 32M/2/30=533.3K
	ADC_SetMode_PCA0Overflow();						// ADCģʽ, PCA0
	ADC_SetADCData_12Bit();							// ADCλΪ12λ
	ADC_SetRightJustified();						// ADCתҶ
	ADC_SetChannel_AIN0();							// ADCͨ0
	ChannelInx=0;
}

/***********************************************************************************
:   void InitDMA_ADC0_TO_XRAM(void)
:DMAʼ ADC0->XRAM
:   
ز:     
*************************************************************************************/
void InitDMA_ADC0_TO_XRAM()
{
	DMA_SetSource_ADC0();									// ԴΪ ADC0
	DMA_SetDestination_XRAM();								// ĿΪ XRAM
	DMA_SetXRAMStartaddr((u16)(&TestBuf[0].BUF[0]));		// ĿXRAMʼַ 
	DMA_SetXRAMStartaddrRL((u16)(&TestBuf[0].BUF[0]));		// ĿXRAMʼַ
	DMA_SetCount(65536-(TEST_ADC_DATA_CNT*2));				// üֵ
	DMA_SetCountRL(65536-(TEST_ADC_DATA_CNT*2));			// ؼֵ
	DMA_SetTrig_Software();									// ôʽΪ
	DMA_EnDCF0Int();										// ʹܼж
	DMA_EnLoop();											// ʹѭģʽ
	DMA_Enable();											// ʹDMA
}

/***********************************************************************************
:   void InitInterrupt(void)
:   жϳʼ
:   
ز:     
*************************************************************************************/
void InitInterrupt(void)
{
	INT_EnDMA();											// ʹDMAж
	INT_EnPCA();											// ʹPCAж
}	

/***********************************************************************************
:   void InitClock(void)
:   ʱӳʼ	
:   
ز:     
*************************************************************************************/
void InitClock(void)
{
#if (MCU_SYSCLK==11059200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=11.0592MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=11.0592MHz CpuClk=5.5296MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==12000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=12MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1);
	
#else
	// SysClk=12MHz CpuClk=6MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1);
#endif
#endif

#if (MCU_SYSCLK==22118400)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=22.1184MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=22.1184MHz CpuClk=11.0592MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==24000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// SysClk=24MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#else
	// SysClk=24MHz CpuClk=12MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx4, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==29491200)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=29.491200MHz CpuClk=29.491200MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=29.491200MHz CpuClk=14.7456MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==32000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// SysClk=32MHz CpuClk=32MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#else
	// SysClk=32MHz CpuClk=16MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx5.33, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X533|OSCIn_IHRCO);
#endif
#endif

#if (MCU_SYSCLK==36000000)
#if (MCU_CPUCLK==MCU_SYSCLK)
	// Cpuclk high speed
	CLK_SetCpuCLK_HighSpeed();
	// CKMIx6,x8,x12
	CLK_SetCKM_x6x8x12();	
	// SysClk=36MHz CpuClk=18MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx6, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4_X6|OSCIn_IHRCO);
#else
	// CKMIx6,x8,x12
	CLK_SetCKM_x6x8x12();	
	// SysClk=36MHz CpuClk=18MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx6, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X4_X6|OSCIn_IHRCO);
#endif
#endif


#if (MCU_SYSCLK==44236800)
	// SysClk=44.2368MHz CpuClk=22.1184MHz
	CLK_SetCKCON0(IHRCO_110592MHz|CPUCLK_SYSCLK_DIV_1|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

#if (MCU_SYSCLK==48000000)
	// SysClk=48MHz CpuClk=24MHz
	CLK_SetCKCON0(IHRCO_12MHz|CPUCLK_SYSCLK_DIV_2|SYSCLK_MCKDO_DIV_1|ENABLE_CKM|CKM_OSCIN_DIV_2);
	DelayXus(100);
	// IHRCO, MCK=CKMIx8, OSCin=IHRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_CKMI_X8|OSCIn_IHRCO);
#endif

	// P60  MCK/4
	//CLK_P60OC_MCKDiv4();
}



/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	InitPort();
	InitClock();
	InitUart0_S0BRG();
	InitADC();
	InitPWM();
	InitDMA_ADC0_TO_XRAM();
	InitInterrupt();

}


void main()
{
	u8 i,cnt;
	WordTypeDef wTemp;
	
    InitSystem();

	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;
	
	
	DMA_Start();
	ADC_SoftStart();
	INT_EnAll();

	cnt=0;
    while(1)
    {
		if(bAdcDMAFlag)
		{
			bAdcDMAFlag=0;
			SendStr("\nADC:");
			wTemp.W=0;
			for(i=0;i<(TEST_ADC_DATA_CNT);i++)
			{
				wTemp.W=wTemp.W+ADCBuf[i].W;
			}
			wTemp.W=wTemp.W>>4;;
			SendHex(wTemp.B.BHigh);
			SendHex(wTemp.B.BLow);

			cnt++;
			if(cnt>=200)
			{
				cnt=0;
				LED_G_0=!LED_G_0;
			}
		}

    }
}



