/**
 ******************************************************************************
 *
 * @file        MG82F6D64_WIZARD.c
 *
 * @brief       This is a C code for Wizard interface.
 *
 * @par         Project
 *              MG82F6D64
 * @version     V2.02
 * @date        2024/05/09
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2019 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *      The Demo software is provided "AS IS" without any warranty, either
 *      expressed or implied, including, but not limited to, the implied warranties
 *      of merchantability and fitness for a particular purpose.  The author will
 *      not be liable for any special, incidental, consequential or indirect
 *      damages due to loss of data or any other reason.
 *      These statements agree with the worldwide and local dictated laws about
 *      authorship and violence against these laws.
 ******************************************************************************
 ******************************************************************************
 */

#include "MG82F6D64_CONFIG.h"


/**
*******************************************************************************
* @brief       Initializing GPIO by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
               DRV_GPIO_Wizard_Init();
* @endcode
*******************************************************************************
*/
/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_GPIO_WIZARD
/// @endcond
void DRV_GPIO_Wizard_Init(void)
{
    /*--------------------Port 0---------------------*/
    #if WizGPIO_P0_EN
        /*--------------P0_0-------------------*/
        #if WizGPIO_P00_EN
            #if (WizGPIO_P00_MODE != P00_InputOnly)
                __DRV_GPIO_P0ModeSelect(WizGPIO_P00_MODE);
            #endif
            #if (WizGPIO_P00_FDC != NORMAL)
                __DRV_GPIO_SetP0FastDriving(WizGPIO_P00_FDC ,FAST);
            #endif
        #endif
        /*--------------P0_1-------------------*/
        #if WizGPIO_P01_EN
            #if (WizGPIO_P01_MODE != P01_InputOnly)
                __DRV_GPIO_P0ModeSelect(WizGPIO_P01_MODE);
            #endif
            #if (WizGPIO_P00_FDC != NORMAL)
                __DRV_GPIO_SetP0FastDriving((WizGPIO_P00_FDC << 1),FAST);
            #endif
        #endif
        /*--------------P0_2-------------------*/
        #if WizGPIO_P02_EN
            #if (WizGPIO_P02_MODE != P02_InputOnly)
                __DRV_GPIO_P0ModeSelect(WizGPIO_P02_MODE);
            #endif
            #if (WizGPIO_P02_FDC != NORMAL)
                __DRV_GPIO_SetP0FastDriving((WizGPIO_P02_FDC << 2),FAST);
            #endif
        #endif
        /*--------------P0_3-------------------*/
        #if WizGPIO_P03_EN
            #if (WizGPIO_P03_MODE != P03_InputOnly)
                __DRV_GPIO_P0ModeSelect(WizGPIO_P03_MODE);
            #endif
            #if (WizGPIO_P03_FDC != NORMAL)
                __DRV_GPIO_SetP0FastDriving((WizGPIO_P03_FDC << 3),FAST);
            #endif
        #endif
        /*--------------P0_4-------------------*/
        #if WizGPIO_P04_EN
            #if (WizGPIO_P04_MODE != P04_InputOnly)
                __DRV_GPIO_P0ModeSelect(WizGPIO_P04_MODE);
            #endif
            #if (WizGPIO_P04_FDC != NORMAL)
                __DRV_GPIO_SetP0FastDriving((WizGPIO_P04_FDC << 4),FAST);
            #endif
        #endif
        /*--------------P0_5-------------------*/
        #if WizGPIO_P05_EN
            #if (WizGPIO_P05_MODE != P05_InputOnly)
                __DRV_GPIO_P0ModeSelect(WizGPIO_P05_MODE);
            #endif
            #if (WizGPIO_P05_FDC != NORMAL)
                __DRV_GPIO_SetP0FastDriving((WizGPIO_P05_FDC << 5),FAST);
            #endif
        #endif
        /*--------------P0_6-------------------*/
        #if WizGPIO_P06_EN
            #if (WizGPIO_P06_MODE != P06_InputOnly)
                __DRV_GPIO_P0ModeSelect(WizGPIO_P06_MODE);
            #endif
            #if (WizGPIO_P06_FDC != NORMAL)
                __DRV_GPIO_SetP0FastDriving((WizGPIO_P06_FDC << 6),FAST);
            #endif
        #endif
        /*--------------P0_7-------------------*/
        #if WizGPIO_P07_EN
            #if (WizGPIO_P07_MODE != P07_InputOnly)
                __DRV_GPIO_P0ModeSelect(WizGPIO_P07_MODE);
            #endif
            #if (WizGPIO_P07_FDC != NORMAL)
                __DRV_GPIO_SetP0FastDriving((WizGPIO_P07_FDC << 7),FAST);
            #endif
        #endif
        /*---------P0 Driving Strength---------*/
        #if P0_DRIVEIN_STRENGTH
            #if (P0DC_0 != 0)
                __DRV_GPIO_P0OutputDrivingConfig(P0DC0,P0DC_0);
            #endif
            #if (P0DC_1 != 0)
                __DRV_GPIO_P0OutputDrivingConfig(P0DC1,P0DC_1);
            #endif
        #endif
    #endif

    /*--------------------Port 1---------------------*/
    #if WizGPIO_P1_EN
        /*--------------P1_0-------------------*/
        #if WizGPIO_P10_EN
            #if (WizGPIO_P10_MODE != P10_InputOnly)
                __DRV_GPIO_P1ModeSelect(WizGPIO_P10_MODE);
            #endif
            #if (WizGPIO_P10_FDC != NORMAL)
                __DRV_GPIO_SetP1FastDriving(WizGPIO_P10_FDC ,FAST);
            #endif
        #endif
        /*--------------P1_1-------------------*/
        #if WizGPIO_P11_EN
            #if (WizGPIO_P11_MODE != P11_InputOnly)
                __DRV_GPIO_P1ModeSelect(WizGPIO_P11_MODE);
            #endif
            #if (WizGPIO_P11_FDC != NORMAL)
                __DRV_GPIO_SetP1FastDriving((WizGPIO_P11_FDC << 1),FAST);
            #endif
        #endif
        /*--------------P1_2-------------------*/
        #if WizGPIO_P12_EN
            #if (WizGPIO_P12_MODE != P12_InputOnly)
                __DRV_GPIO_P1ModeSelect(WizGPIO_P12_MODE);
            #endif
            #if (WizGPIO_P12_FDC != NORMAL)
                __DRV_GPIO_SetP1FastDriving((WizGPIO_P12_FDC << 2),FAST);
            #endif
        #endif
        /*--------------P1_3-------------------*/
        #if WizGPIO_P13_EN
            #if (WizGPIO_P13_MODE != P13_InputOnly)
                __DRV_GPIO_P1ModeSelect(WizGPIO_P13_MODE);
            #endif
            #if (WizGPIO_P13_FDC != NORMAL)
                __DRV_GPIO_SetP1FastDriving((WizGPIO_P13_FDC << 3),FAST);
            #endif
        #endif
        /*--------------P1_4-------------------*/
        #if WizGPIO_P14_EN
            #if (WizGPIO_P14_MODE != P14_InputOnly)
                __DRV_GPIO_P1ModeSelect(WizGPIO_P14_MODE);
            #endif
            #if (WizGPIO_P14_FDC != NORMAL)
                __DRV_GPIO_SetP1FastDriving((WizGPIO_P14_FDC << 4),FAST);
            #endif
        #endif
        /*--------------P1_5-------------------*/
        #if WizGPIO_P15_EN
            #if (WizGPIO_P15_MODE != P15_InputOnly)
                __DRV_GPIO_P1ModeSelect(WizGPIO_P15_MODE);
            #endif
            #if (WizGPIO_P15_FDC != NORMAL)
                __DRV_GPIO_SetP1FastDriving((WizGPIO_P15_FDC << 5),FAST);
            #endif
        #endif
        /*--------------P1_6-------------------*/
        #if WizGPIO_P16_EN
            #if (WizGPIO_P16_MODE != P16_InputOnly)
                __DRV_GPIO_P1ModeSelect(WizGPIO_P16_MODE);
            #endif
            #if (WizGPIO_P16_FDC != NORMAL)
                __DRV_GPIO_SetP1FastDriving((WizGPIO_P16_FDC << 6),FAST);
            #endif
        #endif
        /*--------------P1_7-------------------*/
        #if WizGPIO_P17_EN
            #if (WizGPIO_P17_MODE != P17_InputOnly)
                __DRV_GPIO_P1ModeSelect(WizGPIO_P17_MODE);
            #endif
            #if (WizGPIO_P17_FDC != NORMAL)
                __DRV_GPIO_SetP1FastDriving((WizGPIO_P17_FDC << 7),FAST);
            #endif
        #endif
        /*---------P1 Driving Strength---------*/
        #if P1_DRIVEIN_STRENGTH
            #if (P1DC_0 != 0)
                __DRV_GPIO_P1OutputDrivingConfig(P1DC0,P1DC_0);
            #endif
            #if (P1DC_1 != 0)
                __DRV_GPIO_P1OutputDrivingConfig(P1DC1,P1DC_1);
            #endif
        #endif
    #endif

    /*--------------------Port 2---------------------*/
    #if WizGPIO_P2_EN
        /*--------------P2_0-------------------*/
        #if WizGPIO_P20_EN
            #if (WizGPIO_P20_MODE != P20_InputOnly)
                __DRV_GPIO_P2ModeSelect(WizGPIO_P20_MODE);
            #endif
            #if (WizGPIO_P20_FDC != NORMAL)
                __DRV_GPIO_SetP2FastDriving(WizGPIO_P20_FDC,FAST);
            #endif
        #endif
        /*--------------P2_1-------------------*/
        #if WizGPIO_P21_EN
            #if (WizGPIO_P21_MODE != P21_InputOnly)
                __DRV_GPIO_P2ModeSelect(WizGPIO_P21_MODE);
            #endif
            #if (WizGPIO_P21_FDC != NORMAL)
                __DRV_GPIO_SetP2FastDriving((WizGPIO_P21_FDC << 1),FAST);
            #endif
        #endif
        /*--------------P2_2-------------------*/
        #if WizGPIO_P22_EN
            #if (WizGPIO_P22_MODE != P22_InputOnly)
                __DRV_GPIO_P2ModeSelect(WizGPIO_P22_MODE);
            #endif
            #if (WizGPIO_P22_FDC != NORMAL)
                __DRV_GPIO_SetP2FastDriving((WizGPIO_P22_FDC << 2),FAST);
            #endif
        #endif
        /*--------------P2_3-------------------*/
        #if WizGPIO_P23_EN
            #if (WizGPIO_P23_MODE != P23_InputOnly)
                __DRV_GPIO_P2ModeSelect(WizGPIO_P23_MODE);
            #endif
            #if (WizGPIO_P23_FDC != NORMAL)
                __DRV_GPIO_SetP2FastDriving((WizGPIO_P23_FDC << 3),FAST);
            #endif
        #endif
        /*--------------P2_4-------------------*/
        #if WizGPIO_P24_EN
            #if (WizGPIO_P24_MODE != P24_InputOnly)
                __DRV_GPIO_P2ModeSelect(WizGPIO_P24_MODE);
            #endif
            #if (WizGPIO_P24_FDC != NORMAL)
                __DRV_GPIO_SetP2FastDriving((WizGPIO_P24_FDC << 4),FAST);
            #endif
        #endif
        /*--------------P2_5-------------------*/
        #if WizGPIO_P25_EN
            #if (WizGPIO_P25_MODE != P25_InputOnly)
                __DRV_GPIO_P2ModeSelect(WizGPIO_P25_MODE);
            #endif
            #if (WizGPIO_P25_FDC != NORMAL)
                __DRV_GPIO_SetP2FastDriving((WizGPIO_P25_FDC << 5),FAST);
            #endif
        #endif
        /*--------------P2_6-------------------*/
        #if WizGPIO_P26_EN
            #if (WizGPIO_P26_MODE != P26_InputOnly)
                __DRV_GPIO_P2ModeSelect(WizGPIO_P26_MODE);
            #endif
            #if (WizGPIO_P26_FDC != NORMAL)
                __DRV_GPIO_SetP2FastDriving((WizGPIO_P26_FDC << 6),FAST);
            #endif
        #endif
        /*--------------P2_7-------------------*/
        #if WizGPIO_P27_EN
            #if (WizGPIO_P27_MODE != P27_InputOnly)
                __DRV_GPIO_P2ModeSelect(WizGPIO_P27_MODE);
            #endif
            #if (WizGPIO_P27_FDC != NORMAL)
                __DRV_GPIO_SetP2FastDriving((WizGPIO_P27_FDC << 7),FAST);
            #endif
        #endif
        /*---------P2 Driving Strength---------*/
        #if P2_DRIVEIN_STRENGTH
            #if (P2DC_0 != 0)
                __DRV_GPIO_P2OutputDrivingConfig(P2DC0,P2DC_0);
            #endif
            #if (P2DC_1 != 0)
                __DRV_GPIO_P2OutputDrivingConfig(P2DC1,P2DC_1);
            #endif
        #endif
    #endif

    /*--------------------Port 3---------------------*/
    #if WizGPIO_P3_EN
        /*--------------P3_0-------------------*/
        #if WizGPIO_P30_EN
            #if (WizGPIO_P30_MODE != P30_QuasiMode)
                __DRV_GPIO_P3ModeSelect(WizGPIO_P30_MODE);
            #endif
            #if (WizGPIO_P30_FDC != NORMAL)
                __DRV_GPIO_SetP3FastDriving(WizGPIO_P30_FDC,FAST);
            #endif
        #endif
        /*--------------P3_1-------------------*/
        #if WizGPIO_P31_EN
            #if (WizGPIO_P31_MODE != P31_QuasiMode)
                __DRV_GPIO_P3ModeSelect(WizGPIO_P31_MODE);
            #endif
            #if (WizGPIO_P31_FDC != NORMAL)
                __DRV_GPIO_SetP3FastDriving((WizGPIO_P31_FDC<<1),FAST);
            #endif
        #endif
        /*--------------P3_2-------------------*/
        #if WizGPIO_P32_EN
            #if (WizGPIO_P32_MODE != P32_QuasiMode)
                __DRV_GPIO_P3ModeSelect(WizGPIO_P32_MODE);
            #endif
            #if (WizGPIO_P32_FDC != NORMAL)
                __DRV_GPIO_SetP3FastDriving((WizGPIO_P32_FDC<<2),FAST);
            #endif
        #endif
        /*--------------P3_3-------------------*/
        #if WizGPIO_P33_EN
            #if (WizGPIO_P33_MODE != P33_QuasiMode)
                __DRV_GPIO_P3ModeSelect(WizGPIO_P33_MODE);
            #endif
            #if (WizGPIO_P33_FDC != NORMAL)
                __DRV_GPIO_SetP3FastDriving((WizGPIO_P33_FDC<<3),FAST);
            #endif
        #endif
        /*--------------P3_4-------------------*/
        #if WizGPIO_P34_EN
            #if (WizGPIO_P34_MODE != P34_QuasiMode)
                __DRV_GPIO_P3ModeSelect(WizGPIO_P34_MODE);
            #endif
            #if (WizGPIO_P34_FDC != NORMAL)
                __DRV_GPIO_SetP3FastDriving((WizGPIO_P34_FDC<<4),FAST);
            #endif
        #endif
        /*--------------P3_5-------------------*/
        #if WizGPIO_P35_EN
            #if (WizGPIO_P35_MODE != P35_QuasiMode)
                __DRV_GPIO_P3ModeSelect(WizGPIO_P35_MODE);
            #endif
            #if (WizGPIO_P35_FDC != NORMAL)
                __DRV_GPIO_SetP3FastDriving((WizGPIO_P35_FDC<<5),FAST);
            #endif
        #endif
        /*--------------P3_6-------------------*/
        #if WizGPIO_P36_EN
            #if (WizGPIO_P36_MODE != P36_QuasiMode)
                __DRV_GPIO_P3ModeSelect(WizGPIO_P36_MODE);
            #endif
            #if (WizGPIO_P36_FDC != NORMAL)
                __DRV_GPIO_SetP3FastDriving((WizGPIO_P36_FDC<<6),FAST);
            #endif
        #endif
        /*--------------P3_7-------------------*/
        #if WizGPIO_P37_EN
            #if (WizGPIO_P37_MODE != P37_QuasiMode)
                __DRV_GPIO_P3ModeSelect(WizGPIO_P37_MODE);
            #endif
            #if (WizGPIO_P37_FDC != NORMAL)
                __DRV_GPIO_SetP3FastDriving((WizGPIO_P37_FDC<<7),FAST);
            #endif
        #endif
        /*---------P3 Driving Strength---------*/
        #if P3_DRIVEIN_STRENGTH
            #if (P3DC_0 != 0)
                __DRV_GPIO_P3OutputDrivingConfig(P3DC0,P3DC_0);
            #endif
            #if (P3DC_1 != 0)
                __DRV_GPIO_P3OutputDrivingConfig(P3DC1,P3DC_1);
            #endif
        #endif
    #endif

    /*--------------------Port 4---------------------*/
    #if WizGPIO_P4_EN
        /*---------Port 4 Protection-----------*/
        #if MG82F6D64_GPIO_Port4_Protection
            #if (SPCON0_P4CTL != MW_DISABLE)
                __DRV_GPIO_P4_Protected(SPCON0_P4CTL);
            #endif
        #endif
        /*--------------P4_0-------------------*/
        #if WizGPIO_P40_EN
            #if (WizGPIO_P40_MODE != P40_InputOnly)
                __DRV_GPIO_P4ModeSelect(WizGPIO_P40_MODE);
            #endif
            #if (WizGPIO_P40_FDC != NORMAL)
                __DRV_GPIO_SetP4FastDriving(WizGPIO_P40_FDC,FAST);
            #endif
        #endif
        /*--------------P4_1-------------------*/
        #if WizGPIO_P41_EN
            #if (WizGPIO_P41_MODE != P41_InputOnly)
                __DRV_GPIO_P4ModeSelect(WizGPIO_P41_MODE);
            #endif
            #if (WizGPIO_P41_FDC != NORMAL)
                __DRV_GPIO_SetP4FastDriving((WizGPIO_P41_FDC<<1),FAST);
            #endif
        #endif
        /*--------------P4_2-------------------*/
        #if WizGPIO_P42_EN
            #if (WizGPIO_P42_MODE != P42_InputOnly)
                __DRV_GPIO_P4ModeSelect(WizGPIO_P42_MODE);
            #endif
            #if (WizGPIO_P42_FDC != NORMAL)
                __DRV_GPIO_SetP4FastDriving((WizGPIO_P42_FDC<<2),FAST);
            #endif
        #endif
        /*--------------P4_3-------------------*/
        #if WizGPIO_P43_EN
            #if (WizGPIO_P43_MODE != P43_InputOnly)
                __DRV_GPIO_P4ModeSelect(WizGPIO_P43_MODE);
            #endif
            #if (WizGPIO_P43_FDC != NORMAL)
                __DRV_GPIO_SetP4FastDriving((WizGPIO_P43_FDC<<3),FAST);
            #endif
        #endif

        /*--------------P4_4-------------------*/
        #if WizGPIO_P44_EN
            #if (WizGPIO_P44_MODE != P44_OpenDrainPullUp)
                __DRV_GPIO_P4ModeSelect(WizGPIO_P44_MODE);
            #endif
            #if (WizGPIO_P44_FDC != NORMAL)
                __DRV_GPIO_SetP4FastDriving((WizGPIO_P44_FDC<<4),FAST);
            #endif
            #if (WizGPIO_P44_AF != WizDef_OCD)
                __DRV_GPIO_SetOCD2IO(MW_DISABLE);
                #message "The OCD function is disable."
            #endif
        #endif
        /*--------------P4_5-------------------*/
        #if WizGPIO_P45_EN
            #if (WizGPIO_P45_MODE != P45_OpenDrainPullUp)
                __DRV_GPIO_P4ModeSelect(WizGPIO_P45_MODE);
            #endif
            #if (WizGPIO_P45_FDC != NORMAL)
                __DRV_GPIO_SetP4FastDriving((WizGPIO_P45_FDC<<5),FAST);
            #endif
            #if (WizGPIO_P45_AF != WizDef_OCD)
                __DRV_GPIO_SetOCD2IO(MW_DISABLE);
                #message "The OCD function is disable."
            #endif
        #endif

        /*--------------P4_6-------------------*/
        #if WizGPIO_P46_EN
            #if (WizGPIO_P46_MODE != P46_InputOnly)
                __DRV_GPIO_P4ModeSelect(WizGPIO_P46_MODE);
            #endif
            #if (WizGPIO_P46_FDC != NORMAL)
                __DRV_GPIO_SetP4FastDriving((WizGPIO_P46_FDC<<6),FAST);
            #endif
        #endif
        /*--------------P4_7-------------------*/
        #if WizGPIO_P47_EN
            #if (WizGPIO_P47_MODE != P47_OpenDrainPullUp)
                __DRV_GPIO_P4ModeSelect(WizGPIO_P47_MODE);
            #endif
            #if (WizGPIO_P47_FDC != NORMAL)
                __DRV_GPIO_SetP4FastDriving((WizGPIO_P47_FDC<<7),FAST);
            #endif
            #if (WizGPIO_P47_AF != WizDef_RST)
                __DRV_GPIO_SetRST2IO(MW_DISABLE);
                #message "The RST function is disable."
            #endif
        #endif
        /*---------P4 Disable OCD & RST message ---------*/
        #if ((WizGPIO_P44_EN==1)&&(WizGPIO_P44_AF!=WizDef_OCD)&&\
             (WizGPIO_P45_EN==1)&&(WizGPIO_P45_AF!=WizDef_OCD)&&\
             (WizGPIO_P47_EN==1)&&(WizGPIO_P47_AF!=WizDef_RST))
                #message "If disable the OCD and RST function at the same time, user needs to use the U1 tool to enable OCD function."
        #endif
        /*---------P4 Driving Strength---------*/
        #if P4_DRIVEIN_STRENGTH
            #if (P4DC_0 != 0)
                __DRV_GPIO_P4OutputDrivingConfig(P4DC0,P4DC_0);
            #endif
            #if (P4DC_1 != 0)
                __DRV_GPIO_P4OutputDrivingConfig(P4DC1,P4DC_1);
            #endif
        #endif
    #endif

    /*--------------------Port 5---------------------*/
    #if WizGPIO_P5_EN
        /*--------------P5_0-------------------*/
        #if WizGPIO_P50_EN
            #if (WizGPIO_P50_MODE != P50_InputOnly)
                __DRV_GPIO_P5ModeSelect(WizGPIO_P50_MODE);
            #endif
            #if (WizGPIO_P50_FDC != NORMAL)
                __DRV_GPIO_SetP5FastDriving(WizGPIO_P50_FDC,FAST);
            #endif
        #endif
        /*--------------P5_1-------------------*/
        #if WizGPIO_P51_EN
            #if (WizGPIO_P51_MODE != P51_InputOnly)
                __DRV_GPIO_P5ModeSelect(WizGPIO_P51_MODE);
            #endif
            #if (WizGPIO_P51_FDC != NORMAL)
                __DRV_GPIO_SetP5FastDriving((WizGPIO_P51_FDC<<1),FAST);
            #endif
        #endif
        /*--------------P5_2-------------------*/
        #if WizGPIO_P52_EN
            #if (WizGPIO_P52_MODE != P52_InputOnly)
                __DRV_GPIO_P5ModeSelect(WizGPIO_P52_MODE);
            #endif
            #if (WizGPIO_P52_FDC != NORMAL)
                __DRV_GPIO_SetP5FastDriving((WizGPIO_P52_FDC<<2),FAST);
            #endif
        #endif
        /*--------------P5_3-------------------*/
        #if WizGPIO_P53_EN
            #if (WizGPIO_P53_MODE != P53_InputOnly)
                __DRV_GPIO_P5ModeSelect(WizGPIO_P53_MODE);
            #endif
            #if (WizGPIO_P53_FDC != NORMAL)
                __DRV_GPIO_SetP5FastDriving((WizGPIO_P53_FDC<<3),FAST);
            #endif
        #endif
        /*--------------P5_4-------------------*/
        #if WizGPIO_P54_EN
            #if (WizGPIO_P54_MODE != P54_InputOnly)
                __DRV_GPIO_P5ModeSelect(WizGPIO_P54_MODE);
            #endif
            #if (WizGPIO_P54_FDC != NORMAL)
                __DRV_GPIO_SetP5FastDriving((WizGPIO_P54_FDC<<4),FAST);
            #endif
        #endif
        /*--------------P5_5-------------------*/
        #if WizGPIO_P55_EN
            #if (WizGPIO_P55_MODE != P55_InputOnly)
                __DRV_GPIO_P5ModeSelect(WizGPIO_P55_MODE);
            #endif
            #if (WizGPIO_P55_FDC != NORMAL)
                __DRV_GPIO_SetP5FastDriving((WizGPIO_P55_FDC<<5),FAST);
            #endif
        #endif
        /*--------------P5_6-------------------*/
        #if WizGPIO_P56_EN
            #if (WizGPIO_P56_MODE != P56_InputOnly)
                __DRV_GPIO_P5ModeSelect(WizGPIO_P56_MODE);
            #endif
            #if (WizGPIO_P56_FDC != NORMAL)
                __DRV_GPIO_SetP5FastDriving((WizGPIO_P56_FDC<<6),FAST);
            #endif
        #endif
        /*--------------P5_7-------------------*/
        #if WizGPIO_P57_EN
            #if (WizGPIO_P57_MODE != P57_InputOnly)
                __DRV_GPIO_P5ModeSelect(WizGPIO_P57_MODE);
            #endif
            #if (WizGPIO_P57_FDC != NORMAL)
                __DRV_GPIO_SetP5FastDriving((WizGPIO_P57_FDC<<7),FAST);
            #endif
        #endif
        /*---------P5 Driving Strength---------*/
        #if P5_DRIVEIN_STRENGTH
            #if (P5DC_0 != 0)
                __DRV_GPIO_P5OutputDrivingConfig(P5DC0,P5DC_0);
            #endif
            #if (P5DC_1 != 0)
                __DRV_GPIO_P5OutputDrivingConfig(P5DC1,P5DC_1);
            #endif
        #endif
    #endif

    /*--------------------Port 6---------------------*/
    #if WizGPIO_P6_EN
        /*---------Port 6 Protection-----------*/
        #if MG82F6D64_GPIO_Port6_Protection
            #if (SPCON0_P6CTL != MW_DISABLE)
                __DRV_GPIO_P6_Protected(SPCON0_P6CTL);
            #endif
        #endif
        /*--------------P6_0-------------------*/
        #if WizGPIO_P60_EN
            #if (WizGPIO_P60_MODE != P60_InputOnly)
                __DRV_GPIO_P6ModeSelect(WizGPIO_P60_MODE);
            #endif
        #endif
        /*--------------P6_1-------------------*/
        #if WizGPIO_P61_EN
            #if (WizGPIO_P61_MODE != P61_InputOnly)
                __DRV_GPIO_P6ModeSelect(WizGPIO_P61_MODE);
            #endif
        #endif
        /*--------------P6_2-------------------*/
        #if WizGPIO_P62_EN
            #if (WizGPIO_P62_MODE != P62_InputOnly)
                __DRV_GPIO_P6ModeSelect(WizGPIO_P62_MODE);
            #endif
            #if (WizGPIO_P62_FDC != NORMAL)
                __DRV_GPIO_SetP6FastDriving((WizGPIO_P62_FDC<<2),FAST);
            #endif
        #endif
        /*--------------P6_3-------------------*/
        #if WizGPIO_P63_EN
            #if (WizGPIO_P63_MODE != P63_InputOnly)
                __DRV_GPIO_P6ModeSelect(WizGPIO_P63_MODE);
            #endif
            #if (WizGPIO_P63_FDC != NORMAL)
                __DRV_GPIO_SetP6FastDriving((WizGPIO_P63_FDC<<3),FAST);
            #endif
        #endif
        /*--------------P6_4-------------------*/
        #if WizGPIO_P64_EN
            #if (WizGPIO_P64_MODE != P64_InputOnly)
                __DRV_GPIO_P6ModeSelect(WizGPIO_P64_MODE);
            #endif
            #if (WizGPIO_P64_FDC != NORMAL)
                __DRV_GPIO_SetP6FastDriving((WizGPIO_P64_FDC<<4),FAST);
            #endif
        #endif
        /*--------------P6_5-------------------*/
        #if WizGPIO_P65_EN
            #if (WizGPIO_P65_MODE != P65_InputOnly)
                __DRV_GPIO_P6ModeSelect(WizGPIO_P65_MODE);
            #endif
            #if (WizGPIO_P65_FDC != NORMAL)
                __DRV_GPIO_SetP6FastDriving((WizGPIO_P65_FDC<<5),FAST);
            #endif
        #endif
        /*--------------P6_6-------------------*/
        #if WizGPIO_P66_EN
            #if (WizGPIO_P66_MODE != P66_InputOnly)
                __DRV_GPIO_P6ModeSelect(WizGPIO_P66_MODE);
            #endif
            #if (WizGPIO_P66_FDC != NORMAL)
                __DRV_GPIO_SetP6FastDriving((WizGPIO_P66_FDC<<6),FAST);
            #endif
        #endif
        /*--------------P6_7-------------------*/
        #if WizGPIO_P67_EN
            #if (WizGPIO_P67_MODE != P67_InputOnly)
                __DRV_GPIO_P6ModeSelect(WizGPIO_P67_MODE);
            #endif
            #if (WizGPIO_P67_FDC != NORMAL)
                __DRV_GPIO_SetP6FastDriving((WizGPIO_P67_FDC<<7),FAST);
            #endif
        #endif
        /*---------P6 Driving Strength---------*/
        #if P6_DRIVEIN_STRENGTH
            #if (P6DC_0 != 0)
                __DRV_GPIO_P6OutputDrivingConfig(P6DC0,P6DC_0);
            #endif
            #if (P6DC_1 != 0)
                __DRV_GPIO_P6OutputDrivingConfig(P6DC1,P6DC_1);
            #endif
        #endif
    #endif

    /*--------------------Port 7---------------------*/
    #if WizGPIO_P7_EN
        /*--------------P7_0-------------------*/
        #if WizGPIO_P70_EN
            #if (WizGPIO_P70_MODE != P70_InputOnly)
                __DRV_GPIO_P7ModeSelect(WizGPIO_P70_MODE);
            #endif
            #if (WizGPIO_P70_FDC != NORMAL)
                __DRV_GPIO_SetP7FastDriving(WizGPIO_P70_FDC,FAST);
            #endif
        #endif
        /*--------------P7_1-------------------*/
        #if WizGPIO_P71_EN
            #if (WizGPIO_P71_MODE != P71_InputOnly)
                __DRV_GPIO_P7ModeSelect(WizGPIO_P71_MODE);
            #endif
            #if (WizGPIO_P71_FDC != NORMAL)
                __DRV_GPIO_SetP7FastDriving((WizGPIO_P71_FDC<<1),FAST);
            #endif
        #endif
        /*--------------P7_2-------------------*/
        #if WizGPIO_P72_EN
            #if (WizGPIO_P72_MODE != P72_InputOnly)
                __DRV_GPIO_P7ModeSelect(WizGPIO_P72_MODE);
            #endif
            #if (WizGPIO_P72_FDC != NORMAL)
                __DRV_GPIO_SetP7FastDriving((WizGPIO_P72_FDC<<2),FAST);
            #endif
        #endif
        /*---------P7 Driving Strength---------*/
        #if P7_DRIVEIN_STRENGTH
            #if (P7DC_0 != 0)
                __DRV_GPIO_P7OutputDrivingConfig(P7DC0,P7DC_0);
            #endif
        #endif
    #endif

    //-------------------------------------------------
    // Reserve default function
    //-------------------------------------------------
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P44_EN==1)&&(WizGPIO_P44_AF==WizDef_BEEP))
        #message "P44 is programed as the BEEP function."
    #endif
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P45_EN==1)&&(WizGPIO_P45_AF==WizDef_RTCKO))
        #message "P45 is programed as the RTCKO function."
    #endif
    #if   ((WizGPIO_P6_EN==1)&&(WizGPIO_P60_EN==1)&&(WizGPIO_P60_AF==WizDef_ICKO))
        #message "P60 is programed as the ICKO function."
    #endif
    #if   ((WizGPIO_P6_EN==1)&&(WizGPIO_P60_EN==1)&&(WizGPIO_P60_AF==WizDef_ECKI))
        #message "P60 is programed as the ECKI function."
        #message "Must Config P60 as input mode"
    #endif
    #if   ((WizGPIO_P6_EN==1)&&(WizGPIO_P60_EN==1)&&(WizGPIO_P60_AF==WizDef_XTAL2))
        #message "P60 is programed as the XTAL2 function."
    #endif
    #if   ((WizGPIO_P6_EN==1)&&(WizGPIO_P61_EN==1)&&(WizGPIO_P61_AF==WizDef_XTAL1))
        #message "P61 is programed as the XTAL1 function."
    #endif
    //-------------------------------------------------
    #if   ((WizGPIO_P1_EN==1)&&(WizGPIO_P10_EN==1)&&(WizGPIO_P10_AF==WizDef_AIN0))
        #message "P10 is programed as the AIN0 function."
    #endif
    #if   ((WizGPIO_P1_EN==1)&&(WizGPIO_P11_EN==1)&&(WizGPIO_P11_AF==WizDef_AIN1))
        #message "P11 is programed as the AIN1 function."
    #endif
    #if   ((WizGPIO_P1_EN==1)&&(WizGPIO_P12_EN==1)&&(WizGPIO_P12_AF==WizDef_AIN2))
        #message "P12 is programed as the AIN2 function."
    #endif
    #if   ((WizGPIO_P1_EN==1)&&(WizGPIO_P13_EN==1)&&(WizGPIO_P13_AF==WizDef_AIN3))
        #message "P13 is programed as the AIN3 function."
    #endif
    #if   ((WizGPIO_P1_EN==1)&&(WizGPIO_P14_EN==1)&&(WizGPIO_P14_AF==WizDef_AIN4))
        #message "P14 is programed as the AIN4 function."
    #endif
    #if   ((WizGPIO_P1_EN==1)&&(WizGPIO_P15_EN==1)&&(WizGPIO_P15_AF==WizDef_AIN5))
        #message "P15 is programed as the AIN5 function."
    #endif
    #if   ((WizGPIO_P1_EN==1)&&(WizGPIO_P16_EN==1)&&(WizGPIO_P16_AF==WizDef_AIN6))
        #message "P16 is programed as the AIN6 function."
    #endif
    #if   ((WizGPIO_P1_EN==1)&&(WizGPIO_P17_EN==1)&&(WizGPIO_P17_AF==WizDef_AIN7))
        #message "P17 is programed as the AIN7 function."
    #endif
    #if   ((WizGPIO_P2_EN==1)&&(WizGPIO_P20_EN==1)&&(WizGPIO_P20_AF==WizDef_AIN8))
        #message "P20 is programed as the AIN8 function."
    #endif
    #if   ((WizGPIO_P2_EN==1)&&(WizGPIO_P21_EN==1)&&(WizGPIO_P21_AF==WizDef_AIN9))
        #message "P21 is programed as the AIN9 function."
    #endif
    #if   ((WizGPIO_P5_EN==1)&&(WizGPIO_P52_EN==1)&&(WizGPIO_P52_AF==WizDef_AIN10))
        #message "P52 is programed as the AIN10 function."
    #endif
    #if   ((WizGPIO_P5_EN==1)&&(WizGPIO_P53_EN==1)&&(WizGPIO_P53_AF==WizDef_AIN11))
        #message "P53 is programed as the AIN11 function."
    #endif
    #if   ((WizGPIO_P5_EN==1)&&(WizGPIO_P54_EN==1)&&(WizGPIO_P54_AF==WizDef_AIN12))
        #message "P54 is programed as the AIN12 function."
    #endif
    #if   ((WizGPIO_P5_EN==1)&&(WizGPIO_P55_EN==1)&&(WizGPIO_P55_AF==WizDef_AIN13))
        #message "P55 is programed as the AIN13 function."
    #endif
    #if   ((WizGPIO_P5_EN==1)&&(WizGPIO_P56_EN==1)&&(WizGPIO_P56_AF==WizDef_AIN14))
        #message "P56 is programed as the AIN14 function."
    #endif
    #if   ((WizGPIO_P5_EN==1)&&(WizGPIO_P51_EN==1)&&(WizGPIO_P51_AF==WizDef_AIN15))
        #message "P51 is programed as the AIN15 function."
    #endif
    //-------------------------------------------------
    #if   ((WizGPIO_P6_EN==1)&&(WizGPIO_P64_EN==1)&&(WizGPIO_P64_AF==WizDef_S2CKO))
        #message "P64 is programed as the S2CKO function."
    #endif
    #if   ((WizGPIO_P7_EN==1)&&(WizGPIO_P72_EN==1)&&(WizGPIO_P72_AF==WizDef_S3CKO))
        #message "P72 is programed as the S3CKO function."
    #endif
    //-------------------------------------------------
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P40_EN==1)&&(WizGPIO_P40_AF==WizDef_T0COA))
        #message "P40 is programed as the T0COA function."
    #endif
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P43_EN==1)&&(WizGPIO_P43_AF==WizDef_T0COB))
        #message "P43 is programed as the T0COB function."
    #endif
    //-------------------------------------------------
    #if   ((WizGPIO_P0_EN==1)&&(WizGPIO_P01_EN==1)&&(WizGPIO_P01_AF==WizDef_AC0NI))
        #message "P01 is programed as the AC0NI function."
    #endif
    #if   ((WizGPIO_P0_EN==1)&&(WizGPIO_P02_EN==1)&&(WizGPIO_P02_AF==WizDef_AC0PI0))
        #message "P02 is programed as the AC0PI0 function."
    #endif
    #if   ((WizGPIO_P0_EN==1)&&(WizGPIO_P03_EN==1)&&(WizGPIO_P03_AF==WizDef_AC0PI1))
        #message "P03 is programed as the AC0PI1 function."
    #endif
    #if   ((WizGPIO_P0_EN==1)&&(WizGPIO_P04_EN==1)&&(WizGPIO_P04_AF==WizDef_AC0PI2))
        #message "P04 is programed as the AC0PI2 function."
    #endif
    #if   ((WizGPIO_P0_EN==1)&&(WizGPIO_P05_EN==1)&&(WizGPIO_P05_AF==WizDef_AC0PI3))
        #message "P05 is programed as the AC0PI3 function."
    #endif
    #if   ((WizGPIO_P0_EN==1)&&(WizGPIO_P00_EN==1)&&(WizGPIO_P00_AF==WizDef_AC0OUT))
        #message "P00 is programed as the AC0OUT function."
    #endif
    //-------------------------------------------------
    #if   ((WizGPIO_P0_EN==1)&&(WizGPIO_P06_EN==1)&&(WizGPIO_P06_AF==WizDef_AC1NI))
        #message "P06 is programed as the AC1NI function."
    #endif
    #if   ((WizGPIO_P0_EN==1)&&(WizGPIO_P07_EN==1)&&(WizGPIO_P07_AF==WizDef_AC1PI))
        #message "P07 is programed as the AC1PI function."
    #endif
    #if   ((WizGPIO_P7_EN==1)&&(WizGPIO_P72_EN==1)&&(WizGPIO_P72_AF==WizDef_AC1OUT))
        #message "P72 is programed as the AC1OUT function."
    #endif
    //-------------------------------------------------
    #if   ((WizGPIO_P6_EN==1)&&(WizGPIO_P62_EN==1)&&(WizGPIO_P62_AF==WizDef_AC2NI))
        #message "P62 is programed as the AC2NI function."
    #endif
    #if   ((WizGPIO_P6_EN==1)&&(WizGPIO_P63_EN==1)&&(WizGPIO_P63_AF==WizDef_AC2PI))
        #message "P63 is programed as the AC2PI function."
    #endif
    #if   ((WizGPIO_P6_EN==1)&&(WizGPIO_P64_EN==1)&&(WizGPIO_P64_AF==WizDef_AC2OUT))
        #message "P64 is programed as the AC2OUT function."
    #endif


    //-------------------------------------------------
    // AUXRn, XCIFGn Function
    //-------------------------------------------------
    // --- T0/T0CKO ---
    #if   (((WizGPIO_P3_EN==1)&&(WizGPIO_P34_EN==1)&&(WizGPIO_P34_AF==WizDef_T0))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P34_EN==1)&&(WizGPIO_P34_AF==WizDef_T0CKO)))

        #message "P34 is programed as the T0/T0CKO function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P44_EN==1)&&(WizGPIO_P44_AF==WizDef_T0))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P44_EN==1)&&(WizGPIO_P44_AF==WizDef_T0CKO)))

        AUXR3 |= T0PS0;
        #message "T0/T0CKO default pin is changed : "
        #message "P44 is programed as the T0/T0CKO function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P46_EN==1)&&(WizGPIO_P46_AF==WizDef_T0))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P46_EN==1)&&(WizGPIO_P46_AF==WizDef_T0CKO)))

        AUXR3 |= T0PS1;
        #message "T0/T0CKO default pin is changed : "
        #message "P46 is programed as the T0/T0CKO function."

    #elif (((WizGPIO_P1_EN==1)&&(WizGPIO_P17_EN==1)&&(WizGPIO_P17_AF==WizDef_T0))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P17_EN==1)&&(WizGPIO_P17_AF==WizDef_T0CKO)))

        AUXR3 |= (T0PS1|T0PS0);
        #message "T0/T0CKO default pin is changed : "
        #message "P17 is programed as the T0/T0CKO function."

    #endif

    //-------------------------------------------------
    // --- Serial Port 0 pin Selection 0 ---
    #if   (((WizGPIO_P3_EN==1)&&(WizGPIO_P30_EN==1)&&(WizGPIO_P30_AF==WizDef_RXD0))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P31_EN==1)&&(WizGPIO_P31_AF==WizDef_TXD0)))

        #message "P30 is programed as the RXD0 function."
        #message "P31 is programed as the TXD0 function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P44_EN==1)&&(WizGPIO_P44_AF==WizDef_RXD0))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P45_EN==1)&&(WizGPIO_P45_AF==WizDef_TXD0)))

        SFRPI=AUXR3_Page; AUXR3 |= S0PS0;
        #message "RXD0, TXD0 default pin is changed : "
        #message "P44 is programed as the RXD0 function."
        #message "P45 is programed as the TXD0 function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P31_EN==1)&&(WizGPIO_P31_AF==WizDef_RXD0))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P30_EN==1)&&(WizGPIO_P30_AF==WizDef_TXD0)))

        SFRPI=AUXR10_Page; AUXR10 |= S0PS1;
        #message "RXD0, TXD0 default pin is changed : "
        #message "P31 is programed as the RXD0 function."
        #message "P30 is programed as the TXD0 function."

    #elif (((WizGPIO_P7_EN==1)&&(WizGPIO_P70_EN==1)&&(WizGPIO_P70_AF==WizDef_RXD0))||\
           ((WizGPIO_P7_EN==1)&&(WizGPIO_P71_EN==1)&&(WizGPIO_P71_AF==WizDef_TXD0)))

        SFRPI=AUXR3_Page; AUXR3 |= S0PS0;
        SFRPI=AUXR10_Page; AUXR10 |= S0PS1;
        #message "RXD0, TXD0 default pin is changed : "
        #message "P70 is programed as the RXD0 function."
        #message "P71 is programed as the TXD0 function."

    #endif

    //-------------------------------------------------
    // --- TWI0/I2C0 Port Selection [1:0] ---
    #if   (((WizGPIO_P4_EN==1)&&(WizGPIO_P40_EN==1)&&(WizGPIO_P40_AF==WizDef_TWI0_SCL))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P41_EN==1)&&(WizGPIO_P41_AF==WizDef_TWI0_SDA)))

        #message "P40 is programed as the TWI0_SCL function."
        #message "P41 is programed as the TWI0_SDA function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P60_EN==1)&&(WizGPIO_P60_AF==WizDef_TWI0_SCL))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P61_EN==1)&&(WizGPIO_P61_AF==WizDef_TWI0_SDA)))

        SFRPI=AUXR3_Page; AUXR3 |= TWIPS0;
        #message "TWI0 default pin is changed : "
        #message "P60 is programed as the TWI0_SCL function."
        #message "P61 is programed as the TWI0_SDA function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P31_EN==1)&&(WizGPIO_P31_AF==WizDef_TWI0_SCL))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P30_EN==1)&&(WizGPIO_P30_AF==WizDef_TWI0_SDA)))

        SFRPI=AUXR3_Page; AUXR3 |= TWIPS1;
        #message "TWI0 default pin is changed : "
        #message "P31 is programed as the TWI0_SCL function."
        #message "P30 is programed as the TWI0_SDA function."

    #elif (((WizGPIO_P2_EN==1)&&(WizGPIO_P25_EN==1)&&(WizGPIO_P25_AF==WizDef_TWI0_SCL))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P23_EN==1)&&(WizGPIO_P23_AF==WizDef_TWI0_SDA)))

        SFRPI=AUXR3_Page; AUXR3 |= (TWIPS1|TWIPS0);
        #message "TWI0 default pin is changed : "
        #message "P25 is programed as the TWI0_SCL function."
        #message "P23 is programed as the TWI0_SDA function."

    #endif

    //-------------------------------------------------
    // --- T2/T2CKO, T2EX ---
    #if   (((WizGPIO_P1_EN==1)&&(WizGPIO_P10_EN==1)&&(WizGPIO_P10_AF==WizDef_T2))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P10_EN==1)&&(WizGPIO_P10_AF==WizDef_T2CKO))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P11_EN==1)&&(WizGPIO_P11_AF==WizDef_T2EX)))

        #message "P10 is programed as the T2/T2CKO function."
        #message "P11 is programed as the T2EX function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P32_EN==1)&&(WizGPIO_P32_AF==WizDef_T2))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P32_EN==1)&&(WizGPIO_P32_AF==WizDef_T2CKO))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P33_EN==1)&&(WizGPIO_P33_AF==WizDef_T2EX)))

        SFRPI=AUXR4_Page; AUXR4 |= T2PS0;
        #message "T2/T2CKO, T2EX default pin is changed : "
        #message "P32 is programed as the T2/T2CKO function."
        #message "P30 is programed as the T2EX function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P67_EN==1)&&(WizGPIO_P67_AF==WizDef_T2))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P67_EN==1)&&(WizGPIO_P67_AF==WizDef_T2CKO))||\
           ((WizGPIO_P5_EN==1)&&(WizGPIO_P57_EN==1)&&(WizGPIO_P57_AF==WizDef_T2EX)))

        SFRPI=AUXR4_Page; AUXR4 |= T2PS1;
        #message "T2/T2CKO, T2EX default pin is changed : "
        #message "P67 is programed as the T2/T2CKO function."
        #message "P57 is programed as the T2EX function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P45_EN==1)&&(WizGPIO_P45_AF==WizDef_T2))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P45_EN==1)&&(WizGPIO_P45_AF==WizDef_T2CKO))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P44_EN==1)&&(WizGPIO_P44_AF==WizDef_T2EX)))

        SFRPI=AUXR4_Page; AUXR4 |= (T2PS1|T2PS0);
        #message "T2/T2CKO, T2EX default pin is changed : "
        #message "P45 is programed as the T2/T2CKO function."
        #message "P44 is programed as the T2EX function."

    #endif

    //-------------------------------------------------
    // --- T1/T1CKO ---
    #if   (((WizGPIO_P3_EN==1)&&(WizGPIO_P35_EN==1)&&(WizGPIO_P35_AF==WizDef_T1))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P35_EN==1)&&(WizGPIO_P35_AF==WizDef_T1CKO)))

        #message "P35 is programed as the T1/T1CKO function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P45_EN==1)&&(WizGPIO_P45_AF==WizDef_T1))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P45_EN==1)&&(WizGPIO_P45_AF==WizDef_T1CKO)))

        SFRPI=AUXR4_Page; AUXR4 |= T1PS0;
        #message "T1/T1CKO default pin is changed : "
        #message "P45 is programed as the T1/T1CKO function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_T1))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_T1CKO)))

        SFRPI=AUXR4_Page; AUXR4 |= T1PS1;
        #message "T1/T1CKO default pin is changed : "
        #message "P36 is programed as the T1/T1CKO function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_T1))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_T1CKO)))

        SFRPI=AUXR4_Page; AUXR4 |= (T1PS1|T1PS0);
        #message "T1/T1CKO default pin is changed : "
        #message "P37 is programed as the T1/T1CKO function."

    #endif

    //-------------------------------------------------
    // --- PWM2A, PWM2B ---
    #if   (((WizGPIO_P4_EN==1)&&(WizGPIO_P40_EN==1)&&(WizGPIO_P40_AF==WizDef_PWM2A))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P41_EN==1)&&(WizGPIO_P41_AF==WizDef_PWM2B)))

        #message "P40 is programed as the PWM2A function."
        #message "P41 is programed as the PWM2B function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P34_EN==1)&&(WizGPIO_P34_AF==WizDef_PWM2A))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P35_EN==1)&&(WizGPIO_P35_AF==WizDef_PWM2B)))

        SFRPI=AUXR5_Page; AUXR5 |= C0PPS1;
        #message "PWM2A, PWM2B default pin is changed : "
        #message "P34 is programed as the PWM2A function."
        #message "P35 is programed as the PWM2B function."

    #endif

    //-------------------------------------------------
    // --- PWM0A, PWM0B ---
    #if   (((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_PWM0A))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_PWM0B)))

        #message "P36 is programed as the PWM0A function."
        #message "P37 is programed as the PWM0B function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P60_EN==1)&&(WizGPIO_P60_AF==WizDef_PWM0A))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P61_EN==1)&&(WizGPIO_P61_AF==WizDef_PWM0B)))

        SFRPI=AUXR5_Page; AUXR5 |= C0PPS0;
        #message "PWM0A, PWM0B default pin is changed : "
        #message "P60 is programed as the PWM0A function."
        #message "P61 is programed as the PWM0B function."

    #endif

    //-------------------------------------------------
    // --- PCA0: CEX0, CEX2, CEX4 ---
    #if   (((WizGPIO_P2_EN==1)&&(WizGPIO_P22_EN==1)&&(WizGPIO_P22_AF==WizDef_PCA0_CEX0))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P24_EN==1)&&(WizGPIO_P24_AF==WizDef_PCA0_CEX2))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P26_EN==1)&&(WizGPIO_P26_AF==WizDef_PCA0_CEX4)))

        #message "P22 is programed as the PCA0_CEX0 function."
        #message "P24 is programed as the PCA0_CEX2 function."
        #message "P26 is programed as the PCA0_CEX4 function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P40_EN==1)&&(WizGPIO_P40_AF==WizDef_PCA0_CEX0))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P41_EN==1)&&(WizGPIO_P41_AF==WizDef_PCA0_CEX2))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P32_EN==1)&&(WizGPIO_P32_AF==WizDef_PCA0_CEX4)))

        SFRPI=AUXR5_Page; AUXR5 |= C0PS0;
        #message "PCA0(CEX0, CEX2, CEX4) default pin is changed : "
        #message "P40 is programed as the PCA0_CEX0 function."
        #message "P41 is programed as the PCA0_CEX2 function."
        #message "P32 is programed as the PCA0_CEX4 function."

    #endif

    //-------------------------------------------------
    // --- PCA0: CEX1, CEX3, CEX5 ---
    #if   (((WizGPIO_P2_EN==1)&&(WizGPIO_P23_EN==1)&&(WizGPIO_P23_AF==WizDef_PCA0_CEX1))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P25_EN==1)&&(WizGPIO_P25_AF==WizDef_PCA0_CEX3))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P27_EN==1)&&(WizGPIO_P27_AF==WizDef_PCA0_CEX5)))

        #message "P23 is programed as the PCA0_CEX1 function."
        #message "P25 is programed as the PCA0_CEX3 function."
        #message "P27 is programed as the PCA0_CEX5 function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P33_EN==1)&&(WizGPIO_P33_AF==WizDef_PCA0_CEX1))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P34_EN==1)&&(WizGPIO_P34_AF==WizDef_PCA0_CEX3))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P35_EN==1)&&(WizGPIO_P35_AF==WizDef_PCA0_CEX5)))

        SFRPI=AUXR5_Page; AUXR5 |= C0PS1;
        #message "PCA0(CEX1, CEX3, CEX5) default pin is changed : "
        #message "P33 is programed as the PCA0_CEX1 function."
        #message "P34 is programed as the PCA0_CEX3 function."
        #message "P35 is programed as the PCA0_CEX5 function."

    #endif

    //-------------------------------------------------
    // --- PCA0: ECI ---
    #if   ((WizGPIO_P2_EN==1)&&(WizGPIO_P21_EN==1)&&(WizGPIO_P21_AF==WizDef_PCA0_ECI))

        #message "P21 is programed as the PCA0_ECI function."

    #elif ((WizGPIO_P4_EN==1)&&(WizGPIO_P46_EN==1)&&(WizGPIO_P46_AF==WizDef_PCA0_ECI))

        SFRPI=AUXR5_Page; AUXR5 |= ECIPS0;
        #message "PCA0(ECI) default pin is changed : "
        #message "P46 is programed as the PCA0_ECI function."

    #endif

    //-------------------------------------------------
    // --- PCA0: C0CKO ---
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P47_EN==1)&&(WizGPIO_P47_AF==WizDef_PCA0_C0CKO))

        #message "P47 is programed as the PCA0_C0CKO function."

    #elif ((WizGPIO_P7_EN==1)&&(WizGPIO_P72_EN==1)&&(WizGPIO_P72_AF==WizDef_PCA0_C0CKO))

        SFRPI=AUXR5_Page; AUXR5 |= C0COPS;
        #message "PCA0(C0CKO) default pin is changed : "
        #message "P72 is programed as the PCA0_C0CKO function."

    #endif

    //-------------------------------------------------
    // --- KBI4, KBI5, KBI6, KBI7 ---
    #if   (((WizGPIO_P1_EN==1)&&(WizGPIO_P17_EN==1)&&(WizGPIO_P17_AF==WizDef_KBI7))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P16_EN==1)&&(WizGPIO_P16_AF==WizDef_KBI6))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P15_EN==1)&&(WizGPIO_P15_AF==WizDef_KBI5))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P14_EN==1)&&(WizGPIO_P14_AF==WizDef_KBI4)))

        #message "P17 is programed as the KBI7 function."
        #message "P16 is programed as the KBI6 function."
        #message "P15 is programed as the KBI5 function."
        #message "P14 is programed as the KBI4 function."

    #elif (((WizGPIO_P0_EN==1)&&(WizGPIO_P07_EN==1)&&(WizGPIO_P07_AF==WizDef_KBI7))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P06_EN==1)&&(WizGPIO_P06_AF==WizDef_KBI6))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P05_EN==1)&&(WizGPIO_P05_AF==WizDef_KBI5))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P04_EN==1)&&(WizGPIO_P04_AF==WizDef_KBI4)))

        SFRPI=AUXR6_Page; AUXR6 |= KBIHPS0;
        #message "KBI(4~7) default pin is changed : "
        #message "P07 is programed as the KBI7 function."
        #message "P06 is programed as the KBI6 function."
        #message "P05 is programed as the KBI5 function."
        #message "P04 is programed as the KBI4 function."

    #elif (((WizGPIO_P2_EN==1)&&(WizGPIO_P27_EN==1)&&(WizGPIO_P27_AF==WizDef_KBI7))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P26_EN==1)&&(WizGPIO_P26_AF==WizDef_KBI6))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P25_EN==1)&&(WizGPIO_P25_AF==WizDef_KBI5))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P24_EN==1)&&(WizGPIO_P24_AF==WizDef_KBI4)))

        SFRPI=AUXR6_Page; AUXR6 |= KBIHPS1;
        #message "KBI(4~7) default pin is changed : "
        #message "P27 is programed as the KBI7 function."
        #message "P26 is programed as the KBI6 function."
        #message "P25 is programed as the KBI5 function."
        #message "P24 is programed as the KBI4 function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P63_EN==1)&&(WizGPIO_P63_AF==WizDef_KBI7))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P62_EN==1)&&(WizGPIO_P62_AF==WizDef_KBI6))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P61_EN==1)&&(WizGPIO_P61_AF==WizDef_KBI5))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P60_EN==1)&&(WizGPIO_P60_AF==WizDef_KBI4)))

        SFRPI=AUXR6_Page; AUXR6 |= (KBIHPS1|KBIHPS0);
        #message "KBI(4~7) default pin is changed : "
        #message "P63 is programed as the KBI7 function."
        #message "P62 is programed as the KBI6 function."
        #message "P61 is programed as the KBI5 function."
        #message "P60 is programed as the KBI4 function."

    #endif

    //-------------------------------------------------
    // --- KBI0, KBI1, KBI2, KBI3 ---
    #if   (((WizGPIO_P1_EN==1)&&(WizGPIO_P13_EN==1)&&(WizGPIO_P13_AF==WizDef_KBI3))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P12_EN==1)&&(WizGPIO_P12_AF==WizDef_KBI2))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P11_EN==1)&&(WizGPIO_P11_AF==WizDef_KBI1))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P10_EN==1)&&(WizGPIO_P10_AF==WizDef_KBI0)))

        #message "P13 is programed as the KBI3 function."
        #message "P12 is programed as the KBI2 function."
        #message "P11 is programed as the KBI1 function."
        #message "P10 is programed as the KBI0 function."

    #elif (((WizGPIO_P0_EN==1)&&(WizGPIO_P03_EN==1)&&(WizGPIO_P03_AF==WizDef_KBI3))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P02_EN==1)&&(WizGPIO_P02_AF==WizDef_KBI2))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P01_EN==1)&&(WizGPIO_P01_AF==WizDef_KBI1))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P00_EN==1)&&(WizGPIO_P00_AF==WizDef_KBI0)))

        SFRPI=AUXR6_Page; AUXR6 |= KBILPS0;
        #message "KBI(0~3) default pin is changed : "
        #message "P03 is programed as the KBI3 function."
        #message "P02 is programed as the KBI2 function."
        #message "P01 is programed as the KBI1 function."
        #message "P00 is programed as the KBI0 function."

    #elif (((WizGPIO_P2_EN==1)&&(WizGPIO_P23_EN==1)&&(WizGPIO_P23_AF==WizDef_KBI3))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P22_EN==1)&&(WizGPIO_P22_AF==WizDef_KBI2))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P21_EN==1)&&(WizGPIO_P21_AF==WizDef_KBI1))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P20_EN==1)&&(WizGPIO_P20_AF==WizDef_KBI0)))

        SFRPI=AUXR6_Page; AUXR6 |= KBILPS1;
        #message "KBI(0~3) default pin is changed : "
        #message "P23 is programed as the KBI3 function."
        #message "P22 is programed as the KBI2 function."
        #message "P21 is programed as the KBI1 function."
        #message "P20 is programed as the KBI0 function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P43_EN==1)&&(WizGPIO_P43_AF==WizDef_KBI3))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P42_EN==1)&&(WizGPIO_P42_AF==WizDef_KBI2))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P41_EN==1)&&(WizGPIO_P41_AF==WizDef_KBI1))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P40_EN==1)&&(WizGPIO_P40_AF==WizDef_KBI0)))

        SFRPI=AUXR6_Page; AUXR6 |= (KBILPS1|KBILPS0);
        #message "KBI(0~3) default pin is changed : "
        #message "P43 is programed as the KBI3 function."
        #message "P42 is programed as the KBI2 function."
        #message "P41 is programed as the KBI1 function."
        #message "P40 is programed as the KBI0 function."

    #endif

    //-------------------------------------------------
    // --- S0MI, S1MI, S2MI, S3MI ---
    #if   (((WizGPIO_P6_EN==1)&&(WizGPIO_P62_EN==1)&&(WizGPIO_P62_AF==WizDef_S0MI))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P63_EN==1)&&(WizGPIO_P63_AF==WizDef_S1MI))||\
           ((WizGPIO_P7_EN==1)&&(WizGPIO_P70_EN==1)&&(WizGPIO_P70_AF==WizDef_S2MI))||\
           ((WizGPIO_P7_EN==1)&&(WizGPIO_P71_EN==1)&&(WizGPIO_P71_AF==WizDef_S3MI)))

        #message "P62 is programed as the S0MI function."
        #message "P63 is programed as the S1MI function."
        #message "P70 is programed as the S2MI function."
        #message "P71 is programed as the S3MI function."

    #elif (((WizGPIO_P5_EN==1)&&(WizGPIO_P57_EN==1)&&(WizGPIO_P57_AF==WizDef_S0MI))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P67_EN==1)&&(WizGPIO_P67_AF==WizDef_S1MI))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P66_EN==1)&&(WizGPIO_P66_AF==WizDef_S2MI))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P65_EN==1)&&(WizGPIO_P65_AF==WizDef_S3MI)))

        SFRPI=AUXR6_Page; AUXR6 |= SnMIPS;
        #message "SxMI default pin is changed : "
        #message "P57 is programed as the S0MI function."
        #message "P67 is programed as the S1MI function."
        #message "P66 is programed as the S2MI function."
        #message "P65 is programed as the S3MI function."

    #endif

    //-------------------------------------------------
    // --- S0CKO ---
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P47_EN==1)&&(WizGPIO_P47_AF==WizDef_S0CKO))

        #message "P47 is programed as the S0CKO function."

    #elif ((WizGPIO_P4_EN==1)&&(WizGPIO_P44_EN==1)&&(WizGPIO_P44_AF==WizDef_S0CKO))

        SFRPI=AUXR6_Page; AUXR6 |= S0COPS;
        #message "S0CKO default pin is changed : "
        #message "P44 is programed as the S0CKO function."

    #endif

    //-------------------------------------------------
    // --- BM1OUT ---
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P43_EN==1)&&(WizGPIO_P43_AF==WizDef_BM1OUT))

        SFRPI=AUXR7_Page; AUXR7 |= BM1OE0;
        #message "P43 is programed as the BM1OUT function."

    #elif ((WizGPIO_P3_EN==1)&&(WizGPIO_P31_EN==1)&&(WizGPIO_P31_AF==WizDef_BM1OUT))

        SFRPI=AUXR7_Page; AUXR7 |= BM1OE1;
        #message "P31 is programed as the BM1OUT function."

    #elif ((WizGPIO_P7_EN==1)&&(WizGPIO_P72_EN==1)&&(WizGPIO_P72_AF==WizDef_BM1OUT))

        SFRPI=AUXR7_Page; AUXR7 |= (BM1OE1|BM1OE0);
        #message "P72 is programed as the BM1OUT function."

    #endif

    //-------------------------------------------------
    // --- BM0OUT ---
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P42_EN==1)&&(WizGPIO_P42_AF==WizDef_BM0OUT))

        SFRPI=AUXR7_Page; AUXR7 |= BM0OE0;
        #message "P42 is programed as the BM0OUT function."

    #elif ((WizGPIO_P3_EN==1)&&(WizGPIO_P30_EN==1)&&(WizGPIO_P30_AF==WizDef_BM0OUT))

        SFRPI=AUXR7_Page; AUXR7 |= BM0OE1;
        #message "P30 is programed as the BM0OUT function."

    #elif ((WizGPIO_P5_EN==1)&&(WizGPIO_P50_EN==1)&&(WizGPIO_P50_AF==WizDef_BM0OUT))

        SFRPI=AUXR7_Page; AUXR7 |= (BM0OE1|BM0OE0);
        #message "P50 is programed as the BM0OUT function."

    #endif

    //-------------------------------------------------
    // --- PWM6, PWM7 ---
    #if   (((WizGPIO_P6_EN==1)&&(WizGPIO_P62_EN==1)&&(WizGPIO_P62_AF==WizDef_PWM6))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P63_EN==1)&&(WizGPIO_P63_AF==WizDef_PWM7)))

        #message "P62 is programed as the PWM6 function."
        #message "P63 is programed as the PWM7 function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P60_EN==1)&&(WizGPIO_P60_AF==WizDef_PWM6))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P61_EN==1)&&(WizGPIO_P61_AF==WizDef_PWM7)))

        SFRPI=AUXR8_Page; AUXR8 |= C0PPS2;
        #message "PWM6, PWM7 default pin is changed : "
        #message "P60 is programed as the PWM6 function."
        #message "P61 is programed as the PWM7 function."

    #endif

    //-------------------------------------------------
    // --- S1CKO ---
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P46_EN==1)&&(WizGPIO_P46_AF==WizDef_S1CKO))

        #message "P46 is programed as the S1CKO function."

    #elif ((WizGPIO_P4_EN==1)&&(WizGPIO_P45_EN==1)&&(WizGPIO_P45_AF==WizDef_S1CKO))

        SFRPI=AUXR8_Page; AUXR8 |= S1COPS;
        #message "S1CKO default pin is changed : "
        #message "P45 is programed as the S1CKO function."

    #endif

    //-------------------------------------------------
    // --- T3/T3CKO, T3EX ---
    #if   (((WizGPIO_P4_EN==1)&&(WizGPIO_P46_EN==1)&&(WizGPIO_P46_AF==WizDef_T3))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P46_EN==1)&&(WizGPIO_P46_AF==WizDef_T3CKO))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P00_EN==1)&&(WizGPIO_P00_AF==WizDef_T3EX)))

        #message "P46 is programed as the T3/T3CKO function."
        #message "P00 is programed as the T3EX function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P33_EN==1)&&(WizGPIO_P33_AF==WizDef_T3))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P33_EN==1)&&(WizGPIO_P33_AF==WizDef_T3CKO))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P32_EN==1)&&(WizGPIO_P32_AF==WizDef_T3EX)))

        SFRPI=AUXR8_Page; AUXR8 |= T3PS0;
        #message "T3/T3CKO, T3EX default pin is changed : "
        #message "P33 is programed as the T3/T3CKO function."
        #message "P32 is programed as the T3EX function."

    #elif (((WizGPIO_P2_EN==1)&&(WizGPIO_P21_EN==1)&&(WizGPIO_P21_AF==WizDef_T3))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P21_EN==1)&&(WizGPIO_P21_AF==WizDef_T3CKO))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P20_EN==1)&&(WizGPIO_P20_AF==WizDef_T3EX)))

        SFRPI=AUXR8_Page; AUXR8 |= T3PS1;
        #message "T3/T3CKO, T3EX default pin is changed : "
        #message "P21 is programed as the T3/T3CKO function."
        #message "P20 is programed as the T3EX function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P66_EN==1)&&(WizGPIO_P66_AF==WizDef_T3))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P66_EN==1)&&(WizGPIO_P66_AF==WizDef_T3CKO))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P65_EN==1)&&(WizGPIO_P65_AF==WizDef_T3EX)))

        SFRPI=AUXR8_Page; AUXR8 |= (T3PS1|T3PS0);
        #message "T3/T3CKO, T3EX default pin is changed : "
        #message "P66 is programed as the T3/T3CKO function."
        #message "P65 is programed as the T3EX function."

    #endif

    //-------------------------------------------------
    // --- RXD1, TXD1 ---
    #if   (((WizGPIO_P1_EN==1)&&(WizGPIO_P12_EN==1)&&(WizGPIO_P12_AF==WizDef_RXD1))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P13_EN==1)&&(WizGPIO_P13_AF==WizDef_TXD1)))

        #message "P12 is programed as the RXD1 function."
        #message "P13 is programed as the TXD1 function."

    #elif (((WizGPIO_P7_EN==1)&&(WizGPIO_P71_EN==1)&&(WizGPIO_P71_AF==WizDef_RXD1))||\
           ((WizGPIO_P7_EN==1)&&(WizGPIO_P70_EN==1)&&(WizGPIO_P70_AF==WizDef_TXD1)))

        SFRPI=AUXR9_Page; AUXR9 |= S1PS0;
        #message "RXD1, TXD1 default pin is changed : "
        #message "P71 is programed as the RXD1 function."
        #message "P70 is programed as the TXD1 function."

    #elif (((WizGPIO_P2_EN==1)&&(WizGPIO_P20_EN==1)&&(WizGPIO_P20_AF==WizDef_RXD1))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P21_EN==1)&&(WizGPIO_P21_AF==WizDef_TXD1)))

        SFRPI=AUXR9_Page; AUXR9 |= S1PS1;
        #message "RXD1, TXD1 default pin is changed : "
        #message "P20 is programed as the RXD1 function."
        #message "P21 is programed as the TXD1 function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P34_EN==1)&&(WizGPIO_P34_AF==WizDef_RXD1))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P35_EN==1)&&(WizGPIO_P35_AF==WizDef_TXD1)))

        SFRPI=AUXR9_Page; AUXR9 |= (S1PS1|S1PS0);
        #message "RXD1, TXD1 default pin is changed : "
        #message "P34 is programed as the RXD1 function."
        #message "P35 is programed as the TXD1 function."

    #endif

    //-------------------------------------------------
    // --- nSS, MOSI, MISO, SPICLK, SPID2, SPID3 ---
    #if   (((WizGPIO_P1_EN==1)&&(WizGPIO_P14_EN==1)&&(WizGPIO_P14_AF==WizDef_0_nSS))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P15_EN==1)&&(WizGPIO_P15_AF==WizDef_0_MOSI))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P16_EN==1)&&(WizGPIO_P16_AF==WizDef_0_MISO))||\
           ((WizGPIO_P1_EN==1)&&(WizGPIO_P17_EN==1)&&(WizGPIO_P17_AF==WizDef_0_SPICLK))||\
           ((WizGPIO_P5_EN==1)&&(WizGPIO_P53_EN==1)&&(WizGPIO_P53_AF==WizDef_0_SPID2))||\
           ((WizGPIO_P5_EN==1)&&(WizGPIO_P54_EN==1)&&(WizGPIO_P54_AF==WizDef_0_SPID3)))

        #message "P14 is programed as the nSS function."
        #message "P15 is programed as the MOSI(SPID0) function."
        #message "P16 is programed as the MISO(SPID1) function."
        #message "P17 is programed as the SPICLK function."
        #message "P53 is programed as the SPID2 function."
        #message "P54 is programed as the SPID3 function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P43_EN==1)&&(WizGPIO_P43_AF==WizDef_1_nSS))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P42_EN==1)&&(WizGPIO_P42_AF==WizDef_1_MOSI))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P41_EN==1)&&(WizGPIO_P41_AF==WizDef_1_MISO))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P40_EN==1)&&(WizGPIO_P40_AF==WizDef_1_SPICLK))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_1_SPID2))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_1_SPID3)))

        SFRPI=AUXR10_Page; AUXR10 |= SPIPS0;
        #message "SPI(nSS, MOSI, MISO, SPICLK, SPID2, SPID3) default pin is changed : "
        #message "P43 is programed as the nSS function."
        #message "P42 is programed as the MOSI(SPID0) function."
        #message "P41 is programed as the MISO(SPID1) function."
        #message "P40 is programed as the SPICLK function."
        #message "P36 is programed as the SPID2 function."
        #message "P37 is programed as the SPID3 function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P40_EN==1)&&(WizGPIO_P40_AF==WizDef_2_nSS))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P41_EN==1)&&(WizGPIO_P41_AF==WizDef_2_MOSI))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P42_EN==1)&&(WizGPIO_P42_AF==WizDef_2_MISO))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P43_EN==1)&&(WizGPIO_P43_AF==WizDef_2_SPICLK))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P65_EN==1)&&(WizGPIO_P65_AF==WizDef_2_SPID2))||\
           ((WizGPIO_P5_EN==1)&&(WizGPIO_P57_EN==1)&&(WizGPIO_P57_AF==WizDef_2_SPID3)))

        SFRPI=AUXR10_Page; AUXR10 |= SPIPS1;
        #message "SPI(nSS, MOSI, MISO, SPICLK, SPID2, SPID3) default pin is changed : "
        #message "P40 is programed as the nSS function."
        #message "P41 is programed as the MOSI(SPID0) function."
        #message "P42 is programed as the MISO(SPID1) function."
        #message "P43 is programed as the SPICLK function."
        #message "P65 is programed as the SPID2 function."
        #message "P57 is programed as the SPID3 function."

    #elif (((WizGPIO_P4_EN==1)&&(WizGPIO_P43_EN==1)&&(WizGPIO_P43_AF==WizDef_3_nSS))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P41_EN==1)&&(WizGPIO_P41_AF==WizDef_3_MOSI))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P42_EN==1)&&(WizGPIO_P42_AF==WizDef_3_MISO))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P40_EN==1)&&(WizGPIO_P40_AF==WizDef_3_SPICLK))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P65_EN==1)&&(WizGPIO_P65_AF==WizDef_3_SPID2))||\
           ((WizGPIO_P5_EN==1)&&(WizGPIO_P57_EN==1)&&(WizGPIO_P57_AF==WizDef_3_SPID3)))

        SFRPI=AUXR10_Page; AUXR10 |= (SPIPS1|SPIPS0);
        #message "SPI(nSS, MOSI, MISO, SPICLK, SPID2, SPID3) default pin is changed : "
        #message "P43 is programed as the nSS function."
        #message "P41 is programed as the MOSI(SPID0) function."
        #message "P42 is programed as the MISO(SPID1) function."
        #message "P40 is programed as the SPICLK function."
        #message "P65 is programed as the SPID2 function."
        #message "P57 is programed as the SPID3 function."
    #endif

    //-------------------------------------------------
    // --- TWI1_SCL, TWI1_SDA ---
    #if   (((WizGPIO_P4_EN==1)&&(WizGPIO_P42_EN==1)&&(WizGPIO_P42_AF==WizDef_TWI1_SCL))||\
           ((WizGPIO_P4_EN==1)&&(WizGPIO_P43_EN==1)&&(WizGPIO_P43_AF==WizDef_TWI1_SDA)))

        #message "P42 is programed as the TWI1_SCL function."
        #message "P43 is programed as the TWI1_SDA function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P60_EN==1)&&(WizGPIO_P60_AF==WizDef_TWI1_SCL))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P61_EN==1)&&(WizGPIO_P61_AF==WizDef_TWI1_SDA)))

        SFRPI=AUXR11_Page; AUXR11 |= I2C1PS0;
        #message "TWI1(SCL, SDA) default pin is changed : "
        #message "P60 is programed as the TWI1_SCL function."
        #message "P61 is programed as the TWI1_SDA function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P65_EN==1)&&(WizGPIO_P65_AF==WizDef_TWI1_SCL))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P66_EN==1)&&(WizGPIO_P66_AF==WizDef_TWI1_SDA)))

        SFRPI=AUXR11_Page; AUXR11 |= I2C1PS1;
        #message "TWI1(SCL, SDA) default pin is changed : "
        #message "P65 is programed as the TWI1_SCL function."
        #message "P66 is programed as the TWI1_SDA function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P63_EN==1)&&(WizGPIO_P63_AF==WizDef_TWI1_SCL))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P62_EN==1)&&(WizGPIO_P62_AF==WizDef_TWI1_SDA)))

        SFRPI=AUXR11_Page; AUXR11 |= (I2C1PS1|I2C1PS0);
        #message "TWI1(SCL, SDA) default pin is changed : "
        #message "P63 is programed as the TWI1_SCL function."
        #message "P62 is programed as the TWI1_SDA function."

    #endif

    //-------------------------------------------------
    // --- RXD3, TXD3 ---
    #if   (((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_RXD3))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_TXD3)))

        #message "P36 is programed as the RXD3 function."
        #message "P37 is programed as the TXD3 function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P65_EN==1)&&(WizGPIO_P65_AF==WizDef_RXD3))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P66_EN==1)&&(WizGPIO_P66_AF==WizDef_TXD3)))

        SFRPI=AUXR13_Page; AUXR13 |= S3PS0;
        #message "RXD3, TXD3 default pin is changed : "
        #message "P65 is programed as the RXD3 function."
        #message "P66 is programed as the TXD3 function."

    #endif

    //-------------------------------------------------
    // --- RXD2, TXD2 ---
    #if   (((WizGPIO_P3_EN==1)&&(WizGPIO_P32_EN==1)&&(WizGPIO_P32_AF==WizDef_RXD2))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P33_EN==1)&&(WizGPIO_P33_AF==WizDef_TXD2)))

        #message "P32 is programed as the RXD2 function."
        #message "P33 is programed as the TXD2 function."

    #elif (((WizGPIO_P6_EN==1)&&(WizGPIO_P67_EN==1)&&(WizGPIO_P67_AF==WizDef_RXD2))||\
           ((WizGPIO_P5_EN==1)&&(WizGPIO_P57_EN==1)&&(WizGPIO_P57_AF==WizDef_TXD2)))

        SFRPI=AUXR13_Page; AUXR13 |= S2PS0;
        #message "RXD2, TXD2 default pin is changed : "
        #message "P67 is programed as the RXD2 function."
        #message "P57 is programed as the TXD2 function."

    #endif

    //-------------------------------------------------
    // --- T4/T4CKO, T4EX ---
    #if   (((WizGPIO_P7_EN==1)&&(WizGPIO_P70_EN==1)&&(WizGPIO_P70_AF==WizDef_T4))||\
           ((WizGPIO_P7_EN==1)&&(WizGPIO_P70_EN==1)&&(WizGPIO_P70_AF==WizDef_T4CKO))||\
           ((WizGPIO_P7_EN==1)&&(WizGPIO_P71_EN==1)&&(WizGPIO_P71_AF==WizDef_T4EX)))

        #message "P70 is programed as the T4/T4CKO function."
        #message "P71 is programed as the T4EX function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_T4))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_T4CKO))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_T4EX)))

        SFRPI=AUXR13_Page; AUXR13 |= T4PS0;
        #message "T4/T4CKO, T4EX default pin is changed : "
        #message "P37 is programed as the T4/T4CKO function."
        #message "P36 is programed as the T4EX function."

    #elif (((WizGPIO_P7_EN==1)&&(WizGPIO_P72_EN==1)&&(WizGPIO_P72_AF==WizDef_T4))||\
           ((WizGPIO_P7_EN==1)&&(WizGPIO_P72_EN==1)&&(WizGPIO_P72_AF==WizDef_T4CKO))||\
           ((WizGPIO_P5_EN==1)&&(WizGPIO_P50_EN==1)&&(WizGPIO_P50_AF==WizDef_T4EX)))

        SFRPI=AUXR13_Page; AUXR13 |= T4PS1;
        #message "T4/T4CKO, T4EX default pin is changed : "
        #message "P72 is programed as the T4/T4CKO function."
        #message "P50 is programed as the T4EX function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_T4))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_T4CKO))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_T4EX)))

        SFRPI=AUXR13_Page; AUXR13 |= (T4PS1|T4PS0);
        #message "T4/T4CKO, T4EX default pin is changed : "
        #message "P36 is programed as the T4/T4CKO function."
        #message "P37 is programed as the T4EX function."

    #endif

    //-------------------------------------------------
    // --- AD[7:0] ---
    #if   (((WizGPIO_P0_EN==1)&&(WizGPIO_P07_EN==1)&&(WizGPIO_P07_AF==WizDef_EMB_AD7))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P06_EN==1)&&(WizGPIO_P06_AF==WizDef_EMB_AD6))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P05_EN==1)&&(WizGPIO_P05_AF==WizDef_EMB_AD5))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P04_EN==1)&&(WizGPIO_P04_AF==WizDef_EMB_AD4))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P03_EN==1)&&(WizGPIO_P03_AF==WizDef_EMB_AD3))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P02_EN==1)&&(WizGPIO_P02_AF==WizDef_EMB_AD2))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P01_EN==1)&&(WizGPIO_P01_AF==WizDef_EMB_AD1))||\
           ((WizGPIO_P0_EN==1)&&(WizGPIO_P00_EN==1)&&(WizGPIO_P00_AF==WizDef_EMB_AD0)))

        #message "AD(0~7) default pin is changed : "
        #message "P07 is programed as the AD7 function."
        #message "P06 is programed as the AD6 function."
        #message "P05 is programed as the AD5 function."
        #message "P04 is programed as the AD4 function."
        #message "P03 is programed as the AD3 function."
        #message "P02 is programed as the AD2 function."
        #message "P01 is programed as the AD1 function."
        #message "P00 is programed as the AD0 function."

    #elif (((WizGPIO_P2_EN==1)&&(WizGPIO_P27_EN==1)&&(WizGPIO_P27_AF==WizDef_EMB_AD7))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P26_EN==1)&&(WizGPIO_P26_AF==WizDef_EMB_AD6))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P25_EN==1)&&(WizGPIO_P25_AF==WizDef_EMB_AD5))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P24_EN==1)&&(WizGPIO_P24_AF==WizDef_EMB_AD4))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P23_EN==1)&&(WizGPIO_P23_AF==WizDef_EMB_AD3))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P22_EN==1)&&(WizGPIO_P22_AF==WizDef_EMB_AD2))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P21_EN==1)&&(WizGPIO_P21_AF==WizDef_EMB_AD1))||\
           ((WizGPIO_P2_EN==1)&&(WizGPIO_P20_EN==1)&&(WizGPIO_P20_AF==WizDef_EMB_AD0)))

        SFRPI=AUXR14_Page; AUXR14 |= ADLPS0;
        #message "AD(0~7) default pin is changed : "
        #message "P27 is programed as the AD7 function."
        #message "P26 is programed as the AD6 function."
        #message "P25 is programed as the AD5 function."
        #message "P24 is programed as the AD4 function."
        #message "P23 is programed as the AD3 function."
        #message "P22 is programed as the AD2 function."
        #message "P21 is programed as the AD1 function."
        #message "P20 is programed as the AD0 function."

    #elif (((WizGPIO_P7_EN==1)&&(WizGPIO_P72_EN==1)&&(WizGPIO_P72_AF==WizDef_EMB_AD7))||\
           ((WizGPIO_P7_EN==1)&&(WizGPIO_P71_EN==1)&&(WizGPIO_P71_AF==WizDef_EMB_AD6))||\
           ((WizGPIO_P7_EN==1)&&(WizGPIO_P70_EN==1)&&(WizGPIO_P70_AF==WizDef_EMB_AD5))||\
           ((WizGPIO_P5_EN==1)&&(WizGPIO_P57_EN==1)&&(WizGPIO_P57_AF==WizDef_EMB_AD4))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P67_EN==1)&&(WizGPIO_P67_AF==WizDef_EMB_AD3))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P66_EN==1)&&(WizGPIO_P66_AF==WizDef_EMB_AD2))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P65_EN==1)&&(WizGPIO_P65_AF==WizDef_EMB_AD1))||\
           ((WizGPIO_P6_EN==1)&&(WizGPIO_P64_EN==1)&&(WizGPIO_P64_AF==WizDef_EMB_AD0)))

        SFRPI=AUXR14_Page; AUXR14 |= ADLPS1;
        #message "AD(0~7) default pin is changed : "
        #message "P72 is programed as the AD7 function."
        #message "P71 is programed as the AD6 function."
        #message "P70 is programed as the AD5 function."
        #message "P57 is programed as the AD4 function."
        #message "P67 is programed as the AD3 function."
        #message "P66 is programed as the AD2 function."
        #message "P65 is programed as the AD1 function."
        #message "P64 is programed as the AD0 function."

    #endif

    //-------------------------------------------------
    // --- nWR, nRD ---
    #if   (((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_EMB_nWR))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_EMB_nRD)))

        #message "P36 is programed as the nWR function."
        #message "P37 is programed as the nRD function."

    #elif (((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_EMB_nWR))||\
           ((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_EMB_nRD)))

        SFRPI=AUXR14_Page; AUXR14 |= RWPS0;
        #message "nWR, nRD default pin is changed : "
        #message "P37 is programed as the nWR function."
        #message "P36 is programed as the nRD function."

    #endif

    //-------------------------------------------------
    // --- nINT1 ---
    #if   ((WizGPIO_P3_EN==1)&&(WizGPIO_P33_EN==1)&&(WizGPIO_P33_AF==WizDef_nINT1))

        #message "P33 is programed as the nINT1 function."

    #elif ((WizGPIO_P3_EN==1)&&(WizGPIO_P31_EN==1)&&(WizGPIO_P31_AF==WizDef_nINT1))

        SFRPI=XICFG_Page; XICFG |= INT1IS0;
        #message "nINT1 default pin is changed : "
        #message "P31 is programed as the nINT1 function."

    #elif ((WizGPIO_P3_EN==1)&&(WizGPIO_P35_EN==1)&&(WizGPIO_P35_AF==WizDef_nINT1))

        SFRPI=XICFG_Page; XICFG |= INT1IS1;
        #message "nINT1 default pin is changed : "
        #message "P35 is programed as the nINT1 function."

    #elif ((WizGPIO_P4_EN==1)&&(WizGPIO_P41_EN==1)&&(WizGPIO_P41_AF==WizDef_nINT1))

        SFRPI=XICFG_Page; XICFG |= (INT1IS1|INT1IS0);
        #message "nINT1 default pin is changed : "
        #message "P41 is programed as the nINT1 function."

    #elif ((WizGPIO_P4_EN==1)&&(WizGPIO_P45_EN==1)&&(WizGPIO_P45_AF==WizDef_nINT1))

        SFRPI=XICFG1_Page; XICFG1 |= INT1IS2;
        #message "nINT1 default pin is changed : "
        #message "P45 is programed as the nINT1 function."

    #elif ((WizGPIO_P1_EN==1)&&(WizGPIO_P15_EN==1)&&(WizGPIO_P15_AF==WizDef_nINT1))

        SFRPI=XICFG1_Page; XICFG1 |= INT1IS2;
        SFRPI=XICFG_Page; XICFG |= INT1IS0;
        #message "nINT1 default pin is changed : "
        #message "P15 is programed as the nINT1 function."

    #elif ((WizGPIO_P3_EN==1)&&(WizGPIO_P37_EN==1)&&(WizGPIO_P37_AF==WizDef_nINT1))

        SFRPI=XICFG1_Page; XICFG1 |= INT1IS2;
        SFRPI=XICFG_Page; XICFG |= INT1IS1;
        #message "nINT1 default pin is changed : "
        #message "P37 is programed as the nINT1 function."

    #elif ((WizGPIO_P0_EN==1)&&(WizGPIO_P07_EN==1)&&(WizGPIO_P07_AF==WizDef_nINT1))

        SFRPI=XICFG1_Page; XICFG1 |= INT1IS2;
        SFRPI=XICFG_Page; XICFG |= (INT1IS1|INT1IS0);
        #message "nINT1 default pin is changed : "
        #message "P07 is programed as the nINT1 function."

    #endif

    //-------------------------------------------------
    // --- nINT0 ---
    #if   ((WizGPIO_P3_EN==1)&&(WizGPIO_P32_EN==1)&&(WizGPIO_P32_AF==WizDef_nINT0))

        #message "P32 is programed as the nINT0 function."

    #elif ((WizGPIO_P3_EN==1)&&(WizGPIO_P30_EN==1)&&(WizGPIO_P30_AF==WizDef_nINT0))

        SFRPI=XICFG_Page; XICFG |= INT0IS0;
        #message "nINT0 default pin is changed : "
        #message "P30 is programed as the nINT0 function."

    #elif ((WizGPIO_P3_EN==1)&&(WizGPIO_P34_EN==1)&&(WizGPIO_P34_AF==WizDef_nINT0))

        SFRPI=XICFG_Page; XICFG |= INT0IS1;
        #message "nINT0 default pin is changed : "
        #message "P34 is programed as the nINT0 function."

    #elif ((WizGPIO_P4_EN==1)&&(WizGPIO_P40_EN==1)&&(WizGPIO_P40_AF==WizDef_nINT0))

        SFRPI=XICFG_Page; XICFG |= (INT0IS1|INT0IS0);
        #message "nINT0 default pin is changed : "
        #message "P40 is programed as the nINT0 function."

    #elif ((WizGPIO_P1_EN==1)&&(WizGPIO_P10_EN==1)&&(WizGPIO_P10_AF==WizDef_nINT0))

        SFRPI=XICFG1_Page; XICFG1 |= INT0IS2;
        #message "nINT0 default pin is changed : "
        #message "P10 is programed as the nINT0 function."

    #elif ((WizGPIO_P1_EN==1)&&(WizGPIO_P14_EN==1)&&(WizGPIO_P14_AF==WizDef_nINT0))

        SFRPI=XICFG1_Page; XICFG1 |= INT0IS2;
        SFRPI=XICFG_Page; XICFG |= INT0IS0;
        #message "nINT0 default pin is changed : "
        #message "P14 is programed as the nINT0 function."

    #elif ((WizGPIO_P3_EN==1)&&(WizGPIO_P36_EN==1)&&(WizGPIO_P36_AF==WizDef_nINT0))

        SFRPI=XICFG1_Page; XICFG1 |= INT0IS2;
        SFRPI=XICFG_Page; XICFG |= INT0IS1;
        #message "nINT0 default pin is changed : "
        #message "P36 is programed as the nINT0 function."

    #elif ((WizGPIO_P0_EN==1)&&(WizGPIO_P05_EN==1)&&(WizGPIO_P05_AF==WizDef_nINT0))

        SFRPI=XICFG1_Page; XICFG1 |= INT0IS2;
        SFRPI=XICFG_Page; XICFG |= (INT0IS1|INT0IS0);
        #message "nINT0 default pin is changed : "
        #message "P05 is programed as the nINT0 function."

    #endif

    //-------------------------------------------------
    // --- nINT2 ---
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P43_EN==1)&&(WizGPIO_P43_AF==WizDef_nINT2))

        #message "P43 is programed as the nINT2 function."

    #elif ((WizGPIO_P2_EN==1)&&(WizGPIO_P20_EN==1)&&(WizGPIO_P20_AF==WizDef_nINT2))

        SFRPI=XICFG1_Page; XICFG1 |= INT2IS0;
        #message "nINT2 default pin is changed : "
        #message "P20 is programed as the nINT2 function."

    #elif ((WizGPIO_P1_EN==1)&&(WizGPIO_P11_EN==1)&&(WizGPIO_P11_AF==WizDef_nINT2))

        SFRPI=XICFG1_Page; XICFG1 |= INT2IS1;
        #message "nINT2 default pin is changed : "
        #message "P11 is programed as the nINT2 function."

    #elif ((WizGPIO_P2_EN==1)&&(WizGPIO_P25_EN==1)&&(WizGPIO_P25_AF==WizDef_nINT2))

        SFRPI=XICFG1_Page; XICFG1 |= (INT2IS1|INT2IS0);
        #message "nINT2 default pin is changed : "
        #message "P25 is programed as the nINT2 function."

    #elif ((WizGPIO_P4_EN==1)&&(WizGPIO_P44_EN==1)&&(WizGPIO_P44_AF==WizDef_nINT2))

        SFRPI=XICFG2_Page; XICFG2 |= INT2IS2;
        #message "nINT2 default pin is changed : "
        #message "P44 is programed as the nINT2 function."

    #elif ((WizGPIO_P6_EN==1)&&(WizGPIO_P60_EN==1)&&(WizGPIO_P60_AF==WizDef_nINT2))

        SFRPI=XICFG2_Page; XICFG2 |= INT2IS2;
        SFRPI=XICFG1_Page; XICFG1 |= INT2IS0;
        #message "nINT2 default pin is changed : "
        #message "P60 is programed as the nINT2 function."

    #elif ((WizGPIO_P0_EN==1)&&(WizGPIO_P01_EN==1)&&(WizGPIO_P01_AF==WizDef_nINT2))

        SFRPI=XICFG2_Page; XICFG2 |= INT2IS2;
        SFRPI=XICFG1_Page; XICFG1 |= INT2IS1;
        #message "nINT2 default pin is changed : "
        #message "P01 is programed as the nINT2 function."

    #elif ((WizGPIO_P6_EN==1)&&(WizGPIO_P62_EN==1)&&(WizGPIO_P62_AF==WizDef_nINT2))

        SFRPI=XICFG2_Page; XICFG2 |= INT2IS2;
        SFRPI=XICFG1_Page; XICFG1 |= (INT2IS1|INT2IS0);
        #message "nINT2 default pin is changed : "
        #message "P62 is programed as the nINT2 function."

    #endif

    //-------------------------------------------------
    // --- nINT3 ---
    #if   ((WizGPIO_P4_EN==1)&&(WizGPIO_P42_EN==1)&&(WizGPIO_P42_AF==WizDef_nINT3))

        #message "P42 is programed as the nINT3 function."

    #elif ((WizGPIO_P2_EN==1)&&(WizGPIO_P21_EN==1)&&(WizGPIO_P21_AF==WizDef_nINT3))

        SFRPI=XICFG2_Page; XICFG2 |= INT3IS0;
        #message "nINT3 default pin is changed : "
        #message "P21 is programed as the nINT3 function."

    #elif ((WizGPIO_P0_EN==1)&&(WizGPIO_P00_EN==1)&&(WizGPIO_P00_AF==WizDef_nINT3))

        SFRPI=XICFG2_Page; XICFG2 |= INT3IS1;
        #message "nINT3 default pin is changed : "
        #message "P00 is programed as the nINT3 function."

    #elif ((WizGPIO_P1_EN==1)&&(WizGPIO_P16_EN==1)&&(WizGPIO_P16_AF==WizDef_nINT3))

        SFRPI=XICFG2_Page; XICFG2 |= (INT3IS1|INT3IS0);
        #message "nINT3 default pin is changed : "
        #message "P16 is programed as the nINT3 function."

    #elif ((WizGPIO_P0_EN==1)&&(WizGPIO_P02_EN==1)&&(WizGPIO_P02_AF==WizDef_nINT3))

        SFRPI=XICFG2_Page; XICFG2 |= INT3IS2;
        #message "nINT3 default pin is changed : "
        #message "P02 is programed as the nINT3 function."

    #elif ((WizGPIO_P6_EN==1)&&(WizGPIO_P61_EN==1)&&(WizGPIO_P61_AF==WizDef_nINT3))

        SFRPI=XICFG2_Page; XICFG2 |= (INT3IS2|INT3IS0);
        #message "nINT3 default pin is changed : "
        #message "P61 is programed as the nINT3 function."

    #elif ((WizGPIO_P0_EN==1)&&(WizGPIO_P06_EN==1)&&(WizGPIO_P06_AF==WizDef_nINT3))

        SFRPI=XICFG2_Page; XICFG2 |= (INT3IS2|INT3IS1);
        #message "nINT3 default pin is changed : "
        #message "P06 is programed as the nINT3 function."

    #elif ((WizGPIO_P6_EN==1)&&(WizGPIO_P63_EN==1)&&(WizGPIO_P63_AF==WizDef_nINT3))

        SFRPI=XICFG2_Page; XICFG2 |= (INT3IS2|INT3IS1|INT3IS0);
        #message "nINT3 default pin is changed : "
        #message "P63 is programed as the nINT3 function."

    #endif

    //-------------------------------------------------
    SFRPI=0;
}

/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
*******************************************************************************
* @brief       Initializing system clock by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
               DRV_CLK_Wizard_Init();
* @endcode
*******************************************************************************
*/


/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_CLK_WIZARD
/// @endcond
void DRV_CLK_Wizard_Init(void)
{
    #if (Wizard_SysClk_Select == 0x80020010)
        //Default Sysclk = Cpuclk = 12MHz

    #else

        //================================//
        // HSE HSE1   CPUCLK
        //  1   0       6MHz~25MHz (default)
        //  1   1       > 25MHz
        //  0   0       < 6MHz
        //================================//
        #if (Wizard_DCON0_HSEx == (FASTER_CPUCLK<<24))
            __DRV_CLK_CPUCLK_Range_Select(FASTER_CPUCLK);
        #endif

        //================================//
        // OSCin, default IHRCO
        // --- OSCin=IHRCO (default)
        // --- OSCin=XTAL
        //     > SFIE.MCDFIE (default enable=1)
        //     > SFIE.MCDRE (default enable=1)
        // --- OSCin=ILRCO
        // --- OSCin=ECKI (Set P6.0 in GPIO wizard menu)
        //================================//
        #if   (Wizard_OSCin_SEL == Wizard_OSCin_IH12M)
            //OSCin=IHRCO 12MHz (default)
        //--------------------------------//
        #elif (Wizard_OSCin_SEL == Wizard_OSCin_IH11M)
            CKCON0 |= AFS;
            IFD=255; while(IFD--);
        //--------------------------------//
        #elif (Wizard_OSCin_SEL == Wizard_OSCin_XT2M_25M)
            DRV_PageP_Write(CKCON2_P, (XTGS0_P|XTALE_P|IHRCOE_P));
            while (!(CKCON1 & XTOR));
            __DRV_CLK_OSCin_Select(OSCin_XTAL);
        //--------------------------------//
        #elif (Wizard_OSCin_SEL == Wizard_OSCin_XT32K)
            DRV_PageP_Write(CKCON2_P, (XTALE_P|IHRCOE_P));
            while (!(CKCON1 & XTOR));
            __DRV_CLK_OSCin_Select(OSCin_XTAL);
        //--------------------------------//
        #elif (Wizard_OSCin_SEL == Wizard_OSCin_XT32K_L)
            DRV_PageP_Write(CKCON2_P, (XTGS1_P|XTALE_P|IHRCOE_P));
            while (!(CKCON1 & XTOR));
            __DRV_CLK_OSCin_Select(OSCin_XTAL);
        //--------------------------------//
        #elif (Wizard_OSCin_SEL == Wizard_OSCin_IL32K)
            __DRV_CLK_OSCin_Select(OSCin_ILRCO);
        //--------------------------------//
        #elif (Wizard_OSCin_SEL == Wizard_OSCin_ECKI)
            //Set P60 open-drain mode and P60=1
            __DRV_GPIO_P6ModeSelect(P60_OpenDrain);
            __DRV_GPIO_WriteP6(P60,1);
            __DRV_CLK_OSCin_Select(OSCin_ECKI_P60);
        //--------------------------------//
        #else   //OSCin=IHRCO 12MHz (default)
        //--------------------------------//
        #endif  //Wizard_OSCin_SEL


        //--------------------------------//
        // --- OSCin=XTAL
        //     > SFIE.MCDFIE (default enable=1)
        //     > SFIE.MCDRE (default enable=1)
        //--------------------------------//
        #if ( (DRV_CLK_Wizard_Mode==2)\
            &&( (Wizard_OSCin_SEL==Wizard_OSCin_XT2M_25M)||\
                (Wizard_OSCin_SEL==Wizard_OSCin_XT32K)||\
                (Wizard_OSCin_SEL==Wizard_OSCin_XT32K_L) )\
            &&((DRV_CLK_Advanced_MCD&0x01)==0x01)\
            &&((DRV_CLK_Advanced_MCD&0x60)!=0x60) )
             SFIE &= ~(MCDRE|MCDFIE);
             SFIE |= (DRV_CLK_Advanced_MCD & (MCDRE|MCDFIE));
        #endif


        //================================//
        // CKM Control
        // En/Dis: CKCON0.ENCKM (default = 0)
        // input: CKCON0.CKMIS (default = 01)
        // mode: CKCON5.CKMS0 (default = 0)
        // >> next step: output: CKCON2.MCKS (default = 00)
        //================================//
        #if Wizard_CKCON0_ENCKM
            #if   (Wizard_CKCON0_CKMIS == 0)
                CKCON0 &= ~CKMIS0;
                CKCON0 |= (ENCKM|CKMIS1);
            #elif (Wizard_CKCON0_CKMIS == CKMIS0)
                //default CKMIS0=1
                CKCON0 |= ENCKM;
            #elif (Wizard_CKCON0_CKMIS == CKMIS1)
                CKCON0 &= ~CKMIS0;
                CKCON0 |= (ENCKM|CKMIS1);
            #elif (Wizard_CKCON0_CKMIS == (CKMIS1|CKMIS0))
                CKCON0 |= (ENCKM|CKMIS0|CKMIS1);
            #endif

            #if Wizard_CKCON5_CKMS0
                DRV_PageP_Write(CKCON5_P, CKMS0_P);
            #endif

            //----------------------------//
            // Delay 100us for stable
            // Note: Code size: lv0=99, lv8=89
            //----------------------------//
            IFD=255;  while(IFD--);  while(IFD--);  while(IFD--);  while(IFD--);
        #endif  //Wizard_CKCON0_ENCKM


        //================================//
        // Select MCKD
        // --- CKCON3.MCKD (default=00)
        // Select SYSCLK, CPUCLK
        // --- SYSCLK: CKCON0.[SCKS2,SCKS1,SCKS0] (default=000)
        // --- CPUCLK: CKCON0.CCKS (default=0)
        //================================//
        #if (Wizard_CKCON3_SEL != Wizard_CKCON3_Default)
            //DRV_PageP_Write(CKCON3_P, Wizard_CKCON3_P);
            DRV_PageP_Read (CKCON3_P);
            IFD |= Wizard_CKCON3_P;
            DRV_PageP_Write(CKCON3_P, IFD);
        #endif
        #if (Wizard_CKCON0_CLKSEL != 0)
            CKCON0 |= Wizard_CKCON0_CLKSEL;
        #endif


        //================================//
        // CKM Control
        // output: CKCON2.MCKS (default = 00)
        //================================//
        #if (Wizard_CKCON0_ENCKM && Wizard_CKCON2_MCKS)
            DRV_PageP_Read(CKCON2_P);
            IFD |= (Wizard_CKCON2_P & (MCKS1_P|MCKS0_P));
            DRV_PageP_Write(CKCON2_P, IFD);
        #endif  //Wizard_CKCON0_ENCKM


        //================================//
        // if OSCin!=IHRCO, disable IHRCOE
        //================================//
        #if   (Wizard_OSCin_SEL == Wizard_OSCin_IH12M)
        #elif (Wizard_OSCin_SEL == Wizard_OSCin_IH11M)
        //--------------------------------//
        #else
            //XTAL: Wizard_OSCin_XT2M_25M, Wizard_OSCin_XT32K, Wizard_OSCin_XT32K_L
            //ILRCO: Wizard_OSCin_IL32K
            //ECKI: Wizard_OSCin_ECKI
            __DRV_CLK_IHRCO_Disable();
        #endif  //Wizard_OSCin_SEL


        //================================//
        // DCON0_P : HSE_P, HSE1_P
        //================================//
        #if (Wizard_DCON0_HSEx == (SLOWER_CPUCLK<<24))
            __DRV_CLK_CPUCLK_Range_Select(SLOWER_CPUCLK);
        #endif

    #endif  //(Wizard_SysClk_Select == 0x80020010)


    //================================//
    // P60: GPIO or MCK output (default GPIO=00)
    // P60 Fast Driving Enable/Disable (default disable=0)
    //================================//
    #if (DRV_CLK_Wizard_AUXR0_SEL == 0x00)
        //Default P60=GPIO or ECKI
    #elif ((Wizard_OSCin_SEL == Wizard_OSCin_IH12M)||\
           (Wizard_OSCin_SEL == Wizard_OSCin_IH11M)||\
           (Wizard_OSCin_SEL == Wizard_OSCin_IL32K))
        //Set P60 ICKO and fast driving.
        AUXR0 |= (DRV_CLK_Wizard_AUXR0_SEL);
        #message "Need to config P60 as ICKO and push-pull/open-drain mode."
    #else
        //P60=ECKI or XTAL
        #warning "Warning: P60OC or P60FD function fail, pin already config as ECKI or XTAL."
    #endif

}   //DRV_CLK_Wizard_Init end

/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_CLK_WIZARD
/// @endcond


/**
*******************************************************************************
* @brief       Initializing EMB by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
                DRV_EMB_Wizard_Init();
* @endcode
*******************************************************************************
*/

/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_EMB_WIZARD
/// @endcond
void DRV_EMB_Wizard_Init(void)
{
    #if DRV_EMB_CommandPulse_Width_Select
        __DRV_EMB_CommandPulse_Width_Select(DRV_EMB_CommandPulse_Width_Select);
    #endif
    #if DRV_EMB_DataSetupHold_Time_Select
        __DRV_EMB_DataSetupHold_Time_Select(DRV_EMB_DataSetupHold_Time_Select);
    #endif
}

/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_EMB_WIZARD
/// @endcond


/**
*******************************************************************************
* @brief       Initializing DMA by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
                DRV_DMA_Wizard_Init();
* @endcode
*******************************************************************************
*/

/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_DMA_WIZARD
/// @endcond
void DRV_DMA_Wizard_Init(void)
{
    #if DRV_DMA_Souece_Select
        __DRV_DMA_Source_Select(DRV_DMA_Souece_Select);
    #endif
    #if DRV_DMA_Destination_Select
        __DRV_DMA_Destination_Select(DRV_DMA_Destination_Select);
    #endif
    #if DRV_DMA_External_TriggerSource_Select
        __DRV_DMA_ExternalTriggerSource_Select(DRV_DMA_External_TriggerSource_Select);
    #endif
    #if DRV_DMA_LoopMode_En
        __DRV_DMA_LoopMode_Select(DRV_DMA_LoopMode_En);
    #endif
    #if DRV_DMA_CRC16_Write_En
        __DRV_DMA_CRC16_Write_Enable();
    #endif

    #if DRV_DMA_Timer56_En
        #if (DRV_DMA_Timer56_Mode == 1)
            #if DRV_DMA_M2P_En
                __DRV_DMA_SetDataLength(DRV_DMA_XRAM_Data_Length);//XRAM Data Length by Timer5 Counter
                __DRV_DMA_SetXRAMAddressPointer(DRV_DMA_XRAM_Address_Pointer);//XRAM Address Pointer by Timer6 Counter
            #endif
        #elif (DRV_DMA_Timer56_Mode == 2)
            #if DRV_DMA_P2P_En
                __DRV_DMA_SetDataLength(DRV_DMA_Data_Length);//Data Length by Timer5 Counter
            #endif
        #else
            #if DRV_DMA_Timer_En
                #if DRV_DMA_Timer5_ClockSource_Config
                    __DRV_TIMER5_Clock_Source_Select(DRV_DMA_Timer5_ClockSource_Config);
                #endif
                #if DRV_DMA_Timer5_GatingSource_Config
                    __DRV_TIMER5_Gating_Source_Select(DRV_DMA_Timer5_GatingSource_Config);
                #endif
                __DRV_TIMER5_Set16BitCounter(DRV_DMA_Timer5_Current_Value);
                __DRV_TIMER5_Set16Bit_AutoReloadValue(DRV_DMA_Timer5_Base_Reload_Value);
                #if DRV_DMA_Timer5_TR5_En
                    __DRV_TIMER5_Run_Cmd(MW_ENABLE);
                #endif

                #if DRV_DMA_Timer6_ClockSource_Config
                    __DRV_TIMER6_Clock_Source_Select(DRV_DMA_Timer6_ClockSource_Config);
                #endif
                #if DRV_DMA_Timer6_GatingSource_Config
                    __DRV_TIMER6_Gating_Source_Select(DRV_DMA_Timer6_GatingSource_Config);
                #endif
                __DRV_TIMER6_Set16BitCounter(DRV_DMA_Timer6_Current_Value);
                __DRV_TIMER6_Set16Bit_AutoReloadValue(DRV_DMA_Timer6_Base_Reload_Value);
                #if DRV_DMA_Timer6_TR6_En
                    __DRV_TIMER6_Run_Cmd(MW_ENABLE);
                #endif
            #endif
        #endif
    #endif

    __DRV_DMA_Enable();

    #if DRV_DMA_Start_En
        __DRV_DMA_SetTransferStart();
    #endif
}

/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_DMA_WIZARD
/// @endcond


/**
*******************************************************************************
* @brief       WDT Wizard Initialization.
* @details     Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
               DRV_WDT_Wizard_Init();
* @endcode
*******************************************************************************
*/

/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_WDT_WIZARD
/// @endcond
void DRV_WDT_Wizard_Init(void)
{
    #if (CKCON3_WDTCS != 0)
        __DRV_WDT_ClockSource_Select(CKCON3_WDTCS);
    #endif

    __DRV_WDT_NonStopped_Cmd(WDTCR_NSW);

    __DRV_WDT_IdleControl_Cmd(WDTCR_WIDL);

    #if (CKCON3_WDTFS != 0)
        __DRV_WDT_Overflow_Select(CKCON3_WDTFS);
    #endif

    __DRV_WDT_SetPrescaler(PreScaler);

    __DRV_WDT_Reset_Cmd(WDTCR_WREN);

    __DRV_WDT_Cmd(WDTCR_ENW);
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
*******************************************************************************
* @brief       RTC Wizard Initialization.
* @details     Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
               DRV_RTC_Wizard_Init();
* @endcode
*******************************************************************************
*/
/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_RTC_WIZARD
/// @endcond
void DRV_RTC_Wizard_Init(void)
{
    #if (CKCON4_RCSS != 0)
        __DRV_RTC_ClockSource_Select(CKCON4_RCSS);
    #endif
    #if (CKCON4_RTCCS != 1)
        __DRV_RTC_SetPrescaler(CKCON4_RTCCS);
    #endif
    #if (RTCTM_RTCCT != 0)
        __DRV_RTC_SetCounterValue(RTCTM_RTCCT);
    #endif
    #if (RTCCR_RTCRL != 63)
        __DRV_RTC_SetReloaderValue(RTCCR_RTCRL);
    #endif
    #if (RTCCR_RTCO != 0)
        __DRV_RTC_SetRTCKO(RTCCR_RTCO);
    #endif
    #if (RTCCR_RTCE != 0)
        __DRV_RTC_Cmd(RTCCR_RTCE);
    #endif
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/**
 *******************************************************************************
 * @brief       Initializing BODx by wizard option.
 * @details
 * @return      None
 * @note
 * @par Example
 * @code
 *              DRV_PW_BODx_Wizard_Init();
 * @endcode
 *******************************************************************************
 */
/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_PW_WIZARD
/// @endcond

void DRV_PW_BODx_Wizard_Init(void)
{
    #if (MG82F6D64_BODx_BOD0==1)
        #if (PCON2_BO0RE != MW_DISABLE)
            __DRV_BODx_SetBOD0RST_Cmd(PCON2_BO0RE);
        #endif
    #endif

    #if (MG82F6D64_BODx_BOD1==1)
        #if (PCON2_BO1RE != MW_DISABLE)
            __DRV_BODx_SetBOD1RST_Cmd(PCON2_BO1RE);
        #endif

        #if (PCON2_BO1S != BOD1_VoltageLevel_4V2)
            __DRV_BODx_BOD1_MonitoredLevelSelect(PCON2_BO1S);
        #endif

        #if (PCON2_AWBOD1 != MW_DISABLE)
            __DRV_BODx_BOD1_AwakeBOD1inPD(PCON2_AWBOD1);
        #endif

        #if (PCON2_EBOD1 != MW_ENABLE)
            __DRV_BODx_BOD1_MonitorsVDD(PCON2_EBOD1);
        #endif
    #endif
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif
/// @endcond


/// @cond
#if MG82F6D64_TIMER_WIZARD
/// @endcond

/**
*******************************************************************************
* @brief       TIMER Wizard Initial.
* @details     Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
               DRV_TIMER_Wizard_Init();
* @endcode
*******************************************************************************
*/
void DRV_TIMER_Wizard_Init(void)
{
    /*---------Timer0---------*/
    #if(TM0_Wizard_init_EN)
        /*---------Timer0 Mode0---------*/
        #if(TM0_Wizard_Mode==0x00 && TIMER0_Mode0_8Bit_PWM)
            __DRV_TIMER0_Mode_Select(TM0_Wizard_Mode);
            #if(TIMER0_Mode0_Clock_Source!=TIMER0_CLOCK_SOURCE_SYSCLK_DIV_12)
                __DRV_TIMER0_Clock_Source_Select(TIMER0_Mode0_Clock_Source);
            #endif
            #if(TIMER0_Mode0_Gating_Source!=TIMER0_GATING_SOURCE_DISABLE)
                __DRV_TIMER0_Gating_Source_Select(TIMER0_Mode0_Gating_Source);
            #endif
            #if(TIMER0_Mode0_TH0!=0)
                __DRV_TIMER0_SetHighByte(TIMER0_Mode0_TH0);
            #endif
            #if(TIMER0_Mode0_TL0!=0)
                __DRV_TIMER0_SetLowByte(TIMER0_Mode0_TL0);
            #endif
            #if(TIMER0_Mode0_Clock_Output_Enable!=0)
                __DRV_TIMER0_T0CKO_Cmd(TIMER0_Mode0_Clock_Output_Enable);
            #endif
            #if(TIMER0_Mode0_TR0!=0)
                __DRV_TIMER0_Run_Cmd(TIMER0_Mode0_TR0);
            #endif
        #endif
        /*---------Timer0 Mode1---------*/
        #if(TM0_Wizard_Mode==0x01 && TIMER0_Mode1_16Bit_Timer_Counter)
            __DRV_TIMER0_Mode_Select(TM0_Wizard_Mode);
            #if(TIMER0_Mode1_Clock_Source!=TIMER0_CLOCK_SOURCE_SYSCLK_DIV_12)
                __DRV_TIMER0_Clock_Source_Select(TIMER0_Mode1_Clock_Source);
            #endif
            #if(TIMER0_Mode1_Gating_Source!=TIMER0_GATING_SOURCE_DISABLE)
                __DRV_TIMER0_Gating_Source_Select(TIMER0_Mode1_Gating_Source);
            #endif
            #if(TIMER0_Mode1_16Bits_Counter_Value!=0)
                __DRV_TIMER0_Set16BitCounter(TIMER0_Mode1_16Bits_Counter_Value);
            #endif
            #if(TIMER0_Mode1_Clock_Output_Enable!=0)
                __DRV_TIMER0_T0CKO_Cmd(TIMER0_Mode1_Clock_Output_Enable);
            #endif
            #if(TIMER0_Mode1_TR0!=0)
                __DRV_TIMER0_Run_Cmd(TIMER0_Mode1_TR0);
            #endif
        #endif
        /*---------Timer0 Mode2---------*/
        #if(TM0_Wizard_Mode==0x02 && TIMER0_Mode2_8Bit_Timer_Counter_Auto_Reload)
            __DRV_TIMER0_Mode_Select(TM0_Wizard_Mode);
            #if(TIMER0_Mode2_Clock_Source!=TIMER0_CLOCK_SOURCE_SYSCLK_DIV_12)
                __DRV_TIMER0_Clock_Source_Select(TIMER0_Mode2_Clock_Source);
            #endif
            #if(TIMER0_Mode2_Gating_Source!=TIMER0_GATING_SOURCE_DISABLE)
                __DRV_TIMER0_Gating_Source_Select(TIMER0_Mode2_Gating_Source);
            #endif
            #if(TIMER0_Mode2_TL0!=0)
                __DRV_TIMER0_SetLowByte(TIMER0_Mode2_TL0);
            #endif
            #if(TIMER0_Mode2_Timer_Reload!=0)
                __DRV_TIMER0_SetHighByte(TIMER0_Mode2_Timer_Reload);
            #endif
            #if(TIMER0_Mode2_Clock_Output_Enable!=0)
                __DRV_TIMER0_T0CKO_Cmd(TIMER0_Mode2_Clock_Output_Enable);
            #endif
            #if(TIMER0_Mode2_TR0!=0)
                __DRV_TIMER0_Run_Cmd(TIMER0_Mode2_TR0);
            #endif
        #endif
        /*---------Timer0 Mode3---------*/
        #if(TM0_Wizard_Mode==0x03 && TIMER0_Mode3_Two_Separate_Timer_Counter)
            __DRV_TIMER0_Mode_Select(TM0_Wizard_Mode);
            #if(TIMER0_Mode3_Clock_Source!=TIMER0_CLOCK_SOURCE_SYSCLK_DIV_12)
                __DRV_TIMER0_Clock_Source_Select(TIMER0_Mode3_Clock_Source);
            #endif
            #if(TIMER0_Mode3_Gating_Source!=TIMER0_GATING_SOURCE_DISABLE)
                __DRV_TIMER0_Gating_Source_Select(TIMER0_Mode3_Gating_Source);
            #endif
            #if(TIMER0_Mode3_TH0!=0)
                __DRV_TIMER0_SetHighByte(TIMER0_Mode3_TH0);
            #endif
            #if(TIMER0_Mode3_TL0!=0)
                __DRV_TIMER0_SetLowByte(TIMER0_Mode3_TL0);
            #endif
            #if(TIMER0_Mode3_T0CKO_Clock_Output_Enable!=0)
                __DRV_TIMER0_T0CKO_Cmd(TIMER0_Mode3_T0CKO_Clock_Output_Enable);
            #endif
            #if(TIMER0_Mode3_TR1_Run!=0)
                __DRV_TIMER1_Run_Cmd(TIMER0_Mode3_TR1_Run);
            #endif
            #if(TIMER0_Mode3_TR0_Run!=0)
                __DRV_TIMER0_Run_Cmd(TIMER0_Mode3_TR0_Run);
            #endif
        #endif
    #endif
	/*---------Timer1---------*/
	#if(TM1_Wizard_init_EN)
		/*---------Timer1 Mode0---------*/
		#if(TIMER1_Mode==0x00&&TIMER1_Mode0_8Bit_PWM)
			__DRV_TIMER1_Mode_Select(TIMER1_Mode);
			#if(TIMER1_Mode0_Clock_Source!=TIMER1_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER1_Clock_Source_Select(TIMER1_Mode0_Clock_Source);
			#endif
			#if(TIMER1_Mode0_Gating_Source!=TIMER0_GATING_SOURCE_DISABLE)
				__DRV_TIMER1_Gating_Source_Select(TIMER1_Mode0_Gating_Source);
			#endif
			#if(TIMER1_Mode0_TH1!=0)
				__DRV_TIMER1_SetHighByte(TIMER1_Mode0_TH1);
			#endif
			#if(TIMER1_Mode0_TL1!=0)
				__DRV_TIMER1_SetLowByte(TIMER1_Mode0_TL1);
			#endif
			#if(TIMER1_Mode0_Clock_Output_Enable!=0)
				__DRV_TIMER1_T1CKO_Cmd(TIMER1_Mode0_Clock_Output_Enable);
			#endif
			#if(TIMER1_Mode0_TR1_Run!=0)
				__DRV_TIMER1_Run_Cmd(TIMER1_Mode0_TR1_Run);
			#endif
		#endif

		/*---------Timer1 Mode1---------*/
		#if(TIMER1_Mode==0x01&&TIMER1_Mode1_16Bit_Timer_Counter)
			__DRV_TIMER1_Mode_Select(TIMER1_Mode);
			#if(TIMER1_Mode1_Clock_Source!=TIMER1_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER1_Clock_Source_Select(TIMER1_Mode1_Clock_Source);
			#endif
			#if(TIMER1_Mode1_Gating_Source!=TIMER1_GATING_SOURCE_DISABLE)
				__DRV_TIMER1_Gating_Source_Select(TIMER1_Mode1_Gating_Source);
			#endif
			#if(TIMER1_Mode1_16Bits_Counter_Value!=0)
				__DRV_TIMER1_Set16BitCounter(TIMER1_Mode1_16Bits_Counter_Value);
			#endif
			#if(TIMER1_Mode1_Clock_Output_Enable!=0)
				__DRV_TIMER1_T1CKO_Cmd(TIMER1_Mode1_Clock_Output_Enable);
			#endif
			#if(TIMER1_Mode1_TR1_Run!=0)
				__DRV_TIMER1_Run_Cmd(TIMER1_Mode1_TR1_Run);
			#endif
		#endif
		/*---------Timer1 Mode2---------*/
		#if(TIMER1_Mode==0x02&&TIMER1_Mode2_8Bit_Timer_Counter_Auto_Reload)
			__DRV_TIMER1_Mode_Select(TIMER1_Mode);
			#if(TIMER1_Mode2_Clock_Source!=TIMER1_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER1_Clock_Source_Select(TIMER1_Mode2_Clock_Source);
			#endif
			#if(TIMER1_Mode2_Gating_Source!=TIMER1_GATING_SOURCE_DISABLE)
				__DRV_TIMER1_Gating_Source_Select(TIMER1_Mode2_Gating_Source);
			#endif
			#if(TIMER1_Mode2_TL1!=0)
				__DRV_TIMER1_SetLowByte(TIMER1_Mode2_TL1);
			#endif
            #if(TIMER1_Mode2_Timer_Reload!=0)
                __DRV_TIMER1_SetHighByte(TIMER1_Mode2_Timer_Reload);
            #endif
			#if(TIMER1_Mode2_Clock_Output_Enable!=0)
				__DRV_TIMER1_T1CKO_Cmd(TIMER1_Mode2_Clock_Output_Enable);
			#endif
			#if(TIMER1_Mode2_TR1_Run!=0)
				__DRV_TIMER1_Run_Cmd(TIMER1_Mode2_TR1_Run);
			#endif
		#endif
	#endif

	/*---------Timer2---------*/
	#if(TM2_Wizard_init_EN)
		/*---------Timer2 Mode0---------*/
		#if(TIMER2_Mode==0x00&&TIMER2_Mode0_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Mode0_Clock_Source!=TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_Clock_Source_Select(TIMER2_Mode0_Clock_Source);
			#endif
			#if(TIMER2_Mode0_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Mode0_Capture_Source);
			#endif
			#if(TIMER2_Mode0_Clock_Output_Enable!=0)
				__DRV_TIMER2_Clock_Out_Cmd(TIMER2_Mode0_Clock_Output_Enable);
			#endif
			#if(TIMER2_Mode0_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Mode0_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Mode0_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Mode0_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Mode0_16Bits_Counter_Value!=0)
				__DRV_TIMER2_Set16BitCounter(TIMER2_Mode0_16Bits_Counter_Value);
			#endif
			#if(TIMER2_Mode0_16Bits_Reload_Value!=0)
				__DRV_TIMER2_Set16Bit_AutoReloadValue(TIMER2_Mode0_16Bits_Reload_Value);
			#endif
			#if(TIMER2_Mode0_16Bit_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Mode0_16Bit_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Mode1---------*/
		#if(TIMER2_Mode==0x01&&TIMER2_Mode1_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Mode1_Clock_Source!=TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_Clock_Source_Select(TIMER2_Mode1_Clock_Source);
			#endif
			#if(TIMER2_Mode1_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Mode1_Capture_Source);
			#endif
			#if(TIMER2_Mode1_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Mode1_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Mode1_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Mode1_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Mode1_16Bits_Counter_Value!=0)
				__DRV_TIMER2_Set16BitCounter(TIMER2_Mode1_16Bits_Counter_Value);
			#endif
			#if(TIMER2_Mode1_16Bits_Reload_Value!=0)
				__DRV_TIMER2_Set16Bit_AutoReloadValue(TIMER2_Mode1_16Bits_Reload_Value);
			#endif
			#if(TIMER2_Mode1_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Mode1_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Mode2---------*/
		#if(TIMER2_Mode==0x02&&TIMER2_Mode2_16Bit_Timer_Counter_Capture)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Mode2_Clock_Source!=TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_Clock_Source_Select(TIMER2_Mode2_Clock_Source);
			#endif
			#if(TIMER2_Mode2_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Mode2_Capture_Source);
			#endif
			#if(TIMER2_Mode2_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Mode2_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Mode2_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Mode2_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Mode2_16Bits_Counter_Value!=0)
				__DRV_TIMER2_Set16BitCounter(TIMER2_Mode2_16Bits_Counter_Value);
			#endif
			#if(TIMER2_Mode2_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Mode2_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Mode3---------*/
		#if(TIMER2_Mode==0x03&&TIMER2_Mode3_16Bit_Timer_Counter_Capture_With_Auto_Zero)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Mode3_Clock_Source!=TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_Clock_Source_Select(TIMER2_Mode3_Clock_Source);
			#endif
			#if(TIMER2_Mode3_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Mode3_Capture_Source);
			#endif
			#if(TIMER2_Mode3_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Mode3_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Mode3_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Mode3_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Mode3_16Bits_Counter_Value!=0)
				__DRV_TIMER2_Set16BitCounter(TIMER2_Mode3_16Bits_Counter_Value);
			#endif
			#if(TIMER2_Mode3_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Mode3_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Mode6---------*/
		#if(TIMER2_Mode==0x09&&TIMER2_Mode6_Duty_Capture)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Mode6_Clock_Source!=TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_Clock_Source_Select(TIMER2_Mode6_Clock_Source);
			#endif
			#if(TIMER2_Mode6_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Mode6_Capture_Source);
			#endif
			#if(TIMER2_Mode6_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Mode6_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Mode6_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Mode6_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Mode6_16Bits_Counter_Value!=0)
				__DRV_TIMER2_Set16BitCounter(TIMER2_Mode6_16Bits_Counter_Value);
			#endif
			#if(TIMER2_Mode6_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Mode6_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Split Mode0---------*/
		#if(TIMER2_Mode==0x04&&TIMER2_Split_Mode0_Two_8Bit_Timer_Counter_Auto_Reload_and_External_Interrupt)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Split_Mode0_TH2_Clock_Source!=TIMER2_TH2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TH2_Clock_Source_Select(TIMER2_Split_Mode0_TH2_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode0_TL2_Clock_Source!=TIMER2_TL2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Mode0_TL2_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode0_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode0_Capture_Source);
			#endif
			#if(TIMER2_Split_Mode0_Clock_Output_Enable!=0)
				__DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode0_Clock_Output_Enable);
			#endif
			#if(TIMER2_Split_Mode0_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode0_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Split_Mode0_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode0_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Split_Mode0_TH2!=0)
				__DRV_TIMER2_SetHighByte(TIMER2_Split_Mode0_TH2);
			#endif
			#if(TIMER2_Split_Mode0_RCAP2H!=0)
				__DRV_TIMER2_SetRCAP2H(TIMER2_Split_Mode0_RCAP2H);
			#endif
			#if(TIMER2_Split_Mode0_TL2!=0)
				__DRV_TIMER2_SetLowByte(TIMER2_Split_Mode0_TL2);
			#endif
			#if(TIMER2_Split_Mode0_RCAP2L!=0)
				__DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode0_RCAP2L);
			#endif
			#if(TIMER2_Split_Mode0_TL2LC!=0)
				__DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Mode0_TL2LC);
			#endif
			#if(TIMER2_Split_Mode0_TR2L_Run!=0)
				__DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Mode0_TR2L_Run);
			#endif
			#if(TIMER2_Split_Mode0_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode0_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Split Mode1---------*/
		#if(TIMER2_Mode==0x05&&TIMER2_Split_Mode1_Two_8Bit_Timer_Counter_Auto_Reload_With_External_Interrupt)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Split_Mode1_TH2_Clock_Source!=TIMER2_TH2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TH2_Clock_Source_Select(TIMER2_Split_Mode1_TH2_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode1_TL2_Clock_Source!=TIMER2_TL2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Mode1_TL2_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode1_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode1_Capture_Source);
			#endif
			#if(TIMER2_Split_Mode1_Clock_Output_Enable!=0)
				__DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode1_Clock_Output_Enable);
			#endif
			#if(TIMER2_Split_Mode1_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode1_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Split_Mode1_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode1_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Split_Mode1_TH2!=0)
				__DRV_TIMER2_SetHighByte(TIMER2_Split_Mode1_TH2);
			#endif
			#if(TIMER2_Split_Mode1_RCAP2H!=0)
				__DRV_TIMER2_SetRCAP2H(TIMER2_Split_Mode1_RCAP2H);
			#endif
			#if(TIMER2_Split_Mode1_TL2!=0)
				__DRV_TIMER2_SetLowByte(TIMER2_Split_Mode1_TL2);
			#endif
			#if(TIMER2_Split_Mode1_RCAP2L!=0)
				__DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode1_RCAP2L);
			#endif
			#if(TIMER2_Split_Mode1_TR2LC!=0)
				__DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Mode1_TR2LC);
			#endif
			#if(TIMER2_Split_Mode1_TR2L_Run!=0)
				__DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Mode1_TR2L_Run);
			#endif
			#if(TIMER2_Split_Mode1_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode1_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Split Mode2---------*/
		#if(TIMER2_Mode==0x06&&TIMER2_Split_Mode2_Two_8Bit_Timer_Counter_Capture)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Split_Mode2_TH2_Clock_Source!=TIMER2_TH2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TH2_Clock_Source_Select(TIMER2_Split_Mode2_TH2_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode2_TL2_Clock_Source!=TIMER2_TL2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Mode2_TL2_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode2_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode2_Capture_Source);
			#endif
			#if(TIMER2_Split_Mode2_Clock_Output_Enable!=0)
				__DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode2_Clock_Output_Enable);
			#endif
			#if(TIMER2_Split_Mode2_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode2_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Split_Mode2_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode2_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Split_Mode2_TH2!=0)
				__DRV_TIMER2_SetHighByte(TIMER2_Split_Mode2_TH2);
			#endif
			#if(TIMER2_Split_Mode2_TL2!=0)
				__DRV_TIMER2_SetLowByte(TIMER2_Split_Mode2_TL2);
			#endif
			#if(TIMER2_Split_Mode2_RCAP2L!=0)
				__DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode2_RCAP2L);
			#endif
			#if(TIMER2_Split_Mode2_TR2LC!=0)
				__DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Mode2_TR2LC);
			#endif
			#if(TIMER2_Split_Mode2_TR2L_Run!=0)
				__DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Mode2_TR2L_Run);
			#endif
			#if(TIMER2_Split_Mode2_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode2_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Split Mode3---------*/
		#if(TIMER2_Mode==0x07&&TIMER2_Split_Mode3_Two_8Bit_Timer_Counter_Capture_with_auto_zero)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Split_Mode3_TH2_Clock_Source!=TIMER2_TH2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TH2_Clock_Source_Select(TIMER2_Split_Mode3_TH2_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode3_TL2_Clock_Source!=TIMER2_TL2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Mode3_TL2_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode3_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode3_Capture_Source);
			#endif
			#if(TIMER2_Split_Mode3_Clock_Output_Enable!=0)
				__DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode3_Clock_Output_Enable);
			#endif
			#if(TIMER2_Split_Mode3_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode3_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Split_Mode3_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode3_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Split_Mode3_TH2!=0)
				__DRV_TIMER2_SetHighByte(TIMER2_Split_Mode3_TH2);
			#endif
			#if(TIMER2_Split_Mode3_TL2!=0)
				__DRV_TIMER2_SetLowByte(TIMER2_Split_Mode3_TL2);
			#endif
			#if(TIMER2_Split_Mode3_RCAP2L!=0)
				__DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode3_RCAP2L);
			#endif
			#if(TIMER2_Split_Mode3_TR2LC!=0)
				__DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Mode3_TR2LC);
			#endif
			#if(TIMER2_Split_Mode3_TR2L_Run!=0)
				__DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Mode3_TR2L_Run);
			#endif
			#if(TIMER2_Split_Mode3_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode3_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Split Mode4---------*/
		#if(TIMER2_Mode==0x08&&TIMER2_Split_Mode4_8Bit_Pwm)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Split_Mode4_Clock_Source!=TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_Clock_Source_Select(TIMER2_Split_Mode4_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode4_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode4_Capture_Source);
			#endif
			#if(TIMER2_Split_Mode4_Clock_Output_Enable!=0)
				__DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode4_Clock_Output_Enable);
			#endif
			#if(TIMER2_Split_Mode4_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode4_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Split_Mode4_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode4_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Split_Mode4_TH2!=0)
				__DRV_TIMER2_SetHighByte(TIMER2_Split_Mode4_TH2);
			#endif
			#if(TIMER2_Split_Mode4_RCAP2H!=0)
				__DRV_TIMER2_SetRCAP2H(TIMER2_Split_Mode4_RCAP2H);
			#endif
			#if(TIMER2_Split_Mode4_TL2!=0)
				__DRV_TIMER2_SetLowByte(TIMER2_Split_Mode4_TL2);
			#endif
			#if(TIMER2_Split_Mode4_RCAP2L!=0)
				__DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode4_RCAP2L);
			#endif
			#if(TIMER2_Split_Mode4_T2CKO_Invert!=0)
				__DRV_TIMER2_T2CKO_Invert_Cmd(TIMER2_Split_Mode4_T2CKO_Invert);
			#endif
			#if(TIMER2_Split_Mode4_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode4_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Split Mode6---------*/
		#if(TIMER2_Mode==0x0A&&TIMER2_Split_Mode6_Duty_Capture)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Split_Mode6_Clock_Source!=TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_Clock_Source_Select(TIMER2_Split_Mode6_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode6_TL2_Clock_Source!=TIMER2_TL2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Mode6_TL2_Clock_Source);
			#endif
			#if(TIMER2_Split_Mode6_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Mode6_Capture_Source);
			#endif
			#if(TIMER2_Split_Mode6_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Mode6_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Split_Mode6_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Mode6_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Split_Mode6_TH2!=0)
				__DRV_TIMER2_SetHighByte(TIMER2_Split_Mode6_TH2);
			#endif
			#if(TIMER2_Split_Mode6_TL2!=0)
				__DRV_TIMER2_SetLowByte(TIMER2_Split_Mode6_TL2);
			#endif
			#if(TIMER2_Split_Mode6_RCAP2L!=0)
				__DRV_TIMER2_SetRCAP2L(TIMER2_Split_Mode6_RCAP2L);
			#endif
			#if(TIMER2_Split_Mode6_Clock_Output_Enable!=0)
				__DRV_TIMER2_Clock_Out_Cmd(TIMER2_Split_Mode6_Clock_Output_Enable);
			#endif
			#if(TIMER2_Split_Mode6_TR2LC!=0)
				__DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Mode6_TR2LC);
			#endif
			#if(TIMER2_Split_Mode6_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Split_Mode6_TR2_Run);
			#endif
			#if(TIMER2_Split_Mode6_TR2L_Run!=0)
				__DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Mode6_TR2L_Run);
			#endif
		#endif
		/*---------Timer2 Baud-Rate Generator---------*/
		#if(TIMER2_Mode==0x0B&&TIMER2_Baud_Rate_Generator)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Baud_Rate_Generator_Clock_Source!=TIMER2_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_Clock_Source_Select(TIMER2_Baud_Rate_Generator_Clock_Source);
			#endif
			#if(TIMER2_Baud_Rate_Generator_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Baud_Rate_Generator_Capture_Source);
			#endif
			#if(TIMER2_Baud_Rate_Generator_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Baud_Rate_Generator_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Baud_Rate_Generator_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Baud_Rate_Generator_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Baud_Rate_Generator_16Bits_Counter_Value!=0)
				__DRV_TIMER2_Set16BitCounter(TIMER2_Baud_Rate_Generator_16Bits_Counter_Value);
			#endif
			#if(TIMER2_Baud_Rate_Generator_Reload_Value!=0)
				__DRV_TIMER2_Set16Bit_AutoReloadValue(TIMER2_Baud_Rate_Generator_Reload_Value);
			#endif
			#if(TIMER2_Baud_Rate_Generator_16Bit_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Baud_Rate_Generator_16Bit_TR2_Run);
			#endif
		#endif
		/*---------Timer2 Split Baud-Rate Generator---------*/
		#if(TIMER2_Mode==0x0C&&TIMER2_Split_Baud_Rate_Generator)
			__DRV_TIMER2_Mode_Select(TIMER2_Mode);
			#if(TIMER2_Split_Baud_Rate_Generator_TH2_Clock_Source!=TIMER2_TH2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TH2_Clock_Source_Select(TIMER2_Split_Baud_Rate_Generator_TH2_Clock_Source);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_TL2_Clock_Source!=TIMER2_TL2_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER2_TL2_Clock_Source_Select(TIMER2_Split_Baud_Rate_Generator_TL2_Clock_Source);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_Capture_Source!=TIMER2_CAPTURE_SOURCE_T2EX_PIN)
				__DRV_TIMER2_Capture_Source_Select(TIMER2_Split_Baud_Rate_Generator_Capture_Source);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_Overflow_Flag_Ignored!=0)
				__DRV_TIMER2_TF2_Interrupt_Ignored_Cmd(TIMER2_Split_Baud_Rate_Generator_Overflow_Flag_Ignored);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_Capture_Source_Dectect_Edge!=Timer2_IGNORED)
				__DRV_TIMER2_Capture_Source_Dectect(TIMER2_Split_Baud_Rate_Generator_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_TH2!=0)
				__DRV_TIMER2_SetHighByte(TIMER2_Split_Baud_Rate_Generator_TH2);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_RCAP2H!=0)
				__DRV_TIMER2_SetRCAP2H(TIMER2_Split_Baud_Rate_Generator_RCAP2H);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_TL2!=0)
				__DRV_TIMER2_SetLowByte(TIMER2_Split_Baud_Rate_Generator_TL2);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_RCAP2L!=0)
				__DRV_TIMER2_SetRCAP2L(TIMER2_Split_Baud_Rate_Generator_RCAP2L);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_TR2L_Run!=0)
				__DRV_TIMER2_TL2_Run_Cmd(TIMER2_Split_Baud_Rate_Generator_TR2L_Run);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_TR2_Run!=0)
				__DRV_TIMER2_Run_Cmd(TIMER2_Split_Baud_Rate_Generator_TR2_Run);
			#endif
			#if(TIMER2_Split_Baud_Rate_Generator_TL2LC!=0)
				__DRV_TIMER2_TR2L_Clear_Cmd(TIMER2_Split_Baud_Rate_Generator_TL2LC);
			#endif
		#endif
	#endif

	/*---------Timer3---------*/
	#if(TM3_Wizard_init_EN)
		/*---------Timer3 Mode0---------*/
		#if(TIMER3_Mode==0x00&&TIMER3_Mode0_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Mode0_Clock_Source!=TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_Clock_Source_Select(TIMER3_Mode0_Clock_Source);
			#endif
			#if(TIMER3_Mode0_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Mode0_Capture_Source);
			#endif
			#if(TIMER3_Mode0_Clock_Output_Enable!=0)
				__DRV_TIMER3_Clock_Out_Cmd(TIMER3_Mode0_Clock_Output_Enable);
			#endif
			#if(TIMER3_Mode0_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Mode0_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Mode0_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Mode0_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Mode0_16Bits_Counter_Value!=0)
				__DRV_TIMER3_Set16BitCounter(TIMER3_Mode0_16Bits_Counter_Value);
			#endif
			#if(TIMER3_Mode0_16Bits_Reload_Value!=0)
				__DRV_TIMER3_Set16Bit_AutoReloadValue(TIMER3_Mode0_16Bits_Reload_Value);
			#endif
			#if(TIMER3_Mode0_16Bit_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Mode0_16Bit_TR3_Run);
			#endif
		#endif
		/*---------Timer3 Mode1---------*/
		#if(TIMER3_Mode==0x01&&TIMER3_Mode1_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Mode1_Clock_Source!=TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_Clock_Source_Select(TIMER3_Mode1_Clock_Source);
			#endif
			#if(TIMER3_Mode1_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Mode1_Capture_Source);
			#endif
			#if(TIMER3_Mode1_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Mode1_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Mode1_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Mode1_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Mode1_16Bits_Counter_Value!=0)
				__DRV_TIMER3_Set16BitCounter(TIMER3_Mode1_16Bits_Counter_Value);
			#endif
			#if(TIMER3_Mode1_16Bits_Reload_Value!=0)
				__DRV_TIMER3_Set16Bit_AutoReloadValue(TIMER3_Mode1_16Bits_Reload_Value);
			#endif
			#if(TIMER3_Mode1_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Mode1_TR3_Run);
			#endif
		#endif
		/*---------Timer3 Mode2---------*/
		#if(TIMER3_Mode==0x02&&TIMER3_Mode2_16Bit_Timer_Counter_Capture)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Mode2_Clock_Source!=TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_Clock_Source_Select(TIMER3_Mode2_Clock_Source);
			#endif
			#if(TIMER3_Mode2_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Mode2_Capture_Source);
			#endif
			#if(TIMER3_Mode2_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Mode2_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Mode2_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Mode2_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Mode2_16Bits_Counter_Value!=0)
				__DRV_TIMER3_Set16BitCounter(TIMER3_Mode2_16Bits_Counter_Value);
			#endif
			#if(TIMER3_Mode2_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Mode2_TR3_Run);
			#endif
		#endif
		/*---------Timer3 Mode3---------*/
		#if(TIMER3_Mode==0x03&&TIMER3_Mode3_16Bit_Timer_Counter_Capture_With_Auto_Zero)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Mode3_Clock_Source!=TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_Clock_Source_Select(TIMER3_Mode3_Clock_Source);
			#endif
			#if(TIMER3_Mode3_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Mode3_Capture_Source);
			#endif
			#if(TIMER3_Mode3_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Mode3_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Mode3_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Mode3_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Mode3_16Bits_Counter_Value!=0)
				__DRV_TIMER3_Set16BitCounter(TIMER3_Mode3_16Bits_Counter_Value);
			#endif
			#if(TIMER3_Mode3_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Mode3_TR3_Run);
			#endif
		#endif
		/*---------Timer3 Mode6---------*/
		#if(TIMER3_Mode==0x09&&TIMER3_Mode6_Duty_Capture)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Mode6_Clock_Source!=TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_Clock_Source_Select(TIMER3_Mode6_Clock_Source);
			#endif
			#if(TIMER3_Mode6_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Mode6_Capture_Source);
			#endif
			#if(TIMER3_Mode6_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Mode6_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Mode6_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Mode6_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Mode6_16Bits_Counter_Value!=0)
				__DRV_TIMER3_Set16BitCounter(TIMER3_Mode6_16Bits_Counter_Value);
			#endif
			#if(TIMER3_Mode6_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Mode6_TR3_Run);
			#endif
		#endif
		/*---------Timer3 Split Mode0---------*/
		#if(TIMER3_Mode==0x04&&TIMER3_Split_Mode0_Two_8Bit_Timer_Counter_Auto_Reload_and_External_Interrupt)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Split_Mode0_TH3_Clock_Source!=TIMER3_TH3_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_TH3_Clock_Source_Select(TIMER3_Split_Mode0_TH3_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode0_TL3_Clock_Source!=TIMER3_TL3_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_TL3_Clock_Source_Select(TIMER3_Split_Mode0_TL3_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode0_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode0_Capture_Source);
			#endif
			#if(TIMER3_Split_Mode0_Clock_Output_Enable!=0)
				__DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode0_Clock_Output_Enable);
			#endif
			#if(TIMER3_Split_Mode0_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode0_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Split_Mode0_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode0_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Split_Mode0_TH3!=0)
				__DRV_TIMER3_SetHighByte(TIMER3_Split_Mode0_TH3);
			#endif
			#if(TIMER3_Split_Mode0_RCAP3H!=0)
				__DRV_TIMER3_SetRCAP3H(TIMER3_Split_Mode0_RCAP3H);
			#endif
			#if(TIMER3_Split_Mode0_TL3!=0)
				__DRV_TIMER3_SetLowByte(TIMER3_Split_Mode0_TL3);
			#endif
			#if(TIMER3_Split_Mode0_RCAP3L!=0)
				__DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode0_RCAP3L);
			#endif
			#if(TIMER3_Split_Mode0_TR3L_Run!=0)
				__DRV_TIMER3_TL3_Run_Cmd(TIMER3_Split_Mode0_TR3L_Run);
			#endif
			#if(TIMER3_Split_Mode0_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode0_TR3_Run);
			#endif
			#if(TIMER3_Split_Mode0_TL3LC!=0)
				__DRV_TIMER3_TR3L_Clear_Cmd(TIMER3_Split_Mode0_TL3LC);
			#endif
		#endif
		/*---------Timer3 Split Mode1---------*/
		#if(TIMER3_Mode==0x05&&TIMER3_Split_Mode1_Two_8Bit_Timer_Counter_Auto_Reload_With_External_Interrupt)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Split_Mode1_TH3_Clock_Source!=TIMER3_TH3_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_TH3_Clock_Source_Select(TIMER3_Split_Mode1_TH3_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode1_TL3_Clock_Source!=TIMER3_TL3_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_TL3_Clock_Source_Select(TIMER3_Split_Mode1_TL3_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode1_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode1_Capture_Source);
			#endif
			#if(TIMER3_Split_Mode1_Clock_Output_Enable!=0)
				__DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode1_Clock_Output_Enable);
			#endif
			#if(TIMER3_Split_Mode1_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode1_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Split_Mode1_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode1_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Split_Mode1_TH3!=0)
				__DRV_TIMER3_SetHighByte(TIMER3_Split_Mode1_TH3);
			#endif
			#if(TIMER3_Split_Mode1_RCAP3H!=0)
				__DRV_TIMER3_SetRCAP3H(TIMER3_Split_Mode1_RCAP3H);
			#endif
			#if(TIMER3_Split_Mode1_TL3!=0)
				__DRV_TIMER3_SetLowByte(TIMER3_Split_Mode1_TL3);
			#endif
			#if(TIMER3_Split_Mode1_RCAP3L!=0)
				__DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode1_RCAP3L);
			#endif
			#if(TIMER3_Split_Mode1_TR3L_Run!=0)
				__DRV_TIMER3_TL3_Run_Cmd(TIMER3_Split_Mode1_TR3L_Run);
			#endif
			#if(TIMER3_Split_Mode1_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode1_TR3_Run);
			#endif
			#if(TIMER3_Split_Mode1_TR3LC!=0)
				__DRV_TIMER3_TR3L_Clear_Cmd(TIMER3_Split_Mode1_TR3LC);
			#endif
		#endif
		/*---------Timer3 Split Mode2---------*/
		#if(TIMER3_Mode==0x06&&TIMER3_Split_Mode2_Two_8Bit_Timer_Counter_Capture)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Split_Mode3_TH3_Clock_Source!=TIMER3_TH3_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_TH3_Clock_Source_Select(TIMER3_Split_Mode3_TH3_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode2_TL3_Clock_Source!=TIMER3_TL3_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_TL3_Clock_Source_Select(TIMER3_Split_Mode2_TL3_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode2_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode2_Capture_Source);
			#endif
			#if(TIMER3_Split_Mode2_Clock_Output_Enable!=0)
				__DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode2_Clock_Output_Enable);
			#endif
			#if(TIMER3_Split_Mode2_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode2_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Split_Mode2_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode2_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Split_Mode2_TH3!=0)
				__DRV_TIMER3_SetHighByte(TIMER3_Split_Mode2_TH3);
			#endif
			#if(TIMER3_Split_Mode2_TL3!=0)
				__DRV_TIMER3_SetLowByte(TIMER3_Split_Mode2_TL3);
			#endif
			#if(TIMER3_Split_Mode2_RCAP3L!=0)
				__DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode2_RCAP3L);
			#endif
			#if(TIMER3_Split_Mode2_TR3L_Run!=0)
				__DRV_TIMER3_TL3_Run_Cmd(TIMER3_Split_Mode2_TR3L_Run);
			#endif
			#if(TIMER3_Split_Mode2_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode2_TR3_Run);
			#endif
			#if(TIMER3_Split_Mode2_TR3LC!=0)
				__DRV_TIMER3_TR3L_Clear_Cmd(TIMER3_Split_Mode2_TR3LC);
			#endif
		#endif
		/*---------Timer3 Split Mode3---------*/
		#if(TIMER3_Mode==0x07&&TIMER3_Split_Mode3_Two_8Bit_Timer_Counter_Capture_with_auto_zero)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Split_Mode3_TH3_Clock_Source!=TIMER3_TH3_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_TH3_Clock_Source_Select(TIMER3_Split_Mode3_TH3_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode3_TL3_Clock_Source!=TIMER3_TL3_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_TL3_Clock_Source_Select(TIMER3_Split_Mode3_TL3_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode3_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode3_Capture_Source);
			#endif
			#if(TIMER3_Split_Mode3_Clock_Output_Enable!=0)
				__DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode3_Clock_Output_Enable);
			#endif
			#if(TIMER3_Split_Mode3_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode3_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Split_Mode3_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode3_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Split_Mode3_TH3!=0)
				__DRV_TIMER3_SetHighByte(TIMER3_Split_Mode3_TH3);
			#endif
			#if(TIMER3_Split_Mode3_TL3!=0)
				__DRV_TIMER3_SetLowByte(TIMER3_Split_Mode3_TL3);
			#endif
			#if(TIMER3_Split_Mode3_RCAP3L!=0)
				__DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode3_RCAP3L);
			#endif
			#if(TIMER3_Split_Mode3_TR3L_Run!=0)
				__DRV_TIMER3_TL3_Run_Cmd(TIMER3_Split_Mode3_TR3L_Run);
			#endif
			#if(TIMER3_Split_Mode3_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode3_TR3_Run);
			#endif
			#if(TIMER3_Split_Mode3_TR3LC!=0)
				__DRV_TIMER3_TR3L_Clear_Cmd(TIMER3_Split_Mode3_TR3LC);
			#endif
		#endif
		/*---------Timer3 Split Mode4---------*/
		#if(TIMER3_Mode==0x08&&TIMER3_Split_Mode4_8Bit_Pwm)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Split_Mode4_Clock_Source!=TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_Clock_Source_Select(TIMER3_Split_Mode4_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode4_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode4_Capture_Source);
			#endif
			#if(TIMER3_Split_Mode4_Clock_Output_Enable!=0)
				__DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode4_Clock_Output_Enable);
			#endif
			#if(TIMER3_Split_Mode4_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode4_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Split_Mode4_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode4_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Split_Mode4_TH3!=0)
				__DRV_TIMER3_SetHighByte(TIMER3_Split_Mode4_TH3);
			#endif
			#if(TIMER3_Split_Mode4_RCAP3H!=0)
				__DRV_TIMER3_SetRCAP3H(TIMER3_Split_Mode4_RCAP3H);
			#endif
			#if(TIMER3_Split_Mode4_TL3!=0)
				__DRV_TIMER3_SetLowByte(TIMER3_Split_Mode4_TL3);
			#endif
			#if(TIMER3_Split_Mode4_RCAP3L!=0)
				__DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode4_RCAP3L);
			#endif
			#if(TIMER3_Split_Mode4_T3CKO_Invert!=0)
				__DRV_TIMER3_T3CKO_Invert_Cmd(TIMER3_Split_Mode4_T3CKO_Invert);
			#endif
			#if(TIMER3_Split_Mode4_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode4_TR3_Run);
			#endif
		#endif
		/*---------Timer3 Split Mode6---------*/
		#if(TIMER3_Mode==0x0A&&TIMER3_Split_Mode6_Duty_Capture)
			__DRV_TIMER3_Mode_Select(TIMER3_Mode);
			#if(TIMER3_Split_Mode6_Clock_Source!=TIMER3_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_Clock_Source_Select(TIMER3_Split_Mode6_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode6_TL3_Clock_Source!=TIMER3_TL3_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER3_TL3_Clock_Source_Select(TIMER3_Split_Mode6_TL3_Clock_Source);
			#endif
			#if(TIMER3_Split_Mode6_Capture_Source!=TIMER3_CAPTURE_SOURCE_T3EX_PIN)
				__DRV_TIMER3_Capture_Source_Select(TIMER3_Split_Mode6_Capture_Source);
			#endif
			#if(TIMER3_Split_Mode6_Overflow_Flag_Ignored!=0)
				__DRV_TIMER3_TF3_Interrupt_Ignored_Cmd(TIMER3_Split_Mode6_Overflow_Flag_Ignored);
			#endif
			#if(TIMER3_Split_Mode6_Capture_Source_Dectect_Edge!=Timer3_IGNORED)
				__DRV_TIMER3_Capture_Source_Dectect(TIMER3_Split_Mode6_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER3_Split_Mode6_TH3!=0)
				__DRV_TIMER3_SetHighByte(TIMER3_Split_Mode6_TH3);
			#endif
			#if(TIMER3_Split_Mode6_TL3!=0)
				__DRV_TIMER3_SetLowByte(TIMER3_Split_Mode6_TL3);
			#endif
			#if(TIMER3_Split_Mode6_RCAP3L!=0)
				__DRV_TIMER3_SetRCAP3L(TIMER3_Split_Mode6_RCAP3L);
			#endif
			#if(TIMER3_Split_Mode6_Clock_Output_Enable!=0)
				__DRV_TIMER3_Clock_Out_Cmd(TIMER3_Split_Mode6_Clock_Output_Enable);
			#endif
			#if(TIMER3_Split_Mode6_TR3_Run!=0)
				__DRV_TIMER3_Run_Cmd(TIMER3_Split_Mode6_TR3_Run);
			#endif
			#if(TIMER3_Split_Mode6_TR3L_Run!=0)
				__DRV_TIMER3_TL3_Run_Cmd(TIMER3_Split_Mode6_TR3L_Run);
			#endif
			#if(TIMER3_Split_Mode6_TR3LC!=0)
				__DRV_TIMER3_TR3L_Clear_Cmd(TIMER3_Split_Mode6_TR3LC);
			#endif
		#endif
	#endif

	/*---------Timer4---------*/
	#if(TM4_Wizard_init_EN)
		/*---------Timer4 Mode0---------*/
		#if(TIMER4_Mode==0x00&&TIMER4_Mode0_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Mode0_Clock_Source!=TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_Clock_Source_Select(TIMER4_Mode0_Clock_Source);
			#endif
			#if(TIMER4_Mode0_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Mode0_Capture_Source);
			#endif
			#if(TIMER4_Mode0_Clock_Output_Enable!=0)
				__DRV_TIMER4_Clock_Out_Cmd(TIMER4_Mode0_Clock_Output_Enable);
			#endif
			#if(TIMER4_Mode0_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Mode0_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Mode0_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Mode0_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Mode0_16Bits_Counter_Value!=0)
				__DRV_TIMER4_Set16BitCounter(TIMER4_Mode0_16Bits_Counter_Value);
			#endif
			#if(TIMER4_Mode0_16Bits_Reload_Value!=0)
				__DRV_TIMER4_Set16Bit_AutoReloadValue(TIMER4_Mode0_16Bits_Reload_Value);
			#endif
			#if(TIMER4_Mode0_16Bit_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Mode0_16Bit_TR4_Run);
			#endif
		#endif
		/*---------Timer4 Mode1---------*/
		#if(TIMER4_Mode==0x01&&TIMER4_Mode1_16bit_Timer_Counter_Auto_Reload_and_External_Interrupt)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Mode1_Clock_Source!=TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_Clock_Source_Select(TIMER4_Mode1_Clock_Source);
			#endif
			#if(TIMER4_Mode1_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Mode1_Capture_Source);
			#endif
			#if(TIMER4_Mode1_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Mode1_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Mode1_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Mode1_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Mode1_16Bits_Counter_Value!=0)
				__DRV_TIMER4_Set16BitCounter(TIMER4_Mode1_16Bits_Counter_Value);
			#endif
			#if(TIMER4_Mode1_16Bits_Reload_Value!=0)
				__DRV_TIMER4_Set16Bit_AutoReloadValue(TIMER4_Mode1_16Bits_Reload_Value);
			#endif
			#if(TIMER4_Mode1_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Mode1_TR4_Run);
			#endif
		#endif
		/*---------Timer4 Mode2---------*/
		#if(TIMER4_Mode==0x02&&TIMER4_Mode2_16Bit_Timer_Counter_Capture)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Mode2_Clock_Source!=TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_Clock_Source_Select(TIMER4_Mode2_Clock_Source);
			#endif
			#if(TIMER4_Mode2_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Mode2_Capture_Source);
			#endif
			#if(TIMER4_Mode2_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Mode2_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Mode2_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Mode2_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Mode2_16Bits_Counter_Value!=0)
				__DRV_TIMER4_Set16BitCounter(TIMER4_Mode2_16Bits_Counter_Value);
			#endif
			#if(TIMER4_Mode2_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Mode2_TR4_Run);
			#endif
		#endif
		/*---------Timer4 Mode3---------*/
		#if(TIMER4_Mode==0x03&&TIMER4_Mode3_16Bit_Timer_Counter_Capture_With_Auto_Zero)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Mode3_Clock_Source!=TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_Clock_Source_Select(TIMER4_Mode3_Clock_Source);
			#endif
			#if(TIMER4_Mode3_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Mode3_Capture_Source);
			#endif
			#if(TIMER4_Mode3_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Mode3_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Mode3_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Mode3_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Mode3_16Bits_Counter_Value!=0)
				__DRV_TIMER4_Set16BitCounter(TIMER4_Mode3_16Bits_Counter_Value);
			#endif
			#if(TIMER4_Mode3_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Mode3_TR4_Run);
			#endif
		#endif
		/*---------Timer4 Mode6---------*/
		#if(TIMER4_Mode==0x09&&TIMER4_Mode6_Duty_Capture)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Mode6_Clock_Source!=TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_Clock_Source_Select(TIMER4_Mode6_Clock_Source);
			#endif
			#if(TIMER4_Mode6_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Mode6_Capture_Source);
			#endif
			#if(TIMER4_Mode6_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Mode6_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Mode6_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Mode6_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Mode6_16Bits_Counter_Value!=0)
				__DRV_TIMER4_Set16BitCounter(TIMER4_Mode6_16Bits_Counter_Value);
			#endif
			#if(TIMER4_Mode6_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Mode6_TR4_Run);
			#endif
		#endif
		/*---------Timer4 Split Mode0---------*/
		#if(TIMER4_Mode==0x04&&TIMER4_Split_Mode0_Two_8Bit_Timer_Counter_Auto_Reload_and_External_Interrupt)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Split_Mode0_TH4_Clock_Source!=TIMER4_TH4_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_TH4_Clock_Source_Select(TIMER4_Split_Mode0_TH4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode0_TL4_Clock_Source!=TIMER4_TL4_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_TL4_Clock_Source_Select(TIMER4_Split_Mode0_TL4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode0_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Split_Mode0_Capture_Source);
			#endif
			#if(TIMER4_Split_Mode0_Clock_Output_Enable!=0)
				__DRV_TIMER4_Clock_Out_Cmd(TIMER4_Split_Mode0_Clock_Output_Enable);
			#endif
			#if(TIMER4_Split_Mode0_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Split_Mode0_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Split_Mode0_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Split_Mode0_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Split_Mode0_TH4!=0)
				__DRV_TIMER4_SetHighByte(TIMER4_Split_Mode0_TH4);
			#endif
			#if(TIMER4_Split_Mode0_RCAP4H!=0)
				__DRV_TIMER4_SetRCAP4H(TIMER4_Split_Mode0_RCAP4H);
			#endif
			#if(TIMER4_Split_Mode0_TL4!=0)
				__DRV_TIMER4_SetLowByte(TIMER4_Split_Mode0_TL4);
			#endif
			#if(TIMER4_Split_Mode0_RCAP4L!=0)
				__DRV_TIMER4_SetRCAP4L(TIMER4_Split_Mode0_RCAP4L);
			#endif
			#if(TIMER4_Split_Mode0_TR4L_Run!=0)
				__DRV_TIMER4_TL4_Run_Cmd(TIMER4_Split_Mode0_TR4L_Run);
			#endif
			#if(TIMER4_Split_Mode0_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Split_Mode0_TR4_Run);
			#endif
			#if(TIMER4_Split_Mode0_TL4LC!=0)
				__DRV_TIMER4_TR4L_Clear_Cmd(TIMER4_Split_Mode0_TL4LC);
			#endif
		#endif
		/*---------Timer4 Split Mode1---------*/
		#if(TIMER4_Mode==0x05&&TIMER4_Split_Mode1_Two_8Bit_Timer_Counter_Auto_Reload_With_External_Interrupt)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Split_Mode1_TH4_Clock_Source!=TIMER4_TH4_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_TH4_Clock_Source_Select(TIMER4_Split_Mode1_TH4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode1_TL4_Clock_Source!=TIMER4_TL4_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_TL4_Clock_Source_Select(TIMER4_Split_Mode1_TL4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode1_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Split_Mode1_Capture_Source);
			#endif
			#if(TIMER4_Split_Mode1_Clock_Output_Enable!=0)
				__DRV_TIMER4_Clock_Out_Cmd(TIMER4_Split_Mode1_Clock_Output_Enable);
			#endif
			#if(TIMER4_Split_Mode1_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Split_Mode1_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Split_Mode1_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Split_Mode1_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Split_Mode1_TH4!=0)
				__DRV_TIMER4_SetHighByte(TIMER4_Split_Mode1_TH4);
			#endif
			#if(TIMER4_Split_Mode1_RCAP4H!=0)
				__DRV_TIMER4_SetRCAP4H(TIMER4_Split_Mode1_RCAP4H);
			#endif
			#if(TIMER4_Split_Mode1_TL4!=0)
				__DRV_TIMER4_SetLowByte(TIMER4_Split_Mode1_TL4);
			#endif
			#if(TIMER4_Split_Mode1_RCAP4L!=0)
				__DRV_TIMER4_SetRCAP4L(TIMER4_Split_Mode1_RCAP4L);
			#endif
			#if(TIMER4_Split_Mode1_TR4L_Run!=0)
				__DRV_TIMER4_TL4_Run_Cmd(TIMER4_Split_Mode1_TR4L_Run);
			#endif
			#if(TIMER4_Split_Mode1_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Split_Mode1_TR4_Run);
			#endif
			#if(TIMER4_Split_Mode1_TR4LC!=0)
				__DRV_TIMER4_TR4L_Clear_Cmd(TIMER4_Split_Mode1_TR4LC);
			#endif
		#endif
		/*---------Timer4 Split Mode2---------*/
		#if(TIMER4_Mode==0x06&&TIMER4_Split_Mode2_Two_8Bit_Timer_Counter_Capture)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Split_Mode2_TH4_Clock_Source!=TIMER4_TH4_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_TH4_Clock_Source_Select(TIMER4_Split_Mode2_TH4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode2_TL4_Clock_Source!=TIMER4_TL4_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_TL4_Clock_Source_Select(TIMER4_Split_Mode2_TL4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode2_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Split_Mode2_Capture_Source);
			#endif
			#if(TIMER4_Split_Mode2_Clock_Output_Enable!=0)
				__DRV_TIMER4_Clock_Out_Cmd(TIMER4_Split_Mode2_Clock_Output_Enable);
			#endif
			#if(TIMER4_Split_Mode2_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Split_Mode2_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Split_Mode2_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Split_Mode2_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Split_Mode2_TH4!=0)
				__DRV_TIMER4_SetHighByte(TIMER4_Split_Mode2_TH4);
			#endif
			#if(TIMER4_Split_Mode2_TL4!=0)
				__DRV_TIMER4_SetLowByte(TIMER4_Split_Mode2_TL4);
			#endif
			#if(TIMER4_Split_Mode2_RCAP4L!=0)
				__DRV_TIMER4_SetRCAP4L(TIMER4_Split_Mode2_RCAP4L);
			#endif
			#if(TIMER4_Split_Mode2_TR4L_Run!=0)
				__DRV_TIMER4_TL4_Run_Cmd(TIMER4_Split_Mode2_TR4L_Run);
			#endif
			#if(TIMER4_Split_Mode2_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Split_Mode2_TR4_Run);
			#endif
			#if(TIMER4_Split_Mode2_TR4LC!=0)
				__DRV_TIMER4_TR4L_Clear_Cmd(TIMER4_Split_Mode2_TR4LC);
			#endif
		#endif
		/*---------Timer4 Split Mode3---------*/
		#if(TIMER4_Mode==0x07&&TIMER4_Split_Mode3_Two_8Bit_Timer_Counter_Capture_with_auto_zero)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Split_Mode3_TH4_Clock_Source!=TIMER4_TH4_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_TH4_Clock_Source_Select(TIMER4_Split_Mode3_TH4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode3_TL4_Clock_Source!=TIMER4_TL4_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_TL4_Clock_Source_Select(TIMER4_Split_Mode3_TL4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode3_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Split_Mode3_Capture_Source);
			#endif
			#if(TIMER4_Split_Mode3_Clock_Output_Enable!=0)
				__DRV_TIMER4_Clock_Out_Cmd(TIMER4_Split_Mode3_Clock_Output_Enable);
			#endif
			#if(TIMER4_Split_Mode3_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Split_Mode3_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Split_Mode3_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Split_Mode3_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Split_Mode3_TH4!=0)
				__DRV_TIMER4_SetHighByte(TIMER4_Split_Mode3_TH4);
			#endif
			#if(TIMER4_Split_Mode3_TL4!=0)
				__DRV_TIMER4_SetLowByte(TIMER4_Split_Mode3_TL4);
			#endif
			#if(TIMER4_Split_Mode3_RCAP4L!=0)
				__DRV_TIMER4_SetRCAP4L(TIMER4_Split_Mode3_RCAP4L);
			#endif
			#if(TIMER4_Split_Mode3_TR4L_Run!=0)
				__DRV_TIMER4_TL4_Run_Cmd(TIMER4_Split_Mode3_TR4L_Run);
			#endif
			#if(TIMER4_Split_Mode3_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Split_Mode3_TR4_Run);
			#endif
			#if(TIMER4_Split_Mode3_TR4LC!=0)
				__DRV_TIMER4_TR4L_Clear_Cmd(TIMER4_Split_Mode3_TR4LC);
			#endif
		#endif
		/*---------Timer4 Split Mode4---------*/
		#if(TIMER4_Mode==0x08&&TIMER4_Split_Mode4_8Bit_Pwm)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Split_Mode4_Clock_Source!=TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_Clock_Source_Select(TIMER4_Split_Mode4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode4_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Split_Mode4_Capture_Source);
			#endif
			#if(TIMER4_Split_Mode4_Clock_Output_Enable!=0)
				__DRV_TIMER4_Clock_Out_Cmd(TIMER4_Split_Mode4_Clock_Output_Enable);
			#endif
			#if(TIMER4_Split_Mode4_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Split_Mode4_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Split_Mode4_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Split_Mode4_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Split_Mode4_TH4!=0)
				__DRV_TIMER4_SetHighByte(TIMER4_Split_Mode4_TH4);
			#endif
			#if(TIMER4_Split_Mode4_RCAP4H!=0)
				__DRV_TIMER4_SetRCAP4H(TIMER4_Split_Mode4_RCAP4H);
			#endif
			#if(TIMER4_Split_Mode4_TL4!=0)
				__DRV_TIMER4_SetLowByte(TIMER4_Split_Mode4_TL4);
			#endif
			#if(TIMER4_Split_Mode4_RCAP4L!=0)
				__DRV_TIMER4_SetRCAP4L(TIMER4_Split_Mode4_RCAP4L);
			#endif
			#if(TIMER4_Split_Mode4_T4CKO_Invert!=0)
				__DRV_TIMER4_T4CKO_Invert_Cmd(TIMER4_Split_Mode4_T4CKO_Invert);
			#endif
			#if(TIMER4_Split_Mode4_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Split_Mode4_TR4_Run);
			#endif
		#endif
		/*---------Timer4 Split Mode6---------*/
		#if(TIMER4_Mode==0x0A&&TIMER4_Split_Mode6_Duty_Capture)
			__DRV_TIMER4_Mode_Select(TIMER4_Mode);
			#if(TIMER4_Split_Mode6_Clock_Source!=TIMER4_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_Clock_Source_Select(TIMER4_Split_Mode6_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode6_TL4_Clock_Source!=TIMER4_TL4_SPLIT_MODE_CLOCK_SOURCE_SYSCLK_DIV_12)
				__DRV_TIMER4_TL4_Clock_Source_Select(TIMER4_Split_Mode6_TL4_Clock_Source);
			#endif
			#if(TIMER4_Split_Mode6_Capture_Source!=TIMER4_CAPTURE_SOURCE_T4EX_PIN)
				__DRV_TIMER4_Capture_Source_Select(TIMER4_Split_Mode6_Capture_Source);
			#endif
			#if(TIMER4_Split_Mode6_Overflow_Flag_Ignored!=0)
				__DRV_TIMER4_TF4_Interrupt_Ignored_Cmd(TIMER4_Split_Mode6_Overflow_Flag_Ignored);
			#endif
			#if(TIMER4_Split_Mode6_Capture_Source_Dectect_Edge!=Timer4_IGNORED)
				__DRV_TIMER4_Capture_Source_Dectect(TIMER4_Split_Mode6_Capture_Source_Dectect_Edge);
			#endif
			#if(TIMER4_Split_Mode6_TH4!=0)
				__DRV_TIMER4_SetHighByte(TIMER4_Split_Mode6_TH4);
			#endif
			#if(TIMER4_Split_Mode6_TL4!=0)
				__DRV_TIMER4_SetLowByte(TIMER4_Split_Mode6_TL4);
			#endif
			#if(TIMER4_Split_Mode6_RCAP4L!=0)
				__DRV_TIMER4_SetRCAP4L(TIMER4_Split_Mode6_RCAP4L);
			#endif
			#if(TIMER4_Split_Mode6_Clock_Output_Enable!=0)
				__DRV_TIMER4_Clock_Out_Cmd(TIMER4_Split_Mode6_Clock_Output_Enable);
			#endif
			#if(TIMER4_Split_Mode6_TR4_Run!=0)
				__DRV_TIMER4_Run_Cmd(TIMER4_Split_Mode6_TR4_Run);
			#endif
			#if(TIMER4_Split_Mode6_TR4L_Run!=0)
				__DRV_TIMER4_TL4_Run_Cmd(TIMER4_Split_Mode6_TR4L_Run);
			#endif
			#if(TIMER4_Split_Mode6_TR4LC!=0)
				__DRV_TIMER4_TR4L_Clear_Cmd(TIMER4_Split_Mode6_TR4LC);
			#endif
		#endif
	#endif
}

/// @cond Timer_wizard_option_#endif
#endif
/// @endcond


/// @cond PCA_wizard_option_#if
#if MG82F6D64_PCA_WIZARD
/// @endcond

#if PCA_MODE==0
void DRV_PCA_IC_Wizard_Init()
{
        _push_(SFRPI);
        __DRV_SFR_PageIndex(0);
        __DRV_PCA_Disable();
        CH = 0; CHRL = HIBYTE(65536-(IC_PERIOD));
        CL = 0; CLRL = LOBYTE(65536-(IC_PERIOD));
        __DRV_PCA_ClockSource_Select(IC_CKSRC);
        CMOD |= IC_BUFFER & 0x70;
        #if(IC0_EN)
            CCAPM0 = IC0_EDGE & 0x30;
        #endif
        #if(IC1_EN)
            CCAPM1 = IC1_EDGE & 0x30;
        #endif
        #if(IC2_EN)
            CCAPM2 = IC2_EDGE & 0x30;
        #endif
        #if(IC3_EN)
            CCAPM3 = IC3_EDGE & 0x30;
        #endif
        #if(IC4_EN)
            CCAPM4 = IC4_EDGE & 0x30;
        #endif
        #if(IC5_EN)
            CCAPM5 = IC5_EDGE & 0x30;
        #endif
        #if(IC2_PIN)
            __DRV_PCA_CEX2InputMux_Select(IC2_PIN);
        #endif
        #if(IC4_PIN)
            __DRV_PCA_CEX4InputMux_Select(IC4_PIN);
        #endif
        _pop_(SFRPI);

}
#endif

#if PCA_MODE==1
void DRV_PCA_OC_Wizard_Init()
{
        _push_(SFRPI);
        __DRV_SFR_PageIndex(0);
        __DRV_PCA_Disable();
        __DRV_PCA_SetCounterValue(65536-(OC_PERIOD));
        __DRV_PCA_SetCounterReloadValue(65536-(OC_PERIOD));
        __DRV_PCA_ClockSource_Select(OC_CKSRC);
        CMOD &=0x8F;
        CMOD |= OC_BUFFER & 0x70;
        __DRV_SFR_PageIndex(1);
        ((OC_BUFFER&(PCA_PWM67_BUFFER))==(0x00)?(CCAPM6 &= ~BME6):(CCAPM6 |= BME6));
        __DRV_SFR_PageIndex(0);
        #if(OC0_EN)
          __DRV_PCA_PWM0_SetInverse(OC0_INV);
          __DRV_PCA_PWM0Resolution_Select(OC0_RES);
          CCAPM0 = (ECOM0 | TOG0 | PWM0);
          OC0_RES==PCA_PWM_8BIT?(CCAP0H = LOBYTE(OC0_COPM)):(CCAP0H = HIBYTE(OC0_COPM));
          CCAP0L = LOBYTE(OC0_COPM);
        #endif
        #if(OC1_EN)
          __DRV_PCA_PWM1_SetInverse(OC1_INV);
          __DRV_PCA_PWM1Resolution_Select(OC1_RES);
          CCAPM1 = (ECOM1 | TOG1 | PWM1);
          OC1_RES==PCA_PWM_8BIT?(CCAP1H = LOBYTE(OC1_COPM)):(CCAP1H = HIBYTE(OC1_COPM));
          CCAP1L = LOBYTE(OC1_COPM);
        #endif
        #if(OC2_EN)
          __DRV_PCA_PWM2_SetInverse(OC2_INV);
          __DRV_PCA_PWM2Resolution_Select(OC2_RES);
          CCAPM2 = (ECOM2 | TOG2 | PWM2);
          OC2_RES==PCA_PWM_8BIT?(CCAP2H = LOBYTE(OC2_COPM)):(CCAP2H = HIBYTE(OC2_COPM));
          CCAP2L = LOBYTE(OC2_COPM);
        #endif
        #if(OC3_EN)
          __DRV_PCA_PWM3_SetInverse(OC3_INV);
          __DRV_PCA_PWM3Resolution_Select(OC3_RES);
          CCAPM3 = (ECOM3 | TOG3 | PWM3);
          OC3_RES==PCA_PWM_8BIT?(CCAP3H = LOBYTE(OC3_COPM)):(CCAP3H = HIBYTE(OC3_COPM));
          CCAP3L = LOBYTE(OC3_COPM);
        #endif
        #if(OC4_EN)
          __DRV_PCA_PWM4_SetInverse(OC4_INV);
          __DRV_PCA_PWM4Resolution_Select(OC4_RES);
          CCAPM4 = (ECOM4 | TOG4 | PWM4);
          OC4_RES==PCA_PWM_8BIT?(CCAP4H = LOBYTE(OC4_COPM)):(CCAP4H = HIBYTE(OC4_COPM));
          CCAP4L = LOBYTE(OC4_COPM);
        #endif
        #if(OC5_EN)
          __DRV_PCA_PWM5_SetInverse(OC5_INV);
          __DRV_PCA_PWM5Resolution_Select(OC5_RES);
          CCAPM5 = (ECOM5 | TOG5 | PWM5);
          OC5_RES==PCA_PWM_8BIT?(CCAP5H = LOBYTE(OC5_COPM)):(CCAP5H = HIBYTE(OC5_COPM));
          CCAP5L = LOBYTE(OC5_COPM);
        #endif
        #if(OC6_EN)
          __DRV_PCA_PWM6_SetInverse(OC6_INV);
          __DRV_SFR_PageIndex(1);
          PCAPWM6 &= ~(P0RS1 | P0RS0);
          PCAPWM6 |= OC6_RES;
          CCAPM6 |= (ECOM6 | TOG6 | PWM6);
          OC6_RES==PCA_PWM_8BIT?(CCAP6H = LOBYTE(OC6_COPM)):(CCAP6H = HIBYTE(OC6_COPM));
          CCAP6L = LOBYTE(OC6_COPM);
        #endif
        #if(OC7_EN)
          __DRV_PCA_PWM7_SetInverse(OC7_INV);
          __DRV_SFR_PageIndex(1);
          PCAPWM7 &= ~(P0RS1 | P0RS0);
          PCAPWM7 |= OC7_RES;
          CCAPM7 = (ECOM7 | TOG7 | PWM7);
          OC7_RES==PCA_PWM_8BIT?(CCAP7H = LOBYTE(OC7_COPM)):(CCAP7H = HIBYTE(OC7_COPM));
          CCAP7L = LOBYTE(OC7_COPM);
        #endif
        _pop_(SFRPI);

}
#endif

#if PCA_MODE==2
void DRV_PCA_PWM_Wizard_Init()
{
        _push_(SFRPI);
        __DRV_SFR_PageIndex(0);
        __DRV_PCA_Disable();
        __DRV_SFR_PageIndex(1);
        ((PWM_BUFFER&(PCA_PWM67_BUFFER))==(0x00)?(CCAPM6 &= ~BME6):(CCAPM6 |= BME6));
        __DRV_SFR_PageIndex(0);
        CMOD &=0x8F;
        CMOD |= PWM_BUFFER & 0x70;
        __DRV_PCA_SetCounterValue(65536-PWM_CKS_FREQ/PWM_FREQ);
        __DRV_PCA_SetCounterReloadValue(65536-PWM_CKS_FREQ/PWM_FREQ);
        __DRV_PCA_ClockSource_Select(PWM_CKSRC);
        __DRV_PCA_PWM_CentralAligned_Cmd(PWM_ALIGN);
      #if(PWM0_EN)
        __DRV_PCA_PWM0_SetInverse(PWM0_INV);
        CCAPM0 = (ECOM0 | PWM0);
        PCAPWM0 |= (P1RS1 | P1RS0);
        __DRV_PCA_SetPWM0DutyValue((PWM_CKS_FREQ/PWM_FREQ*(100-PWM0_DUTY_PERC)/100)+(65536-PWM_CKS_FREQ/PWM_FREQ));
      #endif
      #if(PWM1_EN)
        __DRV_PCA_PWM1_SetInverse(PWM1_INV);
        CCAPM1 = (ECOM1 | PWM1);
        PCAPWM1 |= (P1RS1 | P1RS0);
        __DRV_PCA_SetPWM1DutyValue((PWM_CKS_FREQ/PWM_FREQ*(100-PWM1_DUTY_PERC)/100)+(65536-PWM_CKS_FREQ/PWM_FREQ));
      #endif
      #if(PWM2_EN)
        __DRV_PCA_PWM2_SetInverse(PWM2_INV);
        CCAPM2 = (ECOM2 | PWM2);
        PCAPWM2 |= (P2RS1 | P2RS0);
        __DRV_PCA_SetPWM2DutyValue((PWM_CKS_FREQ/PWM_FREQ*(100-PWM2_DUTY_PERC)/100)+(65536-PWM_CKS_FREQ/PWM_FREQ));
      #endif
      #if(PWM3_EN)
        __DRV_PCA_PWM3_SetInverse(PWM3_INV);
        CCAPM3 = (ECOM3 | PWM3);
        PCAPWM3 |= (P3RS1 | P3RS0);
        __DRV_PCA_SetPWM3DutyValue((PWM_CKS_FREQ/PWM_FREQ*(100-PWM3_DUTY_PERC)/100)+(65536-PWM_CKS_FREQ/PWM_FREQ));
      #endif
      #if(PWM4_EN)
        __DRV_PCA_PWM4_SetInverse(PWM4_INV);
        CCAPM4 = (ECOM4 | PWM4);
        PCAPWM4 |= (P4RS1 | P4RS0);
        __DRV_PCA_SetPWM4DutyValue((PWM_CKS_FREQ/PWM_FREQ*(100-PWM4_DUTY_PERC)/100)+(65536-PWM_CKS_FREQ/PWM_FREQ));
      #endif
      #if(PWM5_EN)
        __DRV_PCA_PWM5_SetInverse(PWM5_INV);
        CCAPM5 = (ECOM5 | PWM5);
        PCAPWM5 |= (P5RS1 | P5RS0);
        __DRV_PCA_SetPWM5DutyValue((PWM_CKS_FREQ/PWM_FREQ*(100-PWM5_DUTY_PERC)/100)+(65536-PWM_CKS_FREQ/PWM_FREQ));
      #endif
      #if(PWM6_EN)
        __DRV_PCA_PWM6_SetInverse(PWM6_INV);
        __DRV_SFR_PageIndex(1);
        CCAPM6 = (ECOM6 | PWM6);
        PCAPWM6 |= (P6RS1 | P6RS0);
        __DRV_PCA_SetPWM6DutyValue((PWM_CKS_FREQ/PWM_FREQ*(100-PWM6_DUTY_PERC)/100)+(65536-PWM_CKS_FREQ/PWM_FREQ));
      #endif
      #if(PWM7_EN)
        __DRV_PCA_PWM7_SetInverse(PWM7_INV);
        __DRV_SFR_PageIndex(1);
        CCAPM7 = (ECOM7 | PWM7);
        PCAPWM7 |= (P7RS1 | P7RS0);
        __DRV_PCA_SetPWM7DutyValue((PWM_CKS_FREQ/PWM_FREQ*(100-PWM7_DUTY_PERC)/100)+(65536-PWM_CKS_FREQ/PWM_FREQ));
      #endif
      _pop_(SFRPI);
}
#endif


#if PCA_MODE==3
void DRV_PCA_PWM_DTG_Wizard_Init()
{
        _push_(SFRPI);
        __DRV_SFR_PageIndex(0);
        __DRV_PCA_Disable();
        __DRV_PCA_SetCounterValue(65536-PWM_DTG_CKS_FREQ/PWM_DTG_FREQ);
        __DRV_PCA_SetCounterReloadValue(65536-PWM_DTG_CKS_FREQ/PWM_DTG_FREQ);
        __DRV_PCA_ClockSource_Select(PWM_DTG_CKSRC);
        __DRV_SFR_PageIndex(1);
        PDTCRA = PWM_DTG_DTCKSRC | (PWM_DTG_DTPERIOD & 0x3F);
        __DRV_SFR_PageIndex(0);
      #if(PWM01_DTG_EN)
        __DRV_PCA_PWM0_SetInverse(PWM0_DTG_INV);
        __DRV_PCA_PWM1_SetInverse(PWM1_DTG_INV);
        PCAPWM0 |= (P0RS1 | P0RS0);
        PCAPWM1 |= (P0RS1 | P0RS0);
        CMOD |= BME0;
        CCAPM0 = (ECOM0  | PWM0 | DTE0);
        CCAPM1 = (ECOM1  | PWM1 );
        __DRV_PCA_SetPWM0DutyValue((PWM_DTG_CKS_FREQ/PWM_DTG_FREQ*(100-PWM01_DUTY_PERC)/100)+(65536-PWM_DTG_CKS_FREQ/PWM_DTG_FREQ));
        __DRV_PCA_SetPWM1DutyValue((PWM_DTG_CKS_FREQ/PWM_DTG_FREQ*(100-PWM01_DUTY_PERC)/100)+(65536-PWM_DTG_CKS_FREQ/PWM_DTG_FREQ));
      #endif
      #if(PWM23_DTG_EN)
        __DRV_PCA_PWM2_SetInverse(PWM2_DTG_INV);
        __DRV_PCA_PWM3_SetInverse(PWM3_DTG_INV);
        PCAPWM2 |= (P0RS1 | P0RS0);
        PCAPWM3 |= (P0RS1 | P0RS0);
        CMOD |= BME2;
        CCAPM2 = (ECOM2  | PWM2 | DTE2);
        CCAPM3 = (ECOM3  | PWM3 );
        __DRV_PCA_SetPWM2DutyValue((PWM_DTG_CKS_FREQ/PWM_DTG_FREQ*(100-PWM23_DUTY_PERC)/100)+(65536-PWM_DTG_CKS_FREQ/PWM_DTG_FREQ));
        __DRV_PCA_SetPWM3DutyValue((PWM_DTG_CKS_FREQ/PWM_DTG_FREQ*(100-PWM23_DUTY_PERC)/100)+(65536-PWM_DTG_CKS_FREQ/PWM_DTG_FREQ));
      #endif
      #if(PWM45_DTG_EN)
        __DRV_PCA_PWM4_SetInverse(PWM4_DTG_INV);
        __DRV_PCA_PWM5_SetInverse(PWM5_DTG_INV);
        PCAPWM4 |= (P0RS1 | P0RS0);
        PCAPWM5 |= (P0RS1 | P0RS0);
        CMOD |= BME4;
        CCAPM4 = (ECOM4  | PWM4 | DTE4);
        CCAPM5 = (ECOM5  | PWM5 );
        __DRV_PCA_SetPWM4DutyValue((PWM_DTG_CKS_FREQ/PWM_DTG_FREQ*(100-PWM45_DUTY_PERC)/100)+(65536-PWM_DTG_CKS_FREQ/PWM_DTG_FREQ));
        __DRV_PCA_SetPWM5DutyValue((PWM_DTG_CKS_FREQ/PWM_DTG_FREQ*(100-PWM45_DUTY_PERC)/100)+(65536-PWM_DTG_CKS_FREQ/PWM_DTG_FREQ));
      #endif
      _pop_(SFRPI);
}
#endif

#if PCA_MODE==4
void DRV_PCA_Timer_Wizard_Init()
{
        _push_(SFRPI);
        __DRV_SFR_PageIndex(0);
        __DRV_PCA_Disable();
        __DRV_PCA_SetCounterValue(65536-(TIM_PERIOD));
        __DRV_PCA_SetCounterReloadValue(65536-(TIM_PERIOD));
        __DRV_PCA_ClockSource_Select(TIM_CKSRC);
        #if(PWM0_TIM_EN)
          CCAPM0 = ECOM0 | MAT0;
          __DRV_PCA_SetPWM0DutyValue(TIM0_VAL);
        #endif
        #if(PWM1_TIM_EN)
          CCAPM1 = ECOM1 | MAT1;
          __DRV_PCA_SetPWM1DutyValue(TIM1_VAL);
        #endif
        #if(PWM2_TIM_EN)
          CCAPM2 = ECOM2 | MAT2;
          __DRV_PCA_SetPWM2DutyValue(TIM2_VAL);
        #endif
        #if(PWM3_TIM_EN)
          CCAPM3 = ECOM3 | MAT3;
          __DRV_PCA_SetPWM3DutyValue(TIM3_VAL);
        #endif
        #if(PWM4_TIM_EN)
          CCAPM4 = ECOM4 | MAT4;
          __DRV_PCA_SetPWM4DutyValue(TIM4_VAL);
        #endif
        #if(PWM5_TIM_EN)
          CCAPM5 = ECOM5 | MAT5;
          __DRV_PCA_SetPWM5DutyValue(TIM5_VAL);
        #endif
        #if(PWM6_TIM_EN)
          __DRV_SFR_PageIndex(1);
          CCAPM6 = ECOM6 | MAT6;
          __DRV_PCA_SetPWM6DutyValue(TIM6_VAL);
        #endif
        #if(PWM7_TIM_EN)
          __DRV_SFR_PageIndex(1);
          CCAPM7 = ECOM7 | MAT7;
          __DRV_PCA_SetPWM7DutyValue(TIM7_VAL);
        #endif
        _pop_(SFRPI);\

}
#endif


/**
*******************************************************************************
* @brief       PCA Initial.
* @details     Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
                DRV_PCA_Wizard_Init();
* @endcode
*******************************************************************************
*/
void DRV_PCA_Wizard_Init()
{

    #if PCA_MODE==0
        DRV_PCA_IC_Wizard_Init();
    #endif

    #if PCA_MODE==1
        DRV_PCA_OC_Wizard_Init();
    #endif

    #if PCA_MODE==2
        DRV_PCA_PWM_Wizard_Init();
    #endif

    #if PCA_MODE==3
        DRV_PCA_PWM_DTG_Wizard_Init();
    #endif

    #if PCA_MODE==4
        DRV_PCA_Timer_Wizard_Init();
    #endif

    #if(PCA_ENABLE)
        __DRV_PCA_Enable();
    #endif
}

/// @cond PCA_wizard_option_#endif
#endif
/// @endcond


/// @cond urt0_wizard_option_#if
#if MG82F6D64_UART0_WIZARD
/// @endcond

/**
*******************************************************************************
* @brief       UART0 Wizard Initial.
* @details    Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
                DRV_UART0_Wizard_Init();
* @endcode
*******************************************************************************
*/
void DRV_UART0_Wizard_Init(void)
{
    #if(URT0_Advance_Mode&&URT0_Option)
        #if(URT0_Advance)
            #if(URT0_Mode==0x00)
                __DRV_URT0_Mode_Select(URT0_Mode);
                #if(URT0_Mode0_Shift)
                    #if(URT0_Mode0_Shift_SYSCLK_Clock_Source&&(URT0_Mode0_Clock_Source==0))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode0_Shift_SYSCLK_Clock_Source)
                            #if(URT0_Mode0_Shift_SYSCLK_Clock_Source_for_S0)
                            __DRV_URT0_BaudRateSysclkDiv4_Cmd(URT0_Mode0_Shift_SYSCLK_Clock_Source_SYSCLK);
                            __DRV_URT0_DataOrder_Select(URT0_Mode0_Shift_SYSCLK_Data_Order);
                            __DRV_URT0_SerialReception_Cmd(URT0_Mode0_Shift_SYSCLK_Input_Output);
                            #endif
                            #if(URT0_Mode0_Shift_SYSCLK_Baud_Rate_Generator_for_Others)
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode0_Shift_SYSCLK_Baud_Rate_Reload_Count);
                            __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode0_Shift_SYSCLK_S0BRG_Clock_Source_SYSCLK);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode0_Shift_SYSCLK_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode0_Shift_SYSCLK_S0BRG_Operation);
                            #endif
                        #endif
                    #elif(URT0_Mode0_Shift_S0BRG_Clock_Source&&(URT0_Mode0_Clock_Source==2))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_S0BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode0_Shift_S0BRG_Clock_Source)
                        __DRV_URT0_DataOrder_Select(URT0_Mode0_Shift_S0BRG_Data_Order);
                        __DRV_URT0_BaudRateX2_Select(URT0_Mode0_Shift_S0BRG_Baud_Rate);
                        __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode0_Shift_S0BRG_Baud_Rate_Reload_Count);
                        __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode0_Shift_S0BRG_Clock_Source_SYSCLK);
                        __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode0_Shift_S0BRG_S0BRG_Operation);
                        __DRV_URT0_SerialReception_Cmd(URT0_Mode0_Shift_S0BRG_Input_Output);
                        #endif
                    #endif
                #endif
            #elif(URT0_Mode==0x01)
                __DRV_URT0_Mode_Select(URT0_Mode);
                #if(URT0_Mode1_8Bit)
                    #if(URT0_Mode1_8Bit_Timer1_Clock_Source&&(URT0_Mode1_Clock_Source==0))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode1_8Bit_Timer1_Clock_Source)
                            #if(URT0_Mode1_8Bit_Timer1_Clock_Source_for_S0)
                            __DRV_URT0_DataOrder_Select(URT0_Mode1_8Bit_Timer1_Data_Order);
                            __DRV_URT0_BaudRateX2X4_Select(URT0_Mode1_8Bit_Timer1_Baud_Rate);
                            __DRV_URT0_SerialReception_Cmd(URT0_Mode1_8Bit_Timer1_Reception);
                            #endif
                            #if(URT0_Mode1_8Bit_Timer1_Baud_Rate_Generator_for_Others)
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode1_8Bit_Timer1_Baud_Rate_Reload_Count);
                            __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode1_8Bit_Timer1_S0BRG_Clock_Source_SYSCLK);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode1_8Bit_Timer1_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode1_8Bit_Timer1_S0BRG_Operation);
                            #endif
                        #endif
                    #elif(URT0_Mode1_8Bit_Timer2_Clock_Source&&(URT0_Mode1_Clock_Source==1))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER2_RECEIVE_CLOCK_SOURCE_TIMER2);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode1_8Bit_Timer2_Clock_Source)
                            #if(URT0_Mode1_8Bit_Timer2_Clock_Source_for_S0)
                            __DRV_URT0_DataOrder_Select(URT0_Mode1_8Bit_Timer2_Data_Order);
                            __DRV_URT0_BaudRateX2X4_Select(URT0_Mode1_8Bit_Timer2_Baud_Rate);
                            __DRV_URT0_SerialReception_Cmd(URT0_Mode1_8Bit_Timer2_Reception);
                            #endif
                            #if(URT0_Mode1_8Bit_Timer2_Baud_Rate_Generator_for_Others)
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode1_8Bit_Timer2_Baud_Rate_Reload_Count);
                            __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode1_8Bit_Timer2_Clock_Source_SYSCLK);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode1_8Bit_Timer2_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode1_8Bit_Timer2_S0BRG_Operation);
                            #endif
                        #endif
                    #elif(URT0_Mode1_8Bit_S0BRG_Clock_Source&&(URT0_Mode1_Clock_Source==2))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_S0BRG_RECEIVE_CLOCK_SOURCE_S0BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode1_8Bit_S0BRG_Clock_Source)
                        __DRV_URT0_DataOrder_Select(URT0_Mode1_8Bit_S0BRG_Data_Order);
                        __DRV_URT0_BaudRateX2_Select(URT0_Mode1_8Bit_S0BRG_Baud_Rate);
                        __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode1_8Bit_S0BRG_Baud_Rate_Reload_Count);
                        __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode1_8Bit_S0BRG_Clock_Source_SYSCLK);
                        __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode1_8Bit_S0BRG_S0BRG_Operation);
                        __DRV_URT0_SerialReception_Cmd(URT0_Mode1_8Bit_S0BRG_Reception);
                        #endif
                    #elif(URT0_Mode1_8Bit_S1BRG_Clock_Source&&(URT0_Mode1_Clock_Source==3))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_S1BRG_RECEIVE_CLOCK_SOURCE_S1BRG);
                        #if(URT0_Mode1_8Bit_S1BRG_Clock_Source)
                            #if(URT0_Mode1_8Bit_S1BRG_Clock_Source_for_S0)
                            __DRV_URT0_DataOrder_Select(URT0_Mode1_8Bit_S1BRG_Data_Order);
                            __DRV_URT0_BaudRateX2X4_Select(URT0_Mode1_8Bit_S1BRG_Baud_Rate);
                            __DRV_URT0_SerialReception_Cmd(URT0_Mode1_8Bit_S1BRG_Reception);
                            #endif
                            #if(URT0_Mode1_8Bit_S1BRG_Baud_Rate_Generator_for_Others)
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode1_8Bit_S1BRG_Baud_Rate_Reload_Count);
                            __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode1_8Bit_S1BRG_Clock_Source_SYSCLK);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode1_8Bit_S1BRG_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode1_8Bit_S1BRG_S0BRG_Operation);
                            #endif
                        #endif
                    #endif
                #endif
            #elif(URT0_Mode==0x02)
            __DRV_URT0_Mode_Select(URT0_Mode);
                #if(URT0_Mode2_9Bit)
                    #if(URT0_Mode2_9Bit_SYSCLK_Clock_Source&&(URT0_Mode2_Clock_Source==0))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode2_9Bit_SYSCLK_Clock_Source)
                            #if(URT0_Mode2_9Bit_SYSCLK_Clock_Source_for_S0)
                            __DRV_URT0_DataOrder_Select(URT0_Mode2_9Bit_SYSCLK_Data_Order);
                            __DRV_URT0_BaudRateX2X4_Select(URT0_Mode2_9Bit_SYSCLK_Baud_Rate);
                            __DRV_URT0_SerialReception_Cmd(URT0_Mode2_9Bit_SYSCLK_Reception);
                            #endif
                            #if(URT0_Mode2_9Bit_SYSCLK_Baud_Rate_Generator_for_Others)
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode2_9Bit_SYSCLK_Baud_Rate_Reload_Count);
                            __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode2_9Bit_SYSCLK_Clock_Source_SYSCLK);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode2_9Bit_SYSCLK_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode2_9Bit_SYSCLK_S0BRG_Operation);
                            #endif
                        #endif
                    #elif(URT0_Mode2_9Bit_S0BRG_SYSCLK_Clock_Source&&(URT0_Mode2_Clock_Source==1))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_S0BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode2_9Bit_S0BRG_SYSCLK_Clock_Source)
                        __DRV_URT0_DataOrder_Select(URT0_Mode2_9Bit_S0BRG_SYSCLK_Data_Order);
                        __DRV_URT0_BaudRateX2X4_Select(URT0_Mode2_9Bit_S0BRG_SYSCLK_Baud_Rate);
                        __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode2_9Bit_S0BRG_SYSCLK_Baud_Rate_Reload_Count);
                        __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode2_9Bit_S0BRG_SYSCLK_S0BRG_Clock_Source_SYSCLK);
                        __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode2_9Bit_S0BRG_SYSCLK_S0BRG_Operation);
                        __DRV_URT0_SerialReception_Cmd(URT0_Mode2_9Bit_S0BRG_SYSCLK_Reception);
                        #endif
                    #elif(URT0_Mode2_9Bit_SYSCLK_S0BRG_Clock_Source&&(URT0_Mode2_Clock_Source==2))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_S0BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode2_9Bit_SYSCLK_S0BRG_Clock_Source)
                        __DRV_URT0_DataOrder_Select(URT0_Mode2_9Bit_SYSCLK_S0BRG_Data_Order);
                        __DRV_URT0_BaudRateX2X4_Select(URT0_Mode2_9Bit_SYSCLK_S0BRG_Baud_Rate);
                        __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode2_9Bit_SYSCLK_S0BRG_Baud_Rate_Reload_Count);
                        __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode2_9Bit_SYSCLK_S0BRG_S0BRG_Clock_Source_SYSCLK);
                        __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode2_9Bit_SYSCLK_S0BRG_S0BRG_Operation);
                        __DRV_URT0_SerialReception_Cmd(URT0_Mode2_9Bit_SYSCLK_S0BRG_Reception);
                        #endif
                    #elif(URT0_Mode2_9Bit_Pure_Timer&&(URT0_Mode2_Clock_Source==3))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_S0BRG_RECEIVE_CLOCK_SOURCE_S0BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_S1BRG_RECEIVE_CLOCK_SOURCE_S1BRG);
                        #if(URT0_Mode2_9Bit_Pure_Timer&&(URT0_Mode2_9Bit_Timer_Pure_Timer==UART0_8BIT_TIMER_MODE))
                        __DRV_URT0_TimerMode_Select(URT0_Mode2_9Bit_Timer_Pure_Timer);
                            #if(URT0_Mode2_9Bit_8Bit_Pure_Timer)
                            __DRV_URT0_Pure_Timer_Baudrate_Generator_Overflow_to_S0_Interrupt_Cmd(URT0_Mode2_9Bit_8Bit_Pure_Timer_Baudrate_Generator_Overflow_S0_Interrupt);
                            __DRV_URT0_Pure_Timer_External_Pin_Trigger_to_S0_Interrupt_Cmd(URT0_Mode2_9Bit_8Bit_Pure_Timer_External_Pin_Trigger_S0_Interrupt);
                            __DRV_URT0_Pure_Timer_External_Pin_Control_Baudrate_Generator_Cmd(URT0_Mode2_9Bit_8Bit_Pure_Timer_External_Pin_Baudrate_Generator_Count);
                            __DRV_URT0_Pure_Timer_External_Pin_Trigger_Level_Cmd(URT0_Mode2_9Bit_8Bit_Pure_Timer_External_Pin_Trigger_Level);
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode2_9Bit_8Bit_Pure_Timer_Baud_Rate_Reload_Count);
                            __DRV_URT0_Block_S0IntFlag_Cmd(URT0_Mode2_9Bit_8Bit_Pure_Timer_Block_TI0);
                            __DRV_URT0_TI0toSYSINT_Cmd(URT0_Mode2_9Bit_8Bit_Pure_Timer_S0BRG_TI0_in_System_Flag_Interrupt);
                            __DRV_URT0_Pure_Timer_Clock_Source_Select(URT0_Mode2_9Bit_8Bit_Pure_Timer_Clock_Source);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode2_9Bit_8Bit_Pure_Timer_S0BRG_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode2_9Bit_8Bit_Pure_Timer_S0BRG_Operation);
                            #endif
                        #elif(URT0_Mode2_9Bit_Pure_Timer&&(URT0_Mode2_9Bit_Timer_Pure_Timer==UART0_16BIT_TIMER_MODE))
                        __DRV_URT0_TimerMode_Select(URT0_Mode2_9Bit_Timer_Pure_Timer);
                            #if(URT0_Mode2_9Bit_16Bit_Pure_Timer)
                            __DRV_URT0_Pure_Timer_Baudrate_Generator_Overflow_to_S0_Interrupt_Cmd(URT0_Mode2_9Bit_16Bit_Pure_Timer_Baudrate_Generator_Overflow_S0_Interrupt);
                            __DRV_URT0_Pure_Timer_External_Pin_Trigger_to_S0_Interrupt_Cmd(URT0_Mode2_9Bit_16Bit_Pure_Timer_External_Pin_Trigger_S0_Interrupt);
                            __DRV_URT0_Pure_Timer_External_Pin_Control_Baudrate_Generator_Cmd(URT0_Mode2_9Bit_16Bit_Pure_Timer_External_Pin_Baudrate_Generator_Count);
                            __DRV_URT0_Pure_Timer_External_Pin_Trigger_Level_Cmd(URT0_Mode2_9Bit_16Bit_Pure_Timer_External_Pin_Trigger_Level);
                            __DRV_URT0_BaudRateReloadReg16Bit_Write(URT0_Mode2_9Bit_16Bit_Pure_Timer_Baud_Rate_Reload_Count);
                            __DRV_URT0_Block_S0IntFlag_Cmd(URT0_Mode2_9Bit_16Bit_Pure_Timer_Block_TI0);
                            __DRV_URT0_TI0toSYSINT_Cmd(URT0_Mode2_9Bit_16Bit_Pure_Timer_S0BRG_TI0_in_System_Flag_Interrupt);
                            __DRV_URT0_Pure_Timer_Clock_Source_Select(URT0_Mode2_9Bit_16Bit_Pure_Timer_Clock_Source);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode2_9Bit_16Bit_Pure_Timer_S0BRG_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode2_9Bit_16Bit_Pure_Timer_S0BRG_Operation);
                            #endif
                        #endif
                    #endif
                #endif
            #elif(URT0_Mode==0x03)
            __DRV_URT0_Mode_Select(URT0_Mode);
                #if(URT0_Mode3_9Bit)
                    #if(URT0_Mode3_9Bit_Timer1_Clock_Source&&(URT0_Mode3_Clock_Source==0))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode3_9Bit_Timer1_Clock_Source)
                            #if(URT0_Mode3_9Bit_Timer1_Clock_Source_for_S0)
                            __DRV_URT0_DataOrder_Select(URT0_Mode3_9Bit_Timer1_Data_Order);
                            __DRV_URT0_BaudRateX2X4_Select(URT0_Mode3_9Bit_Timer1_Baud_Rate);
                            __DRV_URT0_SerialReception_Cmd(URT0_Mode3_9Bit_Timer1_Reception);
                            #endif
                            #if(URT0_Mode3_9Bit_Timer1_Baud_Rate_Generator_for_Others)
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode3_9Bit_Timer1_Baud_Rate_Reload_Count);
                            __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode3_9Bit_Timer1_S0BRG_Clock_Source_SYSCLK);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode3_9Bit_Timer1_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode3_9Bit_Timer1_Operation);
                            #endif
                        #endif
                    #elif(URT0_Mode3_9Bit_Timer2_Clock_Source&&(URT0_Mode3_Clock_Source==1))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER2_RECEIVE_CLOCK_SOURCE_TIMER2);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode3_9Bit_Timer2_Clock_Source)
                            #if(URT0_Mode3_9Bit_Timer2_Clock_Source_for_S0)
                            __DRV_URT0_DataOrder_Select(URT0_Mode3_9Bit_Timer2_Data_Order);
                            __DRV_URT0_BaudRateX2X4_Select(URT0_Mode3_9Bit_Timer2_Baud_Rate);
                            __DRV_URT0_SerialReception_Cmd(URT0_Mode3_9Bit_Timer2_Reception);
                            #endif
                            #if(URT0_Mode3_9Bit_Timer2_Baud_Rate_Generator_for_Others)
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode3_9Bit_Timer2_Baud_Rate_Reload_Count);
                            __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode3_9Bit_Timer2_S0BRG_Clock_Source_SYSCLK);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode3_9Bit_Timer2_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode3_9Bit_Timer2_Operation);
                            #endif
                        #endif
                    #elif(URT0_Mode3_9Bit_S0BRG_Clock_Source&&(URT0_Mode3_Clock_Source==2))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_S0BRG_RECEIVE_CLOCK_SOURCE_S0BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode3_9Bit_S0BRG_Clock_Source)
                        __DRV_URT0_DataOrder_Select(URT0_Mode3_9Bit_S0BRG_Data_Order);
                        __DRV_URT0_BaudRateX2_Select(URT0_Mode3_9Bit_S0BRG_Baud_Rate);
                        __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode3_9Bit_S0BRG_Baud_Rate_Reload_Count);
                        __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode3_9Bit_S0BRG_Clock_Source_SYSCLK);
                        __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode3_9Bit_S0BRG_S0BRG_Operation);
                        __DRV_URT0_SerialReception_Cmd(URT0_Mode3_9Bit_S0BRG_Reception);
                        #endif
                    #elif(URT0_Mode3_9Bit_S1BRG_Clock_Source&&(URT0_Mode3_Clock_Source==3))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_S1BRG_RECEIVE_CLOCK_SOURCE_S1BRG);
                        #if(URT0_Mode3_9Bit_S1BRG_Clock_Source)
                            #if(URT0_Mode3_9Bit_S1BRG_Clock_Source_for_S0)
                            __DRV_URT0_DataOrder_Select(URT0_Mode3_9Bit_S1BRG_Data_Order);
                            __DRV_URT0_BaudRateX2X4_Select(URT0_Mode3_9Bit_S1BRG_Baud_Rate);
                            __DRV_URT0_SerialReception_Cmd(URT0_Mode3_9Bit_S1BRG_Reception);
                            #endif
                            #if(URT0_Mode3_9Bit_S1BRG_Baud_Rate_Generator_for_Others)
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode3_9Bit_S1BRG_Baud_Rate_Reload_Count);
                            __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode3_9Bit_S1BRG_S0BRG_Clock_Source_SYSCLK);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode3_9Bit_S1BRG_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode3_9Bit_S1BRG_S0BRG_Operation);
                            #endif
                        #endif
                    #endif
                #endif
            #elif(URT0_Mode==0x04)
            __DRV_URT0_Mode_Select(URT0_Mode);
                #if(URT0_Mode4_Spi_Master)
                    #if(URT0_Mode4_Spi_Master_SYSCLK_Clock_Source&&(URT0_Mode4_Clock_Source==0))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode4_Spi_Master_SYSCLK_Clock_Source)
                            #if(URT0_Mode4_Spi_Master_SYSCLK_Clock_Source_for_S0)
                            __DRV_URT0_BaudRateSysclkDiv4_Cmd(URT0_Mode4_Spi_Master_SYSCLK_Clock_Source_SYSCLK);
                            __DRV_URT0_DataOrder_Select(URT0_Mode4_Spi_Master_SYSCLK_Data_Order);
                            #endif
                            #if(URT0_Mode4_Spi_Master_SYSCLK_Baud_Rate_Generator_for_Others)
                            __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode4_Spi_Master_SYSCLK_S0BRG_Baud_Rate_Reload_Count);
                            __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode4_Spi_Master_SYSCLK_S0BRG_Clock_Source_SYSCLK);
                            __DRV_URT0_Baud_Rate_Generator_Clock_Output_Cmd(URT0_Mode4_Spi_Master_SYSCLK_S0BRG_Clock_Output_Control);
                            __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode4_Spi_Master_SYSCLK_S0BRG_Operation);
                            #endif
                        #endif
                    #elif(URT0_Mode4_Spi_Master_S0BRG_Clock_Source&&(URT0_Mode4_Clock_Source==1))
                    __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_S0BRG_RECEIVE_CLOCK_SOURCE_TIMER_S1BRG);
                    __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                    __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                        #if(URT0_Mode4_Spi_Master_S0BRG_Clock_Source)
                        __DRV_URT0_DataOrder_Select(URT0_Mode4_Spi_Master_S0BRG_Data_Order);
                        __DRV_URT0_BaudRateX2_Select(URT0_Mode4_Spi_Master_S0BRG_Baud_Rate);
                        __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode4_Spi_Master_S0BRG_Baud_Rate_Reload_Count);
                        __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode4_Spi_Master_S0BRG_Clock_Source_SYSCLK);
                        __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode4_Spi_Master_S0BRG_S0BRG_Operation);
                        #endif
                    #endif
                #endif
            #elif(URT0_Mode==0x05)
            __DRV_URT0_Mode_Select(URT0_Mode);
                #if(URT0_Mode5_Lin_Bus)
                __DRV_URT0_Clock_Source_S0BRG_Select(TRANSMIT_CLOCK_SOURCE_S0BRG_RECEIVE_CLOCK_SOURCE_S0BRG);
                __DRV_URT0_Clock_Source_Timer2_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_S1BRG_RECEIVE_CLOCK_SOURCE_TIMER1_S1BRG);
                __DRV_URT0_Clock_Source_S1BRG_Select(TRANSMIT_CLOCK_SOURCE_TIMER1_RECEIVE_CLOCK_SOURCE_TIMER1);
                __DRV_URT0_DataOrder_Select(URT0_Mode5_Lin_Bus_S0BRG_Data_Order);
                __DRV_URT0_BaudRateX2_Select(URT0_Mode5_Lin_Bus_S0BRG_Baud_Rate);
                __DRV_URT0_BaudRateReloadReg_Write(URT0_Mode5_Lin_Bus_S0BRG_Baud_Rate_Reload_Count);
                __DRV_URT0_Lin_Bus_BreakLength_Select(URT0_Mode5_Lin_Bus_S0BRG_Break_Length);
                __DRV_URT0_Lin_Bus_TxRx_Select(URT0_Mode5_Lin_Bus_S0BRG_TX_RX_Selection);
                __DRV_URT0_SerialReception_Cmd(URT0_Mode5_Lin_Bus_S0BRG_Reception);
                __DRV_URT0_BaudRateGeneratorClock_Select(URT0_Mode5_Lin_Bus_S0BRG_Clock_Source_SYSCLK);
                __DRV_URT0_BaudRateGenerator_Cmd(URT0_Mode5_Lin_Bus_S0BRG_Operation);
                #endif
            #endif
        #endif
    #endif
    #if(URT0_Easy_Mode&&(!URT0_Option))
        #if(URT0_Easy)
        __DRV_URT0_Easy_Wizard_Init();
        #endif
    #endif
    TI0=1;//for printf application;
}
/// @cond urt0_wizard_option_#endif
#endif
/// @endcond


/// @cond urt1_wizard_option_#if
#if MG82F6D64_UART1_WIZARD
/// @endcond
/**
*******************************************************************************
* @brief       UART1 Initial.
* @details    Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
                DRV_UART1_Wizard_Init();
* @endcode
*******************************************************************************
*/
void DRV_UART1_Wizard_Init(void)
{
#if(URT1_Advance_Mode&&URT1_Option)
    #if(URT1_Advance)
        #if(URT1_Uart_Mode&&(URT1_Uart_Timer_Mode==UART1_UART_MODE))
        __DRV_URT1_TimerMode_Select(UART1_UART_MODE);
            #if(URT1_Mode==UART1_MODE0_SHIFT_REG)
            __DRV_URT1_Mode_Select(URT1_Mode);
                #if(URT1_Mode0_Shift)
                    #if(URT1_Mode0_Shift_SYSCLK_Clock_Source)
                        #if(URT1_Mode0_Shift_SYSCLK_Clock_Source_for_S1)
                        __DRV_URT1_BaudRateSysclkDiv4_Cmd(URT1_Mode0_Shift_SYSCLK_Clock_Source_SYSCLK);
                        __DRV_URT1_DataOrder_Select(URT1_Mode0_Shift_SYSCLK_Data_Order);
                        __DRV_URT1_SerialReception_Cmd(URT1_Mode0_Shift_SYSCLK_Input_Output);
                        #endif
                        #if(URT1_Mode0_Shift_SYSCLK_Baud_Rate_Generator_for_Others)
                        __DRV_URT1_BaudRateReloadReg_Write(URT1_Mode0_Shift_SYSCLK_Baud_Rate_Reload_Count);
                        __DRV_URT1_BaudRateGeneratorClock_Select(URT1_Mode0_Shift_SYSCLK_S1BRG_Clock_Source_SYSCLK);
                        __DRV_URT1_Baud_Rate_Generator_Clock_Output_Cmd(URT1_Mode0_Shift_SYSCLK_Clock_Output_Control);
                        __DRV_URT1_BaudRateGenerator_Cmd(URT1_Mode0_Shift_SYSCLK_S1BRG_Operation);
                        #endif
                    #endif
                #endif
            #elif(URT1_Mode==UART1_MODE1_8BIT)
            __DRV_URT1_Mode_Select(URT1_Mode);
                #if(URT1_Mode1_8Bit)
                    #if(URT1_Mode1_8Bit_S1BRG_Clock_Source)
                        #if(URT1_Mode1_8Bit_Baud_Rate_Generator_for_S1&&(URT1_Mode1_8Bit_Baud_Rate_Generator==0))
                        __DRV_URT1_DataOrder_Select(URT1_Mode1_8Bit_Data_Order_for_S1);
                        __DRV_URT1_BaudRateX2_Select(URT1_Mode1_8Bit_Baud_Rate_for_S1);
                        __DRV_URT1_BaudRateGeneratorClock_Select(URT1_Mode1_8Bit_Clock_Source_for_S1);
                        __DRV_URT1_BaudRateReloadReg_Write(URT1_Mode1_8Bit_Baud_Rate_Reload_Count_for_S1);
                        __DRV_URT1_BaudRateGenerator_Cmd(URT1_Mode1_8Bit_S1BRG_S1BRG_Operation_for_S1);
                        __DRV_URT1_SerialReception_Cmd(URT1_Mode1_8Bit_S1BRG_Reception);
                        #endif
                        #if(URT1_Mode1_8Bit_Baud_Rate_Generator_for_S0&&(URT1_Mode1_8Bit_Baud_Rate_Generator==2))
                        __DRV_URT1_BaudRateReloadReg_Write(URT1_Mode1_8Bit_Baud_Rate_Reload_Count_for_S0);
                        __DRV_URT1_BaudRateGeneratorClock_Select(URT1_Mode1_8Bit_Clock_Source_for_S0);
                        __DRV_URT1_BaudRateGenerator_Cmd(URT1_Mode1_8Bit_S1BRG_S1BRG_Operation_for_S0);
                        #endif
                    #endif
                #endif
            #elif(URT1_Mode==UART1_MODE2_9BIT)
            __DRV_URT1_Mode_Select(URT1_Mode);
                #if(URT1_Mode2_9Bit)
                    #if(URT1_Mode2_9Bit_SYSCLK_Clock_Source)
                        #if(URT1_Mode2_9Bit_SYSCLK_Clock_Source_for_S1)
                        __DRV_URT1_BaudRateX2_Select(URT1_Mode2_9Bit_SYSCLK_Baud_Rate);
                        __DRV_URT1_BaudRateDiv3_Cmd(URT1_Mode2_9Bit_SYSCLK_Clock_Source_SYSCLK);
                        __DRV_URT1_DataOrder_Select(URT1_Mode2_9Bit_SYSCLK_Data_Order);
                        __DRV_URT1_SerialReception_Cmd(URT1_Mode2_9Bit_SYSCLK_Reception);
                        #endif
                        #if(URT1_Mode2_9Bit_SYSCLK_Baud_Rate_Generator_for_Others)
                        __DRV_URT1_BaudRateReloadReg_Write(URT1_Mode2_9Bit_SYSCLK_Baud_Rate_Reload_Count);
                        __DRV_URT1_BaudRateGeneratorClock_Select(URT1_Mode2_9Bit_SYSCLK_S1BRG_Clock_Source_SYSCLK);
                        __DRV_URT1_Baud_Rate_Generator_Clock_Output_Cmd(URT1_Mode2_9Bit_SYSCLK_Clock_Output_Control);
                        __DRV_URT1_BaudRateGenerator_Cmd(URT1_Mode2_9Bit_SYSCLK_S1BRG_Operation);
                        #endif
                    #endif
                #endif
            #elif(URT1_Mode==UART1_MODE3_9BIT)
            __DRV_URT1_Mode_Select(URT1_Mode);
                #if(URT1_Mode3_9Bit)
                    #if(URT1_Mode3_9Bit_S1BRG_Clock_Source)
                        #if(URT1_Mode3_9Bit_Baud_Rate_Generator_for_S1&&(URT1_Mode3_9Bit_Baud_Rate_Generator==0))
                        __DRV_URT1_DataOrder_Select(URT1_Mode3_9Bit_Data_Order_for_S1);
                        __DRV_URT1_BaudRateX2_Select(URT1_Mode3_9Bit_Baud_Rate_for_S1);
                        __DRV_URT1_BaudRateGeneratorClock_Select(URT1_Mode3_9Bit_Clock_Source_for_S1);
                        __DRV_URT1_BaudRateReloadReg_Write(URT1_Mode3_9Bit_Baud_Rate_Reload_Count_for_S1);
                        __DRV_URT1_BaudRateGenerator_Cmd(URT1_Mode3_9Bit_S1BRG_S1BRG_Operation_for_S1);
                        __DRV_URT1_SerialReception_Cmd(URT1_Mode3_9Bit_S1BRG_Reception);
                        #endif
                        #if(URT1_Mode3_9Bit_Baud_Rate_Generator_for_S0&&(URT1_Mode3_9Bit_Baud_Rate_Generator==2))
                        __DRV_URT1_BaudRateReloadReg_Write(URT1_Mode3_9Bit_Baud_Rate_Reload_Count_for_S0);
                        __DRV_URT1_BaudRateGeneratorClock_Select(URT1_Mode3_9Bit_Clock_Source_for_S0);
                        __DRV_URT1_BaudRateGenerator_Cmd(URT1_Mode3_9Bit_S1BRG_S1BRG_Operation_for_S0);
                        #endif
                    #endif
                #endif
            #elif(URT1_Mode==UART1_MODE4_SPI_MASTER)
            __DRV_URT1_Mode_Select(URT1_Mode);
                #if(URT1_Mode4_Spi_Master)
                    #if(URT1_Mode4_Spi_Master_SYSCLK_Clock_Source)
                        #if(URT1_Mode4_Spi_Master_SYSCLK_Clock_Source_for_S1)
                        __DRV_URT1_BaudRateSysclkDiv4_Cmd(URT1_Mode4_Spi_Master_Clock_Source);
                        __DRV_URT1_DataOrder_Select(URT1_Mode4_Spi_Master_Data_Order);
                        #endif
                        #if(URT1_Mode4_Spi_Master_SYSCLK_Baud_Rate_Generator_for_Others)
                        __DRV_URT1_BaudRateReloadReg_Write(URT1_Mode4_Spi_Master_SYSCLK_Baud_Rate_Reload_Count);
                        __DRV_URT1_BaudRateGeneratorClock_Select(URT1_Mode4_Spi_Master_SYSCLK_S1BRG_Clock_Source_SYSCLK);
                        __DRV_URT1_Baud_Rate_Generator_Clock_Output_Cmd(URT1_Mode4_Spi_Master_Clock_Output_Control);
                        __DRV_URT1_BaudRateGenerator_Cmd(URT1_Mode4_Spi_Master_S1BRG_Operation);
                        #endif
                    #endif
                #endif
            #endif
        #endif
        #if(URT1_Timer_Mode&&(URT1_Uart_Timer_Mode==UART1_TIMER_MODE))
        __DRV_URT1_TimerMode_Select(UART1_TIMER_MODE);
            #if(URT1_Timer_Mode_8Bit_Pure_Timer&&(URT1_Timer_Mode_Pure_Timer==UART1_8BIT_PURE_TIMER))
            __DRV_URT1_PureTimer_Select(URT1_Timer_Mode_Pure_Timer);
            __DRV_URT1_Pure_Timer_Clock_Source_Select(URT1_Timer_Mode_8Bit_Pure_Timer_Clock_Source);
            __DRV_URT1_Pure_Timer_Baudrate_Generator_Overflow_to_S1_Interrupt_Cmd(URT1_Timer_Mode_8Bit_Pure_Timer_BRG_Overflow_S1_Interrupt);
            __DRV_URT1_Pure_Timer_External_Pin_Trigger_to_S1_Interrupt_Cmd(URT1_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_S1_Interrupt);
            __DRV_URT1_Pure_Timer_External_Pin_Control_Baudrate_Generator_Cmd(URT1_Timer_Mode_8Bit_Pure_Timer_External_Pin_BRG_Count);
            __DRV_URT1_Pure_Timer_External_Pin_Trigger_Level_Cmd(URT1_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_Level);
            __DRV_URT1_BaudRateReloadReg_Write(URT1_Timer_Mode_8Bit_Pure_Timer_Baud_Rate_Reload_Count);
            __DRV_URT1_Baud_Rate_Generator_Clock_Output_Cmd(URT1_Timer_Mode_8Bit_Pure_Timer_S1BRG_Clock_Output_Control);
            __DRV_URT1_BaudRateGenerator_Cmd(URT1_Timer_Mode_8Bit_Pure_Timer_S1BRG_Operation);
            #endif
            #if(URT1_Timer_Mode_16Bit_Pure_Timer&&(URT1_Timer_Mode_Pure_Timer==UART1_16BIT_PURE_TIMER))
            __DRV_URT1_PureTimer_Select(URT1_Timer_Mode_Pure_Timer);
            __DRV_URT1_Pure_Timer_Clock_Source_Select(URT1_Timer_Mode_16Bit_Pure_Timer_Clock_Source);
            __DRV_URT1_Pure_Timer_Baudrate_Generator_Overflow_to_S1_Interrupt_Cmd(URT1_Timer_Mode_16Bit_Pure_Timer_BRG_Overflow_S1_Interrupt);
            __DRV_URT1_Pure_Timer_External_Pin_Trigger_to_S1_Interrupt_Cmd(URT1_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_S1_Interrupt);
            __DRV_URT1_Pure_Timer_External_Pin_Control_Baudrate_Generator_Cmd(URT1_Timer_Mode_16Bit_Pure_Timer_External_Pin_BRG_Count);
            __DRV_URT1_Pure_Timer_External_Pin_Trigger_Level_Cmd(URT1_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_Level);
            __DRV_URT1_BaudRateReloadReg16Bit_Write(URT1_Timer_Mode_16Bit_Pure_Timer_Baud_Rate_Reload_Count);
            __DRV_URT1_Baud_Rate_Generator_Clock_Output_Cmd(URT1_Timer_Mode_16Bit_Pure_Timer_S1BRG_Clock_Output_Control);
            __DRV_URT1_BaudRateGenerator_Cmd(URT1_Timer_Mode_16Bit_Pure_Timer_S1BRG_Operation);
            #endif
        #endif
    #endif
#endif
#if(URT1_Easy_Mode&&(!URT1_Option))
    #if(URT1_Easy)
    __DRV_URT1_Easy_Wizard_Init();
    #endif
#endif
}
/// @cond urt1_wizard_option_#endif
#endif
/// @endcond


/// @cond URT2_wizard_option_#if
#if MG82F6D64_UART2_WIZARD
/// @endcond
/**
*******************************************************************************
* @brief       UART2 Initial.
* @details    Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
                DRV_UART2_Wizard_Init();
* @endcode
*******************************************************************************
*/
void DRV_UART2_Wizard_Init(void)
{
#if(URT2_Advance_Mode&&URT2_Option)
    #if(URT2_Advance)
        #if(URT2_Uart_Mode&&(URT2_Uart_Timer_Mode==UART2_UART_MODE))
            __DRV_URT2_TimerMode_Select(UART2_UART_MODE);
            #if(URT2_Mode==UART2_MODE0_SHIFT_REG)
                __DRV_URT2_Mode_Select(URT2_Mode);
                #if(URT2_Mode0_Shift)
                    #if(URT2_Mode0_Shift_SYSCLK_Clock_Source)
                        #if(URT2_Mode0_Shift_SYSCLK_Clock_Source_for_S2)
                            __DRV_URT2_BaudRateSysclkDiv4_Cmd(URT2_Mode0_Shift_SYSCLK_Clock_Source_SYSCLK);
                            __DRV_URT2_DataOrder_Select(URT2_Mode0_Shift_SYSCLK_Data_Order);
                            __DRV_URT2_SerialReception_Cmd(URT2_Mode0_Shift_SYSCLK_Input_Output);
                        #endif
                        #if(URT2_Mode0_Shift_SYSCLK_Baud_Rate_Generator_for_Others)
                            __DRV_URT2_BaudRateReloadReg_Write(URT2_Mode0_Shift_SYSCLK_Baud_Rate_Reload_Count);
                            __DRV_URT2_BaudRateGeneratorClock_Select(URT2_Mode0_Shift_SYSCLK_S2BRG_Clock_Source_SYSCLK);
                            __DRV_URT2_Baud_Rate_Generator_Clock_Output_Cmd(URT2_Mode0_Shift_SYSCLK_Clock_Output_Control);
                            __DRV_URT2_BaudRateGenerator_Cmd(URT2_Mode0_Shift_SYSCLK_S2BRG_Operation);
                        #endif
                    #endif
                #endif
            #elif(URT2_Mode==UART2_MODE1_8BIT)
                __DRV_URT2_Mode_Select(URT2_Mode);
                #if(URT2_Mode1_8Bit)
                    #if(URT2_Mode1_8Bit_S2BRG_Clock_Source)
                        __DRV_URT2_DataOrder_Select(URT2_Mode1_8Bit_Data_Order_for_S2);
                        __DRV_URT2_BaudRateX2_Select(URT2_Mode1_8Bit_Baud_Rate_for_S2);
                        __DRV_URT2_BaudRateGeneratorClock_Select(URT2_Mode1_8Bit_Clock_Source_for_S2);
                        __DRV_URT2_BaudRateReloadReg_Write(URT2_Mode1_8Bit_Baud_Rate_Reload_Count_for_S2);
                        __DRV_URT2_BaudRateGenerator_Cmd(URT2_Mode1_8Bit_S2BRG_S2BRG_Operation_for_S2);
                        __DRV_URT2_SerialReception_Cmd(URT2_Mode1_8Bit_S2BRG_Reception);
                    #endif
                #endif
            #elif(URT2_Mode==UART2_MODE2_9BIT)
                __DRV_URT2_Mode_Select(URT2_Mode);
                #if(URT2_Mode2_9Bit)
                    #if(URT2_Mode2_9Bit_SYSCLK_Clock_Source)
                        #if(URT2_Mode2_9Bit_SYSCLK_Clock_Source_for_S2)
                            __DRV_URT2_BaudRateX2_Select(URT2_Mode2_9Bit_SYSCLK_Baud_Rate);
                            __DRV_URT2_BaudRateDiv3_Cmd(URT2_Mode2_9Bit_SYSCLK_Clock_Source_SYSCLK);
                            __DRV_URT2_DataOrder_Select(URT2_Mode2_9Bit_SYSCLK_Data_Order);
                            __DRV_URT2_SerialReception_Cmd(URT2_Mode2_9Bit_SYSCLK_Reception);
                        #endif
                        #if(URT2_Mode2_9Bit_SYSCLK_Baud_Rate_Generator_for_Others)
                            __DRV_URT2_BaudRateReloadReg_Write(URT2_Mode2_9Bit_SYSCLK_Baud_Rate_Reload_Count);
                            __DRV_URT2_BaudRateGeneratorClock_Select(URT2_Mode2_9Bit_SYSCLK_S2BRG_Clock_Source_SYSCLK);
                            __DRV_URT2_Baud_Rate_Generator_Clock_Output_Cmd(URT2_Mode2_9Bit_SYSCLK_Clock_Output_Control);
                            __DRV_URT2_BaudRateGenerator_Cmd(URT2_Mode2_9Bit_SYSCLK_S2BRG_Operation);
                        #endif
                    #endif
                #endif
            #elif(URT2_Mode==UART2_MODE3_9BIT)
                __DRV_URT2_Mode_Select(URT2_Mode);
                #if(URT2_Mode3_9Bit)
                    #if(URT2_Mode3_9Bit_S2BRG_Clock_Source)
                        __DRV_URT2_DataOrder_Select(URT2_Mode3_9Bit_Data_Order_for_S2);
                        __DRV_URT2_BaudRateX2_Select(URT2_Mode3_9Bit_Baud_Rate_for_S2);
                        __DRV_URT2_BaudRateGeneratorClock_Select(URT2_Mode3_9Bit_Clock_Source_for_S2);
                        __DRV_URT2_BaudRateReloadReg_Write(URT2_Mode3_9Bit_Baud_Rate_Reload_Count_for_S2);
                        __DRV_URT2_BaudRateGenerator_Cmd(URT2_Mode3_9Bit_S2BRG_S2BRG_Operation_for_S2);
                        __DRV_URT2_SerialReception_Cmd(URT2_Mode3_9Bit_S2BRG_Reception);
                    #endif
                #endif
            #elif(URT2_Mode==UART2_MODE4_SPI_MASTER)
                __DRV_URT2_Mode_Select(URT2_Mode);
                #if(URT2_Mode4_Spi_Master)
                    #if(URT2_Mode4_Spi_Master_SYSCLK_Clock_Source)
                        #if(URT2_Mode4_Spi_Master_SYSCLK_Clock_Source_for_S2)
                            __DRV_URT2_BaudRateSysclkDiv4_Cmd(URT2_Mode4_Spi_Master_Clock_Source);
                            __DRV_URT2_DataOrder_Select(URT2_Mode4_Spi_Master_Data_Order);
                        #endif
                        #if(URT2_Mode4_Spi_Master_SYSCLK_Baud_Rate_Generator_for_Others)
                            __DRV_URT2_BaudRateReloadReg_Write(URT2_Mode4_Spi_Master_SYSCLK_Baud_Rate_Reload_Count);
                            __DRV_URT2_BaudRateGeneratorClock_Select(URT2_Mode4_Spi_Master_SYSCLK_S2BRG_Clock_Source_SYSCLK);
                            __DRV_URT2_Baud_Rate_Generator_Clock_Output_Cmd(URT2_Mode4_Spi_Master_Clock_Output_Control);
                            __DRV_URT2_BaudRateGenerator_Cmd(URT2_Mode4_Spi_Master_S2BRG_Operation);
                        #endif
                    #endif
                #endif
            #endif
        #endif
        #if(URT2_Timer_Mode&&(URT2_Uart_Timer_Mode==UART2_TIMER_MODE))
            __DRV_URT2_TimerMode_Select(UART2_TIMER_MODE);
            #if(URT2_Timer_Mode_8Bit_Pure_Timer&&(URT2_Timer_Mode_Pure_Timer==UART2_8BIT_PURE_TIMER))
                __DRV_URT2_PureTimer_Select(URT2_Timer_Mode_Pure_Timer);
                __DRV_URT2_Pure_Timer_Clock_Source_Select(URT2_Timer_Mode_8Bit_Pure_Timer_Clock_Source);
                __DRV_URT2_Pure_Timer_Baudrate_Generator_Overflow_to_S2_Interrupt_Cmd(URT2_Timer_Mode_8Bit_Pure_Timer_BRG_Overflow_S2_Interrupt);
                __DRV_URT2_Pure_Timer_External_Pin_Trigger_to_S2_Interrupt_Cmd(URT2_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_S2_Interrupt);
                __DRV_URT2_Pure_Timer_External_Pin_Control_Baudrate_Generator_Cmd(URT2_Timer_Mode_8Bit_Pure_Timer_External_Pin_BRG_Count);
                __DRV_URT2_Pure_Timer_External_Pin_Trigger_Level_Cmd(URT2_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_Level);
                __DRV_URT2_BaudRateReloadReg_Write(URT2_Timer_Mode_8Bit_Pure_Timer_Baud_Rate_Reload_Count);
                __DRV_URT2_Baud_Rate_Generator_Clock_Output_Cmd(URT2_Timer_Mode_8Bit_Pure_Timer_S2BRG_Clock_Output_Control);
                __DRV_URT2_BaudRateGenerator_Cmd(URT2_Timer_Mode_8Bit_Pure_Timer_S2BRG_Operation);
            #endif
            #if(URT2_Timer_Mode_16Bit_Pure_Timer&&(URT2_Timer_Mode_Pure_Timer==UART2_16BIT_PURE_TIMER))
                __DRV_URT2_PureTimer_Select(URT2_Timer_Mode_Pure_Timer);
                __DRV_URT2_Pure_Timer_Clock_Source_Select(URT2_Timer_Mode_16Bit_Pure_Timer_Clock_Source);
                __DRV_URT2_Pure_Timer_Baudrate_Generator_Overflow_to_S2_Interrupt_Cmd(URT2_Timer_Mode_16Bit_Pure_Timer_BRG_Overflow_S2_Interrupt);
                __DRV_URT2_Pure_Timer_External_Pin_Trigger_to_S2_Interrupt_Cmd(URT2_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_S2_Interrupt);
                __DRV_URT2_Pure_Timer_External_Pin_Control_Baudrate_Generator_Cmd(URT2_Timer_Mode_16Bit_Pure_Timer_External_Pin_BRG_Count);
                __DRV_URT2_Pure_Timer_External_Pin_Trigger_Level_Cmd(URT2_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_Level);
                __DRV_URT2_BaudRateReloadReg16Bit_Write(URT2_Timer_Mode_16Bit_Pure_Timer_Baud_Rate_Reload_Count);
                __DRV_URT2_Baud_Rate_Generator_Clock_Output_Cmd(URT2_Timer_Mode_16Bit_Pure_Timer_S2BRG_Clock_Output_Control);
                __DRV_URT2_BaudRateGenerator_Cmd(URT2_Timer_Mode_16Bit_Pure_Timer_S2BRG_Operation);
            #endif
        #endif
    #endif
#endif

#if(URT2_Easy_Mode&&(!URT2_Option))
    #if(URT2_Easy)
    __DRV_URT2_Easy_Wizard_Init();
    #endif
#endif
}
/// @cond URT2_wizard_option_#endif
#endif
/// @endcond


/// @cond URT3_wizard_option_#if
#if MG82F6D64_UART3_WIZARD
/// @endcond
/**
*******************************************************************************
* @brief       UART3 Initial.
* @details    Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
                DRV_UART3_Wizard_Init();
* @endcode
*******************************************************************************
*/
void DRV_UART3_Wizard_Init(void)
{
#if(URT3_Advance_Mode&&URT3_Option)
    #if(URT3_Advance)
        #if(URT3_Uart_Mode&&(URT3_Uart_Timer_Mode==UART3_UART_MODE))
            __DRV_URT3_TimerMode_Select(UART3_UART_MODE);
            #if(URT3_Mode==UART3_MODE0_SHIFT_REG)
                __DRV_URT3_Mode_Select(URT3_Mode);
                #if(URT3_Mode0_Shift)
                    #if(URT3_Mode0_Shift_SYSCLK_Clock_Source)
                        #if(URT3_Mode0_Shift_SYSCLK_Clock_Source_for_S3)
                            __DRV_URT3_BaudRateSysclkDiv4_Cmd(URT3_Mode0_Shift_SYSCLK_Clock_Source_SYSCLK);
                            __DRV_URT3_DataOrder_Select(URT3_Mode0_Shift_SYSCLK_Data_Order);
                            __DRV_URT3_SerialReception_Cmd(URT3_Mode0_Shift_SYSCLK_Input_Output);
                        #endif
                        #if(URT3_Mode0_Shift_SYSCLK_Baud_Rate_Generator_for_Others)
                            __DRV_URT3_BaudRateReloadReg_Write(URT3_Mode0_Shift_SYSCLK_Baud_Rate_Reload_Count);
                            __DRV_URT3_BaudRateGeneratorClock_Select(URT3_Mode0_Shift_SYSCLK_S3BRG_Clock_Source_SYSCLK);
                            __DRV_URT3_Baud_Rate_Generator_Clock_Output_Cmd(URT3_Mode0_Shift_SYSCLK_Clock_Output_Control);
                            __DRV_URT3_BaudRateGenerator_Cmd(URT3_Mode0_Shift_SYSCLK_S3BRG_Operation);
                        #endif
                    #endif
                #endif
            #elif(URT3_Mode==UART3_MODE1_8BIT)
                    __DRV_URT3_Mode_Select(URT3_Mode);
                #if(URT3_Mode1_8Bit)
                    #if(URT3_Mode1_8Bit_S3BRG_Clock_Source)
                        __DRV_URT3_DataOrder_Select(URT3_Mode1_8Bit_Data_Order_for_S3);
                        __DRV_URT3_BaudRateX2_Select(URT3_Mode1_8Bit_Baud_Rate_for_S3);
                        __DRV_URT3_BaudRateGeneratorClock_Select(URT3_Mode1_8Bit_Clock_Source_for_S3);
                        __DRV_URT3_BaudRateReloadReg_Write(URT3_Mode1_8Bit_Baud_Rate_Reload_Count_for_S3);
                        __DRV_URT3_BaudRateGenerator_Cmd(URT3_Mode1_8Bit_S3BRG_S3BRG_Operation_for_S3);
                        __DRV_URT3_SerialReception_Cmd(URT3_Mode1_8Bit_S3BRG_Reception);
                    #endif
                #endif
            #elif(URT3_Mode==UART3_MODE2_9BIT)
                    __DRV_URT3_Mode_Select(URT3_Mode);
                #if(URT3_Mode2_9Bit)
                    #if(URT3_Mode2_9Bit_SYSCLK_Clock_Source)
                        #if(URT3_Mode2_9Bit_SYSCLK_Clock_Source_for_S3)
                            __DRV_URT3_BaudRateX2_Select(URT3_Mode2_9Bit_SYSCLK_Baud_Rate);
                            __DRV_URT3_BaudRateDiv3_Cmd(URT3_Mode2_9Bit_SYSCLK_Clock_Source_SYSCLK);
                            __DRV_URT3_DataOrder_Select(URT3_Mode2_9Bit_SYSCLK_Data_Order);
                            __DRV_URT3_SerialReception_Cmd(URT3_Mode2_9Bit_SYSCLK_Reception);
                        #endif
                        #if(URT3_Mode2_9Bit_SYSCLK_Baud_Rate_Generator_for_Others)
                            __DRV_URT3_BaudRateReloadReg_Write(URT3_Mode2_9Bit_SYSCLK_Baud_Rate_Reload_Count);
                            __DRV_URT3_BaudRateGeneratorClock_Select(URT3_Mode2_9Bit_SYSCLK_S3BRG_Clock_Source_SYSCLK);
                            __DRV_URT3_Baud_Rate_Generator_Clock_Output_Cmd(URT3_Mode2_9Bit_SYSCLK_Clock_Output_Control);
                            __DRV_URT3_BaudRateGenerator_Cmd(URT3_Mode2_9Bit_SYSCLK_S3BRG_Operation);
                        #endif
                    #endif
                #endif
            #elif(URT3_Mode==UART3_MODE3_9BIT)
                    __DRV_URT3_Mode_Select(URT3_Mode);
                #if(URT3_Mode3_9Bit)
                    #if(URT3_Mode3_9Bit_S3BRG_Clock_Source)
                        __DRV_URT3_DataOrder_Select(URT3_Mode3_9Bit_Data_Order_for_S3);
                        __DRV_URT3_BaudRateX2_Select(URT3_Mode3_9Bit_Baud_Rate_for_S3);
                        __DRV_URT3_BaudRateGeneratorClock_Select(URT3_Mode3_9Bit_Clock_Source_for_S3);
                        __DRV_URT3_BaudRateReloadReg_Write(URT3_Mode3_9Bit_Baud_Rate_Reload_Count_for_S3);
                        __DRV_URT3_BaudRateGenerator_Cmd(URT3_Mode3_9Bit_S3BRG_S3BRG_Operation_for_S3);
                        __DRV_URT3_SerialReception_Cmd(URT3_Mode3_9Bit_S3BRG_Reception);
                    #endif
                #endif
            #elif(URT3_Mode==UART3_MODE4_SPI_MASTER)
                __DRV_URT3_Mode_Select(URT3_Mode);
                #if(URT3_Mode4_Spi_Master)
                    #if(URT3_Mode4_Spi_Master_SYSCLK_Clock_Source)
                        #if(URT3_Mode4_Spi_Master_SYSCLK_Clock_Source_for_S3)
                            __DRV_URT3_BaudRateSysclkDiv4_Cmd(URT3_Mode4_Spi_Master_Clock_Source);
                            __DRV_URT3_DataOrder_Select(URT3_Mode4_Spi_Master_Data_Order);
                        #endif
                        #if(URT3_Mode4_Spi_Master_SYSCLK_Baud_Rate_Generator_for_Others)
                            __DRV_URT3_BaudRateReloadReg_Write(URT3_Mode4_Spi_Master_SYSCLK_Baud_Rate_Reload_Count);
                            __DRV_URT3_BaudRateGeneratorClock_Select(URT3_Mode4_Spi_Master_SYSCLK_S3BRG_Clock_Source_SYSCLK);
                            __DRV_URT3_Baud_Rate_Generator_Clock_Output_Cmd(URT3_Mode4_Spi_Master_Clock_Output_Control);
                            __DRV_URT3_BaudRateGenerator_Cmd(URT3_Mode4_Spi_Master_S3BRG_Operation);
                        #endif
                    #endif
                #endif
            #endif
        #endif
        #if(URT3_Timer_Mode&&(URT3_Uart_Timer_Mode==UART3_TIMER_MODE))
                __DRV_URT3_TimerMode_Select(UART3_TIMER_MODE);
            #if(URT3_Timer_Mode_8Bit_Pure_Timer&&(URT3_Timer_Mode_Pure_Timer==UART3_8BIT_PURE_TIMER))
                __DRV_URT3_PureTimer_Select(URT3_Timer_Mode_Pure_Timer);
                __DRV_URT3_Pure_Timer_Clock_Source_Select(URT3_Timer_Mode_8Bit_Pure_Timer_Clock_Source);
                __DRV_URT3_Pure_Timer_Baudrate_Generator_Overflow_to_S3_Interrupt_Cmd(URT3_Timer_Mode_8Bit_Pure_Timer_BRG_Overflow_S3_Interrupt);
                __DRV_URT3_Pure_Timer_External_Pin_Trigger_to_S3_Interrupt_Cmd(URT3_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_S3_Interrupt);
                __DRV_URT3_Pure_Timer_External_Pin_Control_Baudrate_Generator_Cmd(URT3_Timer_Mode_8Bit_Pure_Timer_External_Pin_BRG_Count);
                __DRV_URT3_Pure_Timer_External_Pin_Trigger_Level_Cmd(URT3_Timer_Mode_8Bit_Pure_Timer_External_Pin_Trigger_Level);
                __DRV_URT3_BaudRateReloadReg_Write(URT3_Timer_Mode_8Bit_Pure_Timer_Baud_Rate_Reload_Count);
                __DRV_URT3_Baud_Rate_Generator_Clock_Output_Cmd(URT3_Timer_Mode_8Bit_Pure_Timer_S3BRG_Clock_Output_Control);
                __DRV_URT3_BaudRateGenerator_Cmd(URT3_Timer_Mode_8Bit_Pure_Timer_S3BRG_Operation);
            #endif
            #if(URT3_Timer_Mode_16Bit_Pure_Timer&&(URT3_Timer_Mode_Pure_Timer==UART3_16BIT_PURE_TIMER))
                __DRV_URT3_PureTimer_Select(URT3_Timer_Mode_Pure_Timer);
                __DRV_URT3_Pure_Timer_Clock_Source_Select(URT3_Timer_Mode_16Bit_Pure_Timer_Clock_Source);
                __DRV_URT3_Pure_Timer_Baudrate_Generator_Overflow_to_S3_Interrupt_Cmd(URT3_Timer_Mode_16Bit_Pure_Timer_BRG_Overflow_S3_Interrupt);
                __DRV_URT3_Pure_Timer_External_Pin_Trigger_to_S3_Interrupt_Cmd(URT3_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_S3_Interrupt);
                __DRV_URT3_Pure_Timer_External_Pin_Control_Baudrate_Generator_Cmd(URT3_Timer_Mode_16Bit_Pure_Timer_External_Pin_BRG_Count);
                __DRV_URT3_Pure_Timer_External_Pin_Trigger_Level_Cmd(URT3_Timer_Mode_16Bit_Pure_Timer_External_Pin_Trigger_Level);
                __DRV_URT3_BaudRateReloadReg16Bit_Write(URT3_Timer_Mode_16Bit_Pure_Timer_Baud_Rate_Reload_Count);
                __DRV_URT3_Baud_Rate_Generator_Clock_Output_Cmd(URT3_Timer_Mode_16Bit_Pure_Timer_S3BRG_Clock_Output_Control);
                __DRV_URT3_BaudRateGenerator_Cmd(URT3_Timer_Mode_16Bit_Pure_Timer_S3BRG_Operation);
            #endif
        #endif
    #endif
#endif
#if(URT3_Easy_Mode&&(!URT3_Option))
    #if(URT3_Easy)
    __DRV_URT3_Easy_Wizard_Init();
    #endif
#endif
}
/// @cond URT3_wizard_option_#endif
#endif
/// @endcond


/// @cond spi_wizard_option_#if
#if MG82F6D64_SPI_WIZARD
/// @endcond

/**
*******************************************************************************
* @brief       SPI Wizard Initial.
* @details    Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
                DRV_SPI_Wizard_Init();
* @endcode
*******************************************************************************
*/
void DRV_SPI_Wizard_Init(void)
{
    #if(SPI_Advance_Mode&&SPI_Option)
        #if(SPI_Advance)
            #if(SPI_Connection==0)
            __DRV_SPI_Connection_Select(SPI_Connection);
                #if(SPI_Connection_Typical_SPI)
                    #if(!SPI_Mode_Typical_SPI)
                        #if(SPI_Slave_Mode_Typical_SPI)
                            __DRV_SPI_Mode_Select(SPI_Slave_Mode_Initial_Typical_SPI);
                            __DRV_SPI_Data_Mode_Select(SPI_Slave_Data_Mode_CPOL_CPHA_Typical_SPI);
                            __DRV_SPI_DataOrder_Select(SPI_Slave_Data_Order_Typical_SPI);
                            __DRV_SPI_SPIF_Auto_Cleared_Cmd(SPI_Slave_SPIF_Auto_Cleared_Typical_SPI);
                        #endif
                    #elif(SPI_Mode_Typical_SPI)
                        #if(SPI_Master_Mode_Typical_SPI)
                            __DRV_SPI_Mode_Select(SPI_Master_Mode_Initial_Typical_SPI);
                            __DRV_SPI_Clock_Rate_Select(SPI_Master_Clock_Rate_Config_Typical_SPI);
                            __DRV_SPI_Data_Mode_Select(SPI_Master_Data_Mode_CPOL_CPHA_Typical_SPI);
                            __DRV_SPI_DataOrder_Select(SPI_Master_Data_Order_Typical_SPI);
                            __DRV_SPI_SPIF_Auto_Cleared_Cmd(SPI_Master_SPIF_Auto_Cleared_Typical_SPI);
                        #endif
                    #endif
                #endif
            #elif(SPI_Connection==1)
            __DRV_SPI_Connection_Select(SPI_Connection);
                #if(SPI_Connection_QPI_Mode)
                    #if(!SPI_Mode_QPI_Mode)
                        #if(SPI_Slave_Mode_QPI_Mode)
                            __DRV_SPI_QPI_Data_Output_Cmd(SPI_Mode_QPI_Data_Bus_Control);
                            __DRV_SPI_Mode_Select(SPI_Slave_Mode_Initial_QPI_Mode);
                            __DRV_SPI_Data_Mode_Select(SPI_Slave_Data_Mode_CPOL_CPHA_QPI_Mode);
                            __DRV_SPI_DataOrder_Select(SPI_Slave_Data_Order_QPI_Mode);
                            __DRV_SPI_SPIF_Auto_Cleared_Cmd(SPI_Slave_SPIF_Auto_Cleared_QPI_Mode);
                        #endif
                    #elif(SPI_Mode_QPI_Mode)
                        #if(SPI_Master_Mode_QPI_Mode)
                            __DRV_SPI_QPI_Mode_Cmd(MW_DISABLE);
                            __DRV_SPI_Clock_Rate_Select(SPI_Master_Clock_Rate_Config_QPI_Mode);
                            __DRV_SPI_QPI_Mode_Cmd(MW_ENABLE);
                            __DRV_SPI_QPI_Data_Output_Cmd(SPI_Mode_QPI_Data_Bus_Control);
                            __DRV_SPI_Mode_Select(SPI_Master_Mode_Initial_QPI_Mode);
                            __DRV_SPI_Data_Mode_Select(SPI_Master_Data_Mode_CPOL_CPHA_QPI_Mode);
                            __DRV_SPI_DataOrder_Select(SPI_Master_Data_Order_QPI_Mode);
                            __DRV_SPI_SPIF_Auto_Cleared_Cmd(SPI_Master_SPIF_Auto_Cleared_QPI_Mode);
                        #endif
                    #endif
                #endif
            #elif(SPI_Connection==2)
            __DRV_SPI_Connection_Select(SPI_Connection);
                #if(SPI_Connection_Daisy_Chain)
                    #if(!SPI_Mode_Daisy_Chain)
                        #if(SPI_Slave_Mode_Daisy_Chain)
                            __DRV_SPI_Mode_Select(SPI_Slave_Mode_Initial_Daisy_Chain);
                            __DRV_SPI_Data_Mode_Select(SPI_Slave_Data_Mode_CPOL_CPHA_Daisy_Chain);
                            __DRV_SPI_DataOrder_Select(SPI_Slave_Data_Order_Daisy_Chain);
                            __DRV_SPI_SPIF_Auto_Cleared_Cmd(SPI_Slave_SPIF_Auto_Cleared_Daisy_Chain);
                        #endif
                    #endif
                #endif
            #endif
        #endif
    #endif
    #if(SPI_Easy_Mode&&(!SPI_Option))
        #if(SPI_Easy)
            __DRV_SPI_Easy_Wizard_Init();
        #endif
    #endif
}
/// @cond spi_wizard_option_#endif
#endif
/// @endcond


/**
*******************************************************************************
* @brief       Initializing I2C0 by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
                DRV_I2C0_Wizard_Init();
* @endcode
*******************************************************************************
*/
/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_I2C0_WIZARD
/// @endcond
void DRV_I2C0_Wizard_Init(void)
{
    #if (DRV_I2C0_Wizard_Mode == 1)//Easy Mode
        #if DRV_I2C0_Wizard_Easy_Check
            __DRV_I2C0_ClockRate_Select(DRV_I2C0_Easy_ClockRate_Config);
            __DRV_I2C0_Enable();
        #endif
    #elif (DRV_I2C0_Wizard_Mode == 2)//Advanced Mode
        #if DRV_I2C0_Wizard_Advanced_Check
            #if DRV_I2C0_Master_Mode_En
                __DRV_I2C0_ClockRate_Select(DRV_I2C0_Basic_ClockRate_Config);
                __DRV_I2C0_Enable();
            #elif DRV_I2C0_Slave_Mode_En
                #if DRV_I2C0_General_Call
                    __DRV_I2C0_GC_Enable();
                #endif
                #if DRV_I2C0_Multiple_Slave_Address_En
                    __DRV_I2C0_SetSecondAddress(DRV_I2C0_Second_Slave_Address);
                    __DRV_I2C0_SetSecondAddressMask(DRV_I2C0_Second_Slave_Address_Mask);
                    __DRV_I2C0_SecondAddress_Enable();
                #endif
                __DRV_I2C0_SetSlaveAddress(DRV_I2C0_Slave_Address);
                __DRV_I2C0_SetACK();
                __DRV_I2C0_Enable();
            #endif
        #endif

    #endif
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_I2C0_WIZARD
/// @endcond


/**
*******************************************************************************
* @brief       Initializing I2C1 by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
                DRV_I2C1_Wizard_Init();
* @endcode
*******************************************************************************
*/
/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_I2C1_WIZARD
/// @endcond
void DRV_I2C1_Wizard_Init(void)
{
    #if (DRV_I2C1_Wizard_Mode == 1)//Easy Mode
        #if DRV_I2C1_Wizard_Easy_Check
            __DRV_I2C1_ClockRate_Select(DRV_I2C1_Easy_ClockRate_Config);
            __DRV_I2C1_Enable();
        #endif
    #elif (DRV_I2C1_Wizard_Mode == 2)//Advanced Mode
        #if DRV_I2C1_Wizard_Advanced_Check
            #if DRV_I2C1_Master_Mode_En
                __DRV_I2C1_ClockRate_Select(DRV_I2C1_Basic_ClockRate_Config);
                __DRV_I2C1_Enable();
            #elif DRV_I2C1_Slave_Mode_En
                #if DRV_I2C1_General_Call
                    __DRV_I2C1_GC1_Enable();
                #endif
                #if DRV_I2C1_Multiple_Slave_Address_En
                    __DRV_I2C1_SetSecondAddress(DRV_I2C1_Second_Slave_Address);
                    __DRV_I2C1_SetSecondAddressMask(DRV_I2C1_Second_Slave_Address_Mask);
                    __DRV_I2C1_SecondAddress_Enable();
                #endif
                __DRV_I2C1_SetSlaveAddress(DRV_I2C1_Slave_Address);
                __DRV_I2C1_SetACK();
                __DRV_I2C1_Enable();
            #endif
        #endif

    #endif
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_I2C1_WIZARD
/// @endcond


/**
*******************************************************************************
* @brief       Initializing SI2C by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
                DRV_SI2C_Wizard_Init();
* @endcode
*******************************************************************************
*/
/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_SI2C_WIZARD
/// @endcond
void DRV_SI2C_Wizard_Init(void)
{
    #if (WizDef_SI2C_AF != 0x00)
        __DRV_SI2C_PinMux_Select(WizDef_SI2C_AF);
    #endif
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_SI2C_WIZARD
/// @endcond


/**
*******************************************************************************
* @brief       Beeper Wizard Initialization.
* @details     Config Wizard Option
* @return      None
* @note        None
* @par         Example
* @code
               DRV_BEEPER_Wizard_Init();
* @endcode
*******************************************************************************
*/

/// @cond DRV_BEEPER_Wizard_Init_#if
#if MG82F6D64_BEEPER_WIZARD
/// @endcond

void DRV_BEEPER_Wizard_Init(void)
{
    uint8_t P_data;
    P_data = DRV_PageP_Read(DCON0_P);
    P_data &= ~OCDE_P;
    DRV_PageP_Write(DCON0_P, P_data);
    _push_(SFRPI);
    __DRV_SFR_PageIndex(0);
    P4M0 |= P4M04;
    __DRV_SFR_PageIndex(2);
    P4M1 &=  ~P4M14;
    _pop_(SFRPI);
    __DRV_BEEPER_ModeSelect(AUXR3_BPOCx);

}
/// @cond DRV_BEEPER_Wizard_Init_#if
#endif
/// @endcond


/**
*******************************************************************************
* @brief       Initializing KBI by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
                DRV_KBI_Wizard_Init();
* @endcode
*******************************************************************************
*/
/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_KBI_WIZARD
/// @endcond
void DRV_KBI_Wizard_Init(void)
{
    #if KBI_IT_PATTERN_MATCHING_SELECTION
        __DRV_KBI_PatternMatchingType_Select(KBI_IT_PATTERN_MATCHING_SELECTION);
    #endif
    #if KBI_IT_TRIGGER_TYPE
        __DRV_KBI_TriggerType_Select(KBI_IT_TRIGGER_TYPE);
    #endif
    #if KBI_IT_FILTER_MODE_TYPE
        __DRV_KBI_FilterMode_Select(KBI_IT_FILTER_MODE_TYPE);
    #endif

    KBPATN = KBI_KBPATN_TYPE_SELECT;
    KBMASK = KBI_KBMASK_SELECT;
}
/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_KBI_WIZARD
/// @endcond


/**
*******************************************************************************
* @brief       Initializing ADC by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
               DRV_ADC_Wizard_Init();
* @endcode
*******************************************************************************
*/
/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_ADC_WIZARD
/// @endcond
void DRV_ADC_Wizard_Init(void)
{
    __DRV_ADC_Enable();
    __DRV_ADC_TriggerSource_Select(__ADC_TRG__);
    __DRV_ADC_DataAlignment_Select(__ADC_DATAALIGNMENT__);
    __DRV_ADC_ClockSource_Select(__ADC_CLKS__);
    __DRV_ADC_PinMux_Select(__ADC_CHL__);
    #if __WINDOW_DETECT_EN__
        __DRV_ADC_WindowDetectMode_Select(__ADC_WD_MODE__);
        __DRV_ADC_SetHigherThreshold(__ADC_WD_HB__);
        __DRV_ADC_SetLowerThreshold(__ADC_WD_LB__);
    #endif
    #if __SCAN_LOOP_EN__
        __DRV_ScanLoopChannel_Config(SCAN_LOOP_PIN,MW_ENABLE);
    #endif
    #if __ADC_CHL__ == 0x08
        __DRV_IVREF_Cmd(MW_ENABLE);
    #endif
}

/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_ADC_WIZARD
/// @endcond


/**
*******************************************************************************
* @brief       Initializing AC by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
               DRV_AC_Wizard_Init();
* @endcode
*******************************************************************************
*/

/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_ACx_WIZARD
/// @endcond
void DRV_ACx_Wizard_Init(void)
{
    #if __AC0_CTL__
        #if __AC0_PIS__!=0
            __DRV_AC0_PositivePinMux_Select(__AC0_PIS__);
        #endif
        #if __AC0_NIS__!=0
            __DRV_AC0_NegativePinMux_Select(__AC0_NIS__);
        #endif
        #if __AC0_FLT_EN__
            __DRV_AC0_FilterMode_Select(__AC0_FLT__);
        #endif
        #if __AC0_LP__
            __DRV_AC0_PowerMode_Select(AC_LOW_POWER);
        #endif
        #if __AC0_PD__
            __DRV_AC0_OperationInPD(MW_ENABLE);
        #endif
        #if __AC0_INV__
            __DRV_AC0_OutputInverse_Cmd(MW_ENABLE);
        #endif
        #if __AC0_INTM__
            __DRV_AC0_TriggerType_Select(__AC0_INTM__);
        #endif
        #if __AC0_HYS__==0
            __DRV_AC0_Hysteresis_Cmd(MW_DISABLE);
        #endif
        #if __AC0_OUT__
            __DRV_AC0_Output_Cmd(MW_ENABLE);
        #endif
        __DRV_AC0_Enable();
    #endif
    #if __AC1_CTL__
        #if __AC1_NIS__!=0
            __DRV_AC1_NegativePinMux_Select(__AC1_NIS__);
        #endif
        #if __AC1_FLT_EN__
            __DRV_AC1_FilterMode_Select(__AC1_FLT__);
        #endif
        #if __AC1_LP__
            __DRV_AC1_PowerMode_Select(AC_LOW_POWER);
        #endif
        #if __AC1_PD__
            __DRV_AC1_OperationInPD(MW_ENABLE);
        #endif
        #if __AC1_INV__
            __DRV_AC1_OutputInverse_Cmd(MW_ENABLE);
        #endif
        #if __AC1_INTM__
            __DRV_AC1_TriggerType_Select(__AC1_INTM__);
        #endif
        #if __AC1_HYS__==0
            __DRV_AC1_Hysteresis_Cmd(MW_DISABLE);
        #endif
        #if __AC1_OUT__
            __DRV_AC1_Output_Cmd(MW_ENABLE);
        #endif
        __DRV_AC1_Enable();
    #endif
    #if __AC2_CTL__
        #if __AC2_NIS__!=0
            __DRV_AC2_NegativePinMux_Select(__AC2_NIS__);
        #endif
        #if __AC2_FLT_EN__
            __DRV_AC2_FilterMode_Select(__AC2_FLT__);
        #endif
        #if __AC2_LP__
            __DRV_AC2_PowerMode_Select(AC_LOW_POWER);
        #endif
        #if __AC2_PD__
            __DRV_AC2_OperationInPD(MW_ENABLE);
        #endif
        #if __AC2_INV__
            __DRV_AC2_OutputInverse_Cmd(MW_ENABLE);
        #endif
        #if __AC2_INTM__
            __DRV_AC2_TriggerType_Select(__AC2_INTM__);
        #endif
        #if __AC2_HYS__==0
            __DRV_AC2_Hysteresis_Cmd(MW_DISABLE);
        #endif
        #if __AC2_OUT__
            __DRV_AC2_Output_Cmd(MW_ENABLE);
        #endif
        __DRV_AC2_Enable();
    #endif
    #if( __AC0_NIS__ == 0x08 || __AC1_NIS__ == 0x08 || __AC2_NIS__ == 0x08)
        __DRV_IVREF_Cmd(MW_ENABLE);
    #endif

}

/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_AC_WIZARD
/// @endcond


/**
*******************************************************************************
* @brief       Initializing IAP boundary.
* @details
* @return      None
* @note        None
* @par         Example
* @code
               DRV_IAP_Boundary_Wizard_Init();
* @endcode
*******************************************************************************
*/
/// @cond DRV_IAP_Boundary_Wizard_Init_#if
#if MG82F6D64_IAP_WIZARD
/// @endcond
void DRV_IAP_Boundary_Wizard_Init(void)
{
    DRV_PageP_Write(IAPLB_P, IAP_BOUNDARY);
}
/// @cond DRV_IAP_Boundary_Wizard_Init_#if
#endif
/// @endcond


/**
*******************************************************************************
* @brief       Initializing all interrupts by wizard option.
* @details
* @return      None
* @note        None
* @par         Example
* @code
                DRV_INT_Wizard_Init();
* @endcode
*******************************************************************************
*/
/// @cond __DRV_Wizard_Without_Doxygen
#if MG82F6D64_INT_ALL_WIZARD
/// @endcond
void DRV_INT_Wizard_Init(void)
{
    //***Check Module Interrupt function Turn on/off***************************
    #if (MG82F6D64_INT0_EN)
        #if MG82F6D64_INT0_PRIORITY
            __DRV_INT0_Priority_Select(MG82F6D64_INT0_PRIORITY);
        #endif
        #if nINT0_TRIGGER_TYPE
            __DRV_INT0_TriggerType_Select(nINT0_TRIGGER_TYPE);
        #endif
        #if nINT0_FILTER_MODE_TYPE
            __DRV_INT0_FilterMode_Select(nINT0_FILTER_MODE_TYPE);
        #endif
        #if (MG82F6D64_INT0_VECTOR_CONFIG == 2)
            __DRV_INT0_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_INT1_EN)
        #if MG82F6D64_INT1_PRIORITY
            __DRV_INT1_Priority_Select(MG82F6D64_INT1_PRIORITY);
        #endif
        #if nINT1_TRIGGER_TYPE
            __DRV_INT1_TriggerType_Select(nINT1_TRIGGER_TYPE);
        #endif
        #if nINT1_FILTER_MODE_TYPE
            __DRV_INT1_FilterMode_Select(nINT1_FILTER_MODE_TYPE);
        #endif
        #if (MG82F6D64_INT1_VECTOR_CONFIG == 2)
            __DRV_INT1_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_INT2_EN)
        #if MG82F6D64_INT2_PRIORITY
            __DRV_INT2_Priority_Select(MG82F6D64_INT2_PRIORITY);
        #endif
        #if nINT2_TRIGGER_TYPE
            __DRV_INT2_TriggerType_Select(nINT2_TRIGGER_TYPE);
        #endif
        #if nINT2_FILTER_MODE_TYPE
            __DRV_INT2_FilterMode_Select(nINT2_FILTER_MODE_TYPE);
        #endif
        #if (MG82F6D64_INT2_VECTOR_CONFIG == 2)
            __DRV_INT2_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_INT3_EN)
        #if MG82F6D64_INT3_PRIORITY
            __DRV_INT3_Priority_Select(MG82F6D64_INT3_PRIORITY);
        #endif
        #if nINT3_TRIGGER_TYPE
            __DRV_INT3_TriggerType_Select(nINT3_TRIGGER_TYPE);
        #endif
        #if nINT3_FILTER_MODE_TYPE
            __DRV_INT3_FilterMode_Select(nINT3_FILTER_MODE_TYPE);
        #endif
        #if (MG82F6D64_INT3_VECTOR_CONFIG == 2)
            __DRV_INT3_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_TIMER0_IT_EN)
        #if MG82F6D64_TIMER0_IT_PRIORITY
            __DRV_INT_Timer0_Priority_Select(MG82F6D64_TIMER0_IT_PRIORITY);
        #endif
        #if (MG82F6D64_TIMER0_IT_VECTOR_CONFIG == 2)
            __DRV_TIMER0_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_TIMER1_IT_EN)
        #if MG82F6D64_TIMER1_IT_PRIORITY
            __DRV_INT_Timer1_Priority_Select(MG82F6D64_TIMER1_IT_PRIORITY);
        #endif
        #if (MG82F6D64_TIMER1_IT_VECTOR_CONFIG == 2)
            __DRV_TIMER1_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_TIMER2_IT_EN)
        #if MG82F6D64_TIMER2_IT_PRIORITY
            __DRV_INT_Timer2_Priority_Select(MG82F6D64_TIMER2_IT_PRIORITY);
        #endif
        #if (MG82F6D64_TIMER2_IT_TF2L_EN)
            __DRV_TIMER2_TF2L_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_TIMER2_IT_VECTOR_CONFIG == 2)
            __DRV_TIMER2_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_TIMER3_IT_EN)
        #if MG82F6D64_TIMER3_IT_PRIORITY
            __DRV_INT_Timer3_Priority_Select(MG82F6D64_TIMER3_IT_PRIORITY);
        #endif
        #if (MG82F6D64_TIMER3_IT_TF3L_EN)
            __DRV_TIMER3_TF3L_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_TIMER3_IT_VECTOR_CONFIG == 2)
            __DRV_TIMER3_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_TIMER4_IT_EN)
        #if MG82F6D64_TIMER4_IT_PRIORITY
            __DRV_INT_Timer4_Priority_Select(MG82F6D64_TIMER4_IT_PRIORITY);
        #endif
        #if (MG82F6D64_TIMER4_IT_TF4L_EN)
            __DRV_TIMER4_TF4L_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_TIMER4_IT_VECTOR_CONFIG == 2)
            __DRV_TIMER4_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_S0_IT_EN)
        #if MG82F6D64_S0_IT_PRIORITY
            __DRV_INT_S0_Priority_Select(MG82F6D64_S0_IT_PRIORITY);
        #endif
        #if (MG82F6D64_S0_IT_VECTOR_CONFIG == 2)
            __DRV_URT0_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_S1_IT_EN)
        #if MG82F6D64_S1_IT_PRIORITY
            __DRV_INT_S1_Priority_Select(MG82F6D64_S1_IT_PRIORITY);
        #endif
        #if (MG82F6D64_S1_IT_VECTOR_CONFIG == 2)
            __DRV_URT1_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_S2_IT_EN)
        #if MG82F6D64_S2_IT_PRIORITY
            __DRV_INT_S2_Priority_Select(MG82F6D64_S2_IT_PRIORITY);
        #endif
        #if (MG82F6D64_S2_IT_VECTOR_CONFIG == 2)
            __DRV_URT2_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_S3_IT_EN)
        #if MG82F6D64_S3_IT_PRIORITY
            __DRV_INT_S3_Priority_Select(MG82F6D64_S3_IT_PRIORITY);
        #endif
        #if (MG82F6D64_S3_IT_VECTOR_CONFIG == 2)
            __DRV_URT3_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_ADC_IT_EN)
        #if MG82F6D64_ADC_IT_PRIORITY
            __DRV_INT_ADC_Priority_Select(MG82F6D64_ADC_IT_PRIORITY);
        #endif
        #if (MG82F6D64_ADC_IT_ADCI_EN == MW_DISABLE)
            __DRV_ADC_IgnoreADCI_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_ADC_IT_SMPF_EN)
            __DRV_ADC_SampleFlag_IT(MW_ENABLE);
        #endif
        #if (MG82F6D64_ADC_IT_ADCWI_EN)
            __DRV_ADC_WindowDetect_IT(MW_ENABLE);
        #endif
        #if (MG82F6D64_ADC_IT_VECTOR_CONFIG == 2)
            __DRV_ADC_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_AC0_IT_EN)
        #if MG82F6D64_AC0_IT_PRIORITY
            __DRV_INT_AC0_Priority_Select(MG82F6D64_AC0_IT_PRIORITY);
        #endif
        #if (MG82F6D64_AC0_IT_VECTOR_CONFIG == 2)
            __DRV_AC0_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_AC1_IT_EN)
        #if MG82F6D64_AC1_IT_PRIORITY
            __DRV_INT_AC1_Priority_Select(MG82F6D64_AC1_IT_PRIORITY);
        #endif
        #if (MG82F6D64_AC1_IT_VECTOR_CONFIG == 2)
            __DRV_AC1_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_AC2_IT_EN)
        #if MG82F6D64_AC2_IT_PRIORITY
            __DRV_INT_AC2_Priority_Select(MG82F6D64_AC2_IT_PRIORITY);
        #endif
        #if (MG82F6D64_AC2_IT_VECTOR_CONFIG == 2)
            __DRV_AC2_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_PCA_IT_EN)
        #if MG82F6D64_PCA_IT_PRIORITY
            __DRV_INT_PCA_Priority_Select(MG82F6D64_PCA_IT_PRIORITY);
        #endif
        #if (MG82F6D64_PCA_IT_COUNTER_EN)
            __DRV_PCA_Counter_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_PCA_IT_MODULE0_EN)
            __DRV_PCA_Module0_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_PCA_IT_MODULE1_EN)
            __DRV_PCA_Module1_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_PCA_IT_MODULE2_EN)
            __DRV_PCA_Module2_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_PCA_IT_MODULE3_EN)
            __DRV_PCA_Module3_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_PCA_IT_MODULE4_EN)
            __DRV_PCA_Module4_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_PCA_IT_MODULE5_EN)
            __DRV_PCA_Module5_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_PCA_IT_MODULE6_EN)
            __DRV_PCA_Module6_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_PCA_IT_MODULE7_EN)
            __DRV_PCA_Module7_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_PCA_IT_VECTOR_CONFIG == 2)
            __DRV_PCA_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_SYSFLAG_EN)
        #if MG82F6D64_SYSFLAG_IT_PRIORITY
            __DRV_INT_SYSFLAG_Priority_Select(MG82F6D64_SYSFLAG_IT_PRIORITY);
        #endif
        #if (MG82F6D64_WDT_IT_EN)
            __DRV_WDT_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_RTC_IT_EN)
            __DRV_RTC_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_BOD0_IT_EN)
            __DRV_BODx_BOD0_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_BOD1_IT_EN)
            __DRV_BODx_BOD1_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_SI2C_IT_EN)
            __DRV_SI2C_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_SYSFLAG_IT_VECTOR_CONFIG == 2)
            __DRV_INT_SystemFlag_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_KBI_IT_EN)
        #if MG82F6D64_KBI_IT_PRIORITY
            __DRV_INT_KBI_Priority_Select(MG82F6D64_KBI_IT_PRIORITY);
        #endif
        #if (MG82F6D64_KBI_IT_VECTOR_CONFIG == 2)
            __DRV_KBI_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_SPI_IT_EN)
        #if MG82F6D64_SPI_IT_PRIORITY
            __DRV_INT_SPI_Priority_Select(MG82F6D64_SPI_IT_PRIORITY);
        #endif
        #if (MG82F6D64_SPI_IT_VECTOR_CONFIG == 2)
            __DRV_SPI_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_I2C0_IT_EN)
        #if MG82F6D64_I2C0_IT_PRIORITY
            __DRV_INT_I2C0_Priority_Select(MG82F6D64_I2C0_IT_PRIORITY);
        #endif
        #if (MG82F6D64_I2C0_IT_VECTOR_CONFIG == 2)
            __DRV_I2C0_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_I2C1_IT_EN)
        #if MG82F6D64_I2C1_IT_PRIORITY
            __DRV_INT_I2C1_Priority_Select(MG82F6D64_I2C1_IT_PRIORITY);
        #endif
        #if (MG82F6D64_I2C1_IT_VECTOR_CONFIG == 2)
            __DRV_I2C1_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //*************************************************************************
    #if (MG82F6D64_DMA_IT_EN)
        #if MG82F6D64_DMA_IT_PRIORITY
            __DRV_INT_DMA_Priority_Select(MG82F6D64_DMA_IT_PRIORITY);
        #endif
        #if (MG82F6D64_DMA_DCF0_IT_EN)
            __DRV_DMA_DCF0_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_DMA_TIMER5_IT_EN)
            __DRV_TIMER5_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_DMA_TIMER6_IT_EN)
            __DRV_TIMER6_IT_Cmd(MW_ENABLE);
        #endif
        #if (MG82F6D64_DMA_IT_VECTOR_CONFIG == 2)
            __DRV_DMA_IT_Cmd(MW_ENABLE);
        #endif
    #endif
    //**************************************************************************
    #if MG82F6D64_INT_GLOBAL_EN
        __DRV_INT_ITEA_Enable();    //Global Interrupt Enable
    #endif
}

/// @cond __DRV_Wizard_Without_Doxygen
#endif  //MG82F6D64_INT_ALL_WIZARD
/// @endcond


/**
 *******************************************************************************
 * @brief       System_Init function can initialize each driver.
 * @details
 * @return      None.
 * @note
 * @par Example
 * @code
 *              System_Wizard_Init();
 * @endcode
 *******************************************************************************
 */

void System_Wizard_Init(void)
{
    //Ch14. GPIO
    #if MG82F6D64_GPIO_WIZARD
        DRV_GPIO_Wizard_Init();
    #endif

    //Ch9. System Clock
    #if MG82F6D64_CLK_WIZARD
        DRV_CLK_Wizard_Init();
    #endif

    //Ch6. External data Memory Bus (EMB)
    #if MG82F6D64_EMB_WIZARD
        DRV_EMB_Wizard_Init();
    #endif

    //Ch8. DMA
    #if MG82F6D64_DMA_WIZARD
        DRV_DMA_Wizard_Init();
    #endif

    //Ch10. WDT
    #if MG82F6D64_WDT_WIZARD
        DRV_WDT_Wizard_Init();
    #endif

    //Ch11. RTC
    #if MG82F6D64_RTC_WIZARD
        DRV_RTC_Wizard_Init();
    #endif

    //Ch12. System Reset

    //Ch13. Power Management
    #if MG82F6D64_PW_WIZARD
        #if MG82F6D64_BODx_WIZARD
            DRV_PW_BODx_Wizard_Init();
        #endif
    #endif

    //Ch15. Interrupt -> Move to END

    //Ch16. Timers/Counters
    #if MG82F6D64_TIMER_WIZARD
        DRV_TIMER_Wizard_Init();
    #endif

    //Ch17. PCA
    #if MG82F6D64_PCA_WIZARD
        DRV_PCA_Wizard_Init();
    #endif

    //Ch18. SerialPort0
    #if MG82F6D64_UART0_WIZARD
        DRV_UART0_Wizard_Init();
    #endif

    //Ch19. SerialPort1
    #if MG82F6D64_UART1_WIZARD
        DRV_UART1_Wizard_Init();
    #endif

    //Ch20. SerialPort2
    #if MG82F6D64_UART2_WIZARD
        DRV_UART2_Wizard_Init();
    #endif

    //Ch21. SerialPort3
    #if MG82F6D64_UART3_WIZARD
        DRV_UART3_Wizard_Init();
    #endif

    //Ch22. SPI
    #if MG82F6D64_SPI_WIZARD
        DRV_SPI_Wizard_Init();
    #endif

    //Ch23. TWI0/I2C0
    #if MG82F6D64_I2C0_WIZARD
        DRV_I2C0_Wizard_Init();
    #endif

    //Ch23. TWI1/I2C1
    #if MG82F6D64_I2C1_WIZARD
        DRV_I2C1_Wizard_Init();
    #endif

    //Ch24. STWI/SI2C
    #if MG82F6D64_SI2C_WIZARD
        DRV_SI2C_Wizard_Init();
    #endif

    //Ch25. Beeper
    #if MG82F6D64_BEEPER_WIZARD
        DRV_BEEPER_Wizard_Init();
    #endif

    //Ch26. KBI
    #if MG82F6D64_KBI_WIZARD
        DRV_KBI_Wizard_Init();
    #endif

    //Ch27. GPL

    //Ch29. ADC
    #if MG82F6D64_ADC_WIZARD
        DRV_ADC_Wizard_Init();
    #endif

    //Ch30. ACx
    #if MG82F6D64_ACx_WIZARD
        DRV_ACx_Wizard_Init();
    #endif

    //Ch32. IAP
    #if MG82F6D64_IAP_WIZARD
       DRV_IAP_Boundary_Wizard_Init();
    #endif

    //Ch15. Interrupt
    #if MG82F6D64_INT_ALL_WIZARD
        DRV_INT_Wizard_Init();
    #endif
}

