
//<<< Use Configuration Wizard in Context Menu >>>

// <h> MCU parameter
//	<o0> MCU system clock source (Hz) <0L-32000000L>
//	<o1> sysclk / n  | n= <0-128>
// </h>
#define SYSCLK 24000000
#define TX_DIV 12


// <h> motor parameter
//	<o0> number poles (n ﷥) <0-20>
//  <o1> Max desired speed <0-10000>
//  <o2> Min desired speed <150-10000>
//  <o3> offset of synchrounization Hall signal <0-50>
// </h>

#define NUM_POLES       2			// motor poles
#define MAX_RPM         1430        // max desired speed
#define MIN_RPM         800         // max desired speed
#define IDXOffset       15

// <h> motor startup parameter
//  <o0> initiail duty <1-1024>    
//  <o1> commutate peroid <0-65535>
//  <o2> commutate count <1-100>
//  <o3> detect limit speed (RPM) <60-200>
// </h>
#define INIT_DUTY       150             
#define C_Peroid        25000
#define C_Count         20
#define L_LowSpeed      100

//<<< end of configuration section >>>

//-----------------------------------------------------------------------------
// preprocessor calculated values
#define T_MAX_RPM       0 - (60 * SYSCLK / MAX_RPM / 6 / NUM_POLES / 32)
#define T_MIN_RPM       0 - (60 * SYSCLK / MIN_RPM / 6 / NUM_POLES / 32)
#define CalRPMTBase     SYSCLK * 60 / 32 / 6 /  NUM_POLES
#define LimitDetectRPM  (60 / 6) * 1000 / L_LowSpeed / NUM_POLES
//-----------------------------------------------------------------------------
// preprocessor error checking
// These macros check for range errors on user modifiable parameters

#define FORWARD 0
#define REVERSE 1


