

//-----------------------------------------------------------------------------
// constants
//-----------------------------------------------------------------------------
#define CLR                 0

// declare motor state
#define IDLE                0x60
#define STUCK               0x61
#define HallError           0x62
#define STARTFAIL           0x67
#define Normal_RUN          0x68
#define STARTUP             0x69

// declare PID state
#define PID_WAIT_Time       0x80
#define PID_Cal_Verror      0x81
#define PID_Cal_Kp          0x82
#define PID_Cal_Ki          0x83
#define PID_Cal_Kd          0x84
#define PID_Cal_sum         0x85
#define PID_WAIT_STABLE     0x86

// declare Generate sinewave table's state
#define GSS_idle            0xA0
#define GSS_loadbase        0xA1
#define GSS_Mduty           0xA2
#define GSS_Div1000         0xA3
#define GSS_WriteTable      0xA4

// declare ADC's state
#define ADCIDLE         0x50
#define ADCSample1      0x51
#define ADCSample2      0x52
#define ADCSearchIndex  0x54
#define ADCReplaceTRPM  0x55

//-----------------------------------------------------------------------------
// declare function name
//-----------------------------------------------------------------------------
#define NoOperation     0x00

//-----------------------------------------------------------------------------
// Function PROTOTYPES
//-----------------------------------------------------------------------------
// in hardio.c
extern void disable_PCA (void);
extern void Port_Init ();
extern void PCA_Init ();
extern void PLL24MHz (void);
extern void MotorRotate (void);

// in KBIISR.c
extern void SetupKeypadPattern (void);

// in Gen_sinewave.c
extern void initial_SineWavePWM (U16 level);
extern void PrepareSineWaveDuty (void);

// in ADC.c
extern void ADC_init (void);
extern void ADC_SpeedSample (void);

// in T2ISR.c
extern void Timer2_init (void);

// in T0ISR.c
extern void Timer0_Init (void);

// in T1ISR.c
extern void Timer1_Init (void);

// in PWM.c
extern void Startup_PWMOutput ();
extern void PWMOutput (void);
extern void SineWaveStartup (void);
extern void SynchronizationUVW (void);
