
/*
    
*/

//#include "REG_FA206.H"
#include "REG_MG82F6D17.H"
#include "typedef.h"
#include "config.h"
#include "motor_parameter.h"
#include <math.h>

extern U16 CurrRPM;                 // the current speed (RPM)
extern U16 TargetRPM;

static U8 ADCState;

code U16 SVRV [] = { 80, 200, 300, 400, 500,   // sample V.R value
                     600, 700, 800, 900, 1000};

code U16 TRPMT [] = {  0, 900, 1000, 1100, 1200, 1300,  // target RPM table 
                     1400, 1500, 1550, 1600, 1650};
//-----------------------------------------------------------------------------
// ADC init
//-----------------------------------------------------------------------------
void ADC_init (void)
{
//5B32    ADCON0 = ADCEN | CHS2 | CHS1 | CHS0;
//5B32    P1AIO |= 0x80;
    ADCON0 = ADCEN;
    ADCFG0 = ADCKS1 | ADCKS0 | ADRJ;
    ADCState = ADCIDLE;
}

//-----------------------------------------------------------------------------
// ADC sample - speed control
//-----------------------------------------------------------------------------
void ADC_SpeedSample (void)
{
    static WTYPE Avg;
    static U8 idx;
    U16 ADCTemp;

    switch (ADCState) {
    case ADCIDLE:
        // first sample 
//5B32        ADCON0 = ADCEN | CHS2 | CHS1 | CHS0 | ADCS; // start conversion   
        ADCON0 = ADCEN | ADCS;
        ADCState = ADCSample1;
        break;
    case ADCSample1:
        if ((ADCON0 & ADCI) == 0x00) break;
//5B32        Avg.B[0] = ADCDH & 0x03;
        Avg.B[0] = ADCDH & 0x0F;
        Avg.B[1] = ADCDL;
//5B32        ADCON0 = ADCEN | CHS2 | CHS1 | CHS0 | ADCS; // start conversion  
        ADCON0 = ADCEN | ADCS;
        ADCState = ADCSample2;
        break;
    case ADCSample2:
        if ((ADCON0 & ADCI) == 0x00) break;
//5B32        ADCON0 = ADCEN | CHS2 | CHS1 | CHS0;        // ADCON0 &= ~(ADCS |  ADCI);
        ADCON0 = ADCEN;
        ADCTemp = Avg.W;
//5B32        Avg.B[0] = ADCDH & 0x03;
        Avg.B[0] = ADCDH & 0x0F;
        Avg.B[1] = ADCDL;
        Avg.W += ADCTemp;
//5B32        Avg.W = Avg.W >> 1;
        Avg.W = Avg.W >> 3;
        ADCState = ADCSearchIndex;
        idx = 0;
        break;
    case ADCSearchIndex:
        if ((SVRV [idx]-20) > Avg.W) {              // hystersis window
            if (SVRV [idx] > Avg.W) {
                ADCState = ADCReplaceTRPM; 
                break;
            }
        }
        idx ++;
        if (idx == 10) ADCState = ADCReplaceTRPM;    
        break;
    case ADCReplaceTRPM:
        if (TargetRPM != TRPMT [idx]) {
            TargetRPM = TRPMT [idx];
        }
        ADCState = ADCIDLE;
        break;
    default:
        ADCState = ADCIDLE;
        break;
    }
    
    
}



