/**
 * @file    tim2_encoder.c
 * @author  MegawinTech Application Team
 * @version V1.0.3
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _TIM2_ENCODER_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "tim2_encoder.h"

/**
  * @addtogroup MG32F005_LibSamples
  * @{
  */

/**
  * @addtogroup TIM2
  * @{
  */

/**
  * @addtogroup TIM2_Encoder
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void SimulateEncoder_Configure(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;

    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);
    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOB, ENABLE);

    /* K3->PA15 */
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin  = GPIO_Pin_15;
    GPIO_InitStruct.GPIO_Mode = GPIO_Mode_IPU;
    GPIO_Init(GPIOA, &GPIO_InitStruct);

    /* K4->PB2 */
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin  = GPIO_Pin_2;
    GPIO_InitStruct.GPIO_Mode = GPIO_Mode_IPU;
    GPIO_Init(GPIOB, &GPIO_InitStruct);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void TIM2_Configure(void)
{
    GPIO_InitTypeDef        GPIO_InitStruct;
    TIM_ICInitTypeDef       TIM_ICInitStruct;
    TIM_TimeBaseInitTypeDef TIM_TimeBaseInitStruct;

    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

    GPIO_PinAFConfig(GPIOA, GPIO_PinSource6, GPIO_AF_0);    /* TIM2_CH1 */
    GPIO_PinAFConfig(GPIOA, GPIO_PinSource7, GPIO_AF_0);    /* TIM2_CH2 */

    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin   = GPIO_Pin_6 | GPIO_Pin_7;
    GPIO_InitStruct.GPIO_Speed = GPIO_Speed_High;
    GPIO_InitStruct.GPIO_Mode  = GPIO_Mode_IPU;
    GPIO_Init(GPIOA, &GPIO_InitStruct);

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2, ENABLE);

    TIM_TimeBaseStructInit(&TIM_TimeBaseInitStruct);
    TIM_TimeBaseInitStruct.TIM_Prescaler = 0;
    TIM_TimeBaseInitStruct.TIM_Period    = 0xFFFFFFFF;
    TIM_TimeBaseInit(TIM2, &TIM_TimeBaseInitStruct);

    TIM_EncoderInterfaceConfig(TIM2, TIM_EncoderMode_TI1, TIM_ICPolarity_Falling, TIM_ICPolarity_Falling);
//    TIM_EncoderInterfaceConfig(TIM2, TIM_EncoderMode_TI2, TIM_ICPolarity_Falling, TIM_ICPolarity_Falling);
//    TIM_EncoderInterfaceConfig(TIM2, TIM_EncoderMode_TI12, TIM_ICPolarity_Falling, TIM_ICPolarity_Falling);

    TIM_ICStructInit(&TIM_ICInitStruct);
    TIM_ICInitStruct.TIM_Channel  = TIM_Channel_1;
    TIM_ICInitStruct.TIM_ICFilter = 6;
    TIM_ICInit(TIM2, &TIM_ICInitStruct);

    TIM_SetCounter(TIM2, 0);

    TIM_Cmd(TIM2, ENABLE);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void TIM2_Encoder_Sample(void)
{
    static uint32_t OldCount = 0;
    static uint32_t NewCount = 0;
    static uint8_t Direction = 0;

    FunctionalState SimulateEncoder = DISABLE;

    if (ENABLE == SimulateEncoder)
    {
        /* LED1 & LED2 : simulate encoder output, K3 & K4 control encoder output direction */
        SimulateEncoder_Configure();

        while (1)
        {
            if (Bit_RESET == GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_15))
            {
                Direction = 0;

                PLATFORM_LED_Enable(LED1, ENABLE);
                PLATFORM_DelayMS(50);

                PLATFORM_LED_Enable(LED2, ENABLE);
                PLATFORM_DelayMS(50);

                PLATFORM_LED_Enable(LED1, DISABLE);
                PLATFORM_DelayMS(50);

                PLATFORM_LED_Enable(LED2, DISABLE);
                PLATFORM_DelayMS(50);
            }
            else if (Bit_RESET == GPIO_ReadInputDataBit(GPIOB, GPIO_Pin_2))
            {
                Direction = 1;

                PLATFORM_LED_Enable(LED2, ENABLE);
                PLATFORM_DelayMS(50);

                PLATFORM_LED_Enable(LED1, ENABLE);
                PLATFORM_DelayMS(50);

                PLATFORM_LED_Enable(LED2, DISABLE);
                PLATFORM_DelayMS(50);

                PLATFORM_LED_Enable(LED1, DISABLE);
                PLATFORM_DelayMS(50);
            }
            else
            {
                if (0 == Direction)
                {
                    PLATFORM_LED_Enable(LED1, ENABLE);
                    PLATFORM_LED_Enable(LED2, ENABLE);
                }
                else
                {
                    PLATFORM_LED_Enable(LED2, ENABLE);
                    PLATFORM_LED_Enable(LED1, ENABLE);
                }
            }
        }
    }
    else
    {
        printf("\r\nTest %s", __FUNCTION__);

        /* PA6 & PA7 : encoder A & B channel */
        TIM2_Configure();

        while (1)
        {
            NewCount = TIM_GetCounter(TIM2);

            if (NewCount != OldCount)
            {
                OldCount = NewCount;

                printf("\r\nDIR : %d, CNT : 0x%08x", TIM_GetCountDirection(TIM2), NewCount);
            }
        }
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

