/**
 * @file    adc_internaltemperaturesensor.c
 * @author  MegawinTech Application Team
 * @version V1.0.3
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _ADC_INTERNALTEMPERATURESENSOR_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "adc_internaltemperaturesensor.h"

/**
  * @addtogroup MG32F005_LibSamples
  * @{
  */

/**
  * @addtogroup ADC
  * @{
  */

/**
  * @addtogroup ADC_InternalTemperatureSensor
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/
#define  AVG_SLOPE  (-3.98)

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void ADC_Configure(void)
{
    ADC_InitTypeDef  ADC_InitStructure;

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_ADC1, ENABLE);

    ADC_StructInit(&ADC_InitStructure);
    ADC_InitStructure.ADC_Resolution = ADC_Resolution_12b;
    ADC_InitStructure.ADC_Prescaler  = ADC_Prescaler_16;
    ADC_InitStructure.ADC_Mode       = ADC_Mode_Imm;
    ADC_InitStructure.ADC_DataAlign  = ADC_DataAlign_Right;
    ADC_Init(ADC1, &ADC_InitStructure);

    ADC_SampleTimeConfig(ADC1, ADC_Channel_VoltTempSensor, ADC_SampleTime_240_5);

    ADC_ChannelCmd(ADC1, ADC_Channel_VoltTempSensor, ENABLE);

    ADC_Cmd(ADC1, ENABLE);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
uint16_t ADC_ReadTemperatureSensorValue(void)
{
    uint16_t Value;

    ADC_TempSensorCmd(ENABLE);

    ADC_SoftwareStartConvCmd(ADC1, ENABLE);

    while (RESET == ADC_GetFlagStatus(ADC1, ADC_FLAG_EOS))
    {
    }

    ADC_ClearFlag(ADC1, ADC_FLAG_EOS);

    Value = ADC_GetChannelConvertedValue(ADC1, ADC_Channel_VoltTempSensor);

    ADC_TempSensorCmd(DISABLE);

    return (Value);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
uint16_t ADC_ReadVoltageSensorValue(void)
{
    uint16_t Value;

    ADC_VrefSensorCmd(ENABLE);

    ADC_SoftwareStartConvCmd(ADC1, ENABLE);

    while (RESET == ADC_GetFlagStatus(ADC1, ADC_FLAG_EOS))
    {
    }

    ADC_ClearFlag(ADC1, ADC_FLAG_EOS);

    Value = ADC_GetChannelConvertedValue(ADC1, ADC_Channel_VoltTempSensor);

    ADC_VrefSensorCmd(DISABLE);

    return (Value);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void ADC_InternalTemperatureSensor_Sample(void)
{
    uint16_t Value;

    float Voltage, Temperature;

    uint16_t OffsetV = *(volatile uint16_t *)(0x1FFFF7E0);
    uint16_t OffsetT = *(volatile uint16_t *)(0x1FFFF7F6) & 0xFFFF;

    printf("\r\nTest %s, V:0x%X, T:0x%X", __FUNCTION__, OffsetV, OffsetT);

    ADC_Configure();

    while (1)
    {
        /* Internal voltage sensor */
        Value = ADC_ReadVoltageSensorValue();

        Voltage = (float)(OffsetV) * (float)3.3 / (float)Value;

        PLATFORM_DelayMS(250);

        /* Internal temperature sensor */
        Value = ADC_ReadTemperatureSensorValue();

        Temperature = 25 + ((float)Value * (float)Voltage * (float)1000 - (float)OffsetT * (float)3300) / ((float)4096 * (float)AVG_SLOPE);

        printf("\r\nVDD : %0.2f, Temperature : %0.2f", Voltage, Temperature);

        PLATFORM_DelayMS(250);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

