/**
 * @file    adc_injectionchannel_polling.c
 * @author  MegawinTech Application Team
 * @version V1.0.3
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _ADC_INJECTIONCHANNEL_POLLING_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "adc_injectionchannel_polling.h"

/**
  * @addtogroup MG32F005_LibSamples
  * @{
  */

/**
  * @addtogroup ADC
  * @{
  */

/**
  * @addtogroup ADC_InjectionChannel_Polling
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void ADC_Configure(void)
{
    ADC_InitTypeDef  ADC_InitStruct;
    GPIO_InitTypeDef GPIO_InitStruct;

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_ADC1, ENABLE);

    ADC_StructInit(&ADC_InitStruct);
    ADC_InitStruct.ADC_Resolution = ADC_Resolution_12b;
    ADC_InitStruct.ADC_Prescaler  = ADC_Prescaler_16;
    ADC_InitStruct.ADC_Mode       = ADC_Mode_Scan;
    ADC_InitStruct.ADC_DataAlign  = ADC_DataAlign_Right;
    ADC_Init(ADC1, &ADC_InitStruct);

    ADC_SampleTimeConfig(ADC1, ADC_Channel_0, ADC_SampleTime_240_5);
    ADC_SampleTimeConfig(ADC1, ADC_Channel_2, ADC_SampleTime_240_5);
    ADC_SampleTimeConfig(ADC1, ADC_Channel_3, ADC_SampleTime_240_5);

    ADC_InjectedChannelNumCfg(ADC1, 2);
    ADC_InjectedChannelSelect(ADC1, ADC_InjectedChannel_0, ADC_Channel_0);
    ADC_InjectedChannelSelect(ADC1, ADC_InjectedChannel_1, ADC_Channel_2);
    ADC_InjectedChannelSelect(ADC1, ADC_InjectedChannel_2, ADC_Channel_3);
    ADC_InjectedConvCmd(ADC1, ENABLE);

    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

    /* PA1(RV1) PA3(RV2) PA4(RV3) */
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin   = GPIO_Pin_1 | GPIO_Pin_3 | GPIO_Pin_4;
    GPIO_InitStruct.GPIO_Speed = GPIO_Speed_High;
    GPIO_InitStruct.GPIO_Mode  = GPIO_Mode_AIN;
    GPIO_Init(GPIOA, &GPIO_InitStruct);

    ADC_Cmd(ADC1, ENABLE);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void ADC_InjectionChannel_Polling_Sample(void)
{
    float RVxVoltage[3];

    printf("\r\nTest %s", __FUNCTION__);

    ADC_Configure();

    while (1)
    {
        ADC_SoftwareStartInjectedConvCmd(ADC1, ENABLE);

        while (RESET == ADC_GetFlagStatus(ADC1, ADC_FLAG_INJEOS))
        {
        }

        ADC_ClearFlag(ADC1, ADC_FLAG_INJEOS);

        RVxVoltage[0] = (float)ADC_GetInjectedChannelConvertedValue(ADC1, ADC_InjectedChannel_0) * (float)3.3 / (float)4096.0;
        RVxVoltage[1] = (float)ADC_GetInjectedChannelConvertedValue(ADC1, ADC_InjectedChannel_1) * (float)3.3 / (float)4096.0;
        RVxVoltage[2] = (float)ADC_GetInjectedChannelConvertedValue(ADC1, ADC_InjectedChannel_2) * (float)3.3 / (float)4096.0;

        printf("\r\nRV1 Voltage = %0.2f  \tRV2 Voltage = %0.2f  \tRV3 Voltage = %0.2f", RVxVoltage[0], RVxVoltage[1], RVxVoltage[2]);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

