/**
 * @file    mg32_hwdiv.h
 * @author  MegawinTech Application Team
 * @brief   This file contains all the functions prototypes for the HWDIV firmware
 *          library.
 */


/* Define to prevent recursive inclusion -----------------------------------------------------------------------------*/
#ifndef __MG32_HWDIV_H
#define __MG32_HWDIV_H

/* Files includes ----------------------------------------------------------------------------------------------------*/
#include "mg32f005_device.h"

/** @addtogroup MG32_StdPeriph_Driver
  * @{
  */

/** @defgroup HWDIV
  * @{
  */

/** @defgroup HWDIV_Exported_Types
  * @{
  */

/**
  * @}
  */

/** @defgroup HWDIV_Exported_Constants
  * @{
  */
#define SET_DVDR(x)   (HWDIV->DVDR) = (x)
#define SET_DVSR(y)   (HWDIV->DVSR) = (y)
#define GET_QUOTR()   (HWDIV->QUOTR)
#define GET_RMDR()    (HWDIV->RMDR)

/**
  * @brief HWDIV_Sign_Typedef
  */
#define HWDIV_Signed      (0x00U << HWDIV_CR_USIGN_Pos)     /*!< Signed division */
#define HWDIV_UnSigned    (0x01U << HWDIV_CR_USIGN_Pos)     /*!< Unsigned division */

/**
  * @}
  */

/** @defgroup HWDIV_Exported_Functions
  * @{
  */
void HWDIV_UsignConfig(uint32_t usign);
void HWDIV_ITConfig(FunctionalState state);

#endif

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
