/**
 * @file    hwdiv_calculation.c
 * @author  MegawinTech Application Team
 * @version V1.0.3
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _HWDIV_CALCULATION_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "hwdiv_calculation.h"

/**
  * @addtogroup MG32F005_LibSamples
  * @{
  */

/**
  * @addtogroup HWDIV
  * @{
  */

/**
  * @addtogroup HWDIV_Calculation
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void HWDIV_Configure(void)
{
    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_HWDIV, ENABLE);

    HWDIV_UsignConfig(HWDIV_UnSigned);

    SET_DVDR(100);
    SET_DVSR(30);

    printf("\r\n%d...%d", GET_QUOTR(), GET_RMDR());

    HWDIV_UsignConfig(HWDIV_Signed);

    SET_DVDR(100);
    SET_DVSR(-25);

    printf("\r\n%d...%d", GET_QUOTR(), GET_RMDR());
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void HWDIV_Calculation_Sample(void)
{
    printf("\r\nTest %s", __FUNCTION__);

    HWDIV_Configure();

    while (1)
    {
        PLATFORM_LED_Toggle(LED1);
        PLATFORM_DelayMS(100);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

