/**
 * @file    flash_iap_dataspace.c
 * @author  MegawinTech Application Team
 * @version V1.0.3
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _FLASH_IAP_DATASPACE_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "flash_iap_dataspace.h"

/**
  * @addtogroup MG32F005_LibSamples
  * @{
  */

/**
  * @addtogroup FLASH
  * @{
  */

/**
  * @addtogroup FLASH_IAP_DataSpace
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/
#define IAP_DATASPACE_START_ADDRESS     ((uint32_t)0x1FE00000)
#define IAP_DATASPACE_PAGE_SIZE         (1024)

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
uint8_t FLASH_IAP_DataSpace_Erase_Program_Test(void)
{
    uint16_t WriteValue    = 0x1234;
    uint16_t ReadValue     = 0;
    uint32_t OffsetAddress = IAP_DATASPACE_START_ADDRESS;

    printf("\r\nWrite Value : 0x%04x", WriteValue);

    FLASH_Unlock();

    FLASH_ClearFlag(FLASH_FLAG_EOP | FLASH_FLAG_PGERR | FLASH_FLAG_WRPRTERR);

    FLASH_EraseDataAreaPage(OffsetAddress);
    FLASH_ClearFlag(FLASH_FLAG_EOP);

    FLASH_ProgramDataAreaHalfWord(OffsetAddress, WriteValue);
    FLASH_ClearFlag(FLASH_FLAG_EOP);

    FLASH_Lock();

    ReadValue = *(volatile uint16_t *)(OffsetAddress);

    printf("\r\nRead  Value : 0x%04x", ReadValue);

    if (ReadValue == WriteValue)
    {
        printf("\t-->Passed");
        return (1);
    }
    else
    {
        printf("\t-->Failed");
        return (0);
    }
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void FLASH_IAP_DataSpace_Sample(void)
{
    uint8_t Result = 0;

    printf("\r\nTest %s", __FUNCTION__);

    Result = FLASH_IAP_DataSpace_Erase_Program_Test();

    while (1)
    {
        if (0 != Result)
        {
            PLATFORM_LED_Toggle(LED1);
            PLATFORM_DelayMS(500);
        }
        else
        {
            PLATFORM_LED_Toggle(LED1);
            PLATFORM_DelayMS(100);
        }
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

