/**
 * @file    dbg_tim_stop.c
 * @author  MegawinTech Application Team
 * @version V1.0.3
 * @date    15-Mar-2023
 * @brief   This file contains all the system functions
 */

/* Define to prevent recursive inclusion */
#define _DBG_TIM_STOP_C_

/* Files include */
#include <stdio.h>
#include "platform.h"
#include "dbg_tim_stop.h"

/**
  * @addtogroup MG32F005_LibSamples
  * @{
  */

/**
  * @addtogroup DBG
  * @{
  */

/**
  * @addtogroup DBG_TIM_Stop
  * @{
  */

/* Private typedef ****************************************************************************************************/

/* Private define *****************************************************************************************************/

/* Private macro ******************************************************************************************************/

/* Private variables **************************************************************************************************/

/* Private functions **************************************************************************************************/

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void DBG_PWM_Configure(void)
{
    GPIO_InitTypeDef        GPIO_InitStruct;
    RCC_ClocksTypeDef       RCC_Clocks;
    TIM_OCInitTypeDef       TIM_OCInitStruct;
    TIM_TimeBaseInitTypeDef TIM_TimeBaseStruct;

    uint32_t TimerPeriod, Channel1Pulse, Channel2Pulse, Channel3Pulse;

    RCC_GetClocksFreq(&RCC_Clocks);

    /* Compute the value to be set in ARR regiter to generate signal frequency at 100 Khz */
    TimerPeriod = (RCC_Clocks.PCLK1_Frequency / 100000 ) - 1;

    /* Compute CCR1 value to generate a duty cycle at 80% for channel 1 */
    Channel1Pulse = ((uint32_t)800 * (TimerPeriod - 1)) / 1000;

    /* Compute CCR2 value to generate a duty cycle at 40% for channel 2 */
    Channel2Pulse = ((uint32_t)400 * (TimerPeriod - 1)) / 1000;

    /* Compute CCR3 value to generate a duty cycle at 25% for channel 3 */
    Channel3Pulse = ((uint32_t)250 * (TimerPeriod - 1)) / 1000;

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM1, ENABLE);

    TIM_TimeBaseStructInit(&TIM_TimeBaseStruct);
    TIM_TimeBaseStruct.TIM_Prescaler         = 0;
    TIM_TimeBaseStruct.TIM_CounterMode       = TIM_CounterMode_Up;
    TIM_TimeBaseStruct.TIM_Period            = TimerPeriod;
    TIM_TimeBaseStruct.TIM_ClockDivision     = TIM_CKD_Div1;
    TIM_TimeBaseStruct.TIM_RepetitionCounter = 0;
    TIM_TimeBaseInit(TIM1, &TIM_TimeBaseStruct);

    TIM_OCStructInit(&TIM_OCInitStruct);
    TIM_OCInitStruct.TIM_OCMode       = TIM_OCMode_PWM1;
    TIM_OCInitStruct.TIM_OutputState  = TIM_OutputState_Enable;
    TIM_OCInitStruct.TIM_Pulse        = 0;
    TIM_OCInitStruct.TIM_OCPolarity   = TIM_OCPolarity_High;
    TIM_OCInitStruct.TIM_OCIdleState  = TIM_OCIdleState_Set;

    TIM_OCInitStruct.TIM_Pulse = Channel1Pulse;
    TIM_OC1Init(TIM1, &TIM_OCInitStruct);

    TIM_OCInitStruct.TIM_Pulse = Channel2Pulse;
    TIM_OC2Init(TIM1, &TIM_OCInitStruct);

    TIM_OCInitStruct.TIM_Pulse = Channel3Pulse;
    TIM_OC3Init(TIM1, &TIM_OCInitStruct);

    RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOB, ENABLE);

    GPIO_PinAFConfig(GPIOB, GPIO_PinSource9, GPIO_AF_0);    /* TIM1_CH1 */
    GPIO_PinAFConfig(GPIOB, GPIO_PinSource7, GPIO_AF_0);    /* TIM1_CH2 */
    GPIO_PinAFConfig(GPIOB, GPIO_PinSource5, GPIO_AF_0);    /* TIM1_CH3 */

    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin   = GPIO_Pin_9 | GPIO_Pin_7 | GPIO_Pin_5;
    GPIO_InitStruct.GPIO_Speed = GPIO_Speed_High;
    GPIO_InitStruct.GPIO_Mode  = GPIO_Mode_AF_PP;
    GPIO_Init(GPIOB, &GPIO_InitStruct);

    TIM_Cmd(TIM1, ENABLE);

    TIM_CtrlPWMOutputs(TIM1, ENABLE);
}

/***********************************************************************************************************************
  * @brief
  * @note   none
  * @param  none
  * @retval none
  *********************************************************************************************************************/
void DBG_TIM_Stop_Sample(void)
{
    printf("\r\nTest %s", __FUNCTION__);

    DBG_PWM_Configure();

    RCC_APB1PeriphClockCmd(RCC_APB1Periph_DBG, ENABLE);

    DBGMCU_Configure(DBGMCU_CR_TIM1_STOP, ENABLE);

    while (1)
    {
        PLATFORM_LED_Toggle(LED1);
        PLATFORM_DelayMS(100);
    }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

