/**
 * @file    mg32_opamp.h
 * @author  MegawinTech Application Team
 * @brief   This file contains all the functions prototypes for the OPAMP firmware
 *          library.
 */


/* Define to prevent recursive inclusion -----------------------------------------------------------------------------*/
#ifndef __MG32_OPAMP_H
#define __MG32_OPAMP_H


/* Files includes ----------------------------------------------------------------------------------------------------*/
#include "mg32f005_device.h"

/** @addtogroup MG32_StdPeriph_Driver
  * @{
  */

/** @defgroup OPAMP
  * @{
  */

/** @defgroup OPAMP_Exported_Types
  * @{
  */

  /**
  * @}
  */

/** @defgroup OPAMP_Exported_Constants
  * @{
  */
#define OPAMP_EN        (0x01U << OPAMP_CR_OPAEN_Pos)               /* OPAMP Enable */

/**
  * @brief OPA_Mode_Typedef
  */
#define OPAMP_Mode_HighPerformance    (0x00U << OPAMP_CR_OPAMSEL_Pos)   /*High performance mode */
#define OPAMP_Mode_LowPower           (0x01U << OPAMP_CR_OPAMSEL_Pos)   /*Low power mode */

/**
  * @}
  */

/** @defgroup OPAMP_Exported_Functions
  * @{
  */
void OPAMP_Cmd(OPAMP_TypeDef* opamp, FunctionalState state);
void OPAMP_ModeConfig(OPAMP_TypeDef* opamp, uint32_t opamode);

#endif

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
