#ifndef _TWI_H
#define _TWI_H

#ifdef  _TWI_C
#define TWI_EXTERN
#else
#define TWI_EXTERN     extern
#endif

#define	TWI_RUN_TIME_MAX		50
#define	TWI_OV_TIME_MAX			100
#define	TWI_FAIL_CNT_MAX		8

typedef enum
{
	TWI_RW_IDLE = 0,
	TWI_RW_WORKING,
	TWI_RW_SUCCESS,
	TWI_RW_FAIL,
};


#define SEND_TWI_ACK()		SICON |= AA		// ACK
#define SEND_TWI_NOACK()	SICON &= ~AA	//  NO ACK
#define SEND_TWI_STA()		SICON |= STA	// ʼλ
#define CLR_TWI_STA()		SICON &= ~STA	// ʼ־
#define SEND_TWI_STO()		SICON |= STO	// ֹͣλֹͣ־Ӳ
#define CLR_TWI_SI()		SICON &= ~SI	// TWIжϱ־
#define SET_TWI_I()			EIE1 |= ETWI0	// TWIж
#define CLR_TWI_I()			EIE1 &= ~ETWI0	// رTWIж

TWI_EXTERN	u8	SlaveAddress;
TWI_EXTERN	u8	SlaveRegAddr;
TWI_EXTERN	u8	SlaveData;
TWI_EXTERN	u8	SlaveDataCnt;
TWI_EXTERN	u8	SlaveDataLen;

TWI_EXTERN	u8	TWI0Status;
TWI_EXTERN	u8	TWI0Ovtime;
TWI_EXTERN	u8	TWI0Runtime;
TWI_EXTERN	u8	TWI0FailCnt;


TWI_EXTERN void TWI0Proc(void);

#endif

