
/*********************************************************************
    Ŀ:MA82G5D16-DEMO
			԰ʹ MA82G5Dxx	SSOP28 EV Board (TH178A)
			CpuCLK=12MHz, SysCLK=12MHz
	
			ʱΪ ILRCO 32KHz, P60MCK/4
	ע

    ʱ:
    ޸־:
    
*********************************************************************/
#define _MAIN_C

#include <Intrins.h>
#include <Absacc.h>

#include <Stdio.h>  // for printf

#include ".\include\REG_MA82G5D16.H"
#include ".\include\Type.h"
#include ".\include\API_Macro_MA82G5D16.H"
#include ".\include\API_Uart_BRGRL_MA82G5D16.H"


#define LED_G_0		P22
#define LED_R		P24
#define LED_G_1		P26

/*************************************************
:     void DelayXms(u16 xMs)
:   		ʱ򣬵λΪms
ú:        
:     u16 xMs -> *1ms  (1~65535)
:     
:        		
:
*************************************************/
void DelayXms(u16 xMs)
{
	while(xMs!=0)
	{
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();
		nop();

		xMs--;
		
	}
}


/***********************************************************************************
:   void InitClock_ILRCO(void)
:   ʼClock
:   
ز:     
*************************************************************************************/
void InitClock_ILRCO(void)
{
	// P60  MCK/4
	CLK_P60OC_MCKDiv4();

	// IHRCO Enable, MCK=OSCin, OSCin=ILRCO
	CLK_SetCKCON2(ENABLE_IHRCO|MCK_OSCin|OSCIn_ILRCO);
	nop();
	// IHRCO Disable, MCK=OSCin, OSCin=ILRCO
	CLK_SetCKCON2(DISABLE_IHRCO|MCK_OSCin|OSCIn_ILRCO);

}


/***********************************************************************************
:   void InitPort(void)
:   IO
:   
ز:     
*************************************************************************************/
void InitPort(void)
{
	PORT_SetP2PushPull(BIT2|BIT4|BIT6);				//  P22,P24,P26 Ϊ LED
	PORT_SetP6PushPull(BIT0);					    // P60 Ϊģʽ
}




/***********************************************************************************
:   void InitSystem(void)
:   ϵͳʼ
:   
ز:     
*************************************************************************************/
void InitSystem(void)
{
	
	InitClock_ILRCO();
	InitPort();

}



void main()
{
	
    InitSystem();
	
	LED_G_0=0;LED_G_1=0;LED_R=0;
	DelayXms(1000);
	LED_G_0=1;LED_G_1=1;LED_R=1;
					
    while(1)
    {
		LED_G_0=0;
		DelayXms(200);
		LED_G_0=1;
		LED_G_1=0;
		DelayXms(200);
		LED_G_1=1;
		LED_R=0;
		DelayXms(200);
		LED_R=1;
    }
}

