/*
*/	
#define	_FUNC_C

#include	"Incfile.h"

void INT_UART(void) interrupt 4        //  ж
{ 
    _push_(SFRPI);
	SFRPI=0;
	if(RI0)
	{
		RI0=0;
	}
	if(TI0)
	{
		TI0=0;
		if(UartOutBufOut==UartOutBufIn)
		{
			bUartOutTxFlag=FALSE;
		}
		else
		{
			S0BUF=UartOutBuf[UartOutBufOut];
			bUartOutTxFlag=TRUE;
			UartOutBufOut++;
			if(UartOutBufOut>=UART_OUT_BUF_SIZE)
			{
				UartOutBufOut=0;
			}
		}
	}
    _pop_(SFRPI);
}

/***********************************************************************************
:   void TestOutByte(u8 ToSend)
:   ģʽ£ͨڷһֽڵ
:   u8 ToSend: ͵
ز:     
*************************************************************************************/
void TestOutByte(u8 ToSend)
{
	u8 i;

	if(bUartOutTxFlag==FALSE)
	{
		UartOutBufIn=0;
		UartOutBufOut=0;
		UartOutBuf[UartOutBufIn]=ToSend;
		UartOutBufIn++;
		TI0=1;
	}
	else
	{
		i=UartOutBufIn;
		UartOutBuf[i]=ToSend;
		i++;
		if(i>=UART_OUT_BUF_SIZE)
		{
			i=0;
		}
		while(i==UartOutBufOut)
		{
		}
		ES0=0;
		UartOutBufIn=i;
		ES0=1;
	}
	
}


/*************************************************
:     
	void TestOutStr(pu8 pStr)
:   		
	 ģʽ£ͨڷַ
ú:        
	
:     
               
:     

:        		

:
        
*************************************************/
void TestOutStr(pu8 pStr)
{
	while((*pStr)!=0)
	{
		TestOutByte(*pStr);
		pStr++;
	}
}


/**************************************************************************************************
:     void TestOutOCT(u8 ToSend)
:   		ģʽ£ͨASCII뷢10Ƶ
ú:        
:     
:     
:        		
:
        
**************************************************************************************************/
void TestOutOCT(u8 ToSend)
{
	BYTE x;
	x = ToSend/100;
	ToSend = ToSend%100;
	if(x != 0)
	{
		TestOutByte('0'+x);
	}
	x = ToSend/10;
	ToSend = ToSend%10;
	TestOutByte('0'+x);
	TestOutByte('0'+ToSend);
}

/*************************************************
:     
	void TestOutHex(u8 ToSend)
:   		
	 ģʽ£ͨASCII뷢16Ƶ
ú:        
	
:     
               
:     

:        		

:
        
*************************************************/
void TestOutHex(u8 ToSend)
{
	BYTE x;
	x = ToSend >> 4;
	if(x < 10)
	{
		TestOutByte('0'+x);
	}
	else
	{
		TestOutByte('A'-10+x);
	}
	x= ToSend&0x0F;
	if(x < 10)
	{
		TestOutByte('0'+x);
	}
	else
	{
		TestOutByte('A'-10+x);
	}
}



/***********************************************************************************
:    u8 NumberChk(u8 uSou, u8 uMin, u8 uMax)
:   ִС
ú:        
:     u8 uSou: 
				u8 uMin:  Сֵ(  )
				u8 uMax: ֵ()
ز:     0: ȷ, 1: Χ
*************************************************************************************/
u8 NumberChk(u8 uSou, u8 uMin, u8 uMax) 
{
	if(uSou < uMin) return 1;
	if(uSou >= uMax) return 2;
	return 0;
}


/***********************************************************************************
:    u8 Bufcmp(u8 *buf1, u8 *buf2, u8 len)
:   	Ƚ
ú:        
:     buf1[],buf1[]: Ƚϵ
				len: Ƚϵĸ
ز:     0: ͬ
				ֵ: ͬ
*************************************************************************************/
u8 Bufcmp(u8 *buf1, u8 *buf2, u8 len)
{
    u8 i;
    for(i=0; i<len; i++)
    {
		if (*buf1++ != *buf2++) return 1;
    }
    return 0;
}

/***********************************************************************************
:    void Bufcpy(u8 *buf1, u8 *buf2, u8 len)
:    Copy
ú:        
:     buf1[]: CopyĿ
				buf2[]: CopyԴ
				len: Copyĸ
ز:     
*************************************************************************************/
void Bufcpy(u8 *buf1, u8 *buf2, u8 len)
{
	u8 i;
	for(i=0; i<len; i++)
	{
		*buf1++ = *buf2++;
	}
}




