
#define		uCHAR	unsigned char
#define		uINT	unsigned int

#include <intrins.h>                             // for _nop_();
#include "REG_MA82G5Dxx.H"
#include "Delay.h"

uCHAR tmp;

#define	nCS						P11
xdata uCHAR TestBuf[128];

void Initial_SPI(void)
{
	SPCON = ( SPEN | SSIG | MSTR | CPHA | SPR0);		//enable SPI and set sampling data at falling edge, SPICLK is sysclk / 8.
	P1M0 = P1M0|(P1M01|P1M05|P1M07);					//set P11, P15, P17 to push-pull
	P1M1 = P1M1 & (~(P1M01|P1M05|P1M07));

	P1M0 = P1M0|P1M06;									//set P16 to open-drain with pull high
	P1M1 = P1M1|P1M16;
}

void SPI_Wr_Single(uCHAR Var)							//Write 1 Byte only.
{
	SPDAT = Var;
	while(!(SPSTAT & SPIF));
	SPSTAT |= SPIF;
}

uCHAR SPI_RD_Single(void)								//Read 1 Byte only.
{
	uCHAR Var;

	SPDAT = 0xFF;
	while(!(SPSTAT & SPIF));
	SPSTAT |= SPIF;
	Var = SPSTAT;
	
	return Var;
}

void SPI_Wr(uCHAR Addr, uCHAR Dta)
{
	nCS = 0;
	SPI_Wr_Single(Addr);
	delay_5us();
	SPI_Wr_Single(Dta);
	nCS = 1;
	
}

uCHAR SPI_Rd(uCHAR Addr)
{
	uCHAR Dta;

	nCS = 0;
	SPI_Wr_Single(Addr);
	delay_5us();
	Dta = SPI_RD_Single();
	nCS = 1;
	
	Dta = SPDAT;
	return Dta;
}

void main(void)
{
	uCHAR i;
	Initial_SPI();

 	while(1)
	{
		P35=!P35;
		for(i=0;i<128;i++)
		{
			SPI_Wr(i&0x7F, 0xAA);
		}	
		for(i=0;i<128;i++)
		{
			TestBuf[i]=SPI_Rd(i|0x80);
		}	
	
	}
}
