/* Includes ------------------------------------------------------------------*/
#include "stdio.h"
#include "mg32f157.h"
#include "bsp_usart1.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
SPI_InitTypeDef  SPI_InitStructure;
GPIO_InitTypeDef GPIO_InitStructure;
NVIC_InitTypeDef NVIC_InitStructure;

const uint8_t WriteData[] = 
{
  0x52,0x79,0x0C,0xAF,0xC0,0x99,0x44,0x71,0x9D,0x30,0xAD,0x68,0xF7,0x95,0xF8,0x38,
  0xF5,0x9C,0x19,0xDD,0xEC,0xBC,0x6C,0xF0,0x71,0xD8,0xE4,0x1D,0x6F,0x7F,0x08,0xD7,
  0x92,0x61,0x36,0x36,0xE3,0x08,0x7E,0xED,0x44,0x22,0x72,0x36,0x84,0x27,0xF5,0x98,
  0x95,0x7C,0xFE,0x4F,0x17,0x8A,0xD3,0x6C,0x43,0xB0,0xBC,0xEC,0x07,0x99,0x81,0x29,
  0x28,0x32,0xFD,0x3B,0x8D,0xCD,0x02,0x97,0xAE,0x80,0xE6,0xC9,0xE5,0x3B,0x9A,0x24,
  0x97,0x31,0xAF,0x57,0x00,0x5E,0xCC,0x1B,0xEB,0x5F,0x2C,0x07,0x68,0x21,0x72,0xFD,
  0x8B,0xDE,0x66,0x74,0xB4,0x09,0xD5,0x33,0xD7,0x5E,0x4A,0x42,0x46,0xD9,0x6F,0x5D,
  0x33,0xCF,0xAD,0xD6,0x62,0x5C,0xF8,0x62,0x92,0x4E,0xE0,0xF0,0x81,0x9A,0xCE,0x94,
  0x5A,0xCC,0x05,0x67,0xD0,0x3E,0xFE,0xB1,0x51,0xFF,0x57,0x8D,0xB1,0x8D,0xAC,0x32,
  0xB5,0xD5,0x7F,0xA8,0xB8,0x4A,0x0E,0xD3,0xEF,0x4A,0x15,0x0D,0x40,0x2D,0xA4,0xC6,
  0x97,0x8D,0x38,0xDA,0xDB,0x54,0xBF,0x6D,0x1C,0xFF,0x54,0xEF,0x82,0x5C,0x40,0xAC,
  0x68,0xA0,0x91,0xEC,0x1B,0x24,0x1D,0x86,0x77,0x5B,0xB6,0x85,0xAF,0xC1,0xAA,0xAD,
  0xC2,0xA6,0xA5,0x76,0x4C,0x66,0xA5,0xFF,0x0A,0x99,0xCA,0x1F,0xC3,0x71,0x86,0xA1,
  0x64,0x85,0xD6,0xA0,0xFB,0xE4,0x68,0x0D,0xDB,0x90,0xC6,0x4B,0x5B,0xB6,0x63,0xE3,
  0x4B,0x8A,0xAA,0x99,0xDD,0x31,0xD2,0xC1,0x4D,0x4A,0xEA,0xC2,0x42,0x36,0xC7,0x0A,
  0x28,0xC8,0xBD,0x46,0x52,0x70,0x94,0x23,0x44,0x39,0xD7,0x07,0xCC,0xCC,0x5C,0x81,
  0x4B,0x2F,0x8C,0xA1,0xDA,0xF4,0x86,0x74,0xB0,0x5A,0x49,0x10,0x1F,0xD4,0x8B,0x7B,
  0x9C,0x65,0x14,0x8E,0x81,0x28,0x6F,0x50,0xE2,0x4E,0x62,0x55,0xFD,0x27,0x7C,0x87,
  0x0E,0xAB,0xD0,0xE9,0x09,0xC7,0x9A,0x77,0xD7,0xBD,0x45,0xEE,
};
uint8_t ReadData[sizeof(WriteData)];
uint16_t TxIndex = 0, RxIndex = 0, RxFlag = 0;
uint8_t ret = 0;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
void SPI_MasterConfig(void);
void SPI_SlaveConfig(void);

/**
  * @brief  Main program
  * @param  None
  * @retval None
  */
int main(void)
{
  /* Updating the system clock */
  SystemCoreClockUpdate();

  /* Configure the interrupt priority group */
  NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);

  /* Init UART1 to 115200-8n1 for print message */
  usart1_init(96000000, 115200);
  
  printf("SPI Simplex Interrupt Example \r\n");

  /* Configure the SPI Master and Slave */
  SPI_SlaveConfig();
  SPI_MasterConfig();

  /* Wait for communication to complate */
  while (!RxFlag);

  /* Print SPI communication data */
  printf("Index | Send | Recv \r\n");
  for (uint16_t i = 0; i < sizeof(WriteData); i++)
  {
    printf(" %3d  | 0x%02X | 0x%02X \r\n", i, WriteData[i], ReadData[i]);
    if(WriteData[i] != ReadData[i])
      ret = 1;
  }

  if (ret)
    printf("SPI Simplex Interrupt Error \r\n");
  else
    printf("SPI Simplex Interrupt Success \r\n");

  while (1)
  {

  }
}

/**
 * @brief  SPI Master Tx Config
 * @param  None
 * @retval None
 */
void SPI_MasterConfig(void)
{
  /* Enable SPI_Master Periph and GPIO clock */
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA | RCC_APB2Periph_SPI1, ENABLE);

  /* 
    SPI1_CS      PA4
    SPI1_CLK     PA5
    SPI1_MOSI    PA7
   */
  /* Configure SPI_Master pins: CS, SCK and MOSI ---------------------------------*/
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_4;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
  GPIO_SetBits(GPIOA, GPIO_Pin_4);

  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5 | GPIO_Pin_7;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOA, &GPIO_InitStructure);

  /* Configure and enable SPI_Master interrupt -------------------------------*/
  NVIC_InitStructure.NVIC_IRQChannel = SPI1_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 2;
  NVIC_Init(&NVIC_InitStructure);

  /* SPI_Master configuration ------------------------------------------------*/
  SPI_InitStructure.SPI_Direction = SPI_Direction_1Line_Tx;
  SPI_InitStructure.SPI_Mode = SPI_Mode_Master;
  SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
  SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
  SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
  SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;
  SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_8;
  SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;
  SPI_InitStructure.SPI_CRCPolynomial = 7;
  SPI_Init(SPI1 , &SPI_InitStructure);

  /* Enable SPI_Master */
  SPI_Cmd(SPI1 , ENABLE);
  
  GPIO_ResetBits(GPIOA, GPIO_Pin_4);
  /* Enable SPI_Master TXE interrupt */
  SPI_I2S_ITConfig(SPI1, SPI_I2S_IT_TXE, ENABLE);
}

/**
 * @brief  SPI Slave Rx Config
 * @param  None
 * @retval None
 */
void SPI_SlaveConfig(void)
{
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_SPI2, ENABLE);

  /* 
    SPI2_CS      PB12
    SPI2_CLK     PB13
    SPI2_MISO    PB14
   */
  /* Configure SPI_Slave pins: CS, SCK and MISO ---------------------------------*/
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13| GPIO_Pin_14;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  /* Configure and enable SPI_Slave interrupt -------------------------------*/
  NVIC_InitStructure.NVIC_IRQChannel = SPI2_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;
  NVIC_Init(&NVIC_InitStructure);

  /* SPI_Slave configuration ------------------------------------------------*/
  SPI_InitStructure.SPI_Direction = SPI_Direction_1Line_Rx;
  SPI_InitStructure.SPI_Mode = SPI_Mode_Slave;
  SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
  SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
  SPI_InitStructure.SPI_CPHA = SPI_CPHA_1Edge;
  SPI_InitStructure.SPI_NSS = SPI_NSS_Hard;
  SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_4;
  SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;
  SPI_InitStructure.SPI_CRCPolynomial = 7;
  SPI_Init(SPI2 , &SPI_InitStructure);

  /* Enable SPI_Slave */
  SPI_Cmd(SPI2 , ENABLE);

  /* Enable SPI_Slave TXE interrupt */
  SPI_I2S_ITConfig(SPI2, SPI_I2S_IT_RXNE, ENABLE);
}

void SPI1_IRQHandler(void)
{
  if (SPI_I2S_GetITStatus(SPI1, SPI_I2S_IT_TXE) != RESET)
  {
    /* Send SPI_Master data */
    SPI_I2S_SendData(SPI1, WriteData[TxIndex++]);

    if (TxIndex >= sizeof(WriteData))
    {
      SPI_I2S_ITConfig(SPI1, SPI_I2S_IT_TXE, DISABLE);
    }
  }
}

void SPI2_IRQHandler(void)
{
  if(SPI_I2S_GetITStatus(SPI2, SPI_I2S_IT_RXNE) != RESET)
  {
    ReadData[RxIndex++] = SPI_I2S_ReceiveData(SPI2);
    if(RxIndex >= sizeof(WriteData))
    {
      SPI_I2S_ITConfig(SPI2, SPI_I2S_IT_RXNE, DISABLE);
      RxFlag = 1;
    }
  }
}

#ifdef  USE_FULL_ASSERT

/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  while (1)
  {

  }
}

#endif
