/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define LSI_FREQ 40000

/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint32_t Index, Counter;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

int main(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
  
  SystemCoreClockUpdate();

  /* Enable GPIOB clock */
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);

  /* Configure PB10 and PB11 in output pushpull mode */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10 | GPIO_Pin_11;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  /* Turn off LED1 and LED2 */
  GPIO_SetBits(GPIOB, GPIO_Pin_10 | GPIO_Pin_11);

  SysTick_Delay_Ms(2000);

  /* Turn on LED1 and LED2 */
  GPIO_ResetBits(GPIOB, GPIO_Pin_10 | GPIO_Pin_11);

  /* Enable the LSI OSC */
  RCC_LSICmd(ENABLE);
  
  /* Wait till LSI is ready */
  while (RCC_GetFlagStatus(RCC_FLAG_LSIRDY) == RESET);

  /* Enable write access to IWDG_PR and IWDG_RLR registers */
  IWDG_WriteAccessCmd(IWDG_WriteAccess_Enable);

  /* IWDG counter clock: LSI/32 */
  IWDG_SetPrescaler(IWDG_Prescaler_32);
  while(IWDG_GetFlagStatus(IWDG_FLAG_PVU) != RESET);

  /* IWDG timeout is about 250ms */
  IWDG_SetReload(LSI_FREQ / 32 * 0.250);
  while(IWDG_GetFlagStatus(IWDG_FLAG_RVU) != RESET);

  /* ATTENTION: It is best to reload IWDG counter when the RVU bit is 0. */
  while(IWDG_GetFlagStatus(IWDG_FLAG_RVU) != RESET);
  IWDG_ReloadCounter();

  /* Enable IWDG */
  IWDG_Enable();

  /* Toggle LED2 6 times */
  Counter = 0;
  Index = 0;
  while (Index < 6)
  {
    Counter++;
    if (Counter > 500000)
    {
      Counter = 0;
      /* Toggle LED2 */
      GPIO_ToggleBits(GPIOB, GPIO_Pin_11);
      Index++;
    }

    IWDG_ReloadCounter();
  }

  /* Infinite loop */
  while (1)
  {
    SysTick_Delay_Ms(200);

    IWDG_ReloadCounter();
  }
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
