/* Includes ------------------------------------------------------------------*/
#include "drv_eeprom_24c02.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void eeprom_24c02_init(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;

  RCC_APB1PeriphClockCmd(RCC_APB1Periph_I2C2, ENABLE);
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);

  /*
    PB10 (I2C2_SCL)
    PB11 (I2C2_SDA)
  */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10 |GPIO_Pin_11;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_OD;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  I2C_DeInit(I2C2);
  I2C_Init(I2C2, I2C_CON_SLAVE_DISABLE | I2C_CON_RESTART_EN | I2C_CON_SPEED_STANDARD | I2C_CON_MASTER_MODE | I2C_CON_BUS_CLEAR_FEATURE_CTRL);
  I2C_TargetAddressConfig(I2C2, 0xA0 >> 1);

  I2C2->SS_SCL_HCNT = 183;  /* tHIGH = (183 + FS_SPKLEN + 7) / 48MHz = 4us */
  I2C2->SS_SCL_LCNT = 225;  /* tLOW = (225 + 1) / 48MHz = 4.708us */
  I2C2->FS_SPKLEN = 2;      /* tSP = 2 / 48MHz = 41.67ns */
  I2C2->SDA_SETUP = 135;    /* tSU;DAT = 135 / 48MHz = 2.8125us */
  I2C2->SDA_HOLD = 91;      /* tHD;DAT = 91 / 48MHz = 1.896us */
 
  I2C2->SCL_STUCK_AT_LOW_TIMEOUT = (SystemCoreClock >> 1) / 100;  /* I2C SCL Stuck at Low Timeout. us */
}

uint32_t eeprom_24c02_random_read(uint8_t addr, uint8_t* pdata)
{
  uint32_t abrt_source = 0;

  I2C_Cmd(I2C2, ENABLE);
  I2C_ClearITPendingBit(I2C2, 0xFFFF);

  I2C_WriteDataCmd(I2C2, addr);
  I2C_WriteDataCmd(I2C2, I2C_DATA_CMD_READ | I2C_DATA_CMD_STOP);

  while((I2C_GetFlagStatus(I2C2, I2C_FLAG_RFNE) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) == RESET));
  while(I2C_GetFlagStatus(I2C2, I2C_FLAG_MST_ACTIVITY) != RESET);
  if(I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) != RESET) {
    abrt_source = I2C_GetTxAbortSource(I2C2);
    I2C_ClearITPendingBit(I2C2, I2C_IT_TX_ABRT);
  }
  else if(I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) != RESET) {
    abrt_source = 0xFFFFFFFF;
    I2C_ClearITPendingBit(I2C2, I2C_IT_SCL_STUCK_AT_LOW);
  }
  else {
    *pdata = I2C_ReadData(I2C2);
  }

  I2C_Cmd(I2C2, DISABLE);

  return abrt_source;
}

uint32_t eeprom_24c02_sequential_read(uint8_t addr, uint8_t* pbuf, uint32_t len)
{
  uint32_t abrt_source = 0;

  I2C_Cmd(I2C2, ENABLE);
  I2C_ClearITPendingBit(I2C2, 0xFFFF);

  I2C_WriteDataCmd(I2C2, addr);
  while(len)
  {
    if(len == 1) {
      I2C_WriteDataCmd(I2C2, I2C_DATA_CMD_READ | I2C_DATA_CMD_STOP);
    }
    else {
      I2C_WriteDataCmd(I2C2, I2C_DATA_CMD_READ);
    }
    while((I2C_GetFlagStatus(I2C2, I2C_FLAG_RFNE) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) == RESET));
    if((I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) != RESET) || (I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) != RESET)) {
      break;
    }
    *pbuf = I2C_ReadData(I2C2);
    pbuf++;
    len--;
  }
  while((I2C_GetFlagStatus(I2C2, I2C_FLAG_TFE) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) == RESET));
  while(I2C_GetFlagStatus(I2C2, I2C_FLAG_MST_ACTIVITY) != RESET);
  if(I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) != RESET) {
    abrt_source = I2C_GetTxAbortSource(I2C2);
    I2C_ClearITPendingBit(I2C2, I2C_IT_TX_ABRT);
  }
  else if(I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) != RESET) {
    abrt_source = 0xFFFFFFFF;
    I2C_ClearITPendingBit(I2C2, I2C_IT_SCL_STUCK_AT_LOW);
  }

  I2C_Cmd(I2C2, DISABLE);

  return abrt_source;
}

uint32_t eeprom_24c02_byte_write(uint8_t addr, uint8_t data)
{
  uint32_t abrt_source = 0;

  I2C_Cmd(I2C2, ENABLE);
  I2C_ClearITPendingBit(I2C2, 0xFFFF);

  I2C_WriteDataCmd(I2C2, addr);
  I2C_WriteDataCmd(I2C2, data | I2C_DATA_CMD_STOP);

  while((I2C_GetFlagStatus(I2C2, I2C_FLAG_TFE) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) == RESET));
  while(I2C_GetFlagStatus(I2C2, I2C_FLAG_MST_ACTIVITY) != RESET);
  if(I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) != RESET) {
    abrt_source = I2C_GetTxAbortSource(I2C2);
    I2C_ClearITPendingBit(I2C2, I2C_IT_TX_ABRT);
  }
  else if(I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) != RESET) {
    abrt_source = 0xFFFFFFFF;
    I2C_ClearITPendingBit(I2C2, I2C_IT_SCL_STUCK_AT_LOW);
  }
  I2C_Cmd(I2C2, DISABLE);

  return abrt_source;
}

uint32_t eeprom_24c02_page_write(uint8_t addr, const uint8_t* pdata, uint8_t len)
{
  uint32_t abrt_source = 0;

  I2C_Cmd(I2C2, ENABLE);
  I2C_ClearITPendingBit(I2C2, 0xFFFF);

  I2C_WriteDataCmd(I2C2, addr);
  while(len)
  {
    while(I2C_GetFlagStatus(I2C2, I2C_FLAG_TFNF) == RESET);
    if((I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) != RESET) || (I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) != RESET)) {
      break;
    }
    if(len == 1) {
      I2C_WriteDataCmd(I2C2, *pdata | I2C_DATA_CMD_STOP);
    }
    else {
      I2C_WriteDataCmd(I2C2, *pdata);
    }
    pdata++;
    len--;
  }

  while((I2C_GetFlagStatus(I2C2, I2C_FLAG_TFE) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) == RESET));
  while(I2C_GetFlagStatus(I2C2, I2C_FLAG_MST_ACTIVITY) != RESET);
  if(I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) != RESET) {
    abrt_source = I2C_GetTxAbortSource(I2C2);
    I2C_ClearITPendingBit(I2C2, I2C_IT_TX_ABRT);
  }
  else if(I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) != RESET) {
    abrt_source = 0xFFFFFFFF;
    I2C_ClearITPendingBit(I2C2, I2C_IT_SCL_STUCK_AT_LOW);
  }

  I2C_Cmd(I2C2, DISABLE);

  return abrt_source;
}

uint32_t eeprom_24c02_probe(void)
{
  uint32_t abrt_source = 0;

  I2C_Cmd(I2C2, ENABLE);
  I2C_ClearITPendingBit(I2C2, 0xFFFF);

  I2C_WriteDataCmd(I2C2, I2C_DATA_CMD_STOP);

  while((I2C_GetFlagStatus(I2C2, I2C_FLAG_TFE) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) == RESET) && (I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) == RESET));
  while(I2C_GetFlagStatus(I2C2, I2C_FLAG_MST_ACTIVITY) != RESET);
  if(I2C_GetRawITStatus(I2C2, I2C_IT_TX_ABRT) != RESET) {
    abrt_source = I2C_GetTxAbortSource(I2C2);
    I2C_ClearITPendingBit(I2C2, I2C_IT_TX_ABRT);
  }
  else if(I2C_GetRawITStatus(I2C2, I2C_IT_SCL_STUCK_AT_LOW) != RESET) {
    abrt_source = 0xFFFFFFFF;
    I2C_ClearITPendingBit(I2C2, I2C_IT_SCL_STUCK_AT_LOW);
  }
  I2C_Cmd(I2C2, DISABLE);

  return abrt_source;
}

