/******************************************************************************
 * @file     mg32f157.h
 * @brief    CMSIS Core Peripheral Access Layer Header File for
 *           mg32f157 Device Series
 * @version  V0.0.4
 * @date     16-June-2023
 * @attention
 * 
 * Copyright (c) 2023 Megawin Technology (Shenzhen) Corp., Ltd
 * All rights reserved.
 * 
 * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
 * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
 * TIME. AS A RESULT, MEGAWIN TECHNOLOGY SHALL NOT BE HELD LIABLE FOR ANY
 * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
 * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
 * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 * 
 ******************************************************************************/

/** @addtogroup CMSIS
  * @{
  */

/** @addtogroup mg32f157
  * @{
  */

#ifndef __MG32F157_H__
#define __MG32F157_H__

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup Library_configuration_section
  * @{
  */

#if !defined  USE_STDPERIPH_DRIVER
/**
 * @brief Comment the line below if you will not use the peripherals drivers.
 * In this case, these drivers will not be included and the application code will 
 * be based on direct access to peripherals registers 
 */
  /*#define USE_STDPERIPH_DRIVER*/
#endif


/**
 * @brief In the following line adjust the value of External High Speed oscillator (HSE)
 *        used in your application.
 * 
 * Tip: To avoid modifying this file each time you need to use different HSE, you
 *      can define the HSE value in your toolchain compiler preprocessor.
 */
#if !defined  HSE_VALUE
  #define HSE_VALUE     (8000000)  /*!< Value of the External oscillator in Hz */
#endif /* HSE_VALUE */


/**
 * @brief In the following line adjust the External High Speed oscillator (HSE) Startup 
 *        Timeout value 
 */
#define HSE_STARTUP_TIMEOUT (0x1000)   /*!< Time out for HSE start up */


/**
 * @brief MG32F157 Standard Peripheral Library version number
 */
#define __MG32F157_STDPERIPH_VERSION_MAIN   (0x00) /*!< [31:24] main version */
#define __MG32F157_STDPERIPH_VERSION_SUB1   (0x00) /*!< [23:16] sub1 version */
#define __MG32F157_STDPERIPH_VERSION_SUB2   (0x00) /*!< [15:8]  sub2 version */
#define __MG32F157_STDPERIPH_VERSION_RC     (0x00) /*!< [7:0]  release candidate */ 
#define __MG32F157_STDPERIPH_VERSION        ( (__MG32F157_STDPERIPH_VERSION_MAIN << 24)\
                                             |(__MG32F157_STDPERIPH_VERSION_SUB1 << 16)\
                                             |(__MG32F157_STDPERIPH_VERSION_SUB2 << 8)\
                                             |(__MG32F157_STDPERIPH_VERSION_RC))

/**
  * @}
  */

#define HSI_VALUE     (8000000)       /*!< Value of the Internal 8M oscillator in Hz*/
#define LSI_VALUE     (40000)         /*!< Value of the Internal 40K oscillator in Hz*/

/* -------------------------  Interrupt Number Definition  ------------------------ */

typedef enum IRQn
{
/* -------------------  Cortex-M3 Processor Exceptions Numbers  ------------------- */
  NonMaskableInt_IRQn           = -14,      /*  2 Non Maskable Interrupt */
  HardFault_IRQn                = -13,      /*  3 HardFault Interrupt */
  MemoryManagement_IRQn         = -12,      /*  4 Memory Management Interrupt */
  BusFault_IRQn                 = -11,      /*  5 Bus Fault Interrupt */
  UsageFault_IRQn               = -10,      /*  6 Usage Fault Interrupt */
  SVCall_IRQn                   =  -5,      /* 11 SV Call Interrupt */
  DebugMonitor_IRQn             =  -4,      /* 12 Debug Monitor Interrupt */
  PendSV_IRQn                   =  -2,      /* 14 Pend SV Interrupt */
  SysTick_IRQn                  =  -1,      /* 15 System Tick Interrupt */

/* ----------------------  MG32F157 Specific Interrupt Numbers  --------------------- */
  WWDG_IRQn                     =   0,      /*!< Window Watchdog Interrupt                            */
  PVD_IRQn                      =   1,      /*!< PVD through EXTI Line detection Interrupt            */
  TAMPER_IRQn                   =   2,      /*!< Tamper Interrupt                                     */
  RTC_IRQn                      =   3,      /*!< RTC global Interrupt                                 */
  FLASH_IRQn                    =   4,      /*!< FLASH global Interrupt                               */
  RCC_IRQn                      =   5,      /*!< RCC global Interrupt                                 */
  EXTI0_IRQn                    =   6,      /*!< EXTI Line0 Interrupt                                 */
  EXTI1_IRQn                    =   7,      /*!< EXTI Line1 Interrupt                                 */
  EXTI2_IRQn                    =   8,      /*!< EXTI Line2 Interrupt                                 */
  EXTI3_IRQn                    =   9,      /*!< EXTI Line3 Interrupt                                 */
  EXTI4_IRQn                    =   10,     /*!< EXTI Line4 Interrupt                                 */
  DMAC1_Channel1_IRQn           =   11,     /*!< DMAC1 Channel 1 global Interrupt                     */
  DMAC1_Channel2_IRQn           =   12,     /*!< DMAC1 Channel 2 global Interrupt                     */
  DMAC1_Channel3_IRQn           =   13,     /*!< DMAC1 Channel 3 global Interrupt                     */
  DMAC1_Channel4_IRQn           =   14,     /*!< DMAC1 Channel 4 global Interrupt                     */
  DMAC1_Channel5_IRQn           =   15,     /*!< DMAC1 Channel 5 global Interrupt                     */
  DMAC1_Channel6_IRQn           =   16,     /*!< DMAC1 Channel 6 global Interrupt                     */
  DMAC1_Channel7_IRQn           =   17,     /*!< DMAC1 Channel 7 global Interrupt                     */
  ADC1_2_IRQn                   =   18,     /*!< ADC1 and ADC2 global Interrupt                       */
  USB_DMA_CAN1_IRQn             =   19,     /*!< USB DMA or CAN1 global Interrupts                    */
  USB_IRQn                      =   20,     /*!< USB global Interrupts                                */
  EXTI9_5_IRQn                  =   23,     /*!< External Line[9:5] Interrupts                        */
  TIM1_BRK_IRQn                 =   24,     /*!< TIM1 Break Interrupt                                 */
  TIM1_UP_IRQn                  =   25,     /*!< TIM1 Update Interrupt                                */
  TIM1_TRG_COM_IRQn             =   26,     /*!< TIM1 Trigger and Commutation Interrupt               */
  TIM1_CC_IRQn                  =   27,     /*!< TIM1 Capture Compare Interrupt                       */
  TIM2_IRQn                     =   28,     /*!< TIM2 global Interrupt                                */
  TIM3_IRQn                     =   29,     /*!< TIM3 global Interrupt                                */
  TIM4_IRQn                     =   30,     /*!< TIM4 global Interrupt                                */
  I2C1_EV_IRQn                  =   31,     /*!< I2C1 Event Interrupt                                 */
  I2C1_ER_IRQn                  =   32,     /*!< I2C1 Error Interrupt                                 */
  I2C2_EV_IRQn                  =   33,     /*!< I2C2 Event Interrupt                                 */
  I2C2_ER_IRQn                  =   34,     /*!< I2C2 Error Interrupt                                 */
  SPI1_IRQn                     =   35,     /*!< SPI1 global Interrupt                                */
  SPI2_IRQn                     =   36,     /*!< SPI2 global Interrupt                                */
  USART1_IRQn                   =   37,     /*!< USART1 global Interrupt                              */
  USART2_IRQn                   =   38,     /*!< USART2 global Interrupt                              */
  USART3_IRQn                   =   39,     /*!< USART3 global Interrupt                              */
  EXTI15_10_IRQn                =   40,     /*!< External Line[15:10] Interrupts                      */
  RTCAlarm_IRQn                 =   41,     /*!< RTC Alarm through EXTI Line Interrupt                */
  TIM8_BRK_IRQn                 =   43,     /*!< TIM8 Break Interrupt                                 */
  TIM8_UP_IRQn                  =   44,     /*!< TIM8 Update Interrupt                                */
  TIM8_TRG_COM_IRQn             =   45,     /*!< TIM8 Trigger and Commutation Interrupt               */
  TIM8_CC_IRQn                  =   46,     /*!< TIM8 Capture Compare Interrupt                       */
  ADC3_IRQn                     =   47,     /*!< ADC3 global Interrupt                                */
  SDIO_IRQn                     =   49,     /*!< SDIO global Interrupt                                */
  TIM5_IRQn                     =   50,     /*!< TIM5 global Interrupt                                */
  SPI3_IRQn                     =   51,     /*!< SPI3 global Interrupt                                */
  UART4_IRQn                    =   52,     /*!< UART4 global Interrupt                               */
  UART5_IRQn                    =   53,     /*!< UART5 global Interrupt                               */
  TIM6_IRQn                     =   54,     /*!< TIM6 global Interrupt                                */
  TIM7_IRQn                     =   55,     /*!< TIM7 global Interrupt                                */
  DMAC2_Channel1_IRQn           =   56,     /*!< DMAC2 Channel 1 global Interrupt                     */
  DMAC2_Channel2_IRQn           =   57,     /*!< DMAC2 Channel 2 global Interrupt                     */
  DMAC2_Channel3_IRQn           =   58,     /*!< DMAC2 Channel 3 global Interrupt                     */
  DMAC2_Channel4_5_IRQn         =   59,     /*!< DMAC2 Channel 4 and Channel 5 global Interrupt       */
  QUADSPI_IRQn                  =   60,     /*!< QUADSPI global Interrupt                             */
  RNG_IRQn                      =   61,     /*!< RNG global Interrupt                                 */
  AES_IRQn                      =   62,     /*!< AES global Interrupt                                 */
  USART_EXTI_IRQn               =   63,     /*!< USART wakeup EXTI line Interrupt                     */
} IRQn_Type;


/* ================================================================================ */
/* ================      Processor and Core Peripheral Section     ================ */
/* ================================================================================ */

/* -------  Start of section using anonymous unions and disabling warnings  ------- */
#if   defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* --------  Configuration of the Cortex-M3 Processor and Core Peripherals  ------- */
#define __CM3_REV                 0x0201U   /* Core revision r2p1 */
#define __MPU_PRESENT             0         /* MG32F157 devices does not provide an MPU */
#define __VTOR_PRESENT            1         /* VTOR present or not */
#define __NVIC_PRIO_BITS          4         /* Number of Bits used for Priority Levels */
#define __Vendor_SysTickConfig    0         /* Set to 1 if different SysTick Config is used */

#include "core_cm3.h"                       /* Processor and core peripherals */
#include "system_mg32f157.h"                /* System Header */



typedef enum {RESET = 0, SET = !RESET} FlagStatus, ITStatus;

typedef enum {DISABLE = 0, ENABLE = !DISABLE} FunctionalState;
#define IS_FUNCTIONAL_STATE(STATE) (((STATE) == DISABLE) || ((STATE) == ENABLE))

typedef enum {INACTIVE = 0, ACTIVE = !INACTIVE} SignalState;

typedef enum {ERROR = 0, SUCCESS = !ERROR} ErrorStatus;


/* ================================================================================ */
/* ================       Device Specific Peripheral Section       ================ */
/* ================================================================================ */


/** @addtogroup Peripheral_registers_structures
  * @{
  */

/* ================================================================================ */
/* ================       Analog to Digital Converter (ADC)        ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t SR;               /*!< ADC status register,                                    Address offset: 0x000 */
  __IO uint32_t CR1;              /*!< ADC control register 1,                                 Address offset: 0x004 */
  __IO uint32_t CR2;              /*!< ADC control register 2,                                 Address offset: 0x008 */
  __IO uint32_t SMPR1;            /*!< ADC sample time register 1,                             Address offset: 0x00C */
  __IO uint32_t SMPR2;            /*!< ADC sample time register 2,                             Address offset: 0x010 */
  __IO uint32_t JOFR1;            /*!< ADC injected channel data offset register 1,            Address offset: 0x014 */
  __IO uint32_t JOFR2;            /*!< ADC injected channel data offset register 2,            Address offset: 0x018 */
  __IO uint32_t JOFR3;            /*!< ADC injected channel data offset register 3,            Address offset: 0x01C */
  __IO uint32_t JOFR4;            /*!< ADC injected channel data offset register 4,            Address offset: 0x020 */
  __IO uint32_t HTR;              /*!< ADC watchdog high threshold register,                   Address offset: 0x024 */
  __IO uint32_t LTR;              /*!< ADC watchdog low threshold register,                    Address offset: 0x028 */
  __IO uint32_t SQR1;             /*!< ADC regular sequence register 1,                        Address offset: 0x02C */
  __IO uint32_t SQR2;             /*!< ADC regular sequence register 2,                        Address offset: 0x030 */
  __IO uint32_t SQR3;             /*!< ADC regular sequence register 3,                        Address offset: 0x034 */
  __IO uint32_t JSQR;             /*!< ADC injected sequence register,                         Address offset: 0x038 */
  __IO uint32_t JDR1;             /*!< ADC injected data register 1,                           Address offset: 0x03C */
  __IO uint32_t JDR2;             /*!< ADC injected data register 2,                           Address offset: 0x040 */
  __IO uint32_t JDR3;             /*!< ADC injected data register 3,                           Address offset: 0x044 */
  __IO uint32_t JDR4;             /*!< ADC injected data register 4,                           Address offset: 0x048 */
  __IO uint32_t DR;               /*!< ADC regular data register,                              Address offset: 0x04C */
} ADC_TypeDef;


/* ================================================================================ */
/* ================             Backup Registers (BKP)             ================ */
/* ================================================================================ */
typedef struct
{
       uint32_t  RESERVED0;       /*!< Reserved */
  __IO uint16_t DR1;              /*!< Backup data 1 register,                                 Address offset: 0x004 */
       uint16_t  RESERVED1;       /*!< Reserved */
  __IO uint16_t DR2;              /*!< Backup data 2 register,                                 Address offset: 0x008 */
       uint16_t  RESERVED2;       /*!< Reserved */
  __IO uint16_t DR3;              /*!< Backup data 3 register,                                 Address offset: 0x00C */
       uint16_t  RESERVED3;       /*!< Reserved */
  __IO uint16_t DR4;              /*!< Backup data 4 register,                                 Address offset: 0x010 */
       uint16_t  RESERVED4;       /*!< Reserved */
  __IO uint16_t DR5;              /*!< Backup data 5 register,                                 Address offset: 0x014 */
       uint16_t  RESERVED5;       /*!< Reserved */
  __IO uint16_t DR6;              /*!< Backup data 6 register,                                 Address offset: 0x018 */
       uint16_t  RESERVED6;       /*!< Reserved */
  __IO uint16_t DR7;              /*!< Backup data 7 register,                                 Address offset: 0x01C */
       uint16_t  RESERVED7;       /*!< Reserved */
  __IO uint16_t DR8;              /*!< Backup data 8 register,                                 Address offset: 0x020 */
       uint16_t  RESERVED8;       /*!< Reserved */
  __IO uint16_t DR9;              /*!< Backup data 9 register,                                 Address offset: 0x024 */
       uint16_t  RESERVED9;       /*!< Reserved */
  __IO uint16_t DR10;             /*!< Backup data 10 register,                                Address offset: 0x028 */
       uint16_t  RESERVED10;      /*!< Reserved */
  __IO uint16_t RTCCR;            /*!< RTC clock calibration register                          Address offset: 0x02C */
       uint16_t  RESERVED11;      /*!< Reserved */
  __IO uint16_t CR;               /*!< Backup control register                                 Address offset: 0x030 */
       uint16_t  RESERVED12;      /*!< Reserved */
  __IO uint16_t CSR;              /*!< Backup control/status register                          Address offset: 0x034 */
       uint16_t  RESERVED13[5];   /*!< Reserved */
  __IO uint16_t DR11;             /*!< Backup data 11 register,                                Address offset: 0x040 */
       uint16_t  RESERVED14;      /*!< Reserved */
  __IO uint16_t DR12;             /*!< Backup data 12 register,                                Address offset: 0x044 */
       uint16_t  RESERVED15;      /*!< Reserved */
  __IO uint16_t DR13;             /*!< Backup data 13 register,                                Address offset: 0x048 */
       uint16_t  RESERVED16;      /*!< Reserved */
  __IO uint16_t DR14;             /*!< Backup data 14 register,                                Address offset: 0x04C */
       uint16_t  RESERVED17;      /*!< Reserved */
  __IO uint16_t DR15;             /*!< Backup data 15 register,                                Address offset: 0x050 */
       uint16_t  RESERVED18;      /*!< Reserved */
  __IO uint16_t DR16;             /*!< Backup data 16 register,                                Address offset: 0x054 */
       uint16_t  RESERVED19;      /*!< Reserved */
  __IO uint16_t DR17;             /*!< Backup data 17 register,                                Address offset: 0x058 */
       uint16_t  RESERVED20;      /*!< Reserved */
  __IO uint16_t DR18;             /*!< Backup data 18 register,                                Address offset: 0x05C */
       uint16_t  RESERVED21;      /*!< Reserved */
  __IO uint16_t DR19;             /*!< Backup data 19 register,                                Address offset: 0x060 */
       uint16_t  RESERVED22;      /*!< Reserved */
  __IO uint16_t DR20;             /*!< Backup data 20 register,                                Address offset: 0x064 */
       uint16_t  RESERVED23;      /*!< Reserved */
  __IO uint16_t DR21;             /*!< Backup data 21 register,                                Address offset: 0x068 */
       uint16_t  RESERVED24;      /*!< Reserved */
  __IO uint16_t DR22;             /*!< Backup data 22 register,                                Address offset: 0x06C */
       uint16_t  RESERVED25;      /*!< Reserved */
  __IO uint16_t DR23;             /*!< Backup data 23 register,                                Address offset: 0x070 */
       uint16_t  RESERVED26;      /*!< Reserved */
  __IO uint16_t DR24;             /*!< Backup data 24 register,                                Address offset: 0x074 */
       uint16_t  RESERVED27;      /*!< Reserved */
  __IO uint16_t DR25;             /*!< Backup data 25 register,                                Address offset: 0x078 */
       uint16_t  RESERVED28;      /*!< Reserved */
  __IO uint16_t DR26;             /*!< Backup data 26 register,                                Address offset: 0x07C */
       uint16_t  RESERVED29;      /*!< Reserved */
  __IO uint16_t DR27;             /*!< Backup data 27 register,                                Address offset: 0x080 */
       uint16_t  RESERVED30;      /*!< Reserved */
  __IO uint16_t DR28;             /*!< Backup data 28 register,                                Address offset: 0x084 */
       uint16_t  RESERVED31;      /*!< Reserved */
  __IO uint16_t DR29;             /*!< Backup data 29 register,                                Address offset: 0x088 */
       uint16_t  RESERVED32;      /*!< Reserved */
  __IO uint16_t DR30;             /*!< Backup data 30 register,                                Address offset: 0x08C */
       uint16_t  RESERVED33;      /*!< Reserved */
  __IO uint16_t DR31;             /*!< Backup data 31 register,                                Address offset: 0x090 */
       uint16_t  RESERVED34;      /*!< Reserved */
  __IO uint16_t DR32;             /*!< Backup data 32 register,                                Address offset: 0x094 */
       uint16_t  RESERVED35;      /*!< Reserved */
  __IO uint16_t DR33;             /*!< Backup data 33 register,                                Address offset: 0x098 */
       uint16_t  RESERVED36;      /*!< Reserved */
  __IO uint16_t DR34;             /*!< Backup data 34 register,                                Address offset: 0x09C */
       uint16_t  RESERVED37;      /*!< Reserved */
  __IO uint16_t DR35;             /*!< Backup data 35 register,                                Address offset: 0x0A0 */
       uint16_t  RESERVED38;      /*!< Reserved */
  __IO uint16_t DR36;             /*!< Backup data 36 register,                                Address offset: 0x0A4 */
       uint16_t  RESERVED39;      /*!< Reserved */
  __IO uint16_t DR37;             /*!< Backup data 37 register,                                Address offset: 0x0A8 */
       uint16_t  RESERVED40;      /*!< Reserved */
  __IO uint16_t DR38;             /*!< Backup data 38 register,                                Address offset: 0x0AC */
       uint16_t  RESERVED41;      /*!< Reserved */
  __IO uint16_t DR39;             /*!< Backup data 39 register,                                Address offset: 0x0B0 */
       uint16_t  RESERVED42;      /*!< Reserved */
  __IO uint16_t DR40;             /*!< Backup data 40 register,                                Address offset: 0x0B4 */
       uint16_t  RESERVED43;      /*!< Reserved */
  __IO uint16_t DR41;             /*!< Backup data 41 register,                                Address offset: 0x0B8 */
       uint16_t  RESERVED44;      /*!< Reserved */
  __IO uint16_t DR42;             /*!< Backup data 42 register,                                Address offset: 0x0BC */
       uint16_t  RESERVED45;      /*!< Reserved */
} BKP_TypeDef;


/* ================================================================================ */
/* ================          Controller Area Network (CAN)         ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t ISR_SR_CMR_MR;          /*!< CAN ISR SR CMR MR register,                       Address offset: 0x000 */
  __IO uint32_t BT1_BT0_RMC_IMR;        /*!< CAN BT0 BT1 RMC IMR register,                     Address offset: 0x004 */
  __IO uint32_t TXBUF;                  /*!< CAN Transmit Buffer register,                     Address offset: 0x008 */
  __IO uint32_t RXBUF;                  /*!< CAN Receive Buffer register,                      Address offset: 0x00C */
  __IO uint32_t ACR;                    /*!< CAN Acceptance Code register,                     Address offset: 0x010 */
  __IO uint32_t AMR;                    /*!< CAN Acceptance Mask register,                     Address offset: 0x014 */
  __IO uint32_t ALC_TXERR_RXERR_ECC;    /*!< CAN ALC TXERR RXERR ECC register,                 Address offset: 0x018 */
  __IO uint32_t NBT;                    /*!< CAN FD Arbitration Phase Bit Timming register,    Address offset: 0x01C */
  __IO uint32_t SSPP_TDCR_DBT;          /*!< CAN FD SSPP TDCR status register,                 Address offset: 0x020 */
  __IO uint32_t APERR_DPERR_FDSR_FDCFG; /*!< CAN FD APERR DPERR  FDSR FDCFG register,          Address offset: 0x024 */
  __IO uint32_t TEST;                   /*!< CAN test register,                                Address offset: 0x028 */
} CAN_TypeDef;


/* ================================================================================ */
/* ================          Cyclic Redundancy Check (CRC)         ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t DR;               /*!< Data register,                                          Address offset: 0x000 */
  __IO uint8_t  IDR;              /*!< Independent data register,                              Address offset: 0x004 */
       uint8_t  RESERVED0;        /*!< Reserved */
       uint16_t RESERVED1;        /*!< Reserved */
  __IO uint32_t CR;               /*!< Control register,                                       Address offset: 0x008 */
} CRC_TypeDef;


/* ================================================================================ */
/* ================      True random number generator (TRNG)       ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CR;               /*!< Control register,                                       Address offset: 0x000 */
  __IO uint32_t SR;               /*!< Status register,                                        Address offset: 0x004 */
  __IO uint32_t DR;               /*!< Date register,                                          Address offset: 0x008 */
} TRNG_TypeDef;


/* ================================================================================ */
/* ================          operational amplifier (OPA)           ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CSR;              /*!< control/status register,                                Address offset: 0x00 */
  __IO uint32_t OTR;              /*!< offset trimming in normal mode register,                Address offset: 0x04 */
  __IO uint32_t LPOTR;            /*!< offset trimming in low power register,                  Address offset: 0x08 */
} OPA_TypeDef;


/* ================================================================================ */
/* ================       Digital to Analog Converter (DAC)        ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CR;               /*!< DAC control register,                                    Address offset: 0x000 */
  __IO uint32_t SWTRIGR;          /*!< DAC software trigger register,                           Address offset: 0x004 */
  __IO uint32_t DHR12R1;          /*!< DAC channel1 12-bit right-aligned data holding register, Address offset: 0x008 */
  __IO uint32_t DHR12L1;          /*!< DAC channel1 12-bit left aligned data holding register,  Address offset: 0x00C */
  __IO uint32_t DHR8R1;           /*!< DAC channel1 8-bit right aligned data holding register,  Address offset: 0x010 */
  __IO uint32_t DHR12R2;          /*!< DAC channel2 12-bit right aligned data holding register, Address offset: 0x014 */
  __IO uint32_t DHR12L2;          /*!< DAC channel2 12-bit left aligned data holding register,  Address offset: 0x018 */
  __IO uint32_t DHR8R2;           /*!< DAC channel2 8-bit right-aligned data holding register,  Address offset: 0x01C */
  __IO uint32_t DHR12RD;          /*!< DUAL DAC 12-bit right-aligned data holding register,     Address offset: 0x020 */
  __IO uint32_t DHR12LD;          /*!< DUAL DAC 12-bit left aligned data holding register,      Address offset: 0x024 */
  __IO uint32_t DHR8RD;           /*!< DUAL DAC 8-bit right aligned data holding register,      Address offset: 0x028 */
  __IO uint32_t DOR1;             /*!< DAC channel1 data output register,                       Address offset: 0x02C */
  __IO uint32_t DOR2;             /*!< DAC channel2 data output register,                       Address offset: 0x030 */
} DAC_TypeDef;


/* ================================================================================ */
/* ================               Debug MCU (DEBUG)                ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t IDCODE;           /*!< DBGMCU_IDCODE register,                                 Address offset: 0x000 */
  __IO uint32_t CR;               /*!< DBGMCU_CR register,                                     Address offset: 0x004 */
}DBGMCU_TypeDef;


/* ================================================================================ */
/* ================       Advanced Encryption Standard (AES)       ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CR;               /*!< AES control register,                                   Address offset: 0x00 */
  __IO uint32_t SR;               /*!< AES status register,                                    Address offset: 0x04 */
  __IO uint32_t DINR;             /*!< AES data input register,                                Address offset: 0x08 */
  __IO uint32_t DOUTR;            /*!< AES data output register,                               Address offset: 0x0C */
  __IO uint32_t KEYR0;            /*!< AES key register 0,                                     Address offset: 0x10 */
  __IO uint32_t KEYR1;            /*!< AES key register 1,                                     Address offset: 0x14 */
  __IO uint32_t KEYR2;            /*!< AES key register 2,                                     Address offset: 0x18 */
  __IO uint32_t KEYR3;            /*!< AES key register 3,                                     Address offset: 0x1C */
  __IO uint32_t IVR0;             /*!< AES initialization vector register 0,                   Address offset: 0x20 */
  __IO uint32_t IVR1;             /*!< AES initialization vector register 1,                   Address offset: 0x24 */
  __IO uint32_t IVR2;             /*!< AES initialization vector register 2,                   Address offset: 0x28 */
  __IO uint32_t IVR3;             /*!< AES initialization vector register 3,                   Address offset: 0x2C */
} AES_TypeDef;


/* ================================================================================ */
/* ==============        Direct Memory Access Controller (DMAC)       ============= */
/* ================================================================================ */
typedef struct
{
  struct {
    __IOM uint32_t SAR;           /*!< Channel x Source Address Register,                   Address offset: 0x000, 0x058, 0x0B0, 0x108, 0x160, 0x1B8, 0x210 */    uint32_t Undefined_SAR;
    __IOM uint32_t DAR;           /*!< Channel x Destination Address Register,              Address offset: 0x008, 0x060, 0x0B8, 0x110, 0x168, 0x1C0, 0x218 */    uint32_t Undefined_DAR;
    __IOM uint32_t LLP;           /*!< Channel x Linked List Pointer Register,              Address offset: 0x010, 0x068, 0x0CO, 0x118, 0x170, 0x1C8, 0x220 */    uint32_t Undefined_LLP;
    __IOM uint32_t CTLL;          /*!< Channel x Control Low Register,                      Address offset: 0x018, 0x070, 0x0C8, 0x120, 0x178, 0x1D0, 0x228 */
    __IOM uint32_t CTLH;          /*!< Channel x Control High Register,                     Address offset: 0x01C, 0x074, 0x0CC, 0x124, 0x17C, 0x1D4, 0x22C */
    __IOM uint32_t SSTAT;         /*!< Channel x Source Status Register,                    Address offset: 0x020, 0x078, 0x0D0, 0x128, 0x180, 0x1D8, 0x230 */    uint32_t Undefined_SSTAT;
    __IOM uint32_t DSTAT;         /*!< Channel x Destination Status Register,               Address offset: 0x028, 0x080, 0x0D8, 0x130, 0x188, 0x1E0, 0x238 */    uint32_t Undefined_DSTAT;
    __IOM uint32_t SSTATAR;       /*!< Channel x Source Status Address Register,            Address offset: 0x030, 0x088, 0x0E0, 0x138, 0x190, 0x1E8, 0x240 */    uint32_t Undefined_SSTATAR;
    __IOM uint32_t DSTATAR;       /*!< Channel x Destination Status Address Register,       Address offset: 0x038, 0x090, 0x0E8, 0x140, 0x198, 0x1F0, 0x248 */    uint32_t Undefined_DSTATAR;
    __IOM uint32_t CFGL;          /*!< Channel x Configuration Low Register,                Address offset: 0x040, 0x098, 0x0F0, 0x148, 0x1A0, 0x1F8, 0x250 */
    __IOM uint32_t CFGH;          /*!< Channel x Configuration High Register,               Address offset: 0x044, 0x09C, 0x0F4, 0x14C, 0x1A4, 0x1FC, 0x254 */
          uint32_t RESERVED0[4];  /*!< Reserved */
  } Ch[7];
        uint32_t RESERVED1[22];   /*!< Reserved,                                                    0x268 - 0x2BC */
  __IM  uint32_t RawTfr;          /*!< Raw Status for IntTfr Interrupt,                     Address offset: 0x2C0 */    uint32_t Undefined_RawTfr;
  __IM  uint32_t RawBlock;        /*!< Raw Status for IntBlock Interrupt,                   Address offset: 0x2C8 */    uint32_t Undefined_RawBlock;
  __IM  uint32_t RawSrcTran;      /*!< Raw Status for IntSrcTran Interrupt,                 Address offset: 0x2D0 */    uint32_t Undefined_RawSrcTran;
  __IM  uint32_t RawDstTran;      /*!< Raw Status for IntDstTran Interrupt,                 Address offset: 0x2D8 */    uint32_t Undefined_RawDstTran;
  __IM  uint32_t RawErr;          /*!< Raw Status for IntErr Interrupt,                     Address offset: 0x2E0 */    uint32_t Undefined_RawErr;
  __IM  uint32_t StatusTfr;       /*!< Status for IntTfr Interrupt,                         Address offset: 0x2E8 */    uint32_t Undefined_StatusTfr;
  __IM  uint32_t StatusBlock;     /*!< Status for IntBlock Interrupt,                       Address offset: 0x2F0 */    uint32_t Undefined_StatusBlock;
  __IM  uint32_t StatusSrcTran;   /*!< Status for IntSrcTran Interrupt,                     Address offset: 0x2F8 */    uint32_t Undefined_StatusSrcTran;
  __IM  uint32_t StatusDstTran;   /*!< Status for IntDstTran Interrupt,                     Address offset: 0x300 */    uint32_t Undefined_StatusDstTran;
  __IM  uint32_t StatusErr;       /*!< Status for IntErr Interrupt,                         Address offset: 0x308 */    uint32_t Undefined_StatusErr;
  __IOM uint32_t MaskTfr;         /*!< Mask for IntTfr Interrupt,                           Address offset: 0x310 */    uint32_t Undefined_MaskTfr;
  __IOM uint32_t MaskBlock;       /*!< Mask for IntBlock Interrupt,                         Address offset: 0x318 */    uint32_t Undefined_MaskBlock;
  __IOM uint32_t MaskSrcTran;     /*!< Mask for IntSrcTran Interrupt,                       Address offset: 0x320 */    uint32_t Undefined_MaskSrcTran;
  __IOM uint32_t MaskDstTran;     /*!< Mask for IntDstTran Interrupt,                       Address offset: 0x328 */    uint32_t Undefined_MaskDstTran;
  __IOM uint32_t MaskErr;         /*!< Mask for IntErr Interrupt,                           Address offset: 0x330 */    uint32_t Undefined_MaskErr;
  __OM  uint32_t ClearTfr;        /*!< Clear for IntTfr Interrupt,                          Address offset: 0x338 */    uint32_t Undefined_ClearTfr;
  __OM  uint32_t ClearBlock;      /*!< Clear for IntBlock Interrupt,                        Address offset: 0x340 */    uint32_t Undefined_ClearBlock;
  __OM  uint32_t ClearSrcTran;    /*!< Clear for IntSrcTran Interrupt,                      Address offset: 0x348 */    uint32_t Undefined_ClearSrcTran;
  __OM  uint32_t ClearDstTran;    /*!< Clear for IntDstTran Interrupt,                      Address offset: 0x350 */    uint32_t Undefined_ClearDstTran;
  __OM  uint32_t ClearErr;        /*!< Clear for IntErr Interrupt,                          Address offset: 0x358 */    uint32_t Undefined_ClearErr;
  __IM  uint32_t StatusInt;       /*!< Status for each interrupt type,                      Address offset: 0x360 */    uint32_t Undefined_StatusInt;
  __IOM uint32_t ReqSrcReg;       /*!< Source Software Transaction Request Register,        Address offset: 0x368 */    uint32_t Undefined_ReqSrcReg;
  __IOM uint32_t ReqDstReg;       /*!< Destination Software Transaction Request Register,   Address offset: 0x370 */    uint32_t Undefined_ReqDstReg;
  __IOM uint32_t SglReqSrcReg;    /*!< Single Source Transaction Request Register,          Address offset: 0x378 */    uint32_t Undefined_SglReqSrcReg;
  __IOM uint32_t SglReqDstReg;    /*!< Single Destination Transaction Request Register,     Address offset: 0x380 */    uint32_t Undefined_SglReqDstReg;
  __IOM uint32_t LstSrcReg;       /*!< Last Source Transaction Request Register,            Address offset: 0x388 */    uint32_t Undefined_LstSrcReg;
  __IOM uint32_t LstDstReg;       /*!< Last Destination Transaction Request Register,       Address offset: 0x390 */    uint32_t Undefined_LstDstReg;
  __IOM uint32_t DmaCfgReg;       /*!< DMA Configuration Register,                          Address offset: 0x398 */    uint32_t Undefined_DmaCfgReg;
  __IOM uint32_t ChEnReg;         /*!< DMA Channel Enable Register,                         Address offset: 0x3A0 */    uint32_t Undefined_ChEnReg;
} DMAC_TypeDef;


/* ================================================================================ */
/* ==============             Universal Serial Bus (USB)              ============= */
/* ================================================================================ */
typedef struct
{
  __IOM uint8_t  FADDR;           /*!< Function address register,                                     Address offset: 0x000 */
  __IOM uint8_t  POWER;           /*!< Power management register,                                     Address offset: 0x001 */
  __IM  uint16_t INTRTX;          /*!< Interrupt register for Endpoint 0 plus TX Endpoints 1 to 15,   Address offset: 0x002 */
  __IM  uint16_t INTRRX;          /*!< Interrupt register for RX Endpoints 1 to 15,                   Address offset: 0x004 */
  __IOM uint16_t INTRTXE;         /*!< Interrupt enable register for IntrTx,                          Address offset: 0x006 */
  __IOM uint16_t INTRRXE;         /*!< Interrupt enable register for IntrRx,                          Address offset: 0x008 */
  __IM  uint8_t  INTRUSB;         /*!< Interrupt register for common USB interrupts,                  Address offset: 0x00A */
  __IOM uint8_t  INTRUSBE;        /*!< Interrupt enable register for IntrUSB,                         Address offset: 0x00B */
  __IM  uint16_t FRAME;           /*!< Frame number,                                                  Address offset: 0x00C */
  __IOM uint8_t  INDEX;           /*!< Index register,                                                Address offset: 0x00E */
  __IOM uint8_t  TESTMODE;        /*!< Testmode register,                                             Address offset: 0x00F */

  __IOM uint16_t TXMAXP;          /*!< Maximum packet size for peripheral TX endpoint,                Address offset: 0x010 */
  union {
  __IOM uint8_t  CSR0L;           /*!< Control Status Low register for Endpoint 0,                    Address offset: 0x012 */
  __IOM uint8_t  TXCSRL;          /*!< Control Status Low register for peripheral TX endpoint,        Address offset: 0x012 */
  };
  union {
  __IOM uint8_t  CSR0H;           /*!< Control Status High register for Endpoint 0,                   Address offset: 0x013 */
  __IOM uint8_t  TXCSRH;          /*!< Control Status High register for peripheral TX endpoint,       Address offset: 0x013 */
  };
  __IOM uint16_t RXMAXP;          /*!< Maximum packet size for peripheral RX endpoint,                Address offset: 0x014 */
  __IOM uint8_t  RXCSRL;          /*!< Control Status Low register for peripheral RX endpoint,        Address offset: 0x016 */
  __IOM uint8_t  RXCSRH;          /*!< Control Status High register for peripheral RX endpoint,       Address offset: 0x017 */
  union {
  __IM  uint16_t COUNT0;          /*!< Number of received bytes in Endpoint 0 FIFO,                   Address offset: 0x018 */
  __IM  uint16_t RXCOUNT;         /*!< Number of bytes in peripheral RX endpoint FIFO,                Address offset: 0x018 */
  };
  union {
  __IOM uint8_t  TYPE0;           /*!< Defines the speed of Endpoint 0 (host mode only),              Address offset: 0x01A */
  __IOM uint8_t  TXTYPE;          /*!< Control of the host TX endpoint (host mode only),              Address offset: 0x01A */
  };
  union {
  __IOM uint8_t  NAKLIMIT0;       /*!< NAKLIMIT0 register (host mode only),                           Address offset: 0x01B */
  __IOM uint8_t  TXINTERVAL;      /*!< TXINTERVAL register (host mode only),                          Address offset: 0x01B */
  };
  __IOM uint8_t  RXTYPE;          /*!< RXTYPE register (host mode only),                              Address offset: 0x01C */
  __IOM uint8_t  RXINTERVAL;      /*!< RXINTERVAL register (host mode only),                          Address offset: 0x01D */
        uint8_t  RESERVED1;       /*!< Reserved,                                                                      0x01E */
  union {
  __IOM uint8_t  CONFIGDATA;      /*!< Configuration information,                                     Address offset: 0x01F */
  __IOM uint8_t  FIFOSIZE;        /*!< FIFO size information,                                         Address offset: 0x01F */
  };

  __IOM uint32_t FIFO[16];        /*!< FIFOs for Endpoints 0 to 15,                           Address offset: 0x020 - 0x05F */

  __IOM uint8_t  DEVCTL;          /*!< DEVCTL register,                                               Address offset: 0x060 */
  __IOM uint8_t  MISC;            /*!< MISC register,                                                 Address offset: 0x061 */
  __IOM uint8_t  TXFIFOSZ;        /*!< TXFIFOSZ register,                                             Address offset: 0x062 */
  __IOM uint8_t  RXFIFOSZ;        /*!< RXFIFOSZ register,                                             Address offset: 0x063 */
  __IOM uint16_t TXFIFOADD;       /*!< TXFIFOADD register,                                            Address offset: 0x064 */
  __IOM uint16_t RXFIFOADD;       /*!< RXFIFOADD register,                                            Address offset: 0x066 */
  union {
  __OM  uint32_t VCONTROL;        /*!< VCONTROL register,                                             Address offset: 0x068 */
  __IM  uint32_t VSTATUS;         /*!< VSTATUS register,                                              Address offset: 0x068 */
  };
  __IM  uint16_t HWVERS;          /*!< Hardware Version Number register,                              Address offset: 0x06C */
        uint8_t  RESERVED2[10];   /*!< Reserved,                                                              0x06E - 0x077 */
  __IM  uint8_t  EPINFO;          /*!< EPINFO register,                                               Address offset: 0x078 */
  __IM  uint8_t  RAMINFO;         /*!< RAMINFO register,                                              Address offset: 0x079 */
  __IOM uint8_t  LINKINFO;        /*!< LINKINFO register,                                             Address offset: 0x07A */
  __IOM uint8_t  VPLEN;           /*!< VPLEN register,                                                Address offset: 0x07B */
  __IOM uint8_t  HS_EOF1;         /*!< HS_EOF1 register,                                              Address offset: 0x07C */
  __IOM uint8_t  FS_EOF1;         /*!< FS_EOF1 register,                                              Address offset: 0x07D */
  __IOM uint8_t  LS_EOF1;         /*!< LS_EOF1 register,                                              Address offset: 0x07E */
  __IOM uint8_t  SOFT_RST;        /*!< SOFT_RST register,                                             Address offset: 0x07F */
} USB_TypeDef;


/* ================================================================================ */
/* ================   External Interrupt/Event Controller (EXTI)   ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t IMR;              /*!< Interrupt mask register,                                       Address offset: 0x000 */
  __IO uint32_t EMR;              /*!< Event mask register,                                           Address offset: 0x004 */
  __IO uint32_t RTSR;             /*!< Rising trigger selection register,                             Address offset: 0x008 */
  __IO uint32_t FTSR;             /*!< Falling trigger selection register,                            Address offset: 0x00C */
  __IO uint32_t SWIER;            /*!< Software interrupt event register,                             Address offset: 0x010 */
  __IO uint32_t PR;               /*!< Pending register,                                              Address offset: 0x014 */
} EXTI_TypeDef;


/* ================================================================================ */
/* ================             FLASH Registers (FLASH)            ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t ACR;              /*!< Flash access control register,                                 Address offset: 0x000 */
  __IO uint32_t KEYR;             /*!< FPEC key register,                                             Address offset: 0x004 */
  __IO uint32_t OPTKEYR;          /*!< Flash OPTKEY register,                                         Address offset: 0x008 */
  __IO uint32_t SR;               /*!< Flash status register,                                         Address offset: 0x00C */
  __IO uint32_t CR;               /*!< Flash control register,                                        Address offset: 0x010 */
  __IO uint32_t AR;               /*!< Flash address register,                                        Address offset: 0x014 */
  __IO uint32_t RESERVED;         /*!< Reserved */
  __IO uint32_t OBR;              /*!< Option byte register,                                          Address offset: 0x01C */
  __IO uint32_t WRPR;             /*!< Write protection register,                                     Address offset: 0x020 */
  __IO uint32_t OP_MODE;          /*!< OP mode register,                                              Address offset: 0x024 */
} FLASH_TypeDef;


/* ================================================================================ */
/* ================           Option Bytes Registers (OP)          ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint16_t RDP;              /*!< Read protection option byte register,                          Address offset: 0x000 */
  __IO uint16_t USER;             /*!< User option byte register,                                     Address offset: 0x002 */
  __IO uint16_t Data0;            /*!< byte for user data storage register,                           Address offset: 0x004 */
  __IO uint16_t Data1;            /*!< byte for user data storage register,                           Address offset: 0x006 */
  __IO uint16_t WRP0;             /*!< Flash memory write protection option byte0 register,           Address offset: 0x008 */
  __IO uint16_t WRP1;             /*!< Flash memory write protection option byte1 register,           Address offset: 0x00A */
  __IO uint16_t WRP2;             /*!< Flash memory write protection option byte2 register,           Address offset: 0x00C */
  __IO uint16_t WRP3;             /*!< Flash memory write protection option byte3 register,           Address offset: 0x00E */
} OB_TypeDef;


/* ================================================================================ */
/* ================           General-purpose I/Os (GPIO)          ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CRL;              /*!< Port configuration register low,                               Address offset: 0x000 */
  __IO uint32_t CRH;              /*!< Port configuration register high,                              Address offset: 0x004 */
  __IO uint32_t IDR;              /*!< Port input data register,                                      Address offset: 0x008 */
  __IO uint32_t ODR;              /*!< Port output data register,                                     Address offset: 0x00C */
  __IO uint32_t BSRR;             /*!< Port bit set/reset register,                                   Address offset: 0x010 */
  __IO uint32_t BRR;              /*!< Port bit reset register,                                       Address offset: 0x014 */
  __IO uint32_t LCKR;             /*!< Port configuration lock register,                              Address offset: 0x018 */
} GPIO_TypeDef;


/* ================================================================================ */
/* ================          Alternate Function I/O (AFIO)         ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t EVCR;             /*!< Event control register,                                        Address offset: 0x000 */
  __IO uint32_t MAPR;             /*!< AF remap and debug I/O configuration register,                 Address offset: 0x004 */
  __IO uint32_t EXTICR[4];        /*!< External interrupt configuration registers,                    Address offset: 0x008 */
       uint32_t RESERVED0;        /*!< Reserved */
  __IO uint32_t MAPR2;            /*!< AF remap and debug I/O configuration register2,                Address offset: 0x01C */
} AFIO_TypeDef;


/* ================================================================================ */
/* ==============            Inter-Integrated Circuit (I2C)           ============= */
/* ================================================================================ */
typedef struct
{
  __IOM uint32_t CON;                         /*!< I2C Control Register,                                          Address offset: 0x000 */
  __IOM uint32_t TAR;                         /*!< I2C Target Address Register,                                   Address offset: 0x004 */
  __IOM uint32_t SAR;                         /*!< I2C Slave Address Register,                                    Address offset: 0x008 */
        uint32_t RESERVED0;                   /*!< Reserved */
  __IOM uint32_t DATA_CMD;                    /*!< I2C Rx/Tx Data Buffer and Command Register,                    Address offset: 0x010 */
  __IOM uint32_t SS_SCL_HCNT;                 /*!< Standard Speed I2C Clock SCL High Count Register,              Address offset: 0x014 */
  __IOM uint32_t SS_SCL_LCNT;                 /*!< Standard Speed I2C Clock SCL Low Count Register,               Address offset: 0x018 */
  __IOM uint32_t FS_SCL_HCNT;                 /*!< Fast Mode or Fast Mode Plus I2C Clock SCL High Count Register, Address offset: 0x01C */
  __IOM uint32_t FS_SCL_LCNT;                 /*!< Fast Mode or Fast Mode Plus I2C Clock SCL Low Count Register,  Address offset: 0x020 */
        uint32_t RESERVED1;                   /*!< Reserved */
        uint32_t RESERVED2;                   /*!< Reserved */
  __IM  uint32_t INTR_STAT;                   /*!< I2C Interrupt Status Register,                                 Address offset: 0x02C */
  __IOM uint32_t INTR_MASK;                   /*!< I2C Interrupt Mask Register,                                   Address offset: 0x030 */
  __IM  uint32_t RAW_INTR_STAT;               /*!< I2C Raw Interrupt Status Register,                             Address offset: 0x034 */
  __IOM uint32_t RX_TL;                       /*!< I2C Receive FIFO Threshold Register,                           Address offset: 0x038 */
  __IOM uint32_t TX_TL;                       /*!< I2C Transmit FIFO Threshold Register,                          Address offset: 0x03C */
  __IM  uint32_t CLR_INTR;                    /*!< Clear Combined and Individual Interrupt Register,              Address offset: 0x040 */
  __IM  uint32_t CLR_RX_UNDER;                /*!< Clear RX_UNDER Interrupt Register,                             Address offset: 0x044 */
  __IM  uint32_t CLR_RX_OVER;                 /*!< Clear RX_OVER Interrupt Register,                              Address offset: 0x048 */
  __IM  uint32_t CLR_TX_OVER;                 /*!< Clear TX_OVER Interrupt Register,                              Address offset: 0x04C */
  __IM  uint32_t CLR_RD_REQ;                  /*!< Clear RD_REQ Interrupt Register,                               Address offset: 0x050 */
  __IM  uint32_t CLR_TX_ABRT;                 /*!< Clear TX_ABRT Interrupt Register,                              Address offset: 0x054 */
  __IM  uint32_t CLR_RX_DONE;                 /*!< Clear RX_DONE Interrupt Register,                              Address offset: 0x058 */
  __IM  uint32_t CLR_ACTIVITY;                /*!< Clear ACTIVITY Interrupt Register,                             Address offset: 0x05C */
  __IM  uint32_t CLR_STOP_DET;                /*!< Clear STOP_DET Interrupt Register,                             Address offset: 0x060 */
  __IM  uint32_t CLR_START_DET;               /*!< Clear START_DET Interrupt Register,                            Address offset: 0x064 */
  __IM  uint32_t CLR_GEN_CALL;                /*!< Clear GEN_CALL Interrupt Register,                             Address offset: 0x068 */
  __IOM uint32_t ENABLE;                      /*!< I2C Enable Register,                                           Address offset: 0x06C */
  __IM  uint32_t STATUS;                      /*!< I2C Status Register,                                           Address offset: 0x070 */
  __IM  uint32_t TXFLR;                       /*!< I2C Transmit FIFO Level Register,                              Address offset: 0x074 */
  __IM  uint32_t RXFLR;                       /*!< I2C Receive FIFO Level Register,                               Address offset: 0x078 */
  __IOM uint32_t SDA_HOLD;                    /*!< I2C SDA Hold Time Length Register,                             Address offset: 0x07C */
  __IM  uint32_t TX_ABRT_SOURCE;              /*!< I2C Transmit Abort Source Register,                            Address offset: 0x080 */
        uint32_t RESERVED3;                   /*!< Reserved */
  __IOM uint32_t DMA_CR;                      /*!< DMA Control Register,                                          Address offset: 0x088 */
  __IOM uint32_t DMA_TDLR;                    /*!< DMA Transmit Data Level Register,                              Address offset: 0x08C */
  __IOM uint32_t DMA_RDLR;                    /*!< DMA Receive Data Level Register,                               Address offset: 0x090 */
  __IOM uint32_t SDA_SETUP;                   /*!< I2C SDA Setup Register,                                        Address offset: 0x094 */
  __IOM uint32_t ACK_GENERAL_CALL;            /*!< I2C ACK General Call Register,                                 Address offset: 0x098 */
  __IM  uint32_t ENABLE_STATUS;               /*!< I2C Enable Status Register,                                    Address offset: 0x09C */
  __IOM uint32_t FS_SPKLEN;                   /*!< I2C SS, FS or FM+ spike suppression limit,                     Address offset: 0x0A0 */
        uint32_t RESERVED4[2];                /*!< Reserved */
  __IOM uint32_t SCL_STUCK_AT_LOW_TIMEOUT;    /*!< I2C SCL Stuck at Low Timeout,                                  Address offset: 0x0AC */
  __IOM uint32_t SDA_STUCK_AT_LOW_TIMEOUT;    /*!< I2C SDA Stuck at Low Timeout,                                  Address offset: 0x0B0 */
  __IM  uint32_t CLR_SCL_STUCK_DET;           /*!< Clear SCL Stuck at Low Detect Interrupt Register,              Address offset: 0x0B4 */
        uint32_t RESERVED5;                   /*!< Reserved */
  __IOM uint32_t SMBUS_CLK_LOW_SEXT;          /*!< SMBus Slave Clock Extend Timeout Register,                     Address offset: 0x0BC */
  __IOM uint32_t SMBUS_CLK_LOW_MEXT;          /*!< SMBus Master Clock Extend Timeout Register,                    Address offset: 0x0C0 */
  __IOM uint32_t SMBUS_THIGH_MAX_IDLE_COUNT;  /*!< SMBus Master THigh MAX Bus-idle count Register,                Address offset: 0x0C4 */
  __IM  uint32_t SMBUS_INTR_STAT;             /*!< SMBUS Interrupt Status Register,                               Address offset: 0x0C8 */
  __IOM uint32_t SMBUS_INTR_MASK;             /*!< SMBus Interrupt Mask Register,                                 Address offset: 0x0CC */
  __IM  uint32_t SMBUS_RAW_INTR_STAT;         /*!< SMBus Raw Interrupt Status Register,                           Address offset: 0x0D0 */
  __OM  uint32_t CLR_SMBUS_INTR;              /*!< SMBus Clear Interrupt Register,                                Address offset: 0x0D4 */
  __IOM uint32_t OPTIONAL_SAR;                /*!< I2C Optional Slave Address Register,                           Address offset: 0x0D8 */
  __IOM uint32_t SMBUS_UDID_LSB;              /*!< SMBUS ARP UDID LSB Register,                                   Address offset: 0x0DC */
} I2C_TypeDef;


/* ================================================================================ */
/* ================           Independent watchdog (IWDG)          ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t KR;               /*!< Key register,                                                  Address offset: 0x000 */
  __IO uint32_t PR;               /*!< Prescaler register,                                            Address offset: 0x004 */
  __IO uint32_t RLR;              /*!< Reload register,                                               Address offset: 0x008 */
  __IO uint32_t SR;               /*!< Status register,                                               Address offset: 0x00C */
} IWDG_TypeDef;


/* ================================================================================ */
/* ================              Power Control (PWR)               ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CR;               /*!< Power control register,                                        Address offset: 0x000 */
  __IO uint32_t CSR;              /*!< Power control/status register,                                 Address offset: 0x004 */
} PWR_TypeDef;


/* ================================================================================ */
/* ================         Reset and Clock Control (RCC)          ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CR;               /*!< Clock control register,                                        Address offset: 0x000 */
  __IO uint32_t CFGR;             /*!< Clock configuration register,                                  Address offset: 0x004 */
  __IO uint32_t CIR;              /*!< Clock interrupt register,                                      Address offset: 0x008 */
  __IO uint32_t APB2RSTR;         /*!< APB2 peripheral reset register,                                Address offset: 0x00C */
  __IO uint32_t APB1RSTR;         /*!< APB1 peripheral reset register,                                Address offset: 0x010 */
  __IO uint32_t AHBENR;           /*!< AHB Peripheral Clock enable register,                          Address offset: 0x014 */
  __IO uint32_t APB2ENR;          /*!< APB2 peripheral clock enable register,                         Address offset: 0x018 */
  __IO uint32_t APB1ENR;          /*!< APB1 peripheral clock enable register,                         Address offset: 0x01C */
  __IO uint32_t BDCR;             /*!< Backup domain control register,                                Address offset: 0x020 */
  __IO uint32_t CSR;              /*!< Control/status register,                                       Address offset: 0x024 */
} RCC_TypeDef;


/* ================================================================================ */
/* ================              Real-Time Clock (RTC)             ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint16_t CRH;              /*!< RTC control register high,                                     Address offset: 0x000 */
       uint16_t RESERVED0;        /*!< Reserved */
  __IO uint16_t CRL;              /*!< RTC control register low,                                      Address offset: 0x004 */
       uint16_t RESERVED1;        /*!< Reserved */
  __IO uint16_t PRLH;             /*!< RTC prescaler load register high,                              Address offset: 0x008 */
       uint16_t RESERVED2;        /*!< Reserved */
  __IO uint16_t PRLL;             /*!< RTC prescaler load register low,                               Address offset: 0x00C */
       uint16_t RESERVED3;        /*!< Reserved */
  __IO uint16_t DIVH;             /*!< RTC prescaler divider register high,                           Address offset: 0x010 */
       uint16_t RESERVED4;        /*!< Reserved */
  __IO uint16_t DIVL;             /*!< RTC prescaler divider register low,                            Address offset: 0x014 */
       uint16_t RESERVED5;        /*!< Reserved */
  __IO uint16_t CNTH;             /*!< RTC counter register high,                                     Address offset: 0x018 */
       uint16_t RESERVED6;        /*!< Reserved */
  __IO uint16_t CNTL;             /*!< RTC counter register low,                                      Address offset: 0x01C */
       uint16_t RESERVED7;        /*!< Reserved */
  __IO uint16_t ALRH;             /*!< RTC alarm register high,                                       Address offset: 0x020 */
       uint16_t RESERVED8;        /*!< Reserved */
  __IO uint16_t ALRL;             /*!< RTC alarm register low,                                        Address offset: 0x024 */
       uint16_t RESERVED9;        /*!< Reserved */
} RTC_TypeDef;


/* ================================================================================ */
/* ================            SD host Interface (SDIO)            ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CTRL;             /*!< Control register,                                              Address offset: 0x00 */
  __IO uint32_t PWREN;            /*!< Power enable register,                                         Address offset: 0x04 */
  __IO uint32_t CLKDIV;           /*!< Clock divider register,                                        Address offset: 0x08 */
  __IO uint32_t RESERVED0;        /*!< Reserved */
  __IO uint32_t CLKENA;           /*!< Clock enable register,                                         Address offset: 0x10 */
  __IO uint32_t TMOUT;            /*!< Time out register,                                             Address offset: 0x14 */
  __IO uint32_t CTYPE;            /*!< Card type register,                                            Address offset: 0x18 */
  __IO uint32_t BLKSIZ;           /*!< Block sizeregister,                                            Address offset: 0x1C */
  __IO uint32_t BYTCNT;           /*!< Byte count register,                                           Address offset: 0x20 */
  __IO uint32_t INTMASK;          /*!< Interrupt mask register,                                       Address offset: 0x24 */
  __IO uint32_t CMDARG;           /*!< Command argument register,                                     Address offset: 0x28 */
  __IO uint32_t CMD;              /*!< Command register,                                              Address offset: 0x2C */
  __IO uint32_t RESP0;            /*!< Response 0 register,                                           Address offset: 0x30 */
  __IO uint32_t RESP1;            /*!< Response 1 register,                                           Address offset: 0x34 */
  __IO uint32_t RESP2;            /*!< Response 2 register,                                           Address offset: 0x38 */
  __IO uint32_t RESP3;            /*!< Response 3 register,                                           Address offset: 0x3C */
  __IO uint32_t MINTSTS;          /*!< Masked interrupt status register,                              Address offset: 0x40 */
  __IO uint32_t RINTSTS;          /*!< Raw interrupt status register,                                 Address offset: 0x44 */
  __IO uint32_t STATUS;           /*!< Status register,                                               Address offset: 0x48 */
  __IO uint32_t FIFOTH;           /*!< FIFO threshold register,                                       Address offset: 0x4C */
  __IO uint32_t CDETECT;          /*!< Card detect register,                                          Address offset: 0x50 */
  __IO uint32_t WRTPRT;           /*!< Write protect register,                                        Address offset: 0x54 */
  __IO uint32_t RESERVED1;        /*!< Reserved*/
  __IO uint32_t TCBCNT;           /*!< Transferred CIU card byte count register,                      Address offset: 0x5C */
  __IO uint32_t TBBCNT;           /*!< Transferred host/DMA to/from BIU-FIFO byte count register,     Address offset: 0x60 */
  __IO uint32_t RESERVED2[7];     /*!< Reserved */
  __IO uint32_t BMOD;             /*!< Bus mode register,                                             Address offset: 0x80 */
  __IO uint32_t PLDMND;           /*!< Poll memand register,                                          Address offset: 0x84 */
  __IO uint32_t DBADDR;           /*!< Descriptor list base address register,                         Address offset: 0x88 */
  __IO uint32_t IDSTS;            /*!< Internal DMAC status register,                                 Address offset: 0x8C */
  __IO uint32_t IDINTEN;          /*!< Internal DMAC interrupt enable register,                       Address offset: 0x90 */
  __IO uint32_t DSCADDR;          /*!< Current host descriptor address register,                      Address offset: 0x94 */
  __IO uint32_t BUFADDR;          /*!< Current host buffer register,                                  Address offset: 0x98 */
  __IO uint32_t RESERVED3[25];    /*!< Reserved */
  __IO uint32_t CARDTHRCTL;       /*!< Card read threshold enable register,                           Address offset: 0x100 */
  __IO uint32_t BACK_END_POWER;   /*!< Back end power register,                                       Address offset: 0x104 */
  __IO uint32_t UHS_REG_EXT;      /*!< Emmc 4.5 1.2V register,                                        Address offset: 0x108 */
  __IO uint32_t EMMC_DDR_REG;     /*!< Emmc DDR START bit dection register,                           Address offset: 0x10C */
  __IO uint32_t ENABLE_SHIFT;     /*!< Phase shift control register,                                  Address offset: 0x110 */
       uint32_t RESERVED4[59];    /*!< Reserved */
  __IO uint32_t FIFO;             /*!< SDIO data FIFO register,                                       Address offset: 0x200 */
} SDIO_TypeDef;


/* ================================================================================ */
/* ==============          Serial Peripheral Interface (SPI)          ============= */
/* ================================================================================ */
typedef struct
{
  __IO uint16_t CR1;              /*!< SPI control register 1,                                        Address offset: 0x000 */
       uint16_t RESERVED0;        /*!< Reserved */
  __IO uint16_t CR2;              /*!< SPI control register 2,                                        Address offset: 0x004 */
       uint16_t RESERVED1;        /*!< Reserved */
  __IO uint16_t SR;               /*!< SPI status register,                                           Address offset: 0x008 */
       uint16_t RESERVED2;        /*!< Reserved */
  __IO uint16_t DR;               /*!< SPI data register,                                             Address offset: 0x00C */
       uint16_t RESERVED3;        /*!< Reserved */
  __IO uint16_t CRCPR;            /*!< SPI CRC polynomial register,                                   Address offset: 0x010 */
       uint16_t RESERVED4;        /*!< Reserved */
  __IO uint16_t RXCRCR;           /*!< SPI RX CRC register,                                           Address offset: 0x014 */
       uint16_t RESERVED5;        /*!< Reserved */
  __IO uint16_t TXCRCR;           /*!< SPI TX CRC register,                                           Address offset: 0x018 */
       uint16_t RESERVED6;        /*!< Reserved */
  __IO uint16_t I2SCFGR;          /*!< SPI_I2S configuration register,                                Address offset: 0x01C */
       uint16_t RESERVED7;        /*!< Reserved */
  __IO uint16_t I2SPR;            /*!< SPI_I2S prescaler register ,                                   Address offset: 0x020 */
       uint16_t RESERVED8;        /*!< Reserved */
} SPI_TypeDef;


/* ================================================================================ */
/* ==============              Quad-SPI Interface (QSPI)              ============= */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CR;               /*!< QUADSPI control register,                                      Address offset: 0x000 */
  __IO uint32_t DCR;              /*!< QUADSPI device configuration register,                         Address offset: 0x004 */
  __IO uint32_t SR;               /*!< QUADSPI status register,                                       Address offset: 0x008 */
  __IO uint32_t FCR;              /*!< QUADSPI flag clear register,                                   Address offset: 0x00C */
  __IO uint32_t DLR;              /*!< QUADSPI data length register,                                  Address offset: 0x010 */
  __IO uint32_t CCR;              /*!< QUADSPI communication configuration register,                  Address offset: 0x014 */
  __IO uint32_t AR;               /*!< QUADSPI address register,                                      Address offset: 0x018 */
  __IO uint32_t ABR;              /*!< QUADSPI alternate bytes registers,                             Address offset: 0x01C */
  __IO uint32_t DR;               /*!< QUADSPI data register,                                         Address offset: 0x020 */
  __IO uint32_t PSMKR;            /*!< QUADSPI polling status mask register,                          Address offset: 0x024 */
  __IO uint32_t PSMAR;            /*!< QUADSPI polling status match register,                         Address offset: 0x028 */
  __IO uint32_t PIR;              /*!< QUADSPI polling interval register,                             Address offset: 0x02C */
  __IO uint32_t LPTR;             /*!< QUADSPI low-power timeout register,                            Address offset: 0x030 */
} QUADSPI_TypeDef;


/* ================================================================================ */
/* ================                   Timer (TIM)                  ================ */
/* ================================================================================ */
typedef struct
{
  __IOM uint32_t CR1;             /*!< Control register 1,                                            Address offset: 0x000 */
  __IOM uint32_t CR2;             /*!< Control register 2,                                            Address offset: 0x004 */
  __IOM uint32_t SMCR;            /*!< Slave mode control register,                                   Address offset: 0x008 */
  __IOM uint32_t DIER;            /*!< DMA/interrupt enable register,                                 Address offset: 0x00C */
  __IOM uint32_t SR;              /*!< Status register,                                               Address offset: 0x010 */
  __OM  uint32_t EGR;             /*!< Event generation register,                                     Address offset: 0x014 */
  __IOM uint32_t CCMR1;           /*!< Capture/compare mode register 1,                               Address offset: 0x018 */
  __IOM uint32_t CCMR2;           /*!< Capture/compare mode register 2,                               Address offset: 0x01C */
  __IOM uint32_t CCER;            /*!< Capture/compare enable register,                               Address offset: 0x020 */
  __IOM uint32_t CNT;             /*!< Counter,                                                       Address offset: 0x024 */
  __IOM uint32_t PSC;             /*!< Prescaler,                                                     Address offset: 0x028 */
  __IOM uint32_t ARR;             /*!< Auto-reload register,                                          Address offset: 0x02C */
  __IOM uint32_t RCR;             /*!< Repetition counter register,                                   Address offset: 0x030 */
  __IOM uint32_t CCR1;            /*!< Capture/compare register 1,                                    Address offset: 0x034 */
  __IOM uint32_t CCR2;            /*!< Capture/compare register 2,                                    Address offset: 0x038 */
  __IOM uint32_t CCR3;            /*!< Capture/compare register 3,                                    Address offset: 0x03C */
  __IOM uint32_t CCR4;            /*!< Capture/compare register 4,                                    Address offset: 0x040 */
  __IOM uint32_t BDTR;            /*!< Break and dead-time register,                                  Address offset: 0x044 */
  __IOM uint32_t DCR;             /*!< DMA control register,                                          Address offset: 0x048 */
  __IOM uint32_t DMAR;            /*!< DMA address for full transfer,                                 Address offset: 0x04C */
} TIM_TypeDef;


/* ================================================================================ */
/* ======= Universal Synchronous Asyncronous Receiver / Transmitter (USART) ======= */
/* ================================================================================ */
typedef struct
{
  __IO uint16_t SR;               /*!< Status register,                                               Address offset: 0x000 */
       uint16_t RESERVED0;        /*!< Reserved */
  __IO uint16_t DR;               /*!< Data register,                                                 Address offset: 0x004 */
       uint16_t RESERVED1;        /*!< Reserved */
  __IO uint16_t BRR;              /*!< Baud rate register,                                            Address offset: 0x008 */
       uint16_t RESERVED2;        /*!< Reserved */
  __IO uint16_t CR1;              /*!< Control register 1,                                            Address offset: 0x00C */
       uint16_t RESERVED3;        /*!< Reserved */
  __IO uint16_t CR2;              /*!< Control register 2,                                            Address offset: 0x010 */
       uint16_t RESERVED4;        /*!< Reserved */
  __IO uint16_t CR3;              /*!< Control register 4,                                            Address offset: 0x014 */
       uint16_t RESERVED5;        /*!< Reserved */
  __IO uint16_t GTPR;             /*!< Guard time and prescaler register,                             Address offset: 0x018 */
       uint16_t RESERVED6;        /*!< Reserved */
} USART_TypeDef;


/* ================================================================================ */
/* ================             Window watchdog (WWDG)             ================ */
/* ================================================================================ */
typedef struct
{
  __IO uint32_t CR;               /*!< Control register,                                              Address offset: 0x000 */
  __IO uint32_t CFR;              /*!< Configuration register,                                        Address offset: 0x004 */
  __IO uint32_t SR;               /*!< Status register,                                               Address offset: 0x008 */
} WWDG_TypeDef;

/**
  * @}
  */


/* --------  End of section using anonymous unions and disabling warnings  -------- */
#if   defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif



/** @addtogroup Peripheral_memory_map
  * @{
  */


#define FLASH_BASE            ((uint32_t)0x08000000)        /*!< FLASH base address in the alias region */
#define SRAM_BASE             ((uint32_t)0x20000000)        /*!< SRAM base address in the alias region */
#define PERIPH_BASE           ((uint32_t)0x40000000)        /*!< Peripheral base address in the alias region */

#define SRAM_BB_BASE          ((uint32_t)0x22000000)        /*!< SRAM base address in the bit-band region */
#define PERIPH_BB_BASE        ((uint32_t)0x42000000)        /*!< Peripheral base address in the bit-band region */

/*!< Peripheral memory map */
#define APB1PERIPH_BASE       PERIPH_BASE                   // 4000_0000
#define APB2PERIPH_BASE       (PERIPH_BASE + 0x10000)       // 4001_0000
#define AHBPERIPH_BASE        (PERIPH_BASE + 0x20000)       // 4002_0000

#define TIM2_BASE             (APB1PERIPH_BASE + 0x0000)    // 4000_0000
#define TIM3_BASE             (APB1PERIPH_BASE + 0x0400)    // 4000_0400
#define TIM4_BASE             (APB1PERIPH_BASE + 0x0800)    // 4000_0800
#define TIM5_BASE             (APB1PERIPH_BASE + 0x0C00)    // 4000_0C00
#define TIM6_BASE             (APB1PERIPH_BASE + 0x1000)    // 4000_1000
#define TIM7_BASE             (APB1PERIPH_BASE + 0x1400)    // 4000_1400
#define RTC_BASE              (APB1PERIPH_BASE + 0x2800)    // 4000_2800
#define WWDG_BASE             (APB1PERIPH_BASE + 0x2C00)    // 4000_2C00
#define IWDG_BASE             (APB1PERIPH_BASE + 0x3000)    // 4000_3000
#define SPI2_BASE             (APB1PERIPH_BASE + 0x3800)    // 4000_3800
#define SPI3_BASE             (APB1PERIPH_BASE + 0x3C00)    // 4000_3C00
#define USART2_BASE           (APB1PERIPH_BASE + 0x4400)    // 4000_4400
#define USART3_BASE           (APB1PERIPH_BASE + 0x4800)    // 4000_4800
#define UART4_BASE            (APB1PERIPH_BASE + 0x4C00)    // 4000_4C00
#define UART5_BASE            (APB1PERIPH_BASE + 0x5000)    // 4000_5000
#define I2C1_BASE             (APB1PERIPH_BASE + 0x5400)    // 4000_5400
#define I2C2_BASE             (APB1PERIPH_BASE + 0x5800)    // 4000_5800
#define CAN1_BASE             (APB1PERIPH_BASE + 0x6400)    // 4000_6400
#define BKP_BASE              (APB1PERIPH_BASE + 0x6C00)    // 4000_6C00
#define PWR_BASE              (APB1PERIPH_BASE + 0x7000)    // 4000_7000
#define DAC_BASE              (APB1PERIPH_BASE + 0x7400)    // 4000_7400

#define AFIO_BASE             (APB2PERIPH_BASE + 0x0000)    // 4001_0000
#define OPA1_BASE             (APB2PERIPH_BASE + 0x0200)    // 4001_0200
#define OPA2_BASE             (APB2PERIPH_BASE + 0x0280)    // 4001_0280
#define OPA3_BASE             (APB2PERIPH_BASE + 0x0300)    // 4001_0300
#define EXTI_BASE             (APB2PERIPH_BASE + 0x0400)    // 4001_0400
#define GPIOA_BASE            (APB2PERIPH_BASE + 0x0800)    // 4001_0800
#define GPIOB_BASE            (APB2PERIPH_BASE + 0x0C00)    // 4001_0C00
#define GPIOC_BASE            (APB2PERIPH_BASE + 0x1000)    // 4001_1000
#define GPIOD_BASE            (APB2PERIPH_BASE + 0x1400)    // 4001_1400
#define GPIOE_BASE            (APB2PERIPH_BASE + 0x1800)    // 4001_1800
#define ADC1_BASE             (APB2PERIPH_BASE + 0x2400)    // 4001_2400
#define ADC2_BASE             (APB2PERIPH_BASE + 0x2800)    // 4001_2800
#define TIM1_BASE             (APB2PERIPH_BASE + 0x2C00)    // 4001_2C00
#define SPI1_BASE             (APB2PERIPH_BASE + 0x3000)    // 4001_3000
#define TIM8_BASE             (APB2PERIPH_BASE + 0x3400)    // 4001_3400
#define USART1_BASE           (APB2PERIPH_BASE + 0x3800)    // 4001_3800
#define ADC3_BASE             (APB2PERIPH_BASE + 0x3C00)    // 4001_3C00
#define QUADSPI_BASE          (APB2PERIPH_BASE + 0x4000)    // 4001_4000

#define USB_BASE              (PERIPH_BASE + 0x5C00)        // 4000_5C00
#define SDIO_BASE             (PERIPH_BASE + 0x18000)       // 4001_8000

#define DMAC1_BASE            (AHBPERIPH_BASE + 0x0000)     // 4002_0000
#define DMAC2_BASE            (AHBPERIPH_BASE + 0x0400)     // 4002_0400
#define RCC_BASE              (AHBPERIPH_BASE + 0x1000)     // 4002_1000
#define CRC_BASE              (AHBPERIPH_BASE + 0x3000)     // 4002_3000
#define TRNG_BASE             (AHBPERIPH_BASE + 0x5000)     // 4002_5000
#define AES_BASE              (AHBPERIPH_BASE + 0x6000)     // 4002_6000

#define FLASH_R_BASE          (AHBPERIPH_BASE + 0x2000)     /*!< Flash registers base address */
#define OB_BASE               ((uint32_t)0x1FFFF800)        /*!< Flash Option Bytes base address */

#define DBGMCU_BASE           ((uint32_t)0xE0042000)        /*!< Debug MCU registers base address */

/**
  * @}
  */
  
/** @addtogroup Peripheral_declaration
  * @{
  */  

#define TIM2                  ((        TIM_TypeDef *)         TIM2_BASE)
#define TIM3                  ((        TIM_TypeDef *)         TIM3_BASE)
#define TIM4                  ((        TIM_TypeDef *)         TIM4_BASE)
#define TIM5                  ((        TIM_TypeDef *)         TIM5_BASE)
#define TIM6                  ((        TIM_TypeDef *)         TIM6_BASE)
#define TIM7                  ((        TIM_TypeDef *)         TIM7_BASE)
#define RTC                   ((        RTC_TypeDef *)          RTC_BASE)
#define WWDG                  ((       WWDG_TypeDef *)         WWDG_BASE)
#define IWDG                  ((       IWDG_TypeDef *)         IWDG_BASE)
#define SPI2                  ((        SPI_TypeDef *)         SPI2_BASE)
#define SPI3                  ((        SPI_TypeDef *)         SPI3_BASE)
#define USART2                ((      USART_TypeDef *)       USART2_BASE)
#define USART3                ((      USART_TypeDef *)       USART3_BASE)
#define UART4                 ((      USART_TypeDef *)        UART4_BASE)
#define UART5                 ((      USART_TypeDef *)        UART5_BASE)
#define I2C1                  ((        I2C_TypeDef *)         I2C1_BASE)
#define I2C2                  ((        I2C_TypeDef *)         I2C2_BASE)
#define CAN1                  ((        CAN_TypeDef *)         CAN1_BASE)
#define BKP                   ((        BKP_TypeDef *)          BKP_BASE)
#define PWR                   ((        PWR_TypeDef *)          PWR_BASE)
#define DAC                   ((        DAC_TypeDef *)          DAC_BASE)
#define AFIO                  ((       AFIO_TypeDef *)         AFIO_BASE)
#define OPA1                  ((        OPA_TypeDef *)         OPA1_BASE)
#define OPA2                  ((        OPA_TypeDef *)         OPA2_BASE)
#define OPA3                  ((        OPA_TypeDef *)         OPA3_BASE)
#define EXTI                  ((       EXTI_TypeDef *)         EXTI_BASE)
#define GPIOA                 ((       GPIO_TypeDef *)        GPIOA_BASE)
#define GPIOB                 ((       GPIO_TypeDef *)        GPIOB_BASE)
#define GPIOC                 ((       GPIO_TypeDef *)        GPIOC_BASE)
#define GPIOD                 ((       GPIO_TypeDef *)        GPIOD_BASE)
#define GPIOE                 ((       GPIO_TypeDef *)        GPIOE_BASE)
#define ADC1                  ((        ADC_TypeDef *)         ADC1_BASE)
#define ADC2                  ((        ADC_TypeDef *)         ADC2_BASE)
#define TIM1                  ((        TIM_TypeDef *)         TIM1_BASE)
#define SPI1                  ((        SPI_TypeDef *)         SPI1_BASE)
#define TIM8                  ((        TIM_TypeDef *)         TIM8_BASE)
#define USART1                ((      USART_TypeDef *)       USART1_BASE)
#define ADC3                  ((        ADC_TypeDef *)         ADC3_BASE)
#define QUADSPI               ((    QUADSPI_TypeDef *)      QUADSPI_BASE)
#define SDIO                  ((       SDIO_TypeDef *)         SDIO_BASE)
#define USB                   ((        USB_TypeDef *)          USB_BASE)
#define DMAC1                 ((       DMAC_TypeDef *)        DMAC1_BASE)
#define DMAC2                 ((       DMAC_TypeDef *)        DMAC2_BASE)
#define RCC                   ((        RCC_TypeDef *)          RCC_BASE)
#define CRC                   ((        CRC_TypeDef *)          CRC_BASE)
#define RNG                   ((       TRNG_TypeDef *)         TRNG_BASE)
#define AES                   ((        AES_TypeDef *)          AES_BASE)
#define FLASH                 ((      FLASH_TypeDef *)      FLASH_R_BASE)
#define OB                    ((         OB_TypeDef *)           OB_BASE)
#define DBGMCU                ((     DBGMCU_TypeDef *)       DBGMCU_BASE)

/**
  * @}
  */

/** @addtogroup Exported_constants
  * @{
  */
  
  /** @addtogroup Peripheral_Registers_Bits_Definition
  * @{
  */
    
/******************************************************************************/
/*                         Peripheral Registers_Bits_Definition               */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*                       CRC calculation unit (CRC)                           */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos                       (0U)
#define CRC_DR_DR_Msk                       (0xFFFFFFFFUL << CRC_DR_DR_Pos)     /*!< 0xFFFFFFFF */
#define CRC_DR_DR                           CRC_DR_DR_Msk                       /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos                     (0U)
#define CRC_IDR_IDR_Msk                     (0xFFUL << CRC_IDR_IDR_Pos)         /*!< 0x000000FF */
#define CRC_IDR_IDR                         CRC_IDR_IDR_Msk                     /*!< General-purpose 8-bit data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos                    (0U)
#define CRC_CR_RESET_Msk                    (0x1UL << CRC_CR_RESET_Pos)         /*!< 0x00000001 */
#define CRC_CR_RESET                        CRC_CR_RESET_Msk                    /*!< RESET bit */

/******************************************************************************/
/*                                                                            */
/*                           Power Control (PWR)                              */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for PWR_CR register  ********************/
#define PWR_CR_LPDS_Pos                     (0U)                               
#define PWR_CR_LPDS_Msk                     (0x1UL << PWR_CR_LPDS_Pos)          /*!< 0x00000001 */
#define PWR_CR_LPDS                         PWR_CR_LPDS_Msk                     /*!< Low-Power Deepsleep */
#define PWR_CR_PDDS_Pos                     (1U)                               
#define PWR_CR_PDDS_Msk                     (0x1UL << PWR_CR_PDDS_Pos)          /*!< 0x00000002 */
#define PWR_CR_PDDS                         PWR_CR_PDDS_Msk                     /*!< Power Down Deepsleep */
#define PWR_CR_CWUF_Pos                     (2U)                               
#define PWR_CR_CWUF_Msk                     (0x1UL << PWR_CR_CWUF_Pos)          /*!< 0x00000004 */
#define PWR_CR_CWUF                         PWR_CR_CWUF_Msk                     /*!< Clear Wakeup Flag */
#define PWR_CR_CSBF_Pos                     (3U)                               
#define PWR_CR_CSBF_Msk                     (0x1UL << PWR_CR_CSBF_Pos)          /*!< 0x00000008 */
#define PWR_CR_CSBF                         PWR_CR_CSBF_Msk                     /*!< Clear Standby Flag */
#define PWR_CR_PVDE_Pos                     (4U)                               
#define PWR_CR_PVDE_Msk                     (0x1UL << PWR_CR_PVDE_Pos)          /*!< 0x00000010 */
#define PWR_CR_PVDE                         PWR_CR_PVDE_Msk                     /*!< Power Voltage Detector Enable */

#define PWR_CR_PLS_Pos                      (5U)                               
#define PWR_CR_PLS_Msk                      (0x7UL << PWR_CR_PLS_Pos)           /*!< 0x000000E0 */
#define PWR_CR_PLS                          PWR_CR_PLS_Msk                      /*!< PLS[2:0] bits (PVD Level Selection) */
#define PWR_CR_PLS_0                        (0x1UL << PWR_CR_PLS_Pos)           /*!< 0x00000020 */
#define PWR_CR_PLS_1                        (0x2UL << PWR_CR_PLS_Pos)           /*!< 0x00000040 */
#define PWR_CR_PLS_2                        (0x4UL << PWR_CR_PLS_Pos)           /*!< 0x00000080 */

/*!< PVD level configuration */
#define PWR_CR_PLS_LEV0                      0x00000000U                        /*!< PVD level 2.2V */
#define PWR_CR_PLS_LEV1                      0x00000020U                        /*!< PVD level 2.3V */
#define PWR_CR_PLS_LEV2                      0x00000040U                        /*!< PVD level 2.4V */
#define PWR_CR_PLS_LEV3                      0x00000060U                        /*!< PVD level 2.5V */
#define PWR_CR_PLS_LEV4                      0x00000080U                        /*!< PVD level 2.6V */
#define PWR_CR_PLS_LEV5                      0x000000A0U                        /*!< PVD level 2.7V */
#define PWR_CR_PLS_LEV6                      0x000000C0U                        /*!< PVD level 2.8V */
#define PWR_CR_PLS_LEV7                      0x000000E0U                        /*!< PVD level 2.9V */

/* Legacy defines */
#define PWR_CR_PLS_2V2                       PWR_CR_PLS_LEV0                    /*!< PVD level 2.2V */
#define PWR_CR_PLS_2V3                       PWR_CR_PLS_LEV1                    /*!< PVD level 2.3V */
#define PWR_CR_PLS_2V4                       PWR_CR_PLS_LEV2                    /*!< PVD level 2.4V */
#define PWR_CR_PLS_2V5                       PWR_CR_PLS_LEV3                    /*!< PVD level 2.5V */
#define PWR_CR_PLS_2V6                       PWR_CR_PLS_LEV4                    /*!< PVD level 2.6V */
#define PWR_CR_PLS_2V7                       PWR_CR_PLS_LEV5                    /*!< PVD level 2.7V */
#define PWR_CR_PLS_2V8                       PWR_CR_PLS_LEV6                    /*!< PVD level 2.8V */
#define PWR_CR_PLS_2V9                       PWR_CR_PLS_LEV7                    /*!< PVD level 2.9V */

#define PWR_CR_DBP_Pos                      (8U)                               
#define PWR_CR_DBP_Msk                      (0x1UL << PWR_CR_DBP_Pos)           /*!< 0x00000100 */
#define PWR_CR_DBP                          PWR_CR_DBP_Msk                      /*!< Disable Backup Domain write protection */

/*******************  Bit definition for PWR_CSR register  ********************/
#define PWR_CSR_WUF_Pos                     (0U)                               
#define PWR_CSR_WUF_Msk                     (0x1UL << PWR_CSR_WUF_Pos)          /*!< 0x00000001 */
#define PWR_CSR_WUF                         PWR_CSR_WUF_Msk                     /*!< Wakeup Flag */
#define PWR_CSR_SBF_Pos                     (1U)                               
#define PWR_CSR_SBF_Msk                     (0x1UL << PWR_CSR_SBF_Pos)          /*!< 0x00000002 */
#define PWR_CSR_SBF                         PWR_CSR_SBF_Msk                     /*!< Standby Flag */
#define PWR_CSR_PVDO_Pos                    (2U)                               
#define PWR_CSR_PVDO_Msk                    (0x1UL << PWR_CSR_PVDO_Pos)         /*!< 0x00000004 */
#define PWR_CSR_PVDO                        PWR_CSR_PVDO_Msk                    /*!< PVD Output */
#define PWR_CSR_EWUP_Pos                    (8U)                               
#define PWR_CSR_EWUP_Msk                    (0x1UL << PWR_CSR_EWUP_Pos)         /*!< 0x00000100 */
#define PWR_CSR_EWUP                        PWR_CSR_EWUP_Msk                    /*!< Enable WKUP pin */

/******************************************************************************/
/*                                                                            */
/*                          Backup registers (BKP)                            */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for BKP_DR1 register  ********************/
#define BKP_DR1_D_Pos                       (0U)                               
#define BKP_DR1_D_Msk                       (0xFFFFUL << BKP_DR1_D_Pos)         /*!< 0x0000FFFF */
#define BKP_DR1_D                           BKP_DR1_D_Msk                       /*!< Backup data */

/*******************  Bit definition for BKP_DR2 register  ********************/
#define BKP_DR2_D_Pos                       (0U)                               
#define BKP_DR2_D_Msk                       (0xFFFFUL << BKP_DR2_D_Pos)         /*!< 0x0000FFFF */
#define BKP_DR2_D                           BKP_DR2_D_Msk                       /*!< Backup data */

/*******************  Bit definition for BKP_DR3 register  ********************/
#define BKP_DR3_D_Pos                       (0U)                               
#define BKP_DR3_D_Msk                       (0xFFFFUL << BKP_DR3_D_Pos)         /*!< 0x0000FFFF */
#define BKP_DR3_D                           BKP_DR3_D_Msk                       /*!< Backup data */

/*******************  Bit definition for BKP_DR4 register  ********************/
#define BKP_DR4_D_Pos                       (0U)                               
#define BKP_DR4_D_Msk                       (0xFFFFUL << BKP_DR4_D_Pos)         /*!< 0x0000FFFF */
#define BKP_DR4_D                           BKP_DR4_D_Msk                       /*!< Backup data */

/*******************  Bit definition for BKP_DR5 register  ********************/
#define BKP_DR5_D_Pos                       (0U)                               
#define BKP_DR5_D_Msk                       (0xFFFFUL << BKP_DR5_D_Pos)         /*!< 0x0000FFFF */
#define BKP_DR5_D                           BKP_DR5_D_Msk                       /*!< Backup data */

/*******************  Bit definition for BKP_DR6 register  ********************/
#define BKP_DR6_D_Pos                       (0U)                               
#define BKP_DR6_D_Msk                       (0xFFFFUL << BKP_DR6_D_Pos)         /*!< 0x0000FFFF */
#define BKP_DR6_D                           BKP_DR6_D_Msk                       /*!< Backup data */

/*******************  Bit definition for BKP_DR7 register  ********************/
#define BKP_DR7_D_Pos                       (0U)                               
#define BKP_DR7_D_Msk                       (0xFFFFUL << BKP_DR7_D_Pos)         /*!< 0x0000FFFF */
#define BKP_DR7_D                           BKP_DR7_D_Msk                       /*!< Backup data */

/*******************  Bit definition for BKP_DR8 register  ********************/
#define BKP_DR8_D_Pos                       (0U)                               
#define BKP_DR8_D_Msk                       (0xFFFFUL << BKP_DR8_D_Pos)         /*!< 0x0000FFFF */
#define BKP_DR8_D                           BKP_DR8_D_Msk                       /*!< Backup data */

/*******************  Bit definition for BKP_DR9 register  ********************/
#define BKP_DR9_D_Pos                       (0U)                               
#define BKP_DR9_D_Msk                       (0xFFFFUL << BKP_DR9_D_Pos)         /*!< 0x0000FFFF */
#define BKP_DR9_D                           BKP_DR9_D_Msk                       /*!< Backup data */

/*******************  Bit definition for BKP_DR10 register  *******************/
#define BKP_DR10_D_Pos                      (0U)                               
#define BKP_DR10_D_Msk                      (0xFFFFUL << BKP_DR10_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR10_D                          BKP_DR10_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR11 register  *******************/
#define BKP_DR11_D_Pos                      (0U)                               
#define BKP_DR11_D_Msk                      (0xFFFFUL << BKP_DR11_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR11_D                          BKP_DR11_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR12 register  *******************/
#define BKP_DR12_D_Pos                      (0U)                               
#define BKP_DR12_D_Msk                      (0xFFFFUL << BKP_DR12_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR12_D                          BKP_DR12_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR13 register  *******************/
#define BKP_DR13_D_Pos                      (0U)                               
#define BKP_DR13_D_Msk                      (0xFFFFUL << BKP_DR13_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR13_D                          BKP_DR13_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR14 register  *******************/
#define BKP_DR14_D_Pos                      (0U)                               
#define BKP_DR14_D_Msk                      (0xFFFFUL << BKP_DR14_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR14_D                          BKP_DR14_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR15 register  *******************/
#define BKP_DR15_D_Pos                      (0U)                               
#define BKP_DR15_D_Msk                      (0xFFFFUL << BKP_DR15_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR15_D                          BKP_DR15_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR16 register  *******************/
#define BKP_DR16_D_Pos                      (0U)                               
#define BKP_DR16_D_Msk                      (0xFFFFUL << BKP_DR16_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR16_D                          BKP_DR16_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR17 register  *******************/
#define BKP_DR17_D_Pos                      (0U)                               
#define BKP_DR17_D_Msk                      (0xFFFFUL << BKP_DR17_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR17_D                          BKP_DR17_D_Msk                      /*!< Backup data */

/******************  Bit definition for BKP_DR18 register  ********************/
#define BKP_DR18_D_Pos                      (0U)                               
#define BKP_DR18_D_Msk                      (0xFFFFUL << BKP_DR18_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR18_D                          BKP_DR18_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR19 register  *******************/
#define BKP_DR19_D_Pos                      (0U)                               
#define BKP_DR19_D_Msk                      (0xFFFFUL << BKP_DR19_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR19_D                          BKP_DR19_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR20 register  *******************/
#define BKP_DR20_D_Pos                      (0U)                               
#define BKP_DR20_D_Msk                      (0xFFFFUL << BKP_DR20_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR20_D                          BKP_DR20_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR21 register  *******************/
#define BKP_DR21_D_Pos                      (0U)                               
#define BKP_DR21_D_Msk                      (0xFFFFUL << BKP_DR21_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR21_D                          BKP_DR21_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR22 register  *******************/
#define BKP_DR22_D_Pos                      (0U)                               
#define BKP_DR22_D_Msk                      (0xFFFFUL << BKP_DR22_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR22_D                          BKP_DR22_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR23 register  *******************/
#define BKP_DR23_D_Pos                      (0U)                               
#define BKP_DR23_D_Msk                      (0xFFFFUL << BKP_DR23_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR23_D                          BKP_DR23_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR24 register  *******************/
#define BKP_DR24_D_Pos                      (0U)                               
#define BKP_DR24_D_Msk                      (0xFFFFUL << BKP_DR24_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR24_D                          BKP_DR24_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR25 register  *******************/
#define BKP_DR25_D_Pos                      (0U)                               
#define BKP_DR25_D_Msk                      (0xFFFFUL << BKP_DR25_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR25_D                          BKP_DR25_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR26 register  *******************/
#define BKP_DR26_D_Pos                      (0U)                               
#define BKP_DR26_D_Msk                      (0xFFFFUL << BKP_DR26_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR26_D                          BKP_DR26_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR27 register  *******************/
#define BKP_DR27_D_Pos                      (0U)                               
#define BKP_DR27_D_Msk                      (0xFFFFUL << BKP_DR27_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR27_D                          BKP_DR27_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR28 register  *******************/
#define BKP_DR28_D_Pos                      (0U)                               
#define BKP_DR28_D_Msk                      (0xFFFFUL << BKP_DR28_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR28_D                          BKP_DR28_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR29 register  *******************/
#define BKP_DR29_D_Pos                      (0U)                               
#define BKP_DR29_D_Msk                      (0xFFFFUL << BKP_DR29_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR29_D                          BKP_DR29_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR30 register  *******************/
#define BKP_DR30_D_Pos                      (0U)                               
#define BKP_DR30_D_Msk                      (0xFFFFUL << BKP_DR30_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR30_D                          BKP_DR30_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR31 register  *******************/
#define BKP_DR31_D_Pos                      (0U)                               
#define BKP_DR31_D_Msk                      (0xFFFFUL << BKP_DR31_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR31_D                          BKP_DR31_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR32 register  *******************/
#define BKP_DR32_D_Pos                      (0U)                               
#define BKP_DR32_D_Msk                      (0xFFFFUL << BKP_DR32_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR32_D                          BKP_DR32_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR33 register  *******************/
#define BKP_DR33_D_Pos                      (0U)                               
#define BKP_DR33_D_Msk                      (0xFFFFUL << BKP_DR33_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR33_D                          BKP_DR33_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR34 register  *******************/
#define BKP_DR34_D_Pos                      (0U)                               
#define BKP_DR34_D_Msk                      (0xFFFFUL << BKP_DR34_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR34_D                          BKP_DR34_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR35 register  *******************/
#define BKP_DR35_D_Pos                      (0U)                               
#define BKP_DR35_D_Msk                      (0xFFFFUL << BKP_DR35_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR35_D                          BKP_DR35_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR36 register  *******************/
#define BKP_DR36_D_Pos                      (0U)                               
#define BKP_DR36_D_Msk                      (0xFFFFUL << BKP_DR36_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR36_D                          BKP_DR36_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR37 register  *******************/
#define BKP_DR37_D_Pos                      (0U)                               
#define BKP_DR37_D_Msk                      (0xFFFFUL << BKP_DR37_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR37_D                          BKP_DR37_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR38 register  *******************/
#define BKP_DR38_D_Pos                      (0U)                               
#define BKP_DR38_D_Msk                      (0xFFFFUL << BKP_DR38_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR38_D                          BKP_DR38_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR39 register  *******************/
#define BKP_DR39_D_Pos                      (0U)                               
#define BKP_DR39_D_Msk                      (0xFFFFUL << BKP_DR39_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR39_D                          BKP_DR39_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR40 register  *******************/
#define BKP_DR40_D_Pos                      (0U)                               
#define BKP_DR40_D_Msk                      (0xFFFFUL << BKP_DR40_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR40_D                          BKP_DR40_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR41 register  *******************/
#define BKP_DR41_D_Pos                      (0U)                               
#define BKP_DR41_D_Msk                      (0xFFFFUL << BKP_DR41_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR41_D                          BKP_DR41_D_Msk                      /*!< Backup data */

/*******************  Bit definition for BKP_DR42 register  *******************/
#define BKP_DR42_D_Pos                      (0U)                               
#define BKP_DR42_D_Msk                      (0xFFFFUL << BKP_DR42_D_Pos)        /*!< 0x0000FFFF */
#define BKP_DR42_D                          BKP_DR42_D_Msk                      /*!< Backup data */

#define RTC_BKP_NUMBER 42

/******************  Bit definition for BKP_RTCCR register  *******************/
#define BKP_RTCCR_CAL_Pos                   (0U)                               
#define BKP_RTCCR_CAL_Msk                   (0x7FUL << BKP_RTCCR_CAL_Pos)       /*!< 0x0000007F */
#define BKP_RTCCR_CAL                       BKP_RTCCR_CAL_Msk                   /*!< Calibration value */
#define BKP_RTCCR_CCO_Pos                   (7U)                               
#define BKP_RTCCR_CCO_Msk                   (0x1UL << BKP_RTCCR_CCO_Pos)        /*!< 0x00000080 */
#define BKP_RTCCR_CCO                       BKP_RTCCR_CCO_Msk                   /*!< Calibration Clock Output */
#define BKP_RTCCR_ASOE_Pos                  (8U)                               
#define BKP_RTCCR_ASOE_Msk                  (0x1UL << BKP_RTCCR_ASOE_Pos)       /*!< 0x00000100 */
#define BKP_RTCCR_ASOE                      BKP_RTCCR_ASOE_Msk                  /*!< Alarm or Second Output Enable */
#define BKP_RTCCR_ASOS_Pos                  (9U)                               
#define BKP_RTCCR_ASOS_Msk                  (0x1UL << BKP_RTCCR_ASOS_Pos)       /*!< 0x00000200 */
#define BKP_RTCCR_ASOS                      BKP_RTCCR_ASOS_Msk                  /*!< Alarm or Second Output Selection */

/********************  Bit definition for BKP_CR register  ********************/
#define BKP_CR_TPE_Pos                      (0U)                               
#define BKP_CR_TPE_Msk                      (0x1UL << BKP_CR_TPE_Pos)           /*!< 0x00000001 */
#define BKP_CR_TPE                          BKP_CR_TPE_Msk                      /*!< TAMPER pin enable */
#define BKP_CR_TPAL_Pos                     (1U)                               
#define BKP_CR_TPAL_Msk                     (0x1UL << BKP_CR_TPAL_Pos)          /*!< 0x00000002 */
#define BKP_CR_TPAL                         BKP_CR_TPAL_Msk                     /*!< TAMPER pin active level */

/*******************  Bit definition for BKP_CSR register  ********************/
#define BKP_CSR_CTE_Pos                     (0U)                               
#define BKP_CSR_CTE_Msk                     (0x1UL << BKP_CSR_CTE_Pos)          /*!< 0x00000001 */
#define BKP_CSR_CTE                         BKP_CSR_CTE_Msk                     /*!< Clear Tamper event */
#define BKP_CSR_CTI_Pos                     (1U)                               
#define BKP_CSR_CTI_Msk                     (0x1UL << BKP_CSR_CTI_Pos)          /*!< 0x00000002 */
#define BKP_CSR_CTI                         BKP_CSR_CTI_Msk                     /*!< Clear Tamper Interrupt */
#define BKP_CSR_TPIE_Pos                    (2U)                               
#define BKP_CSR_TPIE_Msk                    (0x1UL << BKP_CSR_TPIE_Pos)         /*!< 0x00000004 */
#define BKP_CSR_TPIE                        BKP_CSR_TPIE_Msk                    /*!< TAMPER Pin interrupt enable */
#define BKP_CSR_TEF_Pos                     (8U)                               
#define BKP_CSR_TEF_Msk                     (0x1UL << BKP_CSR_TEF_Pos)          /*!< 0x00000100 */
#define BKP_CSR_TEF                         BKP_CSR_TEF_Msk                     /*!< Tamper Event Flag */
#define BKP_CSR_TIF_Pos                     (9U)                               
#define BKP_CSR_TIF_Msk                     (0x1UL << BKP_CSR_TIF_Pos)          /*!< 0x00000200 */
#define BKP_CSR_TIF                         BKP_CSR_TIF_Msk                     /*!< Tamper Interrupt Flag */

/******************************************************************************/
/*                                                                            */
/*                       Reset and Clock Control (RCC)                        */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for RCC_CR register  ********************/
#define RCC_CR_HSION_Pos                     (0U)
#define RCC_CR_HSION_Msk                     (0x1UL << RCC_CR_HSION_Pos)        /*!< 0x00000001 */
#define RCC_CR_HSION                         RCC_CR_HSION_Msk                   /*!< Internal High Speed clock enable */
#define RCC_CR_HSIRDY_Pos                    (1U)
#define RCC_CR_HSIRDY_Msk                    (0x1UL << RCC_CR_HSIRDY_Pos)       /*!< 0x00000002 */
#define RCC_CR_HSIRDY                        RCC_CR_HSIRDY_Msk                  /*!< Internal High Speed clock ready flag */
#define RCC_CR_HSITRIM_Pos                   (3U)
#define RCC_CR_HSITRIM_Msk                   (0xFUL << RCC_CR_HSITRIM_Pos)      /*!< 0x00000078 */
#define RCC_CR_HSITRIM                       RCC_CR_HSITRIM_Msk                 /*!< Internal High Speed clock trimming */
#define RCC_CR_HSICAL_Pos                    (7U)
#define RCC_CR_HSICAL_Msk                    (0x1FFUL << RCC_CR_HSICAL_Pos)     /*!< 0x0000FF80 */
#define RCC_CR_HSICAL                        RCC_CR_HSICAL_Msk                  /*!< Internal High Speed clock Calibration */
#define RCC_CR_HSEON_Pos                     (16U)
#define RCC_CR_HSEON_Msk                     (0x1UL << RCC_CR_HSEON_Pos)        /*!< 0x00010000 */
#define RCC_CR_HSEON                         RCC_CR_HSEON_Msk                   /*!< External High Speed clock enable */
#define RCC_CR_HSERDY_Pos                    (17U)
#define RCC_CR_HSERDY_Msk                    (0x1UL << RCC_CR_HSERDY_Pos)       /*!< 0x00020000 */
#define RCC_CR_HSERDY                        RCC_CR_HSERDY_Msk                  /*!< External High Speed clock ready flag */
#define RCC_CR_HSEBYP_Pos                    (18U)
#define RCC_CR_HSEBYP_Msk                    (0x1UL << RCC_CR_HSEBYP_Pos)       /*!< 0x00040000 */
#define RCC_CR_HSEBYP                        RCC_CR_HSEBYP_Msk                  /*!< External High Speed clock Bypass */
#define RCC_CR_CSSON_Pos                     (19U)
#define RCC_CR_CSSON_Msk                     (0x1UL << RCC_CR_CSSON_Pos)        /*!< 0x00080000 */
#define RCC_CR_CSSON                         RCC_CR_CSSON_Msk                   /*!< Clock Security System enable */
#define RCC_CR_HSEDL_Pos                     (20U)
#define RCC_CR_HSEDL_Msk                     (0x7UL << RCC_CR_HSEDL_Pos)        /*!< 0x00700000 */
#define RCC_CR_HSEDL                         RCC_CR_HSEDL_Msk                   /*!< HSE gain control */
#define RCC_CR_PLLON_Pos                     (24U)
#define RCC_CR_PLLON_Msk                     (0x1UL << RCC_CR_PLLON_Pos)        /*!< 0x01000000 */
#define RCC_CR_PLLON                         RCC_CR_PLLON_Msk                   /*!< PLL enable */
#define RCC_CR_PLLRDY_Pos                    (25U)
#define RCC_CR_PLLRDY_Msk                    (0x1UL << RCC_CR_PLLRDY_Pos)       /*!< 0x02000000 */
#define RCC_CR_PLLRDY                        RCC_CR_PLLRDY_Msk                  /*!< PLL clock ready flag */

/*******************  Bit definition for RCC_CFGR register  *******************/
/*!< SW configuration */
#define RCC_CFGR_SW_Pos                      (0U)
#define RCC_CFGR_SW_Msk                      (0x3UL << RCC_CFGR_SW_Pos)         /*!< 0x00000003 */
#define RCC_CFGR_SW                          RCC_CFGR_SW_Msk                    /*!< SW[1:0] bits (System clock Switch) */
#define RCC_CFGR_SW_0                        (0x1UL << RCC_CFGR_SW_Pos)         /*!< 0x00000001 */
#define RCC_CFGR_SW_1                        (0x2UL << RCC_CFGR_SW_Pos)         /*!< 0x00000002 */

#define RCC_CFGR_SW_HSI                      0x00000000U                        /*!< HSI selected as system clock */
#define RCC_CFGR_SW_HSE                      0x00000001U                        /*!< HSE selected as system clock */
#define RCC_CFGR_SW_PLL                      0x00000002U                        /*!< PLL selected as system clock */

/*!< SWS configuration */
#define RCC_CFGR_SWS_Pos                     (2U)
#define RCC_CFGR_SWS_Msk                     (0x3UL << RCC_CFGR_SWS_Pos)        /*!< 0x0000000C */
#define RCC_CFGR_SWS                         RCC_CFGR_SWS_Msk                   /*!< SWS[1:0] bits (System Clock Switch Status) */
#define RCC_CFGR_SWS_0                       (0x1UL << RCC_CFGR_SWS_Pos)        /*!< 0x00000004 */
#define RCC_CFGR_SWS_1                       (0x2UL << RCC_CFGR_SWS_Pos)        /*!< 0x00000008 */

#define RCC_CFGR_SWS_HSI                     0x00000000U                        /*!< HSI oscillator used as system clock */
#define RCC_CFGR_SWS_HSE                     0x00000004U                        /*!< HSE oscillator used as system clock */
#define RCC_CFGR_SWS_PLL                     0x00000008U                        /*!< PLL used as system clock */

/*!< HPRE configuration */
#define RCC_CFGR_HPRE_Pos                    (4U)
#define RCC_CFGR_HPRE_Msk                    (0xFUL << RCC_CFGR_HPRE_Pos)       /*!< 0x000000F0 */
#define RCC_CFGR_HPRE                        RCC_CFGR_HPRE_Msk                  /*!< HPRE[3:0] bits (AHB prescaler) */
#define RCC_CFGR_HPRE_0                      (0x1UL << RCC_CFGR_HPRE_Pos)       /*!< 0x00000010 */
#define RCC_CFGR_HPRE_1                      (0x2UL << RCC_CFGR_HPRE_Pos)       /*!< 0x00000020 */
#define RCC_CFGR_HPRE_2                      (0x4UL << RCC_CFGR_HPRE_Pos)       /*!< 0x00000040 */
#define RCC_CFGR_HPRE_3                      (0x8UL << RCC_CFGR_HPRE_Pos)       /*!< 0x00000080 */

#define RCC_CFGR_HPRE_DIV1                   0x00000000U                        /*!< SYSCLK not divided */
#define RCC_CFGR_HPRE_DIV2                   0x00000080U                        /*!< SYSCLK divided by 2 */
#define RCC_CFGR_HPRE_DIV4                   0x00000090U                        /*!< SYSCLK divided by 4 */
#define RCC_CFGR_HPRE_DIV8                   0x000000A0U                        /*!< SYSCLK divided by 8 */
#define RCC_CFGR_HPRE_DIV16                  0x000000B0U                        /*!< SYSCLK divided by 16 */
#define RCC_CFGR_HPRE_DIV64                  0x000000C0U                        /*!< SYSCLK divided by 64 */
#define RCC_CFGR_HPRE_DIV128                 0x000000D0U                        /*!< SYSCLK divided by 128 */
#define RCC_CFGR_HPRE_DIV256                 0x000000E0U                        /*!< SYSCLK divided by 256 */
#define RCC_CFGR_HPRE_DIV512                 0x000000F0U                        /*!< SYSCLK divided by 512 */

/*!< PPRE1 configuration */
#define RCC_CFGR_PPRE1_Pos                   (8U)
#define RCC_CFGR_PPRE1_Msk                   (0x7UL << RCC_CFGR_PPRE1_Pos)      /*!< 0x00000700 */
#define RCC_CFGR_PPRE1                       RCC_CFGR_PPRE1_Msk                 /*!< PRE1[2:0] bits (APB1 prescaler) */
#define RCC_CFGR_PPRE1_0                     (0x1UL << RCC_CFGR_PPRE1_Pos)      /*!< 0x00000100 */
#define RCC_CFGR_PPRE1_1                     (0x2UL << RCC_CFGR_PPRE1_Pos)      /*!< 0x00000200 */
#define RCC_CFGR_PPRE1_2                     (0x4UL << RCC_CFGR_PPRE1_Pos)      /*!< 0x00000400 */

#define RCC_CFGR_PPRE1_DIV1                  0x00000000U                        /*!< HCLK not divided */
#define RCC_CFGR_PPRE1_DIV2                  0x00000400U                        /*!< HCLK divided by 2 */
#define RCC_CFGR_PPRE1_DIV4                  0x00000500U                        /*!< HCLK divided by 4 */
#define RCC_CFGR_PPRE1_DIV8                  0x00000600U                        /*!< HCLK divided by 8 */
#define RCC_CFGR_PPRE1_DIV16                 0x00000700U                        /*!< HCLK divided by 16 */

/*!< PPRE2 configuration */
#define RCC_CFGR_PPRE2_Pos                   (11U)
#define RCC_CFGR_PPRE2_Msk                   (0x7UL << RCC_CFGR_PPRE2_Pos)      /*!< 0x00003800 */
#define RCC_CFGR_PPRE2                       RCC_CFGR_PPRE2_Msk                 /*!< PRE2[2:0] bits (APB2 prescaler) */
#define RCC_CFGR_PPRE2_0                     (0x1UL << RCC_CFGR_PPRE2_Pos)      /*!< 0x00000800 */
#define RCC_CFGR_PPRE2_1                     (0x2UL << RCC_CFGR_PPRE2_Pos)      /*!< 0x00001000 */
#define RCC_CFGR_PPRE2_2                     (0x4UL << RCC_CFGR_PPRE2_Pos)      /*!< 0x00002000 */

#define RCC_CFGR_PPRE2_DIV1                  0x00000000U                        /*!< HCLK not divided */
#define RCC_CFGR_PPRE2_DIV2                  0x00002000U                        /*!< HCLK divided by 2 */
#define RCC_CFGR_PPRE2_DIV4                  0x00002800U                        /*!< HCLK divided by 4 */
#define RCC_CFGR_PPRE2_DIV8                  0x00003000U                        /*!< HCLK divided by 8 */
#define RCC_CFGR_PPRE2_DIV16                 0x00003800U                        /*!< HCLK divided by 16 */

/*!< ADCPPRE configuration */
#define RCC_CFGR_ADCPRE_Pos                  (14U)
#define RCC_CFGR_ADCPRE_Msk                  (0x3UL << RCC_CFGR_ADCPRE_Pos)     /*!< 0x0000C000 */
#define RCC_CFGR_ADCPRE                      RCC_CFGR_ADCPRE_Msk                /*!< ADCPRE[1:0] bits (ADC prescaler) */
#define RCC_CFGR_ADCPRE_0                    (0x1UL << RCC_CFGR_ADCPRE_Pos)     /*!< 0x00004000 */
#define RCC_CFGR_ADCPRE_1                    (0x2UL << RCC_CFGR_ADCPRE_Pos)     /*!< 0x00008000 */

#define RCC_CFGR_ADCPRE_DIV2                 0x00000000U                        /*!< PCLK2 divided by 2 */
#define RCC_CFGR_ADCPRE_DIV4                 0x00004000U                        /*!< PCLK2 divided by 4 */
#define RCC_CFGR_ADCPRE_DIV6                 0x00008000U                        /*!< PCLK2 divided by 6 */
#define RCC_CFGR_ADCPRE_DIV8                 0x0000C000U                        /*!< PCLK2 divided by 8 */

#define RCC_CFGR_PLLSRC_Pos                  (16U)
#define RCC_CFGR_PLLSRC_Msk                  (0x1UL << RCC_CFGR_PLLSRC_Pos)     /*!< 0x00010000 */
#define RCC_CFGR_PLLSRC                      RCC_CFGR_PLLSRC_Msk                /*!< PLL entry clock source */

#define RCC_CFGR_PLLSRC_HSI_DIV2             0x00000000U                        /*!< HSI clock divided by 2 selected as PLL entry clock source */
#define RCC_CFGR_PLLSRC_HSE                  0x00010000U                        /*!< HSE clock selected as PLL entry clock source */

#define RCC_CFGR_PLLXTPRE_Pos                (17U)
#define RCC_CFGR_PLLXTPRE_Msk                (0x1UL << RCC_CFGR_PLLXTPRE_Pos)   /*!< 0x00020000 */
#define RCC_CFGR_PLLXTPRE                    RCC_CFGR_PLLXTPRE_Msk              /*!< HSE divider for PLL entry */

/*!< PLLMUL configuration */
#define RCC_CFGR_PLLMULL_Pos                 (18U)
#define RCC_CFGR_PLLMULL_Msk                 (0xFUL << RCC_CFGR_PLLMULL_Pos)    /*!< 0x003C0000 */
#define RCC_CFGR_PLLMULL                     RCC_CFGR_PLLMULL_Msk               /*!< PLLMUL[3:0] bits (PLL multiplication factor) */
#define RCC_CFGR_PLLMULL_0                   (0x1UL << RCC_CFGR_PLLMULL_Pos)    /*!< 0x00040000 */
#define RCC_CFGR_PLLMULL_1                   (0x2UL << RCC_CFGR_PLLMULL_Pos)    /*!< 0x00080000 */
#define RCC_CFGR_PLLMULL_2                   (0x4UL << RCC_CFGR_PLLMULL_Pos)    /*!< 0x00100000 */
#define RCC_CFGR_PLLMULL_3                   (0x8UL << RCC_CFGR_PLLMULL_Pos)    /*!< 0x00200000 */

#define RCC_CFGR_PLLXTPRE_HSE                0x00000000U                        /*!< HSE clock not divided for PLL entry */
#define RCC_CFGR_PLLXTPRE_HSE_DIV2           0x00020000U                        /*!< HSE clock divided by 2 for PLL entry */

#define RCC_CFGR_PLLMULL2                    0x00000000U                        /*!< PLL input clock*2 */
#define RCC_CFGR_PLLMULL3_Pos                (18U)
#define RCC_CFGR_PLLMULL3_Msk                (0x1UL << RCC_CFGR_PLLMULL3_Pos)   /*!< 0x00040000 */
#define RCC_CFGR_PLLMULL3                    RCC_CFGR_PLLMULL3_Msk              /*!< PLL input clock*3 */
#define RCC_CFGR_PLLMULL4_Pos                (19U)
#define RCC_CFGR_PLLMULL4_Msk                (0x1UL << RCC_CFGR_PLLMULL4_Pos)   /*!< 0x00080000 */
#define RCC_CFGR_PLLMULL4                    RCC_CFGR_PLLMULL4_Msk              /*!< PLL input clock*4 */
#define RCC_CFGR_PLLMULL5_Pos                (18U)
#define RCC_CFGR_PLLMULL5_Msk                (0x3UL << RCC_CFGR_PLLMULL5_Pos)   /*!< 0x000C0000 */
#define RCC_CFGR_PLLMULL5                    RCC_CFGR_PLLMULL5_Msk              /*!< PLL input clock*5 */
#define RCC_CFGR_PLLMULL6_Pos                (20U)
#define RCC_CFGR_PLLMULL6_Msk                (0x1UL << RCC_CFGR_PLLMULL6_Pos)   /*!< 0x00100000 */
#define RCC_CFGR_PLLMULL6                    RCC_CFGR_PLLMULL6_Msk              /*!< PLL input clock*6 */
#define RCC_CFGR_PLLMULL7_Pos                (18U)
#define RCC_CFGR_PLLMULL7_Msk                (0x5UL << RCC_CFGR_PLLMULL7_Pos)   /*!< 0x00140000 */
#define RCC_CFGR_PLLMULL7                    RCC_CFGR_PLLMULL7_Msk              /*!< PLL input clock*7 */
#define RCC_CFGR_PLLMULL8_Pos                (19U)
#define RCC_CFGR_PLLMULL8_Msk                (0x3UL << RCC_CFGR_PLLMULL8_Pos)   /*!< 0x00180000 */
#define RCC_CFGR_PLLMULL8                    RCC_CFGR_PLLMULL8_Msk              /*!< PLL input clock*8 */
#define RCC_CFGR_PLLMULL9_Pos                (18U)
#define RCC_CFGR_PLLMULL9_Msk                (0x7UL << RCC_CFGR_PLLMULL9_Pos)   /*!< 0x001C0000 */
#define RCC_CFGR_PLLMULL9                    RCC_CFGR_PLLMULL9_Msk              /*!< PLL input clock*9 */
#define RCC_CFGR_PLLMULL10_Pos               (21U)
#define RCC_CFGR_PLLMULL10_Msk               (0x1UL << RCC_CFGR_PLLMULL10_Pos)  /*!< 0x00200000 */
#define RCC_CFGR_PLLMULL10                   RCC_CFGR_PLLMULL10_Msk             /*!< PLL input clock10 */
#define RCC_CFGR_PLLMULL11_Pos               (18U)
#define RCC_CFGR_PLLMULL11_Msk               (0x9UL << RCC_CFGR_PLLMULL11_Pos)  /*!< 0x00240000 */
#define RCC_CFGR_PLLMULL11                   RCC_CFGR_PLLMULL11_Msk             /*!< PLL input clock*11 */
#define RCC_CFGR_PLLMULL12_Pos               (19U)
#define RCC_CFGR_PLLMULL12_Msk               (0x5UL << RCC_CFGR_PLLMULL12_Pos)  /*!< 0x00280000 */
#define RCC_CFGR_PLLMULL12                   RCC_CFGR_PLLMULL12_Msk             /*!< PLL input clock*12 */
#define RCC_CFGR_PLLMULL13_Pos               (18U)
#define RCC_CFGR_PLLMULL13_Msk               (0xBUL << RCC_CFGR_PLLMULL13_Pos)  /*!< 0x002C0000 */
#define RCC_CFGR_PLLMULL13                   RCC_CFGR_PLLMULL13_Msk             /*!< PLL input clock*13 */
#define RCC_CFGR_PLLMULL14_Pos               (20U)
#define RCC_CFGR_PLLMULL14_Msk               (0x3UL << RCC_CFGR_PLLMULL14_Pos)  /*!< 0x00300000 */
#define RCC_CFGR_PLLMULL14                   RCC_CFGR_PLLMULL14_Msk             /*!< PLL input clock*14 */
#define RCC_CFGR_PLLMULL15_Pos               (18U)
#define RCC_CFGR_PLLMULL15_Msk               (0xDUL << RCC_CFGR_PLLMULL15_Pos)  /*!< 0x00340000 */
#define RCC_CFGR_PLLMULL15                   RCC_CFGR_PLLMULL15_Msk             /*!< PLL input clock*15 */
#define RCC_CFGR_PLLMULL16_Pos               (19U)
#define RCC_CFGR_PLLMULL16_Msk               (0x7UL << RCC_CFGR_PLLMULL16_Pos)  /*!< 0x00380000 */
#define RCC_CFGR_PLLMULL16                   RCC_CFGR_PLLMULL16_Msk             /*!< PLL input clock*16 */
#define RCC_CFGR_USBPRE_Pos                  (22U)
#define RCC_CFGR_USBPRE_Msk                  (0x1UL << RCC_CFGR_USBPRE_Pos)     /*!< 0x00400000 */
#define RCC_CFGR_USBPRE                      RCC_CFGR_USBPRE_Msk                /*!< USB Device prescaler */

/*!< MCO configuration */
#define RCC_CFGR_MCO_Pos                     (24U)
#define RCC_CFGR_MCO_Msk                     (0x7UL << RCC_CFGR_MCO_Pos)        /*!< 0x07000000 */
#define RCC_CFGR_MCO                         RCC_CFGR_MCO_Msk                   /*!< MCO[2:0] bits (Microcontroller Clock Output) */
#define RCC_CFGR_MCO_0                       (0x1UL << RCC_CFGR_MCO_Pos)        /*!< 0x01000000 */
#define RCC_CFGR_MCO_1                       (0x2UL << RCC_CFGR_MCO_Pos)        /*!< 0x02000000 */
#define RCC_CFGR_MCO_2                       (0x4UL << RCC_CFGR_MCO_Pos)        /*!< 0x04000000 */

#define RCC_CFGR_MCO_NOCLOCK                 0x00000000U                        /*!< No clock */
#define RCC_CFGR_MCO_SYSCLK                  0x04000000U                        /*!< System clock selected as MCO source */
#define RCC_CFGR_MCO_HSI                     0x05000000U                        /*!< HSI clock selected as MCO source */
#define RCC_CFGR_MCO_HSE                     0x06000000U                        /*!< HSE clock selected as MCO source  */
#define RCC_CFGR_MCO_PLLCLK_DIV2             0x07000000U                        /*!< PLL clock divided by 2 selected as MCO source */

/*!<******************  Bit definition for RCC_CIR register  ********************/
#define RCC_CIR_LSIRDYF_Pos                  (0U)
#define RCC_CIR_LSIRDYF_Msk                  (0x1UL << RCC_CIR_LSIRDYF_Pos)     /*!< 0x00000001 */
#define RCC_CIR_LSIRDYF                      RCC_CIR_LSIRDYF_Msk                /*!< LSI Ready Interrupt flag */
#define RCC_CIR_LSERDYF_Pos                  (1U)
#define RCC_CIR_LSERDYF_Msk                  (0x1UL << RCC_CIR_LSERDYF_Pos)     /*!< 0x00000002 */
#define RCC_CIR_LSERDYF                      RCC_CIR_LSERDYF_Msk                /*!< LSE Ready Interrupt flag */
#define RCC_CIR_HSIRDYF_Pos                  (2U)
#define RCC_CIR_HSIRDYF_Msk                  (0x1UL << RCC_CIR_HSIRDYF_Pos)     /*!< 0x00000004 */
#define RCC_CIR_HSIRDYF                      RCC_CIR_HSIRDYF_Msk                /*!< HSI Ready Interrupt flag */
#define RCC_CIR_HSERDYF_Pos                  (3U)
#define RCC_CIR_HSERDYF_Msk                  (0x1UL << RCC_CIR_HSERDYF_Pos)     /*!< 0x00000008 */
#define RCC_CIR_HSERDYF                      RCC_CIR_HSERDYF_Msk                /*!< HSE Ready Interrupt flag */
#define RCC_CIR_PLLRDYF_Pos                  (4U)
#define RCC_CIR_PLLRDYF_Msk                  (0x1UL << RCC_CIR_PLLRDYF_Pos)     /*!< 0x00000010 */
#define RCC_CIR_PLLRDYF                      RCC_CIR_PLLRDYF_Msk                /*!< PLL Ready Interrupt flag */
#define RCC_CIR_CSSF_Pos                     (7U)
#define RCC_CIR_CSSF_Msk                     (0x1UL << RCC_CIR_CSSF_Pos)        /*!< 0x00000080 */
#define RCC_CIR_CSSF                         RCC_CIR_CSSF_Msk                   /*!< Clock Security System Interrupt flag */
#define RCC_CIR_LSIRDYIE_Pos                 (8U)
#define RCC_CIR_LSIRDYIE_Msk                 (0x1UL << RCC_CIR_LSIRDYIE_Pos)    /*!< 0x00000100 */
#define RCC_CIR_LSIRDYIE                     RCC_CIR_LSIRDYIE_Msk               /*!< LSI Ready Interrupt Enable */
#define RCC_CIR_LSERDYIE_Pos                 (9U)
#define RCC_CIR_LSERDYIE_Msk                 (0x1UL << RCC_CIR_LSERDYIE_Pos)    /*!< 0x00000200 */
#define RCC_CIR_LSERDYIE                     RCC_CIR_LSERDYIE_Msk               /*!< LSE Ready Interrupt Enable */
#define RCC_CIR_HSIRDYIE_Pos                 (10U)
#define RCC_CIR_HSIRDYIE_Msk                 (0x1UL << RCC_CIR_HSIRDYIE_Pos)    /*!< 0x00000400 */
#define RCC_CIR_HSIRDYIE                     RCC_CIR_HSIRDYIE_Msk               /*!< HSI Ready Interrupt Enable */
#define RCC_CIR_HSERDYIE_Pos                 (11U)
#define RCC_CIR_HSERDYIE_Msk                 (0x1UL << RCC_CIR_HSERDYIE_Pos)    /*!< 0x00000800 */
#define RCC_CIR_HSERDYIE                     RCC_CIR_HSERDYIE_Msk               /*!< HSE Ready Interrupt Enable */
#define RCC_CIR_PLLRDYIE_Pos                 (12U)
#define RCC_CIR_PLLRDYIE_Msk                 (0x1UL << RCC_CIR_PLLRDYIE_Pos)    /*!< 0x00001000 */
#define RCC_CIR_PLLRDYIE                     RCC_CIR_PLLRDYIE_Msk               /*!< PLL Ready Interrupt Enable */
#define RCC_CIR_LSIRDYC_Pos                  (16U)
#define RCC_CIR_LSIRDYC_Msk                  (0x1UL << RCC_CIR_LSIRDYC_Pos)     /*!< 0x00010000 */
#define RCC_CIR_LSIRDYC                      RCC_CIR_LSIRDYC_Msk                /*!< LSI Ready Interrupt Clear */
#define RCC_CIR_LSERDYC_Pos                  (17U)
#define RCC_CIR_LSERDYC_Msk                  (0x1UL << RCC_CIR_LSERDYC_Pos)     /*!< 0x00020000 */
#define RCC_CIR_LSERDYC                      RCC_CIR_LSERDYC_Msk                /*!< LSE Ready Interrupt Clear */
#define RCC_CIR_HSIRDYC_Pos                  (18U)
#define RCC_CIR_HSIRDYC_Msk                  (0x1UL << RCC_CIR_HSIRDYC_Pos)     /*!< 0x00040000 */
#define RCC_CIR_HSIRDYC                      RCC_CIR_HSIRDYC_Msk                /*!< HSI Ready Interrupt Clear */
#define RCC_CIR_HSERDYC_Pos                  (19U)
#define RCC_CIR_HSERDYC_Msk                  (0x1UL << RCC_CIR_HSERDYC_Pos)     /*!< 0x00080000 */
#define RCC_CIR_HSERDYC                      RCC_CIR_HSERDYC_Msk                /*!< HSE Ready Interrupt Clear */
#define RCC_CIR_PLLRDYC_Pos                  (20U)
#define RCC_CIR_PLLRDYC_Msk                  (0x1UL << RCC_CIR_PLLRDYC_Pos)     /*!< 0x00100000 */
#define RCC_CIR_PLLRDYC                      RCC_CIR_PLLRDYC_Msk                /*!< PLL Ready Interrupt Clear */
#define RCC_CIR_CSSC_Pos                     (23U)
#define RCC_CIR_CSSC_Msk                     (0x1UL << RCC_CIR_CSSC_Pos)        /*!< 0x00800000 */
#define RCC_CIR_CSSC                         RCC_CIR_CSSC_Msk                   /*!< Clock Security System Interrupt Clear */

/*****************  Bit definition for RCC_APB2RSTR register  *****************/
#define RCC_APB2RSTR_AFIORST_Pos             (0U)
#define RCC_APB2RSTR_AFIORST_Msk             (0x1UL << RCC_APB2RSTR_AFIORST_Pos) /*!< 0x00000001 */
#define RCC_APB2RSTR_AFIORST                 RCC_APB2RSTR_AFIORST_Msk            /*!< Alternate Function I/O reset */
#define RCC_APB2RSTR_IOPARST_Pos             (2U)
#define RCC_APB2RSTR_IOPARST_Msk             (0x1UL << RCC_APB2RSTR_IOPARST_Pos) /*!< 0x00000004 */
#define RCC_APB2RSTR_IOPARST                 RCC_APB2RSTR_IOPARST_Msk            /*!< I/O port A reset */
#define RCC_APB2RSTR_IOPBRST_Pos             (3U)
#define RCC_APB2RSTR_IOPBRST_Msk             (0x1UL << RCC_APB2RSTR_IOPBRST_Pos) /*!< 0x00000008 */
#define RCC_APB2RSTR_IOPBRST                 RCC_APB2RSTR_IOPBRST_Msk            /*!< I/O port B reset */
#define RCC_APB2RSTR_IOPCRST_Pos             (4U)
#define RCC_APB2RSTR_IOPCRST_Msk             (0x1UL << RCC_APB2RSTR_IOPCRST_Pos) /*!< 0x00000010 */
#define RCC_APB2RSTR_IOPCRST                 RCC_APB2RSTR_IOPCRST_Msk            /*!< I/O port C reset */
#define RCC_APB2RSTR_IOPDRST_Pos             (5U)
#define RCC_APB2RSTR_IOPDRST_Msk             (0x1UL << RCC_APB2RSTR_IOPDRST_Pos) /*!< 0x00000020 */
#define RCC_APB2RSTR_IOPDRST                 RCC_APB2RSTR_IOPDRST_Msk            /*!< I/O port D reset */
#define RCC_APB2RSTR_IOPERST_Pos             (6U)
#define RCC_APB2RSTR_IOPERST_Msk             (0x1UL << RCC_APB2RSTR_IOPERST_Pos) /*!< 0x00000040 */
#define RCC_APB2RSTR_IOPERST                 RCC_APB2RSTR_IOPERST_Msk            /*!< I/O port E reset */
#define RCC_APB2RSTR_ADC1RST_Pos             (9U)
#define RCC_APB2RSTR_ADC1RST_Msk             (0x1UL << RCC_APB2RSTR_ADC1RST_Pos) /*!< 0x00000200 */
#define RCC_APB2RSTR_ADC1RST                 RCC_APB2RSTR_ADC1RST_Msk            /*!< ADC 1 interface reset */
#define RCC_APB2RSTR_ADC2RST_Pos             (10U)
#define RCC_APB2RSTR_ADC2RST_Msk             (0x1UL << RCC_APB2RSTR_ADC2RST_Pos) /*!< 0x00000400 */
#define RCC_APB2RSTR_ADC2RST                 RCC_APB2RSTR_ADC2RST_Msk            /*!< ADC 2 interface reset */
#define RCC_APB2RSTR_TIM1RST_Pos             (11U)
#define RCC_APB2RSTR_TIM1RST_Msk             (0x1UL << RCC_APB2RSTR_TIM1RST_Pos) /*!< 0x00000800 */
#define RCC_APB2RSTR_TIM1RST                 RCC_APB2RSTR_TIM1RST_Msk            /*!< TIM1 Timer reset */
#define RCC_APB2RSTR_SPI1RST_Pos             (12U)
#define RCC_APB2RSTR_SPI1RST_Msk             (0x1UL << RCC_APB2RSTR_SPI1RST_Pos) /*!< 0x00001000 */
#define RCC_APB2RSTR_SPI1RST                 RCC_APB2RSTR_SPI1RST_Msk            /*!< SPI 1 reset */
#define RCC_APB2RSTR_TIM8RST_Pos             (13U)
#define RCC_APB2RSTR_TIM8RST_Msk             (0x1UL << RCC_APB2RSTR_TIM8RST_Pos) /*!< 0x00002000 */
#define RCC_APB2RSTR_TIM8RST                 RCC_APB2RSTR_TIM8RST_Msk            /*!< TIM8 Timer reset */
#define RCC_APB2RSTR_USART1RST_Pos           (14U)
#define RCC_APB2RSTR_USART1RST_Msk           (0x1UL << RCC_APB2RSTR_USART1RST_Pos) /*!< 0x00004000 */
#define RCC_APB2RSTR_USART1RST               RCC_APB2RSTR_USART1RST_Msk          /*!< USART1 reset */
#define RCC_APB2RSTR_ADC3RST_Pos             (15U)
#define RCC_APB2RSTR_ADC3RST_Msk             (0x1UL << RCC_APB2RSTR_ADC3RST_Pos) /*!< 0x00008000 */
#define RCC_APB2RSTR_ADC3RST                 RCC_APB2RSTR_ADC3RST_Msk            /*!< ADC3 interface reset */

/*****************  Bit definition for RCC_APB1RSTR register  *****************/
#define RCC_APB1RSTR_TIM2RST_Pos             (0U)
#define RCC_APB1RSTR_TIM2RST_Msk             (0x1UL << RCC_APB1RSTR_TIM2RST_Pos) /*!< 0x00000001 */
#define RCC_APB1RSTR_TIM2RST                 RCC_APB1RSTR_TIM2RST_Msk            /*!< Timer 2 reset */
#define RCC_APB1RSTR_TIM3RST_Pos             (1U)
#define RCC_APB1RSTR_TIM3RST_Msk             (0x1UL << RCC_APB1RSTR_TIM3RST_Pos) /*!< 0x00000002 */
#define RCC_APB1RSTR_TIM3RST                 RCC_APB1RSTR_TIM3RST_Msk            /*!< Timer 3 reset */
#define RCC_APB1RSTR_TIM4RST_Pos             (2U)
#define RCC_APB1RSTR_TIM4RST_Msk             (0x1UL << RCC_APB1RSTR_TIM4RST_Pos) /*!< 0x00000004 */
#define RCC_APB1RSTR_TIM4RST                 RCC_APB1RSTR_TIM4RST_Msk            /*!< Timer 4 reset */
#define RCC_APB1RSTR_TIM5RST_Pos             (3U)
#define RCC_APB1RSTR_TIM5RST_Msk             (0x1UL << RCC_APB1RSTR_TIM5RST_Pos) /*!< 0x00000008 */
#define RCC_APB1RSTR_TIM5RST                 RCC_APB1RSTR_TIM5RST_Msk            /*!< Timer 5 reset */
#define RCC_APB1RSTR_TIM6RST_Pos             (4U)
#define RCC_APB1RSTR_TIM6RST_Msk             (0x1UL << RCC_APB1RSTR_TIM6RST_Pos) /*!< 0x00000010 */
#define RCC_APB1RSTR_TIM6RST                 RCC_APB1RSTR_TIM6RST_Msk            /*!< Timer 6 reset */
#define RCC_APB1RSTR_TIM7RST_Pos             (5U)
#define RCC_APB1RSTR_TIM7RST_Msk             (0x1UL << RCC_APB1RSTR_TIM7RST_Pos) /*!< 0x00000020 */
#define RCC_APB1RSTR_TIM7RST                 RCC_APB1RSTR_TIM7RST_Msk            /*!< Timer 7 reset */
#define RCC_APB1RSTR_WWDGRST_Pos             (11U)
#define RCC_APB1RSTR_WWDGRST_Msk             (0x1UL << RCC_APB1RSTR_WWDGRST_Pos) /*!< 0x00000800 */
#define RCC_APB1RSTR_WWDGRST                 RCC_APB1RSTR_WWDGRST_Msk            /*!< Window Watchdog reset */
#define RCC_APB1RSTR_SPI2RST_Pos             (14U)
#define RCC_APB1RSTR_SPI2RST_Msk             (0x1UL << RCC_APB1RSTR_SPI2RST_Pos) /*!< 0x00004000 */
#define RCC_APB1RSTR_SPI2RST                 RCC_APB1RSTR_SPI2RST_Msk            /*!< SPI 2 reset */
#define RCC_APB1RSTR_SPI3RST_Pos             (15U)
#define RCC_APB1RSTR_SPI3RST_Msk             (0x1UL << RCC_APB1RSTR_SPI3RST_Pos) /*!< 0x00008000 */
#define RCC_APB1RSTR_SPI3RST                 RCC_APB1RSTR_SPI3RST_Msk            /*!< SPI 3 reset */
#define RCC_APB1RSTR_USART2RST_Pos           (17U)
#define RCC_APB1RSTR_USART2RST_Msk           (0x1UL << RCC_APB1RSTR_USART2RST_Pos) /*!< 0x00020000 */
#define RCC_APB1RSTR_USART2RST               RCC_APB1RSTR_USART2RST_Msk            /*!< USART 2 reset */
#define RCC_APB1RSTR_USART3RST_Pos           (18U)
#define RCC_APB1RSTR_USART3RST_Msk           (0x1UL << RCC_APB1RSTR_USART3RST_Pos) /*!< 0x00040000 */
#define RCC_APB1RSTR_USART3RST               RCC_APB1RSTR_USART3RST_Msk            /*!< USART 3 reset */
#define RCC_APB1RSTR_UART4RST_Pos            (19U)
#define RCC_APB1RSTR_UART4RST_Msk            (0x1UL << RCC_APB1RSTR_UART4RST_Pos) /*!< 0x00080000 */
#define RCC_APB1RSTR_UART4RST                RCC_APB1RSTR_UART4RST_Msk            /*!< UART 4 reset */
#define RCC_APB1RSTR_UART5RST_Pos            (20U)
#define RCC_APB1RSTR_UART5RST_Msk            (0x1UL << RCC_APB1RSTR_UART5RST_Pos) /*!< 0x00100000 */
#define RCC_APB1RSTR_UART5RST                RCC_APB1RSTR_UART5RST_Msk            /*!< UART 5 reset */
#define RCC_APB1RSTR_I2C1RST_Pos             (21U)
#define RCC_APB1RSTR_I2C1RST_Msk             (0x1UL << RCC_APB1RSTR_I2C1RST_Pos) /*!< 0x00200000 */
#define RCC_APB1RSTR_I2C1RST                 RCC_APB1RSTR_I2C1RST_Msk            /*!< I2C 1 reset */
#define RCC_APB1RSTR_I2C2RST_Pos             (22U)
#define RCC_APB1RSTR_I2C2RST_Msk             (0x1UL << RCC_APB1RSTR_I2C2RST_Pos) /*!< 0x00400000 */
#define RCC_APB1RSTR_I2C2RST                 RCC_APB1RSTR_I2C2RST_Msk            /*!< I2C 2 reset */
#define RCC_APB1RSTR_USBRST_Pos              (23U)
#define RCC_APB1RSTR_USBRST_Msk              (0x1UL << RCC_APB1RSTR_USBRST_Pos)  /*!< 0x00800000 */
#define RCC_APB1RSTR_USBRST                  RCC_APB1RSTR_USBRST_Msk             /*!< USB Device reset */
#define RCC_APB1RSTR_CAN1RST_Pos             (25U)
#define RCC_APB1RSTR_CAN1RST_Msk             (0x1UL << RCC_APB1RSTR_CAN1RST_Pos) /*!< 0x02000000 */
#define RCC_APB1RSTR_CAN1RST                 RCC_APB1RSTR_CAN1RST_Msk            /*!< CAN1 reset */
#define RCC_APB1RSTR_BKPRST_Pos              (27U)
#define RCC_APB1RSTR_BKPRST_Msk              (0x1UL << RCC_APB1RSTR_BKPRST_Pos)  /*!< 0x08000000 */
#define RCC_APB1RSTR_BKPRST                  RCC_APB1RSTR_BKPRST_Msk             /*!< Backup interface reset */
#define RCC_APB1RSTR_PWRRST_Pos              (28U)
#define RCC_APB1RSTR_PWRRST_Msk              (0x1UL << RCC_APB1RSTR_PWRRST_Pos)  /*!< 0x10000000 */
#define RCC_APB1RSTR_PWRRST                  RCC_APB1RSTR_PWRRST_Msk             /*!< Power interface reset */
#define RCC_APB1RSTR_DACRST_Pos              (29U)
#define RCC_APB1RSTR_DACRST_Msk              (0x1UL << RCC_APB1RSTR_DACRST_Pos) /*!< 0x20000000 */
#define RCC_APB1RSTR_DACRST                  RCC_APB1RSTR_DACRST_Msk            /*!< DAC interface reset */

/******************  Bit definition for RCC_AHBENR register  ******************/
#define RCC_AHBENR_DMAC1EN_Pos               (0U)
#define RCC_AHBENR_DMAC1EN_Msk               (0x1UL << RCC_AHBENR_DMAC1EN_Pos)  /*!< 0x00000001 */
#define RCC_AHBENR_DMAC1EN                   RCC_AHBENR_DMAC1EN_Msk             /*!< DMAC1 clock enable */
#define RCC_AHBENR_DMAC2EN_Pos               (1U)
#define RCC_AHBENR_DMAC2EN_Msk               (0x1UL << RCC_AHBENR_DMAC2EN_Pos)  /*!< 0x00000002 */
#define RCC_AHBENR_DMAC2EN                   RCC_AHBENR_DMAC2EN_Msk             /*!< DMAC2 clock enable */
#define RCC_AHBENR_SRAMEN_Pos                (2U)
#define RCC_AHBENR_SRAMEN_Msk                (0x1UL << RCC_AHBENR_SRAMEN_Pos)   /*!< 0x00000004 */
#define RCC_AHBENR_SRAMEN                    RCC_AHBENR_SRAMEN_Msk              /*!< SRAM interface clock enable */
#define RCC_AHBENR_FLITFEN_Pos               (4U)
#define RCC_AHBENR_FLITFEN_Msk               (0x1UL << RCC_AHBENR_FLITFEN_Pos)  /*!< 0x00000010 */
#define RCC_AHBENR_FLITFEN                   RCC_AHBENR_FLITFEN_Msk             /*!< FLITF clock enable */
#define RCC_AHBENR_RNGEN_Pos                 (5U)
#define RCC_AHBENR_RNGEN_Msk                 (0x1UL << RCC_AHBENR_RNGEN_Pos)    /*!< 0x00000020 */
#define RCC_AHBENR_RNGEN                     RCC_AHBENR_RNGEN_Msk               /*!< RNG clock enable */
#define RCC_AHBENR_CRCEN_Pos                 (6U)
#define RCC_AHBENR_CRCEN_Msk                 (0x1UL << RCC_AHBENR_CRCEN_Pos)    /*!< 0x00000040 */
#define RCC_AHBENR_CRCEN                     RCC_AHBENR_CRCEN_Msk               /*!< CRC clock enable */
#define RCC_AHBENR_AESEN_Pos                 (7U)
#define RCC_AHBENR_AESEN_Msk                 (0x1UL << RCC_AHBENR_AESEN_Pos)    /*!< 0x00000080 */
#define RCC_AHBENR_AESEN                     RCC_AHBENR_AESEN_Msk               /*!< AES clock enable */
#define RCC_AHBENR_QUADSPIEN_Pos             (8U)
#define RCC_AHBENR_QUADSPIEN_Msk             (0x1UL << RCC_AHBENR_QUADSPIEN_Pos)/*!< 0x00000100 */
#define RCC_AHBENR_QUADSPIIEN                RCC_AHBENR_QUADSPIEN_Msk           /*!< QUADSPI clock enable */
#define RCC_AHBENR_SDIOEN_Pos                (10U)
#define RCC_AHBENR_SDIOEN_Msk                (0x1UL << RCC_AHBENR_SDIOEN_Pos)   /*!< 0x00000400 */
#define RCC_AHBENR_SDIOEN                    RCC_AHBENR_SDIOEN_Msk              /*!< SDIO clock enable */

/******************  Bit definition for RCC_APB2ENR register  *****************/
#define RCC_APB2ENR_AFIOEN_Pos               (0U)
#define RCC_APB2ENR_AFIOEN_Msk               (0x1UL << RCC_APB2ENR_AFIOEN_Pos)  /*!< 0x00000001 */
#define RCC_APB2ENR_AFIOEN                   RCC_APB2ENR_AFIOEN_Msk             /*!< Alternate Function I/O clock enable */
#define RCC_APB2ENR_IOPAEN_Pos               (2U)
#define RCC_APB2ENR_IOPAEN_Msk               (0x1UL << RCC_APB2ENR_IOPAEN_Pos)  /*!< 0x00000004 */
#define RCC_APB2ENR_IOPAEN                   RCC_APB2ENR_IOPAEN_Msk             /*!< I/O port A clock enable */
#define RCC_APB2ENR_IOPBEN_Pos               (3U)
#define RCC_APB2ENR_IOPBEN_Msk               (0x1UL << RCC_APB2ENR_IOPBEN_Pos)  /*!< 0x00000008 */
#define RCC_APB2ENR_IOPBEN                   RCC_APB2ENR_IOPBEN_Msk             /*!< I/O port B clock enable */
#define RCC_APB2ENR_IOPCEN_Pos               (4U)
#define RCC_APB2ENR_IOPCEN_Msk               (0x1UL << RCC_APB2ENR_IOPCEN_Pos)  /*!< 0x00000010 */
#define RCC_APB2ENR_IOPCEN                   RCC_APB2ENR_IOPCEN_Msk             /*!< I/O port C clock enable */
#define RCC_APB2ENR_IOPDEN_Pos               (5U)
#define RCC_APB2ENR_IOPDEN_Msk               (0x1UL << RCC_APB2ENR_IOPDEN_Pos)  /*!< 0x00000020 */
#define RCC_APB2ENR_IOPDEN                   RCC_APB2ENR_IOPDEN_Msk             /*!< I/O port D clock enable */
#define RCC_APB2ENR_IOPEEN_Pos               (6U)
#define RCC_APB2ENR_IOPEEN_Msk               (0x1UL << RCC_APB2ENR_IOPEEN_Pos)  /*!< 0x00000040 */
#define RCC_APB2ENR_IOPEEN                   RCC_APB2ENR_IOPEEN_Msk             /*!< I/O port E clock enable */
#define RCC_APB2ENR_ADC1EN_Pos               (9U)
#define RCC_APB2ENR_ADC1EN_Msk               (0x1UL << RCC_APB2ENR_ADC1EN_Pos)  /*!< 0x00000200 */
#define RCC_APB2ENR_ADC1EN                   RCC_APB2ENR_ADC1EN_Msk             /*!< ADC 1 interface clock enable */
#define RCC_APB2ENR_ADC2EN_Pos               (10U)
#define RCC_APB2ENR_ADC2EN_Msk               (0x1UL << RCC_APB2ENR_ADC2EN_Pos)  /*!< 0x00000400 */
#define RCC_APB2ENR_ADC2EN                   RCC_APB2ENR_ADC2EN_Msk             /*!< ADC 2 interface clock enable */
#define RCC_APB2ENR_TIM1EN_Pos               (11U)
#define RCC_APB2ENR_TIM1EN_Msk               (0x1UL << RCC_APB2ENR_TIM1EN_Pos)  /*!< 0x00000800 */
#define RCC_APB2ENR_TIM1EN                   RCC_APB2ENR_TIM1EN_Msk             /*!< TIM1 Timer clock enable */
#define RCC_APB2ENR_SPI1EN_Pos               (12U)
#define RCC_APB2ENR_SPI1EN_Msk               (0x1UL << RCC_APB2ENR_SPI1EN_Pos)  /*!< 0x00001000 */
#define RCC_APB2ENR_SPI1EN                   RCC_APB2ENR_SPI1EN_Msk             /*!< SPI 1 clock enable */
#define RCC_APB2ENR_TIM8EN_Pos               (13U)
#define RCC_APB2ENR_TIM8EN_Msk               (0x1UL << RCC_APB2ENR_TIM8EN_Pos)  /*!< 0x00002000 */
#define RCC_APB2ENR_TIM8EN                   RCC_APB2ENR_TIM8EN_Msk             /*!< TIM8 Timer clock enable */
#define RCC_APB2ENR_USART1EN_Pos             (14U)
#define RCC_APB2ENR_USART1EN_Msk             (0x1UL << RCC_APB2ENR_USART1EN_Pos) /*!< 0x00004000 */
#define RCC_APB2ENR_USART1EN                 RCC_APB2ENR_USART1EN_Msk            /*!< USART1 clock enable */
#define RCC_APB2ENR_ADC3EN_Pos               (15U)
#define RCC_APB2ENR_ADC3EN_Msk               (0x1UL << RCC_APB2ENR_ADC3EN_Pos)  /*!< 0x00008000 */
#define RCC_APB2ENR_ADC3EN                   RCC_APB2ENR_ADC3EN_Msk             /*!< ADC3 clock enable */

/*****************  Bit definition for RCC_APB1ENR register  ******************/
#define RCC_APB1ENR_TIM2EN_Pos               (0U)
#define RCC_APB1ENR_TIM2EN_Msk               (0x1UL << RCC_APB1ENR_TIM2EN_Pos)  /*!< 0x00000001 */
#define RCC_APB1ENR_TIM2EN                   RCC_APB1ENR_TIM2EN_Msk             /*!< Timer 2 clock enabled*/
#define RCC_APB1ENR_TIM3EN_Pos               (1U)
#define RCC_APB1ENR_TIM3EN_Msk               (0x1UL << RCC_APB1ENR_TIM3EN_Pos)  /*!< 0x00000002 */
#define RCC_APB1ENR_TIM3EN                   RCC_APB1ENR_TIM3EN_Msk             /*!< Timer 3 clock enable */
#define RCC_APB1ENR_TIM4EN_Pos               (2U)
#define RCC_APB1ENR_TIM4EN_Msk               (0x1UL << RCC_APB1ENR_TIM4EN_Pos)  /*!< 0x00000004 */
#define RCC_APB1ENR_TIM4EN                   RCC_APB1ENR_TIM4EN_Msk             /*!< Timer 4 clock enable */
#define RCC_APB1ENR_TIM5EN_Pos               (3U)
#define RCC_APB1ENR_TIM5EN_Msk               (0x1UL << RCC_APB1ENR_TIM5EN_Pos)  /*!< 0x00000008 */
#define RCC_APB1ENR_TIM5EN                   RCC_APB1ENR_TIM5EN_Msk             /*!< Timer 5 clock enable */
#define RCC_APB1ENR_TIM6EN_Pos               (4U)
#define RCC_APB1ENR_TIM6EN_Msk               (0x1UL << RCC_APB1ENR_TIM6EN_Pos)  /*!< 0x00000010 */
#define RCC_APB1ENR_TIM6EN                   RCC_APB1ENR_TIM6EN_Msk             /*!< Timer 6 clock enable */
#define RCC_APB1ENR_TIM7EN_Pos               (5U)
#define RCC_APB1ENR_TIM7EN_Msk               (0x1UL << RCC_APB1ENR_TIM7EN_Pos)  /*!< 0x00000020 */
#define RCC_APB1ENR_TIM7EN                   RCC_APB1ENR_TIM7EN_Msk             /*!< Timer 7 clock enable */
#define RCC_APB1ENR_WWDGEN_Pos               (11U)
#define RCC_APB1ENR_WWDGEN_Msk               (0x1UL << RCC_APB1ENR_WWDGEN_Pos)  /*!< 0x00000800 */
#define RCC_APB1ENR_WWDGEN                   RCC_APB1ENR_WWDGEN_Msk             /*!< Window Watchdog clock enable */
#define RCC_APB1ENR_SPI2EN_Pos               (14U)
#define RCC_APB1ENR_SPI2EN_Msk               (0x1UL << RCC_APB1ENR_SPI2EN_Pos)  /*!< 0x00004000 */
#define RCC_APB1ENR_SPI2EN                   RCC_APB1ENR_SPI2EN_Msk             /*!< SPI 2 clock enable */
#define RCC_APB1ENR_SPI3EN_Pos               (15U)
#define RCC_APB1ENR_SPI3EN_Msk               (0x1UL << RCC_APB1ENR_SPI3EN_Pos)  /*!< 0x00008000 */
#define RCC_APB1ENR_SPI3EN                   RCC_APB1ENR_SPI3EN_Msk             /*!< SPI 3 clock enable */
#define RCC_APB1ENR_USART2EN_Pos             (17U)
#define RCC_APB1ENR_USART2EN_Msk             (0x1UL << RCC_APB1ENR_USART2EN_Pos) /*!< 0x00020000 */
#define RCC_APB1ENR_USART2EN                 RCC_APB1ENR_USART2EN_Msk            /*!< USART 2 clock enable */
#define RCC_APB1ENR_USART3EN_Pos             (18U)
#define RCC_APB1ENR_USART3EN_Msk             (0x1UL << RCC_APB1ENR_USART3EN_Pos) /*!< 0x00040000 */
#define RCC_APB1ENR_USART3EN                 RCC_APB1ENR_USART3EN_Msk           /*!< USART 3 clock enable */
#define RCC_APB1ENR_UART4EN_Pos              (19U)
#define RCC_APB1ENR_UART4EN_Msk              (0x1UL << RCC_APB1ENR_UART4EN_Pos) /*!< 0x00080000 */
#define RCC_APB1ENR_UART4EN                  RCC_APB1ENR_UART4EN_Msk            /*!< UART 4 clock enable */
#define RCC_APB1ENR_UART5EN_Pos              (20U)
#define RCC_APB1ENR_UART5EN_Msk              (0x1UL << RCC_APB1ENR_UART5EN_Pos) /*!< 0x00100000 */
#define RCC_APB1ENR_UART5EN                  RCC_APB1ENR_UART5EN_Msk            /*!< UART 5 clock enable */
#define RCC_APB1ENR_I2C1EN_Pos               (21U)
#define RCC_APB1ENR_I2C1EN_Msk               (0x1UL << RCC_APB1ENR_I2C1EN_Pos)  /*!< 0x00200000 */
#define RCC_APB1ENR_I2C1EN                   RCC_APB1ENR_I2C1EN_Msk             /*!< I2C 1 clock enable */
#define RCC_APB1ENR_I2C2EN_Pos               (22U)
#define RCC_APB1ENR_I2C2EN_Msk               (0x1UL << RCC_APB1ENR_I2C2EN_Pos)  /*!< 0x00400000 */
#define RCC_APB1ENR_I2C2EN                   RCC_APB1ENR_I2C2EN_Msk             /*!< I2C 2 clock enable */
#define RCC_APB1ENR_USBEN_Pos                (23U)
#define RCC_APB1ENR_USBEN_Msk                (0x1UL << RCC_APB1ENR_USBEN_Pos)   /*!< 0x00800000 */
#define RCC_APB1ENR_USBEN                    RCC_APB1ENR_USBEN_Msk              /*!< USB Device clock enable */
#define RCC_APB1ENR_CAN1EN_Pos               (25U)
#define RCC_APB1ENR_CAN1EN_Msk               (0x1UL << RCC_APB1ENR_CAN1EN_Pos)  /*!< 0x02000000 */
#define RCC_APB1ENR_CAN1EN                   RCC_APB1ENR_CAN1EN_Msk             /*!< CAN1 clock enable */
#define RCC_APB1ENR_BKPEN_Pos                (27U)
#define RCC_APB1ENR_BKPEN_Msk                (0x1UL << RCC_APB1ENR_BKPEN_Pos)   /*!< 0x08000000 */
#define RCC_APB1ENR_BKPEN                    RCC_APB1ENR_BKPEN_Msk              /*!< Backup interface clock enable */
#define RCC_APB1ENR_PWREN_Pos                (28U)
#define RCC_APB1ENR_PWREN_Msk                (0x1UL << RCC_APB1ENR_PWREN_Pos)   /*!< 0x10000000 */
#define RCC_APB1ENR_PWREN                    RCC_APB1ENR_PWREN_Msk              /*!< Power interface clock enable */
#define RCC_APB1ENR_DACEN_Pos                (29U)
#define RCC_APB1ENR_DACEN_Msk                (0x1UL << RCC_APB1ENR_DACEN_Pos)   /*!< 0x20000000 */
#define RCC_APB1ENR_DACEN                    RCC_APB1ENR_DACEN_Msk              /*!< DAC interface clock enable */

/*******************  Bit definition for RCC_BDCR register  *******************/
#define RCC_BDCR_LSEON_Pos                   (0U)
#define RCC_BDCR_LSEON_Msk                   (0x1UL << RCC_BDCR_LSEON_Pos)      /*!< 0x00000001 */
#define RCC_BDCR_LSEON                       RCC_BDCR_LSEON_Msk                 /*!< External Low Speed oscillator enable */
#define RCC_BDCR_LSERDY_Pos                  (1U)
#define RCC_BDCR_LSERDY_Msk                  (0x1UL << RCC_BDCR_LSERDY_Pos)     /*!< 0x00000002 */
#define RCC_BDCR_LSERDY                      RCC_BDCR_LSERDY_Msk                /*!< External Low Speed oscillator Ready */
#define RCC_BDCR_LSEBYP_Pos                  (2U)
#define RCC_BDCR_LSEBYP_Msk                  (0x1UL << RCC_BDCR_LSEBYP_Pos)     /*!< 0x00000004 */
#define RCC_BDCR_LSEBYP                      RCC_BDCR_LSEBYP_Msk                /*!< External Low Speed oscillator Bypass */
#define RCC_BDCR_LSEDL_Pos                   (3U)
#define RCC_BDCR_LSEDL_Msk                   (0xFUL << RCC_BDCR_LSEDL_Pos)      /*!< 0x00000078 */
#define RCC_BDCR_LSEDL                       RCC_BDCR_LSEDL_Msk                 /*!< LSE gain control */

#define RCC_BDCR_RTCSEL_Pos                  (8U)
#define RCC_BDCR_RTCSEL_Msk                  (0x3UL << RCC_BDCR_RTCSEL_Pos)     /*!< 0x00000300 */
#define RCC_BDCR_RTCSEL                      RCC_BDCR_RTCSEL_Msk                /*!< RTCSEL[1:0] bits (RTC clock source selection) */
#define RCC_BDCR_RTCSEL_0                    (0x1UL << RCC_BDCR_RTCSEL_Pos)     /*!< 0x00000100 */
#define RCC_BDCR_RTCSEL_1                    (0x2UL << RCC_BDCR_RTCSEL_Pos)     /*!< 0x00000200 */

/*!< RTC congiguration */
#define RCC_BDCR_RTCSEL_NOCLOCK              0x00000000U                        /*!< No clock */
#define RCC_BDCR_RTCSEL_LSE                  0x00000100U                        /*!< LSE oscillator clock used as RTC clock */
#define RCC_BDCR_RTCSEL_LSI                  0x00000200U                        /*!< LSI oscillator clock used as RTC clock */
#define RCC_BDCR_RTCSEL_HSE                  0x00000300U                        /*!< HSE oscillator clock divided by 128 used as RTC clock */

#define RCC_BDCR_RTCEN_Pos                   (15U)
#define RCC_BDCR_RTCEN_Msk                   (0x1UL << RCC_BDCR_RTCEN_Pos)      /*!< 0x00008000 */
#define RCC_BDCR_RTCEN                       RCC_BDCR_RTCEN_Msk                 /*!< RTC clock enable */
#define RCC_BDCR_BDRST_Pos                   (16U)
#define RCC_BDCR_BDRST_Msk                   (0x1UL << RCC_BDCR_BDRST_Pos)      /*!< 0x00010000 */
#define RCC_BDCR_BDRST                       RCC_BDCR_BDRST_Msk                 /*!< Backup domain software reset  */

/*******************  Bit definition for RCC_CSR register  ********************/
#define RCC_CSR_LSION_Pos                    (0U)
#define RCC_CSR_LSION_Msk                    (0x1UL << RCC_CSR_LSION_Pos)       /*!< 0x00000001 */
#define RCC_CSR_LSION                        RCC_CSR_LSION_Msk                  /*!< Internal Low Speed oscillator enable */
#define RCC_CSR_LSIRDY_Pos                   (1U)
#define RCC_CSR_LSIRDY_Msk                   (0x1UL << RCC_CSR_LSIRDY_Pos)      /*!< 0x00000002 */
#define RCC_CSR_LSIRDY                       RCC_CSR_LSIRDY_Msk                 /*!< Internal Low Speed oscillator Ready */
#define RCC_CSR_RMVF_Pos                     (24U)
#define RCC_CSR_RMVF_Msk                     (0x1UL << RCC_CSR_RMVF_Pos)        /*!< 0x01000000 */
#define RCC_CSR_RMVF                         RCC_CSR_RMVF_Msk                   /*!< Remove reset flag */
#define RCC_CSR_PINRSTF_Pos                  (26U)
#define RCC_CSR_PINRSTF_Msk                  (0x1UL << RCC_CSR_PINRSTF_Pos)     /*!< 0x04000000 */
#define RCC_CSR_PINRSTF                      RCC_CSR_PINRSTF_Msk                /*!< PIN reset flag */
#define RCC_CSR_PORRSTF_Pos                  (27U)
#define RCC_CSR_PORRSTF_Msk                  (0x1UL << RCC_CSR_PORRSTF_Pos)     /*!< 0x08000000 */
#define RCC_CSR_PORRSTF                      RCC_CSR_PORRSTF_Msk                /*!< POR/PDR reset flag */
#define RCC_CSR_SFTRSTF_Pos                  (28U)
#define RCC_CSR_SFTRSTF_Msk                  (0x1UL << RCC_CSR_SFTRSTF_Pos)     /*!< 0x10000000 */
#define RCC_CSR_SFTRSTF                      RCC_CSR_SFTRSTF_Msk                /*!< Software Reset flag */
#define RCC_CSR_IWDGRSTF_Pos                 (29U)
#define RCC_CSR_IWDGRSTF_Msk                 (0x1UL << RCC_CSR_IWDGRSTF_Pos)    /*!< 0x20000000 */
#define RCC_CSR_IWDGRSTF                     RCC_CSR_IWDGRSTF_Msk               /*!< Independent Watchdog reset flag */
#define RCC_CSR_WWDGRSTF_Pos                 (30U)
#define RCC_CSR_WWDGRSTF_Msk                 (0x1UL << RCC_CSR_WWDGRSTF_Pos)    /*!< 0x40000000 */
#define RCC_CSR_WWDGRSTF                     RCC_CSR_WWDGRSTF_Msk               /*!< Window watchdog reset flag */
#define RCC_CSR_LPWRRSTF_Pos                 (31U)
#define RCC_CSR_LPWRRSTF_Msk                 (0x1UL << RCC_CSR_LPWRRSTF_Pos)    /*!< 0x80000000 */
#define RCC_CSR_LPWRRSTF                     RCC_CSR_LPWRRSTF_Msk               /*!< Low-Power reset flag */

/******************************************************************************/
/*                                                                            */
/*             General Purpose and Alternate Function I/O (GPIO)              */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for GPIO_CRL register  *******************/
#define GPIO_CRL_MODE_Pos                    (0U)                              
#define GPIO_CRL_MODE_Msk                    (0x33333333UL << GPIO_CRL_MODE_Pos) /*!< 0x33333333 */
#define GPIO_CRL_MODE                        GPIO_CRL_MODE_Msk                   /*!< Port x mode bits */

#define GPIO_CRL_MODE0_Pos                   (0U)                              
#define GPIO_CRL_MODE0_Msk                   (0x3UL << GPIO_CRL_MODE0_Pos)      /*!< 0x00000003 */
#define GPIO_CRL_MODE0                       GPIO_CRL_MODE0_Msk                 /*!< MODE0[1:0] bits (Port x mode bits, pin 0) */
#define GPIO_CRL_MODE0_0                     (0x1UL << GPIO_CRL_MODE0_Pos)      /*!< 0x00000001 */
#define GPIO_CRL_MODE0_1                     (0x2UL << GPIO_CRL_MODE0_Pos)      /*!< 0x00000002 */

#define GPIO_CRL_MODE1_Pos                   (4U)                              
#define GPIO_CRL_MODE1_Msk                   (0x3UL << GPIO_CRL_MODE1_Pos)      /*!< 0x00000030 */
#define GPIO_CRL_MODE1                       GPIO_CRL_MODE1_Msk                 /*!< MODE1[1:0] bits (Port x mode bits, pin 1) */
#define GPIO_CRL_MODE1_0                     (0x1UL << GPIO_CRL_MODE1_Pos)      /*!< 0x00000010 */
#define GPIO_CRL_MODE1_1                     (0x2UL << GPIO_CRL_MODE1_Pos)      /*!< 0x00000020 */

#define GPIO_CRL_MODE2_Pos                   (8U)                              
#define GPIO_CRL_MODE2_Msk                   (0x3UL << GPIO_CRL_MODE2_Pos)      /*!< 0x00000300 */
#define GPIO_CRL_MODE2                       GPIO_CRL_MODE2_Msk                 /*!< MODE2[1:0] bits (Port x mode bits, pin 2) */
#define GPIO_CRL_MODE2_0                     (0x1UL << GPIO_CRL_MODE2_Pos)      /*!< 0x00000100 */
#define GPIO_CRL_MODE2_1                     (0x2UL << GPIO_CRL_MODE2_Pos)      /*!< 0x00000200 */

#define GPIO_CRL_MODE3_Pos                   (12U)                             
#define GPIO_CRL_MODE3_Msk                   (0x3UL << GPIO_CRL_MODE3_Pos)      /*!< 0x00003000 */
#define GPIO_CRL_MODE3                       GPIO_CRL_MODE3_Msk                 /*!< MODE3[1:0] bits (Port x mode bits, pin 3) */
#define GPIO_CRL_MODE3_0                     (0x1UL << GPIO_CRL_MODE3_Pos)      /*!< 0x00001000 */
#define GPIO_CRL_MODE3_1                     (0x2UL << GPIO_CRL_MODE3_Pos)      /*!< 0x00002000 */

#define GPIO_CRL_MODE4_Pos                   (16U)                             
#define GPIO_CRL_MODE4_Msk                   (0x3UL << GPIO_CRL_MODE4_Pos)      /*!< 0x00030000 */
#define GPIO_CRL_MODE4                       GPIO_CRL_MODE4_Msk                 /*!< MODE4[1:0] bits (Port x mode bits, pin 4) */
#define GPIO_CRL_MODE4_0                     (0x1UL << GPIO_CRL_MODE4_Pos)      /*!< 0x00010000 */
#define GPIO_CRL_MODE4_1                     (0x2UL << GPIO_CRL_MODE4_Pos)      /*!< 0x00020000 */

#define GPIO_CRL_MODE5_Pos                   (20U)                             
#define GPIO_CRL_MODE5_Msk                   (0x3UL << GPIO_CRL_MODE5_Pos)      /*!< 0x00300000 */
#define GPIO_CRL_MODE5                       GPIO_CRL_MODE5_Msk                 /*!< MODE5[1:0] bits (Port x mode bits, pin 5) */
#define GPIO_CRL_MODE5_0                     (0x1UL << GPIO_CRL_MODE5_Pos)      /*!< 0x00100000 */
#define GPIO_CRL_MODE5_1                     (0x2UL << GPIO_CRL_MODE5_Pos)      /*!< 0x00200000 */

#define GPIO_CRL_MODE6_Pos                   (24U)                             
#define GPIO_CRL_MODE6_Msk                   (0x3UL << GPIO_CRL_MODE6_Pos)      /*!< 0x03000000 */
#define GPIO_CRL_MODE6                       GPIO_CRL_MODE6_Msk                 /*!< MODE6[1:0] bits (Port x mode bits, pin 6) */
#define GPIO_CRL_MODE6_0                     (0x1UL << GPIO_CRL_MODE6_Pos)      /*!< 0x01000000 */
#define GPIO_CRL_MODE6_1                     (0x2UL << GPIO_CRL_MODE6_Pos)      /*!< 0x02000000 */

#define GPIO_CRL_MODE7_Pos                   (28U)                             
#define GPIO_CRL_MODE7_Msk                   (0x3UL << GPIO_CRL_MODE7_Pos)      /*!< 0x30000000 */
#define GPIO_CRL_MODE7                       GPIO_CRL_MODE7_Msk                 /*!< MODE7[1:0] bits (Port x mode bits, pin 7) */
#define GPIO_CRL_MODE7_0                     (0x1UL << GPIO_CRL_MODE7_Pos)      /*!< 0x10000000 */
#define GPIO_CRL_MODE7_1                     (0x2UL << GPIO_CRL_MODE7_Pos)      /*!< 0x20000000 */

#define GPIO_CRL_CNF_Pos                     (2U)                              
#define GPIO_CRL_CNF_Msk                     (0x33333333UL << GPIO_CRL_CNF_Pos) /*!< 0xCCCCCCCC */
#define GPIO_CRL_CNF                         GPIO_CRL_CNF_Msk                   /*!< Port x configuration bits */

#define GPIO_CRL_CNF0_Pos                    (2U)                              
#define GPIO_CRL_CNF0_Msk                    (0x3UL << GPIO_CRL_CNF0_Pos)       /*!< 0x0000000C */
#define GPIO_CRL_CNF0                        GPIO_CRL_CNF0_Msk                  /*!< CNF0[1:0] bits (Port x configuration bits, pin 0) */
#define GPIO_CRL_CNF0_0                      (0x1UL << GPIO_CRL_CNF0_Pos)       /*!< 0x00000004 */
#define GPIO_CRL_CNF0_1                      (0x2UL << GPIO_CRL_CNF0_Pos)       /*!< 0x00000008 */

#define GPIO_CRL_CNF1_Pos                    (6U)                              
#define GPIO_CRL_CNF1_Msk                    (0x3UL << GPIO_CRL_CNF1_Pos)       /*!< 0x000000C0 */
#define GPIO_CRL_CNF1                        GPIO_CRL_CNF1_Msk                  /*!< CNF1[1:0] bits (Port x configuration bits, pin 1) */
#define GPIO_CRL_CNF1_0                      (0x1UL << GPIO_CRL_CNF1_Pos)       /*!< 0x00000040 */
#define GPIO_CRL_CNF1_1                      (0x2UL << GPIO_CRL_CNF1_Pos)       /*!< 0x00000080 */

#define GPIO_CRL_CNF2_Pos                    (10U)                             
#define GPIO_CRL_CNF2_Msk                    (0x3UL << GPIO_CRL_CNF2_Pos)       /*!< 0x00000C00 */
#define GPIO_CRL_CNF2                        GPIO_CRL_CNF2_Msk                  /*!< CNF2[1:0] bits (Port x configuration bits, pin 2) */
#define GPIO_CRL_CNF2_0                      (0x1UL << GPIO_CRL_CNF2_Pos)       /*!< 0x00000400 */
#define GPIO_CRL_CNF2_1                      (0x2UL << GPIO_CRL_CNF2_Pos)       /*!< 0x00000800 */

#define GPIO_CRL_CNF3_Pos                    (14U)                             
#define GPIO_CRL_CNF3_Msk                    (0x3UL << GPIO_CRL_CNF3_Pos)       /*!< 0x0000C000 */
#define GPIO_CRL_CNF3                        GPIO_CRL_CNF3_Msk                  /*!< CNF3[1:0] bits (Port x configuration bits, pin 3) */
#define GPIO_CRL_CNF3_0                      (0x1UL << GPIO_CRL_CNF3_Pos)       /*!< 0x00004000 */
#define GPIO_CRL_CNF3_1                      (0x2UL << GPIO_CRL_CNF3_Pos)       /*!< 0x00008000 */

#define GPIO_CRL_CNF4_Pos                    (18U)                             
#define GPIO_CRL_CNF4_Msk                    (0x3UL << GPIO_CRL_CNF4_Pos)       /*!< 0x000C0000 */
#define GPIO_CRL_CNF4                        GPIO_CRL_CNF4_Msk                  /*!< CNF4[1:0] bits (Port x configuration bits, pin 4) */
#define GPIO_CRL_CNF4_0                      (0x1UL << GPIO_CRL_CNF4_Pos)       /*!< 0x00040000 */
#define GPIO_CRL_CNF4_1                      (0x2UL << GPIO_CRL_CNF4_Pos)       /*!< 0x00080000 */

#define GPIO_CRL_CNF5_Pos                    (22U)                             
#define GPIO_CRL_CNF5_Msk                    (0x3UL << GPIO_CRL_CNF5_Pos)       /*!< 0x00C00000 */
#define GPIO_CRL_CNF5                        GPIO_CRL_CNF5_Msk                  /*!< CNF5[1:0] bits (Port x configuration bits, pin 5) */
#define GPIO_CRL_CNF5_0                      (0x1UL << GPIO_CRL_CNF5_Pos)       /*!< 0x00400000 */
#define GPIO_CRL_CNF5_1                      (0x2UL << GPIO_CRL_CNF5_Pos)       /*!< 0x00800000 */

#define GPIO_CRL_CNF6_Pos                    (26U)                             
#define GPIO_CRL_CNF6_Msk                    (0x3UL << GPIO_CRL_CNF6_Pos)       /*!< 0x0C000000 */
#define GPIO_CRL_CNF6                        GPIO_CRL_CNF6_Msk                  /*!< CNF6[1:0] bits (Port x configuration bits, pin 6) */
#define GPIO_CRL_CNF6_0                      (0x1UL << GPIO_CRL_CNF6_Pos)       /*!< 0x04000000 */
#define GPIO_CRL_CNF6_1                      (0x2UL << GPIO_CRL_CNF6_Pos)       /*!< 0x08000000 */

#define GPIO_CRL_CNF7_Pos                    (30U)                             
#define GPIO_CRL_CNF7_Msk                    (0x3UL << GPIO_CRL_CNF7_Pos)       /*!< 0xC0000000 */
#define GPIO_CRL_CNF7                        GPIO_CRL_CNF7_Msk                  /*!< CNF7[1:0] bits (Port x configuration bits, pin 7) */
#define GPIO_CRL_CNF7_0                      (0x1UL << GPIO_CRL_CNF7_Pos)       /*!< 0x40000000 */
#define GPIO_CRL_CNF7_1                      (0x2UL << GPIO_CRL_CNF7_Pos)       /*!< 0x80000000 */

/*******************  Bit definition for GPIO_CRH register  *******************/
#define GPIO_CRH_MODE_Pos                    (0U)                              
#define GPIO_CRH_MODE_Msk                    (0x33333333UL << GPIO_CRH_MODE_Pos) /*!< 0x33333333 */
#define GPIO_CRH_MODE                        GPIO_CRH_MODE_Msk                   /*!< Port x mode bits */

#define GPIO_CRH_MODE8_Pos                   (0U)                              
#define GPIO_CRH_MODE8_Msk                   (0x3UL << GPIO_CRH_MODE8_Pos)      /*!< 0x00000003 */
#define GPIO_CRH_MODE8                       GPIO_CRH_MODE8_Msk                 /*!< MODE8[1:0] bits (Port x mode bits, pin 8) */
#define GPIO_CRH_MODE8_0                     (0x1UL << GPIO_CRH_MODE8_Pos)      /*!< 0x00000001 */
#define GPIO_CRH_MODE8_1                     (0x2UL << GPIO_CRH_MODE8_Pos)      /*!< 0x00000002 */

#define GPIO_CRH_MODE9_Pos                   (4U)                              
#define GPIO_CRH_MODE9_Msk                   (0x3UL << GPIO_CRH_MODE9_Pos)      /*!< 0x00000030 */
#define GPIO_CRH_MODE9                       GPIO_CRH_MODE9_Msk                 /*!< MODE9[1:0] bits (Port x mode bits, pin 9) */
#define GPIO_CRH_MODE9_0                     (0x1UL << GPIO_CRH_MODE9_Pos)      /*!< 0x00000010 */
#define GPIO_CRH_MODE9_1                     (0x2UL << GPIO_CRH_MODE9_Pos)      /*!< 0x00000020 */

#define GPIO_CRH_MODE10_Pos                  (8U)                              
#define GPIO_CRH_MODE10_Msk                  (0x3UL << GPIO_CRH_MODE10_Pos)     /*!< 0x00000300 */
#define GPIO_CRH_MODE10                      GPIO_CRH_MODE10_Msk                /*!< MODE10[1:0] bits (Port x mode bits, pin 10) */
#define GPIO_CRH_MODE10_0                    (0x1UL << GPIO_CRH_MODE10_Pos)     /*!< 0x00000100 */
#define GPIO_CRH_MODE10_1                    (0x2UL << GPIO_CRH_MODE10_Pos)     /*!< 0x00000200 */

#define GPIO_CRH_MODE11_Pos                  (12U)                             
#define GPIO_CRH_MODE11_Msk                  (0x3UL << GPIO_CRH_MODE11_Pos)     /*!< 0x00003000 */
#define GPIO_CRH_MODE11                      GPIO_CRH_MODE11_Msk                /*!< MODE11[1:0] bits (Port x mode bits, pin 11) */
#define GPIO_CRH_MODE11_0                    (0x1UL << GPIO_CRH_MODE11_Pos)     /*!< 0x00001000 */
#define GPIO_CRH_MODE11_1                    (0x2UL << GPIO_CRH_MODE11_Pos)     /*!< 0x00002000 */

#define GPIO_CRH_MODE12_Pos                  (16U)                             
#define GPIO_CRH_MODE12_Msk                  (0x3UL << GPIO_CRH_MODE12_Pos)     /*!< 0x00030000 */
#define GPIO_CRH_MODE12                      GPIO_CRH_MODE12_Msk                /*!< MODE12[1:0] bits (Port x mode bits, pin 12) */
#define GPIO_CRH_MODE12_0                    (0x1UL << GPIO_CRH_MODE12_Pos)     /*!< 0x00010000 */
#define GPIO_CRH_MODE12_1                    (0x2UL << GPIO_CRH_MODE12_Pos)     /*!< 0x00020000 */

#define GPIO_CRH_MODE13_Pos                  (20U)                             
#define GPIO_CRH_MODE13_Msk                  (0x3UL << GPIO_CRH_MODE13_Pos)     /*!< 0x00300000 */
#define GPIO_CRH_MODE13                      GPIO_CRH_MODE13_Msk                /*!< MODE13[1:0] bits (Port x mode bits, pin 13) */
#define GPIO_CRH_MODE13_0                    (0x1UL << GPIO_CRH_MODE13_Pos)     /*!< 0x00100000 */
#define GPIO_CRH_MODE13_1                    (0x2UL << GPIO_CRH_MODE13_Pos)     /*!< 0x00200000 */

#define GPIO_CRH_MODE14_Pos                  (24U)                             
#define GPIO_CRH_MODE14_Msk                  (0x3UL << GPIO_CRH_MODE14_Pos)     /*!< 0x03000000 */
#define GPIO_CRH_MODE14                      GPIO_CRH_MODE14_Msk                /*!< MODE14[1:0] bits (Port x mode bits, pin 14) */
#define GPIO_CRH_MODE14_0                    (0x1UL << GPIO_CRH_MODE14_Pos)     /*!< 0x01000000 */
#define GPIO_CRH_MODE14_1                    (0x2UL << GPIO_CRH_MODE14_Pos)     /*!< 0x02000000 */

#define GPIO_CRH_MODE15_Pos                  (28U)                             
#define GPIO_CRH_MODE15_Msk                  (0x3UL << GPIO_CRH_MODE15_Pos)     /*!< 0x30000000 */
#define GPIO_CRH_MODE15                      GPIO_CRH_MODE15_Msk                /*!< MODE15[1:0] bits (Port x mode bits, pin 15) */
#define GPIO_CRH_MODE15_0                    (0x1UL << GPIO_CRH_MODE15_Pos)     /*!< 0x10000000 */
#define GPIO_CRH_MODE15_1                    (0x2UL << GPIO_CRH_MODE15_Pos)     /*!< 0x20000000 */

#define GPIO_CRH_CNF_Pos                     (2U)                              
#define GPIO_CRH_CNF_Msk                     (0x33333333UL << GPIO_CRH_CNF_Pos) /*!< 0xCCCCCCCC */
#define GPIO_CRH_CNF                         GPIO_CRH_CNF_Msk                   /*!< Port x configuration bits */

#define GPIO_CRH_CNF8_Pos                    (2U)                              
#define GPIO_CRH_CNF8_Msk                    (0x3UL << GPIO_CRH_CNF8_Pos)       /*!< 0x0000000C */
#define GPIO_CRH_CNF8                        GPIO_CRH_CNF8_Msk                  /*!< CNF8[1:0] bits (Port x configuration bits, pin 8) */
#define GPIO_CRH_CNF8_0                      (0x1UL << GPIO_CRH_CNF8_Pos)       /*!< 0x00000004 */
#define GPIO_CRH_CNF8_1                      (0x2UL << GPIO_CRH_CNF8_Pos)       /*!< 0x00000008 */

#define GPIO_CRH_CNF9_Pos                    (6U)                              
#define GPIO_CRH_CNF9_Msk                    (0x3UL << GPIO_CRH_CNF9_Pos)       /*!< 0x000000C0 */
#define GPIO_CRH_CNF9                        GPIO_CRH_CNF9_Msk                  /*!< CNF9[1:0] bits (Port x configuration bits, pin 9) */
#define GPIO_CRH_CNF9_0                      (0x1UL << GPIO_CRH_CNF9_Pos)       /*!< 0x00000040 */
#define GPIO_CRH_CNF9_1                      (0x2UL << GPIO_CRH_CNF9_Pos)       /*!< 0x00000080 */

#define GPIO_CRH_CNF10_Pos                   (10U)                             
#define GPIO_CRH_CNF10_Msk                   (0x3UL << GPIO_CRH_CNF10_Pos)      /*!< 0x00000C00 */
#define GPIO_CRH_CNF10                       GPIO_CRH_CNF10_Msk                 /*!< CNF10[1:0] bits (Port x configuration bits, pin 10) */
#define GPIO_CRH_CNF10_0                     (0x1UL << GPIO_CRH_CNF10_Pos)      /*!< 0x00000400 */
#define GPIO_CRH_CNF10_1                     (0x2UL << GPIO_CRH_CNF10_Pos)      /*!< 0x00000800 */

#define GPIO_CRH_CNF11_Pos                   (14U)                             
#define GPIO_CRH_CNF11_Msk                   (0x3UL << GPIO_CRH_CNF11_Pos)      /*!< 0x0000C000 */
#define GPIO_CRH_CNF11                       GPIO_CRH_CNF11_Msk                 /*!< CNF11[1:0] bits (Port x configuration bits, pin 11) */
#define GPIO_CRH_CNF11_0                     (0x1UL << GPIO_CRH_CNF11_Pos)      /*!< 0x00004000 */
#define GPIO_CRH_CNF11_1                     (0x2UL << GPIO_CRH_CNF11_Pos)      /*!< 0x00008000 */

#define GPIO_CRH_CNF12_Pos                   (18U)                             
#define GPIO_CRH_CNF12_Msk                   (0x3UL << GPIO_CRH_CNF12_Pos)      /*!< 0x000C0000 */
#define GPIO_CRH_CNF12                       GPIO_CRH_CNF12_Msk                 /*!< CNF12[1:0] bits (Port x configuration bits, pin 12) */
#define GPIO_CRH_CNF12_0                     (0x1UL << GPIO_CRH_CNF12_Pos)      /*!< 0x00040000 */
#define GPIO_CRH_CNF12_1                     (0x2UL << GPIO_CRH_CNF12_Pos)      /*!< 0x00080000 */

#define GPIO_CRH_CNF13_Pos                   (22U)                             
#define GPIO_CRH_CNF13_Msk                   (0x3UL << GPIO_CRH_CNF13_Pos)      /*!< 0x00C00000 */
#define GPIO_CRH_CNF13                       GPIO_CRH_CNF13_Msk                 /*!< CNF13[1:0] bits (Port x configuration bits, pin 13) */
#define GPIO_CRH_CNF13_0                     (0x1UL << GPIO_CRH_CNF13_Pos)      /*!< 0x00400000 */
#define GPIO_CRH_CNF13_1                     (0x2UL << GPIO_CRH_CNF13_Pos)      /*!< 0x00800000 */

#define GPIO_CRH_CNF14_Pos                   (26U)                             
#define GPIO_CRH_CNF14_Msk                   (0x3UL << GPIO_CRH_CNF14_Pos)      /*!< 0x0C000000 */
#define GPIO_CRH_CNF14                       GPIO_CRH_CNF14_Msk                 /*!< CNF14[1:0] bits (Port x configuration bits, pin 14) */
#define GPIO_CRH_CNF14_0                     (0x1UL << GPIO_CRH_CNF14_Pos)      /*!< 0x04000000 */
#define GPIO_CRH_CNF14_1                     (0x2UL << GPIO_CRH_CNF14_Pos)      /*!< 0x08000000 */

#define GPIO_CRH_CNF15_Pos                   (30U)                             
#define GPIO_CRH_CNF15_Msk                   (0x3UL << GPIO_CRH_CNF15_Pos)      /*!< 0xC0000000 */
#define GPIO_CRH_CNF15                       GPIO_CRH_CNF15_Msk                 /*!< CNF15[1:0] bits (Port x configuration bits, pin 15) */
#define GPIO_CRH_CNF15_0                     (0x1UL << GPIO_CRH_CNF15_Pos)      /*!< 0x40000000 */
#define GPIO_CRH_CNF15_1                     (0x2UL << GPIO_CRH_CNF15_Pos)      /*!< 0x80000000 */

/*!<******************  Bit definition for GPIO_IDR register  *******************/
#define GPIO_IDR_IDR0_Pos                    (0U)                              
#define GPIO_IDR_IDR0_Msk                    (0x1UL << GPIO_IDR_IDR0_Pos)       /*!< 0x00000001 */
#define GPIO_IDR_IDR0                        GPIO_IDR_IDR0_Msk                  /*!< Port input data, bit 0 */
#define GPIO_IDR_IDR1_Pos                    (1U)                              
#define GPIO_IDR_IDR1_Msk                    (0x1UL << GPIO_IDR_IDR1_Pos)       /*!< 0x00000002 */
#define GPIO_IDR_IDR1                        GPIO_IDR_IDR1_Msk                  /*!< Port input data, bit 1 */
#define GPIO_IDR_IDR2_Pos                    (2U)                              
#define GPIO_IDR_IDR2_Msk                    (0x1UL << GPIO_IDR_IDR2_Pos)       /*!< 0x00000004 */
#define GPIO_IDR_IDR2                        GPIO_IDR_IDR2_Msk                  /*!< Port input data, bit 2 */
#define GPIO_IDR_IDR3_Pos                    (3U)                              
#define GPIO_IDR_IDR3_Msk                    (0x1UL << GPIO_IDR_IDR3_Pos)       /*!< 0x00000008 */
#define GPIO_IDR_IDR3                        GPIO_IDR_IDR3_Msk                  /*!< Port input data, bit 3 */
#define GPIO_IDR_IDR4_Pos                    (4U)                              
#define GPIO_IDR_IDR4_Msk                    (0x1UL << GPIO_IDR_IDR4_Pos)       /*!< 0x00000010 */
#define GPIO_IDR_IDR4                        GPIO_IDR_IDR4_Msk                  /*!< Port input data, bit 4 */
#define GPIO_IDR_IDR5_Pos                    (5U)                              
#define GPIO_IDR_IDR5_Msk                    (0x1UL << GPIO_IDR_IDR5_Pos)       /*!< 0x00000020 */
#define GPIO_IDR_IDR5                        GPIO_IDR_IDR5_Msk                  /*!< Port input data, bit 5 */
#define GPIO_IDR_IDR6_Pos                    (6U)                              
#define GPIO_IDR_IDR6_Msk                    (0x1UL << GPIO_IDR_IDR6_Pos)       /*!< 0x00000040 */
#define GPIO_IDR_IDR6                        GPIO_IDR_IDR6_Msk                  /*!< Port input data, bit 6 */
#define GPIO_IDR_IDR7_Pos                    (7U)                              
#define GPIO_IDR_IDR7_Msk                    (0x1UL << GPIO_IDR_IDR7_Pos)       /*!< 0x00000080 */
#define GPIO_IDR_IDR7                        GPIO_IDR_IDR7_Msk                  /*!< Port input data, bit 7 */
#define GPIO_IDR_IDR8_Pos                    (8U)                              
#define GPIO_IDR_IDR8_Msk                    (0x1UL << GPIO_IDR_IDR8_Pos)       /*!< 0x00000100 */
#define GPIO_IDR_IDR8                        GPIO_IDR_IDR8_Msk                  /*!< Port input data, bit 8 */
#define GPIO_IDR_IDR9_Pos                    (9U)                              
#define GPIO_IDR_IDR9_Msk                    (0x1UL << GPIO_IDR_IDR9_Pos)       /*!< 0x00000200 */
#define GPIO_IDR_IDR9                        GPIO_IDR_IDR9_Msk                  /*!< Port input data, bit 9 */
#define GPIO_IDR_IDR10_Pos                   (10U)                             
#define GPIO_IDR_IDR10_Msk                   (0x1UL << GPIO_IDR_IDR10_Pos)      /*!< 0x00000400 */
#define GPIO_IDR_IDR10                       GPIO_IDR_IDR10_Msk                 /*!< Port input data, bit 10 */
#define GPIO_IDR_IDR11_Pos                   (11U)                             
#define GPIO_IDR_IDR11_Msk                   (0x1UL << GPIO_IDR_IDR11_Pos)      /*!< 0x00000800 */
#define GPIO_IDR_IDR11                       GPIO_IDR_IDR11_Msk                 /*!< Port input data, bit 11 */
#define GPIO_IDR_IDR12_Pos                   (12U)                             
#define GPIO_IDR_IDR12_Msk                   (0x1UL << GPIO_IDR_IDR12_Pos)      /*!< 0x00001000 */
#define GPIO_IDR_IDR12                       GPIO_IDR_IDR12_Msk                 /*!< Port input data, bit 12 */
#define GPIO_IDR_IDR13_Pos                   (13U)                             
#define GPIO_IDR_IDR13_Msk                   (0x1UL << GPIO_IDR_IDR13_Pos)      /*!< 0x00002000 */
#define GPIO_IDR_IDR13                       GPIO_IDR_IDR13_Msk                 /*!< Port input data, bit 13 */
#define GPIO_IDR_IDR14_Pos                   (14U)                             
#define GPIO_IDR_IDR14_Msk                   (0x1UL << GPIO_IDR_IDR14_Pos)      /*!< 0x00004000 */
#define GPIO_IDR_IDR14                       GPIO_IDR_IDR14_Msk                 /*!< Port input data, bit 14 */
#define GPIO_IDR_IDR15_Pos                   (15U)                             
#define GPIO_IDR_IDR15_Msk                   (0x1UL << GPIO_IDR_IDR15_Pos)      /*!< 0x00008000 */
#define GPIO_IDR_IDR15                       GPIO_IDR_IDR15_Msk                 /*!< Port input data, bit 15 */

/*******************  Bit definition for GPIO_ODR register  *******************/
#define GPIO_ODR_ODR0_Pos                    (0U)                              
#define GPIO_ODR_ODR0_Msk                    (0x1UL << GPIO_ODR_ODR0_Pos)       /*!< 0x00000001 */
#define GPIO_ODR_ODR0                        GPIO_ODR_ODR0_Msk                  /*!< Port output data, bit 0 */
#define GPIO_ODR_ODR1_Pos                    (1U)                              
#define GPIO_ODR_ODR1_Msk                    (0x1UL << GPIO_ODR_ODR1_Pos)       /*!< 0x00000002 */
#define GPIO_ODR_ODR1                        GPIO_ODR_ODR1_Msk                  /*!< Port output data, bit 1 */
#define GPIO_ODR_ODR2_Pos                    (2U)                              
#define GPIO_ODR_ODR2_Msk                    (0x1UL << GPIO_ODR_ODR2_Pos)       /*!< 0x00000004 */
#define GPIO_ODR_ODR2                        GPIO_ODR_ODR2_Msk                  /*!< Port output data, bit 2 */
#define GPIO_ODR_ODR3_Pos                    (3U)                              
#define GPIO_ODR_ODR3_Msk                    (0x1UL << GPIO_ODR_ODR3_Pos)       /*!< 0x00000008 */
#define GPIO_ODR_ODR3                        GPIO_ODR_ODR3_Msk                  /*!< Port output data, bit 3 */
#define GPIO_ODR_ODR4_Pos                    (4U)                              
#define GPIO_ODR_ODR4_Msk                    (0x1UL << GPIO_ODR_ODR4_Pos)       /*!< 0x00000010 */
#define GPIO_ODR_ODR4                        GPIO_ODR_ODR4_Msk                  /*!< Port output data, bit 4 */
#define GPIO_ODR_ODR5_Pos                    (5U)                              
#define GPIO_ODR_ODR5_Msk                    (0x1UL << GPIO_ODR_ODR5_Pos)       /*!< 0x00000020 */
#define GPIO_ODR_ODR5                        GPIO_ODR_ODR5_Msk                  /*!< Port output data, bit 5 */
#define GPIO_ODR_ODR6_Pos                    (6U)                              
#define GPIO_ODR_ODR6_Msk                    (0x1UL << GPIO_ODR_ODR6_Pos)       /*!< 0x00000040 */
#define GPIO_ODR_ODR6                        GPIO_ODR_ODR6_Msk                  /*!< Port output data, bit 6 */
#define GPIO_ODR_ODR7_Pos                    (7U)                              
#define GPIO_ODR_ODR7_Msk                    (0x1UL << GPIO_ODR_ODR7_Pos)       /*!< 0x00000080 */
#define GPIO_ODR_ODR7                        GPIO_ODR_ODR7_Msk                  /*!< Port output data, bit 7 */
#define GPIO_ODR_ODR8_Pos                    (8U)                              
#define GPIO_ODR_ODR8_Msk                    (0x1UL << GPIO_ODR_ODR8_Pos)       /*!< 0x00000100 */
#define GPIO_ODR_ODR8                        GPIO_ODR_ODR8_Msk                  /*!< Port output data, bit 8 */
#define GPIO_ODR_ODR9_Pos                    (9U)                              
#define GPIO_ODR_ODR9_Msk                    (0x1UL << GPIO_ODR_ODR9_Pos)       /*!< 0x00000200 */
#define GPIO_ODR_ODR9                        GPIO_ODR_ODR9_Msk                  /*!< Port output data, bit 9 */
#define GPIO_ODR_ODR10_Pos                   (10U)                             
#define GPIO_ODR_ODR10_Msk                   (0x1UL << GPIO_ODR_ODR10_Pos)      /*!< 0x00000400 */
#define GPIO_ODR_ODR10                       GPIO_ODR_ODR10_Msk                 /*!< Port output data, bit 10 */
#define GPIO_ODR_ODR11_Pos                   (11U)                             
#define GPIO_ODR_ODR11_Msk                   (0x1UL << GPIO_ODR_ODR11_Pos)      /*!< 0x00000800 */
#define GPIO_ODR_ODR11                       GPIO_ODR_ODR11_Msk                 /*!< Port output data, bit 11 */
#define GPIO_ODR_ODR12_Pos                   (12U)                             
#define GPIO_ODR_ODR12_Msk                   (0x1UL << GPIO_ODR_ODR12_Pos)      /*!< 0x00001000 */
#define GPIO_ODR_ODR12                       GPIO_ODR_ODR12_Msk                 /*!< Port output data, bit 12 */
#define GPIO_ODR_ODR13_Pos                   (13U)                             
#define GPIO_ODR_ODR13_Msk                   (0x1UL << GPIO_ODR_ODR13_Pos)      /*!< 0x00002000 */
#define GPIO_ODR_ODR13                       GPIO_ODR_ODR13_Msk                 /*!< Port output data, bit 13 */
#define GPIO_ODR_ODR14_Pos                   (14U)                             
#define GPIO_ODR_ODR14_Msk                   (0x1UL << GPIO_ODR_ODR14_Pos)      /*!< 0x00004000 */
#define GPIO_ODR_ODR14                       GPIO_ODR_ODR14_Msk                 /*!< Port output data, bit 14 */
#define GPIO_ODR_ODR15_Pos                   (15U)                             
#define GPIO_ODR_ODR15_Msk                   (0x1UL << GPIO_ODR_ODR15_Pos)      /*!< 0x00008000 */
#define GPIO_ODR_ODR15                       GPIO_ODR_ODR15_Msk                 /*!< Port output data, bit 15 */

/******************  Bit definition for GPIO_BSRR register  *******************/
#define GPIO_BSRR_BS0_Pos                    (0U)                              
#define GPIO_BSRR_BS0_Msk                    (0x1UL << GPIO_BSRR_BS0_Pos)       /*!< 0x00000001 */
#define GPIO_BSRR_BS0                        GPIO_BSRR_BS0_Msk                  /*!< Port x Set bit 0 */
#define GPIO_BSRR_BS1_Pos                    (1U)                              
#define GPIO_BSRR_BS1_Msk                    (0x1UL << GPIO_BSRR_BS1_Pos)       /*!< 0x00000002 */
#define GPIO_BSRR_BS1                        GPIO_BSRR_BS1_Msk                  /*!< Port x Set bit 1 */
#define GPIO_BSRR_BS2_Pos                    (2U)                              
#define GPIO_BSRR_BS2_Msk                    (0x1UL << GPIO_BSRR_BS2_Pos)       /*!< 0x00000004 */
#define GPIO_BSRR_BS2                        GPIO_BSRR_BS2_Msk                  /*!< Port x Set bit 2 */
#define GPIO_BSRR_BS3_Pos                    (3U)                              
#define GPIO_BSRR_BS3_Msk                    (0x1UL << GPIO_BSRR_BS3_Pos)       /*!< 0x00000008 */
#define GPIO_BSRR_BS3                        GPIO_BSRR_BS3_Msk                  /*!< Port x Set bit 3 */
#define GPIO_BSRR_BS4_Pos                    (4U)                              
#define GPIO_BSRR_BS4_Msk                    (0x1UL << GPIO_BSRR_BS4_Pos)       /*!< 0x00000010 */
#define GPIO_BSRR_BS4                        GPIO_BSRR_BS4_Msk                  /*!< Port x Set bit 4 */
#define GPIO_BSRR_BS5_Pos                    (5U)                              
#define GPIO_BSRR_BS5_Msk                    (0x1UL << GPIO_BSRR_BS5_Pos)       /*!< 0x00000020 */
#define GPIO_BSRR_BS5                        GPIO_BSRR_BS5_Msk                  /*!< Port x Set bit 5 */
#define GPIO_BSRR_BS6_Pos                    (6U)                              
#define GPIO_BSRR_BS6_Msk                    (0x1UL << GPIO_BSRR_BS6_Pos)       /*!< 0x00000040 */
#define GPIO_BSRR_BS6                        GPIO_BSRR_BS6_Msk                  /*!< Port x Set bit 6 */
#define GPIO_BSRR_BS7_Pos                    (7U)                              
#define GPIO_BSRR_BS7_Msk                    (0x1UL << GPIO_BSRR_BS7_Pos)       /*!< 0x00000080 */
#define GPIO_BSRR_BS7                        GPIO_BSRR_BS7_Msk                  /*!< Port x Set bit 7 */
#define GPIO_BSRR_BS8_Pos                    (8U)                              
#define GPIO_BSRR_BS8_Msk                    (0x1UL << GPIO_BSRR_BS8_Pos)       /*!< 0x00000100 */
#define GPIO_BSRR_BS8                        GPIO_BSRR_BS8_Msk                  /*!< Port x Set bit 8 */
#define GPIO_BSRR_BS9_Pos                    (9U)                              
#define GPIO_BSRR_BS9_Msk                    (0x1UL << GPIO_BSRR_BS9_Pos)       /*!< 0x00000200 */
#define GPIO_BSRR_BS9                        GPIO_BSRR_BS9_Msk                  /*!< Port x Set bit 9 */
#define GPIO_BSRR_BS10_Pos                   (10U)                             
#define GPIO_BSRR_BS10_Msk                   (0x1UL << GPIO_BSRR_BS10_Pos)      /*!< 0x00000400 */
#define GPIO_BSRR_BS10                       GPIO_BSRR_BS10_Msk                 /*!< Port x Set bit 10 */
#define GPIO_BSRR_BS11_Pos                   (11U)                             
#define GPIO_BSRR_BS11_Msk                   (0x1UL << GPIO_BSRR_BS11_Pos)      /*!< 0x00000800 */
#define GPIO_BSRR_BS11                       GPIO_BSRR_BS11_Msk                 /*!< Port x Set bit 11 */
#define GPIO_BSRR_BS12_Pos                   (12U)                             
#define GPIO_BSRR_BS12_Msk                   (0x1UL << GPIO_BSRR_BS12_Pos)      /*!< 0x00001000 */
#define GPIO_BSRR_BS12                       GPIO_BSRR_BS12_Msk                 /*!< Port x Set bit 12 */
#define GPIO_BSRR_BS13_Pos                   (13U)                             
#define GPIO_BSRR_BS13_Msk                   (0x1UL << GPIO_BSRR_BS13_Pos)      /*!< 0x00002000 */
#define GPIO_BSRR_BS13                       GPIO_BSRR_BS13_Msk                 /*!< Port x Set bit 13 */
#define GPIO_BSRR_BS14_Pos                   (14U)                             
#define GPIO_BSRR_BS14_Msk                   (0x1UL << GPIO_BSRR_BS14_Pos)      /*!< 0x00004000 */
#define GPIO_BSRR_BS14                       GPIO_BSRR_BS14_Msk                 /*!< Port x Set bit 14 */
#define GPIO_BSRR_BS15_Pos                   (15U)                             
#define GPIO_BSRR_BS15_Msk                   (0x1UL << GPIO_BSRR_BS15_Pos)      /*!< 0x00008000 */
#define GPIO_BSRR_BS15                       GPIO_BSRR_BS15_Msk                 /*!< Port x Set bit 15 */

#define GPIO_BSRR_BR0_Pos                    (16U)                             
#define GPIO_BSRR_BR0_Msk                    (0x1UL << GPIO_BSRR_BR0_Pos)       /*!< 0x00010000 */
#define GPIO_BSRR_BR0                        GPIO_BSRR_BR0_Msk                  /*!< Port x Reset bit 0 */
#define GPIO_BSRR_BR1_Pos                    (17U)                             
#define GPIO_BSRR_BR1_Msk                    (0x1UL << GPIO_BSRR_BR1_Pos)       /*!< 0x00020000 */
#define GPIO_BSRR_BR1                        GPIO_BSRR_BR1_Msk                  /*!< Port x Reset bit 1 */
#define GPIO_BSRR_BR2_Pos                    (18U)                             
#define GPIO_BSRR_BR2_Msk                    (0x1UL << GPIO_BSRR_BR2_Pos)       /*!< 0x00040000 */
#define GPIO_BSRR_BR2                        GPIO_BSRR_BR2_Msk                  /*!< Port x Reset bit 2 */
#define GPIO_BSRR_BR3_Pos                    (19U)                             
#define GPIO_BSRR_BR3_Msk                    (0x1UL << GPIO_BSRR_BR3_Pos)       /*!< 0x00080000 */
#define GPIO_BSRR_BR3                        GPIO_BSRR_BR3_Msk                  /*!< Port x Reset bit 3 */
#define GPIO_BSRR_BR4_Pos                    (20U)                             
#define GPIO_BSRR_BR4_Msk                    (0x1UL << GPIO_BSRR_BR4_Pos)       /*!< 0x00100000 */
#define GPIO_BSRR_BR4                        GPIO_BSRR_BR4_Msk                  /*!< Port x Reset bit 4 */
#define GPIO_BSRR_BR5_Pos                    (21U)                             
#define GPIO_BSRR_BR5_Msk                    (0x1UL << GPIO_BSRR_BR5_Pos)       /*!< 0x00200000 */
#define GPIO_BSRR_BR5                        GPIO_BSRR_BR5_Msk                  /*!< Port x Reset bit 5 */
#define GPIO_BSRR_BR6_Pos                    (22U)                             
#define GPIO_BSRR_BR6_Msk                    (0x1UL << GPIO_BSRR_BR6_Pos)       /*!< 0x00400000 */
#define GPIO_BSRR_BR6                        GPIO_BSRR_BR6_Msk                  /*!< Port x Reset bit 6 */
#define GPIO_BSRR_BR7_Pos                    (23U)                             
#define GPIO_BSRR_BR7_Msk                    (0x1UL << GPIO_BSRR_BR7_Pos)       /*!< 0x00800000 */
#define GPIO_BSRR_BR7                        GPIO_BSRR_BR7_Msk                  /*!< Port x Reset bit 7 */
#define GPIO_BSRR_BR8_Pos                    (24U)                             
#define GPIO_BSRR_BR8_Msk                    (0x1UL << GPIO_BSRR_BR8_Pos)       /*!< 0x01000000 */
#define GPIO_BSRR_BR8                        GPIO_BSRR_BR8_Msk                  /*!< Port x Reset bit 8 */
#define GPIO_BSRR_BR9_Pos                    (25U)                             
#define GPIO_BSRR_BR9_Msk                    (0x1UL << GPIO_BSRR_BR9_Pos)       /*!< 0x02000000 */
#define GPIO_BSRR_BR9                        GPIO_BSRR_BR9_Msk                  /*!< Port x Reset bit 9 */
#define GPIO_BSRR_BR10_Pos                   (26U)                             
#define GPIO_BSRR_BR10_Msk                   (0x1UL << GPIO_BSRR_BR10_Pos)      /*!< 0x04000000 */
#define GPIO_BSRR_BR10                       GPIO_BSRR_BR10_Msk                 /*!< Port x Reset bit 10 */
#define GPIO_BSRR_BR11_Pos                   (27U)                             
#define GPIO_BSRR_BR11_Msk                   (0x1UL << GPIO_BSRR_BR11_Pos)      /*!< 0x08000000 */
#define GPIO_BSRR_BR11                       GPIO_BSRR_BR11_Msk                 /*!< Port x Reset bit 11 */
#define GPIO_BSRR_BR12_Pos                   (28U)                             
#define GPIO_BSRR_BR12_Msk                   (0x1UL << GPIO_BSRR_BR12_Pos)      /*!< 0x10000000 */
#define GPIO_BSRR_BR12                       GPIO_BSRR_BR12_Msk                 /*!< Port x Reset bit 12 */
#define GPIO_BSRR_BR13_Pos                   (29U)                             
#define GPIO_BSRR_BR13_Msk                   (0x1UL << GPIO_BSRR_BR13_Pos)      /*!< 0x20000000 */
#define GPIO_BSRR_BR13                       GPIO_BSRR_BR13_Msk                 /*!< Port x Reset bit 13 */
#define GPIO_BSRR_BR14_Pos                   (30U)                             
#define GPIO_BSRR_BR14_Msk                   (0x1UL << GPIO_BSRR_BR14_Pos)      /*!< 0x40000000 */
#define GPIO_BSRR_BR14                       GPIO_BSRR_BR14_Msk                 /*!< Port x Reset bit 14 */
#define GPIO_BSRR_BR15_Pos                   (31U)                             
#define GPIO_BSRR_BR15_Msk                   (0x1UL << GPIO_BSRR_BR15_Pos)      /*!< 0x80000000 */
#define GPIO_BSRR_BR15                       GPIO_BSRR_BR15_Msk                 /*!< Port x Reset bit 15 */

/*******************  Bit definition for GPIO_BRR register  *******************/
#define GPIO_BRR_BR0_Pos                     (0U)                              
#define GPIO_BRR_BR0_Msk                     (0x1UL << GPIO_BRR_BR0_Pos)        /*!< 0x00000001 */
#define GPIO_BRR_BR0                         GPIO_BRR_BR0_Msk                   /*!< Port x Reset bit 0 */
#define GPIO_BRR_BR1_Pos                     (1U)                              
#define GPIO_BRR_BR1_Msk                     (0x1UL << GPIO_BRR_BR1_Pos)        /*!< 0x00000002 */
#define GPIO_BRR_BR1                         GPIO_BRR_BR1_Msk                   /*!< Port x Reset bit 1 */
#define GPIO_BRR_BR2_Pos                     (2U)                              
#define GPIO_BRR_BR2_Msk                     (0x1UL << GPIO_BRR_BR2_Pos)        /*!< 0x00000004 */
#define GPIO_BRR_BR2                         GPIO_BRR_BR2_Msk                   /*!< Port x Reset bit 2 */
#define GPIO_BRR_BR3_Pos                     (3U)                              
#define GPIO_BRR_BR3_Msk                     (0x1UL << GPIO_BRR_BR3_Pos)        /*!< 0x00000008 */
#define GPIO_BRR_BR3                         GPIO_BRR_BR3_Msk                   /*!< Port x Reset bit 3 */
#define GPIO_BRR_BR4_Pos                     (4U)                              
#define GPIO_BRR_BR4_Msk                     (0x1UL << GPIO_BRR_BR4_Pos)        /*!< 0x00000010 */
#define GPIO_BRR_BR4                         GPIO_BRR_BR4_Msk                   /*!< Port x Reset bit 4 */
#define GPIO_BRR_BR5_Pos                     (5U)                              
#define GPIO_BRR_BR5_Msk                     (0x1UL << GPIO_BRR_BR5_Pos)        /*!< 0x00000020 */
#define GPIO_BRR_BR5                         GPIO_BRR_BR5_Msk                   /*!< Port x Reset bit 5 */
#define GPIO_BRR_BR6_Pos                     (6U)                              
#define GPIO_BRR_BR6_Msk                     (0x1UL << GPIO_BRR_BR6_Pos)        /*!< 0x00000040 */
#define GPIO_BRR_BR6                         GPIO_BRR_BR6_Msk                   /*!< Port x Reset bit 6 */
#define GPIO_BRR_BR7_Pos                     (7U)                              
#define GPIO_BRR_BR7_Msk                     (0x1UL << GPIO_BRR_BR7_Pos)        /*!< 0x00000080 */
#define GPIO_BRR_BR7                         GPIO_BRR_BR7_Msk                   /*!< Port x Reset bit 7 */
#define GPIO_BRR_BR8_Pos                     (8U)                              
#define GPIO_BRR_BR8_Msk                     (0x1UL << GPIO_BRR_BR8_Pos)        /*!< 0x00000100 */
#define GPIO_BRR_BR8                         GPIO_BRR_BR8_Msk                   /*!< Port x Reset bit 8 */
#define GPIO_BRR_BR9_Pos                     (9U)                              
#define GPIO_BRR_BR9_Msk                     (0x1UL << GPIO_BRR_BR9_Pos)        /*!< 0x00000200 */
#define GPIO_BRR_BR9                         GPIO_BRR_BR9_Msk                   /*!< Port x Reset bit 9 */
#define GPIO_BRR_BR10_Pos                    (10U)                             
#define GPIO_BRR_BR10_Msk                    (0x1UL << GPIO_BRR_BR10_Pos)       /*!< 0x00000400 */
#define GPIO_BRR_BR10                        GPIO_BRR_BR10_Msk                  /*!< Port x Reset bit 10 */
#define GPIO_BRR_BR11_Pos                    (11U)                             
#define GPIO_BRR_BR11_Msk                    (0x1UL << GPIO_BRR_BR11_Pos)       /*!< 0x00000800 */
#define GPIO_BRR_BR11                        GPIO_BRR_BR11_Msk                  /*!< Port x Reset bit 11 */
#define GPIO_BRR_BR12_Pos                    (12U)                             
#define GPIO_BRR_BR12_Msk                    (0x1UL << GPIO_BRR_BR12_Pos)       /*!< 0x00001000 */
#define GPIO_BRR_BR12                        GPIO_BRR_BR12_Msk                  /*!< Port x Reset bit 12 */
#define GPIO_BRR_BR13_Pos                    (13U)                             
#define GPIO_BRR_BR13_Msk                    (0x1UL << GPIO_BRR_BR13_Pos)       /*!< 0x00002000 */
#define GPIO_BRR_BR13                        GPIO_BRR_BR13_Msk                  /*!< Port x Reset bit 13 */
#define GPIO_BRR_BR14_Pos                    (14U)                             
#define GPIO_BRR_BR14_Msk                    (0x1UL << GPIO_BRR_BR14_Pos)       /*!< 0x00004000 */
#define GPIO_BRR_BR14                        GPIO_BRR_BR14_Msk                  /*!< Port x Reset bit 14 */
#define GPIO_BRR_BR15_Pos                    (15U)                             
#define GPIO_BRR_BR15_Msk                    (0x1UL << GPIO_BRR_BR15_Pos)       /*!< 0x00008000 */
#define GPIO_BRR_BR15                        GPIO_BRR_BR15_Msk                  /*!< Port x Reset bit 15 */

/******************  Bit definition for GPIO_LCKR register  *******************/
#define GPIO_LCKR_LCK0_Pos                   (0U)                              
#define GPIO_LCKR_LCK0_Msk                   (0x1UL << GPIO_LCKR_LCK0_Pos)      /*!< 0x00000001 */
#define GPIO_LCKR_LCK0                       GPIO_LCKR_LCK0_Msk                 /*!< Port x Lock bit 0 */
#define GPIO_LCKR_LCK1_Pos                   (1U)                              
#define GPIO_LCKR_LCK1_Msk                   (0x1UL << GPIO_LCKR_LCK1_Pos)      /*!< 0x00000002 */
#define GPIO_LCKR_LCK1                       GPIO_LCKR_LCK1_Msk                 /*!< Port x Lock bit 1 */
#define GPIO_LCKR_LCK2_Pos                   (2U)                              
#define GPIO_LCKR_LCK2_Msk                   (0x1UL << GPIO_LCKR_LCK2_Pos)      /*!< 0x00000004 */
#define GPIO_LCKR_LCK2                       GPIO_LCKR_LCK2_Msk                 /*!< Port x Lock bit 2 */
#define GPIO_LCKR_LCK3_Pos                   (3U)                              
#define GPIO_LCKR_LCK3_Msk                   (0x1UL << GPIO_LCKR_LCK3_Pos)      /*!< 0x00000008 */
#define GPIO_LCKR_LCK3                       GPIO_LCKR_LCK3_Msk                 /*!< Port x Lock bit 3 */
#define GPIO_LCKR_LCK4_Pos                   (4U)                              
#define GPIO_LCKR_LCK4_Msk                   (0x1UL << GPIO_LCKR_LCK4_Pos)      /*!< 0x00000010 */
#define GPIO_LCKR_LCK4                       GPIO_LCKR_LCK4_Msk                 /*!< Port x Lock bit 4 */
#define GPIO_LCKR_LCK5_Pos                   (5U)                              
#define GPIO_LCKR_LCK5_Msk                   (0x1UL << GPIO_LCKR_LCK5_Pos)      /*!< 0x00000020 */
#define GPIO_LCKR_LCK5                       GPIO_LCKR_LCK5_Msk                 /*!< Port x Lock bit 5 */
#define GPIO_LCKR_LCK6_Pos                   (6U)                              
#define GPIO_LCKR_LCK6_Msk                   (0x1UL << GPIO_LCKR_LCK6_Pos)      /*!< 0x00000040 */
#define GPIO_LCKR_LCK6                       GPIO_LCKR_LCK6_Msk                 /*!< Port x Lock bit 6 */
#define GPIO_LCKR_LCK7_Pos                   (7U)                              
#define GPIO_LCKR_LCK7_Msk                   (0x1UL << GPIO_LCKR_LCK7_Pos)      /*!< 0x00000080 */
#define GPIO_LCKR_LCK7                       GPIO_LCKR_LCK7_Msk                 /*!< Port x Lock bit 7 */
#define GPIO_LCKR_LCK8_Pos                   (8U)                              
#define GPIO_LCKR_LCK8_Msk                   (0x1UL << GPIO_LCKR_LCK8_Pos)      /*!< 0x00000100 */
#define GPIO_LCKR_LCK8                       GPIO_LCKR_LCK8_Msk                 /*!< Port x Lock bit 8 */
#define GPIO_LCKR_LCK9_Pos                   (9U)                              
#define GPIO_LCKR_LCK9_Msk                   (0x1UL << GPIO_LCKR_LCK9_Pos)      /*!< 0x00000200 */
#define GPIO_LCKR_LCK9                       GPIO_LCKR_LCK9_Msk                 /*!< Port x Lock bit 9 */
#define GPIO_LCKR_LCK10_Pos                  (10U)                             
#define GPIO_LCKR_LCK10_Msk                  (0x1UL << GPIO_LCKR_LCK10_Pos)     /*!< 0x00000400 */
#define GPIO_LCKR_LCK10                      GPIO_LCKR_LCK10_Msk                /*!< Port x Lock bit 10 */
#define GPIO_LCKR_LCK11_Pos                  (11U)                             
#define GPIO_LCKR_LCK11_Msk                  (0x1UL << GPIO_LCKR_LCK11_Pos)     /*!< 0x00000800 */
#define GPIO_LCKR_LCK11                      GPIO_LCKR_LCK11_Msk                /*!< Port x Lock bit 11 */
#define GPIO_LCKR_LCK12_Pos                  (12U)                             
#define GPIO_LCKR_LCK12_Msk                  (0x1UL << GPIO_LCKR_LCK12_Pos)     /*!< 0x00001000 */
#define GPIO_LCKR_LCK12                      GPIO_LCKR_LCK12_Msk                /*!< Port x Lock bit 12 */
#define GPIO_LCKR_LCK13_Pos                  (13U)                             
#define GPIO_LCKR_LCK13_Msk                  (0x1UL << GPIO_LCKR_LCK13_Pos)     /*!< 0x00002000 */
#define GPIO_LCKR_LCK13                      GPIO_LCKR_LCK13_Msk                /*!< Port x Lock bit 13 */
#define GPIO_LCKR_LCK14_Pos                  (14U)                             
#define GPIO_LCKR_LCK14_Msk                  (0x1UL << GPIO_LCKR_LCK14_Pos)     /*!< 0x00004000 */
#define GPIO_LCKR_LCK14                      GPIO_LCKR_LCK14_Msk                /*!< Port x Lock bit 14 */
#define GPIO_LCKR_LCK15_Pos                  (15U)                             
#define GPIO_LCKR_LCK15_Msk                  (0x1UL << GPIO_LCKR_LCK15_Pos)     /*!< 0x00008000 */
#define GPIO_LCKR_LCK15                      GPIO_LCKR_LCK15_Msk                /*!< Port x Lock bit 15 */
#define GPIO_LCKR_LCKK_Pos                   (16U)                             
#define GPIO_LCKR_LCKK_Msk                   (0x1UL << GPIO_LCKR_LCKK_Pos)      /*!< 0x00010000 */
#define GPIO_LCKR_LCKK                       GPIO_LCKR_LCKK_Msk                 /*!< Lock key */

/******************  Bit definition for AFIO_EVCR register  *******************/
#define AFIO_EVCR_PIN_Pos                    (0U)                              
#define AFIO_EVCR_PIN_Msk                    (0xFUL << AFIO_EVCR_PIN_Pos)       /*!< 0x0000000F */
#define AFIO_EVCR_PIN                        AFIO_EVCR_PIN_Msk                  /*!< PIN[3:0] bits (Pin selection) */
#define AFIO_EVCR_PIN_0                      (0x1UL << AFIO_EVCR_PIN_Pos)       /*!< 0x00000001 */
#define AFIO_EVCR_PIN_1                      (0x2UL << AFIO_EVCR_PIN_Pos)       /*!< 0x00000002 */
#define AFIO_EVCR_PIN_2                      (0x4UL << AFIO_EVCR_PIN_Pos)       /*!< 0x00000004 */
#define AFIO_EVCR_PIN_3                      (0x8UL << AFIO_EVCR_PIN_Pos)       /*!< 0x00000008 */

/*!< PIN configuration */
#define AFIO_EVCR_PIN_PX0                    0x00000000U                        /*!< Pin 0 selected */
#define AFIO_EVCR_PIN_PX1_Pos                (0U)                              
#define AFIO_EVCR_PIN_PX1_Msk                (0x1UL << AFIO_EVCR_PIN_PX1_Pos)   /*!< 0x00000001 */
#define AFIO_EVCR_PIN_PX1                    AFIO_EVCR_PIN_PX1_Msk              /*!< Pin 1 selected */
#define AFIO_EVCR_PIN_PX2_Pos                (1U)                              
#define AFIO_EVCR_PIN_PX2_Msk                (0x1UL << AFIO_EVCR_PIN_PX2_Pos)   /*!< 0x00000002 */
#define AFIO_EVCR_PIN_PX2                    AFIO_EVCR_PIN_PX2_Msk              /*!< Pin 2 selected */
#define AFIO_EVCR_PIN_PX3_Pos                (0U)                              
#define AFIO_EVCR_PIN_PX3_Msk                (0x3UL << AFIO_EVCR_PIN_PX3_Pos)   /*!< 0x00000003 */
#define AFIO_EVCR_PIN_PX3                    AFIO_EVCR_PIN_PX3_Msk              /*!< Pin 3 selected */
#define AFIO_EVCR_PIN_PX4_Pos                (2U)                              
#define AFIO_EVCR_PIN_PX4_Msk                (0x1UL << AFIO_EVCR_PIN_PX4_Pos)   /*!< 0x00000004 */
#define AFIO_EVCR_PIN_PX4                    AFIO_EVCR_PIN_PX4_Msk              /*!< Pin 4 selected */
#define AFIO_EVCR_PIN_PX5_Pos                (0U)                              
#define AFIO_EVCR_PIN_PX5_Msk                (0x5UL << AFIO_EVCR_PIN_PX5_Pos)   /*!< 0x00000005 */
#define AFIO_EVCR_PIN_PX5                    AFIO_EVCR_PIN_PX5_Msk              /*!< Pin 5 selected */
#define AFIO_EVCR_PIN_PX6_Pos                (1U)                              
#define AFIO_EVCR_PIN_PX6_Msk                (0x3UL << AFIO_EVCR_PIN_PX6_Pos)   /*!< 0x00000006 */
#define AFIO_EVCR_PIN_PX6                    AFIO_EVCR_PIN_PX6_Msk              /*!< Pin 6 selected */
#define AFIO_EVCR_PIN_PX7_Pos                (0U)                              
#define AFIO_EVCR_PIN_PX7_Msk                (0x7UL << AFIO_EVCR_PIN_PX7_Pos)   /*!< 0x00000007 */
#define AFIO_EVCR_PIN_PX7                    AFIO_EVCR_PIN_PX7_Msk              /*!< Pin 7 selected */
#define AFIO_EVCR_PIN_PX8_Pos                (3U)                              
#define AFIO_EVCR_PIN_PX8_Msk                (0x1UL << AFIO_EVCR_PIN_PX8_Pos)   /*!< 0x00000008 */
#define AFIO_EVCR_PIN_PX8                    AFIO_EVCR_PIN_PX8_Msk              /*!< Pin 8 selected */
#define AFIO_EVCR_PIN_PX9_Pos                (0U)                              
#define AFIO_EVCR_PIN_PX9_Msk                (0x9UL << AFIO_EVCR_PIN_PX9_Pos)   /*!< 0x00000009 */
#define AFIO_EVCR_PIN_PX9                    AFIO_EVCR_PIN_PX9_Msk              /*!< Pin 9 selected */
#define AFIO_EVCR_PIN_PX10_Pos               (1U)                              
#define AFIO_EVCR_PIN_PX10_Msk               (0x5UL << AFIO_EVCR_PIN_PX10_Pos)  /*!< 0x0000000A */
#define AFIO_EVCR_PIN_PX10                   AFIO_EVCR_PIN_PX10_Msk             /*!< Pin 10 selected */
#define AFIO_EVCR_PIN_PX11_Pos               (0U)                              
#define AFIO_EVCR_PIN_PX11_Msk               (0xBUL << AFIO_EVCR_PIN_PX11_Pos)  /*!< 0x0000000B */
#define AFIO_EVCR_PIN_PX11                   AFIO_EVCR_PIN_PX11_Msk             /*!< Pin 11 selected */
#define AFIO_EVCR_PIN_PX12_Pos               (2U)                              
#define AFIO_EVCR_PIN_PX12_Msk               (0x3UL << AFIO_EVCR_PIN_PX12_Pos)  /*!< 0x0000000C */
#define AFIO_EVCR_PIN_PX12                   AFIO_EVCR_PIN_PX12_Msk             /*!< Pin 12 selected */
#define AFIO_EVCR_PIN_PX13_Pos               (0U)                              
#define AFIO_EVCR_PIN_PX13_Msk               (0xDUL << AFIO_EVCR_PIN_PX13_Pos)  /*!< 0x0000000D */
#define AFIO_EVCR_PIN_PX13                   AFIO_EVCR_PIN_PX13_Msk             /*!< Pin 13 selected */
#define AFIO_EVCR_PIN_PX14_Pos               (1U)                              
#define AFIO_EVCR_PIN_PX14_Msk               (0x7UL << AFIO_EVCR_PIN_PX14_Pos)  /*!< 0x0000000E */
#define AFIO_EVCR_PIN_PX14                   AFIO_EVCR_PIN_PX14_Msk             /*!< Pin 14 selected */
#define AFIO_EVCR_PIN_PX15_Pos               (0U)                              
#define AFIO_EVCR_PIN_PX15_Msk               (0xFUL << AFIO_EVCR_PIN_PX15_Pos)  /*!< 0x0000000F */
#define AFIO_EVCR_PIN_PX15                   AFIO_EVCR_PIN_PX15_Msk             /*!< Pin 15 selected */

#define AFIO_EVCR_PORT_Pos                   (4U)                              
#define AFIO_EVCR_PORT_Msk                   (0x7UL << AFIO_EVCR_PORT_Pos)      /*!< 0x00000070 */
#define AFIO_EVCR_PORT                       AFIO_EVCR_PORT_Msk                 /*!< PORT[2:0] bits (Port selection) */
#define AFIO_EVCR_PORT_0                     (0x1UL << AFIO_EVCR_PORT_Pos)      /*!< 0x00000010 */
#define AFIO_EVCR_PORT_1                     (0x2UL << AFIO_EVCR_PORT_Pos)      /*!< 0x00000020 */
#define AFIO_EVCR_PORT_2                     (0x4UL << AFIO_EVCR_PORT_Pos)      /*!< 0x00000040 */

/*!< PORT configuration */
#define AFIO_EVCR_PORT_PA                    0x00000000                         /*!< Port A selected */
#define AFIO_EVCR_PORT_PB_Pos                (4U)                              
#define AFIO_EVCR_PORT_PB_Msk                (0x1UL << AFIO_EVCR_PORT_PB_Pos)   /*!< 0x00000010 */
#define AFIO_EVCR_PORT_PB                    AFIO_EVCR_PORT_PB_Msk              /*!< Port B selected */
#define AFIO_EVCR_PORT_PC_Pos                (5U)                              
#define AFIO_EVCR_PORT_PC_Msk                (0x1UL << AFIO_EVCR_PORT_PC_Pos)   /*!< 0x00000020 */
#define AFIO_EVCR_PORT_PC                    AFIO_EVCR_PORT_PC_Msk              /*!< Port C selected */
#define AFIO_EVCR_PORT_PD_Pos                (4U)                              
#define AFIO_EVCR_PORT_PD_Msk                (0x3UL << AFIO_EVCR_PORT_PD_Pos)   /*!< 0x00000030 */
#define AFIO_EVCR_PORT_PD                    AFIO_EVCR_PORT_PD_Msk              /*!< Port D selected */
#define AFIO_EVCR_PORT_PE_Pos                (6U)                              
#define AFIO_EVCR_PORT_PE_Msk                (0x1UL << AFIO_EVCR_PORT_PE_Pos)   /*!< 0x00000040 */
#define AFIO_EVCR_PORT_PE                    AFIO_EVCR_PORT_PE_Msk              /*!< Port E selected */

#define AFIO_EVCR_EVOE_Pos                   (7U)                              
#define AFIO_EVCR_EVOE_Msk                   (0x1UL << AFIO_EVCR_EVOE_Pos)      /*!< 0x00000080 */
#define AFIO_EVCR_EVOE                       AFIO_EVCR_EVOE_Msk                 /*!< Event Output Enable */

/******************  Bit definition for AFIO_MAPR register  *******************/
#define AFIO_MAPR_SPI1_REMAP_Pos             (0U)                              
#define AFIO_MAPR_SPI1_REMAP_Msk             (0x1UL << AFIO_MAPR_SPI1_REMAP_Pos) /*!< 0x00000001 */
#define AFIO_MAPR_SPI1_REMAP                 AFIO_MAPR_SPI1_REMAP_Msk            /*!< SPI1 remapping */
#define AFIO_MAPR_I2C1_REMAP_Pos             (1U)                              
#define AFIO_MAPR_I2C1_REMAP_Msk             (0x1UL << AFIO_MAPR_I2C1_REMAP_Pos) /*!< 0x00000002 */
#define AFIO_MAPR_I2C1_REMAP                 AFIO_MAPR_I2C1_REMAP_Msk            /*!< I2C1 remapping */
#define AFIO_MAPR_USART1_REMAP_Pos           (2U)                              
#define AFIO_MAPR_USART1_REMAP_Msk           (0x1UL << AFIO_MAPR_USART1_REMAP_Pos) /*!< 0x00000004 */
#define AFIO_MAPR_USART1_REMAP               AFIO_MAPR_USART1_REMAP_Msk            /*!< USART1 remapping */
#define AFIO_MAPR_USART2_REMAP_Pos           (3U)                              
#define AFIO_MAPR_USART2_REMAP_Msk           (0x1UL << AFIO_MAPR_USART2_REMAP_Pos) /*!< 0x00000008 */
#define AFIO_MAPR_USART2_REMAP               AFIO_MAPR_USART2_REMAP_Msk            /*!< USART2 remapping */

#define AFIO_MAPR_USART3_REMAP_Pos           (4U)                              
#define AFIO_MAPR_USART3_REMAP_Msk           (0x3UL << AFIO_MAPR_USART3_REMAP_Pos) /*!< 0x00000030 */
#define AFIO_MAPR_USART3_REMAP               AFIO_MAPR_USART3_REMAP_Msk            /*!< USART3_REMAP[1:0] bits (USART3 remapping) */
#define AFIO_MAPR_USART3_REMAP_0             (0x1UL << AFIO_MAPR_USART3_REMAP_Pos) /*!< 0x00000010 */
#define AFIO_MAPR_USART3_REMAP_1             (0x2UL << AFIO_MAPR_USART3_REMAP_Pos) /*!< 0x00000020 */

/* USART3_REMAP configuration */
#define AFIO_MAPR_USART3_REMAP_NOREMAP       0x00000000U                                           /*!< No remap (TX/PB10, RX/PB11, CK/PB12, CTS/PB13, RTS/PB14) */
#define AFIO_MAPR_USART3_REMAP_PARTIALREMAP_Pos (4U)                           
#define AFIO_MAPR_USART3_REMAP_PARTIALREMAP_Msk (0x1UL << AFIO_MAPR_USART3_REMAP_PARTIALREMAP_Pos) /*!< 0x00000010 */
#define AFIO_MAPR_USART3_REMAP_PARTIALREMAP  AFIO_MAPR_USART3_REMAP_PARTIALREMAP_Msk               /*!< Partial remap (TX/PC10, RX/PC11, CK/PC12, CTS/PB13, RTS/PB14) */
#define AFIO_MAPR_USART3_REMAP_FULLREMAP_Pos (4U)                              
#define AFIO_MAPR_USART3_REMAP_FULLREMAP_Msk (0x3UL << AFIO_MAPR_USART3_REMAP_FULLREMAP_Pos)       /*!< 0x00000030 */
#define AFIO_MAPR_USART3_REMAP_FULLREMAP     AFIO_MAPR_USART3_REMAP_FULLREMAP_Msk                  /*!< Full remap (TX/PD8, RX/PD9, CK/PD10, CTS/PD11, RTS/PD12) */

#define AFIO_MAPR_TIM1_REMAP_Pos             (6U)                              
#define AFIO_MAPR_TIM1_REMAP_Msk             (0x3UL << AFIO_MAPR_TIM1_REMAP_Pos)                   /*!< 0x000000C0 */
#define AFIO_MAPR_TIM1_REMAP                 AFIO_MAPR_TIM1_REMAP_Msk                              /*!< TIM1_REMAP[1:0] bits (TIM1 remapping) */
#define AFIO_MAPR_TIM1_REMAP_0               (0x1UL << AFIO_MAPR_TIM1_REMAP_Pos)                   /*!< 0x00000040 */
#define AFIO_MAPR_TIM1_REMAP_1               (0x2UL << AFIO_MAPR_TIM1_REMAP_Pos)                   /*!< 0x00000080 */

/*!< TIM1_REMAP configuration */
#define AFIO_MAPR_TIM1_REMAP_NOREMAP         0x00000000U                                           /*!< No remap (ETR/PA12, CH1/PA8, CH2/PA9, CH3/PA10, CH4/PA11, BKIN/PB12, CH1N/PB13, CH2N/PB14, CH3N/PB15) */
#define AFIO_MAPR_TIM1_REMAP_PARTIALREMAP_Pos (6U)                             
#define AFIO_MAPR_TIM1_REMAP_PARTIALREMAP_Msk (0x1UL << AFIO_MAPR_TIM1_REMAP_PARTIALREMAP_Pos)     /*!< 0x00000040 */
#define AFIO_MAPR_TIM1_REMAP_PARTIALREMAP    AFIO_MAPR_TIM1_REMAP_PARTIALREMAP_Msk                 /*!< Partial remap (ETR/PA12, CH1/PA8, CH2/PA9, CH3/PA10, CH4/PA11, BKIN/PA6, CH1N/PA7, CH2N/PB0, CH3N/PB1) */
#define AFIO_MAPR_TIM1_REMAP_FULLREMAP_Pos   (6U)                              
#define AFIO_MAPR_TIM1_REMAP_FULLREMAP_Msk   (0x3UL << AFIO_MAPR_TIM1_REMAP_FULLREMAP_Pos)         /*!< 0x000000C0 */
#define AFIO_MAPR_TIM1_REMAP_FULLREMAP       AFIO_MAPR_TIM1_REMAP_FULLREMAP_Msk                    /*!< Full remap (ETR/PE7, CH1/PE9, CH2/PE11, CH3/PE13, CH4/PE14, BKIN/PE15, CH1N/PE8, CH2N/PE10, CH3N/PE12) */

#define AFIO_MAPR_TIM2_REMAP_Pos             (8U)                              
#define AFIO_MAPR_TIM2_REMAP_Msk             (0x3UL << AFIO_MAPR_TIM2_REMAP_Pos)                   /*!< 0x00000300 */
#define AFIO_MAPR_TIM2_REMAP                 AFIO_MAPR_TIM2_REMAP_Msk                              /*!< TIM2_REMAP[1:0] bits (TIM2 remapping) */
#define AFIO_MAPR_TIM2_REMAP_0               (0x1UL << AFIO_MAPR_TIM2_REMAP_Pos)                   /*!< 0x00000100 */
#define AFIO_MAPR_TIM2_REMAP_1               (0x2UL << AFIO_MAPR_TIM2_REMAP_Pos)                   /*!< 0x00000200 */

/*!< TIM2_REMAP configuration */
#define AFIO_MAPR_TIM2_REMAP_NOREMAP         0x00000000U                                           /*!< No remap (CH1/ETR/PA0, CH2/PA1, CH3/PA2, CH4/PA3) */
#define AFIO_MAPR_TIM2_REMAP_PARTIALREMAP1_Pos (8U)                            
#define AFIO_MAPR_TIM2_REMAP_PARTIALREMAP1_Msk (0x1UL << AFIO_MAPR_TIM2_REMAP_PARTIALREMAP1_Pos)   /*!< 0x00000100 */
#define AFIO_MAPR_TIM2_REMAP_PARTIALREMAP1   AFIO_MAPR_TIM2_REMAP_PARTIALREMAP1_Msk                /*!< Partial remap (CH1/ETR/PA15, CH2/PB3, CH3/PA2, CH4/PA3) */
#define AFIO_MAPR_TIM2_REMAP_PARTIALREMAP2_Pos (9U)                            
#define AFIO_MAPR_TIM2_REMAP_PARTIALREMAP2_Msk (0x1UL << AFIO_MAPR_TIM2_REMAP_PARTIALREMAP2_Pos)   /*!< 0x00000200 */
#define AFIO_MAPR_TIM2_REMAP_PARTIALREMAP2   AFIO_MAPR_TIM2_REMAP_PARTIALREMAP2_Msk                /*!< Partial remap (CH1/ETR/PA0, CH2/PA1, CH3/PB10, CH4/PB11) */
#define AFIO_MAPR_TIM2_REMAP_FULLREMAP_Pos   (8U)                              
#define AFIO_MAPR_TIM2_REMAP_FULLREMAP_Msk   (0x3UL << AFIO_MAPR_TIM2_REMAP_FULLREMAP_Pos)         /*!< 0x00000300 */
#define AFIO_MAPR_TIM2_REMAP_FULLREMAP       AFIO_MAPR_TIM2_REMAP_FULLREMAP_Msk                    /*!< Full remap (CH1/ETR/PA15, CH2/PB3, CH3/PB10, CH4/PB11) */

#define AFIO_MAPR_TIM3_REMAP_Pos             (10U)                             
#define AFIO_MAPR_TIM3_REMAP_Msk             (0x3UL << AFIO_MAPR_TIM3_REMAP_Pos)                   /*!< 0x00000C00 */
#define AFIO_MAPR_TIM3_REMAP                 AFIO_MAPR_TIM3_REMAP_Msk                              /*!< TIM3_REMAP[1:0] bits (TIM3 remapping) */
#define AFIO_MAPR_TIM3_REMAP_0               (0x1UL << AFIO_MAPR_TIM3_REMAP_Pos)                   /*!< 0x00000400 */
#define AFIO_MAPR_TIM3_REMAP_1               (0x2UL << AFIO_MAPR_TIM3_REMAP_Pos)                   /*!< 0x00000800 */

/*!< TIM3_REMAP configuration */
#define AFIO_MAPR_TIM3_REMAP_NOREMAP         0x00000000U                                           /*!< No remap (CH1/PA6, CH2/PA7, CH3/PB0, CH4/PB1) */
#define AFIO_MAPR_TIM3_REMAP_PARTIALREMAP_Pos (11U)                            
#define AFIO_MAPR_TIM3_REMAP_PARTIALREMAP_Msk (0x1UL << AFIO_MAPR_TIM3_REMAP_PARTIALREMAP_Pos)     /*!< 0x00000800 */
#define AFIO_MAPR_TIM3_REMAP_PARTIALREMAP    AFIO_MAPR_TIM3_REMAP_PARTIALREMAP_Msk                 /*!< Partial remap (CH1/PB4, CH2/PB5, CH3/PB0, CH4/PB1) */
#define AFIO_MAPR_TIM3_REMAP_FULLREMAP_Pos   (10U)                             
#define AFIO_MAPR_TIM3_REMAP_FULLREMAP_Msk   (0x3UL << AFIO_MAPR_TIM3_REMAP_FULLREMAP_Pos)         /*!< 0x00000C00 */
#define AFIO_MAPR_TIM3_REMAP_FULLREMAP       AFIO_MAPR_TIM3_REMAP_FULLREMAP_Msk                    /*!< Full remap (CH1/PC6, CH2/PC7, CH3/PC8, CH4/PC9) */

#define AFIO_MAPR_TIM4_REMAP_Pos             (12U)
#define AFIO_MAPR_TIM4_REMAP_Msk                (0x1UL << AFIO_MAPR_TIM4_REMAP_Pos)                /*!< 0x00001000 */
#define AFIO_MAPR_TIM4_REMAP                    AFIO_MAPR_TIM4_REMAP_Msk                           /*!< TIM4_REMAP bit (TIM4 remapping) */

#define AFIO_MAPR_CAN_REMAP_Pos              (13U)                             
#define AFIO_MAPR_CAN_REMAP_Msk              (0x3UL << AFIO_MAPR_CAN_REMAP_Pos)                    /*!< 0x00006000 */
#define AFIO_MAPR_CAN_REMAP                  AFIO_MAPR_CAN_REMAP_Msk                               /*!< CAN_REMAP[1:0] bits (CAN Alternate function remapping) */
#define AFIO_MAPR_CAN_REMAP_0                (0x1UL << AFIO_MAPR_CAN_REMAP_Pos)                    /*!< 0x00002000 */
#define AFIO_MAPR_CAN_REMAP_1                (0x2UL << AFIO_MAPR_CAN_REMAP_Pos)                    /*!< 0x00004000 */

/*!< CAN_REMAP configuration */
#define AFIO_MAPR_CAN_REMAP_REMAP1           0x00000000U                                 /*!< CANRX mapped to PA11, CANTX mapped to PA12 */
#define AFIO_MAPR_CAN_REMAP_REMAP2_Pos       (14U)                             
#define AFIO_MAPR_CAN_REMAP_REMAP2_Msk       (0x1UL << AFIO_MAPR_CAN_REMAP_REMAP2_Pos)   /*!< 0x00004000 */
#define AFIO_MAPR_CAN_REMAP_REMAP2           AFIO_MAPR_CAN_REMAP_REMAP2_Msk              /*!< CANRX mapped to PB8, CANTX mapped to PB9 */
#define AFIO_MAPR_CAN_REMAP_REMAP3_Pos       (13U)                             
#define AFIO_MAPR_CAN_REMAP_REMAP3_Msk       (0x3UL << AFIO_MAPR_CAN_REMAP_REMAP3_Pos)   /*!< 0x00006000 */
#define AFIO_MAPR_CAN_REMAP_REMAP3           AFIO_MAPR_CAN_REMAP_REMAP3_Msk              /*!< CANRX mapped to PD0, CANTX mapped to PD1 */

#define AFIO_MAPR_PD01_REMAP_Pos             (15U)                             
#define AFIO_MAPR_PD01_REMAP_Msk             (0x1UL << AFIO_MAPR_PD01_REMAP_Pos)         /*!< 0x00008000 */
#define AFIO_MAPR_PD01_REMAP                 AFIO_MAPR_PD01_REMAP_Msk                    /*!< Port D0/Port D1 mapping on OSC_IN/OSC_OUT */
#define AFIO_MAPR_TIM5CH4_IREMAP_Pos         (16U)                             
#define AFIO_MAPR_TIM5CH4_IREMAP_Msk         (0x1UL << AFIO_MAPR_TIM5CH4_IREMAP_Pos)     /*!< 0x00010000 */
#define AFIO_MAPR_TIM5CH4_IREMAP             AFIO_MAPR_TIM5CH4_IREMAP_Msk                /*!< TIM5 Channel4 Internal Remap */
#define AFIO_MAPR_ADC1_ETRGINJ_REMAP_Pos     (17U)                             
#define AFIO_MAPR_ADC1_ETRGINJ_REMAP_Msk     (0x1UL << AFIO_MAPR_ADC1_ETRGINJ_REMAP_Pos) /*!< 0x00020000 */
#define AFIO_MAPR_ADC1_ETRGINJ_REMAP         AFIO_MAPR_ADC1_ETRGINJ_REMAP_Msk            /*!< ADC 1 External Trigger Injected Conversion remapping */
#define AFIO_MAPR_ADC1_ETRGREG_REMAP_Pos     (18U)                             
#define AFIO_MAPR_ADC1_ETRGREG_REMAP_Msk     (0x1UL << AFIO_MAPR_ADC1_ETRGREG_REMAP_Pos) /*!< 0x00040000 */
#define AFIO_MAPR_ADC1_ETRGREG_REMAP         AFIO_MAPR_ADC1_ETRGREG_REMAP_Msk            /*!< ADC 1 External Trigger Regular Conversion remapping */
#define AFIO_MAPR_ADC2_ETRGINJ_REMAP_Pos     (19U)                             
#define AFIO_MAPR_ADC2_ETRGINJ_REMAP_Msk     (0x1UL << AFIO_MAPR_ADC2_ETRGINJ_REMAP_Pos) /*!< 0x00080000 */
#define AFIO_MAPR_ADC2_ETRGINJ_REMAP         AFIO_MAPR_ADC2_ETRGINJ_REMAP_Msk            /*!< ADC 2 External Trigger Injected Conversion remapping */
#define AFIO_MAPR_ADC2_ETRGREG_REMAP_Pos     (20U)                             
#define AFIO_MAPR_ADC2_ETRGREG_REMAP_Msk     (0x1UL << AFIO_MAPR_ADC2_ETRGREG_REMAP_Pos) /*!< 0x00100000 */
#define AFIO_MAPR_ADC2_ETRGREG_REMAP         AFIO_MAPR_ADC2_ETRGREG_REMAP_Msk            /*!< ADC 2 External Trigger Regular Conversion remapping */
#define AFIO_MAPR_QUADSPI_REMAP_Pos          (21U)
#define AFIO_MAPR_QUADSPI_REMAP_Msk          (0x1U << AFIO_MAPR_QUADSPI_REMAP_Pos)       /*!< 0x00200000 */
#define AFIO_MAPR_QUADSPI_REMAP              AFIO_MAPR_QUADSPI_REMAP_Msk                 /*!< QUADSPI remapping */

/*!< SWJ_CFG configuration */
#define AFIO_MAPR_SWJ_CFG_Pos                (24U)                             
#define AFIO_MAPR_SWJ_CFG_Msk                (0x7UL << AFIO_MAPR_SWJ_CFG_Pos)            /*!< 0x07000000 */
#define AFIO_MAPR_SWJ_CFG                    AFIO_MAPR_SWJ_CFG_Msk                       /*!< SWJ_CFG[2:0] bits (Serial Wire JTAG configuration) */
#define AFIO_MAPR_SWJ_CFG_0                  (0x1UL << AFIO_MAPR_SWJ_CFG_Pos)            /*!< 0x01000000 */
#define AFIO_MAPR_SWJ_CFG_1                  (0x2UL << AFIO_MAPR_SWJ_CFG_Pos)            /*!< 0x02000000 */
#define AFIO_MAPR_SWJ_CFG_2                  (0x4UL << AFIO_MAPR_SWJ_CFG_Pos)            /*!< 0x04000000 */

#define AFIO_MAPR_SWJ_CFG_RESET              0x00000000U                                 /*!< Full SWJ (JTAG-DP + SW-DP) : Reset State */
#define AFIO_MAPR_SWJ_CFG_NOJNTRST_Pos       (24U)                             
#define AFIO_MAPR_SWJ_CFG_NOJNTRST_Msk       (0x1UL << AFIO_MAPR_SWJ_CFG_NOJNTRST_Pos)   /*!< 0x01000000 */
#define AFIO_MAPR_SWJ_CFG_NOJNTRST           AFIO_MAPR_SWJ_CFG_NOJNTRST_Msk              /*!< Full SWJ (JTAG-DP + SW-DP) but without JNTRST */
#define AFIO_MAPR_SWJ_CFG_JTAGDISABLE_Pos    (25U)                             
#define AFIO_MAPR_SWJ_CFG_JTAGDISABLE_Msk    (0x1UL << AFIO_MAPR_SWJ_CFG_JTAGDISABLE_Pos)/*!< 0x02000000 */
#define AFIO_MAPR_SWJ_CFG_JTAGDISABLE        AFIO_MAPR_SWJ_CFG_JTAGDISABLE_Msk           /*!< JTAG-DP Disabled and SW-DP Enabled */
#define AFIO_MAPR_SWJ_CFG_DISABLE_Pos        (26U)                             
#define AFIO_MAPR_SWJ_CFG_DISABLE_Msk        (0x1UL << AFIO_MAPR_SWJ_CFG_DISABLE_Pos)    /*!< 0x04000000 */
#define AFIO_MAPR_SWJ_CFG_DISABLE            AFIO_MAPR_SWJ_CFG_DISABLE_Msk               /*!< JTAG-DP Disabled and SW-DP Disabled */

/*****************  Bit definition for AFIO_EXTICR1 register  *****************/
#define AFIO_EXTICR1_EXTI0_Pos               (0U)                              
#define AFIO_EXTICR1_EXTI0_Msk               (0xFUL << AFIO_EXTICR1_EXTI0_Pos)    /*!< 0x0000000F */
#define AFIO_EXTICR1_EXTI0                   AFIO_EXTICR1_EXTI0_Msk               /*!< EXTI 0 configuration */
#define AFIO_EXTICR1_EXTI1_Pos               (4U)                              
#define AFIO_EXTICR1_EXTI1_Msk               (0xFUL << AFIO_EXTICR1_EXTI1_Pos)    /*!< 0x000000F0 */
#define AFIO_EXTICR1_EXTI1                   AFIO_EXTICR1_EXTI1_Msk               /*!< EXTI 1 configuration */
#define AFIO_EXTICR1_EXTI2_Pos               (8U)                              
#define AFIO_EXTICR1_EXTI2_Msk               (0xFUL << AFIO_EXTICR1_EXTI2_Pos)    /*!< 0x00000F00 */
#define AFIO_EXTICR1_EXTI2                   AFIO_EXTICR1_EXTI2_Msk               /*!< EXTI 2 configuration */
#define AFIO_EXTICR1_EXTI3_Pos               (12U)                             
#define AFIO_EXTICR1_EXTI3_Msk               (0xFUL << AFIO_EXTICR1_EXTI3_Pos)    /*!< 0x0000F000 */
#define AFIO_EXTICR1_EXTI3                   AFIO_EXTICR1_EXTI3_Msk               /*!< EXTI 3 configuration */

/*!< EXTI0 configuration */
#define AFIO_EXTICR1_EXTI0_PA                0x00000000U                          /*!< PA[0] pin */
#define AFIO_EXTICR1_EXTI0_PB_Pos            (0U)                              
#define AFIO_EXTICR1_EXTI0_PB_Msk            (0x1UL << AFIO_EXTICR1_EXTI0_PB_Pos) /*!< 0x00000001 */
#define AFIO_EXTICR1_EXTI0_PB                AFIO_EXTICR1_EXTI0_PB_Msk            /*!< PB[0] pin */
#define AFIO_EXTICR1_EXTI0_PC_Pos            (1U)                              
#define AFIO_EXTICR1_EXTI0_PC_Msk            (0x1UL << AFIO_EXTICR1_EXTI0_PC_Pos) /*!< 0x00000002 */
#define AFIO_EXTICR1_EXTI0_PC                AFIO_EXTICR1_EXTI0_PC_Msk            /*!< PC[0] pin */
#define AFIO_EXTICR1_EXTI0_PD_Pos            (0U)                              
#define AFIO_EXTICR1_EXTI0_PD_Msk            (0x3UL << AFIO_EXTICR1_EXTI0_PD_Pos) /*!< 0x00000003 */
#define AFIO_EXTICR1_EXTI0_PD                AFIO_EXTICR1_EXTI0_PD_Msk            /*!< PD[0] pin */
#define AFIO_EXTICR1_EXTI0_PE_Pos            (2U)                              
#define AFIO_EXTICR1_EXTI0_PE_Msk            (0x1UL << AFIO_EXTICR1_EXTI0_PE_Pos) /*!< 0x00000004 */
#define AFIO_EXTICR1_EXTI0_PE                AFIO_EXTICR1_EXTI0_PE_Msk            /*!< PE[0] pin */
#define AFIO_EXTICR1_EXTI0_PF_Pos            (0U)                              
#define AFIO_EXTICR1_EXTI0_PF_Msk            (0x5UL << AFIO_EXTICR1_EXTI0_PF_Pos) /*!< 0x00000005 */
#define AFIO_EXTICR1_EXTI0_PF                AFIO_EXTICR1_EXTI0_PF_Msk            /*!< PF[0] pin */
#define AFIO_EXTICR1_EXTI0_PG_Pos            (1U)                              
#define AFIO_EXTICR1_EXTI0_PG_Msk            (0x3UL << AFIO_EXTICR1_EXTI0_PG_Pos) /*!< 0x00000006 */
#define AFIO_EXTICR1_EXTI0_PG                AFIO_EXTICR1_EXTI0_PG_Msk            /*!< PG[0] pin */

/*!< EXTI1 configuration */
#define AFIO_EXTICR1_EXTI1_PA                0x00000000U                          /*!< PA[1] pin */
#define AFIO_EXTICR1_EXTI1_PB_Pos            (4U)                              
#define AFIO_EXTICR1_EXTI1_PB_Msk            (0x1UL << AFIO_EXTICR1_EXTI1_PB_Pos) /*!< 0x00000010 */
#define AFIO_EXTICR1_EXTI1_PB                AFIO_EXTICR1_EXTI1_PB_Msk            /*!< PB[1] pin */
#define AFIO_EXTICR1_EXTI1_PC_Pos            (5U)                              
#define AFIO_EXTICR1_EXTI1_PC_Msk            (0x1UL << AFIO_EXTICR1_EXTI1_PC_Pos) /*!< 0x00000020 */
#define AFIO_EXTICR1_EXTI1_PC                AFIO_EXTICR1_EXTI1_PC_Msk            /*!< PC[1] pin */
#define AFIO_EXTICR1_EXTI1_PD_Pos            (4U)                              
#define AFIO_EXTICR1_EXTI1_PD_Msk            (0x3UL << AFIO_EXTICR1_EXTI1_PD_Pos) /*!< 0x00000030 */
#define AFIO_EXTICR1_EXTI1_PD                AFIO_EXTICR1_EXTI1_PD_Msk            /*!< PD[1] pin */
#define AFIO_EXTICR1_EXTI1_PE_Pos            (6U)                              
#define AFIO_EXTICR1_EXTI1_PE_Msk            (0x1UL << AFIO_EXTICR1_EXTI1_PE_Pos) /*!< 0x00000040 */
#define AFIO_EXTICR1_EXTI1_PE                AFIO_EXTICR1_EXTI1_PE_Msk            /*!< PE[1] pin */
#define AFIO_EXTICR1_EXTI1_PF_Pos            (4U)                              
#define AFIO_EXTICR1_EXTI1_PF_Msk            (0x5UL << AFIO_EXTICR1_EXTI1_PF_Pos) /*!< 0x00000050 */
#define AFIO_EXTICR1_EXTI1_PF                AFIO_EXTICR1_EXTI1_PF_Msk            /*!< PF[1] pin */
#define AFIO_EXTICR1_EXTI1_PG_Pos            (5U)                              
#define AFIO_EXTICR1_EXTI1_PG_Msk            (0x3UL << AFIO_EXTICR1_EXTI1_PG_Pos) /*!< 0x00000060 */
#define AFIO_EXTICR1_EXTI1_PG                AFIO_EXTICR1_EXTI1_PG_Msk            /*!< PG[1] pin */

/*!< EXTI2 configuration */  
#define AFIO_EXTICR1_EXTI2_PA                0x00000000U                          /*!< PA[2] pin */
#define AFIO_EXTICR1_EXTI2_PB_Pos            (8U)                              
#define AFIO_EXTICR1_EXTI2_PB_Msk            (0x1UL << AFIO_EXTICR1_EXTI2_PB_Pos) /*!< 0x00000100 */
#define AFIO_EXTICR1_EXTI2_PB                AFIO_EXTICR1_EXTI2_PB_Msk            /*!< PB[2] pin */
#define AFIO_EXTICR1_EXTI2_PC_Pos            (9U)                              
#define AFIO_EXTICR1_EXTI2_PC_Msk            (0x1UL << AFIO_EXTICR1_EXTI2_PC_Pos) /*!< 0x00000200 */
#define AFIO_EXTICR1_EXTI2_PC                AFIO_EXTICR1_EXTI2_PC_Msk            /*!< PC[2] pin */
#define AFIO_EXTICR1_EXTI2_PD_Pos            (8U)                              
#define AFIO_EXTICR1_EXTI2_PD_Msk            (0x3UL << AFIO_EXTICR1_EXTI2_PD_Pos) /*!< 0x00000300 */
#define AFIO_EXTICR1_EXTI2_PD                AFIO_EXTICR1_EXTI2_PD_Msk            /*!< PD[2] pin */
#define AFIO_EXTICR1_EXTI2_PE_Pos            (10U)                             
#define AFIO_EXTICR1_EXTI2_PE_Msk            (0x1UL << AFIO_EXTICR1_EXTI2_PE_Pos) /*!< 0x00000400 */
#define AFIO_EXTICR1_EXTI2_PE                AFIO_EXTICR1_EXTI2_PE_Msk            /*!< PE[2] pin */
#define AFIO_EXTICR1_EXTI2_PF_Pos            (8U)                              
#define AFIO_EXTICR1_EXTI2_PF_Msk            (0x5UL << AFIO_EXTICR1_EXTI2_PF_Pos) /*!< 0x00000500 */
#define AFIO_EXTICR1_EXTI2_PF                AFIO_EXTICR1_EXTI2_PF_Msk            /*!< PF[2] pin */
#define AFIO_EXTICR1_EXTI2_PG_Pos            (9U)                              
#define AFIO_EXTICR1_EXTI2_PG_Msk            (0x3UL << AFIO_EXTICR1_EXTI2_PG_Pos) /*!< 0x00000600 */
#define AFIO_EXTICR1_EXTI2_PG                AFIO_EXTICR1_EXTI2_PG_Msk            /*!< PG[2] pin */

/*!< EXTI3 configuration */
#define AFIO_EXTICR1_EXTI3_PA                0x00000000U                          /*!< PA[3] pin */
#define AFIO_EXTICR1_EXTI3_PB_Pos            (12U)                             
#define AFIO_EXTICR1_EXTI3_PB_Msk            (0x1UL << AFIO_EXTICR1_EXTI3_PB_Pos) /*!< 0x00001000 */
#define AFIO_EXTICR1_EXTI3_PB                AFIO_EXTICR1_EXTI3_PB_Msk            /*!< PB[3] pin */
#define AFIO_EXTICR1_EXTI3_PC_Pos            (13U)                             
#define AFIO_EXTICR1_EXTI3_PC_Msk            (0x1UL << AFIO_EXTICR1_EXTI3_PC_Pos) /*!< 0x00002000 */
#define AFIO_EXTICR1_EXTI3_PC                AFIO_EXTICR1_EXTI3_PC_Msk            /*!< PC[3] pin */
#define AFIO_EXTICR1_EXTI3_PD_Pos            (12U)                             
#define AFIO_EXTICR1_EXTI3_PD_Msk            (0x3UL << AFIO_EXTICR1_EXTI3_PD_Pos) /*!< 0x00003000 */
#define AFIO_EXTICR1_EXTI3_PD                AFIO_EXTICR1_EXTI3_PD_Msk            /*!< PD[3] pin */
#define AFIO_EXTICR1_EXTI3_PE_Pos            (14U)                             
#define AFIO_EXTICR1_EXTI3_PE_Msk            (0x1UL << AFIO_EXTICR1_EXTI3_PE_Pos) /*!< 0x00004000 */
#define AFIO_EXTICR1_EXTI3_PE                AFIO_EXTICR1_EXTI3_PE_Msk            /*!< PE[3] pin */
#define AFIO_EXTICR1_EXTI3_PF_Pos            (12U)                             
#define AFIO_EXTICR1_EXTI3_PF_Msk            (0x5UL << AFIO_EXTICR1_EXTI3_PF_Pos) /*!< 0x00005000 */
#define AFIO_EXTICR1_EXTI3_PF                AFIO_EXTICR1_EXTI3_PF_Msk            /*!< PF[3] pin */
#define AFIO_EXTICR1_EXTI3_PG_Pos            (13U)                             
#define AFIO_EXTICR1_EXTI3_PG_Msk            (0x3UL << AFIO_EXTICR1_EXTI3_PG_Pos) /*!< 0x00006000 */
#define AFIO_EXTICR1_EXTI3_PG                AFIO_EXTICR1_EXTI3_PG_Msk            /*!< PG[3] pin */

/*****************  Bit definition for AFIO_EXTICR2 register  *****************/
#define AFIO_EXTICR2_EXTI4_Pos               (0U)                              
#define AFIO_EXTICR2_EXTI4_Msk               (0xFUL << AFIO_EXTICR2_EXTI4_Pos)    /*!< 0x0000000F */
#define AFIO_EXTICR2_EXTI4                   AFIO_EXTICR2_EXTI4_Msk               /*!< EXTI 4 configuration */
#define AFIO_EXTICR2_EXTI5_Pos               (4U)                              
#define AFIO_EXTICR2_EXTI5_Msk               (0xFUL << AFIO_EXTICR2_EXTI5_Pos)    /*!< 0x000000F0 */
#define AFIO_EXTICR2_EXTI5                   AFIO_EXTICR2_EXTI5_Msk               /*!< EXTI 5 configuration */
#define AFIO_EXTICR2_EXTI6_Pos               (8U)                              
#define AFIO_EXTICR2_EXTI6_Msk               (0xFUL << AFIO_EXTICR2_EXTI6_Pos)    /*!< 0x00000F00 */
#define AFIO_EXTICR2_EXTI6                   AFIO_EXTICR2_EXTI6_Msk               /*!< EXTI 6 configuration */
#define AFIO_EXTICR2_EXTI7_Pos               (12U)                             
#define AFIO_EXTICR2_EXTI7_Msk               (0xFUL << AFIO_EXTICR2_EXTI7_Pos)    /*!< 0x0000F000 */
#define AFIO_EXTICR2_EXTI7                   AFIO_EXTICR2_EXTI7_Msk               /*!< EXTI 7 configuration */

/*!< EXTI4 configuration */
#define AFIO_EXTICR2_EXTI4_PA                0x00000000U                          /*!< PA[4] pin */
#define AFIO_EXTICR2_EXTI4_PB_Pos            (0U)                              
#define AFIO_EXTICR2_EXTI4_PB_Msk            (0x1UL << AFIO_EXTICR2_EXTI4_PB_Pos) /*!< 0x00000001 */
#define AFIO_EXTICR2_EXTI4_PB                AFIO_EXTICR2_EXTI4_PB_Msk            /*!< PB[4] pin */
#define AFIO_EXTICR2_EXTI4_PC_Pos            (1U)                              
#define AFIO_EXTICR2_EXTI4_PC_Msk            (0x1UL << AFIO_EXTICR2_EXTI4_PC_Pos) /*!< 0x00000002 */
#define AFIO_EXTICR2_EXTI4_PC                AFIO_EXTICR2_EXTI4_PC_Msk            /*!< PC[4] pin */
#define AFIO_EXTICR2_EXTI4_PD_Pos            (0U)                              
#define AFIO_EXTICR2_EXTI4_PD_Msk            (0x3UL << AFIO_EXTICR2_EXTI4_PD_Pos) /*!< 0x00000003 */
#define AFIO_EXTICR2_EXTI4_PD                AFIO_EXTICR2_EXTI4_PD_Msk            /*!< PD[4] pin */
#define AFIO_EXTICR2_EXTI4_PE_Pos            (2U)                              
#define AFIO_EXTICR2_EXTI4_PE_Msk            (0x1UL << AFIO_EXTICR2_EXTI4_PE_Pos) /*!< 0x00000004 */
#define AFIO_EXTICR2_EXTI4_PE                AFIO_EXTICR2_EXTI4_PE_Msk            /*!< PE[4] pin */
#define AFIO_EXTICR2_EXTI4_PF_Pos            (0U)                              
#define AFIO_EXTICR2_EXTI4_PF_Msk            (0x5UL << AFIO_EXTICR2_EXTI4_PF_Pos) /*!< 0x00000005 */
#define AFIO_EXTICR2_EXTI4_PF                AFIO_EXTICR2_EXTI4_PF_Msk            /*!< PF[4] pin */
#define AFIO_EXTICR2_EXTI4_PG_Pos            (1U)                              
#define AFIO_EXTICR2_EXTI4_PG_Msk            (0x3UL << AFIO_EXTICR2_EXTI4_PG_Pos) /*!< 0x00000006 */
#define AFIO_EXTICR2_EXTI4_PG                AFIO_EXTICR2_EXTI4_PG_Msk            /*!< PG[4] pin */

/* EXTI5 configuration */
#define AFIO_EXTICR2_EXTI5_PA                0x00000000U                          /*!< PA[5] pin */
#define AFIO_EXTICR2_EXTI5_PB_Pos            (4U)                              
#define AFIO_EXTICR2_EXTI5_PB_Msk            (0x1UL << AFIO_EXTICR2_EXTI5_PB_Pos) /*!< 0x00000010 */
#define AFIO_EXTICR2_EXTI5_PB                AFIO_EXTICR2_EXTI5_PB_Msk            /*!< PB[5] pin */
#define AFIO_EXTICR2_EXTI5_PC_Pos            (5U)                              
#define AFIO_EXTICR2_EXTI5_PC_Msk            (0x1UL << AFIO_EXTICR2_EXTI5_PC_Pos) /*!< 0x00000020 */
#define AFIO_EXTICR2_EXTI5_PC                AFIO_EXTICR2_EXTI5_PC_Msk            /*!< PC[5] pin */
#define AFIO_EXTICR2_EXTI5_PD_Pos            (4U)                              
#define AFIO_EXTICR2_EXTI5_PD_Msk            (0x3UL << AFIO_EXTICR2_EXTI5_PD_Pos) /*!< 0x00000030 */
#define AFIO_EXTICR2_EXTI5_PD                AFIO_EXTICR2_EXTI5_PD_Msk            /*!< PD[5] pin */
#define AFIO_EXTICR2_EXTI5_PE_Pos            (6U)                              
#define AFIO_EXTICR2_EXTI5_PE_Msk            (0x1UL << AFIO_EXTICR2_EXTI5_PE_Pos) /*!< 0x00000040 */
#define AFIO_EXTICR2_EXTI5_PE                AFIO_EXTICR2_EXTI5_PE_Msk            /*!< PE[5] pin */
#define AFIO_EXTICR2_EXTI5_PF_Pos            (4U)                              
#define AFIO_EXTICR2_EXTI5_PF_Msk            (0x5UL << AFIO_EXTICR2_EXTI5_PF_Pos) /*!< 0x00000050 */
#define AFIO_EXTICR2_EXTI5_PF                AFIO_EXTICR2_EXTI5_PF_Msk            /*!< PF[5] pin */
#define AFIO_EXTICR2_EXTI5_PG_Pos            (5U)                              
#define AFIO_EXTICR2_EXTI5_PG_Msk            (0x3UL << AFIO_EXTICR2_EXTI5_PG_Pos) /*!< 0x00000060 */
#define AFIO_EXTICR2_EXTI5_PG                AFIO_EXTICR2_EXTI5_PG_Msk            /*!< PG[5] pin */

/*!< EXTI6 configuration */  
#define AFIO_EXTICR2_EXTI6_PA                0x00000000U                          /*!< PA[6] pin */
#define AFIO_EXTICR2_EXTI6_PB_Pos            (8U)                              
#define AFIO_EXTICR2_EXTI6_PB_Msk            (0x1UL << AFIO_EXTICR2_EXTI6_PB_Pos) /*!< 0x00000100 */
#define AFIO_EXTICR2_EXTI6_PB                AFIO_EXTICR2_EXTI6_PB_Msk            /*!< PB[6] pin */
#define AFIO_EXTICR2_EXTI6_PC_Pos            (9U)                              
#define AFIO_EXTICR2_EXTI6_PC_Msk            (0x1UL << AFIO_EXTICR2_EXTI6_PC_Pos) /*!< 0x00000200 */
#define AFIO_EXTICR2_EXTI6_PC                AFIO_EXTICR2_EXTI6_PC_Msk            /*!< PC[6] pin */
#define AFIO_EXTICR2_EXTI6_PD_Pos            (8U)                              
#define AFIO_EXTICR2_EXTI6_PD_Msk            (0x3UL << AFIO_EXTICR2_EXTI6_PD_Pos) /*!< 0x00000300 */
#define AFIO_EXTICR2_EXTI6_PD                AFIO_EXTICR2_EXTI6_PD_Msk            /*!< PD[6] pin */
#define AFIO_EXTICR2_EXTI6_PE_Pos            (10U)                             
#define AFIO_EXTICR2_EXTI6_PE_Msk            (0x1UL << AFIO_EXTICR2_EXTI6_PE_Pos) /*!< 0x00000400 */
#define AFIO_EXTICR2_EXTI6_PE                AFIO_EXTICR2_EXTI6_PE_Msk            /*!< PE[6] pin */
#define AFIO_EXTICR2_EXTI6_PF_Pos            (8U)                              
#define AFIO_EXTICR2_EXTI6_PF_Msk            (0x5UL << AFIO_EXTICR2_EXTI6_PF_Pos) /*!< 0x00000500 */
#define AFIO_EXTICR2_EXTI6_PF                AFIO_EXTICR2_EXTI6_PF_Msk            /*!< PF[6] pin */
#define AFIO_EXTICR2_EXTI6_PG_Pos            (9U)                              
#define AFIO_EXTICR2_EXTI6_PG_Msk            (0x3UL << AFIO_EXTICR2_EXTI6_PG_Pos) /*!< 0x00000600 */
#define AFIO_EXTICR2_EXTI6_PG                AFIO_EXTICR2_EXTI6_PG_Msk            /*!< PG[6] pin */

/*!< EXTI7 configuration */
#define AFIO_EXTICR2_EXTI7_PA                0x00000000U                          /*!< PA[7] pin */
#define AFIO_EXTICR2_EXTI7_PB_Pos            (12U)                             
#define AFIO_EXTICR2_EXTI7_PB_Msk            (0x1UL << AFIO_EXTICR2_EXTI7_PB_Pos) /*!< 0x00001000 */
#define AFIO_EXTICR2_EXTI7_PB                AFIO_EXTICR2_EXTI7_PB_Msk            /*!< PB[7] pin */
#define AFIO_EXTICR2_EXTI7_PC_Pos            (13U)                             
#define AFIO_EXTICR2_EXTI7_PC_Msk            (0x1UL << AFIO_EXTICR2_EXTI7_PC_Pos) /*!< 0x00002000 */
#define AFIO_EXTICR2_EXTI7_PC                AFIO_EXTICR2_EXTI7_PC_Msk            /*!< PC[7] pin */
#define AFIO_EXTICR2_EXTI7_PD_Pos            (12U)                             
#define AFIO_EXTICR2_EXTI7_PD_Msk            (0x3UL << AFIO_EXTICR2_EXTI7_PD_Pos) /*!< 0x00003000 */
#define AFIO_EXTICR2_EXTI7_PD                AFIO_EXTICR2_EXTI7_PD_Msk            /*!< PD[7] pin */
#define AFIO_EXTICR2_EXTI7_PE_Pos            (14U)                             
#define AFIO_EXTICR2_EXTI7_PE_Msk            (0x1UL << AFIO_EXTICR2_EXTI7_PE_Pos) /*!< 0x00004000 */
#define AFIO_EXTICR2_EXTI7_PE                AFIO_EXTICR2_EXTI7_PE_Msk            /*!< PE[7] pin */
#define AFIO_EXTICR2_EXTI7_PF_Pos            (12U)                             
#define AFIO_EXTICR2_EXTI7_PF_Msk            (0x5UL << AFIO_EXTICR2_EXTI7_PF_Pos) /*!< 0x00005000 */
#define AFIO_EXTICR2_EXTI7_PF                AFIO_EXTICR2_EXTI7_PF_Msk            /*!< PF[7] pin */
#define AFIO_EXTICR2_EXTI7_PG_Pos            (13U)                             
#define AFIO_EXTICR2_EXTI7_PG_Msk            (0x3UL << AFIO_EXTICR2_EXTI7_PG_Pos) /*!< 0x00006000 */
#define AFIO_EXTICR2_EXTI7_PG                AFIO_EXTICR2_EXTI7_PG_Msk            /*!< PG[7] pin */

/*****************  Bit definition for AFIO_EXTICR3 register  *****************/
#define AFIO_EXTICR3_EXTI8_Pos               (0U)                              
#define AFIO_EXTICR3_EXTI8_Msk               (0xFUL << AFIO_EXTICR3_EXTI8_Pos)    /*!< 0x0000000F */
#define AFIO_EXTICR3_EXTI8                   AFIO_EXTICR3_EXTI8_Msk               /*!< EXTI 8 configuration */
#define AFIO_EXTICR3_EXTI9_Pos               (4U)                              
#define AFIO_EXTICR3_EXTI9_Msk               (0xFUL << AFIO_EXTICR3_EXTI9_Pos)    /*!< 0x000000F0 */
#define AFIO_EXTICR3_EXTI9                   AFIO_EXTICR3_EXTI9_Msk               /*!< EXTI 9 configuration */
#define AFIO_EXTICR3_EXTI10_Pos              (8U)                              
#define AFIO_EXTICR3_EXTI10_Msk              (0xFUL << AFIO_EXTICR3_EXTI10_Pos)   /*!< 0x00000F00 */
#define AFIO_EXTICR3_EXTI10                  AFIO_EXTICR3_EXTI10_Msk              /*!< EXTI 10 configuration */
#define AFIO_EXTICR3_EXTI11_Pos              (12U)                             
#define AFIO_EXTICR3_EXTI11_Msk              (0xFUL << AFIO_EXTICR3_EXTI11_Pos)   /*!< 0x0000F000 */
#define AFIO_EXTICR3_EXTI11                  AFIO_EXTICR3_EXTI11_Msk              /*!< EXTI 11 configuration */

/*!< EXTI8 configuration */
#define AFIO_EXTICR3_EXTI8_PA                0x00000000U                          /*!< PA[8] pin */
#define AFIO_EXTICR3_EXTI8_PB_Pos            (0U)                              
#define AFIO_EXTICR3_EXTI8_PB_Msk            (0x1UL << AFIO_EXTICR3_EXTI8_PB_Pos) /*!< 0x00000001 */
#define AFIO_EXTICR3_EXTI8_PB                AFIO_EXTICR3_EXTI8_PB_Msk            /*!< PB[8] pin */
#define AFIO_EXTICR3_EXTI8_PC_Pos            (1U)                              
#define AFIO_EXTICR3_EXTI8_PC_Msk            (0x1UL << AFIO_EXTICR3_EXTI8_PC_Pos) /*!< 0x00000002 */
#define AFIO_EXTICR3_EXTI8_PC                AFIO_EXTICR3_EXTI8_PC_Msk            /*!< PC[8] pin */
#define AFIO_EXTICR3_EXTI8_PD_Pos            (0U)                              
#define AFIO_EXTICR3_EXTI8_PD_Msk            (0x3UL << AFIO_EXTICR3_EXTI8_PD_Pos) /*!< 0x00000003 */
#define AFIO_EXTICR3_EXTI8_PD                AFIO_EXTICR3_EXTI8_PD_Msk            /*!< PD[8] pin */
#define AFIO_EXTICR3_EXTI8_PE_Pos            (2U)                              
#define AFIO_EXTICR3_EXTI8_PE_Msk            (0x1UL << AFIO_EXTICR3_EXTI8_PE_Pos) /*!< 0x00000004 */
#define AFIO_EXTICR3_EXTI8_PE                AFIO_EXTICR3_EXTI8_PE_Msk            /*!< PE[8] pin */
#define AFIO_EXTICR3_EXTI8_PF_Pos            (0U)                              
#define AFIO_EXTICR3_EXTI8_PF_Msk            (0x5UL << AFIO_EXTICR3_EXTI8_PF_Pos) /*!< 0x00000005 */
#define AFIO_EXTICR3_EXTI8_PF                AFIO_EXTICR3_EXTI8_PF_Msk            /*!< PF[8] pin */
#define AFIO_EXTICR3_EXTI8_PG_Pos            (1U)                              
#define AFIO_EXTICR3_EXTI8_PG_Msk            (0x3UL << AFIO_EXTICR3_EXTI8_PG_Pos) /*!< 0x00000006 */
#define AFIO_EXTICR3_EXTI8_PG                AFIO_EXTICR3_EXTI8_PG_Msk            /*!< PG[8] pin */

/*!< EXTI9 configuration */
#define AFIO_EXTICR3_EXTI9_PA                0x00000000U                          /*!< PA[9] pin */
#define AFIO_EXTICR3_EXTI9_PB_Pos            (4U)                              
#define AFIO_EXTICR3_EXTI9_PB_Msk            (0x1UL << AFIO_EXTICR3_EXTI9_PB_Pos) /*!< 0x00000010 */
#define AFIO_EXTICR3_EXTI9_PB                AFIO_EXTICR3_EXTI9_PB_Msk            /*!< PB[9] pin */
#define AFIO_EXTICR3_EXTI9_PC_Pos            (5U)                              
#define AFIO_EXTICR3_EXTI9_PC_Msk            (0x1UL << AFIO_EXTICR3_EXTI9_PC_Pos) /*!< 0x00000020 */
#define AFIO_EXTICR3_EXTI9_PC                AFIO_EXTICR3_EXTI9_PC_Msk            /*!< PC[9] pin */
#define AFIO_EXTICR3_EXTI9_PD_Pos            (4U)                              
#define AFIO_EXTICR3_EXTI9_PD_Msk            (0x3UL << AFIO_EXTICR3_EXTI9_PD_Pos) /*!< 0x00000030 */
#define AFIO_EXTICR3_EXTI9_PD                AFIO_EXTICR3_EXTI9_PD_Msk            /*!< PD[9] pin */
#define AFIO_EXTICR3_EXTI9_PE_Pos            (6U)                              
#define AFIO_EXTICR3_EXTI9_PE_Msk            (0x1UL << AFIO_EXTICR3_EXTI9_PE_Pos) /*!< 0x00000040 */
#define AFIO_EXTICR3_EXTI9_PE                AFIO_EXTICR3_EXTI9_PE_Msk            /*!< PE[9] pin */
#define AFIO_EXTICR3_EXTI9_PF_Pos            (4U)                              
#define AFIO_EXTICR3_EXTI9_PF_Msk            (0x5UL << AFIO_EXTICR3_EXTI9_PF_Pos) /*!< 0x00000050 */
#define AFIO_EXTICR3_EXTI9_PF                AFIO_EXTICR3_EXTI9_PF_Msk            /*!< PF[9] pin */
#define AFIO_EXTICR3_EXTI9_PG_Pos            (5U)                              
#define AFIO_EXTICR3_EXTI9_PG_Msk            (0x3UL << AFIO_EXTICR3_EXTI9_PG_Pos) /*!< 0x00000060 */
#define AFIO_EXTICR3_EXTI9_PG                AFIO_EXTICR3_EXTI9_PG_Msk            /*!< PG[9] pin */

/*!< EXTI10 configuration */  
#define AFIO_EXTICR3_EXTI10_PA               0x00000000U                           /*!< PA[10] pin */
#define AFIO_EXTICR3_EXTI10_PB_Pos           (8U)                              
#define AFIO_EXTICR3_EXTI10_PB_Msk           (0x1UL << AFIO_EXTICR3_EXTI10_PB_Pos) /*!< 0x00000100 */
#define AFIO_EXTICR3_EXTI10_PB               AFIO_EXTICR3_EXTI10_PB_Msk            /*!< PB[10] pin */
#define AFIO_EXTICR3_EXTI10_PC_Pos           (9U)                              
#define AFIO_EXTICR3_EXTI10_PC_Msk           (0x1UL << AFIO_EXTICR3_EXTI10_PC_Pos) /*!< 0x00000200 */
#define AFIO_EXTICR3_EXTI10_PC               AFIO_EXTICR3_EXTI10_PC_Msk            /*!< PC[10] pin */
#define AFIO_EXTICR3_EXTI10_PD_Pos           (8U)                              
#define AFIO_EXTICR3_EXTI10_PD_Msk           (0x3UL << AFIO_EXTICR3_EXTI10_PD_Pos) /*!< 0x00000300 */
#define AFIO_EXTICR3_EXTI10_PD               AFIO_EXTICR3_EXTI10_PD_Msk            /*!< PD[10] pin */
#define AFIO_EXTICR3_EXTI10_PE_Pos           (10U)                             
#define AFIO_EXTICR3_EXTI10_PE_Msk           (0x1UL << AFIO_EXTICR3_EXTI10_PE_Pos) /*!< 0x00000400 */
#define AFIO_EXTICR3_EXTI10_PE               AFIO_EXTICR3_EXTI10_PE_Msk            /*!< PE[10] pin */
#define AFIO_EXTICR3_EXTI10_PF_Pos           (8U)                              
#define AFIO_EXTICR3_EXTI10_PF_Msk           (0x5UL << AFIO_EXTICR3_EXTI10_PF_Pos) /*!< 0x00000500 */
#define AFIO_EXTICR3_EXTI10_PF               AFIO_EXTICR3_EXTI10_PF_Msk            /*!< PF[10] pin */
#define AFIO_EXTICR3_EXTI10_PG_Pos           (9U)                              
#define AFIO_EXTICR3_EXTI10_PG_Msk           (0x3UL << AFIO_EXTICR3_EXTI10_PG_Pos) /*!< 0x00000600 */
#define AFIO_EXTICR3_EXTI10_PG               AFIO_EXTICR3_EXTI10_PG_Msk            /*!< PG[10] pin */

/*!< EXTI11 configuration */
#define AFIO_EXTICR3_EXTI11_PA               0x00000000U                           /*!< PA[11] pin */
#define AFIO_EXTICR3_EXTI11_PB_Pos           (12U)                             
#define AFIO_EXTICR3_EXTI11_PB_Msk           (0x1UL << AFIO_EXTICR3_EXTI11_PB_Pos) /*!< 0x00001000 */
#define AFIO_EXTICR3_EXTI11_PB               AFIO_EXTICR3_EXTI11_PB_Msk            /*!< PB[11] pin */
#define AFIO_EXTICR3_EXTI11_PC_Pos           (13U)                             
#define AFIO_EXTICR3_EXTI11_PC_Msk           (0x1UL << AFIO_EXTICR3_EXTI11_PC_Pos) /*!< 0x00002000 */
#define AFIO_EXTICR3_EXTI11_PC               AFIO_EXTICR3_EXTI11_PC_Msk            /*!< PC[11] pin */
#define AFIO_EXTICR3_EXTI11_PD_Pos           (12U)                             
#define AFIO_EXTICR3_EXTI11_PD_Msk           (0x3UL << AFIO_EXTICR3_EXTI11_PD_Pos) /*!< 0x00003000 */
#define AFIO_EXTICR3_EXTI11_PD               AFIO_EXTICR3_EXTI11_PD_Msk            /*!< PD[11] pin */
#define AFIO_EXTICR3_EXTI11_PE_Pos           (14U)                             
#define AFIO_EXTICR3_EXTI11_PE_Msk           (0x1UL << AFIO_EXTICR3_EXTI11_PE_Pos) /*!< 0x00004000 */
#define AFIO_EXTICR3_EXTI11_PE               AFIO_EXTICR3_EXTI11_PE_Msk            /*!< PE[11] pin */
#define AFIO_EXTICR3_EXTI11_PF_Pos           (12U)                             
#define AFIO_EXTICR3_EXTI11_PF_Msk           (0x5UL << AFIO_EXTICR3_EXTI11_PF_Pos) /*!< 0x00005000 */
#define AFIO_EXTICR3_EXTI11_PF               AFIO_EXTICR3_EXTI11_PF_Msk            /*!< PF[11] pin */
#define AFIO_EXTICR3_EXTI11_PG_Pos           (13U)                             
#define AFIO_EXTICR3_EXTI11_PG_Msk           (0x3UL << AFIO_EXTICR3_EXTI11_PG_Pos) /*!< 0x00006000 */
#define AFIO_EXTICR3_EXTI11_PG               AFIO_EXTICR3_EXTI11_PG_Msk            /*!< PG[11] pin */

/*****************  Bit definition for AFIO_EXTICR4 register  *****************/
#define AFIO_EXTICR4_EXTI12_Pos              (0U)                              
#define AFIO_EXTICR4_EXTI12_Msk              (0xFUL << AFIO_EXTICR4_EXTI12_Pos)    /*!< 0x0000000F */
#define AFIO_EXTICR4_EXTI12                  AFIO_EXTICR4_EXTI12_Msk               /*!< EXTI 12 configuration */
#define AFIO_EXTICR4_EXTI13_Pos              (4U)                              
#define AFIO_EXTICR4_EXTI13_Msk              (0xFUL << AFIO_EXTICR4_EXTI13_Pos)    /*!< 0x000000F0 */
#define AFIO_EXTICR4_EXTI13                  AFIO_EXTICR4_EXTI13_Msk               /*!< EXTI 13 configuration */
#define AFIO_EXTICR4_EXTI14_Pos              (8U)                              
#define AFIO_EXTICR4_EXTI14_Msk              (0xFUL << AFIO_EXTICR4_EXTI14_Pos)    /*!< 0x00000F00 */
#define AFIO_EXTICR4_EXTI14                  AFIO_EXTICR4_EXTI14_Msk               /*!< EXTI 14 configuration */
#define AFIO_EXTICR4_EXTI15_Pos              (12U)                             
#define AFIO_EXTICR4_EXTI15_Msk              (0xFUL << AFIO_EXTICR4_EXTI15_Pos)    /*!< 0x0000F000 */
#define AFIO_EXTICR4_EXTI15                  AFIO_EXTICR4_EXTI15_Msk               /*!< EXTI 15 configuration */

/* EXTI12 configuration */
#define AFIO_EXTICR4_EXTI12_PA               0x00000000U                           /*!< PA[12] pin */
#define AFIO_EXTICR4_EXTI12_PB_Pos           (0U)                              
#define AFIO_EXTICR4_EXTI12_PB_Msk           (0x1UL << AFIO_EXTICR4_EXTI12_PB_Pos) /*!< 0x00000001 */
#define AFIO_EXTICR4_EXTI12_PB               AFIO_EXTICR4_EXTI12_PB_Msk            /*!< PB[12] pin */
#define AFIO_EXTICR4_EXTI12_PC_Pos           (1U)                              
#define AFIO_EXTICR4_EXTI12_PC_Msk           (0x1UL << AFIO_EXTICR4_EXTI12_PC_Pos) /*!< 0x00000002 */
#define AFIO_EXTICR4_EXTI12_PC               AFIO_EXTICR4_EXTI12_PC_Msk            /*!< PC[12] pin */
#define AFIO_EXTICR4_EXTI12_PD_Pos           (0U)                              
#define AFIO_EXTICR4_EXTI12_PD_Msk           (0x3UL << AFIO_EXTICR4_EXTI12_PD_Pos) /*!< 0x00000003 */
#define AFIO_EXTICR4_EXTI12_PD               AFIO_EXTICR4_EXTI12_PD_Msk            /*!< PD[12] pin */
#define AFIO_EXTICR4_EXTI12_PE_Pos           (2U)                              
#define AFIO_EXTICR4_EXTI12_PE_Msk           (0x1UL << AFIO_EXTICR4_EXTI12_PE_Pos) /*!< 0x00000004 */
#define AFIO_EXTICR4_EXTI12_PE               AFIO_EXTICR4_EXTI12_PE_Msk            /*!< PE[12] pin */
#define AFIO_EXTICR4_EXTI12_PF_Pos           (0U)                              
#define AFIO_EXTICR4_EXTI12_PF_Msk           (0x5UL << AFIO_EXTICR4_EXTI12_PF_Pos) /*!< 0x00000005 */
#define AFIO_EXTICR4_EXTI12_PF               AFIO_EXTICR4_EXTI12_PF_Msk            /*!< PF[12] pin */
#define AFIO_EXTICR4_EXTI12_PG_Pos           (1U)                              
#define AFIO_EXTICR4_EXTI12_PG_Msk           (0x3UL << AFIO_EXTICR4_EXTI12_PG_Pos) /*!< 0x00000006 */
#define AFIO_EXTICR4_EXTI12_PG               AFIO_EXTICR4_EXTI12_PG_Msk            /*!< PG[12] pin */

/* EXTI13 configuration */
#define AFIO_EXTICR4_EXTI13_PA               0x00000000U                           /*!< PA[13] pin */
#define AFIO_EXTICR4_EXTI13_PB_Pos           (4U)                              
#define AFIO_EXTICR4_EXTI13_PB_Msk           (0x1UL << AFIO_EXTICR4_EXTI13_PB_Pos) /*!< 0x00000010 */
#define AFIO_EXTICR4_EXTI13_PB               AFIO_EXTICR4_EXTI13_PB_Msk            /*!< PB[13] pin */
#define AFIO_EXTICR4_EXTI13_PC_Pos           (5U)                              
#define AFIO_EXTICR4_EXTI13_PC_Msk           (0x1UL << AFIO_EXTICR4_EXTI13_PC_Pos) /*!< 0x00000020 */
#define AFIO_EXTICR4_EXTI13_PC               AFIO_EXTICR4_EXTI13_PC_Msk            /*!< PC[13] pin */
#define AFIO_EXTICR4_EXTI13_PD_Pos           (4U)                              
#define AFIO_EXTICR4_EXTI13_PD_Msk           (0x3UL << AFIO_EXTICR4_EXTI13_PD_Pos) /*!< 0x00000030 */
#define AFIO_EXTICR4_EXTI13_PD               AFIO_EXTICR4_EXTI13_PD_Msk            /*!< PD[13] pin */
#define AFIO_EXTICR4_EXTI13_PE_Pos           (6U)                              
#define AFIO_EXTICR4_EXTI13_PE_Msk           (0x1UL << AFIO_EXTICR4_EXTI13_PE_Pos) /*!< 0x00000040 */
#define AFIO_EXTICR4_EXTI13_PE               AFIO_EXTICR4_EXTI13_PE_Msk            /*!< PE[13] pin */
#define AFIO_EXTICR4_EXTI13_PF_Pos           (4U)                              
#define AFIO_EXTICR4_EXTI13_PF_Msk           (0x5UL << AFIO_EXTICR4_EXTI13_PF_Pos) /*!< 0x00000050 */
#define AFIO_EXTICR4_EXTI13_PF               AFIO_EXTICR4_EXTI13_PF_Msk            /*!< PF[13] pin */
#define AFIO_EXTICR4_EXTI13_PG_Pos           (5U)                              
#define AFIO_EXTICR4_EXTI13_PG_Msk           (0x3UL << AFIO_EXTICR4_EXTI13_PG_Pos) /*!< 0x00000060 */
#define AFIO_EXTICR4_EXTI13_PG               AFIO_EXTICR4_EXTI13_PG_Msk            /*!< PG[13] pin */

/*!< EXTI14 configuration */  
#define AFIO_EXTICR4_EXTI14_PA               0x00000000U                           /*!< PA[14] pin */
#define AFIO_EXTICR4_EXTI14_PB_Pos           (8U)                              
#define AFIO_EXTICR4_EXTI14_PB_Msk           (0x1UL << AFIO_EXTICR4_EXTI14_PB_Pos) /*!< 0x00000100 */
#define AFIO_EXTICR4_EXTI14_PB               AFIO_EXTICR4_EXTI14_PB_Msk            /*!< PB[14] pin */
#define AFIO_EXTICR4_EXTI14_PC_Pos           (9U)                              
#define AFIO_EXTICR4_EXTI14_PC_Msk           (0x1UL << AFIO_EXTICR4_EXTI14_PC_Pos) /*!< 0x00000200 */
#define AFIO_EXTICR4_EXTI14_PC               AFIO_EXTICR4_EXTI14_PC_Msk            /*!< PC[14] pin */
#define AFIO_EXTICR4_EXTI14_PD_Pos           (8U)                              
#define AFIO_EXTICR4_EXTI14_PD_Msk           (0x3UL << AFIO_EXTICR4_EXTI14_PD_Pos) /*!< 0x00000300 */
#define AFIO_EXTICR4_EXTI14_PD               AFIO_EXTICR4_EXTI14_PD_Msk            /*!< PD[14] pin */
#define AFIO_EXTICR4_EXTI14_PE_Pos           (10U)                             
#define AFIO_EXTICR4_EXTI14_PE_Msk           (0x1UL << AFIO_EXTICR4_EXTI14_PE_Pos) /*!< 0x00000400 */
#define AFIO_EXTICR4_EXTI14_PE               AFIO_EXTICR4_EXTI14_PE_Msk            /*!< PE[14] pin */
#define AFIO_EXTICR4_EXTI14_PF_Pos           (8U)                              
#define AFIO_EXTICR4_EXTI14_PF_Msk           (0x5UL << AFIO_EXTICR4_EXTI14_PF_Pos) /*!< 0x00000500 */
#define AFIO_EXTICR4_EXTI14_PF               AFIO_EXTICR4_EXTI14_PF_Msk            /*!< PF[14] pin */
#define AFIO_EXTICR4_EXTI14_PG_Pos           (9U)                              
#define AFIO_EXTICR4_EXTI14_PG_Msk           (0x3UL << AFIO_EXTICR4_EXTI14_PG_Pos) /*!< 0x00000600 */
#define AFIO_EXTICR4_EXTI14_PG               AFIO_EXTICR4_EXTI14_PG_Msk            /*!< PG[14] pin */

/*!< EXTI15 configuration */
#define AFIO_EXTICR4_EXTI15_PA               0x00000000U                           /*!< PA[15] pin */
#define AFIO_EXTICR4_EXTI15_PB_Pos           (12U)                             
#define AFIO_EXTICR4_EXTI15_PB_Msk           (0x1UL << AFIO_EXTICR4_EXTI15_PB_Pos) /*!< 0x00001000 */
#define AFIO_EXTICR4_EXTI15_PB               AFIO_EXTICR4_EXTI15_PB_Msk            /*!< PB[15] pin */
#define AFIO_EXTICR4_EXTI15_PC_Pos           (13U)                             
#define AFIO_EXTICR4_EXTI15_PC_Msk           (0x1UL << AFIO_EXTICR4_EXTI15_PC_Pos) /*!< 0x00002000 */
#define AFIO_EXTICR4_EXTI15_PC               AFIO_EXTICR4_EXTI15_PC_Msk            /*!< PC[15] pin */
#define AFIO_EXTICR4_EXTI15_PD_Pos           (12U)                             
#define AFIO_EXTICR4_EXTI15_PD_Msk           (0x3UL << AFIO_EXTICR4_EXTI15_PD_Pos) /*!< 0x00003000 */
#define AFIO_EXTICR4_EXTI15_PD               AFIO_EXTICR4_EXTI15_PD_Msk            /*!< PD[15] pin */
#define AFIO_EXTICR4_EXTI15_PE_Pos           (14U)                             
#define AFIO_EXTICR4_EXTI15_PE_Msk           (0x1UL << AFIO_EXTICR4_EXTI15_PE_Pos) /*!< 0x00004000 */
#define AFIO_EXTICR4_EXTI15_PE               AFIO_EXTICR4_EXTI15_PE_Msk            /*!< PE[15] pin */
#define AFIO_EXTICR4_EXTI15_PF_Pos           (12U)                             
#define AFIO_EXTICR4_EXTI15_PF_Msk           (0x5UL << AFIO_EXTICR4_EXTI15_PF_Pos) /*!< 0x00005000 */
#define AFIO_EXTICR4_EXTI15_PF               AFIO_EXTICR4_EXTI15_PF_Msk            /*!< PF[15] pin */
#define AFIO_EXTICR4_EXTI15_PG_Pos           (13U)                             
#define AFIO_EXTICR4_EXTI15_PG_Msk           (0x3UL << AFIO_EXTICR4_EXTI15_PG_Pos) /*!< 0x00006000 */
#define AFIO_EXTICR4_EXTI15_PG               AFIO_EXTICR4_EXTI15_PG_Msk            /*!< PG[15] pin */

/******************************************************************************/
/*                                                                            */
/*                 External Interrupt/Event Controller (EXTI)                 */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for EXTI_IMR register  *******************/
#define EXTI_IMR_MR0_Pos                    (0U)                               
#define EXTI_IMR_MR0_Msk                    (0x1UL << EXTI_IMR_MR0_Pos)         /*!< 0x00000001 */
#define EXTI_IMR_MR0                        EXTI_IMR_MR0_Msk                    /*!< Interrupt Mask on line 0 */
#define EXTI_IMR_MR1_Pos                    (1U)                               
#define EXTI_IMR_MR1_Msk                    (0x1UL << EXTI_IMR_MR1_Pos)         /*!< 0x00000002 */
#define EXTI_IMR_MR1                        EXTI_IMR_MR1_Msk                    /*!< Interrupt Mask on line 1 */
#define EXTI_IMR_MR2_Pos                    (2U)                               
#define EXTI_IMR_MR2_Msk                    (0x1UL << EXTI_IMR_MR2_Pos)         /*!< 0x00000004 */
#define EXTI_IMR_MR2                        EXTI_IMR_MR2_Msk                    /*!< Interrupt Mask on line 2 */
#define EXTI_IMR_MR3_Pos                    (3U)                               
#define EXTI_IMR_MR3_Msk                    (0x1UL << EXTI_IMR_MR3_Pos)         /*!< 0x00000008 */
#define EXTI_IMR_MR3                        EXTI_IMR_MR3_Msk                    /*!< Interrupt Mask on line 3 */
#define EXTI_IMR_MR4_Pos                    (4U)                               
#define EXTI_IMR_MR4_Msk                    (0x1UL << EXTI_IMR_MR4_Pos)         /*!< 0x00000010 */
#define EXTI_IMR_MR4                        EXTI_IMR_MR4_Msk                    /*!< Interrupt Mask on line 4 */
#define EXTI_IMR_MR5_Pos                    (5U)                               
#define EXTI_IMR_MR5_Msk                    (0x1UL << EXTI_IMR_MR5_Pos)         /*!< 0x00000020 */
#define EXTI_IMR_MR5                        EXTI_IMR_MR5_Msk                    /*!< Interrupt Mask on line 5 */
#define EXTI_IMR_MR6_Pos                    (6U)                               
#define EXTI_IMR_MR6_Msk                    (0x1UL << EXTI_IMR_MR6_Pos)         /*!< 0x00000040 */
#define EXTI_IMR_MR6                        EXTI_IMR_MR6_Msk                    /*!< Interrupt Mask on line 6 */
#define EXTI_IMR_MR7_Pos                    (7U)                               
#define EXTI_IMR_MR7_Msk                    (0x1UL << EXTI_IMR_MR7_Pos)         /*!< 0x00000080 */
#define EXTI_IMR_MR7                        EXTI_IMR_MR7_Msk                    /*!< Interrupt Mask on line 7 */
#define EXTI_IMR_MR8_Pos                    (8U)                               
#define EXTI_IMR_MR8_Msk                    (0x1UL << EXTI_IMR_MR8_Pos)         /*!< 0x00000100 */
#define EXTI_IMR_MR8                        EXTI_IMR_MR8_Msk                    /*!< Interrupt Mask on line 8 */
#define EXTI_IMR_MR9_Pos                    (9U)                               
#define EXTI_IMR_MR9_Msk                    (0x1UL << EXTI_IMR_MR9_Pos)         /*!< 0x00000200 */
#define EXTI_IMR_MR9                        EXTI_IMR_MR9_Msk                    /*!< Interrupt Mask on line 9 */
#define EXTI_IMR_MR10_Pos                   (10U)                              
#define EXTI_IMR_MR10_Msk                   (0x1UL << EXTI_IMR_MR10_Pos)        /*!< 0x00000400 */
#define EXTI_IMR_MR10                       EXTI_IMR_MR10_Msk                   /*!< Interrupt Mask on line 10 */
#define EXTI_IMR_MR11_Pos                   (11U)                              
#define EXTI_IMR_MR11_Msk                   (0x1UL << EXTI_IMR_MR11_Pos)        /*!< 0x00000800 */
#define EXTI_IMR_MR11                       EXTI_IMR_MR11_Msk                   /*!< Interrupt Mask on line 11 */
#define EXTI_IMR_MR12_Pos                   (12U)                              
#define EXTI_IMR_MR12_Msk                   (0x1UL << EXTI_IMR_MR12_Pos)        /*!< 0x00001000 */
#define EXTI_IMR_MR12                       EXTI_IMR_MR12_Msk                   /*!< Interrupt Mask on line 12 */
#define EXTI_IMR_MR13_Pos                   (13U)                              
#define EXTI_IMR_MR13_Msk                   (0x1UL << EXTI_IMR_MR13_Pos)        /*!< 0x00002000 */
#define EXTI_IMR_MR13                       EXTI_IMR_MR13_Msk                   /*!< Interrupt Mask on line 13 */
#define EXTI_IMR_MR14_Pos                   (14U)                              
#define EXTI_IMR_MR14_Msk                   (0x1UL << EXTI_IMR_MR14_Pos)        /*!< 0x00004000 */
#define EXTI_IMR_MR14                       EXTI_IMR_MR14_Msk                   /*!< Interrupt Mask on line 14 */
#define EXTI_IMR_MR15_Pos                   (15U)                              
#define EXTI_IMR_MR15_Msk                   (0x1UL << EXTI_IMR_MR15_Pos)        /*!< 0x00008000 */
#define EXTI_IMR_MR15                       EXTI_IMR_MR15_Msk                   /*!< Interrupt Mask on line 15 */
#define EXTI_IMR_MR16_Pos                   (16U)                              
#define EXTI_IMR_MR16_Msk                   (0x1UL << EXTI_IMR_MR16_Pos)        /*!< 0x00010000 */
#define EXTI_IMR_MR16                       EXTI_IMR_MR16_Msk                   /*!< Interrupt Mask on line 16 */
#define EXTI_IMR_MR17_Pos                   (17U)                              
#define EXTI_IMR_MR17_Msk                   (0x1UL << EXTI_IMR_MR17_Pos)        /*!< 0x00020000 */
#define EXTI_IMR_MR17                       EXTI_IMR_MR17_Msk                   /*!< Interrupt Mask on line 17 */
#define EXTI_IMR_MR18_Pos                   (18U)                              
#define EXTI_IMR_MR18_Msk                   (0x1UL << EXTI_IMR_MR18_Pos)        /*!< 0x00040000 */
#define EXTI_IMR_MR18                       EXTI_IMR_MR18_Msk                   /*!< Interrupt Mask on line 18 */
 
/*******************  Bit definition for EXTI_EMR register  *******************/
#define EXTI_EMR_MR0_Pos                    (0U)                               
#define EXTI_EMR_MR0_Msk                    (0x1UL << EXTI_EMR_MR0_Pos)         /*!< 0x00000001 */
#define EXTI_EMR_MR0                        EXTI_EMR_MR0_Msk                    /*!< Event Mask on line 0 */
#define EXTI_EMR_MR1_Pos                    (1U)                               
#define EXTI_EMR_MR1_Msk                    (0x1UL << EXTI_EMR_MR1_Pos)         /*!< 0x00000002 */
#define EXTI_EMR_MR1                        EXTI_EMR_MR1_Msk                    /*!< Event Mask on line 1 */
#define EXTI_EMR_MR2_Pos                    (2U)                               
#define EXTI_EMR_MR2_Msk                    (0x1UL << EXTI_EMR_MR2_Pos)         /*!< 0x00000004 */
#define EXTI_EMR_MR2                        EXTI_EMR_MR2_Msk                    /*!< Event Mask on line 2 */
#define EXTI_EMR_MR3_Pos                    (3U)                               
#define EXTI_EMR_MR3_Msk                    (0x1UL << EXTI_EMR_MR3_Pos)         /*!< 0x00000008 */
#define EXTI_EMR_MR3                        EXTI_EMR_MR3_Msk                    /*!< Event Mask on line 3 */
#define EXTI_EMR_MR4_Pos                    (4U)                               
#define EXTI_EMR_MR4_Msk                    (0x1UL << EXTI_EMR_MR4_Pos)         /*!< 0x00000010 */
#define EXTI_EMR_MR4                        EXTI_EMR_MR4_Msk                    /*!< Event Mask on line 4 */
#define EXTI_EMR_MR5_Pos                    (5U)                               
#define EXTI_EMR_MR5_Msk                    (0x1UL << EXTI_EMR_MR5_Pos)         /*!< 0x00000020 */
#define EXTI_EMR_MR5                        EXTI_EMR_MR5_Msk                    /*!< Event Mask on line 5 */
#define EXTI_EMR_MR6_Pos                    (6U)                               
#define EXTI_EMR_MR6_Msk                    (0x1UL << EXTI_EMR_MR6_Pos)         /*!< 0x00000040 */
#define EXTI_EMR_MR6                        EXTI_EMR_MR6_Msk                    /*!< Event Mask on line 6 */
#define EXTI_EMR_MR7_Pos                    (7U)                               
#define EXTI_EMR_MR7_Msk                    (0x1UL << EXTI_EMR_MR7_Pos)         /*!< 0x00000080 */
#define EXTI_EMR_MR7                        EXTI_EMR_MR7_Msk                    /*!< Event Mask on line 7 */
#define EXTI_EMR_MR8_Pos                    (8U)                               
#define EXTI_EMR_MR8_Msk                    (0x1UL << EXTI_EMR_MR8_Pos)         /*!< 0x00000100 */
#define EXTI_EMR_MR8                        EXTI_EMR_MR8_Msk                    /*!< Event Mask on line 8 */
#define EXTI_EMR_MR9_Pos                    (9U)                               
#define EXTI_EMR_MR9_Msk                    (0x1UL << EXTI_EMR_MR9_Pos)         /*!< 0x00000200 */
#define EXTI_EMR_MR9                        EXTI_EMR_MR9_Msk                    /*!< Event Mask on line 9 */
#define EXTI_EMR_MR10_Pos                   (10U)                              
#define EXTI_EMR_MR10_Msk                   (0x1UL << EXTI_EMR_MR10_Pos)        /*!< 0x00000400 */
#define EXTI_EMR_MR10                       EXTI_EMR_MR10_Msk                   /*!< Event Mask on line 10 */
#define EXTI_EMR_MR11_Pos                   (11U)                              
#define EXTI_EMR_MR11_Msk                   (0x1UL << EXTI_EMR_MR11_Pos)        /*!< 0x00000800 */
#define EXTI_EMR_MR11                       EXTI_EMR_MR11_Msk                   /*!< Event Mask on line 11 */
#define EXTI_EMR_MR12_Pos                   (12U)                              
#define EXTI_EMR_MR12_Msk                   (0x1UL << EXTI_EMR_MR12_Pos)        /*!< 0x00001000 */
#define EXTI_EMR_MR12                       EXTI_EMR_MR12_Msk                   /*!< Event Mask on line 12 */
#define EXTI_EMR_MR13_Pos                   (13U)                              
#define EXTI_EMR_MR13_Msk                   (0x1UL << EXTI_EMR_MR13_Pos)        /*!< 0x00002000 */
#define EXTI_EMR_MR13                       EXTI_EMR_MR13_Msk                   /*!< Event Mask on line 13 */
#define EXTI_EMR_MR14_Pos                   (14U)                              
#define EXTI_EMR_MR14_Msk                   (0x1UL << EXTI_EMR_MR14_Pos)        /*!< 0x00004000 */
#define EXTI_EMR_MR14                       EXTI_EMR_MR14_Msk                   /*!< Event Mask on line 14 */
#define EXTI_EMR_MR15_Pos                   (15U)                              
#define EXTI_EMR_MR15_Msk                   (0x1UL << EXTI_EMR_MR15_Pos)        /*!< 0x00008000 */
#define EXTI_EMR_MR15                       EXTI_EMR_MR15_Msk                   /*!< Event Mask on line 15 */
#define EXTI_EMR_MR16_Pos                   (16U)                              
#define EXTI_EMR_MR16_Msk                   (0x1UL << EXTI_EMR_MR16_Pos)        /*!< 0x00010000 */
#define EXTI_EMR_MR16                       EXTI_EMR_MR16_Msk                   /*!< Event Mask on line 16 */
#define EXTI_EMR_MR17_Pos                   (17U)                              
#define EXTI_EMR_MR17_Msk                   (0x1UL << EXTI_EMR_MR17_Pos)        /*!< 0x00020000 */
#define EXTI_EMR_MR17                       EXTI_EMR_MR17_Msk                   /*!< Event Mask on line 17 */
#define EXTI_EMR_MR18_Pos                   (18U)                              
#define EXTI_EMR_MR18_Msk                   (0x1UL << EXTI_EMR_MR18_Pos)        /*!< 0x00040000 */
#define EXTI_EMR_MR18                       EXTI_EMR_MR18_Msk                   /*!< Event Mask on line 18 */

/******************  Bit definition for EXTI_RTSR register  *******************/
#define EXTI_RTSR_TR0_Pos                   (0U)                               
#define EXTI_RTSR_TR0_Msk                   (0x1UL << EXTI_RTSR_TR0_Pos)        /*!< 0x00000001 */
#define EXTI_RTSR_TR0                       EXTI_RTSR_TR0_Msk                   /*!< Rising trigger event configuration bit of line 0 */
#define EXTI_RTSR_TR1_Pos                   (1U)                               
#define EXTI_RTSR_TR1_Msk                   (0x1UL << EXTI_RTSR_TR1_Pos)        /*!< 0x00000002 */
#define EXTI_RTSR_TR1                       EXTI_RTSR_TR1_Msk                   /*!< Rising trigger event configuration bit of line 1 */
#define EXTI_RTSR_TR2_Pos                   (2U)                               
#define EXTI_RTSR_TR2_Msk                   (0x1UL << EXTI_RTSR_TR2_Pos)        /*!< 0x00000004 */
#define EXTI_RTSR_TR2                       EXTI_RTSR_TR2_Msk                   /*!< Rising trigger event configuration bit of line 2 */
#define EXTI_RTSR_TR3_Pos                   (3U)                               
#define EXTI_RTSR_TR3_Msk                   (0x1UL << EXTI_RTSR_TR3_Pos)        /*!< 0x00000008 */
#define EXTI_RTSR_TR3                       EXTI_RTSR_TR3_Msk                   /*!< Rising trigger event configuration bit of line 3 */
#define EXTI_RTSR_TR4_Pos                   (4U)                               
#define EXTI_RTSR_TR4_Msk                   (0x1UL << EXTI_RTSR_TR4_Pos)        /*!< 0x00000010 */
#define EXTI_RTSR_TR4                       EXTI_RTSR_TR4_Msk                   /*!< Rising trigger event configuration bit of line 4 */
#define EXTI_RTSR_TR5_Pos                   (5U)                               
#define EXTI_RTSR_TR5_Msk                   (0x1UL << EXTI_RTSR_TR5_Pos)        /*!< 0x00000020 */
#define EXTI_RTSR_TR5                       EXTI_RTSR_TR5_Msk                   /*!< Rising trigger event configuration bit of line 5 */
#define EXTI_RTSR_TR6_Pos                   (6U)                               
#define EXTI_RTSR_TR6_Msk                   (0x1UL << EXTI_RTSR_TR6_Pos)        /*!< 0x00000040 */
#define EXTI_RTSR_TR6                       EXTI_RTSR_TR6_Msk                   /*!< Rising trigger event configuration bit of line 6 */
#define EXTI_RTSR_TR7_Pos                   (7U)                               
#define EXTI_RTSR_TR7_Msk                   (0x1UL << EXTI_RTSR_TR7_Pos)        /*!< 0x00000080 */
#define EXTI_RTSR_TR7                       EXTI_RTSR_TR7_Msk                   /*!< Rising trigger event configuration bit of line 7 */
#define EXTI_RTSR_TR8_Pos                   (8U)                               
#define EXTI_RTSR_TR8_Msk                   (0x1UL << EXTI_RTSR_TR8_Pos)        /*!< 0x00000100 */
#define EXTI_RTSR_TR8                       EXTI_RTSR_TR8_Msk                   /*!< Rising trigger event configuration bit of line 8 */
#define EXTI_RTSR_TR9_Pos                   (9U)                               
#define EXTI_RTSR_TR9_Msk                   (0x1UL << EXTI_RTSR_TR9_Pos)        /*!< 0x00000200 */
#define EXTI_RTSR_TR9                       EXTI_RTSR_TR9_Msk                   /*!< Rising trigger event configuration bit of line 9 */
#define EXTI_RTSR_TR10_Pos                  (10U)                              
#define EXTI_RTSR_TR10_Msk                  (0x1UL << EXTI_RTSR_TR10_Pos)       /*!< 0x00000400 */
#define EXTI_RTSR_TR10                      EXTI_RTSR_TR10_Msk                  /*!< Rising trigger event configuration bit of line 10 */
#define EXTI_RTSR_TR11_Pos                  (11U)                              
#define EXTI_RTSR_TR11_Msk                  (0x1UL << EXTI_RTSR_TR11_Pos)       /*!< 0x00000800 */
#define EXTI_RTSR_TR11                      EXTI_RTSR_TR11_Msk                  /*!< Rising trigger event configuration bit of line 11 */
#define EXTI_RTSR_TR12_Pos                  (12U)                              
#define EXTI_RTSR_TR12_Msk                  (0x1UL << EXTI_RTSR_TR12_Pos)       /*!< 0x00001000 */
#define EXTI_RTSR_TR12                      EXTI_RTSR_TR12_Msk                  /*!< Rising trigger event configuration bit of line 12 */
#define EXTI_RTSR_TR13_Pos                  (13U)                              
#define EXTI_RTSR_TR13_Msk                  (0x1UL << EXTI_RTSR_TR13_Pos)       /*!< 0x00002000 */
#define EXTI_RTSR_TR13                      EXTI_RTSR_TR13_Msk                  /*!< Rising trigger event configuration bit of line 13 */
#define EXTI_RTSR_TR14_Pos                  (14U)                              
#define EXTI_RTSR_TR14_Msk                  (0x1UL << EXTI_RTSR_TR14_Pos)       /*!< 0x00004000 */
#define EXTI_RTSR_TR14                      EXTI_RTSR_TR14_Msk                  /*!< Rising trigger event configuration bit of line 14 */
#define EXTI_RTSR_TR15_Pos                  (15U)                              
#define EXTI_RTSR_TR15_Msk                  (0x1UL << EXTI_RTSR_TR15_Pos)       /*!< 0x00008000 */
#define EXTI_RTSR_TR15                      EXTI_RTSR_TR15_Msk                  /*!< Rising trigger event configuration bit of line 15 */
#define EXTI_RTSR_TR16_Pos                  (16U)                              
#define EXTI_RTSR_TR16_Msk                  (0x1UL << EXTI_RTSR_TR16_Pos)       /*!< 0x00010000 */
#define EXTI_RTSR_TR16                      EXTI_RTSR_TR16_Msk                  /*!< Rising trigger event configuration bit of line 16 */
#define EXTI_RTSR_TR17_Pos                  (17U)                              
#define EXTI_RTSR_TR17_Msk                  (0x1UL << EXTI_RTSR_TR17_Pos)       /*!< 0x00020000 */
#define EXTI_RTSR_TR17                      EXTI_RTSR_TR17_Msk                  /*!< Rising trigger event configuration bit of line 17 */
#define EXTI_RTSR_TR18_Pos                  (18U)                              
#define EXTI_RTSR_TR18_Msk                  (0x1UL << EXTI_RTSR_TR18_Pos)       /*!< 0x00040000 */
#define EXTI_RTSR_TR18                      EXTI_RTSR_TR18_Msk                  /*!< Rising trigger event configuration bit of line 18 */

/******************  Bit definition for EXTI_FTSR register  *******************/
#define EXTI_FTSR_TR0_Pos                   (0U)                               
#define EXTI_FTSR_TR0_Msk                   (0x1UL << EXTI_FTSR_TR0_Pos)        /*!< 0x00000001 */
#define EXTI_FTSR_TR0                       EXTI_FTSR_TR0_Msk                   /*!< Falling trigger event configuration bit of line 0 */
#define EXTI_FTSR_TR1_Pos                   (1U)                               
#define EXTI_FTSR_TR1_Msk                   (0x1UL << EXTI_FTSR_TR1_Pos)        /*!< 0x00000002 */
#define EXTI_FTSR_TR1                       EXTI_FTSR_TR1_Msk                   /*!< Falling trigger event configuration bit of line 1 */
#define EXTI_FTSR_TR2_Pos                   (2U)                               
#define EXTI_FTSR_TR2_Msk                   (0x1UL << EXTI_FTSR_TR2_Pos)        /*!< 0x00000004 */
#define EXTI_FTSR_TR2                       EXTI_FTSR_TR2_Msk                   /*!< Falling trigger event configuration bit of line 2 */
#define EXTI_FTSR_TR3_Pos                   (3U)                               
#define EXTI_FTSR_TR3_Msk                   (0x1UL << EXTI_FTSR_TR3_Pos)        /*!< 0x00000008 */
#define EXTI_FTSR_TR3                       EXTI_FTSR_TR3_Msk                   /*!< Falling trigger event configuration bit of line 3 */
#define EXTI_FTSR_TR4_Pos                   (4U)                               
#define EXTI_FTSR_TR4_Msk                   (0x1UL << EXTI_FTSR_TR4_Pos)        /*!< 0x00000010 */
#define EXTI_FTSR_TR4                       EXTI_FTSR_TR4_Msk                   /*!< Falling trigger event configuration bit of line 4 */
#define EXTI_FTSR_TR5_Pos                   (5U)                               
#define EXTI_FTSR_TR5_Msk                   (0x1UL << EXTI_FTSR_TR5_Pos)        /*!< 0x00000020 */
#define EXTI_FTSR_TR5                       EXTI_FTSR_TR5_Msk                   /*!< Falling trigger event configuration bit of line 5 */
#define EXTI_FTSR_TR6_Pos                   (6U)                               
#define EXTI_FTSR_TR6_Msk                   (0x1UL << EXTI_FTSR_TR6_Pos)        /*!< 0x00000040 */
#define EXTI_FTSR_TR6                       EXTI_FTSR_TR6_Msk                   /*!< Falling trigger event configuration bit of line 6 */
#define EXTI_FTSR_TR7_Pos                   (7U)                               
#define EXTI_FTSR_TR7_Msk                   (0x1UL << EXTI_FTSR_TR7_Pos)        /*!< 0x00000080 */
#define EXTI_FTSR_TR7                       EXTI_FTSR_TR7_Msk                   /*!< Falling trigger event configuration bit of line 7 */
#define EXTI_FTSR_TR8_Pos                   (8U)                               
#define EXTI_FTSR_TR8_Msk                   (0x1UL << EXTI_FTSR_TR8_Pos)        /*!< 0x00000100 */
#define EXTI_FTSR_TR8                       EXTI_FTSR_TR8_Msk                   /*!< Falling trigger event configuration bit of line 8 */
#define EXTI_FTSR_TR9_Pos                   (9U)                               
#define EXTI_FTSR_TR9_Msk                   (0x1UL << EXTI_FTSR_TR9_Pos)        /*!< 0x00000200 */
#define EXTI_FTSR_TR9                       EXTI_FTSR_TR9_Msk                   /*!< Falling trigger event configuration bit of line 9 */
#define EXTI_FTSR_TR10_Pos                  (10U)                              
#define EXTI_FTSR_TR10_Msk                  (0x1UL << EXTI_FTSR_TR10_Pos)       /*!< 0x00000400 */
#define EXTI_FTSR_TR10                      EXTI_FTSR_TR10_Msk                  /*!< Falling trigger event configuration bit of line 10 */
#define EXTI_FTSR_TR11_Pos                  (11U)                              
#define EXTI_FTSR_TR11_Msk                  (0x1UL << EXTI_FTSR_TR11_Pos)       /*!< 0x00000800 */
#define EXTI_FTSR_TR11                      EXTI_FTSR_TR11_Msk                  /*!< Falling trigger event configuration bit of line 11 */
#define EXTI_FTSR_TR12_Pos                  (12U)                              
#define EXTI_FTSR_TR12_Msk                  (0x1UL << EXTI_FTSR_TR12_Pos)       /*!< 0x00001000 */
#define EXTI_FTSR_TR12                      EXTI_FTSR_TR12_Msk                  /*!< Falling trigger event configuration bit of line 12 */
#define EXTI_FTSR_TR13_Pos                  (13U)                              
#define EXTI_FTSR_TR13_Msk                  (0x1UL << EXTI_FTSR_TR13_Pos)       /*!< 0x00002000 */
#define EXTI_FTSR_TR13                      EXTI_FTSR_TR13_Msk                  /*!< Falling trigger event configuration bit of line 13 */
#define EXTI_FTSR_TR14_Pos                  (14U)                              
#define EXTI_FTSR_TR14_Msk                  (0x1UL << EXTI_FTSR_TR14_Pos)       /*!< 0x00004000 */
#define EXTI_FTSR_TR14                      EXTI_FTSR_TR14_Msk                  /*!< Falling trigger event configuration bit of line 14 */
#define EXTI_FTSR_TR15_Pos                  (15U)                              
#define EXTI_FTSR_TR15_Msk                  (0x1UL << EXTI_FTSR_TR15_Pos)       /*!< 0x00008000 */
#define EXTI_FTSR_TR15                      EXTI_FTSR_TR15_Msk                  /*!< Falling trigger event configuration bit of line 15 */
#define EXTI_FTSR_TR16_Pos                  (16U)                              
#define EXTI_FTSR_TR16_Msk                  (0x1UL << EXTI_FTSR_TR16_Pos)       /*!< 0x00010000 */
#define EXTI_FTSR_TR16                      EXTI_FTSR_TR16_Msk                  /*!< Falling trigger event configuration bit of line 16 */
#define EXTI_FTSR_TR17_Pos                  (17U)                              
#define EXTI_FTSR_TR17_Msk                  (0x1UL << EXTI_FTSR_TR17_Pos)       /*!< 0x00020000 */
#define EXTI_FTSR_TR17                      EXTI_FTSR_TR17_Msk                  /*!< Falling trigger event configuration bit of line 17 */
#define EXTI_FTSR_TR18_Pos                  (18U)                              
#define EXTI_FTSR_TR18_Msk                  (0x1UL << EXTI_FTSR_TR18_Pos)       /*!< 0x00040000 */
#define EXTI_FTSR_TR18                      EXTI_FTSR_TR18_Msk                  /*!< Falling trigger event configuration bit of line 18 */

/******************  Bit definition for EXTI_SWIER register  ******************/
#define EXTI_SWIER_SWIER0_Pos               (0U)                               
#define EXTI_SWIER_SWIER0_Msk               (0x1UL << EXTI_SWIER_SWIER0_Pos)    /*!< 0x00000001 */
#define EXTI_SWIER_SWIER0                   EXTI_SWIER_SWIER0_Msk               /*!< Software Interrupt on line 0 */
#define EXTI_SWIER_SWIER1_Pos               (1U)                               
#define EXTI_SWIER_SWIER1_Msk               (0x1UL << EXTI_SWIER_SWIER1_Pos)    /*!< 0x00000002 */
#define EXTI_SWIER_SWIER1                   EXTI_SWIER_SWIER1_Msk               /*!< Software Interrupt on line 1 */
#define EXTI_SWIER_SWIER2_Pos               (2U)                               
#define EXTI_SWIER_SWIER2_Msk               (0x1UL << EXTI_SWIER_SWIER2_Pos)    /*!< 0x00000004 */
#define EXTI_SWIER_SWIER2                   EXTI_SWIER_SWIER2_Msk               /*!< Software Interrupt on line 2 */
#define EXTI_SWIER_SWIER3_Pos               (3U)                               
#define EXTI_SWIER_SWIER3_Msk               (0x1UL << EXTI_SWIER_SWIER3_Pos)    /*!< 0x00000008 */
#define EXTI_SWIER_SWIER3                   EXTI_SWIER_SWIER3_Msk               /*!< Software Interrupt on line 3 */
#define EXTI_SWIER_SWIER4_Pos               (4U)                               
#define EXTI_SWIER_SWIER4_Msk               (0x1UL << EXTI_SWIER_SWIER4_Pos)    /*!< 0x00000010 */
#define EXTI_SWIER_SWIER4                   EXTI_SWIER_SWIER4_Msk               /*!< Software Interrupt on line 4 */
#define EXTI_SWIER_SWIER5_Pos               (5U)                               
#define EXTI_SWIER_SWIER5_Msk               (0x1UL << EXTI_SWIER_SWIER5_Pos)    /*!< 0x00000020 */
#define EXTI_SWIER_SWIER5                   EXTI_SWIER_SWIER5_Msk               /*!< Software Interrupt on line 5 */
#define EXTI_SWIER_SWIER6_Pos               (6U)                               
#define EXTI_SWIER_SWIER6_Msk               (0x1UL << EXTI_SWIER_SWIER6_Pos)    /*!< 0x00000040 */
#define EXTI_SWIER_SWIER6                   EXTI_SWIER_SWIER6_Msk               /*!< Software Interrupt on line 6 */
#define EXTI_SWIER_SWIER7_Pos               (7U)                               
#define EXTI_SWIER_SWIER7_Msk               (0x1UL << EXTI_SWIER_SWIER7_Pos)    /*!< 0x00000080 */
#define EXTI_SWIER_SWIER7                   EXTI_SWIER_SWIER7_Msk               /*!< Software Interrupt on line 7 */
#define EXTI_SWIER_SWIER8_Pos               (8U)                               
#define EXTI_SWIER_SWIER8_Msk               (0x1UL << EXTI_SWIER_SWIER8_Pos)    /*!< 0x00000100 */
#define EXTI_SWIER_SWIER8                   EXTI_SWIER_SWIER8_Msk               /*!< Software Interrupt on line 8 */
#define EXTI_SWIER_SWIER9_Pos               (9U)                               
#define EXTI_SWIER_SWIER9_Msk               (0x1UL << EXTI_SWIER_SWIER9_Pos)    /*!< 0x00000200 */
#define EXTI_SWIER_SWIER9                   EXTI_SWIER_SWIER9_Msk               /*!< Software Interrupt on line 9 */
#define EXTI_SWIER_SWIER10_Pos              (10U)                              
#define EXTI_SWIER_SWIER10_Msk              (0x1UL << EXTI_SWIER_SWIER10_Pos)   /*!< 0x00000400 */
#define EXTI_SWIER_SWIER10                  EXTI_SWIER_SWIER10_Msk              /*!< Software Interrupt on line 10 */
#define EXTI_SWIER_SWIER11_Pos              (11U)                              
#define EXTI_SWIER_SWIER11_Msk              (0x1UL << EXTI_SWIER_SWIER11_Pos)   /*!< 0x00000800 */
#define EXTI_SWIER_SWIER11                  EXTI_SWIER_SWIER11_Msk              /*!< Software Interrupt on line 11 */
#define EXTI_SWIER_SWIER12_Pos              (12U)                              
#define EXTI_SWIER_SWIER12_Msk              (0x1UL << EXTI_SWIER_SWIER12_Pos)   /*!< 0x00001000 */
#define EXTI_SWIER_SWIER12                  EXTI_SWIER_SWIER12_Msk              /*!< Software Interrupt on line 12 */
#define EXTI_SWIER_SWIER13_Pos              (13U)                              
#define EXTI_SWIER_SWIER13_Msk              (0x1UL << EXTI_SWIER_SWIER13_Pos)   /*!< 0x00002000 */
#define EXTI_SWIER_SWIER13                  EXTI_SWIER_SWIER13_Msk              /*!< Software Interrupt on line 13 */
#define EXTI_SWIER_SWIER14_Pos              (14U)                              
#define EXTI_SWIER_SWIER14_Msk              (0x1UL << EXTI_SWIER_SWIER14_Pos)   /*!< 0x00004000 */
#define EXTI_SWIER_SWIER14                  EXTI_SWIER_SWIER14_Msk              /*!< Software Interrupt on line 14 */
#define EXTI_SWIER_SWIER15_Pos              (15U)                              
#define EXTI_SWIER_SWIER15_Msk              (0x1UL << EXTI_SWIER_SWIER15_Pos)   /*!< 0x00008000 */
#define EXTI_SWIER_SWIER15                  EXTI_SWIER_SWIER15_Msk              /*!< Software Interrupt on line 15 */
#define EXTI_SWIER_SWIER16_Pos              (16U)                              
#define EXTI_SWIER_SWIER16_Msk              (0x1UL << EXTI_SWIER_SWIER16_Pos)   /*!< 0x00010000 */
#define EXTI_SWIER_SWIER16                  EXTI_SWIER_SWIER16_Msk              /*!< Software Interrupt on line 16 */
#define EXTI_SWIER_SWIER17_Pos              (17U)                              
#define EXTI_SWIER_SWIER17_Msk              (0x1UL << EXTI_SWIER_SWIER17_Pos)   /*!< 0x00020000 */
#define EXTI_SWIER_SWIER17                  EXTI_SWIER_SWIER17_Msk              /*!< Software Interrupt on line 17 */
#define EXTI_SWIER_SWIER18_Pos              (18U)                              
#define EXTI_SWIER_SWIER18_Msk              (0x1UL << EXTI_SWIER_SWIER18_Pos)   /*!< 0x00040000 */
#define EXTI_SWIER_SWIER18                  EXTI_SWIER_SWIER18_Msk              /*!< Software Interrupt on line 18 */

/*******************  Bit definition for EXTI_PR register  ********************/
#define EXTI_PR_PR0_Pos                     (0U)                               
#define EXTI_PR_PR0_Msk                     (0x1UL << EXTI_PR_PR0_Pos)          /*!< 0x00000001 */
#define EXTI_PR_PR0                         EXTI_PR_PR0_Msk                     /*!< Pending bit for line 0 */
#define EXTI_PR_PR1_Pos                     (1U)                               
#define EXTI_PR_PR1_Msk                     (0x1UL << EXTI_PR_PR1_Pos)          /*!< 0x00000002 */
#define EXTI_PR_PR1                         EXTI_PR_PR1_Msk                     /*!< Pending bit for line 1 */
#define EXTI_PR_PR2_Pos                     (2U)                               
#define EXTI_PR_PR2_Msk                     (0x1UL << EXTI_PR_PR2_Pos)          /*!< 0x00000004 */
#define EXTI_PR_PR2                         EXTI_PR_PR2_Msk                     /*!< Pending bit for line 2 */
#define EXTI_PR_PR3_Pos                     (3U)                               
#define EXTI_PR_PR3_Msk                     (0x1UL << EXTI_PR_PR3_Pos)          /*!< 0x00000008 */
#define EXTI_PR_PR3                         EXTI_PR_PR3_Msk                     /*!< Pending bit for line 3 */
#define EXTI_PR_PR4_Pos                     (4U)                               
#define EXTI_PR_PR4_Msk                     (0x1UL << EXTI_PR_PR4_Pos)          /*!< 0x00000010 */
#define EXTI_PR_PR4                         EXTI_PR_PR4_Msk                     /*!< Pending bit for line 4 */
#define EXTI_PR_PR5_Pos                     (5U)                               
#define EXTI_PR_PR5_Msk                     (0x1UL << EXTI_PR_PR5_Pos)          /*!< 0x00000020 */
#define EXTI_PR_PR5                         EXTI_PR_PR5_Msk                     /*!< Pending bit for line 5 */
#define EXTI_PR_PR6_Pos                     (6U)                               
#define EXTI_PR_PR6_Msk                     (0x1UL << EXTI_PR_PR6_Pos)          /*!< 0x00000040 */
#define EXTI_PR_PR6                         EXTI_PR_PR6_Msk                     /*!< Pending bit for line 6 */
#define EXTI_PR_PR7_Pos                     (7U)                               
#define EXTI_PR_PR7_Msk                     (0x1UL << EXTI_PR_PR7_Pos)          /*!< 0x00000080 */
#define EXTI_PR_PR7                         EXTI_PR_PR7_Msk                     /*!< Pending bit for line 7 */
#define EXTI_PR_PR8_Pos                     (8U)                               
#define EXTI_PR_PR8_Msk                     (0x1UL << EXTI_PR_PR8_Pos)          /*!< 0x00000100 */
#define EXTI_PR_PR8                         EXTI_PR_PR8_Msk                     /*!< Pending bit for line 8 */
#define EXTI_PR_PR9_Pos                     (9U)                               
#define EXTI_PR_PR9_Msk                     (0x1UL << EXTI_PR_PR9_Pos)          /*!< 0x00000200 */
#define EXTI_PR_PR9                         EXTI_PR_PR9_Msk                     /*!< Pending bit for line 9 */
#define EXTI_PR_PR10_Pos                    (10U)                              
#define EXTI_PR_PR10_Msk                    (0x1UL << EXTI_PR_PR10_Pos)         /*!< 0x00000400 */
#define EXTI_PR_PR10                        EXTI_PR_PR10_Msk                    /*!< Pending bit for line 10 */
#define EXTI_PR_PR11_Pos                    (11U)                              
#define EXTI_PR_PR11_Msk                    (0x1UL << EXTI_PR_PR11_Pos)         /*!< 0x00000800 */
#define EXTI_PR_PR11                        EXTI_PR_PR11_Msk                    /*!< Pending bit for line 11 */
#define EXTI_PR_PR12_Pos                    (12U)                              
#define EXTI_PR_PR12_Msk                    (0x1UL << EXTI_PR_PR12_Pos)         /*!< 0x00001000 */
#define EXTI_PR_PR12                        EXTI_PR_PR12_Msk                    /*!< Pending bit for line 12 */
#define EXTI_PR_PR13_Pos                    (13U)                              
#define EXTI_PR_PR13_Msk                    (0x1UL << EXTI_PR_PR13_Pos)         /*!< 0x00002000 */
#define EXTI_PR_PR13                        EXTI_PR_PR13_Msk                    /*!< Pending bit for line 13 */
#define EXTI_PR_PR14_Pos                    (14U)                              
#define EXTI_PR_PR14_Msk                    (0x1UL << EXTI_PR_PR14_Pos)         /*!< 0x00004000 */
#define EXTI_PR_PR14                        EXTI_PR_PR14_Msk                    /*!< Pending bit for line 14 */
#define EXTI_PR_PR15_Pos                    (15U)                              
#define EXTI_PR_PR15_Msk                    (0x1UL << EXTI_PR_PR15_Pos)         /*!< 0x00008000 */
#define EXTI_PR_PR15                        EXTI_PR_PR15_Msk                    /*!< Pending bit for line 15 */
#define EXTI_PR_PR16_Pos                    (16U)                              
#define EXTI_PR_PR16_Msk                    (0x1UL << EXTI_PR_PR16_Pos)         /*!< 0x00010000 */
#define EXTI_PR_PR16                        EXTI_PR_PR16_Msk                    /*!< Pending bit for line 16 */
#define EXTI_PR_PR17_Pos                    (17U)                              
#define EXTI_PR_PR17_Msk                    (0x1UL << EXTI_PR_PR17_Pos)         /*!< 0x00020000 */
#define EXTI_PR_PR17                        EXTI_PR_PR17_Msk                    /*!< Pending bit for line 17 */
#define EXTI_PR_PR18_Pos                    (18U)                              
#define EXTI_PR_PR18_Msk                    (0x1UL << EXTI_PR_PR18_Pos)         /*!< 0x00040000 */
#define EXTI_PR_PR18                        EXTI_PR_PR18_Msk                    /*!< Pending bit for line 18 */

/******************************************************************************/
/*                                                                            */
/*                   Direct Memory Access Controller (DMAC)                   */
/*                                                                            */
/******************************************************************************/

/*******************************  Bit definition for DMAC_CTLLx register  *******************************/
#define DMAC_CTLL_INT_EN                    (0x1U << 0)               /*!< Interrupt Enable Bit */

#define DMAC_CTLL_DST_TR_WIDTH_Msk          (0x7U << 1)               /*!< Destination Transfer Width field mask bit */
#define DMAC_CTLL_DST_TR_WIDTH_8            (0x0U << 1)               /*!< Destination Transfer Width is 8 bits */
#define DMAC_CTLL_DST_TR_WIDTH_16           (0x1U << 1)               /*!< Destination Transfer Width is 16 bits */
#define DMAC_CTLL_DST_TR_WIDTH_32           (0x2U << 1)               /*!< Destination Transfer Width is 32 bits */

#define DMAC_CTLL_SRC_TR_WIDTH_Msk          (0x7U << 4)               /*!< Source Transfer Width field mask bit*/
#define DMAC_CTLL_SRC_TR_WIDTH_8            (0x0U << 4)               /*!< Source Transfer Width is 8 bits */
#define DMAC_CTLL_SRC_TR_WIDTH_16           (0x1U << 4)               /*!< Source Transfer Width is 16 bits */
#define DMAC_CTLL_SRC_TR_WIDTH_32           (0x2U << 4)               /*!< Source Transfer Width is 32 bits */

#define DMAC_CTLL_DINC_Msk                  (0x3U << 7)               /*!< Destination Address Increment field mask bit */
#define DMAC_CTLL_DINC_INC                  (0x0U << 7)               /*!< Destination Address Increment is increment */
#define DMAC_CTLL_DINC_DEC                  (0x1U << 7)               /*!< Destination Address Increment is decrement */
#define DMAC_CTLL_DINC_NO                   (0x2U << 7)               /*!< Destination Address Increment is no change */

#define DMAC_CTLL_SINC_Msk                  (0x3U << 9)               /*!< Source Address Increment field mask bit */
#define DMAC_CTLL_SINC_INC                  (0x0U << 9)               /*!< Source Address Increment is increment */
#define DMAC_CTLL_SINC_DEC                  (0x1U << 9)               /*!< Source Address Increment is decrement */
#define DMAC_CTLL_SINC_NO                   (0x2U << 9)               /*!< Source Address Increment is no change */

#define DMAC_CTLL_DEST_MSIZE_Msk            (0x7U << 11)              /*!< Destination Burst Transaction Length field mask bit */
#define DMAC_CTLL_DEST_MSIZE_1              (0x0U << 11)              /*!< Destination Burst Transaction Length */
#define DMAC_CTLL_DEST_MSIZE_4              (0x1U << 11)              /*!< Destination Burst Transaction Length */
#define DMAC_CTLL_DEST_MSIZE_8              (0x2U << 11)              /*!< Destination Burst Transaction Length */
#define DMAC_CTLL_DEST_MSIZE_16             (0x3U << 11)              /*!< Destination Burst Transaction Length */
#define DMAC_CTLL_DEST_MSIZE_32             (0x4U << 11)              /*!< Destination Burst Transaction Length */
#define DMAC_CTLL_DEST_MSIZE_64             (0x5U << 11)              /*!< Destination Burst Transaction Length */
#define DMAC_CTLL_DEST_MSIZE_128            (0x6U << 11)              /*!< Destination Burst Transaction Length */
#define DMAC_CTLL_DEST_MSIZE_256            (0x7U << 11)              /*!< Destination Burst Transaction Length */

#define DMAC_CTLL_SRC_MSIZE_Msk             (0x7U << 14)              /*!< Source Burst Transaction Length field mask bit */
#define DMAC_CTLL_SRC_MSIZE_1               (0x0U << 14)              /*!< Source Burst Transaction Length */
#define DMAC_CTLL_SRC_MSIZE_4               (0x1U << 14)              /*!< Source Burst Transaction Length */
#define DMAC_CTLL_SRC_MSIZE_8               (0x2U << 14)              /*!< Source Burst Transaction Length */
#define DMAC_CTLL_SRC_MSIZE_16              (0x3U << 14)              /*!< Source Burst Transaction Length */
#define DMAC_CTLL_SRC_MSIZE_32              (0x4U << 14)              /*!< Source Burst Transaction Length */
#define DMAC_CTLL_SRC_MSIZE_64              (0x5U << 14)              /*!< Source Burst Transaction Length */
#define DMAC_CTLL_SRC_MSIZE_128             (0x6U << 14)              /*!< Source Burst Transaction Length */
#define DMAC_CTLL_SRC_MSIZE_256             (0x7U << 14)              /*!< Source Burst Transaction Length */

#define DMAC_CTLL_SRC_GATHER_EN             (0x1U << 17)              /*!< Source gather enable bit */
#define DMAC_CTLL_DST_SCATTER_EN            (0x1U << 18)              /*!< Destination scatter enable bit */

#define DMAC_CTLL_TT_FC_Msk                 (0x7U << 20)              /*!< Transfer Type and Flow Control field mask bit */
#define DMAC_CTLL_TT_FC_M2M_DMAC            (0x0U << 20)              /*!< Transfer Type is Memory to Memory, Flow Control is DMAC */
#define DMAC_CTLL_TT_FC_M2P_DMAC            (0x1U << 20)              /*!< Transfer Type is Memory to Peripheral, Flow Control is DMAC */
#define DMAC_CTLL_TT_FC_P2M_DMAC            (0x2U << 20)              /*!< Transfer Type is Peripheral to Memory, Flow Control is DMAC */
#define DMAC_CTLL_TT_FC_P2P_DMAC            (0x3U << 20)              /*!< Transfer Type is Peripheral to Peripheral, Flow Control is DMAC */
#define DMAC_CTLL_TT_FC_P2M_PERIPH          (0x4U << 20)              /*!< Transfer Type is Peripheral to Memory, Flow Control is Peripheral */
#define DMAC_CTLL_TT_FC_P2P_SRC_PERIPH      (0x5U << 20)              /*!< Transfer Type is Peripheral to Peripheral, Flow Control is Source Peripheral */
#define DMAC_CTLL_TT_FC_M2P_PERIPH          (0x6U << 20)              /*!< Transfer Type is Memory to Peripheral, Flow Control is Peripheral */
#define DMAC_CTLL_TT_FC_P2P_DST_PERIPH      (0x7U << 20)              /*!< Transfer Type is Peripheral to Peripheral, Flow Control is Destination Peripheral */

#define DMAC_CTLL_LLP_DST_EN                (0x1U << 27)              /*!< Source Burst Transaction Length */
#define DMAC_CTLL_LLP_SRC_EN                (0x1U << 28)              /*!< Block chaining is enabled on the source side */

/*******************************  Bit definition for DMAC_CTLHx register  *******************************/
#define DMAC_CTLH_BLOCK_TS_Msk              (0xFFFU)                  /*!< Block Transfer Size field mask bit */
#define DMAC_CTLH_DONE                      (0x1U << 12)              /*!< Done bit */

/*******************************  Bit definition for DMAC_CFGLx register  *******************************/
#define DMAC_CFGL_CH_PRIOR_Msk              (0x7U << 5)                /*!< Channel priority field mask */
#define DMAC_CFGL_CH_SUSP                   (0x1U << 8)                /*!< Channel Suspend */
#define DMAC_CFGL_FIFO_EMPTY                (0x1U << 9)                /*!< Indicates if there is data left in the channel FIFO */
#define DMAC_CFGL_HS_SEL_DST                (0x1U << 10)               /*!< Destination Software or Hardware Handshaking Select */
#define DMAC_CFGL_HS_SEL_SRC                (0x1U << 11)               /*!< Source Software or Hardware Handshaking Select */

#define DMAC_CFGL_DST_HS_POL                (0x1U << 18)               /*!< Destination Handshaking Interface Polarity */
#define DMAC_CFGL_SRC_HS_POL                (0x1U << 19)               /*!< Source Handshaking Interface Polarity */

#define DMAC_CFGL_RELOAD_SRC                (0x1U << 30)               /*!< Automatic Source Reload */
#define DMAC_CFGL_RELOAD_DST                (0x1U << 31)               /*!< Automatic Destination Reload */

/*******************************  Bit definition for DMAC_CFGHx register  *******************************/
#define DMAC_CFGH_FIFO_MODE                 (0x1U << 1)                /*!< FIFO Mode Select */
#define DMAC_CFGH_DS_UPD_EN                 (0x1U << 5)                /*!< Destination Status Update Enable */
#define DMAC_CFGH_SS_UPD_EN                 (0x1U << 6)                /*!< Source Status Update Enable */

#define DMAC_CFGH_SRC_PER_Msk               (0xFU << 7)                /*!< No description */
#define DMAC_CFGH_DEST_PER_Msk              (0xFU << 11)               /*!< No description */

/******************************************************************************/
/*                                                                            */
/*                      Analog to Digital Converter (ADC)                     */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for ADC_SR register  ********************/
#define ADC_SR_AWD_Pos                      (0U)                               
#define ADC_SR_AWD_Msk                      (0x1UL << ADC_SR_AWD_Pos)           /*!< 0x00000001 */
#define ADC_SR_AWD                          ADC_SR_AWD_Msk                      /*!< ADC analog watchdog 1 flag */
#define ADC_SR_EOC_Pos                      (1U)                               
#define ADC_SR_EOC_Msk                      (0x1UL << ADC_SR_EOC_Pos)           /*!< 0x00000002 */
#define ADC_SR_EOC                          ADC_SR_EOC_Msk                      /*!< ADC group regular end of sequence conversions flag */
#define ADC_SR_JEOC_Pos                     (2U)                               
#define ADC_SR_JEOC_Msk                     (0x1UL << ADC_SR_JEOC_Pos)          /*!< 0x00000004 */
#define ADC_SR_JEOC                         ADC_SR_JEOC_Msk                     /*!< ADC group injected end of sequence conversions flag */
#define ADC_SR_JSTRT_Pos                    (3U)                               
#define ADC_SR_JSTRT_Msk                    (0x1UL << ADC_SR_JSTRT_Pos)         /*!< 0x00000008 */
#define ADC_SR_JSTRT                        ADC_SR_JSTRT_Msk                    /*!< ADC group injected conversion start flag */
#define ADC_SR_STRT_Pos                     (4U)                               
#define ADC_SR_STRT_Msk                     (0x1UL << ADC_SR_STRT_Pos)          /*!< 0x00000010 */
#define ADC_SR_STRT                         ADC_SR_STRT_Msk                     /*!< ADC group regular conversion start flag */

/*******************  Bit definition for ADC_CR1 register  ********************/
#define ADC_CR1_AWDCH_Pos                   (0U)                               
#define ADC_CR1_AWDCH_Msk                   (0x1FUL << ADC_CR1_AWDCH_Pos)       /*!< 0x0000001F */
#define ADC_CR1_AWDCH                       ADC_CR1_AWDCH_Msk                   /*!< ADC analog watchdog 1 monitored channel selection */
#define ADC_CR1_AWDCH_0                     (0x01UL << ADC_CR1_AWDCH_Pos)       /*!< 0x00000001 */
#define ADC_CR1_AWDCH_1                     (0x02UL << ADC_CR1_AWDCH_Pos)       /*!< 0x00000002 */
#define ADC_CR1_AWDCH_2                     (0x04UL << ADC_CR1_AWDCH_Pos)       /*!< 0x00000004 */
#define ADC_CR1_AWDCH_3                     (0x08UL << ADC_CR1_AWDCH_Pos)       /*!< 0x00000008 */
#define ADC_CR1_AWDCH_4                     (0x10UL << ADC_CR1_AWDCH_Pos)       /*!< 0x00000010 */

#define ADC_CR1_EOCIE_Pos                   (5U)                               
#define ADC_CR1_EOCIE_Msk                   (0x1UL << ADC_CR1_EOCIE_Pos)        /*!< 0x00000020 */
#define ADC_CR1_EOCIE                       ADC_CR1_EOCIE_Msk                   /*!< ADC group regular end of sequence conversions interrupt */
#define ADC_CR1_AWDIE_Pos                   (6U)                               
#define ADC_CR1_AWDIE_Msk                   (0x1UL << ADC_CR1_AWDIE_Pos)        /*!< 0x00000040 */
#define ADC_CR1_AWDIE                       ADC_CR1_AWDIE_Msk                   /*!< ADC analog watchdog 1 interrupt */
#define ADC_CR1_JEOCIE_Pos                  (7U)                               
#define ADC_CR1_JEOCIE_Msk                  (0x1UL << ADC_CR1_JEOCIE_Pos)       /*!< 0x00000080 */
#define ADC_CR1_JEOCIE                      ADC_CR1_JEOCIE_Msk                  /*!< ADC group injected end of sequence conversions interrupt */
#define ADC_CR1_SCAN_Pos                    (8U)                               
#define ADC_CR1_SCAN_Msk                    (0x1UL << ADC_CR1_SCAN_Pos)         /*!< 0x00000100 */
#define ADC_CR1_SCAN                        ADC_CR1_SCAN_Msk                    /*!< ADC scan mode */
#define ADC_CR1_AWDSGL_Pos                  (9U)                               
#define ADC_CR1_AWDSGL_Msk                  (0x1UL << ADC_CR1_AWDSGL_Pos)       /*!< 0x00000200 */
#define ADC_CR1_AWDSGL                      ADC_CR1_AWDSGL_Msk                  /*!< ADC analog watchdog 1 monitoring a single channel or all channels */
#define ADC_CR1_JAUTO_Pos                   (10U)                              
#define ADC_CR1_JAUTO_Msk                   (0x1UL << ADC_CR1_JAUTO_Pos)        /*!< 0x00000400 */
#define ADC_CR1_JAUTO                       ADC_CR1_JAUTO_Msk                   /*!< ADC group injected automatic trigger mode */
#define ADC_CR1_DISCEN_Pos                  (11U)                              
#define ADC_CR1_DISCEN_Msk                  (0x1UL << ADC_CR1_DISCEN_Pos)       /*!< 0x00000800 */
#define ADC_CR1_DISCEN                      ADC_CR1_DISCEN_Msk                  /*!< ADC group regular sequencer discontinuous mode */
#define ADC_CR1_JDISCEN_Pos                 (12U)                              
#define ADC_CR1_JDISCEN_Msk                 (0x1UL << ADC_CR1_JDISCEN_Pos)      /*!< 0x00001000 */
#define ADC_CR1_JDISCEN                     ADC_CR1_JDISCEN_Msk                 /*!< ADC group injected sequencer discontinuous mode */

#define ADC_CR1_DISCNUM_Pos                 (13U)                              
#define ADC_CR1_DISCNUM_Msk                 (0x7UL << ADC_CR1_DISCNUM_Pos)      /*!< 0x0000E000 */
#define ADC_CR1_DISCNUM                     ADC_CR1_DISCNUM_Msk                 /*!< ADC group regular sequencer discontinuous number of ranks */
#define ADC_CR1_DISCNUM_0                   (0x1UL << ADC_CR1_DISCNUM_Pos)      /*!< 0x00002000 */
#define ADC_CR1_DISCNUM_1                   (0x2UL << ADC_CR1_DISCNUM_Pos)      /*!< 0x00004000 */
#define ADC_CR1_DISCNUM_2                   (0x4UL << ADC_CR1_DISCNUM_Pos)      /*!< 0x00008000 */

#define ADC_CR1_DUALMOD_Pos                 (16U)                              
#define ADC_CR1_DUALMOD_Msk                 (0xFUL << ADC_CR1_DUALMOD_Pos)      /*!< 0x000F0000 */
#define ADC_CR1_DUALMOD                     ADC_CR1_DUALMOD_Msk                 /*!< ADC multimode mode selection */
#define ADC_CR1_DUALMOD_0                   (0x1UL << ADC_CR1_DUALMOD_Pos)      /*!< 0x00010000 */
#define ADC_CR1_DUALMOD_1                   (0x2UL << ADC_CR1_DUALMOD_Pos)      /*!< 0x00020000 */
#define ADC_CR1_DUALMOD_2                   (0x4UL << ADC_CR1_DUALMOD_Pos)      /*!< 0x00040000 */
#define ADC_CR1_DUALMOD_3                   (0x8UL << ADC_CR1_DUALMOD_Pos)      /*!< 0x00080000 */

#define ADC_CR1_JAWDEN_Pos                  (22U)                              
#define ADC_CR1_JAWDEN_Msk                  (0x1UL << ADC_CR1_JAWDEN_Pos)       /*!< 0x00400000 */
#define ADC_CR1_JAWDEN                      ADC_CR1_JAWDEN_Msk                  /*!< ADC analog watchdog 1 enable on scope ADC group injected */
#define ADC_CR1_AWDEN_Pos                   (23U)                              
#define ADC_CR1_AWDEN_Msk                   (0x1UL << ADC_CR1_AWDEN_Pos)        /*!< 0x00800000 */
#define ADC_CR1_AWDEN                       ADC_CR1_AWDEN_Msk                   /*!< ADC analog watchdog 1 enable on scope ADC group regular */

/*******************  Bit definition for ADC_CR2 register  ********************/
#define ADC_CR2_ADON_Pos                    (0U)                               
#define ADC_CR2_ADON_Msk                    (0x1UL << ADC_CR2_ADON_Pos)         /*!< 0x00000001 */
#define ADC_CR2_ADON                        ADC_CR2_ADON_Msk                    /*!< ADC enable */
#define ADC_CR2_CONT_Pos                    (1U)                               
#define ADC_CR2_CONT_Msk                    (0x1UL << ADC_CR2_CONT_Pos)         /*!< 0x00000002 */
#define ADC_CR2_CONT                        ADC_CR2_CONT_Msk                    /*!< ADC group regular continuous conversion mode */
#define ADC_CR2_CAL_Pos                     (2U)                               
#define ADC_CR2_CAL_Msk                     (0x1UL << ADC_CR2_CAL_Pos)          /*!< 0x00000004 */
#define ADC_CR2_CAL                         ADC_CR2_CAL_Msk                     /*!< ADC calibration start */
#define ADC_CR2_RSTCAL_Pos                  (3U)                               
#define ADC_CR2_RSTCAL_Msk                  (0x1UL << ADC_CR2_RSTCAL_Pos)       /*!< 0x00000008 */
#define ADC_CR2_RSTCAL                      ADC_CR2_RSTCAL_Msk                  /*!< ADC calibration reset */
#define ADC_CR2_DMA_Pos                     (8U)                               
#define ADC_CR2_DMA_Msk                     (0x1UL << ADC_CR2_DMA_Pos)          /*!< 0x00000100 */
#define ADC_CR2_DMA                         ADC_CR2_DMA_Msk                     /*!< ADC DMA transfer enable */
#define ADC_CR2_ALIGN_Pos                   (11U)                              
#define ADC_CR2_ALIGN_Msk                   (0x1UL << ADC_CR2_ALIGN_Pos)        /*!< 0x00000800 */
#define ADC_CR2_ALIGN                       ADC_CR2_ALIGN_Msk                   /*!< ADC data alignement */

#define ADC_CR2_JEXTSEL_Pos                 (12U)                              
#define ADC_CR2_JEXTSEL_Msk                 (0x7UL << ADC_CR2_JEXTSEL_Pos)      /*!< 0x00007000 */
#define ADC_CR2_JEXTSEL                     ADC_CR2_JEXTSEL_Msk                 /*!< ADC group injected external trigger source */
#define ADC_CR2_JEXTSEL_0                   (0x1UL << ADC_CR2_JEXTSEL_Pos)      /*!< 0x00001000 */
#define ADC_CR2_JEXTSEL_1                   (0x2UL << ADC_CR2_JEXTSEL_Pos)      /*!< 0x00002000 */
#define ADC_CR2_JEXTSEL_2                   (0x4UL << ADC_CR2_JEXTSEL_Pos)      /*!< 0x00004000 */

#define ADC_CR2_JEXTTRIG_Pos                (15U)                              
#define ADC_CR2_JEXTTRIG_Msk                (0x1UL << ADC_CR2_JEXTTRIG_Pos)     /*!< 0x00008000 */
#define ADC_CR2_JEXTTRIG                    ADC_CR2_JEXTTRIG_Msk                /*!< ADC group injected external trigger enable */

#define ADC_CR2_EXTSEL_Pos                  (17U)                              
#define ADC_CR2_EXTSEL_Msk                  (0x7UL << ADC_CR2_EXTSEL_Pos)       /*!< 0x000E0000 */
#define ADC_CR2_EXTSEL                      ADC_CR2_EXTSEL_Msk                  /*!< ADC group regular external trigger source */
#define ADC_CR2_EXTSEL_0                    (0x1UL << ADC_CR2_EXTSEL_Pos)       /*!< 0x00020000 */
#define ADC_CR2_EXTSEL_1                    (0x2UL << ADC_CR2_EXTSEL_Pos)       /*!< 0x00040000 */
#define ADC_CR2_EXTSEL_2                    (0x4UL << ADC_CR2_EXTSEL_Pos)       /*!< 0x00080000 */

#define ADC_CR2_EXTTRIG_Pos                 (20U)                              
#define ADC_CR2_EXTTRIG_Msk                 (0x1UL << ADC_CR2_EXTTRIG_Pos)      /*!< 0x00100000 */
#define ADC_CR2_EXTTRIG                     ADC_CR2_EXTTRIG_Msk                 /*!< ADC group regular external trigger enable */
#define ADC_CR2_JSWSTART_Pos                (21U)                              
#define ADC_CR2_JSWSTART_Msk                (0x1UL << ADC_CR2_JSWSTART_Pos)     /*!< 0x00200000 */
#define ADC_CR2_JSWSTART                    ADC_CR2_JSWSTART_Msk                /*!< ADC group injected conversion start */
#define ADC_CR2_SWSTART_Pos                 (22U)                              
#define ADC_CR2_SWSTART_Msk                 (0x1UL << ADC_CR2_SWSTART_Pos)      /*!< 0x00400000 */
#define ADC_CR2_SWSTART                     ADC_CR2_SWSTART_Msk                 /*!< ADC group regular conversion start */
#define ADC_CR2_TSVREFE_Pos                 (23U)                              
#define ADC_CR2_TSVREFE_Msk                 (0x1UL << ADC_CR2_TSVREFE_Pos)      /*!< 0x00800000 */
#define ADC_CR2_TSVREFE                     ADC_CR2_TSVREFE_Msk                 /*!< ADC internal path to VrefInt and temperature sensor enable */

/******************  Bit definition for ADC_SMPR1 register  *******************/
#define ADC_SMPR1_SMP10_Pos                 (0U)                               
#define ADC_SMPR1_SMP10_Msk                 (0x7UL << ADC_SMPR1_SMP10_Pos)      /*!< 0x00000007 */
#define ADC_SMPR1_SMP10                     ADC_SMPR1_SMP10_Msk                 /*!< ADC channel 10 sampling time selection  */
#define ADC_SMPR1_SMP10_0                   (0x1UL << ADC_SMPR1_SMP10_Pos)      /*!< 0x00000001 */
#define ADC_SMPR1_SMP10_1                   (0x2UL << ADC_SMPR1_SMP10_Pos)      /*!< 0x00000002 */
#define ADC_SMPR1_SMP10_2                   (0x4UL << ADC_SMPR1_SMP10_Pos)      /*!< 0x00000004 */

#define ADC_SMPR1_SMP11_Pos                 (3U)                               
#define ADC_SMPR1_SMP11_Msk                 (0x7UL << ADC_SMPR1_SMP11_Pos)      /*!< 0x00000038 */
#define ADC_SMPR1_SMP11                     ADC_SMPR1_SMP11_Msk                 /*!< ADC channel 11 sampling time selection  */
#define ADC_SMPR1_SMP11_0                   (0x1UL << ADC_SMPR1_SMP11_Pos)      /*!< 0x00000008 */
#define ADC_SMPR1_SMP11_1                   (0x2UL << ADC_SMPR1_SMP11_Pos)      /*!< 0x00000010 */
#define ADC_SMPR1_SMP11_2                   (0x4UL << ADC_SMPR1_SMP11_Pos)      /*!< 0x00000020 */

#define ADC_SMPR1_SMP12_Pos                 (6U)                               
#define ADC_SMPR1_SMP12_Msk                 (0x7UL << ADC_SMPR1_SMP12_Pos)      /*!< 0x000001C0 */
#define ADC_SMPR1_SMP12                     ADC_SMPR1_SMP12_Msk                 /*!< ADC channel 12 sampling time selection  */
#define ADC_SMPR1_SMP12_0                   (0x1UL << ADC_SMPR1_SMP12_Pos)      /*!< 0x00000040 */
#define ADC_SMPR1_SMP12_1                   (0x2UL << ADC_SMPR1_SMP12_Pos)      /*!< 0x00000080 */
#define ADC_SMPR1_SMP12_2                   (0x4UL << ADC_SMPR1_SMP12_Pos)      /*!< 0x00000100 */

#define ADC_SMPR1_SMP13_Pos                 (9U)                               
#define ADC_SMPR1_SMP13_Msk                 (0x7UL << ADC_SMPR1_SMP13_Pos)      /*!< 0x00000E00 */
#define ADC_SMPR1_SMP13                     ADC_SMPR1_SMP13_Msk                 /*!< ADC channel 13 sampling time selection  */
#define ADC_SMPR1_SMP13_0                   (0x1UL << ADC_SMPR1_SMP13_Pos)      /*!< 0x00000200 */
#define ADC_SMPR1_SMP13_1                   (0x2UL << ADC_SMPR1_SMP13_Pos)      /*!< 0x00000400 */
#define ADC_SMPR1_SMP13_2                   (0x4UL << ADC_SMPR1_SMP13_Pos)      /*!< 0x00000800 */

#define ADC_SMPR1_SMP14_Pos                 (12U)                              
#define ADC_SMPR1_SMP14_Msk                 (0x7UL << ADC_SMPR1_SMP14_Pos)      /*!< 0x00007000 */
#define ADC_SMPR1_SMP14                     ADC_SMPR1_SMP14_Msk                 /*!< ADC channel 14 sampling time selection  */
#define ADC_SMPR1_SMP14_0                   (0x1UL << ADC_SMPR1_SMP14_Pos)      /*!< 0x00001000 */
#define ADC_SMPR1_SMP14_1                   (0x2UL << ADC_SMPR1_SMP14_Pos)      /*!< 0x00002000 */
#define ADC_SMPR1_SMP14_2                   (0x4UL << ADC_SMPR1_SMP14_Pos)      /*!< 0x00004000 */

#define ADC_SMPR1_SMP15_Pos                 (15U)                              
#define ADC_SMPR1_SMP15_Msk                 (0x7UL << ADC_SMPR1_SMP15_Pos)      /*!< 0x00038000 */
#define ADC_SMPR1_SMP15                     ADC_SMPR1_SMP15_Msk                 /*!< ADC channel 15 sampling time selection  */
#define ADC_SMPR1_SMP15_0                   (0x1UL << ADC_SMPR1_SMP15_Pos)      /*!< 0x00008000 */
#define ADC_SMPR1_SMP15_1                   (0x2UL << ADC_SMPR1_SMP15_Pos)      /*!< 0x00010000 */
#define ADC_SMPR1_SMP15_2                   (0x4UL << ADC_SMPR1_SMP15_Pos)      /*!< 0x00020000 */

#define ADC_SMPR1_SMP16_Pos                 (18U)                              
#define ADC_SMPR1_SMP16_Msk                 (0x7UL << ADC_SMPR1_SMP16_Pos)      /*!< 0x001C0000 */
#define ADC_SMPR1_SMP16                     ADC_SMPR1_SMP16_Msk                 /*!< ADC channel 16 sampling time selection  */
#define ADC_SMPR1_SMP16_0                   (0x1UL << ADC_SMPR1_SMP16_Pos)      /*!< 0x00040000 */
#define ADC_SMPR1_SMP16_1                   (0x2UL << ADC_SMPR1_SMP16_Pos)      /*!< 0x00080000 */
#define ADC_SMPR1_SMP16_2                   (0x4UL << ADC_SMPR1_SMP16_Pos)      /*!< 0x00100000 */

#define ADC_SMPR1_SMP17_Pos                 (21U)                              
#define ADC_SMPR1_SMP17_Msk                 (0x7UL << ADC_SMPR1_SMP17_Pos)      /*!< 0x00E00000 */
#define ADC_SMPR1_SMP17                     ADC_SMPR1_SMP17_Msk                 /*!< ADC channel 17 sampling time selection  */
#define ADC_SMPR1_SMP17_0                   (0x1UL << ADC_SMPR1_SMP17_Pos)      /*!< 0x00200000 */
#define ADC_SMPR1_SMP17_1                   (0x2UL << ADC_SMPR1_SMP17_Pos)      /*!< 0x00400000 */
#define ADC_SMPR1_SMP17_2                   (0x4UL << ADC_SMPR1_SMP17_Pos)      /*!< 0x00800000 */

/******************  Bit definition for ADC_SMPR2 register  *******************/
#define ADC_SMPR2_SMP0_Pos                  (0U)                               
#define ADC_SMPR2_SMP0_Msk                  (0x7UL << ADC_SMPR2_SMP0_Pos)       /*!< 0x00000007 */
#define ADC_SMPR2_SMP0                      ADC_SMPR2_SMP0_Msk                  /*!< ADC channel 0 sampling time selection  */
#define ADC_SMPR2_SMP0_0                    (0x1UL << ADC_SMPR2_SMP0_Pos)       /*!< 0x00000001 */
#define ADC_SMPR2_SMP0_1                    (0x2UL << ADC_SMPR2_SMP0_Pos)       /*!< 0x00000002 */
#define ADC_SMPR2_SMP0_2                    (0x4UL << ADC_SMPR2_SMP0_Pos)       /*!< 0x00000004 */

#define ADC_SMPR2_SMP1_Pos                  (3U)                               
#define ADC_SMPR2_SMP1_Msk                  (0x7UL << ADC_SMPR2_SMP1_Pos)       /*!< 0x00000038 */
#define ADC_SMPR2_SMP1                      ADC_SMPR2_SMP1_Msk                  /*!< ADC channel 1 sampling time selection  */
#define ADC_SMPR2_SMP1_0                    (0x1UL << ADC_SMPR2_SMP1_Pos)       /*!< 0x00000008 */
#define ADC_SMPR2_SMP1_1                    (0x2UL << ADC_SMPR2_SMP1_Pos)       /*!< 0x00000010 */
#define ADC_SMPR2_SMP1_2                    (0x4UL << ADC_SMPR2_SMP1_Pos)       /*!< 0x00000020 */

#define ADC_SMPR2_SMP2_Pos                  (6U)                               
#define ADC_SMPR2_SMP2_Msk                  (0x7UL << ADC_SMPR2_SMP2_Pos)       /*!< 0x000001C0 */
#define ADC_SMPR2_SMP2                      ADC_SMPR2_SMP2_Msk                  /*!< ADC channel 2 sampling time selection  */
#define ADC_SMPR2_SMP2_0                    (0x1UL << ADC_SMPR2_SMP2_Pos)       /*!< 0x00000040 */
#define ADC_SMPR2_SMP2_1                    (0x2UL << ADC_SMPR2_SMP2_Pos)       /*!< 0x00000080 */
#define ADC_SMPR2_SMP2_2                    (0x4UL << ADC_SMPR2_SMP2_Pos)       /*!< 0x00000100 */

#define ADC_SMPR2_SMP3_Pos                  (9U)                               
#define ADC_SMPR2_SMP3_Msk                  (0x7UL << ADC_SMPR2_SMP3_Pos)       /*!< 0x00000E00 */
#define ADC_SMPR2_SMP3                      ADC_SMPR2_SMP3_Msk                  /*!< ADC channel 3 sampling time selection  */
#define ADC_SMPR2_SMP3_0                    (0x1UL << ADC_SMPR2_SMP3_Pos)       /*!< 0x00000200 */
#define ADC_SMPR2_SMP3_1                    (0x2UL << ADC_SMPR2_SMP3_Pos)       /*!< 0x00000400 */
#define ADC_SMPR2_SMP3_2                    (0x4UL << ADC_SMPR2_SMP3_Pos)       /*!< 0x00000800 */

#define ADC_SMPR2_SMP4_Pos                  (12U)                              
#define ADC_SMPR2_SMP4_Msk                  (0x7UL << ADC_SMPR2_SMP4_Pos)       /*!< 0x00007000 */
#define ADC_SMPR2_SMP4                      ADC_SMPR2_SMP4_Msk                  /*!< ADC channel 4 sampling time selection  */
#define ADC_SMPR2_SMP4_0                    (0x1UL << ADC_SMPR2_SMP4_Pos)       /*!< 0x00001000 */
#define ADC_SMPR2_SMP4_1                    (0x2UL << ADC_SMPR2_SMP4_Pos)       /*!< 0x00002000 */
#define ADC_SMPR2_SMP4_2                    (0x4UL << ADC_SMPR2_SMP4_Pos)       /*!< 0x00004000 */

#define ADC_SMPR2_SMP5_Pos                  (15U)                              
#define ADC_SMPR2_SMP5_Msk                  (0x7UL << ADC_SMPR2_SMP5_Pos)       /*!< 0x00038000 */
#define ADC_SMPR2_SMP5                      ADC_SMPR2_SMP5_Msk                  /*!< ADC channel 5 sampling time selection  */
#define ADC_SMPR2_SMP5_0                    (0x1UL << ADC_SMPR2_SMP5_Pos)       /*!< 0x00008000 */
#define ADC_SMPR2_SMP5_1                    (0x2UL << ADC_SMPR2_SMP5_Pos)       /*!< 0x00010000 */
#define ADC_SMPR2_SMP5_2                    (0x4UL << ADC_SMPR2_SMP5_Pos)       /*!< 0x00020000 */

#define ADC_SMPR2_SMP6_Pos                  (18U)                              
#define ADC_SMPR2_SMP6_Msk                  (0x7UL << ADC_SMPR2_SMP6_Pos)       /*!< 0x001C0000 */
#define ADC_SMPR2_SMP6                      ADC_SMPR2_SMP6_Msk                  /*!< ADC channel 6 sampling time selection  */
#define ADC_SMPR2_SMP6_0                    (0x1UL << ADC_SMPR2_SMP6_Pos)       /*!< 0x00040000 */
#define ADC_SMPR2_SMP6_1                    (0x2UL << ADC_SMPR2_SMP6_Pos)       /*!< 0x00080000 */
#define ADC_SMPR2_SMP6_2                    (0x4UL << ADC_SMPR2_SMP6_Pos)       /*!< 0x00100000 */

#define ADC_SMPR2_SMP7_Pos                  (21U)                              
#define ADC_SMPR2_SMP7_Msk                  (0x7UL << ADC_SMPR2_SMP7_Pos)       /*!< 0x00E00000 */
#define ADC_SMPR2_SMP7                      ADC_SMPR2_SMP7_Msk                  /*!< ADC channel 7 sampling time selection  */
#define ADC_SMPR2_SMP7_0                    (0x1UL << ADC_SMPR2_SMP7_Pos)       /*!< 0x00200000 */
#define ADC_SMPR2_SMP7_1                    (0x2UL << ADC_SMPR2_SMP7_Pos)       /*!< 0x00400000 */
#define ADC_SMPR2_SMP7_2                    (0x4UL << ADC_SMPR2_SMP7_Pos)       /*!< 0x00800000 */

#define ADC_SMPR2_SMP8_Pos                  (24U)                              
#define ADC_SMPR2_SMP8_Msk                  (0x7UL << ADC_SMPR2_SMP8_Pos)       /*!< 0x07000000 */
#define ADC_SMPR2_SMP8                      ADC_SMPR2_SMP8_Msk                  /*!< ADC channel 8 sampling time selection  */
#define ADC_SMPR2_SMP8_0                    (0x1UL << ADC_SMPR2_SMP8_Pos)       /*!< 0x01000000 */
#define ADC_SMPR2_SMP8_1                    (0x2UL << ADC_SMPR2_SMP8_Pos)       /*!< 0x02000000 */
#define ADC_SMPR2_SMP8_2                    (0x4UL << ADC_SMPR2_SMP8_Pos)       /*!< 0x04000000 */

#define ADC_SMPR2_SMP9_Pos                  (27U)                              
#define ADC_SMPR2_SMP9_Msk                  (0x7UL << ADC_SMPR2_SMP9_Pos)       /*!< 0x38000000 */
#define ADC_SMPR2_SMP9                      ADC_SMPR2_SMP9_Msk                  /*!< ADC channel 9 sampling time selection  */
#define ADC_SMPR2_SMP9_0                    (0x1UL << ADC_SMPR2_SMP9_Pos)       /*!< 0x08000000 */
#define ADC_SMPR2_SMP9_1                    (0x2UL << ADC_SMPR2_SMP9_Pos)       /*!< 0x10000000 */
#define ADC_SMPR2_SMP9_2                    (0x4UL << ADC_SMPR2_SMP9_Pos)       /*!< 0x20000000 */

/******************  Bit definition for ADC_JOFR1 register  *******************/
#define ADC_JOFR1_JOFFSET1_Pos              (0U)                               
#define ADC_JOFR1_JOFFSET1_Msk              (0xFFFUL << ADC_JOFR1_JOFFSET1_Pos) /*!< 0x00000FFF */
#define ADC_JOFR1_JOFFSET1                  ADC_JOFR1_JOFFSET1_Msk              /*!< ADC group injected sequencer rank 1 offset value */

/******************  Bit definition for ADC_JOFR2 register  *******************/
#define ADC_JOFR2_JOFFSET2_Pos              (0U)                               
#define ADC_JOFR2_JOFFSET2_Msk              (0xFFFUL << ADC_JOFR2_JOFFSET2_Pos) /*!< 0x00000FFF */
#define ADC_JOFR2_JOFFSET2                  ADC_JOFR2_JOFFSET2_Msk              /*!< ADC group injected sequencer rank 2 offset value */

/******************  Bit definition for ADC_JOFR3 register  *******************/
#define ADC_JOFR3_JOFFSET3_Pos              (0U)                               
#define ADC_JOFR3_JOFFSET3_Msk              (0xFFFUL << ADC_JOFR3_JOFFSET3_Pos) /*!< 0x00000FFF */
#define ADC_JOFR3_JOFFSET3                  ADC_JOFR3_JOFFSET3_Msk              /*!< ADC group injected sequencer rank 3 offset value */

/******************  Bit definition for ADC_JOFR4 register  *******************/
#define ADC_JOFR4_JOFFSET4_Pos              (0U)                               
#define ADC_JOFR4_JOFFSET4_Msk              (0xFFFUL << ADC_JOFR4_JOFFSET4_Pos) /*!< 0x00000FFF */
#define ADC_JOFR4_JOFFSET4                  ADC_JOFR4_JOFFSET4_Msk              /*!< ADC group injected sequencer rank 4 offset value */

/*******************  Bit definition for ADC_HTR register  ********************/
#define ADC_HTR_HT_Pos                      (0U)                               
#define ADC_HTR_HT_Msk                      (0xFFFUL << ADC_HTR_HT_Pos)         /*!< 0x00000FFF */
#define ADC_HTR_HT                          ADC_HTR_HT_Msk                      /*!< ADC analog watchdog 1 threshold high */

/*******************  Bit definition for ADC_LTR register  ********************/
#define ADC_LTR_LT_Pos                      (0U)                               
#define ADC_LTR_LT_Msk                      (0xFFFUL << ADC_LTR_LT_Pos)         /*!< 0x00000FFF */
#define ADC_LTR_LT                          ADC_LTR_LT_Msk                      /*!< ADC analog watchdog 1 threshold low */

/*******************  Bit definition for ADC_SQR1 register  *******************/
#define ADC_SQR1_SQ13_Pos                   (0U)                               
#define ADC_SQR1_SQ13_Msk                   (0x1FUL << ADC_SQR1_SQ13_Pos)       /*!< 0x0000001F */
#define ADC_SQR1_SQ13                       ADC_SQR1_SQ13_Msk                   /*!< ADC group regular sequencer rank 13 */
#define ADC_SQR1_SQ13_0                     (0x01UL << ADC_SQR1_SQ13_Pos)       /*!< 0x00000001 */
#define ADC_SQR1_SQ13_1                     (0x02UL << ADC_SQR1_SQ13_Pos)       /*!< 0x00000002 */
#define ADC_SQR1_SQ13_2                     (0x04UL << ADC_SQR1_SQ13_Pos)       /*!< 0x00000004 */
#define ADC_SQR1_SQ13_3                     (0x08UL << ADC_SQR1_SQ13_Pos)       /*!< 0x00000008 */
#define ADC_SQR1_SQ13_4                     (0x10UL << ADC_SQR1_SQ13_Pos)       /*!< 0x00000010 */

#define ADC_SQR1_SQ14_Pos                   (5U)                               
#define ADC_SQR1_SQ14_Msk                   (0x1FUL << ADC_SQR1_SQ14_Pos)       /*!< 0x000003E0 */
#define ADC_SQR1_SQ14                       ADC_SQR1_SQ14_Msk                   /*!< ADC group regular sequencer rank 14 */
#define ADC_SQR1_SQ14_0                     (0x01UL << ADC_SQR1_SQ14_Pos)       /*!< 0x00000020 */
#define ADC_SQR1_SQ14_1                     (0x02UL << ADC_SQR1_SQ14_Pos)       /*!< 0x00000040 */
#define ADC_SQR1_SQ14_2                     (0x04UL << ADC_SQR1_SQ14_Pos)       /*!< 0x00000080 */
#define ADC_SQR1_SQ14_3                     (0x08UL << ADC_SQR1_SQ14_Pos)       /*!< 0x00000100 */
#define ADC_SQR1_SQ14_4                     (0x10UL << ADC_SQR1_SQ14_Pos)       /*!< 0x00000200 */

#define ADC_SQR1_SQ15_Pos                   (10U)                              
#define ADC_SQR1_SQ15_Msk                   (0x1FUL << ADC_SQR1_SQ15_Pos)       /*!< 0x00007C00 */
#define ADC_SQR1_SQ15                       ADC_SQR1_SQ15_Msk                   /*!< ADC group regular sequencer rank 15 */
#define ADC_SQR1_SQ15_0                     (0x01UL << ADC_SQR1_SQ15_Pos)       /*!< 0x00000400 */
#define ADC_SQR1_SQ15_1                     (0x02UL << ADC_SQR1_SQ15_Pos)       /*!< 0x00000800 */
#define ADC_SQR1_SQ15_2                     (0x04UL << ADC_SQR1_SQ15_Pos)       /*!< 0x00001000 */
#define ADC_SQR1_SQ15_3                     (0x08UL << ADC_SQR1_SQ15_Pos)       /*!< 0x00002000 */
#define ADC_SQR1_SQ15_4                     (0x10UL << ADC_SQR1_SQ15_Pos)       /*!< 0x00004000 */

#define ADC_SQR1_SQ16_Pos                   (15U)                              
#define ADC_SQR1_SQ16_Msk                   (0x1FUL << ADC_SQR1_SQ16_Pos)       /*!< 0x000F8000 */
#define ADC_SQR1_SQ16                       ADC_SQR1_SQ16_Msk                   /*!< ADC group regular sequencer rank 16 */
#define ADC_SQR1_SQ16_0                     (0x01UL << ADC_SQR1_SQ16_Pos)       /*!< 0x00008000 */
#define ADC_SQR1_SQ16_1                     (0x02UL << ADC_SQR1_SQ16_Pos)       /*!< 0x00010000 */
#define ADC_SQR1_SQ16_2                     (0x04UL << ADC_SQR1_SQ16_Pos)       /*!< 0x00020000 */
#define ADC_SQR1_SQ16_3                     (0x08UL << ADC_SQR1_SQ16_Pos)       /*!< 0x00040000 */
#define ADC_SQR1_SQ16_4                     (0x10UL << ADC_SQR1_SQ16_Pos)       /*!< 0x00080000 */

#define ADC_SQR1_L_Pos                      (20U)                              
#define ADC_SQR1_L_Msk                      (0xFUL << ADC_SQR1_L_Pos)           /*!< 0x00F00000 */
#define ADC_SQR1_L                          ADC_SQR1_L_Msk                      /*!< ADC group regular sequencer scan length */
#define ADC_SQR1_L_0                        (0x1UL << ADC_SQR1_L_Pos)           /*!< 0x00100000 */
#define ADC_SQR1_L_1                        (0x2UL << ADC_SQR1_L_Pos)           /*!< 0x00200000 */
#define ADC_SQR1_L_2                        (0x4UL << ADC_SQR1_L_Pos)           /*!< 0x00400000 */
#define ADC_SQR1_L_3                        (0x8UL << ADC_SQR1_L_Pos)           /*!< 0x00800000 */

/*******************  Bit definition for ADC_SQR2 register  *******************/
#define ADC_SQR2_SQ7_Pos                    (0U)                               
#define ADC_SQR2_SQ7_Msk                    (0x1FUL << ADC_SQR2_SQ7_Pos)        /*!< 0x0000001F */
#define ADC_SQR2_SQ7                        ADC_SQR2_SQ7_Msk                    /*!< ADC group regular sequencer rank 7 */
#define ADC_SQR2_SQ7_0                      (0x01UL << ADC_SQR2_SQ7_Pos)        /*!< 0x00000001 */
#define ADC_SQR2_SQ7_1                      (0x02UL << ADC_SQR2_SQ7_Pos)        /*!< 0x00000002 */
#define ADC_SQR2_SQ7_2                      (0x04UL << ADC_SQR2_SQ7_Pos)        /*!< 0x00000004 */
#define ADC_SQR2_SQ7_3                      (0x08UL << ADC_SQR2_SQ7_Pos)        /*!< 0x00000008 */
#define ADC_SQR2_SQ7_4                      (0x10UL << ADC_SQR2_SQ7_Pos)        /*!< 0x00000010 */

#define ADC_SQR2_SQ8_Pos                    (5U)                               
#define ADC_SQR2_SQ8_Msk                    (0x1FUL << ADC_SQR2_SQ8_Pos)        /*!< 0x000003E0 */
#define ADC_SQR2_SQ8                        ADC_SQR2_SQ8_Msk                    /*!< ADC group regular sequencer rank 8 */
#define ADC_SQR2_SQ8_0                      (0x01UL << ADC_SQR2_SQ8_Pos)        /*!< 0x00000020 */
#define ADC_SQR2_SQ8_1                      (0x02UL << ADC_SQR2_SQ8_Pos)        /*!< 0x00000040 */
#define ADC_SQR2_SQ8_2                      (0x04UL << ADC_SQR2_SQ8_Pos)        /*!< 0x00000080 */
#define ADC_SQR2_SQ8_3                      (0x08UL << ADC_SQR2_SQ8_Pos)        /*!< 0x00000100 */
#define ADC_SQR2_SQ8_4                      (0x10UL << ADC_SQR2_SQ8_Pos)        /*!< 0x00000200 */

#define ADC_SQR2_SQ9_Pos                    (10U)                              
#define ADC_SQR2_SQ9_Msk                    (0x1FUL << ADC_SQR2_SQ9_Pos)        /*!< 0x00007C00 */
#define ADC_SQR2_SQ9                        ADC_SQR2_SQ9_Msk                    /*!< ADC group regular sequencer rank 9 */
#define ADC_SQR2_SQ9_0                      (0x01UL << ADC_SQR2_SQ9_Pos)        /*!< 0x00000400 */
#define ADC_SQR2_SQ9_1                      (0x02UL << ADC_SQR2_SQ9_Pos)        /*!< 0x00000800 */
#define ADC_SQR2_SQ9_2                      (0x04UL << ADC_SQR2_SQ9_Pos)        /*!< 0x00001000 */
#define ADC_SQR2_SQ9_3                      (0x08UL << ADC_SQR2_SQ9_Pos)        /*!< 0x00002000 */
#define ADC_SQR2_SQ9_4                      (0x10UL << ADC_SQR2_SQ9_Pos)        /*!< 0x00004000 */

#define ADC_SQR2_SQ10_Pos                   (15U)                              
#define ADC_SQR2_SQ10_Msk                   (0x1FUL << ADC_SQR2_SQ10_Pos)       /*!< 0x000F8000 */
#define ADC_SQR2_SQ10                       ADC_SQR2_SQ10_Msk                   /*!< ADC group regular sequencer rank 10 */
#define ADC_SQR2_SQ10_0                     (0x01UL << ADC_SQR2_SQ10_Pos)       /*!< 0x00008000 */
#define ADC_SQR2_SQ10_1                     (0x02UL << ADC_SQR2_SQ10_Pos)       /*!< 0x00010000 */
#define ADC_SQR2_SQ10_2                     (0x04UL << ADC_SQR2_SQ10_Pos)       /*!< 0x00020000 */
#define ADC_SQR2_SQ10_3                     (0x08UL << ADC_SQR2_SQ10_Pos)       /*!< 0x00040000 */
#define ADC_SQR2_SQ10_4                     (0x10UL << ADC_SQR2_SQ10_Pos)       /*!< 0x00080000 */

#define ADC_SQR2_SQ11_Pos                   (20U)                              
#define ADC_SQR2_SQ11_Msk                   (0x1FUL << ADC_SQR2_SQ11_Pos)       /*!< 0x01F00000 */
#define ADC_SQR2_SQ11                       ADC_SQR2_SQ11_Msk                   /*!< ADC group regular sequencer rank 1 */
#define ADC_SQR2_SQ11_0                     (0x01UL << ADC_SQR2_SQ11_Pos)       /*!< 0x00100000 */
#define ADC_SQR2_SQ11_1                     (0x02UL << ADC_SQR2_SQ11_Pos)       /*!< 0x00200000 */
#define ADC_SQR2_SQ11_2                     (0x04UL << ADC_SQR2_SQ11_Pos)       /*!< 0x00400000 */
#define ADC_SQR2_SQ11_3                     (0x08UL << ADC_SQR2_SQ11_Pos)       /*!< 0x00800000 */
#define ADC_SQR2_SQ11_4                     (0x10UL << ADC_SQR2_SQ11_Pos)       /*!< 0x01000000 */

#define ADC_SQR2_SQ12_Pos                   (25U)                              
#define ADC_SQR2_SQ12_Msk                   (0x1FUL << ADC_SQR2_SQ12_Pos)       /*!< 0x3E000000 */
#define ADC_SQR2_SQ12                       ADC_SQR2_SQ12_Msk                   /*!< ADC group regular sequencer rank 12 */
#define ADC_SQR2_SQ12_0                     (0x01UL << ADC_SQR2_SQ12_Pos)       /*!< 0x02000000 */
#define ADC_SQR2_SQ12_1                     (0x02UL << ADC_SQR2_SQ12_Pos)       /*!< 0x04000000 */
#define ADC_SQR2_SQ12_2                     (0x04UL << ADC_SQR2_SQ12_Pos)       /*!< 0x08000000 */
#define ADC_SQR2_SQ12_3                     (0x08UL << ADC_SQR2_SQ12_Pos)       /*!< 0x10000000 */
#define ADC_SQR2_SQ12_4                     (0x10UL << ADC_SQR2_SQ12_Pos)       /*!< 0x20000000 */

/*******************  Bit definition for ADC_SQR3 register  *******************/
#define ADC_SQR3_SQ1_Pos                    (0U)                               
#define ADC_SQR3_SQ1_Msk                    (0x1FUL << ADC_SQR3_SQ1_Pos)        /*!< 0x0000001F */
#define ADC_SQR3_SQ1                        ADC_SQR3_SQ1_Msk                    /*!< ADC group regular sequencer rank 1 */
#define ADC_SQR3_SQ1_0                      (0x01UL << ADC_SQR3_SQ1_Pos)        /*!< 0x00000001 */
#define ADC_SQR3_SQ1_1                      (0x02UL << ADC_SQR3_SQ1_Pos)        /*!< 0x00000002 */
#define ADC_SQR3_SQ1_2                      (0x04UL << ADC_SQR3_SQ1_Pos)        /*!< 0x00000004 */
#define ADC_SQR3_SQ1_3                      (0x08UL << ADC_SQR3_SQ1_Pos)        /*!< 0x00000008 */
#define ADC_SQR3_SQ1_4                      (0x10UL << ADC_SQR3_SQ1_Pos)        /*!< 0x00000010 */

#define ADC_SQR3_SQ2_Pos                    (5U)                               
#define ADC_SQR3_SQ2_Msk                    (0x1FUL << ADC_SQR3_SQ2_Pos)        /*!< 0x000003E0 */
#define ADC_SQR3_SQ2                        ADC_SQR3_SQ2_Msk                    /*!< ADC group regular sequencer rank 2 */
#define ADC_SQR3_SQ2_0                      (0x01UL << ADC_SQR3_SQ2_Pos)        /*!< 0x00000020 */
#define ADC_SQR3_SQ2_1                      (0x02UL << ADC_SQR3_SQ2_Pos)        /*!< 0x00000040 */
#define ADC_SQR3_SQ2_2                      (0x04UL << ADC_SQR3_SQ2_Pos)        /*!< 0x00000080 */
#define ADC_SQR3_SQ2_3                      (0x08UL << ADC_SQR3_SQ2_Pos)        /*!< 0x00000100 */
#define ADC_SQR3_SQ2_4                      (0x10UL << ADC_SQR3_SQ2_Pos)        /*!< 0x00000200 */

#define ADC_SQR3_SQ3_Pos                    (10U)                              
#define ADC_SQR3_SQ3_Msk                    (0x1FUL << ADC_SQR3_SQ3_Pos)        /*!< 0x00007C00 */
#define ADC_SQR3_SQ3                        ADC_SQR3_SQ3_Msk                    /*!< ADC group regular sequencer rank 3 */
#define ADC_SQR3_SQ3_0                      (0x01UL << ADC_SQR3_SQ3_Pos)        /*!< 0x00000400 */
#define ADC_SQR3_SQ3_1                      (0x02UL << ADC_SQR3_SQ3_Pos)        /*!< 0x00000800 */
#define ADC_SQR3_SQ3_2                      (0x04UL << ADC_SQR3_SQ3_Pos)        /*!< 0x00001000 */
#define ADC_SQR3_SQ3_3                      (0x08UL << ADC_SQR3_SQ3_Pos)        /*!< 0x00002000 */
#define ADC_SQR3_SQ3_4                      (0x10UL << ADC_SQR3_SQ3_Pos)        /*!< 0x00004000 */

#define ADC_SQR3_SQ4_Pos                    (15U)                              
#define ADC_SQR3_SQ4_Msk                    (0x1FUL << ADC_SQR3_SQ4_Pos)        /*!< 0x000F8000 */
#define ADC_SQR3_SQ4                        ADC_SQR3_SQ4_Msk                    /*!< ADC group regular sequencer rank 4 */
#define ADC_SQR3_SQ4_0                      (0x01UL << ADC_SQR3_SQ4_Pos)        /*!< 0x00008000 */
#define ADC_SQR3_SQ4_1                      (0x02UL << ADC_SQR3_SQ4_Pos)        /*!< 0x00010000 */
#define ADC_SQR3_SQ4_2                      (0x04UL << ADC_SQR3_SQ4_Pos)        /*!< 0x00020000 */
#define ADC_SQR3_SQ4_3                      (0x08UL << ADC_SQR3_SQ4_Pos)        /*!< 0x00040000 */
#define ADC_SQR3_SQ4_4                      (0x10UL << ADC_SQR3_SQ4_Pos)        /*!< 0x00080000 */

#define ADC_SQR3_SQ5_Pos                    (20U)                              
#define ADC_SQR3_SQ5_Msk                    (0x1FUL << ADC_SQR3_SQ5_Pos)        /*!< 0x01F00000 */
#define ADC_SQR3_SQ5                        ADC_SQR3_SQ5_Msk                    /*!< ADC group regular sequencer rank 5 */
#define ADC_SQR3_SQ5_0                      (0x01UL << ADC_SQR3_SQ5_Pos)        /*!< 0x00100000 */
#define ADC_SQR3_SQ5_1                      (0x02UL << ADC_SQR3_SQ5_Pos)        /*!< 0x00200000 */
#define ADC_SQR3_SQ5_2                      (0x04UL << ADC_SQR3_SQ5_Pos)        /*!< 0x00400000 */
#define ADC_SQR3_SQ5_3                      (0x08UL << ADC_SQR3_SQ5_Pos)        /*!< 0x00800000 */
#define ADC_SQR3_SQ5_4                      (0x10UL << ADC_SQR3_SQ5_Pos)        /*!< 0x01000000 */

#define ADC_SQR3_SQ6_Pos                    (25U)                              
#define ADC_SQR3_SQ6_Msk                    (0x1FUL << ADC_SQR3_SQ6_Pos)        /*!< 0x3E000000 */
#define ADC_SQR3_SQ6                        ADC_SQR3_SQ6_Msk                    /*!< ADC group regular sequencer rank 6 */
#define ADC_SQR3_SQ6_0                      (0x01UL << ADC_SQR3_SQ6_Pos)        /*!< 0x02000000 */
#define ADC_SQR3_SQ6_1                      (0x02UL << ADC_SQR3_SQ6_Pos)        /*!< 0x04000000 */
#define ADC_SQR3_SQ6_2                      (0x04UL << ADC_SQR3_SQ6_Pos)        /*!< 0x08000000 */
#define ADC_SQR3_SQ6_3                      (0x08UL << ADC_SQR3_SQ6_Pos)        /*!< 0x10000000 */
#define ADC_SQR3_SQ6_4                      (0x10UL << ADC_SQR3_SQ6_Pos)        /*!< 0x20000000 */

/*******************  Bit definition for ADC_JSQR register  *******************/
#define ADC_JSQR_JSQ1_Pos                   (0U)                               
#define ADC_JSQR_JSQ1_Msk                   (0x1FUL << ADC_JSQR_JSQ1_Pos)       /*!< 0x0000001F */
#define ADC_JSQR_JSQ1                       ADC_JSQR_JSQ1_Msk                   /*!< ADC group injected sequencer rank 1 */
#define ADC_JSQR_JSQ1_0                     (0x01UL << ADC_JSQR_JSQ1_Pos)       /*!< 0x00000001 */
#define ADC_JSQR_JSQ1_1                     (0x02UL << ADC_JSQR_JSQ1_Pos)       /*!< 0x00000002 */
#define ADC_JSQR_JSQ1_2                     (0x04UL << ADC_JSQR_JSQ1_Pos)       /*!< 0x00000004 */
#define ADC_JSQR_JSQ1_3                     (0x08UL << ADC_JSQR_JSQ1_Pos)       /*!< 0x00000008 */
#define ADC_JSQR_JSQ1_4                     (0x10UL << ADC_JSQR_JSQ1_Pos)       /*!< 0x00000010 */

#define ADC_JSQR_JSQ2_Pos                   (5U)                               
#define ADC_JSQR_JSQ2_Msk                   (0x1FUL << ADC_JSQR_JSQ2_Pos)       /*!< 0x000003E0 */
#define ADC_JSQR_JSQ2                       ADC_JSQR_JSQ2_Msk                   /*!< ADC group injected sequencer rank 2 */
#define ADC_JSQR_JSQ2_0                     (0x01UL << ADC_JSQR_JSQ2_Pos)       /*!< 0x00000020 */
#define ADC_JSQR_JSQ2_1                     (0x02UL << ADC_JSQR_JSQ2_Pos)       /*!< 0x00000040 */
#define ADC_JSQR_JSQ2_2                     (0x04UL << ADC_JSQR_JSQ2_Pos)       /*!< 0x00000080 */
#define ADC_JSQR_JSQ2_3                     (0x08UL << ADC_JSQR_JSQ2_Pos)       /*!< 0x00000100 */
#define ADC_JSQR_JSQ2_4                     (0x10UL << ADC_JSQR_JSQ2_Pos)       /*!< 0x00000200 */

#define ADC_JSQR_JSQ3_Pos                   (10U)                              
#define ADC_JSQR_JSQ3_Msk                   (0x1FUL << ADC_JSQR_JSQ3_Pos)       /*!< 0x00007C00 */
#define ADC_JSQR_JSQ3                       ADC_JSQR_JSQ3_Msk                   /*!< ADC group injected sequencer rank 3 */
#define ADC_JSQR_JSQ3_0                     (0x01UL << ADC_JSQR_JSQ3_Pos)       /*!< 0x00000400 */
#define ADC_JSQR_JSQ3_1                     (0x02UL << ADC_JSQR_JSQ3_Pos)       /*!< 0x00000800 */
#define ADC_JSQR_JSQ3_2                     (0x04UL << ADC_JSQR_JSQ3_Pos)       /*!< 0x00001000 */
#define ADC_JSQR_JSQ3_3                     (0x08UL << ADC_JSQR_JSQ3_Pos)       /*!< 0x00002000 */
#define ADC_JSQR_JSQ3_4                     (0x10UL << ADC_JSQR_JSQ3_Pos)       /*!< 0x00004000 */

#define ADC_JSQR_JSQ4_Pos                   (15U)                              
#define ADC_JSQR_JSQ4_Msk                   (0x1FUL << ADC_JSQR_JSQ4_Pos)       /*!< 0x000F8000 */
#define ADC_JSQR_JSQ4                       ADC_JSQR_JSQ4_Msk                   /*!< ADC group injected sequencer rank 4 */
#define ADC_JSQR_JSQ4_0                     (0x01UL << ADC_JSQR_JSQ4_Pos)       /*!< 0x00008000 */
#define ADC_JSQR_JSQ4_1                     (0x02UL << ADC_JSQR_JSQ4_Pos)       /*!< 0x00010000 */
#define ADC_JSQR_JSQ4_2                     (0x04UL << ADC_JSQR_JSQ4_Pos)       /*!< 0x00020000 */
#define ADC_JSQR_JSQ4_3                     (0x08UL << ADC_JSQR_JSQ4_Pos)       /*!< 0x00040000 */
#define ADC_JSQR_JSQ4_4                     (0x10UL << ADC_JSQR_JSQ4_Pos)       /*!< 0x00080000 */

#define ADC_JSQR_JL_Pos                     (20U)                              
#define ADC_JSQR_JL_Msk                     (0x3UL << ADC_JSQR_JL_Pos)          /*!< 0x00300000 */
#define ADC_JSQR_JL                         ADC_JSQR_JL_Msk                     /*!< ADC group injected sequencer scan length */
#define ADC_JSQR_JL_0                       (0x1UL << ADC_JSQR_JL_Pos)          /*!< 0x00100000 */
#define ADC_JSQR_JL_1                       (0x2UL << ADC_JSQR_JL_Pos)          /*!< 0x00200000 */

/*******************  Bit definition for ADC_JDR1 register  *******************/
#define ADC_JDR1_JDATA_Pos                  (0U)                               
#define ADC_JDR1_JDATA_Msk                  (0xFFFFUL << ADC_JDR1_JDATA_Pos)    /*!< 0x0000FFFF */
#define ADC_JDR1_JDATA                      ADC_JDR1_JDATA_Msk                  /*!< ADC group injected sequencer rank 1 conversion data */

/*******************  Bit definition for ADC_JDR2 register  *******************/
#define ADC_JDR2_JDATA_Pos                  (0U)                               
#define ADC_JDR2_JDATA_Msk                  (0xFFFFUL << ADC_JDR2_JDATA_Pos)    /*!< 0x0000FFFF */
#define ADC_JDR2_JDATA                      ADC_JDR2_JDATA_Msk                  /*!< ADC group injected sequencer rank 2 conversion data */

/*******************  Bit definition for ADC_JDR3 register  *******************/
#define ADC_JDR3_JDATA_Pos                  (0U)                               
#define ADC_JDR3_JDATA_Msk                  (0xFFFFUL << ADC_JDR3_JDATA_Pos)    /*!< 0x0000FFFF */
#define ADC_JDR3_JDATA                      ADC_JDR3_JDATA_Msk                  /*!< ADC group injected sequencer rank 3 conversion data */

/*******************  Bit definition for ADC_JDR4 register  *******************/
#define ADC_JDR4_JDATA_Pos                  (0U)                               
#define ADC_JDR4_JDATA_Msk                  (0xFFFFUL << ADC_JDR4_JDATA_Pos)    /*!< 0x0000FFFF */
#define ADC_JDR4_JDATA                      ADC_JDR4_JDATA_Msk                  /*!< ADC group injected sequencer rank 4 conversion data */

/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_DATA_Pos                     (0U)                               
#define ADC_DR_DATA_Msk                     (0xFFFFUL << ADC_DR_DATA_Pos)       /*!< 0x0000FFFF */
#define ADC_DR_DATA                         ADC_DR_DATA_Msk                     /*!< ADC group regular conversion data */
#define ADC_DR_ADC2DATA_Pos                 (16U)                              
#define ADC_DR_ADC2DATA_Msk                 (0xFFFFUL << ADC_DR_ADC2DATA_Pos)   /*!< 0xFFFF0000 */
#define ADC_DR_ADC2DATA                     ADC_DR_ADC2DATA_Msk                 /*!< ADC group regular conversion data for ADC slave, in multimode */

/******************************************************************************/
/*                                                                            */
/*                    Digital to Analog Converter (DAC)                       */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for DAC_CR register  ********************/
#define DAC_CR_EN1_Pos                      (0U)                               
#define DAC_CR_EN1_Msk                      (0x1UL << DAC_CR_EN1_Pos)           /*!< 0x00000001 */
#define DAC_CR_EN1                          DAC_CR_EN1_Msk                      /*!< DAC channel1 enable */
#define DAC_CR_BOFF1_Pos                    (1U)                               
#define DAC_CR_BOFF1_Msk                    (0x1UL << DAC_CR_BOFF1_Pos)         /*!< 0x00000002 */
#define DAC_CR_BOFF1                        DAC_CR_BOFF1_Msk                    /*!< DAC channel1 output buffer disable */
#define DAC_CR_TEN1_Pos                     (2U)                               
#define DAC_CR_TEN1_Msk                     (0x1UL << DAC_CR_TEN1_Pos)          /*!< 0x00000004 */
#define DAC_CR_TEN1                         DAC_CR_TEN1_Msk                     /*!< DAC channel1 Trigger enable */

#define DAC_CR_TSEL1_Pos                    (3U)                               
#define DAC_CR_TSEL1_Msk                    (0x7UL << DAC_CR_TSEL1_Pos)         /*!< 0x00000038 */
#define DAC_CR_TSEL1                        DAC_CR_TSEL1_Msk                    /*!< TSEL1[2:0] (DAC channel1 Trigger selection) */
#define DAC_CR_TSEL1_0                      (0x1UL << DAC_CR_TSEL1_Pos)         /*!< 0x00000008 */
#define DAC_CR_TSEL1_1                      (0x2UL << DAC_CR_TSEL1_Pos)         /*!< 0x00000010 */
#define DAC_CR_TSEL1_2                      (0x4UL << DAC_CR_TSEL1_Pos)         /*!< 0x00000020 */

#define DAC_CR_WAVE1_Pos                    (6U)                               
#define DAC_CR_WAVE1_Msk                    (0x3UL << DAC_CR_WAVE1_Pos)         /*!< 0x000000C0 */
#define DAC_CR_WAVE1                        DAC_CR_WAVE1_Msk                    /*!< WAVE1[1:0] (DAC channel1 noise/triangle wave generation enable) */
#define DAC_CR_WAVE1_0                      (0x1UL << DAC_CR_WAVE1_Pos)         /*!< 0x00000040 */
#define DAC_CR_WAVE1_1                      (0x2UL << DAC_CR_WAVE1_Pos)         /*!< 0x00000080 */

#define DAC_CR_MAMP1_Pos                    (8U)                               
#define DAC_CR_MAMP1_Msk                    (0xFUL << DAC_CR_MAMP1_Pos)         /*!< 0x00000F00 */
#define DAC_CR_MAMP1                        DAC_CR_MAMP1_Msk                    /*!< MAMP1[3:0] (DAC channel1 Mask/Amplitude selector) */
#define DAC_CR_MAMP1_0                      (0x1UL << DAC_CR_MAMP1_Pos)         /*!< 0x00000100 */
#define DAC_CR_MAMP1_1                      (0x2UL << DAC_CR_MAMP1_Pos)         /*!< 0x00000200 */
#define DAC_CR_MAMP1_2                      (0x4UL << DAC_CR_MAMP1_Pos)         /*!< 0x00000400 */
#define DAC_CR_MAMP1_3                      (0x8UL << DAC_CR_MAMP1_Pos)         /*!< 0x00000800 */

#define DAC_CR_DMAEN1_Pos                   (12U)                              
#define DAC_CR_DMAEN1_Msk                   (0x1UL << DAC_CR_DMAEN1_Pos)        /*!< 0x00001000 */
#define DAC_CR_DMAEN1                       DAC_CR_DMAEN1_Msk                   /*!< DAC channel1 DMA enable */
#define DAC_CR_EN2_Pos                      (16U)                              
#define DAC_CR_EN2_Msk                      (0x1UL << DAC_CR_EN2_Pos)           /*!< 0x00010000 */
#define DAC_CR_EN2                          DAC_CR_EN2_Msk                      /*!< DAC channel2 enable */
#define DAC_CR_BOFF2_Pos                    (17U)                              
#define DAC_CR_BOFF2_Msk                    (0x1UL << DAC_CR_BOFF2_Pos)         /*!< 0x00020000 */
#define DAC_CR_BOFF2                        DAC_CR_BOFF2_Msk                    /*!< DAC channel2 output buffer disable */
#define DAC_CR_TEN2_Pos                     (18U)                              
#define DAC_CR_TEN2_Msk                     (0x1UL << DAC_CR_TEN2_Pos)          /*!< 0x00040000 */
#define DAC_CR_TEN2                         DAC_CR_TEN2_Msk                     /*!< DAC channel2 Trigger enable */

#define DAC_CR_TSEL2_Pos                    (19U)                              
#define DAC_CR_TSEL2_Msk                    (0x7UL << DAC_CR_TSEL2_Pos)         /*!< 0x00380000 */
#define DAC_CR_TSEL2                        DAC_CR_TSEL2_Msk                    /*!< TSEL2[2:0] (DAC channel2 Trigger selection) */
#define DAC_CR_TSEL2_0                      (0x1UL << DAC_CR_TSEL2_Pos)         /*!< 0x00080000 */
#define DAC_CR_TSEL2_1                      (0x2UL << DAC_CR_TSEL2_Pos)         /*!< 0x00100000 */
#define DAC_CR_TSEL2_2                      (0x4UL << DAC_CR_TSEL2_Pos)         /*!< 0x00200000 */

#define DAC_CR_WAVE2_Pos                    (22U)                              
#define DAC_CR_WAVE2_Msk                    (0x3UL << DAC_CR_WAVE2_Pos)         /*!< 0x00C00000 */
#define DAC_CR_WAVE2                        DAC_CR_WAVE2_Msk                    /*!< WAVE2[1:0] (DAC channel2 noise/triangle wave generation enable) */
#define DAC_CR_WAVE2_0                      (0x1UL << DAC_CR_WAVE2_Pos)         /*!< 0x00400000 */
#define DAC_CR_WAVE2_1                      (0x2UL << DAC_CR_WAVE2_Pos)         /*!< 0x00800000 */

#define DAC_CR_MAMP2_Pos                    (24U)                              
#define DAC_CR_MAMP2_Msk                    (0xFUL << DAC_CR_MAMP2_Pos)         /*!< 0x0F000000 */
#define DAC_CR_MAMP2                        DAC_CR_MAMP2_Msk                    /*!< MAMP2[3:0] (DAC channel2 Mask/Amplitude selector) */
#define DAC_CR_MAMP2_0                      (0x1UL << DAC_CR_MAMP2_Pos)         /*!< 0x01000000 */
#define DAC_CR_MAMP2_1                      (0x2UL << DAC_CR_MAMP2_Pos)         /*!< 0x02000000 */
#define DAC_CR_MAMP2_2                      (0x4UL << DAC_CR_MAMP2_Pos)         /*!< 0x04000000 */
#define DAC_CR_MAMP2_3                      (0x8UL << DAC_CR_MAMP2_Pos)         /*!< 0x08000000 */

#define DAC_CR_DMAEN2_Pos                   (28U)                              
#define DAC_CR_DMAEN2_Msk                   (0x1UL << DAC_CR_DMAEN2_Pos)        /*!< 0x10000000 */
#define DAC_CR_DMAEN2                       DAC_CR_DMAEN2_Msk                   /*!< DAC channel2 DMA enabled */

/*****************  Bit definition for DAC_SWTRIGR register  ******************/
#define DAC_SWTRIGR_SWTRIG1_Pos             (0U)                               
#define DAC_SWTRIGR_SWTRIG1_Msk             (0x1UL << DAC_SWTRIGR_SWTRIG1_Pos)    /*!< 0x00000001 */
#define DAC_SWTRIGR_SWTRIG1                 DAC_SWTRIGR_SWTRIG1_Msk               /*!< DAC channel1 software trigger */
#define DAC_SWTRIGR_SWTRIG2_Pos             (1U)                               
#define DAC_SWTRIGR_SWTRIG2_Msk             (0x1UL << DAC_SWTRIGR_SWTRIG2_Pos)    /*!< 0x00000002 */
#define DAC_SWTRIGR_SWTRIG2                 DAC_SWTRIGR_SWTRIG2_Msk               /*!< DAC channel2 software trigger */

/*****************  Bit definition for DAC_DHR12R1 register  ******************/
#define DAC_DHR12R1_DACC1DHR_Pos            (0U)                               
#define DAC_DHR12R1_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12R1_DACC1DHR_Pos) /*!< 0x00000FFF */
#define DAC_DHR12R1_DACC1DHR                DAC_DHR12R1_DACC1DHR_Msk              /*!< DAC channel1 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L1 register  ******************/
#define DAC_DHR12L1_DACC1DHR_Pos            (4U)                               
#define DAC_DHR12L1_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12L1_DACC1DHR_Pos) /*!< 0x0000FFF0 */
#define DAC_DHR12L1_DACC1DHR                DAC_DHR12L1_DACC1DHR_Msk              /*!< DAC channel1 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R1 register  ******************/
#define DAC_DHR8R1_DACC1DHR_Pos             (0U)                               
#define DAC_DHR8R1_DACC1DHR_Msk             (0xFFUL << DAC_DHR8R1_DACC1DHR_Pos)   /*!< 0x000000FF */
#define DAC_DHR8R1_DACC1DHR                 DAC_DHR8R1_DACC1DHR_Msk               /*!< DAC channel1 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12R2 register  ******************/
#define DAC_DHR12R2_DACC2DHR_Pos            (0U)                               
#define DAC_DHR12R2_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12R2_DACC2DHR_Pos) /*!< 0x00000FFF */
#define DAC_DHR12R2_DACC2DHR                DAC_DHR12R2_DACC2DHR_Msk              /*!< DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L2 register  ******************/
#define DAC_DHR12L2_DACC2DHR_Pos            (4U)                               
#define DAC_DHR12L2_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12L2_DACC2DHR_Pos) /*!< 0x0000FFF0 */
#define DAC_DHR12L2_DACC2DHR                DAC_DHR12L2_DACC2DHR_Msk              /*!< DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R2 register  ******************/
#define DAC_DHR8R2_DACC2DHR_Pos             (0U)                               
#define DAC_DHR8R2_DACC2DHR_Msk             (0xFFUL << DAC_DHR8R2_DACC2DHR_Pos)   /*!< 0x000000FF */
#define DAC_DHR8R2_DACC2DHR                 DAC_DHR8R2_DACC2DHR_Msk               /*!< DAC channel2 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12RD register  ******************/
#define DAC_DHR12RD_DACC1DHR_Pos            (0U)                               
#define DAC_DHR12RD_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12RD_DACC1DHR_Pos) /*!< 0x00000FFF */
#define DAC_DHR12RD_DACC1DHR                DAC_DHR12RD_DACC1DHR_Msk              /*!< DAC channel1 12-bit Right aligned data */
#define DAC_DHR12RD_DACC2DHR_Pos            (16U)                              
#define DAC_DHR12RD_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12RD_DACC2DHR_Pos) /*!< 0x0FFF0000 */
#define DAC_DHR12RD_DACC2DHR                DAC_DHR12RD_DACC2DHR_Msk              /*!< DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12LD register  ******************/
#define DAC_DHR12LD_DACC1DHR_Pos            (4U)                               
#define DAC_DHR12LD_DACC1DHR_Msk            (0xFFFUL << DAC_DHR12LD_DACC1DHR_Pos) /*!< 0x0000FFF0 */
#define DAC_DHR12LD_DACC1DHR                DAC_DHR12LD_DACC1DHR_Msk              /*!< DAC channel1 12-bit Left aligned data */
#define DAC_DHR12LD_DACC2DHR_Pos            (20U)                              
#define DAC_DHR12LD_DACC2DHR_Msk            (0xFFFUL << DAC_DHR12LD_DACC2DHR_Pos) /*!< 0xFFF00000 */
#define DAC_DHR12LD_DACC2DHR                DAC_DHR12LD_DACC2DHR_Msk              /*!< DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8RD register  ******************/
#define DAC_DHR8RD_DACC1DHR_Pos             (0U)                               
#define DAC_DHR8RD_DACC1DHR_Msk             (0xFFUL << DAC_DHR8RD_DACC1DHR_Pos)   /*!< 0x000000FF */
#define DAC_DHR8RD_DACC1DHR                 DAC_DHR8RD_DACC1DHR_Msk               /*!< DAC channel1 8-bit Right aligned data */
#define DAC_DHR8RD_DACC2DHR_Pos             (8U)                               
#define DAC_DHR8RD_DACC2DHR_Msk             (0xFFUL << DAC_DHR8RD_DACC2DHR_Pos)   /*!< 0x0000FF00 */
#define DAC_DHR8RD_DACC2DHR                 DAC_DHR8RD_DACC2DHR_Msk               /*!< DAC channel2 8-bit Right aligned data */

/*******************  Bit definition for DAC_DOR1 register  *******************/
#define DAC_DOR1_DACC1DOR_Pos               (0U)                               
#define DAC_DOR1_DACC1DOR_Msk               (0xFFFUL << DAC_DOR1_DACC1DOR_Pos)    /*!< 0x00000FFF */
#define DAC_DOR1_DACC1DOR                   DAC_DOR1_DACC1DOR_Msk                 /*!< DAC channel1 data output */

/*******************  Bit definition for DAC_DOR2 register  *******************/
#define DAC_DOR2_DACC2DOR_Pos               (0U)                               
#define DAC_DOR2_DACC2DOR_Msk               (0xFFFUL << DAC_DOR2_DACC2DOR_Pos)    /*!< 0x00000FFF */
#define DAC_DOR2_DACC2DOR                   DAC_DOR2_DACC2DOR_Msk                 /*!< DAC channel2 data output */

/*****************************************************************************/
/*                                                                           */
/*                               Timers (TIM)                                */
/*                                                                           */
/*****************************************************************************/
/*******************  Bit definition for TIM_CR1 register  *******************/
#define TIM_CR1_CEN_Pos                     (0U)                               
#define TIM_CR1_CEN_Msk                     (0x1UL << TIM_CR1_CEN_Pos)          /*!< 0x00000001 */
#define TIM_CR1_CEN                         TIM_CR1_CEN_Msk                     /*!<Counter enable */
#define TIM_CR1_UDIS_Pos                    (1U)                               
#define TIM_CR1_UDIS_Msk                    (0x1UL << TIM_CR1_UDIS_Pos)         /*!< 0x00000002 */
#define TIM_CR1_UDIS                        TIM_CR1_UDIS_Msk                    /*!<Update disable */
#define TIM_CR1_URS_Pos                     (2U)                               
#define TIM_CR1_URS_Msk                     (0x1UL << TIM_CR1_URS_Pos)          /*!< 0x00000004 */
#define TIM_CR1_URS                         TIM_CR1_URS_Msk                     /*!<Update request source */
#define TIM_CR1_OPM_Pos                     (3U)                               
#define TIM_CR1_OPM_Msk                     (0x1UL << TIM_CR1_OPM_Pos)          /*!< 0x00000008 */
#define TIM_CR1_OPM                         TIM_CR1_OPM_Msk                     /*!<One pulse mode */
#define TIM_CR1_DIR_Pos                     (4U)                               
#define TIM_CR1_DIR_Msk                     (0x1UL << TIM_CR1_DIR_Pos)          /*!< 0x00000010 */
#define TIM_CR1_DIR                         TIM_CR1_DIR_Msk                     /*!<Direction */

#define TIM_CR1_CMS_Pos                     (5U)                               
#define TIM_CR1_CMS_Msk                     (0x3UL << TIM_CR1_CMS_Pos)          /*!< 0x00000060 */
#define TIM_CR1_CMS                         TIM_CR1_CMS_Msk                     /*!<CMS[1:0] bits (Center-aligned mode selection) */
#define TIM_CR1_CMS_0                       (0x1UL << TIM_CR1_CMS_Pos)          /*!< 0x00000020 */
#define TIM_CR1_CMS_1                       (0x2UL << TIM_CR1_CMS_Pos)          /*!< 0x00000040 */

#define TIM_CR1_ARPE_Pos                    (7U)                               
#define TIM_CR1_ARPE_Msk                    (0x1UL << TIM_CR1_ARPE_Pos)         /*!< 0x00000080 */
#define TIM_CR1_ARPE                        TIM_CR1_ARPE_Msk                    /*!<Auto-reload preload enable */

#define TIM_CR1_CKD_Pos                     (8U)                               
#define TIM_CR1_CKD_Msk                     (0x3UL << TIM_CR1_CKD_Pos)          /*!< 0x00000300 */
#define TIM_CR1_CKD                         TIM_CR1_CKD_Msk                     /*!<CKD[1:0] bits (clock division) */
#define TIM_CR1_CKD_0                       (0x1UL << TIM_CR1_CKD_Pos)          /*!< 0x00000100 */
#define TIM_CR1_CKD_1                       (0x2UL << TIM_CR1_CKD_Pos)          /*!< 0x00000200 */

/*******************  Bit definition for TIM_CR2 register  *******************/
#define TIM_CR2_CCPC_Pos                    (0U)                               
#define TIM_CR2_CCPC_Msk                    (0x1UL << TIM_CR2_CCPC_Pos)         /*!< 0x00000001 */
#define TIM_CR2_CCPC                        TIM_CR2_CCPC_Msk                    /*!<Capture/Compare Preloaded Control */
#define TIM_CR2_CCUS_Pos                    (2U)                               
#define TIM_CR2_CCUS_Msk                    (0x1UL << TIM_CR2_CCUS_Pos)         /*!< 0x00000004 */
#define TIM_CR2_CCUS                        TIM_CR2_CCUS_Msk                    /*!<Capture/Compare Control Update Selection */
#define TIM_CR2_CCDS_Pos                    (3U)                               
#define TIM_CR2_CCDS_Msk                    (0x1UL << TIM_CR2_CCDS_Pos)         /*!< 0x00000008 */
#define TIM_CR2_CCDS                        TIM_CR2_CCDS_Msk                    /*!<Capture/Compare DMA Selection */

#define TIM_CR2_MMS_Pos                     (4U)                               
#define TIM_CR2_MMS_Msk                     (0x7UL << TIM_CR2_MMS_Pos)          /*!< 0x00000070 */
#define TIM_CR2_MMS                         TIM_CR2_MMS_Msk                     /*!<MMS[2:0] bits (Master Mode Selection) */
#define TIM_CR2_MMS_0                       (0x1UL << TIM_CR2_MMS_Pos)          /*!< 0x00000010 */
#define TIM_CR2_MMS_1                       (0x2UL << TIM_CR2_MMS_Pos)          /*!< 0x00000020 */
#define TIM_CR2_MMS_2                       (0x4UL << TIM_CR2_MMS_Pos)          /*!< 0x00000040 */

#define TIM_CR2_TI1S_Pos                    (7U)                               
#define TIM_CR2_TI1S_Msk                    (0x1UL << TIM_CR2_TI1S_Pos)         /*!< 0x00000080 */
#define TIM_CR2_TI1S                        TIM_CR2_TI1S_Msk                    /*!<TI1 Selection */
#define TIM_CR2_OIS1_Pos                    (8U)                               
#define TIM_CR2_OIS1_Msk                    (0x1UL << TIM_CR2_OIS1_Pos)         /*!< 0x00000100 */
#define TIM_CR2_OIS1                        TIM_CR2_OIS1_Msk                    /*!<Output Idle state 1 (OC1 output) */
#define TIM_CR2_OIS1N_Pos                   (9U)                               
#define TIM_CR2_OIS1N_Msk                   (0x1UL << TIM_CR2_OIS1N_Pos)        /*!< 0x00000200 */
#define TIM_CR2_OIS1N                       TIM_CR2_OIS1N_Msk                   /*!<Output Idle state 1 (OC1N output) */
#define TIM_CR2_OIS2_Pos                    (10U)                              
#define TIM_CR2_OIS2_Msk                    (0x1UL << TIM_CR2_OIS2_Pos)         /*!< 0x00000400 */
#define TIM_CR2_OIS2                        TIM_CR2_OIS2_Msk                    /*!<Output Idle state 2 (OC2 output) */
#define TIM_CR2_OIS2N_Pos                   (11U)                              
#define TIM_CR2_OIS2N_Msk                   (0x1UL << TIM_CR2_OIS2N_Pos)        /*!< 0x00000800 */
#define TIM_CR2_OIS2N                       TIM_CR2_OIS2N_Msk                   /*!<Output Idle state 2 (OC2N output) */
#define TIM_CR2_OIS3_Pos                    (12U)                              
#define TIM_CR2_OIS3_Msk                    (0x1UL << TIM_CR2_OIS3_Pos)         /*!< 0x00001000 */
#define TIM_CR2_OIS3                        TIM_CR2_OIS3_Msk                    /*!<Output Idle state 3 (OC3 output) */
#define TIM_CR2_OIS3N_Pos                   (13U)                              
#define TIM_CR2_OIS3N_Msk                   (0x1UL << TIM_CR2_OIS3N_Pos)        /*!< 0x00002000 */
#define TIM_CR2_OIS3N                       TIM_CR2_OIS3N_Msk                   /*!<Output Idle state 3 (OC3N output) */
#define TIM_CR2_OIS4_Pos                    (14U)                              
#define TIM_CR2_OIS4_Msk                    (0x1UL << TIM_CR2_OIS4_Pos)         /*!< 0x00004000 */
#define TIM_CR2_OIS4                        TIM_CR2_OIS4_Msk                    /*!<Output Idle state 4 (OC4 output) */

/*******************  Bit definition for TIM_SMCR register  ******************/
#define TIM_SMCR_SMS_Pos                    (0U)                               
#define TIM_SMCR_SMS_Msk                    (0x7UL << TIM_SMCR_SMS_Pos)         /*!< 0x00000007 */
#define TIM_SMCR_SMS                        TIM_SMCR_SMS_Msk                    /*!<SMS[2:0] bits (Slave mode selection) */
#define TIM_SMCR_SMS_0                      (0x1UL << TIM_SMCR_SMS_Pos)         /*!< 0x00000001 */
#define TIM_SMCR_SMS_1                      (0x2UL << TIM_SMCR_SMS_Pos)         /*!< 0x00000002 */
#define TIM_SMCR_SMS_2                      (0x4UL << TIM_SMCR_SMS_Pos)         /*!< 0x00000004 */

#define TIM_SMCR_TS_Pos                     (4U)                               
#define TIM_SMCR_TS_Msk                     (0x7UL << TIM_SMCR_TS_Pos)          /*!< 0x00000070 */
#define TIM_SMCR_TS                         TIM_SMCR_TS_Msk                     /*!<TS[2:0] bits (Trigger selection) */
#define TIM_SMCR_TS_0                       (0x1UL << TIM_SMCR_TS_Pos)          /*!< 0x00000010 */
#define TIM_SMCR_TS_1                       (0x2UL << TIM_SMCR_TS_Pos)          /*!< 0x00000020 */
#define TIM_SMCR_TS_2                       (0x4UL << TIM_SMCR_TS_Pos)          /*!< 0x00000040 */

#define TIM_SMCR_MSM_Pos                    (7U)                               
#define TIM_SMCR_MSM_Msk                    (0x1UL << TIM_SMCR_MSM_Pos)         /*!< 0x00000080 */
#define TIM_SMCR_MSM                        TIM_SMCR_MSM_Msk                    /*!<Master/slave mode */

#define TIM_SMCR_ETF_Pos                    (8U)                               
#define TIM_SMCR_ETF_Msk                    (0xFUL << TIM_SMCR_ETF_Pos)         /*!< 0x00000F00 */
#define TIM_SMCR_ETF                        TIM_SMCR_ETF_Msk                    /*!<ETF[3:0] bits (External trigger filter) */
#define TIM_SMCR_ETF_0                      (0x1UL << TIM_SMCR_ETF_Pos)         /*!< 0x00000100 */
#define TIM_SMCR_ETF_1                      (0x2UL << TIM_SMCR_ETF_Pos)         /*!< 0x00000200 */
#define TIM_SMCR_ETF_2                      (0x4UL << TIM_SMCR_ETF_Pos)         /*!< 0x00000400 */
#define TIM_SMCR_ETF_3                      (0x8UL << TIM_SMCR_ETF_Pos)         /*!< 0x00000800 */

#define TIM_SMCR_ETPS_Pos                   (12U)                              
#define TIM_SMCR_ETPS_Msk                   (0x3UL << TIM_SMCR_ETPS_Pos)        /*!< 0x00003000 */
#define TIM_SMCR_ETPS                       TIM_SMCR_ETPS_Msk                   /*!<ETPS[1:0] bits (External trigger prescaler) */
#define TIM_SMCR_ETPS_0                     (0x1UL << TIM_SMCR_ETPS_Pos)        /*!< 0x00001000 */
#define TIM_SMCR_ETPS_1                     (0x2UL << TIM_SMCR_ETPS_Pos)        /*!< 0x00002000 */

#define TIM_SMCR_ECE_Pos                    (14U)                              
#define TIM_SMCR_ECE_Msk                    (0x1UL << TIM_SMCR_ECE_Pos)         /*!< 0x00004000 */
#define TIM_SMCR_ECE                        TIM_SMCR_ECE_Msk                    /*!<External clock enable */
#define TIM_SMCR_ETP_Pos                    (15U)                              
#define TIM_SMCR_ETP_Msk                    (0x1UL << TIM_SMCR_ETP_Pos)         /*!< 0x00008000 */
#define TIM_SMCR_ETP                        TIM_SMCR_ETP_Msk                    /*!<External trigger polarity */

/*******************  Bit definition for TIM_DIER register  ******************/
#define TIM_DIER_UIE_Pos                    (0U)                               
#define TIM_DIER_UIE_Msk                    (0x1UL << TIM_DIER_UIE_Pos)         /*!< 0x00000001 */
#define TIM_DIER_UIE                        TIM_DIER_UIE_Msk                    /*!<Update interrupt enable */
#define TIM_DIER_CC1IE_Pos                  (1U)                               
#define TIM_DIER_CC1IE_Msk                  (0x1UL << TIM_DIER_CC1IE_Pos)       /*!< 0x00000002 */
#define TIM_DIER_CC1IE                      TIM_DIER_CC1IE_Msk                  /*!<Capture/Compare 1 interrupt enable */
#define TIM_DIER_CC2IE_Pos                  (2U)                               
#define TIM_DIER_CC2IE_Msk                  (0x1UL << TIM_DIER_CC2IE_Pos)       /*!< 0x00000004 */
#define TIM_DIER_CC2IE                      TIM_DIER_CC2IE_Msk                  /*!<Capture/Compare 2 interrupt enable */
#define TIM_DIER_CC3IE_Pos                  (3U)                               
#define TIM_DIER_CC3IE_Msk                  (0x1UL << TIM_DIER_CC3IE_Pos)       /*!< 0x00000008 */
#define TIM_DIER_CC3IE                      TIM_DIER_CC3IE_Msk                  /*!<Capture/Compare 3 interrupt enable */
#define TIM_DIER_CC4IE_Pos                  (4U)                               
#define TIM_DIER_CC4IE_Msk                  (0x1UL << TIM_DIER_CC4IE_Pos)       /*!< 0x00000010 */
#define TIM_DIER_CC4IE                      TIM_DIER_CC4IE_Msk                  /*!<Capture/Compare 4 interrupt enable */
#define TIM_DIER_COMIE_Pos                  (5U)                               
#define TIM_DIER_COMIE_Msk                  (0x1UL << TIM_DIER_COMIE_Pos)       /*!< 0x00000020 */
#define TIM_DIER_COMIE                      TIM_DIER_COMIE_Msk                  /*!<COM interrupt enable */
#define TIM_DIER_TIE_Pos                    (6U)                               
#define TIM_DIER_TIE_Msk                    (0x1UL << TIM_DIER_TIE_Pos)         /*!< 0x00000040 */
#define TIM_DIER_TIE                        TIM_DIER_TIE_Msk                    /*!<Trigger interrupt enable */
#define TIM_DIER_BIE_Pos                    (7U)                               
#define TIM_DIER_BIE_Msk                    (0x1UL << TIM_DIER_BIE_Pos)         /*!< 0x00000080 */
#define TIM_DIER_BIE                        TIM_DIER_BIE_Msk                    /*!<Break interrupt enable */
#define TIM_DIER_UDE_Pos                    (8U)                               
#define TIM_DIER_UDE_Msk                    (0x1UL << TIM_DIER_UDE_Pos)         /*!< 0x00000100 */
#define TIM_DIER_UDE                        TIM_DIER_UDE_Msk                    /*!<Update DMA request enable */
#define TIM_DIER_CC1DE_Pos                  (9U)                               
#define TIM_DIER_CC1DE_Msk                  (0x1UL << TIM_DIER_CC1DE_Pos)       /*!< 0x00000200 */
#define TIM_DIER_CC1DE                      TIM_DIER_CC1DE_Msk                  /*!<Capture/Compare 1 DMA request enable */
#define TIM_DIER_CC2DE_Pos                  (10U)                              
#define TIM_DIER_CC2DE_Msk                  (0x1UL << TIM_DIER_CC2DE_Pos)       /*!< 0x00000400 */
#define TIM_DIER_CC2DE                      TIM_DIER_CC2DE_Msk                  /*!<Capture/Compare 2 DMA request enable */
#define TIM_DIER_CC3DE_Pos                  (11U)                              
#define TIM_DIER_CC3DE_Msk                  (0x1UL << TIM_DIER_CC3DE_Pos)       /*!< 0x00000800 */
#define TIM_DIER_CC3DE                      TIM_DIER_CC3DE_Msk                  /*!<Capture/Compare 3 DMA request enable */
#define TIM_DIER_CC4DE_Pos                  (12U)                              
#define TIM_DIER_CC4DE_Msk                  (0x1UL << TIM_DIER_CC4DE_Pos)       /*!< 0x00001000 */
#define TIM_DIER_CC4DE                      TIM_DIER_CC4DE_Msk                  /*!<Capture/Compare 4 DMA request enable */
#define TIM_DIER_COMDE_Pos                  (13U)                              
#define TIM_DIER_COMDE_Msk                  (0x1UL << TIM_DIER_COMDE_Pos)       /*!< 0x00002000 */
#define TIM_DIER_COMDE                      TIM_DIER_COMDE_Msk                  /*!<COM DMA request enable */
#define TIM_DIER_TDE_Pos                    (14U)                              
#define TIM_DIER_TDE_Msk                    (0x1UL << TIM_DIER_TDE_Pos)         /*!< 0x00004000 */
#define TIM_DIER_TDE                        TIM_DIER_TDE_Msk                    /*!<Trigger DMA request enable */

/********************  Bit definition for TIM_SR register  *******************/
#define TIM_SR_UIF_Pos                      (0U)                               
#define TIM_SR_UIF_Msk                      (0x1UL << TIM_SR_UIF_Pos)           /*!< 0x00000001 */
#define TIM_SR_UIF                          TIM_SR_UIF_Msk                      /*!<Update interrupt Flag */
#define TIM_SR_CC1IF_Pos                    (1U)                               
#define TIM_SR_CC1IF_Msk                    (0x1UL << TIM_SR_CC1IF_Pos)         /*!< 0x00000002 */
#define TIM_SR_CC1IF                        TIM_SR_CC1IF_Msk                    /*!<Capture/Compare 1 interrupt Flag */
#define TIM_SR_CC2IF_Pos                    (2U)                               
#define TIM_SR_CC2IF_Msk                    (0x1UL << TIM_SR_CC2IF_Pos)         /*!< 0x00000004 */
#define TIM_SR_CC2IF                        TIM_SR_CC2IF_Msk                    /*!<Capture/Compare 2 interrupt Flag */
#define TIM_SR_CC3IF_Pos                    (3U)                               
#define TIM_SR_CC3IF_Msk                    (0x1UL << TIM_SR_CC3IF_Pos)         /*!< 0x00000008 */
#define TIM_SR_CC3IF                        TIM_SR_CC3IF_Msk                    /*!<Capture/Compare 3 interrupt Flag */
#define TIM_SR_CC4IF_Pos                    (4U)                               
#define TIM_SR_CC4IF_Msk                    (0x1UL << TIM_SR_CC4IF_Pos)         /*!< 0x00000010 */
#define TIM_SR_CC4IF                        TIM_SR_CC4IF_Msk                    /*!<Capture/Compare 4 interrupt Flag */
#define TIM_SR_COMIF_Pos                    (5U)                               
#define TIM_SR_COMIF_Msk                    (0x1UL << TIM_SR_COMIF_Pos)         /*!< 0x00000020 */
#define TIM_SR_COMIF                        TIM_SR_COMIF_Msk                    /*!<COM interrupt Flag */
#define TIM_SR_TIF_Pos                      (6U)                               
#define TIM_SR_TIF_Msk                      (0x1UL << TIM_SR_TIF_Pos)           /*!< 0x00000040 */
#define TIM_SR_TIF                          TIM_SR_TIF_Msk                      /*!<Trigger interrupt Flag */
#define TIM_SR_BIF_Pos                      (7U)                               
#define TIM_SR_BIF_Msk                      (0x1UL << TIM_SR_BIF_Pos)           /*!< 0x00000080 */
#define TIM_SR_BIF                          TIM_SR_BIF_Msk                      /*!<Break interrupt Flag */
#define TIM_SR_CC1OF_Pos                    (9U)                               
#define TIM_SR_CC1OF_Msk                    (0x1UL << TIM_SR_CC1OF_Pos)         /*!< 0x00000200 */
#define TIM_SR_CC1OF                        TIM_SR_CC1OF_Msk                    /*!<Capture/Compare 1 Overcapture Flag */
#define TIM_SR_CC2OF_Pos                    (10U)                              
#define TIM_SR_CC2OF_Msk                    (0x1UL << TIM_SR_CC2OF_Pos)         /*!< 0x00000400 */
#define TIM_SR_CC2OF                        TIM_SR_CC2OF_Msk                    /*!<Capture/Compare 2 Overcapture Flag */
#define TIM_SR_CC3OF_Pos                    (11U)                              
#define TIM_SR_CC3OF_Msk                    (0x1UL << TIM_SR_CC3OF_Pos)         /*!< 0x00000800 */
#define TIM_SR_CC3OF                        TIM_SR_CC3OF_Msk                    /*!<Capture/Compare 3 Overcapture Flag */
#define TIM_SR_CC4OF_Pos                    (12U)                              
#define TIM_SR_CC4OF_Msk                    (0x1UL << TIM_SR_CC4OF_Pos)         /*!< 0x00001000 */
#define TIM_SR_CC4OF                        TIM_SR_CC4OF_Msk                    /*!<Capture/Compare 4 Overcapture Flag */

/*******************  Bit definition for TIM_EGR register  *******************/
#define TIM_EGR_UG_Pos                      (0U)                               
#define TIM_EGR_UG_Msk                      (0x1UL << TIM_EGR_UG_Pos)           /*!< 0x00000001 */
#define TIM_EGR_UG                          TIM_EGR_UG_Msk                      /*!<Update Generation */
#define TIM_EGR_CC1G_Pos                    (1U)                               
#define TIM_EGR_CC1G_Msk                    (0x1UL << TIM_EGR_CC1G_Pos)         /*!< 0x00000002 */
#define TIM_EGR_CC1G                        TIM_EGR_CC1G_Msk                    /*!<Capture/Compare 1 Generation */
#define TIM_EGR_CC2G_Pos                    (2U)                               
#define TIM_EGR_CC2G_Msk                    (0x1UL << TIM_EGR_CC2G_Pos)         /*!< 0x00000004 */
#define TIM_EGR_CC2G                        TIM_EGR_CC2G_Msk                    /*!<Capture/Compare 2 Generation */
#define TIM_EGR_CC3G_Pos                    (3U)                               
#define TIM_EGR_CC3G_Msk                    (0x1UL << TIM_EGR_CC3G_Pos)         /*!< 0x00000008 */
#define TIM_EGR_CC3G                        TIM_EGR_CC3G_Msk                    /*!<Capture/Compare 3 Generation */
#define TIM_EGR_CC4G_Pos                    (4U)                               
#define TIM_EGR_CC4G_Msk                    (0x1UL << TIM_EGR_CC4G_Pos)         /*!< 0x00000010 */
#define TIM_EGR_CC4G                        TIM_EGR_CC4G_Msk                    /*!<Capture/Compare 4 Generation */
#define TIM_EGR_COMG_Pos                    (5U)                               
#define TIM_EGR_COMG_Msk                    (0x1UL << TIM_EGR_COMG_Pos)         /*!< 0x00000020 */
#define TIM_EGR_COMG                        TIM_EGR_COMG_Msk                    /*!<Capture/Compare Control Update Generation */
#define TIM_EGR_TG_Pos                      (6U)                               
#define TIM_EGR_TG_Msk                      (0x1UL << TIM_EGR_TG_Pos)           /*!< 0x00000040 */
#define TIM_EGR_TG                          TIM_EGR_TG_Msk                      /*!<Trigger Generation */
#define TIM_EGR_BG_Pos                      (7U)                               
#define TIM_EGR_BG_Msk                      (0x1UL << TIM_EGR_BG_Pos)           /*!< 0x00000080 */
#define TIM_EGR_BG                          TIM_EGR_BG_Msk                      /*!<Break Generation */

/******************  Bit definition for TIM_CCMR1 register  ******************/
#define TIM_CCMR1_CC1S_Pos                  (0U)                               
#define TIM_CCMR1_CC1S_Msk                  (0x3UL << TIM_CCMR1_CC1S_Pos)       /*!< 0x00000003 */
#define TIM_CCMR1_CC1S                      TIM_CCMR1_CC1S_Msk                  /*!<CC1S[1:0] bits (Capture/Compare 1 Selection) */
#define TIM_CCMR1_CC1S_0                    (0x1UL << TIM_CCMR1_CC1S_Pos)       /*!< 0x00000001 */
#define TIM_CCMR1_CC1S_1                    (0x2UL << TIM_CCMR1_CC1S_Pos)       /*!< 0x00000002 */

#define TIM_CCMR1_OC1FE_Pos                 (2U)                               
#define TIM_CCMR1_OC1FE_Msk                 (0x1UL << TIM_CCMR1_OC1FE_Pos)      /*!< 0x00000004 */
#define TIM_CCMR1_OC1FE                     TIM_CCMR1_OC1FE_Msk                 /*!<Output Compare 1 Fast enable */
#define TIM_CCMR1_OC1PE_Pos                 (3U)                               
#define TIM_CCMR1_OC1PE_Msk                 (0x1UL << TIM_CCMR1_OC1PE_Pos)      /*!< 0x00000008 */
#define TIM_CCMR1_OC1PE                     TIM_CCMR1_OC1PE_Msk                /*!<Output Compare 1 Preload enable */

#define TIM_CCMR1_OC1M_Pos                  (4U)                               
#define TIM_CCMR1_OC1M_Msk                  (0x7UL << TIM_CCMR1_OC1M_Pos)       /*!< 0x00000070 */
#define TIM_CCMR1_OC1M                      TIM_CCMR1_OC1M_Msk                  /*!<OC1M[2:0] bits (Output Compare 1 Mode) */
#define TIM_CCMR1_OC1M_0                    (0x1UL << TIM_CCMR1_OC1M_Pos)       /*!< 0x00000010 */
#define TIM_CCMR1_OC1M_1                    (0x2UL << TIM_CCMR1_OC1M_Pos)       /*!< 0x00000020 */
#define TIM_CCMR1_OC1M_2                    (0x4UL << TIM_CCMR1_OC1M_Pos)       /*!< 0x00000040 */

#define TIM_CCMR1_OC1CE_Pos                 (7U)                               
#define TIM_CCMR1_OC1CE_Msk                 (0x1UL << TIM_CCMR1_OC1CE_Pos)      /*!< 0x00000080 */
#define TIM_CCMR1_OC1CE                     TIM_CCMR1_OC1CE_Msk                 /*!<Output Compare 1Clear Enable */

#define TIM_CCMR1_CC2S_Pos                  (8U)                               
#define TIM_CCMR1_CC2S_Msk                  (0x3UL << TIM_CCMR1_CC2S_Pos)       /*!< 0x00000300 */
#define TIM_CCMR1_CC2S                      TIM_CCMR1_CC2S_Msk                  /*!<CC2S[1:0] bits (Capture/Compare 2 Selection) */
#define TIM_CCMR1_CC2S_0                    (0x1UL << TIM_CCMR1_CC2S_Pos)       /*!< 0x00000100 */
#define TIM_CCMR1_CC2S_1                    (0x2UL << TIM_CCMR1_CC2S_Pos)       /*!< 0x00000200 */

#define TIM_CCMR1_OC2FE_Pos                 (10U)                              
#define TIM_CCMR1_OC2FE_Msk                 (0x1UL << TIM_CCMR1_OC2FE_Pos)      /*!< 0x00000400 */
#define TIM_CCMR1_OC2FE                     TIM_CCMR1_OC2FE_Msk                 /*!<Output Compare 2 Fast enable */
#define TIM_CCMR1_OC2PE_Pos                 (11U)                              
#define TIM_CCMR1_OC2PE_Msk                 (0x1UL << TIM_CCMR1_OC2PE_Pos)      /*!< 0x00000800 */
#define TIM_CCMR1_OC2PE                     TIM_CCMR1_OC2PE_Msk                 /*!<Output Compare 2 Preload enable */

#define TIM_CCMR1_OC2M_Pos                  (12U)                              
#define TIM_CCMR1_OC2M_Msk                  (0x7UL << TIM_CCMR1_OC2M_Pos)       /*!< 0x00007000 */
#define TIM_CCMR1_OC2M                      TIM_CCMR1_OC2M_Msk                  /*!<OC2M[2:0] bits (Output Compare 2 Mode) */
#define TIM_CCMR1_OC2M_0                    (0x1UL << TIM_CCMR1_OC2M_Pos)       /*!< 0x00001000 */
#define TIM_CCMR1_OC2M_1                    (0x2UL << TIM_CCMR1_OC2M_Pos)       /*!< 0x00002000 */
#define TIM_CCMR1_OC2M_2                    (0x4UL << TIM_CCMR1_OC2M_Pos)       /*!< 0x00004000 */

#define TIM_CCMR1_OC2CE_Pos                 (15U)                              
#define TIM_CCMR1_OC2CE_Msk                 (0x1UL << TIM_CCMR1_OC2CE_Pos)      /*!< 0x00008000 */
#define TIM_CCMR1_OC2CE                     TIM_CCMR1_OC2CE_Msk                 /*!<Output Compare 2 Clear Enable */

#define TIM_CCMR1_IC1PSC_Pos                (2U)                               
#define TIM_CCMR1_IC1PSC_Msk                (0x3UL << TIM_CCMR1_IC1PSC_Pos)     /*!< 0x0000000C */
#define TIM_CCMR1_IC1PSC                    TIM_CCMR1_IC1PSC_Msk                /*!<IC1PSC[1:0] bits (Input Capture 1 Prescaler) */
#define TIM_CCMR1_IC1PSC_0                  (0x1UL << TIM_CCMR1_IC1PSC_Pos)     /*!< 0x00000004 */
#define TIM_CCMR1_IC1PSC_1                  (0x2UL << TIM_CCMR1_IC1PSC_Pos)     /*!< 0x00000008 */

#define TIM_CCMR1_IC1F_Pos                  (4U)                               
#define TIM_CCMR1_IC1F_Msk                  (0xFUL << TIM_CCMR1_IC1F_Pos)       /*!< 0x000000F0 */
#define TIM_CCMR1_IC1F                      TIM_CCMR1_IC1F_Msk                  /*!<IC1F[3:0] bits (Input Capture 1 Filter) */
#define TIM_CCMR1_IC1F_0                    (0x1UL << TIM_CCMR1_IC1F_Pos)       /*!< 0x00000010 */
#define TIM_CCMR1_IC1F_1                    (0x2UL << TIM_CCMR1_IC1F_Pos)       /*!< 0x00000020 */
#define TIM_CCMR1_IC1F_2                    (0x4UL << TIM_CCMR1_IC1F_Pos)       /*!< 0x00000040 */
#define TIM_CCMR1_IC1F_3                    (0x8UL << TIM_CCMR1_IC1F_Pos)       /*!< 0x00000080 */

#define TIM_CCMR1_IC2PSC_Pos                (10U)                              
#define TIM_CCMR1_IC2PSC_Msk                (0x3UL << TIM_CCMR1_IC2PSC_Pos)     /*!< 0x00000C00 */
#define TIM_CCMR1_IC2PSC                    TIM_CCMR1_IC2PSC_Msk                /*!<IC2PSC[1:0] bits (Input Capture 2 Prescaler) */
#define TIM_CCMR1_IC2PSC_0                  (0x1UL << TIM_CCMR1_IC2PSC_Pos)     /*!< 0x00000400 */
#define TIM_CCMR1_IC2PSC_1                  (0x2UL << TIM_CCMR1_IC2PSC_Pos)     /*!< 0x00000800 */

#define TIM_CCMR1_IC2F_Pos                  (12U)                              
#define TIM_CCMR1_IC2F_Msk                  (0xFUL << TIM_CCMR1_IC2F_Pos)       /*!< 0x0000F000 */
#define TIM_CCMR1_IC2F                      TIM_CCMR1_IC2F_Msk                  /*!<IC2F[3:0] bits (Input Capture 2 Filter) */
#define TIM_CCMR1_IC2F_0                    (0x1UL << TIM_CCMR1_IC2F_Pos)       /*!< 0x00001000 */
#define TIM_CCMR1_IC2F_1                    (0x2UL << TIM_CCMR1_IC2F_Pos)       /*!< 0x00002000 */
#define TIM_CCMR1_IC2F_2                    (0x4UL << TIM_CCMR1_IC2F_Pos)       /*!< 0x00004000 */
#define TIM_CCMR1_IC2F_3                    (0x8UL << TIM_CCMR1_IC2F_Pos)       /*!< 0x00008000 */

/******************  Bit definition for TIM_CCMR2 register  ******************/
#define TIM_CCMR2_CC3S_Pos                  (0U)                               
#define TIM_CCMR2_CC3S_Msk                  (0x3UL << TIM_CCMR2_CC3S_Pos)       /*!< 0x00000003 */
#define TIM_CCMR2_CC3S                      TIM_CCMR2_CC3S_Msk                  /*!<CC3S[1:0] bits (Capture/Compare 3 Selection) */
#define TIM_CCMR2_CC3S_0                    (0x1UL << TIM_CCMR2_CC3S_Pos)       /*!< 0x00000001 */
#define TIM_CCMR2_CC3S_1                    (0x2UL << TIM_CCMR2_CC3S_Pos)       /*!< 0x00000002 */

#define TIM_CCMR2_OC3FE_Pos                 (2U)                               
#define TIM_CCMR2_OC3FE_Msk                 (0x1UL << TIM_CCMR2_OC3FE_Pos)      /*!< 0x00000004 */
#define TIM_CCMR2_OC3FE                     TIM_CCMR2_OC3FE_Msk                 /*!<Output Compare 3 Fast enable */
#define TIM_CCMR2_OC3PE_Pos                 (3U)                               
#define TIM_CCMR2_OC3PE_Msk                 (0x1UL << TIM_CCMR2_OC3PE_Pos)      /*!< 0x00000008 */
#define TIM_CCMR2_OC3PE                     TIM_CCMR2_OC3PE_Msk                 /*!<Output Compare 3 Preload enable */

#define TIM_CCMR2_OC3M_Pos                  (4U)                               
#define TIM_CCMR2_OC3M_Msk                  (0x7UL << TIM_CCMR2_OC3M_Pos)       /*!< 0x00000070 */
#define TIM_CCMR2_OC3M                      TIM_CCMR2_OC3M_Msk                  /*!<OC3M[2:0] bits (Output Compare 3 Mode) */
#define TIM_CCMR2_OC3M_0                    (0x1UL << TIM_CCMR2_OC3M_Pos)       /*!< 0x00000010 */
#define TIM_CCMR2_OC3M_1                    (0x2UL << TIM_CCMR2_OC3M_Pos)       /*!< 0x00000020 */
#define TIM_CCMR2_OC3M_2                    (0x4UL << TIM_CCMR2_OC3M_Pos)       /*!< 0x00000040 */

#define TIM_CCMR2_OC3CE_Pos                 (7U)                               
#define TIM_CCMR2_OC3CE_Msk                 (0x1UL << TIM_CCMR2_OC3CE_Pos)      /*!< 0x00000080 */
#define TIM_CCMR2_OC3CE                     TIM_CCMR2_OC3CE_Msk                 /*!<Output Compare 3 Clear Enable */

#define TIM_CCMR2_CC4S_Pos                  (8U)                               
#define TIM_CCMR2_CC4S_Msk                  (0x3UL << TIM_CCMR2_CC4S_Pos)       /*!< 0x00000300 */
#define TIM_CCMR2_CC4S                      TIM_CCMR2_CC4S_Msk                  /*!<CC4S[1:0] bits (Capture/Compare 4 Selection) */
#define TIM_CCMR2_CC4S_0                    (0x1UL << TIM_CCMR2_CC4S_Pos)       /*!< 0x00000100 */
#define TIM_CCMR2_CC4S_1                    (0x2UL << TIM_CCMR2_CC4S_Pos)       /*!< 0x00000200 */

#define TIM_CCMR2_OC4FE_Pos                 (10U)                              
#define TIM_CCMR2_OC4FE_Msk                 (0x1UL << TIM_CCMR2_OC4FE_Pos)      /*!< 0x00000400 */
#define TIM_CCMR2_OC4FE                     TIM_CCMR2_OC4FE_Msk                 /*!<Output Compare 4 Fast enable */
#define TIM_CCMR2_OC4PE_Pos                 (11U)                              
#define TIM_CCMR2_OC4PE_Msk                 (0x1UL << TIM_CCMR2_OC4PE_Pos)      /*!< 0x00000800 */
#define TIM_CCMR2_OC4PE                     TIM_CCMR2_OC4PE_Msk                 /*!<Output Compare 4 Preload enable */

#define TIM_CCMR2_OC4M_Pos                  (12U)                              
#define TIM_CCMR2_OC4M_Msk                  (0x7UL << TIM_CCMR2_OC4M_Pos)       /*!< 0x00007000 */
#define TIM_CCMR2_OC4M                      TIM_CCMR2_OC4M_Msk                  /*!<OC4M[2:0] bits (Output Compare 4 Mode) */
#define TIM_CCMR2_OC4M_0                    (0x1UL << TIM_CCMR2_OC4M_Pos)       /*!< 0x00001000 */
#define TIM_CCMR2_OC4M_1                    (0x2UL << TIM_CCMR2_OC4M_Pos)       /*!< 0x00002000 */
#define TIM_CCMR2_OC4M_2                    (0x4UL << TIM_CCMR2_OC4M_Pos)       /*!< 0x00004000 */

#define TIM_CCMR2_OC4CE_Pos                 (15U)                              
#define TIM_CCMR2_OC4CE_Msk                 (0x1UL << TIM_CCMR2_OC4CE_Pos)      /*!< 0x00008000 */
#define TIM_CCMR2_OC4CE                     TIM_CCMR2_OC4CE_Msk                 /*!<Output Compare 4 Clear Enable */

#define TIM_CCMR2_IC3PSC_Pos                (2U)                               
#define TIM_CCMR2_IC3PSC_Msk                (0x3UL << TIM_CCMR2_IC3PSC_Pos)     /*!< 0x0000000C */
#define TIM_CCMR2_IC3PSC                    TIM_CCMR2_IC3PSC_Msk                /*!<IC3PSC[1:0] bits (Input Capture 3 Prescaler) */
#define TIM_CCMR2_IC3PSC_0                  (0x1UL << TIM_CCMR2_IC3PSC_Pos)     /*!< 0x00000004 */
#define TIM_CCMR2_IC3PSC_1                  (0x2UL << TIM_CCMR2_IC3PSC_Pos)     /*!< 0x00000008 */

#define TIM_CCMR2_IC3F_Pos                  (4U)                               
#define TIM_CCMR2_IC3F_Msk                  (0xFUL << TIM_CCMR2_IC3F_Pos)       /*!< 0x000000F0 */
#define TIM_CCMR2_IC3F                      TIM_CCMR2_IC3F_Msk                  /*!<IC3F[3:0] bits (Input Capture 3 Filter) */
#define TIM_CCMR2_IC3F_0                    (0x1UL << TIM_CCMR2_IC3F_Pos)       /*!< 0x00000010 */
#define TIM_CCMR2_IC3F_1                    (0x2UL << TIM_CCMR2_IC3F_Pos)       /*!< 0x00000020 */
#define TIM_CCMR2_IC3F_2                    (0x4UL << TIM_CCMR2_IC3F_Pos)       /*!< 0x00000040 */
#define TIM_CCMR2_IC3F_3                    (0x8UL << TIM_CCMR2_IC3F_Pos)       /*!< 0x00000080 */

#define TIM_CCMR2_IC4PSC_Pos                (10U)                              
#define TIM_CCMR2_IC4PSC_Msk                (0x3UL << TIM_CCMR2_IC4PSC_Pos)     /*!< 0x00000C00 */
#define TIM_CCMR2_IC4PSC                    TIM_CCMR2_IC4PSC_Msk                /*!<IC4PSC[1:0] bits (Input Capture 4 Prescaler) */
#define TIM_CCMR2_IC4PSC_0                  (0x1UL << TIM_CCMR2_IC4PSC_Pos)     /*!< 0x00000400 */
#define TIM_CCMR2_IC4PSC_1                  (0x2UL << TIM_CCMR2_IC4PSC_Pos)     /*!< 0x00000800 */

#define TIM_CCMR2_IC4F_Pos                  (12U)                              
#define TIM_CCMR2_IC4F_Msk                  (0xFUL << TIM_CCMR2_IC4F_Pos)       /*!< 0x0000F000 */
#define TIM_CCMR2_IC4F                      TIM_CCMR2_IC4F_Msk                  /*!<IC4F[3:0] bits (Input Capture 4 Filter) */
#define TIM_CCMR2_IC4F_0                    (0x1UL << TIM_CCMR2_IC4F_Pos)       /*!< 0x00001000 */
#define TIM_CCMR2_IC4F_1                    (0x2UL << TIM_CCMR2_IC4F_Pos)       /*!< 0x00002000 */
#define TIM_CCMR2_IC4F_2                    (0x4UL << TIM_CCMR2_IC4F_Pos)       /*!< 0x00004000 */
#define TIM_CCMR2_IC4F_3                    (0x8UL << TIM_CCMR2_IC4F_Pos)       /*!< 0x00008000 */

/*******************  Bit definition for TIM_CCER register  ******************/
#define TIM_CCER_CC1E_Pos                   (0U)                               
#define TIM_CCER_CC1E_Msk                   (0x1UL << TIM_CCER_CC1E_Pos)        /*!< 0x00000001 */
#define TIM_CCER_CC1E                       TIM_CCER_CC1E_Msk                   /*!<Capture/Compare 1 output enable */
#define TIM_CCER_CC1P_Pos                   (1U)                               
#define TIM_CCER_CC1P_Msk                   (0x1UL << TIM_CCER_CC1P_Pos)        /*!< 0x00000002 */
#define TIM_CCER_CC1P                       TIM_CCER_CC1P_Msk                   /*!<Capture/Compare 1 output Polarity */
#define TIM_CCER_CC1NE_Pos                  (2U)                               
#define TIM_CCER_CC1NE_Msk                  (0x1UL << TIM_CCER_CC1NE_Pos)       /*!< 0x00000004 */
#define TIM_CCER_CC1NE                      TIM_CCER_CC1NE_Msk                  /*!<Capture/Compare 1 Complementary output enable */
#define TIM_CCER_CC1NP_Pos                  (3U)                               
#define TIM_CCER_CC1NP_Msk                  (0x1UL << TIM_CCER_CC1NP_Pos)       /*!< 0x00000008 */
#define TIM_CCER_CC1NP                      TIM_CCER_CC1NP_Msk                  /*!<Capture/Compare 1 Complementary output Polarity */
#define TIM_CCER_CC2E_Pos                   (4U)                               
#define TIM_CCER_CC2E_Msk                   (0x1UL << TIM_CCER_CC2E_Pos)        /*!< 0x00000010 */
#define TIM_CCER_CC2E                       TIM_CCER_CC2E_Msk                   /*!<Capture/Compare 2 output enable */
#define TIM_CCER_CC2P_Pos                   (5U)                               
#define TIM_CCER_CC2P_Msk                   (0x1UL << TIM_CCER_CC2P_Pos)        /*!< 0x00000020 */
#define TIM_CCER_CC2P                       TIM_CCER_CC2P_Msk                   /*!<Capture/Compare 2 output Polarity */
#define TIM_CCER_CC2NE_Pos                  (6U)                               
#define TIM_CCER_CC2NE_Msk                  (0x1UL << TIM_CCER_CC2NE_Pos)       /*!< 0x00000040 */
#define TIM_CCER_CC2NE                      TIM_CCER_CC2NE_Msk                  /*!<Capture/Compare 2 Complementary output enable */
#define TIM_CCER_CC2NP_Pos                  (7U)                               
#define TIM_CCER_CC2NP_Msk                  (0x1UL << TIM_CCER_CC2NP_Pos)       /*!< 0x00000080 */
#define TIM_CCER_CC2NP                      TIM_CCER_CC2NP_Msk                  /*!<Capture/Compare 2 Complementary output Polarity */
#define TIM_CCER_CC3E_Pos                   (8U)                               
#define TIM_CCER_CC3E_Msk                   (0x1UL << TIM_CCER_CC3E_Pos)        /*!< 0x00000100 */
#define TIM_CCER_CC3E                       TIM_CCER_CC3E_Msk                   /*!<Capture/Compare 3 output enable */
#define TIM_CCER_CC3P_Pos                   (9U)                               
#define TIM_CCER_CC3P_Msk                   (0x1UL << TIM_CCER_CC3P_Pos)        /*!< 0x00000200 */
#define TIM_CCER_CC3P                       TIM_CCER_CC3P_Msk                   /*!<Capture/Compare 3 output Polarity */
#define TIM_CCER_CC3NE_Pos                  (10U)                              
#define TIM_CCER_CC3NE_Msk                  (0x1UL << TIM_CCER_CC3NE_Pos)       /*!< 0x00000400 */
#define TIM_CCER_CC3NE                      TIM_CCER_CC3NE_Msk                  /*!<Capture/Compare 3 Complementary output enable */
#define TIM_CCER_CC3NP_Pos                  (11U)                              
#define TIM_CCER_CC3NP_Msk                  (0x1UL << TIM_CCER_CC3NP_Pos)       /*!< 0x00000800 */
#define TIM_CCER_CC3NP                      TIM_CCER_CC3NP_Msk                  /*!<Capture/Compare 3 Complementary output Polarity */
#define TIM_CCER_CC4E_Pos                   (12U)                              
#define TIM_CCER_CC4E_Msk                   (0x1UL << TIM_CCER_CC4E_Pos)        /*!< 0x00001000 */
#define TIM_CCER_CC4E                       TIM_CCER_CC4E_Msk                   /*!<Capture/Compare 4 output enable */
#define TIM_CCER_CC4P_Pos                   (13U)                              
#define TIM_CCER_CC4P_Msk                   (0x1UL << TIM_CCER_CC4P_Pos)        /*!< 0x00002000 */
#define TIM_CCER_CC4P                       TIM_CCER_CC4P_Msk                   /*!<Capture/Compare 4 output Polarity */

/*******************  Bit definition for TIM_CNT register  *******************/
#define TIM_CNT_CNT_Pos                     (0U)                               
#define TIM_CNT_CNT_Msk                     (0xFFFFFFFFUL << TIM_CNT_CNT_Pos)   /*!< 0xFFFFFFFF */
#define TIM_CNT_CNT                         TIM_CNT_CNT_Msk                    /*!<Counter Value */

/*******************  Bit definition for TIM_PSC register  *******************/
#define TIM_PSC_PSC_Pos                     (0U)                               
#define TIM_PSC_PSC_Msk                     (0xFFFFUL << TIM_PSC_PSC_Pos)       /*!< 0x0000FFFF */
#define TIM_PSC_PSC                         TIM_PSC_PSC_Msk                     /*!<Prescaler Value */

/*******************  Bit definition for TIM_ARR register  *******************/
#define TIM_ARR_ARR_Pos                     (0U)                               
#define TIM_ARR_ARR_Msk                     (0xFFFFFFFFUL << TIM_ARR_ARR_Pos)   /*!< 0xFFFFFFFF */
#define TIM_ARR_ARR                         TIM_ARR_ARR_Msk                     /*!<actual auto-reload Value */

/*******************  Bit definition for TIM_RCR register  *******************/
#define TIM_RCR_REP_Pos                     (0U)                               
#define TIM_RCR_REP_Msk                     (0xFFUL << TIM_RCR_REP_Pos)         /*!< 0x000000FF */
#define TIM_RCR_REP                         TIM_RCR_REP_Msk                     /*!<Repetition Counter Value */

/*******************  Bit definition for TIM_CCR1 register  ******************/
#define TIM_CCR1_CCR1_Pos                   (0U)                               
#define TIM_CCR1_CCR1_Msk                   (0xFFFFUL << TIM_CCR1_CCR1_Pos)     /*!< 0x0000FFFF */
#define TIM_CCR1_CCR1                       TIM_CCR1_CCR1_Msk                   /*!<Capture/Compare 1 Value */

/*******************  Bit definition for TIM_CCR2 register  ******************/
#define TIM_CCR2_CCR2_Pos                   (0U)                               
#define TIM_CCR2_CCR2_Msk                   (0xFFFFUL << TIM_CCR2_CCR2_Pos)     /*!< 0x0000FFFF */
#define TIM_CCR2_CCR2                       TIM_CCR2_CCR2_Msk                   /*!<Capture/Compare 2 Value */

/*******************  Bit definition for TIM_CCR3 register  ******************/
#define TIM_CCR3_CCR3_Pos                   (0U)                               
#define TIM_CCR3_CCR3_Msk                   (0xFFFFUL << TIM_CCR3_CCR3_Pos)     /*!< 0x0000FFFF */
#define TIM_CCR3_CCR3                       TIM_CCR3_CCR3_Msk                   /*!<Capture/Compare 3 Value */

/*******************  Bit definition for TIM_CCR4 register  ******************/
#define TIM_CCR4_CCR4_Pos                   (0U)                               
#define TIM_CCR4_CCR4_Msk                   (0xFFFFUL << TIM_CCR4_CCR4_Pos)     /*!< 0x0000FFFF */
#define TIM_CCR4_CCR4                       TIM_CCR4_CCR4_Msk                   /*!<Capture/Compare 4 Value */

/*******************  Bit definition for TIM_BDTR register  ******************/
#define TIM_BDTR_DTG_Pos                    (0U)                               
#define TIM_BDTR_DTG_Msk                    (0xFFUL << TIM_BDTR_DTG_Pos)        /*!< 0x000000FF */
#define TIM_BDTR_DTG                        TIM_BDTR_DTG_Msk                    /*!<DTG[0:7] bits (Dead-Time Generator set-up) */
#define TIM_BDTR_DTG_0                      (0x01UL << TIM_BDTR_DTG_Pos)        /*!< 0x00000001 */
#define TIM_BDTR_DTG_1                      (0x02UL << TIM_BDTR_DTG_Pos)        /*!< 0x00000002 */
#define TIM_BDTR_DTG_2                      (0x04UL << TIM_BDTR_DTG_Pos)        /*!< 0x00000004 */
#define TIM_BDTR_DTG_3                      (0x08UL << TIM_BDTR_DTG_Pos)        /*!< 0x00000008 */
#define TIM_BDTR_DTG_4                      (0x10UL << TIM_BDTR_DTG_Pos)        /*!< 0x00000010 */
#define TIM_BDTR_DTG_5                      (0x20UL << TIM_BDTR_DTG_Pos)        /*!< 0x00000020 */
#define TIM_BDTR_DTG_6                      (0x40UL << TIM_BDTR_DTG_Pos)        /*!< 0x00000040 */
#define TIM_BDTR_DTG_7                      (0x80UL << TIM_BDTR_DTG_Pos)        /*!< 0x00000080 */

#define TIM_BDTR_LOCK_Pos                   (8U)                               
#define TIM_BDTR_LOCK_Msk                   (0x3UL << TIM_BDTR_LOCK_Pos)        /*!< 0x00000300 */
#define TIM_BDTR_LOCK                       TIM_BDTR_LOCK_Msk                   /*!<LOCK[1:0] bits (Lock Configuration) */
#define TIM_BDTR_LOCK_0                     (0x1UL << TIM_BDTR_LOCK_Pos)        /*!< 0x00000100 */
#define TIM_BDTR_LOCK_1                     (0x2UL << TIM_BDTR_LOCK_Pos)        /*!< 0x00000200 */

#define TIM_BDTR_OSSI_Pos                   (10U)                              
#define TIM_BDTR_OSSI_Msk                   (0x1UL << TIM_BDTR_OSSI_Pos)        /*!< 0x00000400 */
#define TIM_BDTR_OSSI                       TIM_BDTR_OSSI_Msk                   /*!<Off-State Selection for Idle mode */
#define TIM_BDTR_OSSR_Pos                   (11U)                              
#define TIM_BDTR_OSSR_Msk                   (0x1UL << TIM_BDTR_OSSR_Pos)        /*!< 0x00000800 */
#define TIM_BDTR_OSSR                       TIM_BDTR_OSSR_Msk                   /*!<Off-State Selection for Run mode */
#define TIM_BDTR_BKE_Pos                    (12U)                              
#define TIM_BDTR_BKE_Msk                    (0x1UL << TIM_BDTR_BKE_Pos)         /*!< 0x00001000 */
#define TIM_BDTR_BKE                        TIM_BDTR_BKE_Msk                    /*!<Break enable */
#define TIM_BDTR_BKP_Pos                    (13U)                              
#define TIM_BDTR_BKP_Msk                    (0x1UL << TIM_BDTR_BKP_Pos)         /*!< 0x00002000 */
#define TIM_BDTR_BKP                        TIM_BDTR_BKP_Msk                    /*!<Break Polarity */
#define TIM_BDTR_AOE_Pos                    (14U)                              
#define TIM_BDTR_AOE_Msk                    (0x1UL << TIM_BDTR_AOE_Pos)         /*!< 0x00004000 */
#define TIM_BDTR_AOE                        TIM_BDTR_AOE_Msk                    /*!<Automatic Output enable */
#define TIM_BDTR_MOE_Pos                    (15U)                              
#define TIM_BDTR_MOE_Msk                    (0x1UL << TIM_BDTR_MOE_Pos)         /*!< 0x00008000 */
#define TIM_BDTR_MOE                        TIM_BDTR_MOE_Msk                    /*!<Main Output enable */

/*******************  Bit definition for TIM_DCR register  *******************/
#define TIM_DCR_DBA_Pos                     (0U)                               
#define TIM_DCR_DBA_Msk                     (0x1FUL << TIM_DCR_DBA_Pos)         /*!< 0x0000001F */
#define TIM_DCR_DBA                         TIM_DCR_DBA_Msk                     /*!<DBA[4:0] bits (DMA Base Address) */
#define TIM_DCR_DBA_0                       (0x01UL << TIM_DCR_DBA_Pos)         /*!< 0x00000001 */
#define TIM_DCR_DBA_1                       (0x02UL << TIM_DCR_DBA_Pos)         /*!< 0x00000002 */
#define TIM_DCR_DBA_2                       (0x04UL << TIM_DCR_DBA_Pos)         /*!< 0x00000004 */
#define TIM_DCR_DBA_3                       (0x08UL << TIM_DCR_DBA_Pos)         /*!< 0x00000008 */
#define TIM_DCR_DBA_4                       (0x10UL << TIM_DCR_DBA_Pos)         /*!< 0x00000010 */

#define TIM_DCR_DBL_Pos                     (8U)                               
#define TIM_DCR_DBL_Msk                     (0x1FUL << TIM_DCR_DBL_Pos)         /*!< 0x00001F00 */
#define TIM_DCR_DBL                         TIM_DCR_DBL_Msk                     /*!<DBL[4:0] bits (DMA Burst Length) */
#define TIM_DCR_DBL_0                       (0x01UL << TIM_DCR_DBL_Pos)         /*!< 0x00000100 */
#define TIM_DCR_DBL_1                       (0x02UL << TIM_DCR_DBL_Pos)         /*!< 0x00000200 */
#define TIM_DCR_DBL_2                       (0x04UL << TIM_DCR_DBL_Pos)         /*!< 0x00000400 */
#define TIM_DCR_DBL_3                       (0x08UL << TIM_DCR_DBL_Pos)         /*!< 0x00000800 */
#define TIM_DCR_DBL_4                       (0x10UL << TIM_DCR_DBL_Pos)         /*!< 0x00001000 */

/*******************  Bit definition for TIM_DMAR register  ******************/
#define TIM_DMAR_DMAB_Pos                   (0U)                               
#define TIM_DMAR_DMAB_Msk                   (0xFFFFUL << TIM_DMAR_DMAB_Pos)     /*!< 0x0000FFFF */
#define TIM_DMAR_DMAB                       TIM_DMAR_DMAB_Msk                   /*!<DMA register for burst accesses */

/******************************************************************************/
/*                                                                            */
/*                       Controller Area Network (CAN)                        */
/*                                                                            */
/******************************************************************************/

/***************  Bit definition for CAN_ISR_SR_CMR_MR register  **************/
#define CAN_MR_AFM_Pos                      (0U)
#define CAN_MR_AFM_Msk                      (0x1UL << CAN_MR_AFM_Pos)           /*!< 0x00000001 */
#define CAN_MR_AFM                          CAN_MR_AFM_Msk                      /*!<Hardware Acceptance Filter Scheme */
#define CAN_MR_LOM_Pos                      (1U)
#define CAN_MR_LOM_Msk                      (0x1UL << CAN_MR_LOM_Pos)           /*!< 0x00000002 */
#define CAN_MR_LOM                          CAN_MR_LOM_Msk                      /*!<Listen Only Mode */
#define CAN_MR_RM_Pos                       (2U)
#define CAN_MR_RM_Msk                       (0x1UL << CAN_MR_RM_Pos)            /*!< 0x00000004 */
#define CAN_MR_RM                            CAN_MR_RM_Msk                      /*!<Reset Mode */

#define CAN_CMR_AT_Pos                      (9U)
#define CAN_CMR_AT_Msk                      (0x1UL << CAN_CMR_AT_Pos)           /*!< 0x00000200 */
#define CAN_CMR_AT                          CAN_CMR_AT_Msk                      /*!<Abort Transmission */
#define CAN_CMR_TR_Pos                      (10U)
#define CAN_CMR_TR_Msk                      (0x1UL << CAN_CMR_TR_Pos)           /*!< 0x00000400 */
#define CAN_CMR_TR                          CAN_CMR_TR_Msk                      /*!<Transmit Request */

#define CAN_SR_BS_Pos                       (16U)
#define CAN_SR_BS_Msk                       (0x1UL << CAN_SR_BS_Pos)            /*!< 0x00010000 */
#define CAN_SR_BS                           CAN_SR_BS_Msk                       /*!<Bus off Status */
#define CAN_SR_ES_Pos                       (17U)
#define CAN_SR_ES_Msk                       (0x1UL << CAN_SR_ES_Pos)            /*!< 0x00020000 */
#define CAN_SR_ES                           CAN_SR_ES_Msk                       /*!<Error Status */
#define CAN_SR_TS_Pos                       (18U)
#define CAN_SR_TS_Msk                       (0x1UL << CAN_SR_TS_Pos)            /*!< 0x00040000 */
#define CAN_SR_TS                           CAN_SR_TS_Msk                       /*!<Transmit Status */
#define CAN_SR_RS_Pos                       (19U)
#define CAN_SR_RS_Msk                       (0x1UL << CAN_SR_RS_Pos)            /*!< 0x00080000 */
#define CAN_SR_RS                           CAN_SR_RS_Msk                       /*!<Receive Status */
#define CAN_SR_TBS_Pos                      (21U)
#define CAN_SR_TBS_Msk                      (0x1UL << CAN_SR_TBS_Pos)           /*!< 0x00200000 */
#define CAN_SR_TBS                          CAN_SR_TBS_Msk                      /*!<Transmit Buffer Status */
#define CAN_SR_DSO_Pos                      (22U)
#define CAN_SR_DSO_Msk                      (0x1UL << CAN_SR_DSO_Pos)           /*!< 0x00400000 */
#define CAN_SR_DSO                          CAN_SR_DSO_Msk                      /*!<Data Overrun Status */
#define CAN_SR_RBS_Pos                      (23U)
#define CAN_SR_RBS_Msk                      (0x1UL << CAN_SR_RBS_Pos)           /*!< 0x00800000 */
#define CAN_SR_RBS                          CAN_SR_RBS_Msk                      /*!<Receive Buffer Status */
                         
#define CAN_ISR_DOI_Pos                     (24U)
#define CAN_ISR_DOI_Msk                     (0x1UL << CAN_ISR_DOI_Pos)          /*!< 0x01000000 */
#define CAN_ISR_DOI                         CAN_ISR_DOI_Msk                     /*!<Data Overrun Interrupt */
#define CAN_ISR_BEI_Pos                     (25U)
#define CAN_ISR_BEI_Msk                     (0x1UL << CAN_ISR_BEI_Pos)          /*!< 0x02000000 */
#define CAN_ISR_BEI                         CAN_ISR_BEI_Msk                     /*!<Buss Error Interrupt */
#define CAN_ISR_TI_Pos                      (26U)
#define CAN_ISR_TI_Msk                      (0x1UL << CAN_ISR_TI_Pos)           /*!< 0x04000000 */
#define CAN_ISR_TI                          CAN_ISR_TI_Msk                      /*!<Transmission Interrupt */
#define CAN_ISR_RI_Pos                      (27U)
#define CAN_ISR_RI_Msk                      (0x1UL << CAN_ISR_RI_Pos)           /*!< 0x08000000 */
#define CAN_ISR_RI                          CAN_ISR_RI_Msk                      /*!<Receive Interrupt */
#define CAN_ISR_EPI_Pos                     (28U)          
#define CAN_ISR_EPI_Msk                     (0x1UL << CAN_ISR_EPI_Pos)          /*!< 0x10000000 */
#define CAN_ISR_EPI                         CAN_ISR_EPI_Msk                     /*!<Error Passive Interrup */
#define CAN_ISR_EWI_Pos                     (29U)
#define CAN_ISR_EWI_Msk                     (0x1UL << CAN_ISR_EWI_Pos)          /*!< 0x20000000 */
#define CAN_ISR_EWI                         CAN_ISR_EWI_Msk                     /*!<Error Warning Interrupt */
#define CAN_ISR_ALI_Pos                     (30U)
#define CAN_ISR_ALI_Msk                     (0x1UL << CAN_ISR_ALI_Pos)          /*!< 0x40000000 */
#define CAN_ISR_ALI                         CAN_ISR_ALI_Msk                     /*!<Arbitration Lost Interrupt */

/***************  Bit definition for CAN_BT1_BT0_RMC_IMR  **************/
#define CAN_IMR_DOIM_Pos                    (0U)
#define CAN_IMR_DOIM_Msk                    (0x1UL << CAN_IMR_DOIM_Pos)         /*!< 0x00000001 */
#define CAN_IMR_DOIM                        CAN_IMR_DOIM_Msk                    /*!<MasK for DOI Interrupt */
#define CAN_IMR_BEIM_Pos                    (1U)
#define CAN_IMR_BEIM_Msk                    (0x1UL << CAN_IMR_BEIM_Pos)         /*!< 0x00000002 */
#define CAN_IMR_BEIM                        CAN_IMR_BEIM_Msk                    /*!<MasK for BEI Interrupt */
#define CAN_IMR_TIM_Pos                     (2U)
#define CAN_IMR_TIM_Msk                     (0x1UL << CAN_IMR_TIM_Pos)          /*!< 0x00000004 */
#define CAN_IMR_TIM                         CAN_IMR_TIM_Msk                     /*!<MasK for TI Interrupt */
#define CAN_IMR_RIM_Pos                     (3U)
#define CAN_IMR_RIM_Msk                     (0x1UL << CAN_IMR_RIM_Pos)          /*!< 0x00000008 */
#define CAN_IMR_RIM                         CAN_IMR_RIM_Msk                     /*!<MasK for RI Interrupt */
#define CAN_IMR_EPIM_Pos                    (4U)
#define CAN_IMR_EPIM_Msk                    (0x1UL << CAN_IMR_EPIM_Pos)         /*!< 0x00000010 */
#define CAN_IMR_EPIM                        CAN_IMR_EPIM_Msk                    /*!<MasK for EPI Interrupt */
#define CAN_IMR_EWIM_Pos                    (5U)
#define CAN_IMR_EWIM_Msk                    (0x1UL << CAN_IMR_EWIM_Pos)         /*!< 0x00000020 */
#define CAN_IMR_EWIM                        CAN_IMR_EWIM_Msk                    /*!<MasK for EWI Interrupt */
#define CAN_IMR_ALIM_Pos                    (6U)
#define CAN_IMR_ALIM_Msk                    (0x1UL << CAN_IMR_ALIM_Pos)         /*!< 0x00000040 */
#define CAN_IMR_ALIM                        CAN_IMR_ALIM_Msk                    /*!<MasK for ALI Interrupt */

#define CAN_RMC_Pos                         (8U)
#define CAN_RMC_Msk                         (0x1FUL << CAN_RMC_Pos)             /*!< 0x00001F00 */
#define CAN_RMC                             CAN_RMC_Msk                         /*!<Number of Stored Message Frames */

#define CAN_BTR_BRP_Pos                     (16U)
#define CAN_BTR_BRP_Msk                     (0x3FUL << CAN_BTR_BRP_Pos)         /*!< 0x003F0000 */
#define CAN_BTR_BRP                         CAN_BTR_BRP_Msk                     /*!<BTR0[5:0] bits (Baud Rate Prescaler) */
#define CAN_BTR_SJW_Pos                     (22U)
#define CAN_BTR_SJW_Msk                     (0x3UL << CAN_BTR_SJW_Pos)          /*!< 0x00C00000 */
#define CAN_BTR_SJW                         CAN_BTR_SJW_Msk                     /*!<BTR0[7:6] bits (Synchronization Jump Width) */
#define CAN_BTR_TSEG1_Pos                   (24U)
#define CAN_BTR_TSEG1_Msk                   (0xFUL << CAN_BTR_TSEG1_Pos)        /*!< 0x0F000000 */
#define CAN_BTR_TSEG1                       CAN_BTR_TSEG1_Msk                   /*!<BTR1[3:0] bits (Number of clock cycles per Time Segment 1) */
#define CAN_BTR_TSEG2_Pos                   (28U)
#define CAN_BTR_TSEG2_Msk                   (0x7UL << CAN_BTR_TSEG2_Pos)        /*!< 0x70000000 */
#define CAN_BTR_TSEG2                       CAN_BTR_TSEG2_Msk                   /*!<BTR1[6:4] bits (Number of clock cycles per Time Segment 2) */
#define CAN_BTR_SAM_Pos                     (31U)
#define CAN_BTR_SAM_Msk                     (0x1UL << CAN_BTR_SAM_Pos)          /*!< 0x80000000 */
#define CAN_BTR_SAM                         CAN_BTR_SAM_Msk                     /*!<Number of bus level samples */

/************** Bit definition for CAN_ALC_TXERR_RXERR_ECC *************/
#define CAN_ECC_BER_Pos                     (0U)
#define CAN_ECC_BER_Msk                     (0x1UL << CAN_ECC_BER_Pos)          /*!< 0x00000001 */
#define CAN_ECC_BER                         CAN_ECC_BER_Msk                     /*!<Bit Error Occurred */
#define CAN_ECC_STFER_Pos                   (1U)
#define CAN_ECC_STFER_Msk                   (0x1UL << CAN_ECC_STFER_Pos)        /*!< 0x00000002 */
#define CAN_ECC_STFER                       CAN_ECC_STFER_Msk                   /*!<Stuff Error Occurred */
#define CAN_ECC_CRCER_Pos                   (2U)
#define CAN_ECC_CRCER_Msk                   (0x1UL << CAN_ECC_CRCER_Pos)        /*!< 0x00000004 */
#define CAN_ECC_CRCER                       CAN_ECC_CRCER_Msk                   /*!<CRC Error Occurred */
#define CAN_ECC_FRMER_Pos                   (3U)
#define CAN_ECC_FRMER_Msk                   (0x1UL << CAN_ECC_FRMER_Pos)        /*!< 0x00000008 */
#define CAN_ECC_FRMER                       CAN_ECC_FRMER_Msk                   /*!<Form Error Occurred */
#define CAN_ECC_ACKER_Pos                   (4U)
#define CAN_ECC_ACKER_Msk                   (0x1UL << CAN_ECC_ACKER_Pos)        /*!< 0x00000010 */
#define CAN_ECC_ACKER                       CAN_ECC_ACKER_Msk                   /*!<ACK Error Occurred */
#define CAN_ECC_EDIR_Pos                    (5U)
#define CAN_ECC_EDIR_Msk                    (0x1UL << CAN_ECC_EDIR_Pos)         /*!< 0x00000020 */
#define CAN_ECC_EDIR                        CAN_ECC_EDIR_Msk                    /*!<Direction of Transfer While Error Occurred */
#define CAN_ECC_TXWRN_Pos                   (6U)
#define CAN_ECC_TXWRN_Msk                   (0x1UL << CAN_ECC_TXWRN_Pos)        /*!< 0x00000040 */
#define CAN_ECC_TXWRN                       CAN_ECC_TXWRN_Msk                   /*!<Set When TXERR Counter is Greater Than or Equal to 96 */
#define CAN_ECC_RXERR_Pos                   (8U)
#define CAN_ECC_RXERR_Msk                   (0xFFUL << CAN_ECC_RXERR_Pos)       /*!< 0x00000080 */
#define CAN_ECC_RXERR                       CAN_ECC_RXERR_Msk                   /*!<Set When RXERR Counter is Greater Than or Equal to 96 */

#define CAN_RXERR_Pos                       (8U)
#define CAN_RXERR_Msk                       (0xFFUL << CAN_RXERR_Pos)           /*!< 0x0000FF00 */
#define CAN_RXERR                           CAN_RXERR_Msk                       /*!<RXERR[7:0] bits (Receive Error Count) */

#define CAN_TXERR_Pos                       (16U)
#define CAN_TXERR_Msk                       (0xFFUL << CAN_TXERR_Pos)           /*!< 0x00FF0000 */
#define CAN_TXERR                           CAN_TXERR_Msk                       /*!<TXERR[7:0] bits (Transmit Error Count) */

#define CAN_ALC_Pos                         (24U)
#define CAN_ALC_Msk                         (0x1FUL << CAN_ALC_Pos)             /*!< 0x1F000000 */
#define CAN_ALC                             CAN_ALC_Msk                         /*!<ALC[4:0] bits (Arbitration Lost Bit Number) */

/***************        Bit definition for CAN_NBT        **************/
#define CAN_NBT_NBRP_Pos                    (0U)
#define CAN_NBT_NBRP_Msk                    (0x3FFUL << CAN_NBT_NBRP_Pos)       /*!< 0x000003FF */
#define CAN_NBT_NBRP                        CAN_NBT_NBRP_Msk                    /*!<NBT[9:0] (Lower eight bits of baudrate prescaler used in Arbitration phase) */
#define CAN_NBT_NSEG1_Pos                   (10U)
#define CAN_NBT_NSEG1_Msk                   (0x3FUL << CAN_NBT_NSEG1_Pos)       /*!< 0x0000FC00 */
#define CAN_NBT_NSEG1                       CAN_NBT_NSEG1_Msk                   /*!<NBT[15:10] (The time segment before the sample point in Arbitration Phase) */
#define CAN_NBT_NSEG2_Pos                   (16U)
#define CAN_NBT_NSEG2_Msk                   (0xFUL << CAN_NBT_NSEG2_Pos)        /*!< 0x000F0000 */
#define CAN_NBT_NSEG2                       CAN_NBT_NSEG2_Msk                   /*!<NBT[19:16] (The time segment after the sample point in Arbitration Phase) */
#define CAN_NBT_NSJM_Pos                    (20U)
#define CAN_NBT_NSJM_Msk                    (0xFUL << CAN_NBT_NSJM_Pos)         /*!< 0x00F00000 */
#define CAN_NBT_NSJM                        CAN_NBT_NSJM_Msk                    /*!<NBT[23:20] (Synchronization Jump Width in Arbitration phase) */

/***************   Bit definition for CAN_SSPP_TDCR_DBT   **************/
#define CAN_DBT_DBRP_Pos                    (0U)
#define CAN_DBT_DBRP_Msk                    (0x1FUL << CAN_DBT_DBRP_Pos)        /*!< 0x0000001F */
#define CAN_DBT_DBRP                        CAN_DBT_DBRP_Msk                    /*!<DBT[4:0] (The Baud Rate Prescaler in Data Phase) */
#define CAN_DBT_DSJW_Pos                    (5U)
#define CAN_DBT_DSJW_Msk                    (0x7UL << CAN_DBT_DSJW_Pos)         /*!< 0x000000E0 */
#define CAN_DBT_DSJW                        CAN_DBT_DSJW_Msk                    /*!<<DBT[7:5] (Synchronization Jump Width in Data Phase) */
#define CAN_DBT_DSEG1_Pos                   (8U)
#define CAN_DBT_DSEG1_Msk                   (0x1FUL << CAN_DBT_DSEG1_Pos)       /*!< 0x00001F00 */
#define CAN_DBT_DSEG1                       CAN_DBT_DSEG1_Msk                   /*!<<DBT[12:8] (The time segment before the sample point in Data Phase) */
#define CAN_DBT_DSEG2_Pos                   (13U)          
#define CAN_DBT_DSEG2_Msk                   (0x7UL << CAN_DBT_DSEG2_Pos)        /*!< 0x0000E000 */
#define CAN_DBT_DSEG2                       CAN_DBT_DSEG2_Msk                   /*!<<DBT[15:13] (The time segment after the sample point in Data Phase) */

#define CAN_TDCR_TDCO_Pos                   (16U)
#define CAN_TDCR_TDCO_Msk                   (0x7FUL << CAN_TDCR_TDCO_Pos)       /*!< 0x007F0000 */
#define CAN_TDCR_TDCO                       CAN_TDCR_TDCO_Msk                   /*!<TDCR[6:0] (Transceiver Delay Compensation Offset) */
#define CAN_TDCR_TDCEN_Pos                  (23U)
#define CAN_TDCR_TDCEN_Msk                  (0x1UL << CAN_TDCR_TDCEN_Pos)       /*!< 0x00800000 */
#define CAN_TDCR_TDCEN                      CAN_TDCR_TDCEN_Msk                  /*!<Transceiver Delay Compensation Enable */

#define CAN_SSPP_SSPP_Pos                   (24U)
#define CAN_SSPP_SSPP_Msk                   (0x7FUL << CAN_SSPP_SSPP_Pos)       /*!< 0x7F000000 */
#define CAN_SSPP_SSPP                       CAN_SSPP_SSPP_Msk                   /*!<SSPP[6:0] (Position of the Secondary Sample Point) */

/************* Bit definition for CAN_APERR_DPERR_FDSR_FDCFG ***********/
#define CAN_FDCFG_FDEN_Pos                  (0U)
#define CAN_FDCFG_FDEN_Msk                  (0x1UL << CAN_FDCFG_FDEN_Pos)       /*!< 0x00000001 */
#define CAN_FDCFG_FDEN                      CAN_FDCFG_FDEN_Msk                  /*!<CAN FD Frame Format */
#define CAN_FDCFG_BRSEN_Pos                 (1U)
#define CAN_FDCFG_BRSEN_Msk                 (0x1UL << CAN_FDCFG_BRSEN_Pos)      /*!< 0x00000002 */
#define CAN_FDCFG_BRSEN                     CAN_FDCFG_BRSEN_Msk                 /*!<Bit Rate Switched in Data Phase */
#define CAN_FDCFG_EXTBT_Pos                 (2U)
#define CAN_FDCFG_EXTBT_Msk                 (0x1UL << CAN_FDCFG_EXTBT_Pos)      /*!< 0x00000004 */
#define CAN_FDCFG_EXTBT                     CAN_FDCFG_EXTBT_Msk                 /*!<Bit Time Prescaler in Arbitration Phase */
#define CAN_FDCFG_ISO_Pos                   (3U)
#define CAN_FDCFG_ISO_Msk                   (0x1UL << CAN_FDCFG_ISO_Pos)        /*!< 0x00000008 */
#define CAN_FDCFG_ISO                       CAN_FDCFG_ISO_Msk                   /*!<ISO CAN FD format selection */
#define CAN_FDCFG_DAR_Pos                   (4U)
#define CAN_FDCFG_DAR_Msk                   (0x1UL << CAN_FDCFG_DAR_Pos)        /*!< 0x00000010 */
#define CAN_FDCFG_DAR                       CAN_FDCFG_DAR_Msk                   /*!<Disable Auto retransmission */
#define CAN_FDCFG_REOM_Pos                  (5U)
#define CAN_FDCFG_REOM_Msk                  (0x1UL << CAN_FDCFG_REOM_Pos)       /*!< 0x00000020 */
#define CAN_FDCFG_REOM                      CAN_FDCFG_REOM_Msk                  /*!<Restricted Operation Mode */

#define CAN_FDSTA_BITERR_Pos                (8U)
#define CAN_FDSTA_BITERR_Msk                (0x1UL << CAN_FDSTA_BITERR_Pos)     /*!< 0x00000100 */
#define CAN_FDSTA_BITERR                    CAN_FDSTA_BITERR_Msk                /*!<Bit Error Indicator */
#define CAN_FDSTA_CRCERR_Pos                (9U)
#define CAN_FDSTA_CRCERR_Msk                (0x1UL << CAN_FDSTA_CRCERR_Pos)     /*!< 0x00000200 */
#define CAN_FDSTA_CRCERR                    CAN_FDSTA_CRCERR_Msk                /*!<Cyclic Redundancy Check Error indicator */
#define CAN_FDSTA_FRMERR_Pos                (10U)
#define CAN_FDSTA_FRMERR_Msk                (0x1UL << CAN_FDSTA_FRMERR_Pos)     /*!< 0x00000400 */
#define CAN_FDSTA_FRMERR                    CAN_FDSTA_FRMERR_Msk                /*!<Form Error indicator */
#define CAN_FDSTA_STFERR_Pos                (11U)
#define CAN_FDSTA_STFERR_Msk                (0x1UL << CAN_FDSTA_STFERR_Pos)     /*!< 0x00000800 */
#define CAN_FDSTA_STFERR                    CAN_FDSTA_STFERR_Msk                /*!<Stuff Error Indicator */
#define CAN_FDSTA_STATE_Pos                 (14U)
#define CAN_FDSTA_STATE_Msk                 (0x3UL << CAN_FDSTA_STATE_Pos)      /*!< 0x0000C000 */
#define CAN_FDSTA_STATE                     CAN_FDSTA_STATE_Msk                 /*!<FLEXCAN operation state */

#define CAN_DPERR_DPXERR_Pos                (16U)
#define CAN_DPERR_DPXERR_Msk                (0xFFUL << CAN_DPERR_DPXERR_Pos)    /*!< 0x00FF0000 */
#define CAN_DPERR_DPXERR                    CAN_DPERR_DPXERR_Msk                /*!<DPERR[7:0] (Data Phase Error Counter) */

#define CAN_APERR_APERR_Pos                 (24U)
#define CAN_APERR_APERR_Msk                 (0xFFUL << CAN_APERR_APERR_Pos)     /*!< 0xFF000000 */
#define CAN_APERR_APERR                     CAN_APERR_APERR_Msk                 /*!<APERR[7:0] (Arbitration Error Counter) */

/***************       Bit definition for CAN_TEST        **************/
#define CAN_TEST_LBEN_Pos                   (0U)
#define CAN_TEST_LBEN_Msk                   (0x1UL << CAN_TEST_LBEN_Pos)        /*!< 0x00000001 */
#define CAN_TEST_LBEN                       CAN_TEST_LBEN_Msk                   /*!<Loop Back Enable Bit */
#define CAN_TEST_TXC_Pos                    (1U)
#define CAN_TEST_TXC_Msk                    (0x1UL << CAN_TEST_TXC_Pos)         /*!< 0x00000002 */
#define CAN_TEST_TXC                        CAN_TEST_TXC_Msk                    /*!<TXD Pin ControL */

/******************************************************************************/
/*                                                                            */
/*                           Real-Time Clock (RTC)                            */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for RTC_CRH register  ********************/
#define RTC_CRH_SECIE_Pos                   (0U)                               
#define RTC_CRH_SECIE_Msk                   (0x1UL << RTC_CRH_SECIE_Pos)        /*!< 0x00000001 */
#define RTC_CRH_SECIE                       RTC_CRH_SECIE_Msk                   /*!< Second Interrupt Enable */
#define RTC_CRH_ALRIE_Pos                   (1U)                               
#define RTC_CRH_ALRIE_Msk                   (0x1UL << RTC_CRH_ALRIE_Pos)        /*!< 0x00000002 */
#define RTC_CRH_ALRIE                       RTC_CRH_ALRIE_Msk                   /*!< Alarm Interrupt Enable */
#define RTC_CRH_OWIE_Pos                    (2U)                               
#define RTC_CRH_OWIE_Msk                    (0x1UL << RTC_CRH_OWIE_Pos)         /*!< 0x00000004 */
#define RTC_CRH_OWIE                        RTC_CRH_OWIE_Msk                    /*!< OverfloW Interrupt Enable */

/*******************  Bit definition for RTC_CRL register  ********************/
#define RTC_CRL_SECF_Pos                    (0U)                               
#define RTC_CRL_SECF_Msk                    (0x1UL << RTC_CRL_SECF_Pos)         /*!< 0x00000001 */
#define RTC_CRL_SECF                        RTC_CRL_SECF_Msk                    /*!< Second Flag */
#define RTC_CRL_ALRF_Pos                    (1U)                               
#define RTC_CRL_ALRF_Msk                    (0x1UL << RTC_CRL_ALRF_Pos)         /*!< 0x00000002 */
#define RTC_CRL_ALRF                        RTC_CRL_ALRF_Msk                    /*!< Alarm Flag */
#define RTC_CRL_OWF_Pos                     (2U)                               
#define RTC_CRL_OWF_Msk                     (0x1UL << RTC_CRL_OWF_Pos)          /*!< 0x00000004 */
#define RTC_CRL_OWF                         RTC_CRL_OWF_Msk                     /*!< OverfloW Flag */
#define RTC_CRL_RSF_Pos                     (3U)                               
#define RTC_CRL_RSF_Msk                     (0x1UL << RTC_CRL_RSF_Pos)          /*!< 0x00000008 */
#define RTC_CRL_RSF                         RTC_CRL_RSF_Msk                     /*!< Registers Synchronized Flag */
#define RTC_CRL_CNF_Pos                     (4U)                               
#define RTC_CRL_CNF_Msk                     (0x1UL << RTC_CRL_CNF_Pos)          /*!< 0x00000010 */
#define RTC_CRL_CNF                         RTC_CRL_CNF_Msk                     /*!< Configuration Flag */
#define RTC_CRL_RTOFF_Pos                   (5U)                               
#define RTC_CRL_RTOFF_Msk                   (0x1UL << RTC_CRL_RTOFF_Pos)        /*!< 0x00000020 */
#define RTC_CRL_RTOFF                       RTC_CRL_RTOFF_Msk                   /*!< RTC operation OFF */

/*******************  Bit definition for RTC_PRLH register  *******************/
#define RTC_PRLH_PRL_Pos                    (0U)                               
#define RTC_PRLH_PRL_Msk                    (0xFUL << RTC_PRLH_PRL_Pos)         /*!< 0x0000000F */
#define RTC_PRLH_PRL                        RTC_PRLH_PRL_Msk                    /*!< RTC Prescaler Reload Value High */

/*******************  Bit definition for RTC_PRLL register  *******************/
#define RTC_PRLL_PRL_Pos                    (0U)                               
#define RTC_PRLL_PRL_Msk                    (0xFFFFUL << RTC_PRLL_PRL_Pos)      /*!< 0x0000FFFF */
#define RTC_PRLL_PRL                        RTC_PRLL_PRL_Msk                    /*!< RTC Prescaler Reload Value Low */

/*******************  Bit definition for RTC_DIVH register  *******************/
#define RTC_DIVH_RTC_DIV_Pos                (0U)                               
#define RTC_DIVH_RTC_DIV_Msk                (0xFUL << RTC_DIVH_RTC_DIV_Pos)     /*!< 0x0000000F */
#define RTC_DIVH_RTC_DIV                    RTC_DIVH_RTC_DIV_Msk                /*!< RTC Clock Divider High */

/*******************  Bit definition for RTC_DIVL register  *******************/
#define RTC_DIVL_RTC_DIV_Pos                (0U)                               
#define RTC_DIVL_RTC_DIV_Msk                (0xFFFFUL << RTC_DIVL_RTC_DIV_Pos)  /*!< 0x0000FFFF */
#define RTC_DIVL_RTC_DIV                    RTC_DIVL_RTC_DIV_Msk                /*!< RTC Clock Divider Low */

/*******************  Bit definition for RTC_CNTH register  *******************/
#define RTC_CNTH_RTC_CNT_Pos                (0U)                               
#define RTC_CNTH_RTC_CNT_Msk                (0xFFFFUL << RTC_CNTH_RTC_CNT_Pos)  /*!< 0x0000FFFF */
#define RTC_CNTH_RTC_CNT                    RTC_CNTH_RTC_CNT_Msk                /*!< RTC Counter High */

/*******************  Bit definition for RTC_CNTL register  *******************/
#define RTC_CNTL_RTC_CNT_Pos                (0U)                               
#define RTC_CNTL_RTC_CNT_Msk                (0xFFFFUL << RTC_CNTL_RTC_CNT_Pos)  /*!< 0x0000FFFF */
#define RTC_CNTL_RTC_CNT                    RTC_CNTL_RTC_CNT_Msk                /*!< RTC Counter Low */

/*******************  Bit definition for RTC_ALRH register  *******************/
#define RTC_ALRH_RTC_ALR_Pos                (0U)                               
#define RTC_ALRH_RTC_ALR_Msk                (0xFFFFUL << RTC_ALRH_RTC_ALR_Pos)  /*!< 0x0000FFFF */
#define RTC_ALRH_RTC_ALR                    RTC_ALRH_RTC_ALR_Msk                /*!< RTC Alarm High */

/*******************  Bit definition for RTC_ALRL register  *******************/
#define RTC_ALRL_RTC_ALR_Pos                (0U)                               
#define RTC_ALRL_RTC_ALR_Msk                (0xFFFFUL << RTC_ALRL_RTC_ALR_Pos)  /*!< 0x0000FFFF */
#define RTC_ALRL_RTC_ALR                    RTC_ALRL_RTC_ALR_Msk                /*!< RTC Alarm Low */

/******************************************************************************/
/*                                                                            */
/*                        Independent WATCHDOG (IWDG)                         */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for IWDG_KR register  ********************/
#define IWDG_KR_KEY_Pos                     (0U)                               
#define IWDG_KR_KEY_Msk                     (0xFFFFUL << IWDG_KR_KEY_Pos)       /*!< 0x0000FFFF */
#define IWDG_KR_KEY                         IWDG_KR_KEY_Msk                     /*!< Key value (write only, read 0000h) */

/*******************  Bit definition for IWDG_PR register  ********************/
#define IWDG_PR_PR_Pos                      (0U)                               
#define IWDG_PR_PR_Msk                      (0x7UL << IWDG_PR_PR_Pos)           /*!< 0x00000007 */
#define IWDG_PR_PR                          IWDG_PR_PR_Msk                      /*!< PR[2:0] (Prescaler divider) */
#define IWDG_PR_PR_0                        (0x1UL << IWDG_PR_PR_Pos)           /*!< 0x00000001 */
#define IWDG_PR_PR_1                        (0x2UL << IWDG_PR_PR_Pos)           /*!< 0x00000002 */
#define IWDG_PR_PR_2                        (0x4UL << IWDG_PR_PR_Pos)           /*!< 0x00000004 */

/*******************  Bit definition for IWDG_RLR register  *******************/
#define IWDG_RLR_RL_Pos                     (0U)                               
#define IWDG_RLR_RL_Msk                     (0xFFFUL << IWDG_RLR_RL_Pos)        /*!< 0x00000FFF */
#define IWDG_RLR_RL                         IWDG_RLR_RL_Msk                     /*!< Watchdog counter reload value */

/*******************  Bit definition for IWDG_SR register  ********************/
#define IWDG_SR_PVU_Pos                     (0U)                               
#define IWDG_SR_PVU_Msk                     (0x1UL << IWDG_SR_PVU_Pos)          /*!< 0x00000001 */
#define IWDG_SR_PVU                         IWDG_SR_PVU_Msk                     /*!< Watchdog prescaler value update */
#define IWDG_SR_RVU_Pos                     (1U)                               
#define IWDG_SR_RVU_Msk                     (0x1UL << IWDG_SR_RVU_Pos)          /*!< 0x00000002 */
#define IWDG_SR_RVU                         IWDG_SR_RVU_Msk                     /*!< Watchdog counter reload value update */

/******************************************************************************/
/*                                                                            */
/*                         Window WATCHDOG (WWDG)                             */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for WWDG_CR register  ********************/
#define WWDG_CR_T_Pos                       (0U)                               
#define WWDG_CR_T_Msk                       (0x7FUL << WWDG_CR_T_Pos)           /*!< 0x0000007F */
#define WWDG_CR_T                           WWDG_CR_T_Msk                       /*!< T[6:0] bits (7-Bit counter (MSB to LSB)) */
#define WWDG_CR_T0                          (0x01UL << WWDG_CR_T_Pos)           /*!< 0x00000001 */
#define WWDG_CR_T1                          (0x02UL << WWDG_CR_T_Pos)           /*!< 0x00000002 */
#define WWDG_CR_T2                          (0x04UL << WWDG_CR_T_Pos)           /*!< 0x00000004 */
#define WWDG_CR_T3                          (0x08UL << WWDG_CR_T_Pos)           /*!< 0x00000008 */
#define WWDG_CR_T4                          (0x10UL << WWDG_CR_T_Pos)           /*!< 0x00000010 */
#define WWDG_CR_T5                          (0x20UL << WWDG_CR_T_Pos)           /*!< 0x00000020 */
#define WWDG_CR_T6                          (0x40UL << WWDG_CR_T_Pos)           /*!< 0x00000040 */

#define WWDG_CR_WDGA_Pos                    (7U)                               
#define WWDG_CR_WDGA_Msk                    (0x1UL << WWDG_CR_WDGA_Pos)         /*!< 0x00000080 */
#define WWDG_CR_WDGA                        WWDG_CR_WDGA_Msk                    /*!< Activation bit */

/*******************  Bit definition for WWDG_CFR register  *******************/
#define WWDG_CFR_W_Pos                      (0U)                               
#define WWDG_CFR_W_Msk                      (0x7FUL << WWDG_CFR_W_Pos)          /*!< 0x0000007F */
#define WWDG_CFR_W                          WWDG_CFR_W_Msk                      /*!< W[6:0] bits (7-bit window value) */
#define WWDG_CFR_W0                         (0x01UL << WWDG_CFR_W_Pos)          /*!< 0x00000001 */
#define WWDG_CFR_W1                         (0x02UL << WWDG_CFR_W_Pos)          /*!< 0x00000002 */
#define WWDG_CFR_W2                         (0x04UL << WWDG_CFR_W_Pos)          /*!< 0x00000004 */
#define WWDG_CFR_W3                         (0x08UL << WWDG_CFR_W_Pos)          /*!< 0x00000008 */
#define WWDG_CFR_W4                         (0x10UL << WWDG_CFR_W_Pos)          /*!< 0x00000010 */
#define WWDG_CFR_W5                         (0x20UL << WWDG_CFR_W_Pos)          /*!< 0x00000020 */
#define WWDG_CFR_W6                         (0x40UL << WWDG_CFR_W_Pos)          /*!< 0x00000040 */

#define WWDG_CFR_WDGTB_Pos                  (7U)                               
#define WWDG_CFR_WDGTB_Msk                  (0x3UL << WWDG_CFR_WDGTB_Pos)       /*!< 0x00000180 */
#define WWDG_CFR_WDGTB                      WWDG_CFR_WDGTB_Msk                  /*!< WDGTB[1:0] bits (Timer Base) */
#define WWDG_CFR_WDGTB0                     (0x1UL << WWDG_CFR_WDGTB_Pos)       /*!< 0x00000080 */
#define WWDG_CFR_WDGTB1                     (0x2UL << WWDG_CFR_WDGTB_Pos)       /*!< 0x00000100 */

#define WWDG_CFR_EWI_Pos                    (9U)                               
#define WWDG_CFR_EWI_Msk                    (0x1UL << WWDG_CFR_EWI_Pos)         /*!< 0x00000200 */
#define WWDG_CFR_EWI                        WWDG_CFR_EWI_Msk                    /*!< Early Wakeup Interrupt */

/*******************  Bit definition for WWDG_SR register  ********************/
#define WWDG_SR_EWIF_Pos                    (0U)                               
#define WWDG_SR_EWIF_Msk                    (0x1UL << WWDG_SR_EWIF_Pos)         /*!< 0x00000001 */
#define WWDG_SR_EWIF                        WWDG_SR_EWIF_Msk                    /*!< Early Wakeup Interrupt Flag */

/******************************************************************************/
/*                                                                            */
/*                          Quad-SPI Interface (QSPI)                         */
/*                                                                            */
/******************************************************************************/

/*****************  Bit definition for QUADSPI_CR register  *******************/
#define QUADSPI_CR_EN_Pos                   (0U)                                       
#define QUADSPI_CR_EN_Msk                   (0x1U << QUADSPI_CR_EN_Pos)                /*!< 0x00000001 */
#define QUADSPI_CR_EN                       QUADSPI_CR_EN_Msk                          /*!< Enable */
#define QUADSPI_CR_ABORT_Pos                (1U)                                       
#define QUADSPI_CR_ABORT_Msk                (0x1U << QUADSPI_CR_ABORT_Pos)             /*!< 0x00000002 */
#define QUADSPI_CR_ABORT                    QUADSPI_CR_ABORT_Msk                       /*!< Abort request */
#define QUADSPI_CR_DMAEN_Pos                (2U)                                       
#define QUADSPI_CR_DMAEN_Msk                (0x1U << QUADSPI_CR_DMAEN_Pos)             /*!< 0x00000004 */
#define QUADSPI_CR_DMAEN                    QUADSPI_CR_DMAEN_Msk                       /*!< DMA Enable */
#define QUADSPI_CR_TCEN_Pos                 (3U)                                       
#define QUADSPI_CR_TCEN_Msk                 (0x1U << QUADSPI_CR_TCEN_Pos)              /*!< 0x00000008 */
#define QUADSPI_CR_TCEN                     QUADSPI_CR_TCEN_Msk                        /*!< Timeout Counter Enable */
#define QUADSPI_CR_SSHIFT_Pos               (4U)                                       
#define QUADSPI_CR_SSHIFT_Msk               (0x1U << QUADSPI_CR_SSHIFT_Pos)            /*!< 0x00000010 */
#define QUADSPI_CR_SSHIFT                   QUADSPI_CR_SSHIFT_Msk                      /*!< SSHIFT Sample Shift */
#define QUADSPI_CR_DFM_Pos                  (6U)                                       
#define QUADSPI_CR_DFM_Msk                  (0x1U << QUADSPI_CR_DFM_Pos)               /*!< 0x00000040 */
#define QUADSPI_CR_DFM                      QUADSPI_CR_DFM_Msk                         /*!< Dual Flash Mode */
#define QUADSPI_CR_FSEL_Pos                 (7U)                                       
#define QUADSPI_CR_FSEL_Msk                 (0x1U << QUADSPI_CR_FSEL_Pos)              /*!< 0x00000080 */
#define QUADSPI_CR_FSEL                     QUADSPI_CR_FSEL_Msk                        /*!< Flash Select */
#define QUADSPI_CR_FTHRES_Pos               (8U)                                       
#define QUADSPI_CR_FTHRES_Msk               (0xFU << QUADSPI_CR_FTHRES_Pos)            /*!< 0x00000F00 */
#define QUADSPI_CR_FTHRES                   QUADSPI_CR_FTHRES_Msk                      /*!< FTHRES[3:0] FIFO Level */
#define QUADSPI_CR_FTHRES_0                 (0x1U << QUADSPI_CR_FTHRES_Pos)            /*!< 0x00000100 */
#define QUADSPI_CR_FTHRES_1                 (0x2U << QUADSPI_CR_FTHRES_Pos)            /*!< 0x00000200 */
#define QUADSPI_CR_FTHRES_2                 (0x4U << QUADSPI_CR_FTHRES_Pos)            /*!< 0x00000400 */
#define QUADSPI_CR_FTHRES_3                 (0x8U << QUADSPI_CR_FTHRES_Pos)            /*!< 0x00000800 */
#define QUADSPI_CR_TEIE_Pos                 (16U)                                      
#define QUADSPI_CR_TEIE_Msk                 (0x1U << QUADSPI_CR_TEIE_Pos)              /*!< 0x00010000 */
#define QUADSPI_CR_TEIE                     QUADSPI_CR_TEIE_Msk                        /*!< Transfer Error Interrupt Enable */
#define QUADSPI_CR_TCIE_Pos                 (17U)                                      
#define QUADSPI_CR_TCIE_Msk                 (0x1U << QUADSPI_CR_TCIE_Pos)              /*!< 0x00020000 */
#define QUADSPI_CR_TCIE                     QUADSPI_CR_TCIE_Msk                        /*!< Transfer Complete Interrupt Enable */
#define QUADSPI_CR_FTIE_Pos                 (18U)                                      
#define QUADSPI_CR_FTIE_Msk                 (0x1U << QUADSPI_CR_FTIE_Pos)              /*!< 0x00040000 */
#define QUADSPI_CR_FTIE                     QUADSPI_CR_FTIE_Msk                        /*!< FIFO Threshold Interrupt Enable */
#define QUADSPI_CR_SMIE_Pos                 (19U)                                      
#define QUADSPI_CR_SMIE_Msk                 (0x1U << QUADSPI_CR_SMIE_Pos)              /*!< 0x00080000 */
#define QUADSPI_CR_SMIE                     QUADSPI_CR_SMIE_Msk                        /*!< Status Match Interrupt Enable */
#define QUADSPI_CR_TOIE_Pos                 (20U)                                      
#define QUADSPI_CR_TOIE_Msk                 (0x1U << QUADSPI_CR_TOIE_Pos)              /*!< 0x00100000 */
#define QUADSPI_CR_TOIE                     QUADSPI_CR_TOIE_Msk                        /*!< TimeOut Interrupt Enable */
#define QUADSPI_CR_APMS_Pos                 (22U)                                      
#define QUADSPI_CR_APMS_Msk                 (0x1U << QUADSPI_CR_APMS_Pos)              /*!< 0x00400000 */
#define QUADSPI_CR_APMS                     QUADSPI_CR_APMS_Msk                        /*!< Bit 1 */
#define QUADSPI_CR_PMM_Pos                  (23U)                                      
#define QUADSPI_CR_PMM_Msk                  (0x1U << QUADSPI_CR_PMM_Pos)               /*!< 0x00800000 */
#define QUADSPI_CR_PMM                      QUADSPI_CR_PMM_Msk                         /*!< Polling Match Mode */
#define QUADSPI_CR_PRESCALER_Pos            (24U)                                      
#define QUADSPI_CR_PRESCALER_Msk            (0xFFU << QUADSPI_CR_PRESCALER_Pos)        /*!< 0xFF000000 */
#define QUADSPI_CR_PRESCALER                QUADSPI_CR_PRESCALER_Msk                   /*!< PRESCALER[7:0] Clock prescaler */
#define QUADSPI_CR_PRESCALER_0              (0x01U << QUADSPI_CR_PRESCALER_Pos)        /*!< 0x01000000 */
#define QUADSPI_CR_PRESCALER_1              (0x02U << QUADSPI_CR_PRESCALER_Pos)        /*!< 0x02000000 */
#define QUADSPI_CR_PRESCALER_2              (0x04U << QUADSPI_CR_PRESCALER_Pos)        /*!< 0x04000000 */
#define QUADSPI_CR_PRESCALER_3              (0x08U << QUADSPI_CR_PRESCALER_Pos)        /*!< 0x08000000 */
#define QUADSPI_CR_PRESCALER_4              (0x10U << QUADSPI_CR_PRESCALER_Pos)        /*!< 0x10000000 */
#define QUADSPI_CR_PRESCALER_5              (0x20U << QUADSPI_CR_PRESCALER_Pos)        /*!< 0x20000000 */
#define QUADSPI_CR_PRESCALER_6              (0x40U << QUADSPI_CR_PRESCALER_Pos)        /*!< 0x40000000 */
#define QUADSPI_CR_PRESCALER_7              (0x80U << QUADSPI_CR_PRESCALER_Pos)        /*!< 0x80000000 */

/*****************  Bit definition for QUADSPI_DCR register  ******************/
#define QUADSPI_DCR_CKMODE_Pos              (0U)                                
#define QUADSPI_DCR_CKMODE_Msk              (0x1U << QUADSPI_DCR_CKMODE_Pos)           /*!< 0x00000001 */
#define QUADSPI_DCR_CKMODE                  QUADSPI_DCR_CKMODE_Msk                     /*!< Mode 0 / Mode 3 */
#define QUADSPI_DCR_CSHT_Pos                (8U)                                       
#define QUADSPI_DCR_CSHT_Msk                (0x7U << QUADSPI_DCR_CSHT_Pos)             /*!< 0x00000700 */
#define QUADSPI_DCR_CSHT                    QUADSPI_DCR_CSHT_Msk                       /*!< CSHT[2:0]: ChipSelect High Time */
#define QUADSPI_DCR_CSHT_0                  (0x1U << QUADSPI_DCR_CSHT_Pos)             /*!< 0x00000100 */
#define QUADSPI_DCR_CSHT_1                  (0x2U << QUADSPI_DCR_CSHT_Pos)             /*!< 0x00000200 */
#define QUADSPI_DCR_CSHT_2                  (0x4U << QUADSPI_DCR_CSHT_Pos)             /*!< 0x00000400 */
#define QUADSPI_DCR_FSIZE_Pos               (16U)                                      
#define QUADSPI_DCR_FSIZE_Msk               (0x1FU << QUADSPI_DCR_FSIZE_Pos)           /*!< 0x001F0000 */
#define QUADSPI_DCR_FSIZE                   QUADSPI_DCR_FSIZE_Msk                      /*!< FSIZE[4:0]: Flash Size */
#define QUADSPI_DCR_FSIZE_0                 (0x01U << QUADSPI_DCR_FSIZE_Pos)           /*!< 0x00010000 */
#define QUADSPI_DCR_FSIZE_1                 (0x02U << QUADSPI_DCR_FSIZE_Pos)           /*!< 0x00020000 */
#define QUADSPI_DCR_FSIZE_2                 (0x04U << QUADSPI_DCR_FSIZE_Pos)           /*!< 0x00040000 */
#define QUADSPI_DCR_FSIZE_3                 (0x08U << QUADSPI_DCR_FSIZE_Pos)           /*!< 0x00080000 */
#define QUADSPI_DCR_FSIZE_4                 (0x10U << QUADSPI_DCR_FSIZE_Pos)           /*!< 0x00100000 */

/******************  Bit definition for QUADSPI_SR register  *******************/
#define QUADSPI_SR_TEF_Pos                  (0U)                                       
#define QUADSPI_SR_TEF_Msk                  (0x1U << QUADSPI_SR_TEF_Pos)               /*!< 0x00000001 */
#define QUADSPI_SR_TEF                      QUADSPI_SR_TEF_Msk                         /*!< Transfer Error Flag */
#define QUADSPI_SR_TCF_Pos                  (1U)                                       
#define QUADSPI_SR_TCF_Msk                  (0x1U << QUADSPI_SR_TCF_Pos)               /*!< 0x00000002 */
#define QUADSPI_SR_TCF                      QUADSPI_SR_TCF_Msk                         /*!< Transfer Complete Flag */
#define QUADSPI_SR_FTF_Pos                  (2U)                                       
#define QUADSPI_SR_FTF_Msk                  (0x1U << QUADSPI_SR_FTF_Pos)               /*!< 0x00000004 */
#define QUADSPI_SR_FTF                      QUADSPI_SR_FTF_Msk                         /*!< FIFO Threshlod Flag */
#define QUADSPI_SR_SMF_Pos                  (3U)                                       
#define QUADSPI_SR_SMF_Msk                  (0x1U << QUADSPI_SR_SMF_Pos)               /*!< 0x00000008 */
#define QUADSPI_SR_SMF                      QUADSPI_SR_SMF_Msk                         /*!< Status Match Flag */
#define QUADSPI_SR_TOF_Pos                  (4U)                                       
#define QUADSPI_SR_TOF_Msk                  (0x1U << QUADSPI_SR_TOF_Pos)               /*!< 0x00000010 */
#define QUADSPI_SR_TOF                      QUADSPI_SR_TOF_Msk                         /*!< Timeout Flag */
#define QUADSPI_SR_BUSY_Pos                 (5U)                                       
#define QUADSPI_SR_BUSY_Msk                 (0x1U << QUADSPI_SR_BUSY_Pos)              /*!< 0x00000020 */
#define QUADSPI_SR_BUSY                     QUADSPI_SR_BUSY_Msk                        /*!< Busy */
#define QUADSPI_SR_FLEVEL_Pos               (8U)                                       
#define QUADSPI_SR_FLEVEL_Msk               (0x1FU << QUADSPI_SR_FLEVEL_Pos)           /*!< 0x00001F00 */
#define QUADSPI_SR_FLEVEL                   QUADSPI_SR_FLEVEL_Msk                      /*!< FIFO Threshlod Flag */
#define QUADSPI_SR_FLEVEL_0                 (0x01U << QUADSPI_SR_FLEVEL_Pos)           /*!< 0x00000100 */
#define QUADSPI_SR_FLEVEL_1                 (0x02U << QUADSPI_SR_FLEVEL_Pos)           /*!< 0x00000200 */
#define QUADSPI_SR_FLEVEL_2                 (0x04U << QUADSPI_SR_FLEVEL_Pos)           /*!< 0x00000400 */
#define QUADSPI_SR_FLEVEL_3                 (0x08U << QUADSPI_SR_FLEVEL_Pos)           /*!< 0x00000800 */
#define QUADSPI_SR_FLEVEL_4                 (0x10U << QUADSPI_SR_FLEVEL_Pos)           /*!< 0x00001000 */
#define QUADSPI_SR_FLEVEL_5                 (0x20U << QUADSPI_SR_FLEVEL_Pos)           /*!< 0x00002000 */
#define QUADSPI_SR_FLEVEL_6                 (0x30U << QUADSPI_SR_FLEVEL_Pos)           /*!< 0x00003000 */

/******************  Bit definition for QUADSPI_FCR register  ******************/
#define QUADSPI_FCR_CTEF_Pos                (0U)                                
#define QUADSPI_FCR_CTEF_Msk                (0x1U << QUADSPI_FCR_CTEF_Pos)             /*!< 0x00000001 */
#define QUADSPI_FCR_CTEF                    QUADSPI_FCR_CTEF_Msk                       /*!< Clear Transfer Error Flag */
#define QUADSPI_FCR_CTCF_Pos                (1U)                                       
#define QUADSPI_FCR_CTCF_Msk                (0x1U << QUADSPI_FCR_CTCF_Pos)             /*!< 0x00000002 */
#define QUADSPI_FCR_CTCF                    QUADSPI_FCR_CTCF_Msk                       /*!< Clear Transfer Complete Flag */
#define QUADSPI_FCR_CSMF_Pos                (3U)                                       
#define QUADSPI_FCR_CSMF_Msk                (0x1U << QUADSPI_FCR_CSMF_Pos)             /*!< 0x00000008 */
#define QUADSPI_FCR_CSMF                    QUADSPI_FCR_CSMF_Msk                       /*!< Clear Status Match Flag */
#define QUADSPI_FCR_CTOF_Pos                (4U)                                       
#define QUADSPI_FCR_CTOF_Msk                (0x1U << QUADSPI_FCR_CTOF_Pos)             /*!< 0x00000010 */
#define QUADSPI_FCR_CTOF                    QUADSPI_FCR_CTOF_Msk                       /*!< Clear Timeout Flag */

/******************  Bit definition for QUADSPI_DLR register  ******************/
#define QUADSPI_DLR_DL_Pos                  (0U)                                
#define QUADSPI_DLR_DL_Msk                  (0xFFFFFFFFU << QUADSPI_DLR_DL_Pos)        /*!< 0xFFFFFFFF */
#define QUADSPI_DLR_DL                      QUADSPI_DLR_DL_Msk                         /*!< DL[31:0]: Data Length */

/******************  Bit definition for QUADSPI_CCR register  ******************/
#define QUADSPI_CCR_INSTRUCTION_Pos         (0U)                                       
#define QUADSPI_CCR_INSTRUCTION_Msk         (0xFFU << QUADSPI_CCR_INSTRUCTION_Pos)     /*!< 0x000000FF */
#define QUADSPI_CCR_INSTRUCTION             QUADSPI_CCR_INSTRUCTION_Msk                /*!< INSTRUCTION[7:0]: Instruction */
#define QUADSPI_CCR_INSTRUCTION_0           (0x01U << QUADSPI_CCR_INSTRUCTION_Pos)     /*!< 0x00000001 */
#define QUADSPI_CCR_INSTRUCTION_1           (0x02U << QUADSPI_CCR_INSTRUCTION_Pos)     /*!< 0x00000002 */
#define QUADSPI_CCR_INSTRUCTION_2           (0x04U << QUADSPI_CCR_INSTRUCTION_Pos)     /*!< 0x00000004 */
#define QUADSPI_CCR_INSTRUCTION_3           (0x08U << QUADSPI_CCR_INSTRUCTION_Pos)     /*!< 0x00000008 */
#define QUADSPI_CCR_INSTRUCTION_4           (0x10U << QUADSPI_CCR_INSTRUCTION_Pos)     /*!< 0x00000010 */
#define QUADSPI_CCR_INSTRUCTION_5           (0x20U << QUADSPI_CCR_INSTRUCTION_Pos)     /*!< 0x00000020 */
#define QUADSPI_CCR_INSTRUCTION_6           (0x40U << QUADSPI_CCR_INSTRUCTION_Pos)     /*!< 0x00000040 */
#define QUADSPI_CCR_INSTRUCTION_7           (0x80U << QUADSPI_CCR_INSTRUCTION_Pos)     /*!< 0x00000080 */
#define QUADSPI_CCR_IMODE_Pos               (8U)                                       
#define QUADSPI_CCR_IMODE_Msk               (0x3U << QUADSPI_CCR_IMODE_Pos)            /*!< 0x00000300 */
#define QUADSPI_CCR_IMODE                   QUADSPI_CCR_IMODE_Msk                      /*!< IMODE[1:0]: Instruction Mode */
#define QUADSPI_CCR_IMODE_0                 (0x1U << QUADSPI_CCR_IMODE_Pos)            /*!< 0x00000100 */
#define QUADSPI_CCR_IMODE_1                 (0x2U << QUADSPI_CCR_IMODE_Pos)            /*!< 0x00000200 */
#define QUADSPI_CCR_ADMODE_Pos              (10U)                                      
#define QUADSPI_CCR_ADMODE_Msk              (0x3U << QUADSPI_CCR_ADMODE_Pos)           /*!< 0x00000C00 */
#define QUADSPI_CCR_ADMODE                  QUADSPI_CCR_ADMODE_Msk                     /*!< ADMODE[1:0]: Address Mode */
#define QUADSPI_CCR_ADMODE_0                (0x1U << QUADSPI_CCR_ADMODE_Pos)           /*!< 0x00000400 */
#define QUADSPI_CCR_ADMODE_1                (0x2U << QUADSPI_CCR_ADMODE_Pos)           /*!< 0x00000800 */
#define QUADSPI_CCR_ADSIZE_Pos              (12U)                                      
#define QUADSPI_CCR_ADSIZE_Msk              (0x3U << QUADSPI_CCR_ADSIZE_Pos)           /*!< 0x00003000 */
#define QUADSPI_CCR_ADSIZE                  QUADSPI_CCR_ADSIZE_Msk                     /*!< ADSIZE[1:0]: Address Size */
#define QUADSPI_CCR_ADSIZE_0                (0x1U << QUADSPI_CCR_ADSIZE_Pos)           /*!< 0x00001000 */
#define QUADSPI_CCR_ADSIZE_1                (0x2U << QUADSPI_CCR_ADSIZE_Pos)           /*!< 0x00002000 */
#define QUADSPI_CCR_ABMODE_Pos              (14U)                                      
#define QUADSPI_CCR_ABMODE_Msk              (0x3U << QUADSPI_CCR_ABMODE_Pos)           /*!< 0x0000C000 */
#define QUADSPI_CCR_ABMODE                  QUADSPI_CCR_ABMODE_Msk                     /*!< ABMODE[1:0]: Alternate Bytes Mode */
#define QUADSPI_CCR_ABMODE_0                (0x1U << QUADSPI_CCR_ABMODE_Pos)           /*!< 0x00004000 */
#define QUADSPI_CCR_ABMODE_1                (0x2U << QUADSPI_CCR_ABMODE_Pos)           /*!< 0x00008000 */
#define QUADSPI_CCR_ABSIZE_Pos              (16U)                                      
#define QUADSPI_CCR_ABSIZE_Msk              (0x3U << QUADSPI_CCR_ABSIZE_Pos)           /*!< 0x00030000 */
#define QUADSPI_CCR_ABSIZE                  QUADSPI_CCR_ABSIZE_Msk                     /*!< ABSIZE[1:0]: Instruction Mode */
#define QUADSPI_CCR_ABSIZE_0                (0x1U << QUADSPI_CCR_ABSIZE_Pos)           /*!< 0x00010000 */
#define QUADSPI_CCR_ABSIZE_1                (0x2U << QUADSPI_CCR_ABSIZE_Pos)           /*!< 0x00020000 */
#define QUADSPI_CCR_DCYC_Pos                (18U)                                      
#define QUADSPI_CCR_DCYC_Msk                (0x1FU << QUADSPI_CCR_DCYC_Pos)            /*!< 0x007C0000 */
#define QUADSPI_CCR_DCYC                    QUADSPI_CCR_DCYC_Msk                       /*!< DCYC[4:0]: Dummy Cycles */
#define QUADSPI_CCR_DCYC_0                  (0x01U << QUADSPI_CCR_DCYC_Pos)            /*!< 0x00040000 */
#define QUADSPI_CCR_DCYC_1                  (0x02U << QUADSPI_CCR_DCYC_Pos)            /*!< 0x00080000 */
#define QUADSPI_CCR_DCYC_2                  (0x04U << QUADSPI_CCR_DCYC_Pos)            /*!< 0x00100000 */
#define QUADSPI_CCR_DCYC_3                  (0x08U << QUADSPI_CCR_DCYC_Pos)            /*!< 0x00200000 */
#define QUADSPI_CCR_DCYC_4                  (0x10U << QUADSPI_CCR_DCYC_Pos)            /*!< 0x00400000 */
#define QUADSPI_CCR_DMODE_Pos               (24U)                                      
#define QUADSPI_CCR_DMODE_Msk               (0x3U << QUADSPI_CCR_DMODE_Pos)            /*!< 0x03000000 */
#define QUADSPI_CCR_DMODE                   QUADSPI_CCR_DMODE_Msk                      /*!< DMODE[1:0]: Data Mode */
#define QUADSPI_CCR_DMODE_0                 (0x1U << QUADSPI_CCR_DMODE_Pos)            /*!< 0x01000000 */
#define QUADSPI_CCR_DMODE_1                 (0x2U << QUADSPI_CCR_DMODE_Pos)            /*!< 0x02000000 */
#define QUADSPI_CCR_FMODE_Pos               (26U)                                      
#define QUADSPI_CCR_FMODE_Msk               (0x3U << QUADSPI_CCR_FMODE_Pos)            /*!< 0x0C000000 */
#define QUADSPI_CCR_FMODE                   QUADSPI_CCR_FMODE_Msk                      /*!< FMODE[1:0]: Functional Mode */
#define QUADSPI_CCR_FMODE_0                 (0x1U << QUADSPI_CCR_FMODE_Pos)            /*!< 0x04000000 */
#define QUADSPI_CCR_FMODE_1                 (0x2U << QUADSPI_CCR_FMODE_Pos)            /*!< 0x08000000 */
#define QUADSPI_CCR_SIOO_Pos                (28U)                                      
#define QUADSPI_CCR_SIOO_Msk                (0x1U << QUADSPI_CCR_SIOO_Pos)             /*!< 0x10000000 */
#define QUADSPI_CCR_SIOO                    QUADSPI_CCR_SIOO_Msk                       /*!< SIOO: Send Instruction Only Once Mode */
#define QUADSPI_CCR_DHHC_Pos                (30U)                                      
#define QUADSPI_CCR_DHHC_Msk                (0x1U << QUADSPI_CCR_DHHC_Pos)             /*!< 0x40000000 */
#define QUADSPI_CCR_DHHC                    QUADSPI_CCR_DHHC_Msk                       /*!< DHHC: DDR hold half cycle */
#define QUADSPI_CCR_DDRM_Pos                (31U)                                      
#define QUADSPI_CCR_DDRM_Msk                (0x1U << QUADSPI_CCR_DDRM_Pos)             /*!< 0x80000000 */
#define QUADSPI_CCR_DDRM                    QUADSPI_CCR_DDRM_Msk                       /*!< DDRM: Double Data Rate Mode */

/******************  Bit definition for QUADSPI_AR register  *******************/
#define QUADSPI_AR_ADDRESS_Pos              (0U)                                  
#define QUADSPI_AR_ADDRESS_Msk              (0xFFFFFFFFU << QUADSPI_AR_ADDRESS_Pos)    /*!< 0xFFFFFFFF */
#define QUADSPI_AR_ADDRESS                  QUADSPI_AR_ADDRESS_Msk                     /*!< ADDRESS[31:0]: Address */

/******************  Bit definition for QUADSPI_ABR register  ******************/
#define QUADSPI_ABR_ALTERNATE_Pos           (0U)                                  
#define QUADSPI_ABR_ALTERNATE_Msk           (0xFFFFFFFFU << QUADSPI_ABR_ALTERNATE_Pos) /*!< 0xFFFFFFFF */
#define QUADSPI_ABR_ALTERNATE               QUADSPI_ABR_ALTERNATE_Msk                  /*!< ALTERNATE[31:0]: Alternate Bytes */

/******************  Bit definition for QUADSPI_DR register  *******************/
#define QUADSPI_DR_DATA_Pos                 (0U)                                  
#define QUADSPI_DR_DATA_Msk                 (0xFFFFFFFFU << QUADSPI_DR_DATA_Pos)       /*!< 0xFFFFFFFF */
#define QUADSPI_DR_DATA                     QUADSPI_DR_DATA_Msk                        /*!< DATA[31:0]: Data */

/******************  Bit definition for QUADSPI_PSMKR register  ****************/
#define QUADSPI_PSMKR_MASK_Pos              (0U)                                  
#define QUADSPI_PSMKR_MASK_Msk              (0xFFFFFFFFU << QUADSPI_PSMKR_MASK_Pos)    /*!< 0xFFFFFFFF */
#define QUADSPI_PSMKR_MASK                  QUADSPI_PSMKR_MASK_Msk                     /*!< MASK[31:0]: Status Mask */

/******************  Bit definition for QUADSPI_PSMAR register  ****************/
#define QUADSPI_PSMAR_MATCH_Pos             (0U)                                  
#define QUADSPI_PSMAR_MATCH_Msk             (0xFFFFFFFFU << QUADSPI_PSMAR_MATCH_Pos)   /*!< 0xFFFFFFFF */
#define QUADSPI_PSMAR_MATCH                 QUADSPI_PSMAR_MATCH_Msk                    /*!< MATCH[31:0]: Status Match */

/******************  Bit definition for QUADSPI_PIR register  *****************/
#define QUADSPI_PIR_INTERVAL_Pos            (0U)                                  
#define QUADSPI_PIR_INTERVAL_Msk            (0xFFFFU << QUADSPI_PIR_INTERVAL_Pos)      /*!< 0x0000FFFF */
#define QUADSPI_PIR_INTERVAL                QUADSPI_PIR_INTERVAL_Msk                   /*!< INTERVAL[15:0]: Polling Interval */

/******************  Bit definition for QUADSPI_LPTR register  *****************/
#define QUADSPI_LPTR_TIMEOUT_Pos            (0U)                                  
#define QUADSPI_LPTR_TIMEOUT_Msk            (0xFFFFU << QUADSPI_LPTR_TIMEOUT_Pos)      /*!< 0x0000FFFF */
#define QUADSPI_LPTR_TIMEOUT                QUADSPI_LPTR_TIMEOUT_Msk                   /*!< TIMEOUT[15:0]: Timeout period */

/******************************************************************************/
/*                                                                            */
/*                       SD host Interface (SDIO)                             */
/*                                                                            */
/******************************************************************************/

/******************  Bit definition for SDIO_CTRL register  ******************/
#define SDIO_CTRL_CTRL_RST_Pos              (0U)
#define SDIO_CTRL_CTRL_RST_Msk              (0x1U << SDIO_CTRL_CTRL_RST_Pos)
#define SDIO_CTRL_CTRL_RST                  SDIO_CTRL_CTRL_RST_Msk
#define SDIO_CTRL_FIFO_RST_Pos              (1U)
#define SDIO_CTRL_FIFO_RST_Msk              (0x1U << SDIO_CTRL_FIFO_RST_Pos)
#define SDIO_CTRL_FIFO_RST                  SDIO_CTRL_FIFO_RST_Msk
#define SDIO_CTRL_DMA_RST_Pos               (2U)
#define SDIO_CTRL_DMA_RST_Msk               (0x1U << SDIO_CTRL_DMA_RST_Pos)
#define SDIO_CTRL_DMA_RST                   SDIO_CTRL_DMA_RST_Msk
#define SDIO_CTRL_INT_ENABLE_Pos            (4U)
#define SDIO_CTRL_INT_ENABLE_Msk            (0x1U << SDIO_CTRL_INT_ENABLE_Pos)
#define SDIO_CTRL_INT_ENABLE                SDIO_CTRL_INT_ENABLE_Msk
#define SDIO_CTRL_DMA_ENABLE_Pos            (5U)
#define SDIO_CTRL_DMA_ENABLE_Msk            (0x1U << SDIO_CTRL_DMA_ENABLE_Pos)
#define SDIO_CTRL_DMA_ENABLE                SDIO_CTRL_DMA_ENABLE_Msk
#define SDIO_CTRL_READ_WAIT_Pos             (6U)
#define SDIO_CTRL_READ_WAIT_Msk             (0x1U << SDIO_CTRL_READ_WAIT_Pos)
#define SDIO_CTRL_READ_WAIT                 SDIO_CTRL_READ_WAIT_Msk
#define SDIO_CTRL_SEND_IRQ_RESP_Pos         (7U)
#define SDIO_CTRL_SEND_IRQ_RESP_Msk         (0x1U << SDIO_CTRL_SEND_IRQ_RESP_Pos)
#define SDIO_CTRL_SEND_IRQ_RESP             SDIO_CTRL_SEND_IRQ_RESP_Msk
#define SDIO_CTRL_ABORT_READ_DATA_Pos       (8U)
#define SDIO_CTRL_ABORT_READ_DATA_Msk       (0x1U << SDIO_CTRL_ABORT_READ_DATA_Pos)
#define SDIO_CTRL_ABORT_READ_DATA           SDIO_CTRL_ABORT_READ_DATA_Msk
#define SDIO_CTRL_CEATA_INT_STAT_Pos        (11U)
#define SDIO_CTRL_CEATA_INT_STAT_Msk        (0x1U << SDIO_CTRL_CEATA_INT_STAT_Pos)
#define SDIO_CTRL_CEATA_INT_STAT            SDIO_CTRL_CEATA_INT_STAT_Msk
#define SDIO_CTRL_CARD_VLTG_A_Pos           (16U)
#define SDIO_CTRL_CARD_VLTG_A_Msk           (0xFU << SDIO_CTRL_CARD_VLTG_A_Pos)
#define SDIO_CTRL_CARD_VLTG_A               SDIO_CTRL_CARD_VLTG_A_Msk
#define SDIO_CTRL_CARD_VLTG_B_Pos           (20U)
#define SDIO_CTRL_CARD_VLTG_B_Msk           (0xFU << SDIO_CTRL_CARD_VLTG_B_Pos)
#define SDIO_CTRL_CARD_VLTG_B               SDIO_CTRL_CARD_VLTG_B_Msk
#define SDIO_CTRL_EN_OD_Pos                 (24U)
#define SDIO_CTRL_EN_OD_Msk                 (0x1U << SDIO_CTRL_EN_OD_Pos)
#define SDIO_CTRL_EN_OD                     SDIO_CTRL_EN_OD_Msk
#define SDIO_CTRL_INTERNAL_DMAC_Pos         (25U)
#define SDIO_CTRL_INTERNAL_DMAC_Msk         (0x1U << SDIO_CTRL_INTERNAL_DMAC_Pos)
#define SDIO_CTRL_INTERNAL_DMAC             SDIO_CTRL_INTERNAL_DMAC_Msk

/*******************  Bit definition for SDIO_CLKDIV register  *******************/
#define SDIO_CLKDIV_DIVIDER_Pos             (0U)
#define SDIO_CLKDIV_DIVIDER_Msk             (0xFFU << SDIO_CLKDIV_DIVIDER_Pos)
#define SDIO_CLKDIV_DIVIDER                 SDIO_CLKDIV_DIVIDER_Msk

/*******************  Bit definition for SDIO_CLKENA register  *******************/
#define SDIO_CLKENA_CLK_ENABLE_Pos          (0U)
#define SDIO_CLKENA_CLK_ENABLE_Msk          (0x1U << SDIO_CLKENA_CLK_ENABLE_Pos)
#define SDIO_CLKENA_CLK_ENABLE              SDIO_CLKENA_CLK_ENABLE_Msk

#define SDIO_CLKENA_LOW_POWER_Pos           (16U)
#define SDIO_CLKENA_LOW_POWER_Msk           (0x1U << SDIO_CLKENA_LOW_POWER_Pos)
#define SDIO_CLKENA_LOW_POWER               SDIO_CLKENA_LOW_POWER_Msk

/*******************  Bit definition for SDIO_TIMOUT register  *******************/
#define SDIO_TIMOUT_DATA_TIMOUT_Pos         (0U)
#define SDIO_TIMOUT_DATA_TIMOUT_Msk         (0xFFU << SDIO_TIMOUT_DATA_TIMOUT_Pos)
#define SDIO_TIMOUT_DATA_TIMOUT             SDIO_TIMOUT_DATA_TIMOUT_Msk

#define SDIO_TIMOUT_RESPONSE_TIMOUT_Pos     (8U)
#define SDIO_TIMOUT_RESPONSE_TIMOUT_Msk     (0xFFFFFFU << SDIO_TIMOUT_RESPONSE_TIMOUT_Pos)
#define SDIO_TIMOUT_RESPONSE_TIMOUT         SDIO_TIMOUT_RESPONSE_TIMOUT_Msk

/*******************  Bit definition for SDIO_WIDTH register  *******************/
#define SDIO_CTYPE_WIDTH0_Pos               (0U)
#define SDIO_CTYPE_WIDTH0_Msk               (0x1U << SDIO_CTYPE_WIDTH0_Pos)
#define SDIO_CTYPE_WIDTH0                   SDIO_CTYPE_WIDTH0_Msk

#define SDIO_CTYPE_WIDTH1_Pos               (16U)
#define SDIO_CTYPE_WIDTH1_Msk               (0x1U << SDIO_CTYPE_WIDTH1_Pos)
#define SDIO_CTYPE_WIDTH1                   SDIO_CTYPE_WIDTH1_Msk

/*******************  Bit definition for SDIO_BLKSIZE register  *******************/
#define SDIO_BLKSIZE_BLOCKSIZE_Pos          (0U)
#define SDIO_BLKSIZE_BLOCKSIZE_Msk          (0xFFFFU << SDIO_BLKSIZE_BLOCKSIZE_Pos)
#define SDIO_BLKSIZE_BLOCKSIZE              SDIO_BLKSIZE_BLOCKSIZE_Msk

/*******************  Bit definition for SDIO_BYTCNT register  *******************/
#define SDIO_BYTCNT_BYTECOUNT_Pos           (0U)
#define SDIO_BYTCNT_BYTECOUNT_Msk           (0xFFFFFFFFU << SDIO_BYTCNT_BYTECOUNT_Pos)
#define SDIO_BYTCNT_BYTECOUNT               SDIO_BYTCNT_BYTECOUNT_Msk

/*******************  Bit definition for SDIO_INTMASK register  *******************/
#define SDIO_INTMASK_CARDDETECT_Pos         (0U)
#define SDIO_INTMASK_CARDDETECT_Msk         (0x1U << SDIO_INTMASK_CARDDETECT_Pos)
#define SDIO_INTMASK_CARDDETECT             SDIO_INTMASK_CARDDETECT_Msk
#define SDIO_INTMASK_RESPERR_Pos            (1U)
#define SDIO_INTMASK_RESPERR_Msk            (0x1U << SDIO_INTMASK_RESPERR_Pos)
#define SDIO_INTMASK_RESPERR                SDIO_INTMASK_RESPERR_Msk
#define SDIO_INTMASK_CMDDONE_Pos            (2U)
#define SDIO_INTMASK_CMDDONE_Msk            (0x1U << SDIO_INTMASK_CMDDONE_Pos)
#define SDIO_INTMASK_CMDDONE                SDIO_INTMASK_CMDDONE_Msk
#define SDIO_INTMASK_DTRANSFEROVER_Pos      (3U)
#define SDIO_INTMASK_DTRANSFEROVER_Msk      (0x1U << SDIO_INTMASK_DTRANSFEROVER_Pos)
#define SDIO_INTMASK_DTRANSFEROVER          SDIO_INTMASK_DTRANSFEROVER_Msk
#define SDIO_INTMASK_TXDATAREQ_Pos          (4U)
#define SDIO_INTMASK_TXDATAREQ_Msk          (0x1U << SDIO_INTMASK_TXDATAREQ_Pos)
#define SDIO_INTMASK_TXDATAREQ              SDIO_INTMASK_TXDATAREQ_Msk
#define SDIO_INTMASK_RXDATAREQ_Pos          (5U)
#define SDIO_INTMASK_RXDATAREQ_Msk          (0x1U << SDIO_INTMASK_RXDATAREQ_Pos)
#define SDIO_INTMASK_RXDATAREQ              SDIO_INTMASK_RXDATAREQ_Msk
#define SDIO_INTMASK_RESPCRCERR_Pos         (6U)
#define SDIO_INTMASK_RESPCRCERR_Msk         (0x1U << SDIO_INTMASK_RESPCRCERR_Pos)
#define SDIO_INTMASK_RESPCRCERR             SDIO_INTMASK_RESPCRCERR_Msk
#define SDIO_INTMASK_DATACRCERR_Pos         (7U)
#define SDIO_INTMASK_DATACRCERR_Msk         (0x1U << SDIO_INTMASK_DATACRCERR_Pos)
#define SDIO_INTMASK_DATACRCERR             SDIO_INTMASK_DATACRCERR_Msk
#define SDIO_INTMASK_RESPTIMEOUT_Pos        (8U)
#define SDIO_INTMASK_RESPTIMEOUT_Msk        (0x1U << SDIO_INTMASK_RESPTIMEOUT_Pos)
#define SDIO_INTMASK_RESPTIMEOUT            SDIO_INTMASK_RESPTIMEOUT_Msk
#define SDIO_INTMASK_DATATIMEOUT_Pos        (9U)
#define SDIO_INTMASK_DATATIMEOUT_Msk        (0x1U << SDIO_INTMASK_DATATIMEOUT_Pos)
#define SDIO_INTMASK_DATATIMEOUT            SDIO_INTMASK_DATATIMEOUT_Msk
#define SDIO_INTMASK_DATASTARV_Pos          (10U)
#define SDIO_INTMASK_DATASTARV_Msk          (0x1U << SDIO_INTMASK_DATASTARV_Pos)
#define SDIO_INTMASK_DATASTARV              SDIO_INTMASK_DATASTARV_Msk
#define SDIO_INTMASK_UNDER_OVER_RUN_Pos     (11U)
#define SDIO_INTMASK_UNDER_OVER_RUN_Msk     (0x1U << SDIO_INTMASK_UNDER_OVER_RUN_Pos)
#define SDIO_INTMASK_UNDER_OVER_RUN         SDIO_INTMASK_UNDER_OVER_RUN_Msk
#define SDIO_INTMASK_HLE_Pos                (12U)
#define SDIO_INTMASK_HLE_Msk                (0x1U << SDIO_INTMASK_HLE_Pos)
#define SDIO_INTMASK_HLE                    SDIO_INTMASK_HLE_Msk
#define SDIO_INTMASK_STARTERROR_Pos         (13U)
#define SDIO_INTMASK_STARTERROR_Msk         (0x1U << SDIO_INTMASK_STARTERROR_Pos)
#define SDIO_INTMASK_STARTERROR             SDIO_INTMASK_STARTERROR_Msk
#define SDIO_INTMASK_BUSYCLEAR_Pos          (13U)
#define SDIO_INTMASK_BUSYCLEAR_Msk          (0x1U << SDIO_INTMASK_BUSYCLEAR_Pos)
#define SDIO_INTMASK_BUSYCLEAR              SDIO_INTMASK_BUSYCLEAR_Msk
#define SDIO_INTMASK_AUTOCMDDONE_Pos        (14U)
#define SDIO_INTMASK_AUTOCMDDONE_Msk        (0x1U << SDIO_INTMASK_AUTOCMDDONE_Pos)
#define SDIO_INTMASK_AUTOCMDDONE            SDIO_INTMASK_AUTOCMDDONE_Msk
#define SDIO_INTMASK_ENDERROR_Pos           (15U)
#define SDIO_INTMASK_ENDERROR_Msk           (0x1U << SDIO_INTMASK_ENDERROR_Pos)
#define SDIO_INTMASK_ENDERROR               SDIO_INTMASK_ENDERROR_Msk
#define SDIO_INTMASK_SDIOIT_Pos             (16U)
#define SDIO_INTMASK_SDIOIT_Msk             (0xFFFFU << SDIO_INTMASK_SDIOIT_Pos)
#define SDIO_INTMASK_SDIOIT                 SDIO_INTMASK_SDIOIT_Msk

/*******************  Bit definition for SDIO_CMDARG register  *******************/
#define SDIO_CMD_CMDARG_Pos                 (0U)
#define SDIO_CMD_CMDARG_Msk                 (0xFFFFFFFFU << SDIO_CMD_CMDARG_Pos)
#define SDIO_CMD_CMDARG                     SDIO_CMD_CMDARG_Msk

/*******************  Bit definition for SDIO_CMD register  *******************/
#define SDIO_CMD_CMDINDEX_Pos               (0U)
#define SDIO_CMD_CMDINDEX_Msk               (0x3FU << SDIO_CMD_CMDINDEX_Pos)
#define SDIO_CMD_CMDINDEX                   SDIO_CMD_CMDINDEX_Msk
#define SDIO_CMD_RESP_EXPECT_Pos            (6U)
#define SDIO_CMD_RESP_EXPECT_Msk            (0x1U << SDIO_CMD_RESP_EXPECT_Pos)
#define SDIO_CMD_RESP_EXPECT                SDIO_CMD_RESP_EXPECT_Msk
#define SDIO_CMD_RESP_LENGTH_Pos            (7U)
#define SDIO_CMD_RESP_LENGTH_Msk            (0x1U << SDIO_CMD_RESP_LENGTH_Pos)
#define SDIO_CMD_RESP_LENGTH                SDIO_CMD_RESP_LENGTH_Msk
#define SDIO_CMD_CHECK_RESP_CRC_Pos         (8U)
#define SDIO_CMD_CHECK_RESP_CRC_Msk         (0x1U << SDIO_CMD_CHECK_RESP_CRC_Pos)
#define SDIO_CMD_CHECK_RESP_CRC             SDIO_CMD_CHECK_RESP_CRC_Msk
#define SDIO_CMD_DATA_EXPECT_Pos            (9U)
#define SDIO_CMD_DATA_EXPECT_Msk            (0x1U << SDIO_CMD_DATA_EXPECT_Pos)
#define SDIO_CMD_DATA_EXPECT                SDIO_CMD_DATA_EXPECT_Msk
#define SDIO_CMD_READ_WRITE_Pos             (10U)
#define SDIO_CMD_READ_WRITE_Msk             (0x1U << SDIO_CMD_READ_WRITE_Pos)
#define SDIO_CMD_READ_WRITE                 SDIO_CMD_READ_WRITE_Msk
#define SDIO_CMD_TRANSFER_MODE_Pos          (11U)
#define SDIO_CMD_TRANSFER_MODE_Msk          (0x1U << SDIO_CMD_TRANSFER_MODE_Pos)
#define SDIO_CMD_TRANSFER_MODE              SDIO_CMD_TRANSFER_MODE_Msk
#define SDIO_CMD_SEND_AUTO_STOP_Pos         (12U)
#define SDIO_CMD_SEND_AUTO_STOP_Msk         (0x1U << SDIO_CMD_SEND_AUTO_STOP_Pos)
#define SDIO_CMD_SEND_AUTO_STOP             SDIO_CMD_SEND_AUTO_STOP_Msk
#define SDIO_CMD_WAIT_PRV_COMPLT_Pos        (13U)
#define SDIO_CMD_WAIT_PRV_COMPLT_Msk        (0x1U << SDIO_CMD_WAIT_PRV_COMPLT_Pos)
#define SDIO_CMD_WAIT_PRV_COMPLT            SDIO_CMD_WAIT_PRV_COMPLT_Msk
#define SDIO_CMD_STOP_ABORT_CMD_Pos         (14U)
#define SDIO_CMD_STOP_ABORT_CMD_Msk         (0x1U << SDIO_CMD_STOP_ABORT_CMD_Pos)
#define SDIO_CMD_STOP_ABORT_CMD             SDIO_CMD_STOP_ABORT_CMD_Msk
#define SDIO_CMD_SEND_INITIALIZATION_Pos    (15U)
#define SDIO_CMD_SEND_INITIALIZATION_Msk    (0x1U << SDIO_CMD_SEND_INITIALIZATION_Pos)
#define SDIO_CMD_SEND_INITIALIZATION        SDIO_CMD_SEND_INITIALIZATION_Msk

/******************  Bit definition for SDIO_MINISTS register  ********************/
#define SDIO_MINISTS_CARDDETECT_Pos         (0U)
#define SDIO_MINISTS_CARDDETECT_Msk         (0x1U << SDIO_MINISTS_CARDDETECT_Pos)
#define SDIO_MINISTS_CARDDETECT             SDIO_MINISTS_CARDDETECT_Msk
#define SDIO_MINISTS_RESPERR_Pos            (1U)
#define SDIO_MINISTS_RESPERR_Msk            (0x1U << SDIO_MINISTS_RESPERR_Pos)
#define SDIO_MINISTS_RESPERR                SDIO_MINISTS_RESPERR_Msk
#define SDIO_MINISTS_CMDDONE_Pos            (2U)
#define SDIO_MINISTS_CMDDONE_Msk            (0x1U << SDIO_MINISTS_CMDDONE_Pos)
#define SDIO_MINISTS_CMDDONE                SDIO_MINISTS_CMDDONE_Msk
#define SDIO_MINISTS_DTRANSFEROVER_Pos      (3U)
#define SDIO_MINISTS_DTRANSFEROVER_Msk      (0x1U << SDIO_MINISTS_DTRANSFEROVER_Pos)
#define SDIO_MINISTS_DTRANSFEROVER          SDIO_MINISTS_DTRANSFEROVER_Msk
#define SDIO_MINISTS_TXDATAREQ_Pos          (4U)
#define SDIO_MINISTS_TXDATAREQ_Msk          (0x1U << SDIO_MINISTS_TXDATAREQ_Pos)
#define SDIO_MINISTS_TXDATAREQ              SDIO_MINISTS_TXDATAREQ_Msk
#define SDIO_MINISTS_RXDATAREQ_Pos          (5U)
#define SDIO_MINISTS_RXDATAREQ_Msk          (0x1U << SDIO_MINISTS_RXDATAREQ_Pos)
#define SDIO_MINISTS_RXDATAREQ              SDIO_MINISTS_RXDATAREQ_Msk
#define SDIO_MINISTS_RESPCRCERR_Pos         (6U)
#define SDIO_MINISTS_RESPCRCERR_Msk         (0x1U << SDIO_MINISTS_RESPCRCERR_Pos)
#define SDIO_MINISTS_RESPCRCERR             SDIO_MINISTS_RESPCRCERR_Msk
#define SDIO_MINISTS_DATACRCERR_Pos         (7U)
#define SDIO_MINISTS_DATACRCERR_Msk         (0x1U << SDIO_MINISTS_DATACRCERR_Pos)
#define SDIO_MINISTS_DATACRCERR             SDIO_MINISTS_DATACRCERR_Msk
#define SDIO_MINISTS_RESPTIMEOUT_Pos        (8U)
#define SDIO_MINISTS_RESPTIMEOUT_Msk        (0x1U << SDIO_MINISTS_RESPTIMEOUT_Pos)
#define SDIO_MINISTS_RESPTIMEOUT            SDIO_MINISTS_RESPTIMEOUT_Msk
#define SDIO_MINISTS_DATATIMEOUT_Pos        (9U)
#define SDIO_MINISTS_DATATIMEOUT_Msk        (0x1U << SDIO_MINISTS_DATATIMEOUT_Pos)
#define SDIO_MINISTS_DATATIMEOUT            SDIO_MINISTS_DATATIMEOUT_Msk
#define SDIO_MINISTS_DATASTARV_Pos          (10U)
#define SDIO_MINISTS_DATASTARV_Msk          (0x1U << SDIO_MINISTS_DATASTARV_Pos)
#define SDIO_MINISTS_DATASTARV              SDIO_MINISTS_DATASTARV_Msk
#define SDIO_MINISTS_UNDER_OVER_RUN_Pos     (11U)
#define SDIO_MINISTS_UNDER_OVER_RUN_Msk     (0x1U << SDIO_MINISTS_UNDER_OVER_RUN_Pos)
#define SDIO_MINISTS_UNDER_OVER_RUN         SDIO_MINISTS_UNDER_OVER_RUN_Msk
#define SDIO_MINISTS_HLE_Pos                (12U)
#define SDIO_MINISTS_HLE_Msk                (0x1U << SDIO_MINISTS_HLE_Pos)
#define SDIO_MINISTS_HLE                    SDIO_MINISTS_HLE_Msk
#define SDIO_MINISTS_STARTERROR_Pos         (13U)
#define SDIO_MINISTS_STARTERROR_Msk         (0x1U << SDIO_MINISTS_STARTERROR_Pos)
#define SDIO_MINISTS_STARTERROR             SDIO_MINISTS_STARTERROR_Msk
#define SDIO_MINISTS_BUSYCLEAR_Pos          (13U)
#define SDIO_MINISTS_BUSYCLEAR_Msk          (0x1U << SDIO_MINISTS_BUSYCLEAR_Pos)
#define SDIO_MINISTS_BUSYCLEAR              SDIO_MINISTS_BUSYCLEAR_Msk
#define SDIO_MINISTS_AUTOCMDDONE_Pos        (14U)
#define SDIO_MINISTS_AUTOCMDDONE_Msk        (0x1U << SDIO_MINISTS_AUTOCMDDONE_Pos)
#define SDIO_MINISTS_AUTOCMDDONE            SDIO_MINISTS_AUTOCMDDONE_Msk
#define SDIO_MINISTS_ENDERROR_Pos           (15U)
#define SDIO_MINISTS_ENDERROR_Msk           (0x1U << SDIO_MINISTS_ENDERROR_Pos)
#define SDIO_MINISTS_ENDERROR               SDIO_MINISTS_ENDERROR_Msk
#define SDIO_MINISTS_SDIOIT_Pos             (16U)
#define SDIO_MINISTS_SDIOIT_Msk             (0xFFFFU << SDIO_MINISTS_SDIOIT_Pos)
#define SDIO_MINISTS_SDIOIT                 SDIO_MINISTS_SDIOIT_Msk

/******************  Bit definition for SDIO_RINTSTS register  ********************/
#define SDIO_RINTSTS_CARDDETECT_Pos         (0U)
#define SDIO_RINTSTS_CARDDETECT_Msk         (0x1U << SDIO_RINTSTS_CARDDETECT_Pos)
#define SDIO_RINTSTS_CARDDETECT             SDIO_RINTSTS_CARDDETECT_Msk
#define SDIO_RINTSTS_RESPERR_Pos            (1U)
#define SDIO_RINTSTS_RESPERR_Msk            (0x1U << SDIO_RINTSTS_RESPERR_Pos)
#define SDIO_RINTSTS_RESPERR                SDIO_RINTSTS_RESPERR_Msk
#define SDIO_RINTSTS_CMDDONE_Pos            (2U)
#define SDIO_RINTSTS_CMDDONE_Msk            (0x1U << SDIO_RINTSTS_CMDDONE_Pos)
#define SDIO_RINTSTS_CMDDONE                SDIO_RINTSTS_CMDDONE_Msk
#define SDIO_RINTSTS_DTRANSFEROVER_Pos      (3U)
#define SDIO_RINTSTS_DTRANSFEROVER_Msk      (0x1U << SDIO_RINTSTS_DTRANSFEROVER_Pos)
#define SDIO_RINTSTS_DTRANSFEROVER          SDIO_RINTSTS_DTRANSFEROVER_Msk
#define SDIO_RINTSTS_TXDATAREQ_Pos          (4U)
#define SDIO_RINTSTS_TXDATAREQ_Msk          (0x1U << SDIO_RINTSTS_TXDATAREQ_Pos)
#define SDIO_RINTSTS_TXDATAREQ              SDIO_RINTSTS_TXDATAREQ_Msk
#define SDIO_RINTSTS_RXDATAREQ_Pos          (5U)
#define SDIO_RINTSTS_RXDATAREQ_Msk          (0x1U << SDIO_RINTSTS_RXDATAREQ_Pos)
#define SDIO_RINTSTS_RXDATAREQ              SDIO_RINTSTS_RXDATAREQ_Msk
#define SDIO_RINTSTS_RESPCRCERR_Pos         (6U)
#define SDIO_RINTSTS_RESPCRCERR_Msk         (0x1U << SDIO_RINTSTS_RESPCRCERR_Pos)
#define SDIO_RINTSTS_RESPCRCERR             SDIO_RINTSTS_RESPCRCERR_Msk
#define SDIO_RINTSTS_DATACRCERR_Pos         (7U)
#define SDIO_RINTSTS_DATACRCERR_Msk         (0x1U << SDIO_RINTSTS_DATACRCERR_Pos)
#define SDIO_RINTSTS_DATACRCERR             SDIO_RINTSTS_DATACRCERR_Msk
#define SDIO_RINTSTS_RESPTIMEOUT_Pos        (8U)
#define SDIO_RINTSTS_RESPTIMEOUT_Msk        (0x1U << SDIO_RINTSTS_RESPTIMEOUT_Pos)
#define SDIO_RINTSTS_RESPTIMEOUT            SDIO_RINTSTS_RESPTIMEOUT_Msk
#define SDIO_RINTSTS_DATATIMEOUT_Pos        (9U)
#define SDIO_RINTSTS_DATATIMEOUT_Msk        (0x1U << SDIO_RINTSTS_DATATIMEOUT_Pos)
#define SDIO_RINTSTS_DATATIMEOUT            SDIO_RINTSTS_DATATIMEOUT_Msk
#define SDIO_RINTSTS_DATASTARV_Pos          (10U)
#define SDIO_RINTSTS_DATASTARV_Msk          (0x1U << SDIO_RINTSTS_DATASTARV_Pos)
#define SDIO_RINTSTS_DATASTARV              SDIO_RINTSTS_DATASTARV_Msk
#define SDIO_RINTSTS_UNDER_OVER_RUN_Pos     (11U)
#define SDIO_RINTSTS_UNDER_OVER_RUN_Msk     (0x1U << SDIO_RINTSTS_UNDER_OVER_RUN_Pos)
#define SDIO_RINTSTS_UNDER_OVER_RUN         SDIO_RINTSTS_UNDER_OVER_RUN_Msk
#define SDIO_RINTSTS_HLE_Pos                (12U)
#define SDIO_RINTSTS_HLE_Msk                (0x1U << SDIO_RINTSTS_HLE_Pos)
#define SDIO_RINTSTS_HLE                    SDIO_RINTSTS_HLE_Msk
#define SDIO_RINTSTS_STARTERROR_Pos         (13U)
#define SDIO_RINTSTS_STARTERROR_Msk         (0x1U << SDIO_RINTSTS_STARTERROR_Pos)
#define SDIO_RINTSTS_STARTERROR             SDIO_RINTSTS_STARTERROR_Msk
#define SDIO_RINTSTS_BUSYCLEAR_Pos          (13U)
#define SDIO_RINTSTS_BUSYCLEAR_Msk          (0x1U << SDIO_RINTSTS_BUSYCLEAR_Pos)
#define SDIO_RINTSTS_BUSYCLEAR              SDIO_RINTSTS_BUSYCLEAR_Msk
#define SDIO_RINTSTS_AUTOCMDDONE_Pos        (14U)
#define SDIO_RINTSTS_AUTOCMDDONE_Msk        (0x1U << SDIO_RINTSTS_AUTOCMDDONE_Pos)
#define SDIO_RINTSTS_AUTOCMDDONE            SDIO_RINTSTS_AUTOCMDDONE_Msk
#define SDIO_RINTSTS_ENDERROR_Pos           (15U)
#define SDIO_RINTSTS_ENDERROR_Msk           (0x1U << SDIO_RINTSTS_ENDERROR_Pos)
#define SDIO_RINTSTS_ENDERROR               SDIO_RINTSTS_ENDERROR_Msk
#define SDIO_RINTSTS_SDIOIT_Pos             (16U)
#define SDIO_RINTSTS_SDIOIT_Msk             (0xFFFFU << SDIO_RINTSTS_SDIOIT_Pos)
#define SDIO_RINTSTS_SDIOIT                 SDIO_RINTSTS_SDIOIT_Msk

/*******************  Bit definition for SDIO_STATUS register  *******************/
#define SDIO_STATUS_RX_WMARK_Pos            (0U)
#define SDIO_STATUS_RX_WMARK_Msk            (0x1U << SDIO_STATUS_RX_WMARK_Pos)
#define SDIO_STATUS_RX_WMARK                SDIO_STATUS_RX_WMARK_Msk
#define SDIO_STATUS_TX_WMARK_Pos            (1U)
#define SDIO_STATUS_TX_WMARK_Msk            (0x1U << SDIO_STATUS_TX_WMARK_Pos)
#define SDIO_STATUS_TX_WMARK                SDIO_STATUS_TX_WMARK_Msk
#define SDIO_STATUS_FIFO_EMPTY_Pos          (2U)
#define SDIO_STATUS_FIFO_EMPTY_Msk          (0x1U << SDIO_STATUS_FIFO_EMPTY_Pos)
#define SDIO_STATUS_FIFO_EMPTY              SDIO_STATUS_FIFO_EMPTY_Msk
#define SDIO_STATUS_FIFO_FULL_Pos           (3U)
#define SDIO_STATUS_FIFO_FULL_Msk           (0x1U << SDIO_STATUS_FIFO_FULL_Pos)
#define SDIO_STATUS_FIFO_FULL               SDIO_STATUS_FIFO_FULL_Msk
#define SDIO_STATUS_FSM_STATE_Pos           (4U)
#define SDIO_STATUS_FSM_STATE_Msk           (0xFU << SDIO_STATUS_FSM_STATE_Pos)
#define SDIO_STATUS_FSM_STATE               SDIO_STATUS_FSM_STATE_Msk
#define SDIO_STATUS_DATA3_STATUS_Pos        (8U)
#define SDIO_STATUS_DATA3_STATUS_Msk        (0x1U << SDIO_STATUS_DATA3_STATUS_Pos)
#define SDIO_STATUS_DATA3_STATUS            SDIO_STATUS_DATA3_STATUS_Msk
#define SDIO_STATUS_CARD_BUSY_Pos           (9U)
#define SDIO_STATUS_CARD_BUSY_Msk           (0x1U << SDIO_STATUS_CARD_BUSY_Pos)
#define SDIO_STATUS_CARD_BUSY               SDIO_STATUS_CARD_BUSY_Msk
#define SDIO_STATUS_DATA_BUSY_Pos           (10U)
#define SDIO_STATUS_DATA_BUSY_Msk           (0x1U << SDIO_STATUS_DATA_BUSY_Pos)
#define SDIO_STATUS_DATA_BUSY               SDIO_STATUS_DATA_BUSY_Msk
#define SDIO_STATUS_RESPONSE_INDEX_Pos      (11U)
#define SDIO_STATUS_RESPONSE_INDEX_Msk      (0x3FU << SDIO_STATUS_RESPONSE_INDEX_Pos)
#define SDIO_STATUS_RESPONSE_INDEX          SDIO_STATUS_RESPONSE_INDEX_Msk
#define SDIO_STATUS_FIFO_COUNT_Pos          (17U)
#define SDIO_STATUS_FIFO_COUNT_Msk          (0x1FFFU << SDIO_STATUS_FIFO_COUNT_Pos)
#define SDIO_STATUS_FIFO_COUNT              SDIO_STATUS_FIFO_COUNT_Msk
#define SDIO_STATUS_DMA_ACK_Pos             (30U)
#define SDIO_STATUS_DMA_ACK_Msk             (0x1U << SDIO_STATUS_DMA_ACK_Pos)
#define SDIO_STATUS_DMA_ACK                 SDIO_STATUS_DMA_ACK_Msk
#define SDIO_STATUS_DMA_REQ_Pos             (31U)
#define SDIO_STATUS_DMA_REQ_Msk             (0x1U << SDIO_STATUS_DMA_REQ_Pos)
#define SDIO_STATUS_DMA_REQ                 SDIO_STATUS_DMA_REQ_Msk


/*******************  Bit definition for SDIO_FIFOTH register  *******************/
#define SDIO_FIFOTH_TX_WMARK_Pos            (0U)
#define SDIO_FIFOTH_TX_WMARK_Msk            (0xFFFU << SDIO_FIFOTH_TX_WMARK_Pos)
#define SDIO_FIFOTH_TX_WMARK                SDIO_FIFOTH_TX_WMARK_Msk
#define SDIO_FIFOTH_RX_WMARK_Pos            (16U)
#define SDIO_FIFOTH_RX_WMARK_Msk            (0xFFFU << SDIO_FIFOTH_RX_WMARK_Pos)
#define SDIO_FIFOTH_RX_WMARK                SDIO_FIFOTH_RX_WMARK_Msk
#define SDIO_FIFOTH_MSIZE_Pos               (28U)
#define SDIO_FIFOTH_MSIZE_Msk               (0x3U << SDIO_FIFOTH_MSIZE_Pos)
#define SDIO_FIFOTH_MSIZE                   SDIO_FIFOTH_MSIZE_Msk

/*******************  Bit definition for SDIO_WRIPRT register  *******************/
#define SDIO_WRIPRT_WRITE_PROTECT_Pos       (0U)
#define SDIO_WRIPRT_WRITE_PROTECT_Msk       (0x1U << SDIO_WRIPRT_WRITE_PROTECT_Pos)
#define SDIO_WRIPRT_WRITE_PROTECT           SDIO_WRIPRT_WRITE_PROTECT_Msk

/*******************  Bit definition for SDIO_TCBCNT register  *******************/
#define SDIO_TCBCNT_COUNT_Pos               (0U)
#define SDIO_TCBCNT_COUNT_Msk               (0xFFFFFFFFU << SDIO_TCBCNT_COUNT_Pos)
#define SDIO_TCBCNT_COUNT                   SDIO_TCBCNT_COUNT_Msk

/*******************  Bit definition for SDIO_TBBCNT register  *******************/
#define SDIO_TBBCNT_COUNT_Pos               (0U)
#define SDIO_TBBCNT_COUNT_Msk               (0xFFFFFFFFU << SDIO_TBBCNT_COUNT_Pos)
#define SDIO_TBBCNT_COUNT                   SDIO_TBBCNT_COUNT_Msk

/*******************  Bit definition for SDIO_BMOD register  *******************/
#define SDIO_BMOD_SWR_Pos                   (0U)
#define SDIO_BMOD_SWR_Msk                   (0x1U << SDIO_BMOD_SWR_Pos)
#define SDIO_BMOD_SWR                       SDIO_BMOD_SERE_Msk
#define SDIO_BMOD_FB_Pos                    (1U)
#define SDIO_BMOD_FB_Msk                    (0x1U << SDIO_BMOD_FB_Pos)
#define SDIO_BMOD_FB                        SDIO_BMOD_FB_Msk
#define SDIO_BMOD_DSL_Pos                   (2U)
#define SDIO_BMOD_DSL_Msk                   (0x1FU << SDIO_BMOD_DSL_Pos)
#define SDIO_BMOD_DSL                       SDIO_BMOD_DSL_Msk
#define SDIO_BMOD_DE_Pos                    (7U)
#define SDIO_BMOD_DE_Msk                    (0x1U << SDIO_BMOD_DE_Pos)
#define SDIO_BMOD_DE                        SDIO_BMOD_DE_Msk
#define SDIO_BMOD_PBL_Pos                   (8U)
#define SDIO_BMOD_PBL_Msk                   (0x7U << SDIO_BMOD_PBL_Pos)
#define SDIO_BMOD_PBL                       SDIO_BMOD_PBL_Msk

/*******************  Bit definition for SDIO_PLDMND register  *******************/
#define SDIO_PLDMND_PD_Pos                  (0U)
#define SDIO_PLDMND_PD_Msk                  (0xFFFFFFFFU << SDIO_PLDMND_PD_Pos)
#define SDIO_PLDMND_PD                      SDIO_PLDMND_PD_Msk

/*******************  Bit definition for SDIO_DBADDR register  *******************/
#define SDIO_DBADDR_SDL_Pos                 (0U)
#define SDIO_DBADDR_SDL_Msk                 (0xFFFFFFFFU << SDIO_DBADDR_SDL_Pos)
#define SDIO_DBADDR_SDL                     SDIO_DBADDR_SDL_Msk

/*******************  Bit definition for SDIO_IDSTS register  *******************/
#define SDIO_IDSTS_TI_Pos                   (0U)
#define SDIO_IDSTS_TI_Msk                   (0x1U << SDIO_IDSTS_TI_Pos)
#define SDIO_IDSTS_TI                       SDIO_IDSTS_TI_Msk
#define SDIO_IDSTS_RI_Pos                   (1U)
#define SDIO_IDSTS_RI_Msk                   (0x1U << SDIO_IDSTS_RI_Pos)
#define SDIO_IDSTS_RI                       SDIO_IDSTS_RI_Msk
#define SDIO_IDSTS_FBE_Pos                  (2U)
#define SDIO_IDSTS_FBE_Msk                  (0x1U << SDIO_IDSTS_FBE_Pos)
#define SDIO_IDSTS_FBE                      SDIO_IDSTS_FBE_Msk
#define SDIO_IDSTS_DU_Pos                   (4U)
#define SDIO_IDSTS_DU_Msk                   (0x1U << SDIO_IDSTS_DU_Pos)
#define SDIO_IDSTS_DU                       SDIO_IDSTS_DU_Msk
#define SDIO_IDSTS_CES_Pos                  (5U)
#define SDIO_IDSTS_CES_Msk                  (0x1U << SDIO_IDSTS_CES_Pos)
#define SDIO_IDSTS_CES                      SDIO_IDSTS_CES_Msk
#define SDIO_IDSTS_NIS_Pos                  (8U)
#define SDIO_IDSTS_NIS_Msk                  (0x1U << SDIO_IDSTS_NIS_Pos)
#define SDIO_IDSTS_NIS                      SDIO_IDSTS_NIS_Msk
#define SDIO_IDSTS_AIS_Pos                  (9U)
#define SDIO_IDSTS_AIS_Msk                  (0x1U << SDIO_IDSTS_AIS_Pos)
#define SDIO_IDSTS_AIS                      SDIO_IDSTS_AIS_Msk
#define SDIO_IDSTS_FBE_CODE_Pos             (10U)
#define SDIO_IDSTS_FBE_CODE_Msk             (0x7U << SDIO_IDSTS_FBE_CODE_Pos)
#define SDIO_IDSTS_FBE_CODE                 SDIO_IDSTS_FBE_CODE_Msk
#define SDIO_IDSTS_FSM_Pos                  (13U)
#define SDIO_IDSTS_FSM_Msk                  (0xFU << SDIO_IDSTS_FSM_Pos)
#define SDIO_IDSTS_FSM                      SDIO_IDSTS_FSM_Msk

/*******************  Bit definition for SDIO_IDINTEN register  *******************/
#define SDIO_IDINTEN_TI_Pos                 (0U)
#define SDIO_IDINTEN_TI_Msk                 (0x1U << SDIO_DBADDR_SDL_Pos)
#define SDIO_IDINTEN_TI                     SDIO_DBADDR_SDL_Msk
#define SDIO_IDINTEN_RI_Pos                 (1U)
#define SDIO_IDINTEN_RI_Msk                 (0x1U << SDIO_IDINTEN_RI_Pos)
#define SDIO_IDINTEN_RI                     SDIO_IDINTEN_RI_Msk
#define SDIO_IDINTEN_FBE_Pos                (2U)
#define SDIO_IDINTEN_FBE_Msk                (0x1U << SDIO_IDINTEN_FBE_Pos)
#define SDIO_IDINTEN_FBE                    SDIO_IDINTEN_FBE_Msk
#define SDIO_IDINTEN_DU_Pos                 (4U)
#define SDIO_IDINTEN_DU_Msk                 (0x1U << SDIO_IDINTEN_DU_Pos)
#define SDIO_IDINTEN_DU                     SDIO_IDINTEN_DU_Msk
#define SDIO_IDINTEN_CES_Pos                (5U)
#define SDIO_IDINTEN_CES_Msk                (0x1U << SDIO_IDINTEN_CES_Pos)
#define SDIO_IDINTEN_CES                    SDIO_IDINTEN_CES_Msk
#define SDIO_IDINTEN_NI_Pos                 (8U)
#define SDIO_IDINTEN_NI_Msk                 (0x1U << SDIO_IDINTEN_NI_Pos)
#define SDIO_IDINTEN_NI                     SDIO_IDINTEN_NI_Msk
#define SDIO_IDINTEN_AI_Pos                 (9U)
#define SDIO_IDINTEN_AI_Msk                 (0x1U << SDIO_IDINTEN_AI_Pos)
#define SDIO_IDINTEN_AI                     SDIO_IDINTEN_AI_Msk

/*******************  Bit definition for SDIO_DSCADDR register  *******************/
#define SDIO_DSCADDR_HDA_Pos                (0U)
#define SDIO_DSCADDR_HDA_Msk                (0xFFFFFFFFU << SDIO_DSCADDR_HDA_Pos)
#define SDIO_DSCADDR_HDA                    SDIO_DSCADDR_HDA_Msk

/*******************  Bit definition for SDIO_BUFADDR register  *******************/
#define SDIO_BUFADDR_HBA_Pos                (0U)
#define SDIO_BUFADDR_HBA_Msk                (0xFFFFFFFFU << SDIO_BUFADDR_HBA_Pos)
#define SDIO_BUFADDR_HBA                    SDIO_BUFADDR_HBA_Msk

/*******************  Bit definition for SDIO_CARDTHRCTL register  *******************/
#define SDIO_CARDTHRCTL_CARDRDTHREN_Pos     (0U)
#define SDIO_CARDTHRCTL_CARDRDTHREN_Msk     (0x1 << SDIO_CARDTHRCTL_CARDRDTHREN_Pos)
#define SDIO_CARDTHRCTL_CARDRDTHREN         SDIO_CARDTHRCTL_CARDRDTHREN_Msk
#define SDIO_CARDTHRCTL_BSYCLRINTEN_Pos     (1U)
#define SDIO_CARDTHRCTL_BSYCLRINTEN_Msk     (0x1 << SDIO_CARDTHRCTL_BSYCLRINTEN_Pos)
#define SDIO_CARDTHRCTL_BSYCLRINTEN         SDIO_CARDTHRCTL_BSYCLRINTEN_Msk
#define SDIO_CARDTHRCTL_CARDWRTHREN_Pos     (2U)
#define SDIO_CARDTHRCTL_CARDWRTHREN_Msk     (0x1 << SDIO_CARDTHRCTL_CARDWRTHREN_Pos)
#define SDIO_CARDTHRCTL_CARDWRTHREN         SDIO_CARDTHRCTL_CARDWRTHREN_Msk
#define SDIO_CARDTHRCTL_CARDTHRESHOLD_Pos   (16U)
#define SDIO_CARDTHRCTL_CARDTHRESHOLD_Msk   (0x3FF << SDIO_CARDTHRCTL_CARDTHRESHOLD_Pos)
#define SDIO_CARDTHRCTL_CARDTHRESHOLD       SDIO_CARDTHRCTL_CARDTHRESHOLD_Msk

/******************************************************************************/
/*                                                                            */
/*                      Universal Serial Bus (USB)                            */
/*                                                                            */
/******************************************************************************/

/********************************  Bit definition for USB_FADDR register  ********************************/
#define USB_FADDR_FADDR_Msk       (0x7FU)              /*!< The function address field mask */

/********************************  Bit definition for USB_POWER register  ********************************/
#define USB_POWER_SUSEN           (0x1U << 0)          /*!< No description */
#define USB_POWER_SUSMD           (0x1U << 1)          /*!< No description */
#define USB_POWER_RESUME          (0x1U << 2)          /*!< No description */
#define USB_POWER_USBRST          (0x1U << 3)          /*!< No description */
#define USB_POWER_SOFTCONN        (0x1U << 6)          /*!< No description */
#define USB_POWER_ISOUD           (0x1U << 7)          /*!< No description */

/********************************  Bit definition for USB_INTRTX register  ********************************/
#define USB_INTRTX_EP0            (0x1U << 0)          /*!< No description */
#define USB_INTRTX_EP1TX          (0x1U << 1)          /*!< No description */
#define USB_INTRTX_EP2TX          (0x1U << 2)          /*!< No description */
#define USB_INTRTX_EP3TX          (0x1U << 3)          /*!< No description */
#define USB_INTRTX_EP4TX          (0x1U << 4)          /*!< No description */
#define USB_INTRTX_EP5TX          (0x1U << 5)          /*!< No description */

/********************************  Bit definition for USB_INTRRX register  ********************************/
#define USB_INTRRX_EP1RX          (0x1U << 1)          /*!< No description */
#define USB_INTRRX_EP2RX          (0x1U << 2)          /*!< No description */
#define USB_INTRRX_EP3RX          (0x1U << 3)          /*!< No description */
#define USB_INTRRX_EP4RX          (0x1U << 4)          /*!< No description */
#define USB_INTRRX_EP5RX          (0x1U << 5)          /*!< No description */

/********************************  Bit definition for USB_INTRTXE register  ********************************/
#define USB_INTRTXE_EP0E          (0x1U << 0)          /*!< No description */
#define USB_INTRTXE_EP1TXE        (0x1U << 1)          /*!< No description */
#define USB_INTRTXE_EP2TXE        (0x1U << 2)          /*!< No description */
#define USB_INTRTXE_EP3TXE        (0x1U << 3)          /*!< No description */
#define USB_INTRTXE_EP4TXE        (0x1U << 4)          /*!< No description */
#define USB_INTRTXE_EP5TXE        (0x1U << 5)          /*!< No description */

/********************************  Bit definition for USB_INTRRXE register  ********************************/
#define USB_INTRRXE_EP1RXE        (0x1U << 1)          /*!< No description */
#define USB_INTRRXE_EP2RXE        (0x1U << 2)          /*!< No description */
#define USB_INTRRXE_EP3RXE        (0x1U << 3)          /*!< No description */
#define USB_INTRRXE_EP4RXE        (0x1U << 4)          /*!< No description */
#define USB_INTRRXE_EP5RXE        (0x1U << 5)          /*!< No description */

/********************************  Bit definition for USB_INTRUSB register  ********************************/
#define USB_INTRUSB_SUSIS         (0x1U << 0)          /*!< No description */
#define USB_INTRUSB_RSUIS         (0x1U << 1)          /*!< No description */
#define USB_INTRUSB_RSTIS         (0x1U << 2)          /*!< No description */
#define USB_INTRUSB_SOFIS         (0x1U << 3)          /*!< No description */

/********************************  Bit definition for USB_INTRUSBE register  ********************************/
#define USB_INTRUSBE_SUSIE        (0x1U << 0)          /*!< No description */
#define USB_INTRUSBE_RSUIE        (0x1U << 1)          /*!< No description */
#define USB_INTRUSBE_RSTIE        (0x1U << 2)          /*!< No description */
#define USB_INTRUSBE_SOFIE        (0x1U << 3)          /*!< No description */

/********************************  Bit definition for USB_CSR0L register  ********************************/
#define USB_CSR0L_RXPKTRDY        (0x1U << 0)          /*!< No description */
#define USB_CSR0L_TXPKTRDY        (0x1U << 1)          /*!< No description */
#define USB_CSR0L_SENTSTALL       (0x1U << 2)          /*!< No description */
#define USB_CSR0L_DATAEND         (0x1U << 3)          /*!< No description */
#define USB_CSR0L_SETUPEND        (0x1U << 4)          /*!< No description */
#define USB_CSR0L_SENDSTALL       (0x1U << 5)          /*!< No description */
#define USB_CSR0L_SVDRXPKTRDY     (0x1U << 6)          /*!< No description */
#define USB_CSR0L_SVDSETUPEND     (0x1U << 7)          /*!< No description */

/********************************  Bit definition for USB_CSR0H register  ********************************/
#define USB_CSR0H_FLUSHFIFO       (0x1U << 0)          /*!< No description */

/********************************  Bit definition for USB_TXCSRL register  ********************************/
#define USB_TXCSRL_TXPKTRDY       (0x1U << 0)          /*!< No description */
#define USB_TXCSRL_FIFONE         (0x1U << 1)          /*!< No description */
#define USB_TXCSRL_UNDERRUN       (0x1U << 2)          /*!< No description */
#define USB_TXCSRL_FLUSHFIFO      (0x1U << 3)          /*!< No description */
#define USB_TXCSRL_SENDSTALL      (0x1U << 4)          /*!< No description */
#define USB_TXCSRL_SENTSTALL      (0x1U << 5)          /*!< No description */
#define USB_TXCSRL_CLRDATATOG     (0x1U << 6)          /*!< No description */

/********************************  Bit definition for USB_TXCSRH register  ********************************/
#define USB_TXCSRH_FRCDATATOG     (0x1U << 3)          /*!< No description */
#define USB_TXCSRH_DMAEN          (0x1U << 4)          /*!< No description */
#define USB_TXCSRH_ISO            (0x1U << 6)          /*!< No description */
#define USB_TXCSRH_AUTOSET        (0x1U << 7)          /*!< No description */

/********************************  Bit definition for USB_RXCSRL register  ********************************/
#define USB_RXCSRL_RXPKTRDY       (0x1U << 0)          /*!< No description */
#define USB_RXCSRL_FIFOFULL       (0x1U << 1)          /*!< No description */
#define USB_RXCSRL_OVERRUN        (0x1U << 2)          /*!< No description */
#define USB_RXCSRL_DATAERROR      (0x1U << 3)          /*!< No description */
#define USB_RXCSRL_FLUSHFIFO      (0x1U << 4)          /*!< No description */
#define USB_RXCSRL_SENDSTALL      (0x1U << 5)          /*!< No description */
#define USB_RXCSRL_SENTSTALL      (0x1U << 6)          /*!< No description */
#define USB_RXCSRL_CLRDATATOG     (0x1U << 7)          /*!< No description */

/********************************  Bit definition for USB_OUTCSR2 register  ********************************/
#define USB_RXCSRH_DMAEN          (0x1U << 5)          /*!< No description */
#define USB_RXCSRH_ISO            (0x1U << 6)          /*!< No description */
#define USB_RXCSRH_AUTOCLR        (0x1U << 7)          /*!< No description */

/******************************************************************************/
/*                                                                            */
/*                      Serial Peripheral Interface (SPI)                     */
/*                                                                            */
/******************************************************************************/

/*
 * @brief Specific device feature definitions (not present on all devices in the STM32F1 serie)
 */
#define SPI_I2S_SUPPORT       /*!< I2S support */
#define SPI_CRC_ERROR_WORKAROUND_FEATURE

/*******************  Bit definition for SPI_CR1 register  ********************/
#define SPI_CR1_CPHA_Pos                    (0U)                               
#define SPI_CR1_CPHA_Msk                    (0x1UL << SPI_CR1_CPHA_Pos)         /*!< 0x00000001 */
#define SPI_CR1_CPHA                        SPI_CR1_CPHA_Msk                    /*!< Clock Phase */
#define SPI_CR1_CPOL_Pos                    (1U)                               
#define SPI_CR1_CPOL_Msk                    (0x1UL << SPI_CR1_CPOL_Pos)         /*!< 0x00000002 */
#define SPI_CR1_CPOL                        SPI_CR1_CPOL_Msk                    /*!< Clock Polarity */
#define SPI_CR1_MSTR_Pos                    (2U)                               
#define SPI_CR1_MSTR_Msk                    (0x1UL << SPI_CR1_MSTR_Pos)         /*!< 0x00000004 */
#define SPI_CR1_MSTR                        SPI_CR1_MSTR_Msk                    /*!< Master Selection */

#define SPI_CR1_BR_Pos                      (3U)                               
#define SPI_CR1_BR_Msk                      (0x7UL << SPI_CR1_BR_Pos)           /*!< 0x00000038 */
#define SPI_CR1_BR                          SPI_CR1_BR_Msk                      /*!< BR[2:0] bits (Baud Rate Control) */
#define SPI_CR1_BR_0                        (0x1UL << SPI_CR1_BR_Pos)           /*!< 0x00000008 */
#define SPI_CR1_BR_1                        (0x2UL << SPI_CR1_BR_Pos)           /*!< 0x00000010 */
#define SPI_CR1_BR_2                        (0x4UL << SPI_CR1_BR_Pos)           /*!< 0x00000020 */

#define SPI_CR1_SPE_Pos                     (6U)                               
#define SPI_CR1_SPE_Msk                     (0x1UL << SPI_CR1_SPE_Pos)          /*!< 0x00000040 */
#define SPI_CR1_SPE                         SPI_CR1_SPE_Msk                     /*!< SPI Enable */
#define SPI_CR1_LSBFIRST_Pos                (7U)                               
#define SPI_CR1_LSBFIRST_Msk                (0x1UL << SPI_CR1_LSBFIRST_Pos)     /*!< 0x00000080 */
#define SPI_CR1_LSBFIRST                    SPI_CR1_LSBFIRST_Msk                /*!< Frame Format */
#define SPI_CR1_SSI_Pos                     (8U)                               
#define SPI_CR1_SSI_Msk                     (0x1UL << SPI_CR1_SSI_Pos)          /*!< 0x00000100 */
#define SPI_CR1_SSI                         SPI_CR1_SSI_Msk                     /*!< Internal slave select */
#define SPI_CR1_SSM_Pos                     (9U)                               
#define SPI_CR1_SSM_Msk                     (0x1UL << SPI_CR1_SSM_Pos)          /*!< 0x00000200 */
#define SPI_CR1_SSM                         SPI_CR1_SSM_Msk                     /*!< Software slave management */
#define SPI_CR1_RXONLY_Pos                  (10U)                              
#define SPI_CR1_RXONLY_Msk                  (0x1UL << SPI_CR1_RXONLY_Pos)       /*!< 0x00000400 */
#define SPI_CR1_RXONLY                      SPI_CR1_RXONLY_Msk                  /*!< Receive only */
#define SPI_CR1_DFF_Pos                     (11U)                              
#define SPI_CR1_DFF_Msk                     (0x1UL << SPI_CR1_DFF_Pos)          /*!< 0x00000800 */
#define SPI_CR1_DFF                         SPI_CR1_DFF_Msk                     /*!< Data Frame Format */
#define SPI_CR1_CRCNEXT_Pos                 (12U)                              
#define SPI_CR1_CRCNEXT_Msk                 (0x1UL << SPI_CR1_CRCNEXT_Pos)      /*!< 0x00001000 */
#define SPI_CR1_CRCNEXT                     SPI_CR1_CRCNEXT_Msk                 /*!< Transmit CRC next */
#define SPI_CR1_CRCEN_Pos                   (13U)                              
#define SPI_CR1_CRCEN_Msk                   (0x1UL << SPI_CR1_CRCEN_Pos)        /*!< 0x00002000 */
#define SPI_CR1_CRCEN                       SPI_CR1_CRCEN_Msk                   /*!< Hardware CRC calculation enable */
#define SPI_CR1_BIDIOE_Pos                  (14U)                              
#define SPI_CR1_BIDIOE_Msk                  (0x1UL << SPI_CR1_BIDIOE_Pos)       /*!< 0x00004000 */
#define SPI_CR1_BIDIOE                      SPI_CR1_BIDIOE_Msk                  /*!< Output enable in bidirectional mode */
#define SPI_CR1_BIDIMODE_Pos                (15U)                              
#define SPI_CR1_BIDIMODE_Msk                (0x1UL << SPI_CR1_BIDIMODE_Pos)     /*!< 0x00008000 */
#define SPI_CR1_BIDIMODE                    SPI_CR1_BIDIMODE_Msk                /*!< Bidirectional data mode enable */

/*******************  Bit definition for SPI_CR2 register  ********************/
#define SPI_CR2_RXDMAEN_Pos                 (0U)                               
#define SPI_CR2_RXDMAEN_Msk                 (0x1UL << SPI_CR2_RXDMAEN_Pos)      /*!< 0x00000001 */
#define SPI_CR2_RXDMAEN                     SPI_CR2_RXDMAEN_Msk                 /*!< Rx Buffer DMA Enable */
#define SPI_CR2_TXDMAEN_Pos                 (1U)                               
#define SPI_CR2_TXDMAEN_Msk                 (0x1UL << SPI_CR2_TXDMAEN_Pos)      /*!< 0x00000002 */
#define SPI_CR2_TXDMAEN                     SPI_CR2_TXDMAEN_Msk                 /*!< Tx Buffer DMA Enable */
#define SPI_CR2_SSOE_Pos                    (2U)                               
#define SPI_CR2_SSOE_Msk                    (0x1UL << SPI_CR2_SSOE_Pos)         /*!< 0x00000004 */
#define SPI_CR2_SSOE                        SPI_CR2_SSOE_Msk                    /*!< SS Output Enable */
#define SPI_CR2_ERRIE_Pos                   (5U)                               
#define SPI_CR2_ERRIE_Msk                   (0x1UL << SPI_CR2_ERRIE_Pos)        /*!< 0x00000020 */
#define SPI_CR2_ERRIE                       SPI_CR2_ERRIE_Msk                   /*!< Error Interrupt Enable */
#define SPI_CR2_RXNEIE_Pos                  (6U)                               
#define SPI_CR2_RXNEIE_Msk                  (0x1UL << SPI_CR2_RXNEIE_Pos)       /*!< 0x00000040 */
#define SPI_CR2_RXNEIE                      SPI_CR2_RXNEIE_Msk                  /*!< RX buffer Not Empty Interrupt Enable */
#define SPI_CR2_TXEIE_Pos                   (7U)                               
#define SPI_CR2_TXEIE_Msk                   (0x1UL << SPI_CR2_TXEIE_Pos)        /*!< 0x00000080 */
#define SPI_CR2_TXEIE                       SPI_CR2_TXEIE_Msk                   /*!< Tx buffer Empty Interrupt Enable */

/********************  Bit definition for SPI_SR register  ********************/
#define SPI_SR_RXNE_Pos                     (0U)                               
#define SPI_SR_RXNE_Msk                     (0x1UL << SPI_SR_RXNE_Pos)          /*!< 0x00000001 */
#define SPI_SR_RXNE                         SPI_SR_RXNE_Msk                     /*!< Receive buffer Not Empty */
#define SPI_SR_TXE_Pos                      (1U)                               
#define SPI_SR_TXE_Msk                      (0x1UL << SPI_SR_TXE_Pos)           /*!< 0x00000002 */
#define SPI_SR_TXE                          SPI_SR_TXE_Msk                      /*!< Transmit buffer Empty */
#define SPI_SR_CHSIDE_Pos                   (2U)                               
#define SPI_SR_CHSIDE_Msk                   (0x1UL << SPI_SR_CHSIDE_Pos)        /*!< 0x00000004 */
#define SPI_SR_CHSIDE                       SPI_SR_CHSIDE_Msk                   /*!< Channel side */
#define SPI_SR_UDR_Pos                      (3U)                               
#define SPI_SR_UDR_Msk                      (0x1UL << SPI_SR_UDR_Pos)           /*!< 0x00000008 */
#define SPI_SR_UDR                          SPI_SR_UDR_Msk                      /*!< Underrun flag */
#define SPI_SR_CRCERR_Pos                   (4U)                               
#define SPI_SR_CRCERR_Msk                   (0x1UL << SPI_SR_CRCERR_Pos)        /*!< 0x00000010 */
#define SPI_SR_CRCERR                       SPI_SR_CRCERR_Msk                   /*!< CRC Error flag */
#define SPI_SR_MODF_Pos                     (5U)                               
#define SPI_SR_MODF_Msk                     (0x1UL << SPI_SR_MODF_Pos)          /*!< 0x00000020 */
#define SPI_SR_MODF                         SPI_SR_MODF_Msk                     /*!< Mode fault */
#define SPI_SR_OVR_Pos                      (6U)                               
#define SPI_SR_OVR_Msk                      (0x1UL << SPI_SR_OVR_Pos)           /*!< 0x00000040 */
#define SPI_SR_OVR                          SPI_SR_OVR_Msk                      /*!< Overrun flag */
#define SPI_SR_BSY_Pos                      (7U)                               
#define SPI_SR_BSY_Msk                      (0x1UL << SPI_SR_BSY_Pos)           /*!< 0x00000080 */
#define SPI_SR_BSY                          SPI_SR_BSY_Msk                      /*!< Busy flag */

/********************  Bit definition for SPI_DR register  ********************/
#define SPI_DR_DR_Pos                       (0U)                               
#define SPI_DR_DR_Msk                       (0xFFFFUL << SPI_DR_DR_Pos)         /*!< 0x0000FFFF */
#define SPI_DR_DR                           SPI_DR_DR_Msk                       /*!< Data Register */

/*******************  Bit definition for SPI_CRCPR register  ******************/
#define SPI_CRCPR_CRCPOLY_Pos               (0U)                               
#define SPI_CRCPR_CRCPOLY_Msk               (0xFFFFUL << SPI_CRCPR_CRCPOLY_Pos) /*!< 0x0000FFFF */
#define SPI_CRCPR_CRCPOLY                   SPI_CRCPR_CRCPOLY_Msk               /*!< CRC polynomial register */

/******************  Bit definition for SPI_RXCRCR register  ******************/
#define SPI_RXCRCR_RXCRC_Pos                (0U)                               
#define SPI_RXCRCR_RXCRC_Msk                (0xFFFFUL << SPI_RXCRCR_RXCRC_Pos)  /*!< 0x0000FFFF */
#define SPI_RXCRCR_RXCRC                    SPI_RXCRCR_RXCRC_Msk                /*!< Rx CRC Register */

/******************  Bit definition for SPI_TXCRCR register  ******************/
#define SPI_TXCRCR_TXCRC_Pos                (0U)                               
#define SPI_TXCRCR_TXCRC_Msk                (0xFFFFUL << SPI_TXCRCR_TXCRC_Pos)  /*!< 0x0000FFFF */
#define SPI_TXCRCR_TXCRC                    SPI_TXCRCR_TXCRC_Msk                /*!< Tx CRC Register */

/******************  Bit definition for SPI_I2SCFGR register  *****************/
#define SPI_I2SCFGR_CHLEN_Pos               (0U)                               
#define SPI_I2SCFGR_CHLEN_Msk               (0x1UL << SPI_I2SCFGR_CHLEN_Pos)    /*!< 0x00000001 */
#define SPI_I2SCFGR_CHLEN                   SPI_I2SCFGR_CHLEN_Msk               /*!< Channel length (number of bits per audio channel) */

#define SPI_I2SCFGR_DATLEN_Pos              (1U)                               
#define SPI_I2SCFGR_DATLEN_Msk              (0x3UL << SPI_I2SCFGR_DATLEN_Pos)   /*!< 0x00000006 */
#define SPI_I2SCFGR_DATLEN                  SPI_I2SCFGR_DATLEN_Msk              /*!< DATLEN[1:0] bits (Data length to be transferred) */
#define SPI_I2SCFGR_DATLEN_0                (0x1UL << SPI_I2SCFGR_DATLEN_Pos)   /*!< 0x00000002 */
#define SPI_I2SCFGR_DATLEN_1                (0x2UL << SPI_I2SCFGR_DATLEN_Pos)   /*!< 0x00000004 */

#define SPI_I2SCFGR_CKPOL_Pos               (3U)                               
#define SPI_I2SCFGR_CKPOL_Msk               (0x1UL << SPI_I2SCFGR_CKPOL_Pos)    /*!< 0x00000008 */
#define SPI_I2SCFGR_CKPOL                   SPI_I2SCFGR_CKPOL_Msk               /*!< steady state clock polarity */

#define SPI_I2SCFGR_I2SSTD_Pos              (4U)                               
#define SPI_I2SCFGR_I2SSTD_Msk              (0x3UL << SPI_I2SCFGR_I2SSTD_Pos)   /*!< 0x00000030 */
#define SPI_I2SCFGR_I2SSTD                  SPI_I2SCFGR_I2SSTD_Msk              /*!< I2SSTD[1:0] bits (I2S standard selection) */
#define SPI_I2SCFGR_I2SSTD_0                (0x1UL << SPI_I2SCFGR_I2SSTD_Pos)   /*!< 0x00000010 */
#define SPI_I2SCFGR_I2SSTD_1                (0x2UL << SPI_I2SCFGR_I2SSTD_Pos)   /*!< 0x00000020 */

#define SPI_I2SCFGR_PCMSYNC_Pos             (7U)                               
#define SPI_I2SCFGR_PCMSYNC_Msk             (0x1UL << SPI_I2SCFGR_PCMSYNC_Pos)  /*!< 0x00000080 */
#define SPI_I2SCFGR_PCMSYNC                 SPI_I2SCFGR_PCMSYNC_Msk             /*!< PCM frame synchronization */

#define SPI_I2SCFGR_I2SCFG_Pos              (8U)                               
#define SPI_I2SCFGR_I2SCFG_Msk              (0x3UL << SPI_I2SCFGR_I2SCFG_Pos)   /*!< 0x00000300 */
#define SPI_I2SCFGR_I2SCFG                  SPI_I2SCFGR_I2SCFG_Msk              /*!< I2SCFG[1:0] bits (I2S configuration mode) */
#define SPI_I2SCFGR_I2SCFG_0                (0x1UL << SPI_I2SCFGR_I2SCFG_Pos)   /*!< 0x00000100 */
#define SPI_I2SCFGR_I2SCFG_1                (0x2UL << SPI_I2SCFGR_I2SCFG_Pos)   /*!< 0x00000200 */

#define SPI_I2SCFGR_I2SE_Pos                (10U)                              
#define SPI_I2SCFGR_I2SE_Msk                (0x1UL << SPI_I2SCFGR_I2SE_Pos)     /*!< 0x00000400 */
#define SPI_I2SCFGR_I2SE                    SPI_I2SCFGR_I2SE_Msk                /*!< I2S Enable */
#define SPI_I2SCFGR_I2SMOD_Pos              (11U)                              
#define SPI_I2SCFGR_I2SMOD_Msk              (0x1UL << SPI_I2SCFGR_I2SMOD_Pos)   /*!< 0x00000800 */
#define SPI_I2SCFGR_I2SMOD                  SPI_I2SCFGR_I2SMOD_Msk              /*!< I2S mode selection */
/******************  Bit definition for SPI_I2SPR register  *******************/
#define SPI_I2SPR_I2SDIV_Pos                (0U)                               
#define SPI_I2SPR_I2SDIV_Msk                (0xFFUL << SPI_I2SPR_I2SDIV_Pos)    /*!< 0x000000FF */
#define SPI_I2SPR_I2SDIV                    SPI_I2SPR_I2SDIV_Msk                /*!< I2S Linear prescaler */
#define SPI_I2SPR_ODD_Pos                   (8U)                               
#define SPI_I2SPR_ODD_Msk                   (0x1UL << SPI_I2SPR_ODD_Pos)        /*!< 0x00000100 */
#define SPI_I2SPR_ODD                       SPI_I2SPR_ODD_Msk                   /*!< Odd factor for the prescaler */
#define SPI_I2SPR_MCKOE_Pos                 (9U)                               
#define SPI_I2SPR_MCKOE_Msk                 (0x1UL << SPI_I2SPR_MCKOE_Pos)      /*!< 0x00000200 */
#define SPI_I2SPR_MCKOE                     SPI_I2SPR_MCKOE_Msk                 /*!< Master Clock Output Enable */

/******************************************************************************/
/*                                                                            */
/*                    Inter-integrated Circuit Interface (I2C)                */
/*                                                                            */
/******************************************************************************/

/******************************    Bit definition for I2C_CON register *******************************/
#define I2C_CON_MASTER_MODE                   (0x1UL << 0)                      /*!< This bit controls whether the i2c master is enable */

#define I2C_CON_SPEED_Msk                     (0x3UL << 1)                      /*!< SPEED field mask bit */
#define I2C_CON_SPEED_STANDARD                (0x1UL << 1)                      /*!< standard mode (0 to 100 Kb/s) */
#define I2C_CON_SPEED_FAST                    (0x2UL << 1)                      /*!< fast mode (≤ 400 Kb/s) or fast mode plus (≤ 1000 Kb/s) */

#define I2C_CON_10BITADDR_SLAVE               (0x1UL << 3)                      /*!< When acting as a slave, this bit controls i2c responds to 10-bit addresses. */
#define I2C_CON_10BITADDR_MASTER              (0x1UL << 4)                      /*!< XXX */
#define I2C_CON_RESTART_EN                    (0x1UL << 5)                      /*!< Determines whether RESTART conditions may be sent when acting as a master. */
#define I2C_CON_SLAVE_DISABLE                 (0x1UL << 6)                      /*!< This bit controls whether I2C has its slave disabled */
#define I2C_CON_STOP_DET_IFADDRESSED          (0x1UL << 7)                      /*!< XXX */
#define I2C_CON_TX_EMPTY_CTRL                 (0x1UL << 8)                      /*!< This bit controls the generation of the TX_EMPTY interrupt */
#define I2C_CON_RX_FIFO_FULL_HLD_CTRL         (0x1UL << 9)                      /*!< This bit controls whether i2c should hold the bus when the Rx FIFO is physically full to its RX_BUFFER_DEPTH */
#define I2C_CON_STOP_DET_IF_MASTER_ACTIVE     (0x1UL << 10)                     /*!< XXX */
#define I2C_CON_BUS_CLEAR_FEATURE_CTRL        (0x1UL << 11)                     /*!< XXX */
#define I2C_CON_OPTIONAL_SAR_CTRL             (0x1UL << 16)                     /*!< Enables the usage of OPTIONAL_SAR register */
#define I2C_CON_SMBUS_SLAVE_QUICK_EN          (0x1UL << 17)                     /*!< XXX */
#define I2C_CON_SMBUS_ARP_EN                  (0x1UL << 18)                     /*!< This bit controls whether i2c should enable Address Resolution Logic in SMBus Mode  */
#define I2C_CON_SMBUS_PERSISTANT_SLV_ADDR_EN  (0x1UL << 19)                     /*!< This bit controls to enable i2c slave as persistent or non-persistent slave */

/******************************    Bit definition for I2C_TAR register   *******************************/
#define I2C_TAR_TAR_Msk                       (0x3FFUL)                         /*!< target address field mask bit */
#define I2C_TAR_GC_OR_START                   (0x1UL << 10)                     /*!< this bit indicates whether a General Call or START byte command is to be performed by the i2c. */
#define I2C_TAR_SPECIAL                       (0x1UL << 11)                     /*!< This bit indicates whether software performs a Device-ID, General Call or START BYTE command. */
#define I2C_TAR_10BITADDR_MASTER              (0x1UL << 12)                     /*!< This bit controls whether the i2c starts its transfers in 7-or 10-bit addressing mode when acting as a master. */
#define I2C_TAR_DEVICE_ID                     (0x1UL << 13)                     /*!< If bit 11 (SPECIAL) is set to 1, then this bit indicates whether a Device-ID of a particular slave mentioned in TAR[6:0] is to be performed by the i2c Master. */
#define I2C_TAR_SMBUS_QUICK_CMD               (0x1UL << 16)                     /*!< If bit 11 (SPECIAL) is set to 1, then this bit indicates whether a Quick command is to be performed by the i2c. */

/******************************    Bit definition for I2C_SAR register   *******************************/
/******************************    Bit definition for I2C_HS_MADDR register   *******************************/

/******************************    Bit definition for I2C_DATA_CMD register   *******************************/
#define I2C_DATA_CMD_DAT_Msk                  (0xFFUL)                          /*!< DAT field mask bit */

#define I2C_DATA_CMD_READ                     (0x1UL << 8)                      /*!< This bit controls whether a read or a write is performed */
#define I2C_DATA_CMD_STOP                     (0x1UL << 9)                      /*!< This bit controls whether a STOP is issued after the byte is sent or received */
#define I2C_DATA_CMD_RESTART                  (0x1UL << 10)                     /*!< This bit controls whether a RESTART is issued before the byte is sent or received */
#define I2C_DATA_CMD_FIRST_DATA_BYTE          (0x1UL << 11)                     /*!< Indicates the first data byte received after the address phase for receive transfer in Master receiver or Slave receiver mode */

/******************************    Bit definition for I2C_SS_SCL_HCNT register   *******************************/
/******************************    Bit definition for I2C_SS_SCL_LCNT register   *******************************/
/******************************    Bit definition for I2C_FS_SCL_HCNT register   *******************************/
/******************************    Bit definition for I2C_FS_SCL_LCNT register   *******************************/
/******************************    Bit definition for I2C_HS_SCL_HCNT register   *******************************/
/******************************    Bit definition for I2C_HS_SCL_LCNT register   *******************************/

/******************************    Bit definition for I2C_INTR_STAT register   *******************************/
/******************************    Bit definition for I2C_INTR_MASK register   *******************************/
/******************************    Bit definition for I2C_RAW_INTR_STAT register   *******************************/
#define I2C_INTR_RX_UNDER                     (0x1UL << 0)                      /*!< Set if the processor attempts to read the receive buffer when it is empty by reading from the DATA_CMD register */
#define I2C_INTR_RX_OVER                      (0x1UL << 1)                      /*!< Set if the receive buffer is completely filled to RX_BUFFER_DEPTH and an additional byte is received from an external I2C device */
#define I2C_INTR_RX_FULL                      (0x1UL << 2)                      /*!< Set when the receive buffer reaches or goes above the RX_TL threshold in the RX_TL register */
#define I2C_INTR_TX_OVER                      (0x1UL << 3)                      /*!< Set during transmit if the transmit buffer is filled to TX_BUFFER_DEPTH and the processor attempts to issue another I2C command by writing to the DATA_CMD register */
#define I2C_INTR_TX_EMPTY                     (0x1UL << 4)                      /*!< The behavior of the TX_EMPTY interrupt status differs based on the TX_EMPTY_CTRL selection in the CON register */
#define I2C_INTR_RD_REQ                       (0x1UL << 5)                      /*!< This bit is set to 1 when DW_apb_i2c is acting as a slave and another I2C master is attempting to read data from DW_apb_i2c */
#define I2C_INTR_TX_ABRT                      (0x1UL << 6)                      /*!< This bit indicates if DW_apb_i2c, as an I2C transmitter, is unable to complete the intended actions on the contents of the transmit FIFO */
#define I2C_INTR_RX_DONE                      (0x1UL << 7)                      /*!< When the DW_apb_i2c is acting as a slave-transmitter, this bit is set to 1 if the master does not acknowledge a transmitted byte */
#define I2C_INTR_ACTIVITY                     (0x1UL << 8)                      /*!< This bit captures DW_apb_i2c activity and stays set until it is cleared */
#define I2C_INTR_STOP_DET                     (0x1UL << 9)                      /*!< Indicates whether a STOP condition has occurred on the I2C interface regardless of whether DW_apb_i2c is operating in slave or master mode */
#define I2C_INTR_START_DET                    (0x1UL << 10)                     /*!< Indicates whether a STOP condition has occurred on the I2C interface regardless of whether DW_apb_i2c is operating in slave or master mode */
#define I2C_INTR_GEN_CALL                     (0x1UL << 11)                     /*!< Indicates whether a START or RESTART condition has occurred on the I2C interface regardless of whether DW_apb_i2c is operating in slave or master mode */
#define I2C_INTR_SCL_STUCK_AT_LOW             (0x1UL << 14)                     /*!< Indicates whether the SCL Line is stuck at low for the SCL_STUCK_LOW_TIMOUT number of clk periods */


/******************************    Bit definition for I2C_RX_TL register   *******************************/
/******************************    Bit definition for I2C_TX_TL register   *******************************/
/******************************    Bit definition for I2C_CLR_INTR register   *******************************/
/******************************    Bit definition for I2C_CLR_RX_UNDERT register   *******************************/
/******************************    Bit definition for I2C_CLR_RX_OVER register   *******************************/
/******************************    Bit definition for I2C_CLR_TX_OVER register   *******************************/
/******************************    Bit definition for I2C_CLR_RD_REQ register   *******************************/
/******************************    Bit definition for I2C_CLR_TX_ABRT register   *******************************/
/******************************    Bit definition for I2C_CLR_RX_DONE register   *******************************/
/******************************    Bit definition for I2C_CLR_ACTIVITY register   *******************************/
/******************************    Bit definition for I2C_CLR_STOP_DET register   *******************************/
/******************************    Bit definition for I2C_CLR_START_DET register   *******************************/
/******************************    Bit definition for I2C_CLR_GEN_CALL register   *******************************/

/******************************    Bit definition for I2C_ENABLE register   *******************************/
#define I2C_ENABLE_ENABLE                            (0x1UL << 0)               /*!< Controls whether the DW_apb_i2c is enabled */
#define I2C_ENABLE_ABORT                             (0x1UL << 1)               /*!< XXX */
#define I2C_ENABLE_TX_CMD_BLOCK                      (0x1UL << 2)               /*!< XXX */
#define I2C_ENABLE_SDA_STUCK_RECOVERY_ENA            (0x1UL << 3)               /*!< XXX */
#define I2C_ENABLE_SMBUS_CLK_RESET                   (0x1UL << 16)              /*!< This bit is used in SMBus Host mode to initiate the SMBus Master Clock Reset */
#define I2C_ENABLE_SMBUS_SUSPEND_EN                  (0x1UL << 17)              /*!< The SMBUS_SUSPEND_EN register bit is used to control assertion and de-assertion of SMBSUS signal */
#define I2C_ENABLE_SMBUS_ALERT_EN                    (0x1UL << 18)              /*!< The SMBUS_ALERT_CTRL register bit is used to control assertion of SMBALERT signal */

/******************************    Bit definition for I2C_STATUS register   *******************************/
#define I2C_STATUS_ACTIVITY                          (0x1UL << 0)               /*!< I2C Activity Status */
#define I2C_STATUS_TFNF                              (0x1UL << 1)               /*!< Transmit FIFO Not Full */
#define I2C_STATUS_TFE                               (0x1UL << 2)               /*!< Transmit FIFO Completely Empty */
#define I2C_STATUS_RFNE                              (0x1UL << 3)               /*!< Receive FIFO Not Empty */
#define I2C_STATUS_RFF                               (0x1UL << 4)               /*!< Receive FIFO Completely Full */
#define I2C_STATUS_MST_ACTIVITY                      (0x1UL << 5)               /*!< Master FSM Activity Status */
#define I2C_STATUS_SLV_ACTIVITY                      (0x1UL << 6)               /*!< Slave FSM Activity Status */
#define I2C_STATUS_MST_HOLD_TX_FIFO_EMPTY            (0x1UL << 7)               /*!< XXX */
#define I2C_STATUS_MST_HOLD_RX_FIFO_FULL             (0x1UL << 8)               /*!< XXX */
#define I2C_STATUS_SLV_HOLD_TX_FIFO_EMPTY            (0x1UL << 9)               /*!< XXX */
#define I2C_STATUS_SLV_HOLD_RX_FIFO_FULL             (0x1UL << 10)              /*!< XXX */
#define I2C_STATUS_SDA_STUCK_NOT_RECOVERED           (0x1UL << 11)              /*!< XXX */
#define I2C_STATUS_SMBUS_QUICK_CMD_BIT               (0x1UL << 16)              /*!< XXX */
#define I2C_STATUS_SMBUS_SLAVE_ADDR_VALID            (0x1UL << 17)              /*!< This bit indicates whether the SMBus Slave address (sar[6:0]) is valid or not */
#define I2C_STATUS_SMBUS_SLAVE_ADDR_RESOLVED         (0x1UL << 18)              /*!< This bit indicates whether the SMBus Slave address (sar[6:0]) is Resolved by ARP Master */
#define I2C_STATUS_SMBUS_SUSPEND_STATUS              (0x1UL << 19)              /*!< This bit indicates whether the status of the input signal is smbus_sus_in_n */
#define I2C_STATUS_SMBUS_ALERT_STATUS                (0x1UL << 20)              /*!< This bit indicates whether the status of the input signal is smbus_alert_in_n */

/******************************    Bit definition for I2C_TXFLR register   *******************************/
/******************************    Bit definition for I2C_RXFLR register   *******************************/
/******************************    Bit definition for I2C_SDA_HOLD register   *******************************/

/******************************    Bit definition for I2C_TX_ABRT_SOURCE   *******************************/
#define I2C_TX_ABRT_SOURCE_7B_ADDR_NOACK             (0x1UL << 0)               /*!< Master is in 7-bit addressing mode and the address sent was not acknowledged by any slave */
#define I2C_TX_ABRT_SOURCE_10ADDR1_NOACK             (0x1UL << 1)               /*!< Master is in 10-bit address mode and the first 10-bit address byte was not acknowledged by any slave. */
#define I2C_TX_ABRT_SOURCE_10ADDR2_NOACK             (0x1UL << 2)               /*!< Master is in 10-bit address mode and the second address byte of the 10-bit address was not acknowledged by any slave */
#define I2C_TX_ABRT_SOURCE_TXDATA_NOACK              (0x1UL << 3)               /*!< XXX */
#define I2C_TX_ABRT_SOURCE_GCALL_NOACK               (0x1UL << 4)               /*!< XXX */
#define I2C_TX_ABRT_SOURCE_GCALL_READ                (0x1UL << 5)               /*!< XXX */
#define I2C_TX_ABRT_SOURCE_HS_ACKDET                 (0x1UL << 6)               /*!< XXX */
#define I2C_TX_ABRT_SOURCE_SBYTE_ACKDET              (0x1UL << 7)               /*!< XXX */
#define I2C_TX_ABRT_SOURCE_HS_NORSTRT                (0x1UL << 8)               /*!< XXX */
#define I2C_TX_ABRT_SOURCE_SBYTE_NORSTRT             (0x1UL << 9)               /*!< XXX */
#define I2C_TX_ABRT_SOURCE_10B_RD_NORSTRT            (0x1UL << 10)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_MASTER_DIS                (0x1UL << 11)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_LOST                      (0x1UL << 12)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_SLVFLUSH_TXFIFO           (0x1UL << 13)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_SLV_ARBLOST               (0x1UL << 14)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_SLVRD_INTX                (0x1UL << 15)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_USER_ABRT                 (0x1UL << 16)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_SDA_STUCK_AT_LOW          (0x1UL << 17)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_DEVICE_NOACK              (0x1UL << 18)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_DEVICE_SLVADDR_NOACK      (0x1UL << 19)              /*!< XXX */
#define I2C_TX_ABRT_SOURCE_DEVICE_WRITE              (0x1UL << 20)              /*!< XXX */

#define I2C_TX_ABRT_SOURCE_TX_FLUSH_CNT_Msk          (0xFF800000UL)             /*!< XXX */

/******************************    Bit definition for I2C_SLV_DATA_NACK_ONLY register   *******************************/
#define I2C_SLV_DATA_NACK_ONLY_NACK                  (0x1UL << 0)               /*!< XXX */

/******************************    Bit definition for I2C_DMA_CR register   *******************************/
#define I2C_DMA_CR_RDMAE                             (0x1UL << 0)               /*!< XXX */
#define I2C_DMA_CR_TDMAE                             (0x1UL << 1)               /*!< XXX */

/******************************    Bit definition for I2C_DMA_TDLR register   *******************************/
/******************************    Bit definition for I2C_DMA_RDLR register   *******************************/
/******************************    Bit definition for I2C_SDA_SETUP register   *******************************/
/******************************    Bit definition for I2C_ACK_GENERAL_CALL register   *******************************/

/******************************    Bit definition for I2C_ENABLE_STATUS register   *******************************/
#define I2C_ENABLE_STATUS_IC_EN                      (0x1UL << 0)               /*!< XXX */
#define I2C_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY    (0x1UL << 1)               /*!< XXX */
#define I2C_ENABLE_STATUS_SLV_RX_DATA_LOST           (0x1UL << 2)               /*!< XXX */

/******************************    Bit definition for FS_SPKLEN register   *******************************/
/******************************    Bit definition for HS_SPKLEN register   *******************************/
/******************************    Bit definition for CLR_RESTART_DET register   *******************************/
/******************************    Bit definition for SCL_STUCK_AT_LOW_TIMEOUT register   *******************************/
/******************************    Bit definition for SDA_STUCK_AT_LOW_TIMEOUT register   *******************************/
/******************************    Bit definition for CLR_SCL_STUCK_DET register   *******************************/
/******************************    Bit definition for SMBUS_CLK_LOW_SEXT register   *******************************/
/******************************    Bit definition for SMBUS_CLK_LOW_MEXT register   *******************************/
/******************************    Bit definition for SMBUS_THIGH_MAX_IDLE_COUNT register   *******************************/
/******************************    Bit definition for SMBUS_INTR_STAT register   *******************************/
/******************************    Bit definition for SMBUS_INTR_MASK register   *******************************/
/******************************    Bit definition for SMBUS_RAW_INTR_STAT register   *******************************/
#define I2C_SMBUS_INTR_SLV_CLOCK_EXTND_TIMEOUT       (0x1UL << 0)               /*!< XXX */
#define I2C_SMBUS_INTR_MST_CLOCK_EXTND_TIMEOUT       (0x1UL << 1)               /*!< XXX */
#define I2C_SMBUS_INTR_QUICK_CMD_DET                 (0x1UL << 2)               /*!< XXX */
#define I2C_SMBUS_INTR_HOST_NTFY_MST_DET             (0x1UL << 3)               /*!< XXX */
#define I2C_SMBUS_INTR_ARP_PREPARE_CMD_DET           (0x1UL << 4)               /*!< XXX */
#define I2C_SMBUS_INTR_ARP_RST_CMD_DET               (0x1UL << 5)               /*!< XXX */
#define I2C_SMBUS_INTR_ARP_GET_UDID_CMD_DET          (0x1UL << 6)               /*!< XXX */
#define I2C_SMBUS_INTR_ARP_ASSGN_ADDR_CMD_DET        (0x1UL << 7)               /*!< XXX */
#define I2C_SMBUS_INTR_SLV_RX_PEC_NACK               (0x1UL << 8)               /*!< XXX */
#define I2C_SMBUS_INTR_SMBUS_SUSPEND_DET             (0x1UL << 9)               /*!< XXX */
#define I2C_SMBUS_INTR_SMBUS_ALERT_DET               (0x1UL << 10)              /*!< XXX */

/******************************    Bit definition for CLR_SMBUS_INTR register   *******************************/
/******************************    Bit definition for OPTIONAL_SAR register   *******************************/
/******************************    Bit definition for SMBUS_UDID_LSB register   *******************************/

/******************************************************************************/
/*                                                                            */
/*         Universal Synchronous Asynchronous Receiver Transmitter            */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for USART_SR register  *******************/
#define USART_SR_PE_Pos                     (0U)                               
#define USART_SR_PE_Msk                     (0x1UL << USART_SR_PE_Pos)          /*!< 0x00000001 */
#define USART_SR_PE                         USART_SR_PE_Msk                     /*!< Parity Error */
#define USART_SR_FE_Pos                     (1U)                               
#define USART_SR_FE_Msk                     (0x1UL << USART_SR_FE_Pos)          /*!< 0x00000002 */
#define USART_SR_FE                         USART_SR_FE_Msk                     /*!< Framing Error */
#define USART_SR_NE_Pos                     (2U)                               
#define USART_SR_NE_Msk                     (0x1UL << USART_SR_NE_Pos)          /*!< 0x00000004 */
#define USART_SR_NE                         USART_SR_NE_Msk                     /*!< Noise Error Flag */
#define USART_SR_ORE_Pos                    (3U)                               
#define USART_SR_ORE_Msk                    (0x1UL << USART_SR_ORE_Pos)         /*!< 0x00000008 */
#define USART_SR_ORE                        USART_SR_ORE_Msk                    /*!< OverRun Error */
#define USART_SR_IDLE_Pos                   (4U)                               
#define USART_SR_IDLE_Msk                   (0x1UL << USART_SR_IDLE_Pos)        /*!< 0x00000010 */
#define USART_SR_IDLE                       USART_SR_IDLE_Msk                   /*!< IDLE line detected */
#define USART_SR_RXNE_Pos                   (5U)                               
#define USART_SR_RXNE_Msk                   (0x1UL << USART_SR_RXNE_Pos)        /*!< 0x00000020 */
#define USART_SR_RXNE                       USART_SR_RXNE_Msk                   /*!< Read Data Register Not Empty */
#define USART_SR_TC_Pos                     (6U)                               
#define USART_SR_TC_Msk                     (0x1UL << USART_SR_TC_Pos)          /*!< 0x00000040 */
#define USART_SR_TC                         USART_SR_TC_Msk                     /*!< Transmission Complete */
#define USART_SR_TXE_Pos                    (7U)                               
#define USART_SR_TXE_Msk                    (0x1UL << USART_SR_TXE_Pos)         /*!< 0x00000080 */
#define USART_SR_TXE                        USART_SR_TXE_Msk                    /*!< Transmit Data Register Empty */
#define USART_SR_LBD_Pos                    (8U)                               
#define USART_SR_LBD_Msk                    (0x1UL << USART_SR_LBD_Pos)         /*!< 0x00000100 */
#define USART_SR_LBD                        USART_SR_LBD_Msk                    /*!< LIN Break Detection Flag */
#define USART_SR_CTS_Pos                    (9U)                               
#define USART_SR_CTS_Msk                    (0x1UL << USART_SR_CTS_Pos)         /*!< 0x00000200 */
#define USART_SR_CTS                        USART_SR_CTS_Msk                    /*!< CTS Flag */

/*******************  Bit definition for USART_DR register  *******************/
#define USART_DR_DR_Pos                     (0U)                               
#define USART_DR_DR_Msk                     (0x1FFUL << USART_DR_DR_Pos)        /*!< 0x000001FF */
#define USART_DR_DR                         USART_DR_DR_Msk                     /*!< Data value */

/******************  Bit definition for USART_BRR register  *******************/
#define USART_BRR_DIV_Fraction_Pos          (0U)                               
#define USART_BRR_DIV_Fraction_Msk          (0xFUL << USART_BRR_DIV_Fraction_Pos) /*!< 0x0000000F */
#define USART_BRR_DIV_Fraction              USART_BRR_DIV_Fraction_Msk          /*!< Fraction of USARTDIV */
#define USART_BRR_DIV_Mantissa_Pos          (4U)                               
#define USART_BRR_DIV_Mantissa_Msk          (0xFFFUL << USART_BRR_DIV_Mantissa_Pos) /*!< 0x0000FFF0 */
#define USART_BRR_DIV_Mantissa              USART_BRR_DIV_Mantissa_Msk          /*!< Mantissa of USARTDIV */

/******************  Bit definition for USART_CR1 register  *******************/
#define USART_CR1_SBK_Pos                   (0U)                               
#define USART_CR1_SBK_Msk                   (0x1UL << USART_CR1_SBK_Pos)        /*!< 0x00000001 */
#define USART_CR1_SBK                       USART_CR1_SBK_Msk                   /*!< Send Break */
#define USART_CR1_RWU_Pos                   (1U)                               
#define USART_CR1_RWU_Msk                   (0x1UL << USART_CR1_RWU_Pos)        /*!< 0x00000002 */
#define USART_CR1_RWU                       USART_CR1_RWU_Msk                   /*!< Receiver wakeup */
#define USART_CR1_RE_Pos                    (2U)                               
#define USART_CR1_RE_Msk                    (0x1UL << USART_CR1_RE_Pos)         /*!< 0x00000004 */
#define USART_CR1_RE                        USART_CR1_RE_Msk                    /*!< Receiver Enable */
#define USART_CR1_TE_Pos                    (3U)                               
#define USART_CR1_TE_Msk                    (0x1UL << USART_CR1_TE_Pos)         /*!< 0x00000008 */
#define USART_CR1_TE                        USART_CR1_TE_Msk                    /*!< Transmitter Enable */
#define USART_CR1_IDLEIE_Pos                (4U)                               
#define USART_CR1_IDLEIE_Msk                (0x1UL << USART_CR1_IDLEIE_Pos)     /*!< 0x00000010 */
#define USART_CR1_IDLEIE                    USART_CR1_IDLEIE_Msk                /*!< IDLE Interrupt Enable */
#define USART_CR1_RXNEIE_Pos                (5U)                               
#define USART_CR1_RXNEIE_Msk                (0x1UL << USART_CR1_RXNEIE_Pos)     /*!< 0x00000020 */
#define USART_CR1_RXNEIE                    USART_CR1_RXNEIE_Msk                /*!< RXNE Interrupt Enable */
#define USART_CR1_TCIE_Pos                  (6U)                               
#define USART_CR1_TCIE_Msk                  (0x1UL << USART_CR1_TCIE_Pos)       /*!< 0x00000040 */
#define USART_CR1_TCIE                      USART_CR1_TCIE_Msk                  /*!< Transmission Complete Interrupt Enable */
#define USART_CR1_TXEIE_Pos                 (7U)                               
#define USART_CR1_TXEIE_Msk                 (0x1UL << USART_CR1_TXEIE_Pos)      /*!< 0x00000080 */
#define USART_CR1_TXEIE                     USART_CR1_TXEIE_Msk                 /*!< PE Interrupt Enable */
#define USART_CR1_PEIE_Pos                  (8U)                               
#define USART_CR1_PEIE_Msk                  (0x1UL << USART_CR1_PEIE_Pos)       /*!< 0x00000100 */
#define USART_CR1_PEIE                      USART_CR1_PEIE_Msk                  /*!< PE Interrupt Enable */
#define USART_CR1_PS_Pos                    (9U)                               
#define USART_CR1_PS_Msk                    (0x1UL << USART_CR1_PS_Pos)         /*!< 0x00000200 */
#define USART_CR1_PS                        USART_CR1_PS_Msk                    /*!< Parity Selection */
#define USART_CR1_PCE_Pos                   (10U)                              
#define USART_CR1_PCE_Msk                   (0x1UL << USART_CR1_PCE_Pos)        /*!< 0x00000400 */
#define USART_CR1_PCE                       USART_CR1_PCE_Msk                   /*!< Parity Control Enable */
#define USART_CR1_WAKE_Pos                  (11U)                              
#define USART_CR1_WAKE_Msk                  (0x1UL << USART_CR1_WAKE_Pos)       /*!< 0x00000800 */
#define USART_CR1_WAKE                      USART_CR1_WAKE_Msk                  /*!< Wakeup method */
#define USART_CR1_M_Pos                     (12U)                              
#define USART_CR1_M_Msk                     (0x1UL << USART_CR1_M_Pos)          /*!< 0x00001000 */
#define USART_CR1_M                         USART_CR1_M_Msk                     /*!< Word length */
#define USART_CR1_UE_Pos                    (13U)                              
#define USART_CR1_UE_Msk                    (0x1UL << USART_CR1_UE_Pos)         /*!< 0x00002000 */
#define USART_CR1_UE                        USART_CR1_UE_Msk                    /*!< USART Enable */

/******************  Bit definition for USART_CR2 register  *******************/
#define USART_CR2_ADD_Pos                   (0U)                               
#define USART_CR2_ADD_Msk                   (0xFUL << USART_CR2_ADD_Pos)        /*!< 0x0000000F */
#define USART_CR2_ADD                       USART_CR2_ADD_Msk                   /*!< Address of the USART node */
#define USART_CR2_LBDL_Pos                  (5U)                               
#define USART_CR2_LBDL_Msk                  (0x1UL << USART_CR2_LBDL_Pos)       /*!< 0x00000020 */
#define USART_CR2_LBDL                      USART_CR2_LBDL_Msk                  /*!< LIN Break Detection Length */
#define USART_CR2_LBDIE_Pos                 (6U)                               
#define USART_CR2_LBDIE_Msk                 (0x1UL << USART_CR2_LBDIE_Pos)      /*!< 0x00000040 */
#define USART_CR2_LBDIE                     USART_CR2_LBDIE_Msk                 /*!< LIN Break Detection Interrupt Enable */
#define USART_CR2_LBCL_Pos                  (8U)                               
#define USART_CR2_LBCL_Msk                  (0x1UL << USART_CR2_LBCL_Pos)       /*!< 0x00000100 */
#define USART_CR2_LBCL                      USART_CR2_LBCL_Msk                  /*!< Last Bit Clock pulse */
#define USART_CR2_CPHA_Pos                  (9U)                               
#define USART_CR2_CPHA_Msk                  (0x1UL << USART_CR2_CPHA_Pos)       /*!< 0x00000200 */
#define USART_CR2_CPHA                      USART_CR2_CPHA_Msk                  /*!< Clock Phase */
#define USART_CR2_CPOL_Pos                  (10U)                              
#define USART_CR2_CPOL_Msk                  (0x1UL << USART_CR2_CPOL_Pos)       /*!< 0x00000400 */
#define USART_CR2_CPOL                      USART_CR2_CPOL_Msk                  /*!< Clock Polarity */
#define USART_CR2_CLKEN_Pos                 (11U)                              
#define USART_CR2_CLKEN_Msk                 (0x1UL << USART_CR2_CLKEN_Pos)      /*!< 0x00000800 */
#define USART_CR2_CLKEN                     USART_CR2_CLKEN_Msk                 /*!< Clock Enable */

#define USART_CR2_STOP_Pos                  (12U)                              
#define USART_CR2_STOP_Msk                  (0x3UL << USART_CR2_STOP_Pos)       /*!< 0x00003000 */
#define USART_CR2_STOP                      USART_CR2_STOP_Msk                  /*!< STOP[1:0] bits (STOP bits) */
#define USART_CR2_STOP_0                    (0x1UL << USART_CR2_STOP_Pos)       /*!< 0x00001000 */
#define USART_CR2_STOP_1                    (0x2UL << USART_CR2_STOP_Pos)       /*!< 0x00002000 */

#define USART_CR2_LINEN_Pos                 (14U)                              
#define USART_CR2_LINEN_Msk                 (0x1UL << USART_CR2_LINEN_Pos)      /*!< 0x00004000 */
#define USART_CR2_LINEN                     USART_CR2_LINEN_Msk                 /*!< LIN mode enable */

/******************  Bit definition for USART_CR3 register  *******************/
#define USART_CR3_EIE_Pos                   (0U)                               
#define USART_CR3_EIE_Msk                   (0x1UL << USART_CR3_EIE_Pos)        /*!< 0x00000001 */
#define USART_CR3_EIE                       USART_CR3_EIE_Msk                   /*!< Error Interrupt Enable */
#define USART_CR3_IREN_Pos                  (1U)                               
#define USART_CR3_IREN_Msk                  (0x1UL << USART_CR3_IREN_Pos)       /*!< 0x00000002 */
#define USART_CR3_IREN                      USART_CR3_IREN_Msk                  /*!< IrDA mode Enable */
#define USART_CR3_IRLP_Pos                  (2U)                               
#define USART_CR3_IRLP_Msk                  (0x1UL << USART_CR3_IRLP_Pos)       /*!< 0x00000004 */
#define USART_CR3_IRLP                      USART_CR3_IRLP_Msk                  /*!< IrDA Low-Power */
#define USART_CR3_HDSEL_Pos                 (3U)                               
#define USART_CR3_HDSEL_Msk                 (0x1UL << USART_CR3_HDSEL_Pos)      /*!< 0x00000008 */
#define USART_CR3_HDSEL                     USART_CR3_HDSEL_Msk                 /*!< Half-Duplex Selection */
#define USART_CR3_NACK_Pos                  (4U)                               
#define USART_CR3_NACK_Msk                  (0x1UL << USART_CR3_NACK_Pos)       /*!< 0x00000010 */
#define USART_CR3_NACK                      USART_CR3_NACK_Msk                  /*!< Smartcard NACK enable */
#define USART_CR3_SCEN_Pos                  (5U)                               
#define USART_CR3_SCEN_Msk                  (0x1UL << USART_CR3_SCEN_Pos)       /*!< 0x00000020 */
#define USART_CR3_SCEN                      USART_CR3_SCEN_Msk                  /*!< Smartcard mode enable */
#define USART_CR3_DMAR_Pos                  (6U)                               
#define USART_CR3_DMAR_Msk                  (0x1UL << USART_CR3_DMAR_Pos)       /*!< 0x00000040 */
#define USART_CR3_DMAR                      USART_CR3_DMAR_Msk                  /*!< DMA Enable Receiver */
#define USART_CR3_DMAT_Pos                  (7U)                               
#define USART_CR3_DMAT_Msk                  (0x1UL << USART_CR3_DMAT_Pos)       /*!< 0x00000080 */
#define USART_CR3_DMAT                      USART_CR3_DMAT_Msk                  /*!< DMA Enable Transmitter */
#define USART_CR3_RTSE_Pos                  (8U)                               
#define USART_CR3_RTSE_Msk                  (0x1UL << USART_CR3_RTSE_Pos)       /*!< 0x00000100 */
#define USART_CR3_RTSE                      USART_CR3_RTSE_Msk                  /*!< RTS Enable */
#define USART_CR3_CTSE_Pos                  (9U)                               
#define USART_CR3_CTSE_Msk                  (0x1UL << USART_CR3_CTSE_Pos)       /*!< 0x00000200 */
#define USART_CR3_CTSE                      USART_CR3_CTSE_Msk                  /*!< CTS Enable */
#define USART_CR3_CTSIE_Pos                 (10U)                              
#define USART_CR3_CTSIE_Msk                 (0x1UL << USART_CR3_CTSIE_Pos)      /*!< 0x00000400 */
#define USART_CR3_CTSIE                     USART_CR3_CTSIE_Msk                 /*!< CTS Interrupt Enable */

/******************  Bit definition for USART_GTPR register  ******************/
#define USART_GTPR_PSC_Pos                  (0U)                               
#define USART_GTPR_PSC_Msk                  (0xFFUL << USART_GTPR_PSC_Pos)      /*!< 0x000000FF */
#define USART_GTPR_PSC                      USART_GTPR_PSC_Msk                  /*!< PSC[7:0] bits (Prescaler value) */
#define USART_GTPR_PSC_0                    (0x01UL << USART_GTPR_PSC_Pos)      /*!< 0x00000001 */
#define USART_GTPR_PSC_1                    (0x02UL << USART_GTPR_PSC_Pos)      /*!< 0x00000002 */
#define USART_GTPR_PSC_2                    (0x04UL << USART_GTPR_PSC_Pos)      /*!< 0x00000004 */
#define USART_GTPR_PSC_3                    (0x08UL << USART_GTPR_PSC_Pos)      /*!< 0x00000008 */
#define USART_GTPR_PSC_4                    (0x10UL << USART_GTPR_PSC_Pos)      /*!< 0x00000010 */
#define USART_GTPR_PSC_5                    (0x20UL << USART_GTPR_PSC_Pos)      /*!< 0x00000020 */
#define USART_GTPR_PSC_6                    (0x40UL << USART_GTPR_PSC_Pos)      /*!< 0x00000040 */
#define USART_GTPR_PSC_7                    (0x80UL << USART_GTPR_PSC_Pos)      /*!< 0x00000080 */

#define USART_GTPR_GT_Pos                   (8U)                               
#define USART_GTPR_GT_Msk                   (0xFFUL << USART_GTPR_GT_Pos)       /*!< 0x0000FF00 */
#define USART_GTPR_GT                       USART_GTPR_GT_Msk                   /*!< Guard time value */

/******************************************************************************/
/*                                                                            */
/*                            Debug MCU (DBGMCU)                              */
/*                                                                            */
/******************************************************************************/

/****************  Bit definition for DBGMCU_IDCODE register  *****************/
#define DBGMCU_IDCODE_DEV_ID_Pos            (0U)                               
#define DBGMCU_IDCODE_DEV_ID_Msk            (0xFFFUL << DBGMCU_IDCODE_DEV_ID_Pos) /*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                DBGMCU_IDCODE_DEV_ID_Msk              /*!< Device Identifier */

#define DBGMCU_IDCODE_REV_ID_Pos            (16U)                              
#define DBGMCU_IDCODE_REV_ID_Msk            (0xFFFFUL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                DBGMCU_IDCODE_REV_ID_Msk               /*!< REV_ID[15:0] bits (Revision Identifier) */
#define DBGMCU_IDCODE_REV_ID_0              (0x0001UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x00010000 */
#define DBGMCU_IDCODE_REV_ID_1              (0x0002UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x00020000 */
#define DBGMCU_IDCODE_REV_ID_2              (0x0004UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x00040000 */
#define DBGMCU_IDCODE_REV_ID_3              (0x0008UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x00080000 */
#define DBGMCU_IDCODE_REV_ID_4              (0x0010UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x00100000 */
#define DBGMCU_IDCODE_REV_ID_5              (0x0020UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x00200000 */
#define DBGMCU_IDCODE_REV_ID_6              (0x0040UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x00400000 */
#define DBGMCU_IDCODE_REV_ID_7              (0x0080UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x00800000 */
#define DBGMCU_IDCODE_REV_ID_8              (0x0100UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x01000000 */
#define DBGMCU_IDCODE_REV_ID_9              (0x0200UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x02000000 */
#define DBGMCU_IDCODE_REV_ID_10             (0x0400UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x04000000 */
#define DBGMCU_IDCODE_REV_ID_11             (0x0800UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x08000000 */
#define DBGMCU_IDCODE_REV_ID_12             (0x1000UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x10000000 */
#define DBGMCU_IDCODE_REV_ID_13             (0x2000UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x20000000 */
#define DBGMCU_IDCODE_REV_ID_14             (0x4000UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x40000000 */
#define DBGMCU_IDCODE_REV_ID_15             (0x8000UL << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0x80000000 */

/******************  Bit definition for DBGMCU_CR register  *******************/
#define DBGMCU_CR_DBG_SLEEP_Pos             (0U)                               
#define DBGMCU_CR_DBG_SLEEP_Msk             (0x1UL << DBGMCU_CR_DBG_SLEEP_Pos)   /*!< 0x00000001 */
#define DBGMCU_CR_DBG_SLEEP                 DBGMCU_CR_DBG_SLEEP_Msk              /*!< Debug Sleep Mode */
#define DBGMCU_CR_DBG_STOP_Pos              (1U)                               
#define DBGMCU_CR_DBG_STOP_Msk              (0x1UL << DBGMCU_CR_DBG_STOP_Pos)    /*!< 0x00000002 */
#define DBGMCU_CR_DBG_STOP                  DBGMCU_CR_DBG_STOP_Msk               /*!< Debug Stop Mode */
#define DBGMCU_CR_DBG_STANDBY_Pos           (2U)                               
#define DBGMCU_CR_DBG_STANDBY_Msk           (0x1UL << DBGMCU_CR_DBG_STANDBY_Pos) /*!< 0x00000004 */
#define DBGMCU_CR_DBG_STANDBY               DBGMCU_CR_DBG_STANDBY_Msk            /*!< Debug Standby mode */
#define DBGMCU_CR_TRACE_IOEN_Pos            (5U)                               
#define DBGMCU_CR_TRACE_IOEN_Msk            (0x1UL << DBGMCU_CR_TRACE_IOEN_Pos)  /*!< 0x00000020 */
#define DBGMCU_CR_TRACE_IOEN                DBGMCU_CR_TRACE_IOEN_Msk             /*!< Trace Pin Assignment Control */

#define DBGMCU_CR_TRACE_MODE_Pos            (6U)                               
#define DBGMCU_CR_TRACE_MODE_Msk            (0x3UL << DBGMCU_CR_TRACE_MODE_Pos)  /*!< 0x000000C0 */
#define DBGMCU_CR_TRACE_MODE                DBGMCU_CR_TRACE_MODE_Msk             /*!< TRACE_MODE[1:0] bits (Trace Pin Assignment Control) */
#define DBGMCU_CR_TRACE_MODE_0              (0x1UL << DBGMCU_CR_TRACE_MODE_Pos)  /*!< 0x00000040 */
#define DBGMCU_CR_TRACE_MODE_1              (0x2UL << DBGMCU_CR_TRACE_MODE_Pos)  /*!< 0x00000080 */

#define DBGMCU_CR_DBG_IWDG_STOP_Pos         (8U)                               
#define DBGMCU_CR_DBG_IWDG_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_IWDG_STOP_Pos) /*!< 0x00000100 */
#define DBGMCU_CR_DBG_IWDG_STOP             DBGMCU_CR_DBG_IWDG_STOP_Msk            /*!< Debug Independent Watchdog stopped when Core is halted */
#define DBGMCU_CR_DBG_WWDG_STOP_Pos         (9U)                               
#define DBGMCU_CR_DBG_WWDG_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_WWDG_STOP_Pos) /*!< 0x00000200 */
#define DBGMCU_CR_DBG_WWDG_STOP             DBGMCU_CR_DBG_WWDG_STOP_Msk            /*!< Debug Window Watchdog stopped when Core is halted */
#define DBGMCU_CR_DBG_TIM1_STOP_Pos         (10U)                              
#define DBGMCU_CR_DBG_TIM1_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_TIM1_STOP_Pos) /*!< 0x00000400 */
#define DBGMCU_CR_DBG_TIM1_STOP             DBGMCU_CR_DBG_TIM1_STOP_Msk            /*!< TIM1 counter stopped when core is halted */
#define DBGMCU_CR_DBG_TIM2_STOP_Pos         (11U)                              
#define DBGMCU_CR_DBG_TIM2_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_TIM2_STOP_Pos) /*!< 0x00000800 */
#define DBGMCU_CR_DBG_TIM2_STOP             DBGMCU_CR_DBG_TIM2_STOP_Msk            /*!< TIM2 counter stopped when core is halted */
#define DBGMCU_CR_DBG_TIM3_STOP_Pos         (12U)                              
#define DBGMCU_CR_DBG_TIM3_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_TIM3_STOP_Pos) /*!< 0x00001000 */
#define DBGMCU_CR_DBG_TIM3_STOP             DBGMCU_CR_DBG_TIM3_STOP_Msk            /*!< TIM3 counter stopped when core is halted */
#define DBGMCU_CR_DBG_TIM4_STOP_Pos         (13U)                              
#define DBGMCU_CR_DBG_TIM4_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_TIM4_STOP_Pos) /*!< 0x00002000 */
#define DBGMCU_CR_DBG_TIM4_STOP             DBGMCU_CR_DBG_TIM4_STOP_Msk            /*!< TIM4 counter stopped when core is halted */
#define DBGMCU_CR_DBG_CAN1_STOP_Pos         (14U)                              
#define DBGMCU_CR_DBG_CAN1_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_CAN1_STOP_Pos) /*!< 0x00004000 */
#define DBGMCU_CR_DBG_CAN1_STOP             DBGMCU_CR_DBG_CAN1_STOP_Msk            /*!< Debug CAN1 stopped when Core is halted */
#define DBGMCU_CR_DBG_I2C1_SMBUS_TIMEOUT_Pos (15U)                             
#define DBGMCU_CR_DBG_I2C1_SMBUS_TIMEOUT_Msk (0x1UL << DBGMCU_CR_DBG_I2C1_SMBUS_TIMEOUT_Pos) /*!< 0x00008000 */
#define DBGMCU_CR_DBG_I2C1_SMBUS_TIMEOUT    DBGMCU_CR_DBG_I2C1_SMBUS_TIMEOUT_Msk   /*!< SMBUS timeout mode stopped when Core is halted */
#define DBGMCU_CR_DBG_I2C2_SMBUS_TIMEOUT_Pos (16U)                             
#define DBGMCU_CR_DBG_I2C2_SMBUS_TIMEOUT_Msk (0x1UL << DBGMCU_CR_DBG_I2C2_SMBUS_TIMEOUT_Pos) /*!< 0x00010000 */
#define DBGMCU_CR_DBG_I2C2_SMBUS_TIMEOUT    DBGMCU_CR_DBG_I2C2_SMBUS_TIMEOUT_Msk   /*!< SMBUS timeout mode stopped when Core is halted */
#define DBGMCU_CR_DBG_TIM8_STOP_Pos         (17U)                              
#define DBGMCU_CR_DBG_TIM8_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_TIM8_STOP_Pos) /*!< 0x00020000 */
#define DBGMCU_CR_DBG_TIM8_STOP             DBGMCU_CR_DBG_TIM8_STOP_Msk            /*!< TIM8 counter stopped when core is halted */
#define DBGMCU_CR_DBG_TIM5_STOP_Pos         (18U)                              
#define DBGMCU_CR_DBG_TIM5_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_TIM5_STOP_Pos) /*!< 0x00040000 */
#define DBGMCU_CR_DBG_TIM5_STOP             DBGMCU_CR_DBG_TIM5_STOP_Msk            /*!< TIM5 counter stopped when core is halted */
#define DBGMCU_CR_DBG_TIM6_STOP_Pos         (19U)                              
#define DBGMCU_CR_DBG_TIM6_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_TIM6_STOP_Pos) /*!< 0x00080000 */
#define DBGMCU_CR_DBG_TIM6_STOP             DBGMCU_CR_DBG_TIM6_STOP_Msk            /*!< TIM6 counter stopped when core is halted */
#define DBGMCU_CR_DBG_TIM7_STOP_Pos         (20U)                              
#define DBGMCU_CR_DBG_TIM7_STOP_Msk         (0x1UL << DBGMCU_CR_DBG_TIM7_STOP_Pos) /*!< 0x00100000 */
#define DBGMCU_CR_DBG_TIM7_STOP             DBGMCU_CR_DBG_TIM7_STOP_Msk            /*!< TIM7 counter stopped when core is halted */

/******************************************************************************/
/*                                                                            */
/*                  FLASH and Option Bytes Registers (FLASH)                  */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for FLASH_ACR register  ******************/
#define FLASH_ACR_LATENCY_Pos               (0U)                               
#define FLASH_ACR_LATENCY_Msk               (0x7UL << FLASH_ACR_LATENCY_Pos)    /*!< 0x00000007 */
#define FLASH_ACR_LATENCY                   FLASH_ACR_LATENCY_Msk               /*!< LATENCY[2:0] bits (Latency) */
#define FLASH_ACR_LATENCY_0                 (0x0UL << FLASH_ACR_LATENCY_Pos)    /*!< 0x00000001 */
#define FLASH_ACR_LATENCY_1                 (0x1UL << FLASH_ACR_LATENCY_Pos)    /*!< 0x00000002 */

#define FLASH_ACR_HLFCYA_Pos                (3U)                               
#define FLASH_ACR_HLFCYA_Msk                (0x1UL << FLASH_ACR_HLFCYA_Pos)     /*!< 0x00000008 */
#define FLASH_ACR_HLFCYA                    FLASH_ACR_HLFCYA_Msk                /*!< Flash Half Cycle Access Enable */
#define FLASH_ACR_PRFTBE_Pos                (4U)
#define FLASH_ACR_PRFTBE_Msk                (0x1UL << FLASH_ACR_PRFTBE_Pos)     /*!< 0x00000010 */
#define FLASH_ACR_PRFTBE                    FLASH_ACR_PRFTBE_Msk                /*!< Prefetch Buffer Enable */
#define FLASH_ACR_PRFTBS_Pos                (5U)                               
#define FLASH_ACR_PRFTBS_Msk                (0x1UL << FLASH_ACR_PRFTBS_Pos)     /*!< 0x00000020 */
#define FLASH_ACR_PRFTBS                    FLASH_ACR_PRFTBS_Msk                /*!< Prefetch Buffer Status */

/******************  Bit definition for FLASH_KEYR register  ******************/
#define FLASH_KEYR_FKEYR_Pos                (0U)                               
#define FLASH_KEYR_FKEYR_Msk                (0xFFFFFFFFUL << FLASH_KEYR_FKEYR_Pos) /*!< 0xFFFFFFFF */
#define FLASH_KEYR_FKEYR                    FLASH_KEYR_FKEYR_Msk                /*!< FPEC Key */

#define RDP_KEY_Pos                         (0U)                               
#define RDP_KEY_Msk                         (0xA5UL << RDP_KEY_Pos)             /*!< 0x000000A5 */
#define RDP_KEY                             RDP_KEY_Msk                         /*!< RDP Key */
#define FLASH_KEY1_Pos                      (0U)                               
#define FLASH_KEY1_Msk                      (0x45670123UL << FLASH_KEY1_Pos)    /*!< 0x45670123 */
#define FLASH_KEY1                          FLASH_KEY1_Msk                      /*!< FPEC Key1 */
#define FLASH_KEY2_Pos                      (0U)                               
#define FLASH_KEY2_Msk                      (0xCDEF89ABUL << FLASH_KEY2_Pos)    /*!< 0xCDEF89AB */
#define FLASH_KEY2                          FLASH_KEY2_Msk                      /*!< FPEC Key2 */

/*****************  Bit definition for FLASH_OPTKEYR register  ****************/
#define FLASH_OPTKEYR_OPTKEYR_Pos           (0U)                               
#define FLASH_OPTKEYR_OPTKEYR_Msk           (0xFFFFFFFFUL << FLASH_OPTKEYR_OPTKEYR_Pos) /*!< 0xFFFFFFFF */
#define FLASH_OPTKEYR_OPTKEYR               FLASH_OPTKEYR_OPTKEYR_Msk           /*!< Option Byte Key */

#define  FLASH_OPTKEY1                       FLASH_KEY1                         /*!< Option Byte Key1 */
#define  FLASH_OPTKEY2                       FLASH_KEY2                         /*!< Option Byte Key2 */

/******************  Bit definition for FLASH_SR register  ********************/
#define FLASH_SR_BSY_Pos                    (0U)                               
#define FLASH_SR_BSY_Msk                    (0x1UL << FLASH_SR_BSY_Pos)         /*!< 0x00000001 */
#define FLASH_SR_BSY                        FLASH_SR_BSY_Msk                    /*!< Busy */
#define FLASH_SR_PGERR_Pos                  (2U)                               
#define FLASH_SR_PGERR_Msk                  (0x1UL << FLASH_SR_PGERR_Pos)       /*!< 0x00000004 */
#define FLASH_SR_PGERR                      FLASH_SR_PGERR_Msk                  /*!< Programming Error */
#define FLASH_SR_WRPRTERR_Pos               (4U)                               
#define FLASH_SR_WRPRTERR_Msk               (0x1UL << FLASH_SR_WRPRTERR_Pos)    /*!< 0x00000010 */
#define FLASH_SR_WRPRTERR                   FLASH_SR_WRPRTERR_Msk               /*!< Write Protection Error */
#define FLASH_SR_EOP_Pos                    (5U)                               
#define FLASH_SR_EOP_Msk                    (0x1UL << FLASH_SR_EOP_Pos)         /*!< 0x00000020 */
#define FLASH_SR_EOP                        FLASH_SR_EOP_Msk                    /*!< End of operation */

/*******************  Bit definition for FLASH_CR register  *******************/
#define FLASH_CR_PG_Pos                     (0U)                               
#define FLASH_CR_PG_Msk                     (0x1UL << FLASH_CR_PG_Pos)          /*!< 0x00000001 */
#define FLASH_CR_PG                         FLASH_CR_PG_Msk                     /*!< Programming */
#define FLASH_CR_PER_Pos                    (1U)                               
#define FLASH_CR_PER_Msk                    (0x1UL << FLASH_CR_PER_Pos)         /*!< 0x00000002 */
#define FLASH_CR_PER                        FLASH_CR_PER_Msk                    /*!< Page Erase */
#define FLASH_CR_MER_Pos                    (2U)                               
#define FLASH_CR_MER_Msk                    (0x1UL << FLASH_CR_MER_Pos)         /*!< 0x00000004 */
#define FLASH_CR_MER                        FLASH_CR_MER_Msk                    /*!< Mass Erase */
#define FLASH_CR_OPTPG_Pos                  (4U)                               
#define FLASH_CR_OPTPG_Msk                  (0x1UL << FLASH_CR_OPTPG_Pos)       /*!< 0x00000010 */
#define FLASH_CR_OPTPG                      FLASH_CR_OPTPG_Msk                  /*!< Option Byte Programming */
#define FLASH_CR_OPTER_Pos                  (5U)                               
#define FLASH_CR_OPTER_Msk                  (0x1UL << FLASH_CR_OPTER_Pos)       /*!< 0x00000020 */
#define FLASH_CR_OPTER                      FLASH_CR_OPTER_Msk                  /*!< Option Byte Erase */
#define FLASH_CR_STRT_Pos                   (6U)                               
#define FLASH_CR_STRT_Msk                   (0x1UL << FLASH_CR_STRT_Pos)        /*!< 0x00000040 */
#define FLASH_CR_STRT                       FLASH_CR_STRT_Msk                   /*!< Start */
#define FLASH_CR_LOCK_Pos                   (7U)                               
#define FLASH_CR_LOCK_Msk                   (0x1UL << FLASH_CR_LOCK_Pos)        /*!< 0x00000080 */
#define FLASH_CR_LOCK                       FLASH_CR_LOCK_Msk                   /*!< Lock */
#define FLASH_CR_OPTWRE_Pos                 (9U)                               
#define FLASH_CR_OPTWRE_Msk                 (0x1UL << FLASH_CR_OPTWRE_Pos)      /*!< 0x00000200 */
#define FLASH_CR_OPTWRE                     FLASH_CR_OPTWRE_Msk                 /*!< Option Bytes Write Enable */
#define FLASH_CR_ERRIE_Pos                  (10U)                              
#define FLASH_CR_ERRIE_Msk                  (0x1UL << FLASH_CR_ERRIE_Pos)       /*!< 0x00000400 */
#define FLASH_CR_ERRIE                      FLASH_CR_ERRIE_Msk                  /*!< Error Interrupt Enable */
#define FLASH_CR_EOPIE_Pos                  (12U)                              
#define FLASH_CR_EOPIE_Msk                  (0x1UL << FLASH_CR_EOPIE_Pos)       /*!< 0x00001000 */
#define FLASH_CR_EOPIE                      FLASH_CR_EOPIE_Msk                  /*!< End of operation interrupt enable */

/*******************  Bit definition for FLASH_AR register  *******************/
#define FLASH_AR_FAR_Pos                    (0U)                               
#define FLASH_AR_FAR_Msk                    (0xFFFFFFFFUL << FLASH_AR_FAR_Pos)  /*!< 0xFFFFFFFF */
#define FLASH_AR_FAR                        FLASH_AR_FAR_Msk                    /*!< Flash Address */

/******************  Bit definition for FLASH_OBR register  *******************/
#define FLASH_OBR_OPTERR_Pos                (0U)                               
#define FLASH_OBR_OPTERR_Msk                (0x1UL << FLASH_OBR_OPTERR_Pos)     /*!< 0x00000001 */
#define FLASH_OBR_OPTERR                    FLASH_OBR_OPTERR_Msk                /*!< Option Byte Error */
#define FLASH_OBR_RDPRT_Pos                 (1U)                               
#define FLASH_OBR_RDPRT_Msk                 (0x1UL << FLASH_OBR_RDPRT_Pos)      /*!< 0x00000002 */
#define FLASH_OBR_RDPRT                     FLASH_OBR_RDPRT_Msk                 /*!< Read protection */

#define FLASH_OBR_IWDG_SW_Pos               (2U)                               
#define FLASH_OBR_IWDG_SW_Msk               (0x1UL << FLASH_OBR_IWDG_SW_Pos)    /*!< 0x00000004 */
#define FLASH_OBR_IWDG_SW                   FLASH_OBR_IWDG_SW_Msk               /*!< IWDG SW */
#define FLASH_OBR_nRST_STOP_Pos             (3U)                               
#define FLASH_OBR_nRST_STOP_Msk             (0x1UL << FLASH_OBR_nRST_STOP_Pos)  /*!< 0x00000008 */
#define FLASH_OBR_nRST_STOP                 FLASH_OBR_nRST_STOP_Msk             /*!< nRST_STOP */
#define FLASH_OBR_nRST_STDBY_Pos            (4U)                               
#define FLASH_OBR_nRST_STDBY_Msk            (0x1UL << FLASH_OBR_nRST_STDBY_Pos) /*!< 0x00000010 */
#define FLASH_OBR_nRST_STDBY                FLASH_OBR_nRST_STDBY_Msk            /*!< nRST_STDBY */
#define FLASH_OBR_USER_Pos                  (2U)                               
#define FLASH_OBR_USER_Msk                  (0x7UL << FLASH_OBR_USER_Pos)       /*!< 0x0000001C */
#define FLASH_OBR_USER                      FLASH_OBR_USER_Msk                  /*!< User Option Bytes */
#define FLASH_OBR_DATA0_Pos                 (10U)                              
#define FLASH_OBR_DATA0_Msk                 (0xFFUL << FLASH_OBR_DATA0_Pos)     /*!< 0x0003FC00 */
#define FLASH_OBR_DATA0                     FLASH_OBR_DATA0_Msk                 /*!< Data0 */
#define FLASH_OBR_DATA1_Pos                 (18U)                              
#define FLASH_OBR_DATA1_Msk                 (0xFFUL << FLASH_OBR_DATA1_Pos)     /*!< 0x03FC0000 */
#define FLASH_OBR_DATA1                     FLASH_OBR_DATA1_Msk                 /*!< Data1 */

/******************  Bit definition for FLASH_WRPR register  ******************/
#define FLASH_WRPR_WRP_Pos                  (0U)                               
#define FLASH_WRPR_WRP_Msk                  (0xFFFFFFFFUL << FLASH_WRPR_WRP_Pos) /*!< 0xFFFFFFFF */
#define FLASH_WRPR_WRP                      FLASH_WRPR_WRP_Msk                  /*!< Write Protect */

/*----------------------------------------------------------------------------*/

/******************  Bit definition for FLASH_RDP register  *******************/
#define FLASH_RDP_RDP_Pos                   (0U)                               
#define FLASH_RDP_RDP_Msk                   (0xFFUL << FLASH_RDP_RDP_Pos)       /*!< 0x000000FF */
#define FLASH_RDP_RDP                       FLASH_RDP_RDP_Msk                   /*!< Read protection option byte */
#define FLASH_RDP_nRDP_Pos                  (8U)                               
#define FLASH_RDP_nRDP_Msk                  (0xFFUL << FLASH_RDP_nRDP_Pos)      /*!< 0x0000FF00 */
#define FLASH_RDP_nRDP                      FLASH_RDP_nRDP_Msk                  /*!< Read protection complemented option byte */

/******************  Bit definition for FLASH_USER register  ******************/
#define FLASH_USER_USER_Pos                 (16U)                              
#define FLASH_USER_USER_Msk                 (0xFFUL << FLASH_USER_USER_Pos)     /*!< 0x00FF0000 */
#define FLASH_USER_USER                     FLASH_USER_USER_Msk                 /*!< User option byte */
#define FLASH_USER_nUSER_Pos                (24U)                              
#define FLASH_USER_nUSER_Msk                (0xFFUL << FLASH_USER_nUSER_Pos)    /*!< 0xFF000000 */
#define FLASH_USER_nUSER                    FLASH_USER_nUSER_Msk                /*!< User complemented option byte */

/******************  Bit definition for FLASH_Data0 register  *****************/
#define FLASH_DATA0_DATA0_Pos               (0U)                               
#define FLASH_DATA0_DATA0_Msk               (0xFFUL << FLASH_DATA0_DATA0_Pos)   /*!< 0x000000FF */
#define FLASH_DATA0_DATA0                   FLASH_DATA0_DATA0_Msk               /*!< User data storage option byte */
#define FLASH_DATA0_nDATA0_Pos              (8U)                               
#define FLASH_DATA0_nDATA0_Msk              (0xFFUL << FLASH_DATA0_nDATA0_Pos)  /*!< 0x0000FF00 */
#define FLASH_DATA0_nDATA0                  FLASH_DATA0_nDATA0_Msk              /*!< User data storage complemented option byte */

/******************  Bit definition for FLASH_Data1 register  *****************/
#define FLASH_DATA1_DATA1_Pos               (16U)                              
#define FLASH_DATA1_DATA1_Msk               (0xFFUL << FLASH_DATA1_DATA1_Pos)   /*!< 0x00FF0000 */
#define FLASH_DATA1_DATA1                   FLASH_DATA1_DATA1_Msk               /*!< User data storage option byte */
#define FLASH_DATA1_nDATA1_Pos              (24U)                              
#define FLASH_DATA1_nDATA1_Msk              (0xFFUL << FLASH_DATA1_nDATA1_Pos)  /*!< 0xFF000000 */
#define FLASH_DATA1_nDATA1                  FLASH_DATA1_nDATA1_Msk              /*!< User data storage complemented option byte */

/******************  Bit definition for FLASH_WRP0 register  ******************/
#define FLASH_WRP0_WRP0_Pos                 (0U)                               
#define FLASH_WRP0_WRP0_Msk                 (0xFFUL << FLASH_WRP0_WRP0_Pos)     /*!< 0x000000FF */
#define FLASH_WRP0_WRP0                     FLASH_WRP0_WRP0_Msk                 /*!< Flash memory write protection option bytes */
#define FLASH_WRP0_nWRP0_Pos                (8U)                               
#define FLASH_WRP0_nWRP0_Msk                (0xFFUL << FLASH_WRP0_nWRP0_Pos)    /*!< 0x0000FF00 */
#define FLASH_WRP0_nWRP0                    FLASH_WRP0_nWRP0_Msk                /*!< Flash memory write protection complemented option bytes */

/******************  Bit definition for FLASH_WRP1 register  ******************/
#define FLASH_WRP1_WRP1_Pos                 (16U)                              
#define FLASH_WRP1_WRP1_Msk                 (0xFFUL << FLASH_WRP1_WRP1_Pos)     /*!< 0x00FF0000 */
#define FLASH_WRP1_WRP1                     FLASH_WRP1_WRP1_Msk                 /*!< Flash memory write protection option bytes */
#define FLASH_WRP1_nWRP1_Pos                (24U)                              
#define FLASH_WRP1_nWRP1_Msk                (0xFFUL << FLASH_WRP1_nWRP1_Pos)    /*!< 0xFF000000 */
#define FLASH_WRP1_nWRP1                    FLASH_WRP1_nWRP1_Msk                /*!< Flash memory write protection complemented option bytes */

/******************  Bit definition for FLASH_WRP2 register  ******************/
#define FLASH_WRP2_WRP2_Pos                 (0U)                               
#define FLASH_WRP2_WRP2_Msk                 (0xFFUL << FLASH_WRP2_WRP2_Pos)     /*!< 0x000000FF */
#define FLASH_WRP2_WRP2                     FLASH_WRP2_WRP2_Msk                 /*!< Flash memory write protection option bytes */
#define FLASH_WRP2_nWRP2_Pos                (8U)                               
#define FLASH_WRP2_nWRP2_Msk                (0xFFUL << FLASH_WRP2_nWRP2_Pos)    /*!< 0x0000FF00 */
#define FLASH_WRP2_nWRP2                    FLASH_WRP2_nWRP2_Msk                /*!< Flash memory write protection complemented option bytes */

/******************  Bit definition for FLASH_WRP3 register  ******************/
#define FLASH_WRP3_WRP3_Pos                 (16U)                              
#define FLASH_WRP3_WRP3_Msk                 (0xFFUL << FLASH_WRP3_WRP3_Pos)     /*!< 0x00FF0000 */
#define FLASH_WRP3_WRP3                     FLASH_WRP3_WRP3_Msk                 /*!< Flash memory write protection option bytes */
#define FLASH_WRP3_nWRP3_Pos                (24U)                              
#define FLASH_WRP3_nWRP3_Msk                (0xFFUL << FLASH_WRP3_nWRP3_Pos)    /*!< 0xFF000000 */
#define FLASH_WRP3_nWRP3                    FLASH_WRP3_nWRP3_Msk                /*!< Flash memory write protection complemented option bytes */

/**
  * @}
  */

 /**
  * @}
  */ 


#define M8(adr)  (*((volatile uint8_t  *) (adr)))
#define M16(adr) (*((volatile uint16_t *) (adr)))
#define M32(adr) (*((volatile uint32_t *) (adr)))


#define BIT_BAND_ADDR(addr, bitnum) ((((uint32_t)(addr)) & 0xF0000000) + 0x2000000 + ((((uint32_t)(addr)) & 0xFFFFF) << 5) + ((bitnum) << 2))


#ifdef USE_STDPERIPH_DRIVER
  #include "mg32f157_conf.h"
#endif


/** @addtogroup Exported_macro
  * @{
  */

#define SET_BIT(REG, BIT)     ((REG) |= (BIT))

#define CLEAR_BIT(REG, BIT)   ((REG) &= ~(BIT))

#define READ_BIT(REG, BIT)    ((REG) & (BIT))

#define CLEAR_REG(REG)        ((REG) = (0x0))

#define WRITE_REG(REG, VAL)   ((REG) = (VAL))

#define READ_REG(REG)         ((REG))

#define MODIFY_REG(REG, CLEARMASK, SETMASK)  WRITE_REG((REG), (((READ_REG(REG)) & (~(CLEARMASK))) | (SETMASK)))

#define POSITION_VAL(VAL)     (__CLZ(__RBIT(VAL)))

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif  /* __MG32F157_H__ */

/**
  * @}
  */

/**
  * @}
  */
