/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

int main(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
  
  SystemCoreClockUpdate();

  /* Enable GPIOB, WWDG clock */
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_WWDG, ENABLE);

  /* Configure PB10 and PB11 in output pushpull mode */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOB, &GPIO_InitStructure);
  
  /* Turn off LED1 */
  GPIO_SetBits(GPIOB, GPIO_Pin_10);
  SysTick_Delay_Ms(3000);
  /* Turn on LED1 */
  GPIO_ResetBits(GPIOB, GPIO_Pin_10);
  SysTick_Delay_Ms(200);
  
  WWDG_DeInit();
  
  /* WWDG clock counter = (PCLK(48MHz)/4096)/4 = 2929.6875 Hz (~0.341 ms)  */
  WWDG_SetPrescaler(WWDG_Prescaler_4);
  
  /*
    Enable WWDG and set counter value to 127, WWDG timeout = ~0.341 ms * 64 = 21.8 ms
    In this case the refresh window is: ~0.341 ms * (127-80) = 16.027 ms < refresh window < ~0.341 ms * 64 = 21.8ms
  */
  WWDG_SetWindowValue(80);
  WWDG_Enable(127);

  /* Infinite loop */
  while (1)
  {
    SysTick_Delay_Ms(20);
    WWDG_SetCounter(127);
  }
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
