/* Includes ------------------------------------------------------------------*/
#include "stdio.h"
#include "string.h"
#include "mg32f157.h"
#include "bsp_usart1.h"
#include "drv_es8316.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
I2S_InitTypeDef  I2S_InitStructure;
GPIO_InitTypeDef GPIO_InitStructure;
NVIC_InitTypeDef NVIC_InitStructure;

extern const unsigned char wav_data[132344];
uint8_t *audio_data = 0;
uint32_t audio_data_length = 0;
uint32_t audio_index = 0;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
void I2S_Config(void);
void StartPlay(void);

/**
  * @brief  Main program
  * @param  None
  * @retval None
  */
int main(void)
{
  /* Updating the system clock */
  SystemCoreClockUpdate();

  /* Configure the interrupt priority group */
  NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);

  /* Init UART1 to 115200-8n1 for print message */
  usart1_init(96000000, 115200);

  printf("I2S Audio Play Example\r\n");

  if (es8316_init() != 0)
  {
    printf("Error! ES8316 not detected!!!\r\n");
    while (1);
  }
  
  /* I2S peripheral configuration */
  I2S_Config();

  audio_data = (uint8_t *)&wav_data[0x2C];
  audio_data_length = *((volatile uint32_t*)&wav_data[0x28]);
  audio_index = 0;

  /* Enable I2S */
  I2S_Cmd(SPI2, ENABLE);

  while (1)
  {
  }
}

/**
 * @brief  I2S peripheral configuration
 * @param  None
 * @retval None
 */
void I2S_Config(void)
{
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB| RCC_APB2Periph_GPIOC, ENABLE);
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_SPI2, ENABLE);

  /*
  I2S_WS     PB12
  I2S_CK     PB13
  I2S_SD     PB15
  I2S_MCK    PC6 
  */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12| GPIO_Pin_13| GPIO_Pin_15;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOB, &GPIO_InitStructure);

  /* I2S_MCK */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6;
  GPIO_Init(GPIOC, &GPIO_InitStructure);
  
  /* SPI2 IRQ Channel configuration */
  NVIC_InitStructure.NVIC_IRQChannel = SPI2_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
  NVIC_Init(&NVIC_InitStructure);

  /* I2S peripheral configuration */
  SPI_I2S_DeInit(SPI2);
  I2S_InitStructure.I2S_Standard = I2S_Standard_Phillips;
  I2S_InitStructure.I2S_DataFormat = I2S_DataFormat_16b;
  I2S_InitStructure.I2S_MCLKOutput = I2S_MCLKOutput_Enable;
  I2S_InitStructure.I2S_AudioFreq = I2S_AudioFreq_22k;
  I2S_InitStructure.I2S_CPOL = I2S_CPOL_Low;
  I2S_InitStructure.I2S_Mode = I2S_Mode_MasterTx;
  I2S_Init(SPI2, &I2S_InitStructure);

  /* Enable the I2S2 TxE interrupt */
  SPI_I2S_ITConfig(SPI2, SPI_I2S_IT_TXE, ENABLE);
}

void SPI2_IRQHandler(void)
{
  if(SPI_I2S_GetITStatus(SPI2, SPI_I2S_IT_TXE) != RESET)
  {
    SPI_I2S_SendData(SPI2, (audio_data[audio_index + 1] << 8)| (audio_data[audio_index]));
    audio_index += 2;
    if(audio_index >= audio_data_length)
      audio_index = 0;
  }
}

#ifdef  USE_FULL_ASSERT

/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  while (1)
  {

  }
}

#endif
