/* Includes ------------------------------------------------------------------*/
#include "mg32f157.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
GPIO_InitTypeDef GPIO_InitStructure;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**
 * @brief  Main program.
 * @param  None
 * @return None
 */
int main(void)
{
  /* Enable GPIOA and GPIOB clocks */
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA |RCC_APB2Periph_GPIOB, ENABLE);

  /* Configure PA0 as input pull-down mode */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPD;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
  
  /* Configure PA1 as input pull-up mode */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
  
  /* Configure PB10 and PB11 in output pushpull mode */
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10 | GPIO_Pin_11;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOB, &GPIO_InitStructure);
  
  /* LED1 and LED2 turn off */
  GPIO_SetBits(GPIOB, GPIO_Pin_10 |GPIO_Pin_11);

  /* Infinite loop */
  while (1)
  {
    if (GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_0) != Bit_RESET)
    {
      /* LED1 and LED2 turn on */
      GPIO_ResetBits(GPIOB, GPIO_Pin_10);
    }
    else
    {
      /* LED1 and LED2 turn off */
      GPIO_SetBits(GPIOB, GPIO_Pin_10);
    }

    if (GPIO_ReadInputDataBit(GPIOA, GPIO_Pin_1) == Bit_RESET)
    {
      /* LED1 and LED2 turn on */
      GPIO_ResetBits(GPIOB, GPIO_Pin_11);
    }
    else
    {
      /* LED1 and LED2 turn off */
      GPIO_SetBits(GPIOB, GPIO_Pin_11);
    }
  }
}

#ifdef  USE_FULL_ASSERT
/**
 * @brief  Reports the name of the source file and the source line number
 *         where the assert_param error has occurred.
 * @param  file: pointer to the source file name
 * @param  line: assert_param error line source number
 * @return None
 */
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
