#include "REG_MG82G5Exx.h"
#include "IEC60730-STL.h"

unsigned char P0_Input_Test(unsigned char value)
{
	unsigned char readbackvalue;

	P0 = value;
	
	SFRPI = 0x04;
	P0M1 = ~value;
	SFRPI = 0x00;
	P0M0 = value;			//configure test_IO to Push-Pull

	SFRPI = 0x04;			//test_IO in Push-Pull mode 7 sysclk.
	P0M1 = value;			//configure test_IO to Open-Drain with Pull-up resistor.
	SFRPI = 0x00;
	
	readbackvalue = P0;

	P0 = 0xFF;					//write default value
	SFRPI = 0x04;
	P0M1 = 0x00;				//write default value
	SFRPI = 0x00;
	P0M0 = 0x00;				//write default value

	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P0_Output_Test(unsigned char value)
{
	unsigned char readbackvalue;

	P0 = value;
	
	SFRPI = 0x04;
	P0M1 = ~value;
	SFRPI = 0x00;
	P0M0 = value;			//configure test_IO to Push-Pull

	SFRPI = 0x04;			//test_IO in Push-Pull mode 7 sysclk.
	P0M1 = value;			//configure test_IO to Open-Drain with Pull-up resistor.
	SFRPI = 0x00;
	
	readbackvalue = P0;

	P0 = 0xFF;					//write default value
	SFRPI = 0x04;
	P0M1 = 0x00;				//write default value
	SFRPI = 0x00;
	P0M0 = 0x00;				//write default value

	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P1_Input_Test(unsigned char value)
{
	unsigned char readbackvalue;

	P1 = value;
	
	P1M1 = ~value;
	P1M0 = value;			//configure test_IO to Push-Pull

	P1M1 = value;			//test_IO in Push-Pull mode 4 sysclk. configure test_IO to Open-Drain with Pull-up resistor.
	
	readbackvalue = P1;

	P1 = 0xFF;					//write default value
	P1M1 = 0x00;				//write default value
	P1M0 = 0x00;				//write default value

	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P1_Output_Test(unsigned char value)
{
	unsigned char readbackvalue;

	P1 = value;
	
	P1M1 = ~value;
	P1M0 = value;			//configure test_IO to Push-Pull

	P1M1 = value;			//test_IO in Push-Pull mode 4 sysclk. configure test_IO to Open-Drain with Pull-up resistor.
	
	readbackvalue = P1;

	P1 = 0xFF;					//write default value
	P1M1 = 0x00;				//write default value
	P1M0 = 0x00;				//write default value

	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P2_Input_Test(unsigned char value)
{
	unsigned char readbackvalue;

	P2 = value;
	
	SFRPI = 0x01;
	P2M1 = ~value;
	SFRPI = 0x00;
	P2M0 = value;			//configure test_IO to Push-Pull

	SFRPI = 0x01;			//test_IO in Push-Pull mode 7 sysclk.
	P2M1 = value;			//configure test_IO to Open-Drain with Pull-up resistor.
	SFRPI = 0x00;
	
	readbackvalue = P2;

	P2 = 0xFF;					//write default value
	SFRPI = 0x01;
	P2M1 = 0x00;				//write default value
	SFRPI = 0x00;
	P2M0 = 0x00;				//write default value

	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P2_Output_Test(unsigned char value)
{
	unsigned char readbackvalue;

	P2 = value;
	
	SFRPI = 0x01;
	P2M1 = ~value;
	SFRPI = 0x00;
	P2M0 = value;			//configure test_IO to Push-Pull

	SFRPI = 0x01;			//test_IO in Push-Pull mode 7 sysclk.
	P2M1 = value;			//configure test_IO to Open-Drain with Pull-up resistor.
	SFRPI = 0x00;
	
	readbackvalue = P2;

	P2 = 0xFF;					//write default value
	SFRPI = 0x01;
	P2M1 = 0x00;				//write default value
	SFRPI = 0x00;
	P2M0 = 0x00;				//write default value

	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P3_Input_Test(unsigned char value)
{
	unsigned char readbackvalue;

	P3 = value;

	readbackvalue = P3;
	
	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P3_Output_Test(unsigned char value)
{
	unsigned char readbackvalue;

	P3 = value;

	readbackvalue = P3;
	
	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P4_Input_Test(unsigned char value)
{
	unsigned char readbackvalue;

	value &= 0x4F;				//don't check P44(OCD_SCL), P45(OCD_SDA), P47(RST)

	P4 = value;
	
	SFRPI = 0x02;
	P4M1 = ~value;
	SFRPI = 0x00;
	P4M0 = value;				//configure test_IO to Push-Pull

	SFRPI = 0x02;				//test_IO in Push-Pull mode 7 sysclk.
	P4M1 = value;				//configure test_IO to Open-Drain with Pull-up resistor.
	SFRPI = 0x00;
	
	readbackvalue = P4;
	readbackvalue &= 0x4F;		//don't check P44(OCD_SCL), P45(OCD_SDA), P47(RST)

	P4 = 0xFF;					//write default value
	SFRPI = 0x02;
	P4M1 = 0x00;				//write default value
	SFRPI = 0x00;
	P4M0 = 0x00;				//write default value
	
	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P4_Output_Test(unsigned char value)
{
	unsigned char readbackvalue;

	value &= 0x4F;		//don't check P44(OCD_SCL), P45(OCD_SDA), P47(RST)

	P4 = value;
	
	SFRPI = 0x02;
	P4M1 = ~value;
	SFRPI = 0x00;
	P4M0 = value;			//configure test_IO to Push-Pull

	SFRPI = 0x02;			//test_IO in Push-Pull mode 7 sysclk.
	P4M1 = value;			//configure test_IO to Open-Drain with Pull-up resistor.
	SFRPI = 0x00;
	
	readbackvalue = P4;
	readbackvalue &= 0x4F;		//don't check P44(OCD_SCL), P45(OCD_SDA), P47(RST)

	P4 = 0xFF;				//write default value
	SFRPI = 0x02;
	P4M1 = 0x00;				//write default value
	SFRPI = 0x00;
	P4M0 = 0x00;				//write default value
	
	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P6_Input_Test(unsigned char value)
{
	unsigned char readbackvalue;

	value &= 0x1F;		//P6 has not P65, P66, P67.

	P6 = value;
	
	SFRPI = 0x03;
	P6M1 = ~value;
	SFRPI = 0x01;
	P6M0 = value;				//configure test_IO to Push-Pull

	SFRPI = 0x03;				//test_IO in Push-Pull mode 7 sysclk.
	P6M1 = value;				//configure test_IO to Open-Drain with Pull-up resistor.
	SFRPI = 0x00;
	
	readbackvalue = P6;
	readbackvalue &= 0x1F;		//P6 has not P65, P66, P67.

	P6 = 0xFF;					//write default value
	SFRPI = 0x03;
	P6M1 = 0x00;				//write default value
	SFRPI = 0x01;
	P6M0 = 0x00;				//write default value
	SFRPI = 0x00;
	
	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

unsigned char P6_Output_Test(unsigned char value)
{
	unsigned char readbackvalue;

	value &= 0x1F;		//P6 has not P65, P66, P67.

	P6 = value;
	
	SFRPI = 0x03;
	P6M1 = ~value;
	SFRPI = 0x01;
	P6M0 = value;				//configure test_IO to Push-Pull

	SFRPI = 0x03;				//test_IO in Push-Pull mode 7 sysclk.
	P6M1 = value;				//configure test_IO to Open-Drain with Pull-up resistor.
	SFRPI = 0x00;
	
	readbackvalue = P6;
	readbackvalue &= 0x1F;		//P6 has not P65, P66, P67.

	P6 = 0xFF;					//write default value
	SFRPI = 0x03;
	P6M1 = 0x00;				//write default value
	SFRPI = 0x01;
	P6M0 = 0x00;				//write default value
	SFRPI = 0x00;
	
	if(readbackvalue != value)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}
