#include "IEC60730-STL.h"
 
unsigned int clock_freq;
unsigned int RES_clock_freq;
#define clock_freq_lower			350		//(500 * (1 - 0.3))
#define clock_freq_upper			650		//(500 * (1 + 0.3))

bit clk_watch_interrupt_flag;


/*********************************************************************************************/
/*Module name:   Clock                                                                       */
/*Function Name: Clk_Test_Init                                                               */
/*Parameter:     None                                                                        */
/*Function description: Initialize Clock test corresponding flag and variable .              */
/*********************************************************************************************/ 

void Clk_Test_Init(void)
{
	clock_freq = 0;

	clk_watch_interrupt_flag = 0;
}

/*********************************************************************************************/
/*Module name:   Clock                                                                       */
/*Function Name: ClockTest                                                                   */
/*Parameter:     None                                                                        */
/*Function description: checks whether the number of interrupts that occurred is within the  */
/*                      predefined range. and it verifies whether interrupts are handled in  */
/*                      time.once interrupt test error is detected, program will run into an */
/*                      infinite loop.                                                       */
/*********************************************************************************************/
unsigned char ClockTest(void)
{

	if(clock_freq > clock_freq_upper || clock_freq < clock_freq_lower)
	{
		clock_freq = 0;
		clk_watch_interrupt_flag = 0;
		return TEST_FUNC_ERROR;
	}

	clock_freq = 0;
	return TEST_NORMAL;
}

