#include "REG_MG82G5Exx.h"
#include "IEC60730-STL.h"


/*********************************************************************************************/
/*Module name:   AD                                                                          */
/*Function Name: AD_Test                                                                     */
/*Parameter:     None                                                                        */
/*Function description: check if AD convert result is in expected range, a perdefine bound   */
/*                      is set before test.                                                  */
/*********************************************************************************************/
void AD_Init(void)
{
	ADCON0 = 0;//ADC block turn off
	ADCFG0 = ADRJ; //Right-Justified
	ADCON0 = ADCEN;//ADC block turn on

	ADCON0 |= ADCS; // Enable A/D Conversion
	while(!(ADCON0 & 0x10)); //wait until AD convert end
	ADCON0&=0xEF; //Clear ADCI
}	

unsigned char AD_Test(unsigned char AIN_num, unsigned int value_low, unsigned int value_upper)
{
	unsigned int result;
	ADCON0 |= AIN_num;
	for(result = 10; result != 0; result --);
	ADCON0 |= ADCS; // Enable A/D Conversion
		
	while(!(ADCON0 & 0x10)); //wait until AD convert end
	
	ADCON0 &= 0xEF; //Clear ADCI

	result = (ADCDH<<8)+ADCDL; //10-bits
	
	AD_value= result;
	
	if(result > value_upper || result < value_low)
	{
		return TEST_FUNC_ERROR;
	}
	
	return TEST_NORMAL;
}

