$NOMOD51
;------------------------------------------------------------------------------
;  This file is part of the C51 Compiler package
;  Copyright (c) 1988-2005 Keil Elektronik GmbH and Keil Software, Inc.
;  Version 8.01
;
;  *** <<< Use Configuration Wizard in Context Menu >>> ***
;------------------------------------------------------------------------------
;  STARTUP.A51:  This code is executed after processor reset.
;
;  To translate this file use A51 with the following invocation:
;
;     A51 STARTUP.A51
;
;  To link the modified STARTUP.OBJ file to your application use the following
;  Lx51 invocation:
;
;     Lx51 your object file list, STARTUP.OBJ  controls
;
;------------------------------------------------------------------------------
;
;  User-defined <h> Power-On Initialization of Memory
;
;  With the following EQU statements the initialization of memory
;  at processor reset can be defined:
;
; <o> IDATALEN: IDATA memory size <0x0-0x100>
;     <i> Note: The absolute start-address of IDATA memory is always 0
;     <i>       The IDATA space overlaps physically the DATA and BIT areas.
IDATALEN        EQU     80H
;
; <o> XDATASTART: XDATA memory start address <0x0-0xFFFF> 
;     <i> The absolute start address of XDATA memory
XDATASTART      EQU     0     
;
; <o> XDATALEN: XDATA memory size <0x0-0xFFFF> 
;     <i> The length of XDATA memory in bytes.
XDATALEN        EQU     0      
;
; <o> PDATASTART: PDATA memory start address <0x0-0xFFFF> 
;     <i> The absolute start address of PDATA memory
PDATASTART      EQU     0H
;
; <o> PDATALEN: PDATA memory size <0x0-0xFF> 
;     <i> The length of PDATA memory in bytes.
PDATALEN        EQU     0H
;
;</h>
;------------------------------------------------------------------------------
;
;<h> Reentrant Stack Initialization
;
;  The following EQU statements define the stack pointer for reentrant
;  functions and initialized it:
;
; <h> Stack Space for reentrant functions in the SMALL model.
;  <q> IBPSTACK: Enable SMALL model reentrant stack
;     <i> Stack space for reentrant functions in the SMALL model.
IBPSTACK        EQU     0       ; set to 1 if small reentrant is used.
;  <o> IBPSTACKTOP: End address of SMALL model stack <0x0-0xFF>
;     <i> Set the top of the stack to the highest location.
IBPSTACKTOP     EQU     0xFF +1     ; default 0FFH+1  
; </h>
;
; <h> Stack Space for reentrant functions in the LARGE model.      
;  <q> XBPSTACK: Enable LARGE model reentrant stack
;     <i> Stack space for reentrant functions in the LARGE model.
XBPSTACK        EQU     0       ; set to 1 if large reentrant is used.
;  <o> XBPSTACKTOP: End address of LARGE model stack <0x0-0xFFFF>
;     <i> Set the top of the stack to the highest location.
XBPSTACKTOP     EQU     0xFFFF +1   ; default 0FFFFH+1 
; </h>
;
; <h> Stack Space for reentrant functions in the COMPACT model.    
;  <q> PBPSTACK: Enable COMPACT model reentrant stack
;     <i> Stack space for reentrant functions in the COMPACT model.
PBPSTACK        EQU     0       ; set to 1 if compact reentrant is used.
;
;   <o> PBPSTACKTOP: End address of COMPACT model stack <0x0-0xFFFF>
;     <i> Set the top of the stack to the highest location.
PBPSTACKTOP     EQU     0xFF +1     ; default 0FFH+1  
; </h>
;</h>
;------------------------------------------------------------------------------
;
;  Memory Page for Using the Compact Model with 64 KByte xdata RAM
;  <e>Compact Model Page Definition
;
;  <i>Define the XDATA page used for PDATA variables. 
;  <i>PPAGE must conform with the PPAGE set in the linker invocation.
;
; Enable pdata memory page initalization
PPAGEENABLE     EQU     0       ; set to 1 if pdata object are used.
;
; <o> PPAGE number <0x0-0xFF> 
; <i> uppermost 256-byte address of the page used for PDATA variables.
PPAGE           EQU     0
;
; <o> SFR address which supplies uppermost address byte <0x0-0xFF> 
; <i> most 8051 variants use P2 as uppermost address byte
PPAGE_SFR       DATA    0A0H
;
; </e>
;------------------------------------------------------------------------------

; Standard SFR Symbols 
ACC     DATA    0E0H
B       DATA    0F0H
SP      DATA    81H
DPL     DATA    82H
DPH     DATA    83H
TH0     DATA    8CH
TL0     DATA    8AH

PC_TEST_ADDRESS1	EQU	1800h
PC_TEST_ADDRESS2	EQU	1FFFh
PC_TEST_ADDRESS3	EQU	2800h
PC_TEST_ADDRESS4	EQU	2FFFh
PC_TEST_ADDRESS5	EQU	3800h
PC_TEST_ADDRESS6	EQU	3FFFh
PC_TEST_ADDRESS7	EQU	4800h
PC_TEST_ADDRESS8	EQU	4FFFh
PC_TEST_ADDRESS9	EQU	5800h
PC_TEST_ADDRESS10	EQU	5FFFh
PC_TEST_ADDRESS11	EQU	6800h
PC_TEST_ADDRESS12	EQU	6FFFh
PC_TEST_ADDRESS13	EQU	2C00h
PC_TEST_ADDRESS14	EQU	3C00h
PC_TEST_ADDRESS15	EQU	4C00h

                NAME    ?C_STARTUP


?C_C51STARTUP   SEGMENT   CODE
?STACK          SEGMENT   IDATA

                RSEG    ?STACK
                DS      1

                EXTRN CODE (?C_START)
                PUBLIC  ?C_STARTUP

                CSEG    AT      0
?C_STARTUP:     LJMP    STARTUP1

                RSEG    ?C_C51STARTUP

STARTUP1:

		CALL	Test_Reg
		CALL	Test_RAM
		CALL	Test_PC

IF IDATALEN <> 0
                MOV     R0,#IDATALEN - 1
                CLR     A
IDATALOOP:      MOV     @R0,A
                DJNZ    R0,IDATALOOP
ENDIF

IF XDATALEN <> 0
                MOV     DPTR,#XDATASTART
                MOV     R7,#LOW (XDATALEN)
  IF (LOW (XDATALEN)) <> 0
                MOV     R6,#(HIGH (XDATALEN)) +1
  ELSE
                MOV     R6,#HIGH (XDATALEN)
  ENDIF
                CLR     A
XDATALOOP:      MOVX    @DPTR,A
                INC     DPTR
                DJNZ    R7,XDATALOOP
                DJNZ    R6,XDATALOOP
ENDIF

IF PPAGEENABLE <> 0
                MOV     PPAGE_SFR,#PPAGE
ENDIF

IF PDATALEN <> 0
                MOV     R0,#LOW (PDATASTART)
                MOV     R7,#LOW (PDATALEN)
                CLR     A
PDATALOOP:      MOVX    @R0,A
                INC     R0
                DJNZ    R7,PDATALOOP
ENDIF

IF IBPSTACK <> 0
EXTRN DATA (?C_IBP)

                MOV     ?C_IBP,#LOW IBPSTACKTOP
ENDIF

IF XBPSTACK <> 0
EXTRN DATA (?C_XBP)

                MOV     ?C_XBP,#HIGH XBPSTACKTOP
                MOV     ?C_XBP+1,#LOW XBPSTACKTOP
ENDIF

IF PBPSTACK <> 0
EXTRN DATA (?C_PBP)
                MOV     ?C_PBP,#LOW PBPSTACKTOP
ENDIF

                MOV     SP,#?STACK-1

; This code is required if you use L51_BANK.A51 with Banking Mode 4
;<h> Code Banking
; <q> Select Bank 0 for L51_BANK.A51 Mode 4
#if 0   
;     <i> Initialize bank mechanism to code bank 0 when using L51_BANK.A51 with Banking Mode 4.
EXTRN CODE (?B_SWITCH0)
                CALL    ?B_SWITCH0      ; init bank mechanism to code bank 0
#endif
;</h>
                LJMP    ?C_START

Test_Reg:
		CALL	Test_Bank_Reg
		CALL	Test_CPU_Reg
		RET


Test_Bank_Reg:
		MOV	R0, #055h
		XRL	00h, #055h
		CJNE	R0, #00h, reg_error

		MOV	R0, #0AAh
		XRL	00h, #0AAh
		CJNE	R0, #00h, reg_error

		MOV	R1, #055h
		XRL	01h, #055h
		CJNE	R1, #00h, reg_error

		MOV	R1, #0AAh
		XRL	01h, #0AAh
		CJNE	R1, #00h, reg_error

		MOV	R2, #055h
		XRL	02h, #055h
		CJNE	R2, #00h, reg_error

		MOV	R2, #0AAh
		XRL	02h, #0AAh
		CJNE	R2, #00h, reg_error

		MOV	R3, #055h
		XRL	03h, #055h
		CJNE	R3, #00h, reg_error

		MOV	R3, #0AAh
		XRL	03h, #0AAh
		CJNE	R3, #00h, reg_error

		MOV	R4, #055h
		XRL	04h, #055h
		CJNE	R4, #00h, reg_error

		MOV	R4, #0AAh
		XRL	04h, #0AAh
		CJNE	R4, #00h, reg_error

		MOV	R5, #055h
		XRL	05h, #055h
		CJNE	R5, #00h, reg_error

		MOV	R5, #0AAh
		XRL	05h, #0AAh
		CJNE	R5, #00h, reg_error

		MOV	R6, #055h
		XRL	06h, #055h
		CJNE	R6, #00h, reg_error

		MOV	R6, #0AAh
		XRL	06h, #0AAh
		CJNE	R6, #00h, reg_error

		MOV	R7, #055h
		XRL	07h, #055h
		CJNE	R7, #00h, reg_error

		MOV	R7, #0AAh
		XRL	07h, #0AAh
		CJNE	R7, #00h, reg_error

		RET

  reg_error:
		JMP	$


Test_CPU_Reg:
		MOV	A, #055h
		XRL	A, #055h
		JNZ	reg_error

		MOV	A, #0AAh
		XRL	A, #0AAh
		JNZ	reg_error

		MOV	B, #055h
		MOV	A, #055h
		XRL	A, B
		JNZ	reg_error

		MOV	B, #0AAh
		XRL	A, #0AAh
		XRL	A, B
		JNZ	reg_error

		MOV	DPH, #055h
		MOV	A, #055h
		XRL	A, DPH
		JNZ	reg_error

		MOV	DPH, #0AAh
		XRL	A, #0AAh
		XRL	A, DPH
		JNZ	reg_error

		MOV	DPL, #055h
		MOV	A, #055h
		XRL	A, DPL
		JNZ	reg_error

		MOV	DPL, #0AAh
		XRL	A, #0AAh
		XRL	A, DPL
		JNZ	reg_error

		MOV	B, SP
		MOV	SP, #055h
		MOV	A, #055h
		XRL	A, SP
		JNZ	reg_error

		MOV	SP, #0AAh
		XRL	A, #0AAh
		XRL	A, SP
		JNZ	reg_error
		MOV	SP, B

		RET


Test_RAM:
		CALL	Test_Variable_Memory	;(RAM)
		RET

Test_Variable_Memory:	;(RAM)
		MOV	DPTR, #00h		;test on-chip external ram

  Test_Variable_Memory_xdata_Loop:
		MOV	A, #055h
		MOVX	@DPTR, A
		MOVX	A, @DPTR
		XRL	A, #055h
		JNZ	ram_error

		MOV	A, #0AAh
		MOVX	@DPTR, A
		MOVX	A, @DPTR
		XRL	A, #0AAh
		JNZ	ram_error

		CLR	A
		MOVX	@DPTR, A
		MOVX	A, @DPTR
		XRL	A, #000h
		JNZ	ram_error
		
		INC	DPTR
		MOV	A, DPH
		CJNE	A, #07h, Test_Variable_Memory_xdata_Loop

		MOV	R0, #0FFh
		MOV	R1, #0F0h
  Test_Variable_Memory_idata_Loop:
		MOV	@R0, #055h
		MOV	A, @R0
		XRL	A, #055h
		JNZ	ram_error

		MOV	@R0, #0AAh
		MOV	A, @R0
		XRL	A, #0AAh
		JNZ	ram_error

		MOV	@R0, #000h
		MOV	A, @R0
		XRL	A, #000h
		JNZ	ram_error
		
		DEC	R0
		DJNZ	R1, Test_Variable_Memory_idata_Loop

		RET

  ram_error:
		JMP	$


Test_PC:

		CALL	PC_TEST1
		MOV	DPTR, #PC_TEST_ADDRESS1
		CALL	Compare_PC

		CALL	PC_TEST2
		MOV	DPTR, #PC_TEST_ADDRESS2
		CALL	Compare_PC

		CALL	PC_TEST3
		MOV	DPTR, #PC_TEST_ADDRESS3
		CALL	Compare_PC

		CALL	PC_TEST4
		MOV	DPTR, #PC_TEST_ADDRESS4
		CALL	Compare_PC

		CALL	PC_TEST5
		MOV	DPTR, #PC_TEST_ADDRESS5
		CALL	Compare_PC

		CALL	PC_TEST6
		MOV	DPTR, #PC_TEST_ADDRESS6
		CALL	Compare_PC

		CALL	PC_TEST7
		MOV	DPTR, #PC_TEST_ADDRESS7
		CALL	Compare_PC

		CALL	PC_TEST8
		MOV	DPTR, #PC_TEST_ADDRESS8
		CALL	Compare_PC

		CALL	PC_TEST9
		MOV	DPTR, #PC_TEST_ADDRESS9
		CALL	Compare_PC

		CALL	PC_TEST10
		MOV	DPTR, #PC_TEST_ADDRESS10
		CALL	Compare_PC

		CALL	PC_TEST11
		MOV	DPTR, #PC_TEST_ADDRESS11
		CALL	Compare_PC

		CALL	PC_TEST12
		MOV	DPTR, #PC_TEST_ADDRESS12
		CALL	Compare_PC

		CALL	PC_TEST13
		MOV	DPTR, #PC_TEST_ADDRESS13
		CALL	Compare_PC

		CALL	PC_TEST14
		MOV	DPTR, #PC_TEST_ADDRESS14
		CALL	Compare_PC

		CALL	PC_TEST15
		MOV	DPTR, #PC_TEST_ADDRESS15
		CALL	Compare_PC
		
		RET

Compare_PC:
		MOV	A, DPH
		CJNE	A, TH0, pc_error
		MOV	A, DPL
		CJNE	A, TL0, pc_error
		RET

  pc_error:
		JMP	$


	CSEG	AT	PC_TEST_ADDRESS1
PC_TEST1:
		MOV	DPTR, #PC_TEST1
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS2
PC_TEST2:
		MOV	DPTR, #PC_TEST2
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS3
PC_TEST3:
		MOV	DPTR, #PC_TEST3
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS4
PC_TEST4:
		MOV	DPTR, #PC_TEST4
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS5
PC_TEST5:
		MOV	DPTR, #PC_TEST5
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS6
PC_TEST6:
		MOV	DPTR, #PC_TEST6
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS7
PC_TEST7:
		MOV	DPTR, #PC_TEST7
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS8
PC_TEST8:
		MOV	DPTR, #PC_TEST8
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS9
PC_TEST9:
		MOV	DPTR, #PC_TEST9
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS10
PC_TEST10:
		MOV	DPTR, #PC_TEST10
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS11
PC_TEST11:
		MOV	DPTR, #PC_TEST11
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS12
PC_TEST12:
		MOV	DPTR, #PC_TEST12
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS13
PC_TEST13:
		MOV	DPTR, #PC_TEST13
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS14
PC_TEST14:
		MOV	DPTR, #PC_TEST14
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

	CSEG	AT	PC_TEST_ADDRESS15
PC_TEST15:
		MOV	DPTR, #PC_TEST15
		MOV	TH0, DPH
		MOV	TL0, DPL
		RET

                END
