

 #if 1
 
 #ifndef _MG32x02z_USBD_COM_API_H__
 #define _MG32x02z_USBD_COM_API_H__
 
 
// <<< Use Configuration Wizard in Context Menu >>>
//<o0> Bridge Device is  <0=> UART

#define API_COM_BRIDGE_DEVICE        0 

#define API_COM_BRIDGE_DEVICE_UART   0


// <<< end of Configuration section >>>   
 
 
 
#include "MG32x02z.h" 

 
 
 /**
 * @name	============== CDC (Class Definitions for Communications Devices) protocal Relationship ==============
 *   		
 */ 
///@{     
    
//--------------------------------------------------------------------------------             
//Communications Class Subclass Codes                            
//    - Subclass codes for the Communications interface class

#define CDC_RESERVED                                0x00
#define CDC_DIRECT_LINE_CONTROL_MODEL               0x01        /*!< Reference USBPSTN1.2.*/
#define CDC_ABSTRACT_CONTROL_MODEL                  0x02        /*!< Reference USBPSTN1.2.*/
#define CDC_TELEPHONE_CONTROL_MODEL                 0x03        /*!< Reference USBPSTN1.2.*/
#define CDC_MULTI_CHANNEL_CONTROL_MODEL             0x04        /*!< Reference USBPSTN1.2.*/
#define CDC_CAPI_CONTROL_MODEL                      0x05        /*!< Reference USBISDN1.2.*/
#define CDC_ETHERNET_NETWORKING_CONTROL_MODEL       0x06        /*!< Reference USBISDN1.2.*/
#define CDC_ATM_NETWORKING_CONTROL_MODEL            0x07        /*!< Reference USBECM1.2.*/
#define CDC_WIRELESS_HANDSET_CONTROL_MODEL          0x08        /*!< Reference USBATM1.2.*/
#define CDC_DEVICE_MANAGEMENT                       0x09        /*!< Reference USBWMC1.1.*/
#define CDC_MOBILE_DIRECT_LINE_MODEL                0x0A        /*!< Reference USBWMC1.1.*/
#define CDC_OBEX                                    0x0B        /*!< Reference USBWMC1.1.*/
#define CDC_ETHERNET_EMULATION_MODEL                0x0C        /*!< Reference USBEEM1.0.*/
#define CDC_NETWORK_CONTROL_MODEL                   0x0D        /*!< Reference USBNCM1.0.*/
    
//---------------------------------------------------
//Communication Interface Class Control Protocol Codes 
#define USBSPEC                                     0x00        /*!< No class specific protocol required .*/
#define CDC_AT_ITU_T_V_250                          0x01        /*!< AT Commands V.250 etc.*/
#define CDC_AT_PCCA_101                             0x02        /*!< AT Commands defined by PCCA-101.*/
#define CDC_AT_PCCA_101_AnnexO                      0x03        /*!< AT Commands defined by PCCA-101 & Annex O.*/
#define CDC_AT_GSM_7_07                             0x04        /*!< AT Commands defined by GSM 07.07.*/
#define CDC_AT_3GPP_27_07                           0x05        /*!< AT Commands defined by 3GPP 27.007.*/
#define CDC_AT_C_S0017_0                            0x06        /*!< AT Commands defined by TIA for CDMA.*/
#define CDC_USB_EEM                                 0x07        /*!< Ethernet Emulation Model*/
#define CDC_ExternalProtocol                        0xFE        /*!< External Protocol : Commands defiend by Command Set Functional Descriptor*/
#define CDC_VENDOR_SPEC                             0xFF        /*!< Vendor-specific*/
    
    
    
//-------------------------------------------------------------------------------- 
//Data Interface Class Code      
#define bInterfaceClass_CDC_DATA                    0x0A       
    
    
    
//-------------------------------------------------------------------------------- 
//Data Interface Class Protocol Codes

#define CDC_DATA_USBSPEC                            0x00         /*!< No class specific protocol required.*/
#define CDC_DATA_USBNCM1_0                          0x01         /*!< Network Transfer Block.*/
#define CDC_DATA_I_430                              0x30         /*!< Physical interface protocol for ISDN BRI.*/
#define CDC_DATA_ISO_IEC_3309_1993                  0x31         /*!< HDLC.*/
#define CDC_DATA_NONE_TRANSPARENT                   0x32         /*!< Transparent.*/
#define CDC_DATA_Q_921M                             0x50         /*!< Management protocol for Q.921 data link protocol.*/
#define CDC_DATA_Q_921                              0x51         /*!< Data link protocol for Q.931.*/
#define CDC_DATA_Q_921TM                            0x52         /*!< TEI-multiplexor for Q.921 data link protocol.*/
#define CDC_DATA_V_42BIS                            0x90         /*!< Data compression procedures.*/
#define CDC_DATA_Q_931_EURO_ISDN                    0x91         /*!< Euro-ISDN protocol control.*/
#define CDC_DATA_V_120                              0x92         /*!< V.24 rate adaptation to ISDN.*/
#define CDC_DATA_CAPI2_0                            0x93         /*!< CAPI Commands.*/
#define CDC_DATA_NONE_HOST_BASED_DRIVER             0xFD         
#define CDC_DATA_CDCSPEC                            0xFE         /*!< The protocol(s) are described using a Protocol Unit Functional Descriptors on Communications Class Interface.*/
#define CDC_DATA_VENDOR_SPEC                        0xFF         /*!< Vendor-specific.*/
    

//----------------------------------------------------------------------------------
//bDescriptor SubType in Communications Class Functional Descriptor
//   - The bDescriptor Type values are the same ones defined in the USB Device Class
//     Definition for Audio Devices Specification.
#define HEADER_FUNCTIONAL_DESCRIPTOR                                                  0x00     /*!< Header Function Descriptor , which marks the beginning of the concatenated set of  
                                                                                                    functional descriptos for the interface.*/
#define CALL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR                                         0x01     /*!< Call Management Functional Descriptor.*/
#define ABSTRACT_CONTROL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR                             0x02     /*!< Abstract Control Management Functional Descriptor.*/
#define DIRECT_LINE_MANAGEMENT_FUNCITIONAL_DESCRIPTOR                                 0x03     /*!< Direct Line Management Functional Descriptor.*/
#define TELEPHONE_RINGER_FUNCTIONAL_DESCRIPTOR                                        0x04     /*!< Telephone Ringer Functional Descriptor.*/
#define TELEPHONE_CALL_LINE_STATE_REPORTING_CAPABILITIES_FUNCITIONAL_DESCRIPTOR       0x05     /*!< Telephone Call and Line State Reporting Capabilities Functional Descriptor.*/
#define UNION_FUNCTIONAL_DESCRIPTOR                                                   0x06     /*!< Uion Functional Descriptor.*/
#define COUNTRY_SELECTION_FUNCTIONAL_DESCRIPTOR                                       0x07     /*!< Country Selection Functional Descriptor.*/
#define TELEPHONE_OPERATIONAL_MODES_FUNCTIONAL_DESCRIPTOR                             0x08     /*!< Telephone Operational Modes Functional Descriptor.*/
#define USB_TERMINAL_FUNCTIONAL_DESCRIPTOR                                            0x09     /*!< USB Terminal Functional Descriptor.*/
#define NETWORK_CHANNEL_TERMINAL_DESCRIPTOR                                           0x0A     /*!< Network Channel Terminal Descriptor.*/
#define PROTOCOL_UNIT_FUNCTIONAL_DESCRIPTOR                                           0x0B     /*!< Protocol Unit Functional Descriptor.*/
#define EXTENSION_UNIT_FUNCTIONAL_DESCRIPTOR                                          0x0C     /*!< Extension Unit Functional Descriptor.*/
#define MULTI_CHANNEL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR                                0x0D     /*!< Multi-Channel Management Functional Descriptor.*/
#define CAPI_CONTROL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR                                 0x0E     /*!< CAPI Control Management Functional Descriptor.*/
#define ETHERNET_NETWORKING_FUNCTIONAL_DESCRIPTOR                                     0x0F     /*!< Ethernet Networking Functional Descriptor.*/
#define ATM_NETWORKING_FUNCTIONAL_DESCRIPTOR                                          0x10     /*!< ATM Networking Functional Descriptor.*/
#define WIRELESS_HANDSET_CONTROL_MODEL_FUNCTIONAL_DESCRIPTOR                          0x11     /*!< Wireless Handset Control Model Functional Descriptor.*/    
#define MOBILE_DIRECT_LINE_MODEL_FUNCTIONAL_DESCRIPTOR                                0x12     /*!< Mobile Direct Line Model Functional Descriptor.*/
#define MDLM_DETAIL_FUNCTIONAL_DESCRIPTOR                                             0x13     /*!< MDLM Detail Functional Descriptor.*/
#define DEVICE_MANAGEMENT_MODEL_FUNCTIONAL_DESCRIPTOR                                 0x14     /*!< Device Management Model Functional Descriptor.*/
#define OBEX_FUNCTIONAL_DESCRIPTOR                                                    0x15     /*!< OBEX Functional Descriptor*/
#define COMMAND_SET_FUNCTIONAL_DESCRIPTOR                                             0x16     /*!< Command Set Functional Descriptor.*/
#define COMMAND_SET_DETAIL_FUNCTIONAL__DESCRIPTOR                                     0x17     /*!< Command Set Detail Functional Descriptor.*/
#define TELEPHONE_CONTROL_MODEL_FUNCTIONAL_DESCRIPTOR                                 0x18     /*!< Teltphone Control Model Functional Descriptor.*/
#define OBEX_SERVICE_IDENTIFIER_FUNCTIONAL_DESCRIPTOR                                 0x19     /*!< OBEX Service Identifier Functional Descriptor.*/
#define NCM_FUNCTIONAL_DESCRIPTOR                                                     0x1A     /*!< NVM Functional Descriptor.*/


//----------------------------------------------------------------------------------
//Class-Specific Request Codes.
#define SEND_ENCAPSULATED_COMMAND                     0x00                 /*!< Reference CDC120 6.2.1 */
#define GET_ENCAPSULATED_RESPONSE                     0x01                 /*!< Reference CDC120 6.2.1 */
#define SET_COMM_FEATURE                              0x02                 /*!< Reference USBPSTN1.2   */
#define GET_COMM_FEATURE                              0x03                 /*!< Reference USBPSTN1.2   */
#define CLEAR_COMM_FEATURE                            0x04                 /*!< Reference USBPSTN1.2   */
#define SET_AUX_LINE_STATE                            0x10                 /*!< Reference USBPSTN1.2   */
#define SET_HOOK_STATE                                0x11                 /*!< Reference USBPSTN1.2   */
#define PULSE_SETUP                                   0x12                 /*!< Reference USBPSTN1.2   */
#define SEND_PULSE                                    0x13                 /*!< Reference USBPSTN1.2   */
#define SET_PULSE_TIME                                0x14                 /*!< Reference USBPSTN1.2   */
#define PING_AUX_JACK                                 0x15                 /*!< Reference USBPSTN1.2   */
#define SET_LINE_CODING                               0x20                 /*!< Reference USBPSTN1.2   */
#define GET_LINE_CODING                               0x21                 /*!< Reference USBPSTN1.2   */
#define SET_CONTROL_LINE_STATE                        0x22                 /*!< Reference USBPSTN1.2   */
#define SET_BREAK                                     0x23                 /*!< Reference USBPSTN1.2   */
#define SET_RINGER_PARMS                              0x30                 /*!< Reference USBPSTN1.2   */
#define GET_RINGER_PARMS                              0x31                 /*!< Reference USBPSTN1.2   */
#define SET_OPERATION_PARMS                           0x32                 /*!< Reference USBPSTN1.2   */
#define GET_OPERATION_PARMS                           0x33                 /*!< Reference USBPSTN1.2   */
#define SET_LINE_PARMS                                0x34                 /*!< Reference USBPSTN1.2   */
#define GET_LINE_PARMS                                0x35                 /*!< Reference USBPSTN1.2   */
#define DIAL_DIGITS                                   0x36                 /*!< Reference USBPSTN1.2   */
#define SET_UNIT_PARAMETER                            0x37                 /*!< Reference USBISDN1.2   */
#define GET_UNIT_PARAMETER                            0x38                 /*!< Reference USBISDN1.2   */
#define CLEAR_UNIT_PARAMETER                          0x39                 /*!< Reference USBISDN1.2   */
#define GET_PROFILE                                   0x3A                 /*!< Reference USBISDN1.2   */
#define SET_ETHERNET_MULTICAST_FILTERS                0x40                 /*!< Reference USBECM1.2    */
#define SET_ETHERNET_POWER_MANAGEMENT_PATTERN_FILTER  0x41                 /*!< Reference USBECM1.2    */
#define GET_ETHERNET_POWER_MANAGEMENT_PATTERN_FILTER  0x42                 /*!< Reference USBECM1.2    */
#define SET_ETHERNET_PACKET_FILTER                    0x43                 /*!< Reference USBECM1.2    */
#define GET_ETHERNET_STATISTIC                        0x44                 /*!< Reference USBECM1.2    */
#define SET_ATM_DATA_FORMAT                           0x50                 /*!< Reference USBATM1.2    */
#define GET_ATM_DEVICE_STATISTICS                     0x51                 /*!< Reference USBATM1.2    */
#define SET_ATM_DEFAULT_VC                            0x52                 /*!< Reference USBATM1.2    */
#define GET_ATM_VC_STATISTICS                         0x53                 /*!< Reference USBATM1.2    */
#define GET_NTB_PARAMETERS                            0x80                 /*!< Reference USBNCM1.0    */
#define GET_NET_ADDRESS                               0x81                 /*!< Reference USBNCM1.0    */
#define SET_NET_ADDRESS                               0x82                 /*!< Reference USBNCM1.0    */
#define GET_NTB_FORMAT                                0x83                 /*!< Reference USBNCM1.0    */
#define SET_NTB_FORMAT                                0x84                 /*!< Reference USBNCM1.0    */
#define GET_NTB_INPUT_SIZE                            0x85                 /*!< Reference USBNCM1.0    */
#define SET_NTB_INPUT_SIZE                            0x86                 /*!< Reference USBNCM1.0    */
#define GET_MAX_DATAGRAM_SIZE                         0x87                 /*!< Reference USBNCM1.0    */
#define SET_MAX_DATAGRAM_SIZE                         0x88                 /*!< Reference USBNCM1.0    */
#define GET_CRC_MODE                                  0x89                 /*!< Reference USBNCM1.0    */
#define SET_CRC_MODE                                  0x8A                 /*!< Reference USBNCM1.0    */
    
    
//----------------------------------------------------------------------------------    
// Class-Specific Notification Codes for PSTN subclasses.
#define PSTN_NETWORK_CONNECTION                       0x00                 
#define PSTN_RESPONSE_AVAILABLE                       0x01                 /*!< This notification allows the device to notify the host a response is available.*/
#define PSTN_AUX_JACK_HOOK_STATE                      0x08                 /*!< This notification indicates the loop has changed on the auxiliary phone interface of the USB device.*/
#define PSTN_RING_DETECT                              0x09                 /*!< This notification indicates ring voltage on the POTS line interface of the USB device.*/
#define PSTN_SERIAL_STATE                             0x20                 /*!< This notification sends asynchronous notification of UART status.*/
#define PSTN_CALL_STATE_CHANGE                        0x28                 /*!< This notification identifies that a change has occurred to the state of a call on the line corresponding to
                                                                                the interface or union for the line*/
#define PSTN_LINE_STATE_CHANGE                        0x23                 /*!< This notification identifies that a change has occurred to the state of the line corresponding to the interface or 
                                                                                master interface of a union sending the notification message.*/

    
    
///@}  
 
 
/**
 * @name	============== Line Coding Relationship ==============
 *   		
 */ 
///@{ 
 

#define COM_STOPBIT_1_0           0                                /*!< 1   Stop bit  .*/
#define COM_STOPBIT_1_5           1                                /*!< 1.5 Stop bits .*/
#define COM_STOPBIT_2_0           2                                /*!< 2   Stop bits .*/
                                                                   
#define COM_PARITY_None           0                                /*!< Parity = None  .*/
#define COM_PARITY_Odd            1                                /*!< Parity = Odd   .*/
#define COM_PARITY_Even           2                                /*!< Parity = Even  .*/
#define COM_PARITY_Mark           3                                /*!< Parity = Mark  .*/
#define COM_PARITY_Space          4                                /*!< Parity = Space .*/


#define COM_SUCCESS               0
#define COM_FAILURE               1


/** 
 * @struct	COM_LineCoding_TypeDef
 * @brief	character formatting properties.
 */




void      API_COM_GetLineCoding(uint8_t* gLineCodingBuf);
uint32_t  API_COM_SetLineCoding(uint8_t* sLineCodingBuf);


/**
 * @name	============== Line State Relationship ==============
 *   		
 */ 
///@{


/** 
 * @struct	COM_LineState_TypeDef
 * @brief	Control Signal Bitmap struct.
 */



void API_COM_SetControlLineState(uint8_t* sControlLineStateBuf);

/**
 * @name	============== Break Relationship ==============
 *   		
 */ 
///@{


/** 
 * @struct	COM_SendBreak_TypeDef
 * @brief	SendBreak request. 
 */


void API_COM_SendBreak(uint8_t* SendBreakBuf); 

/**
 * @name	========== PSTN Subclass Specific Notifications (SerialState)==============
 *   		
 */ 
///@{
#if API_COM_BRIDGE_DEVICE == API_COM_BRIDGE_DEVICE_UART


#define PSTN_URT_bRxCarrier                 0x01                       /*!< State of receiver carrier detection mechanism of device.
                                                                            This signal corresponds to V.24 signal 109 and RS-232 signal DCD.*/
#define PSTN_URT_bTxCarrier                 0x02                       /*!< State of transmission carrier.
                                                                            This signal corresponds to V.24 signal 106 and RS-232 signal DSR.*/
#define PSTN_URT_bBrek                      0x04                       /*!< State of break detection mechanism of the device.*/
#define PSTN_URT_bRingSignal                0x08                       /*!< State of ring signal detection of the device.*/
#define PSTN_URT_bFraming                   0x10                       /*!< A framing error has occurred.*/
#define PSTN_URT_bParity                    0x20                       /*!< A parity error has occurred.*/
#define PSTN_URT_bOverRun                   0x40                       /*!< Received data has been discarded due to overrun in the device.*/

#endif

//@}


/**
 * @name	============== COM Control Relationship ==============
 *   		
 */ 
///@{

/** 
 * @struct	COM_TypeDef
 * @brief	COM Control Relationship Parameter.
 */





#endif







#endif


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/*
  USBSerial_API.c

  Copyright (c) 2023, Magawin
  Original code (pre-library): Copyright (c) 2011, Peter Barrett

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include <Arduino.h>


#include "USBSerial_def.h"



typedef struct
{
      uint32_t    USBStatus;                         /*!< USB software status.*/
      uint8_t     RxTx[EP0_PACKET_SIZE];             /*!< For Rx/Tx FIFO.*/
  __I uint8_t     *Buf;                              /*!< USB Tx Buffer Address , Maybe addressing to ROM address.*/  
      uint32_t    All;                               /*!< Transmit All size in byte.*/
      uint8_t     DataStage;                         /*!< Index the next transaction are DATASTAGE or STATUSSTAGE.*/
      uint8_t     Tmp;					             /*!< Store some data for Next transaction( SET_ADDRESS/SET_CONFIGURATION/..).*/
      uint8_t     ConfigurationValue;                /*!< Host set configuration value.*/   
#if MG_USB_LPM_EN == 1
      uint8_t     LPM_BLE;                           /*!< LPM BLE setting from Host.*/
#else
      uint8_t     __Padding; 
#endif
}USBCTR_TypeDef;   

//extern USBCTR_TypeDef Ep0;   



#if !defined(USBCON)   // || !defined(USBD_USE_HID_COMPOSITE)

#error "USB HID not enabled! Select 'HID' in the 'Tools->USB interface' menu."

#else

//================================================================================


#include "MG32x02z.h"
#include "MG32x02z_USB_DRV.h"
#include "MG32x02z_USB_Init.h"
#include "MG32x02z_USBD_API.h"
#include "MG32x02z_USBD_USBSerialDescriptor.h"

#include "USBSerial_API.h"
//#include "MG32x02z_GPIO_DRV.h"

#include "USBSerial.h"

#ifdef __cplusplus

#include "Stream.h"
#include "chip.h"


#endif  //#ifdef __cplusplus




COM_TypeDef COM;  

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static const uint8_t  EPn_ID_Table[8]          = {                    0 , MG_USB_EP1_ADDRESS    , MG_USB_EP2_ADDRESS    , MG_USB_EP3_ADDRESS    , MG_USB_EP4_ADDRESS    , MG_USB_EP5_ADDRESS    , MG_USB_EP6_ADDRESS    , MG_USB_EP7_ADDRESS    };
static const uint16_t EPn_RXSIZE_TABLE[8]      = {MG_USB_EP0_SRAM_RXSIZE, MG_USB_EP1_SRAM_RXSIZE, MG_USB_EP2_SRAM_RXSIZE, MG_USB_EP3_SRAM_RXSIZE, MG_USB_EP4_SRAM_RXSIZE, MG_USB_EP5_SRAM_RXSIZE, MG_USB_EP6_SRAM_RXSIZE, MG_USB_EP7_SRAM_RXSIZE};
static const uint16_t EPn_RXSRAM_TABLE[8]      = {USB_EP0_SRAM_RXADR    , USB_EP1_SRAM_RXADR    , USB_EP2_SRAM_RXADR    , USB_EP3_SRAM_RXADR    , USB_EP4_SRAM_RXADR    , USB_EP5_SRAM_RXADR    , USB_EP6_SRAM_RXADR    , USB_EP7_SRAM_RXADR}   ;
static const uint16_t EPn_TXSRAM_TABLE[8]      = {USB_EP0_SRAM_TXADR    , USB_EP1_SRAM_TXADR    , USB_EP2_SRAM_TXADR    , USB_EP3_SRAM_TXADR    , USB_EP4_SRAM_TXADR    , USB_EP5_SRAM_TXADR    , USB_EP6_SRAM_TXADR    , USB_EP7_SRAM_TXADR}   ;
static const uint8_t  EPn_InitaStatus_TABLE[8] = {MG_USB_EP0_STATUS     , MG_USB_EP1_STATUS     , MG_USB_EP2_STATUS     , MG_USB_EP3_STATUS     , MG_USB_EP4_STATUS     , MG_USB_EP5_STATUS     , MG_USB_EP6_STATUS     , MG_USB_EP7_STATUS     };

static uint32_t USB_EP_TABLE[2][8] = {
                                         {USB_EP0_Base , USB_EP1_Base , USB_EP2_Base , USB_EP3_Base , USB_EP4_Base , USB_EP5_Base , USB_EP6_Base , USB_EP7_Base},
                                         {USB_IT_EP0   , USB_IT_EP1   , USB_IT_EP2   , USB_IT_EP3   , USB_IT_EP4   , USB_IT_EP5   , USB_IT_EP6   , USB_IT_EP7}  
                                     };
                                     
USBCTR_TypeDef Ep0;
                                     
/* Private function prototypes -----------------------------------------------*/
void API_USBSerial_IRQ( void );
void API_USBSerial_Inital(void);
static void API_USBSerial_Endpoint0_ReadData( void );
static void API_USBSerial_Get_Status( void );
static void API_USBSerial_ClearFeature( void );
static void API_USBSerial_SetFeature( void ); 
static void API_USBSerial_GetDescriptor( void );
static void API_USBSerial_SetConfiguration( void );
static void API_USBSerial_SetInterface( void );
static void API_USBSerial_GetInterface( void );
static void API_USBSerial_ControlRead( void );
static void API_USBSerial_StandardRequest( void );
static void API_USBSerial_ClassRequest( void );                                     
static void API_USBSerial_ControlWrite( void );
static void API_USBSerial_Event(void);

void  USBSerial_SetAPI()
{
    g_UsbFun.pfUsbInit          = API_USBSerial_Inital;
    g_UsbFun.pfEP0ReadData      = API_USBSerial_Endpoint0_ReadData;
    g_UsbFun.pfGetStatus        = API_USBSerial_Get_Status;
    g_UsbFun.pfClearFeature     = API_USBSerial_ClearFeature;
    g_UsbFun.pfSetFeature       = API_USBSerial_SetFeature;
    g_UsbFun.pfGetDescriptor    = API_USBSerial_GetDescriptor;
    g_UsbFun.pfSetConfiguration = API_USBSerial_SetConfiguration;
    g_UsbFun.pfSetInterface     = API_USBSerial_SetInterface;
    g_UsbFun.pfGetInterface     = API_USBSerial_GetInterface;
    g_UsbFun.pfControlRead      = API_USBSerial_ControlRead;
    g_UsbFun.pfStandardRequest  = API_USBSerial_StandardRequest;
    g_UsbFun.pfClassRequest     = API_USBSerial_ClassRequest;
    g_UsbFun.pfControlWrite     = API_USBSerial_ControlWrite;
    
    g_UsbFun.pfStateEvent       = API_USBSerial_Event;
        
    g_UsbFun.pfIRQHandler       = API_USBSerial_IRQ;
}

                                     
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/                                     
/* External vairables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	    USB function inital.
 * @details         
 * @exception   No
 * @note                    
 *******************************************************************************
 */  
void API_USBSerial_Inital(void)
{
    USB_EP_Struct*  USB_EPX;
    uint8_t         USB_InitTmp;
    
    USB_Cmd(ENABLE);
    
    NVIC_DisableIRQ(USB_IRQn);
    USB_ITEA_Cmd(DISABLE);
 
    //=====================================================
    //EP0 config
    
    USB_TriggerEndpointRst(USB_EP0 , EP_RST_TX_RX);
    
    USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);  
    USB_EndpintIT_Config( USB_EP0 , (USB_EP_IE_TXDONE | USB_EP_IE_RXDONE) , ENABLE);
    

    USB_SetEndpointRXDataAddress(USB_EP0, EPn_RXSRAM_TABLE[0]);             
    USB_SetEndpointTXDataAddress(USB_EP0, EPn_TXSRAM_TABLE[0]);                
    
    USB_SetEndpointRXBlock(USB_EP0,64);
    
    //====================================================
    //EP1 ~ EP7 config
    for(USB_InitTmp=1;USB_InitTmp<8;USB_InitTmp++)
    {
        USB_EPX = ((USB_EP_Struct*) USB_EP_TABLE[0][USB_InitTmp]); 
        
        //-----------------------------------------------------------------
        //Defeault Inital 
        USB_TriggerEndpointRst(USB_EPX , EP_RST_TX_RX);
        USB_SetEndpointStatus(USB_EPX, EP_RX_DISABLE_TX_DISABLE);
        USB_EndpintIT_Config( USB_EPX , USB_EP_IE_ALL, DISABLE); 

        //-----------------------------------------------------------------
        //Set buffer relationship control.
        USB_SetEndpointRXDataAddress(USB_EPX, EPn_RXSRAM_TABLE[USB_InitTmp]);              /*!<Set SRAM address that USB_EPX_RX start save address. */
        USB_SetEndpointTXDataAddress(USB_EPX, EPn_TXSRAM_TABLE[USB_InitTmp]);              /*!<Set SRAM address that USB_EPX_TX start send address..*/

        if(EPn_RXSIZE_TABLE[USB_InitTmp] != 0)        
        {
            USB_SetEndpointRXBlock(USB_EPX,EPn_RXSIZE_TABLE[USB_InitTmp]);  
        }
        
        if(EPn_InitaStatus_TABLE[USB_InitTmp] & MG_USB_DBUF_MSK)
        {
            USB_EndpointDoubleBufferMode_Cmd(USB_EPX,ENABLE);
        }
        else
        {
            USB_EndpointDoubleBufferMode_Cmd(USB_EPX,DISABLE);
        }
        //-----------------------------------------------------------------
        //Set Endpoint Address
        USB_SetEndpointAddress(USB_EPX, EPn_ID_Table[USB_InitTmp] ); 
        
        //-----------------------------------------------------------------
        //Set Endpoint Mode.
        switch(( EPn_InitaStatus_TABLE[USB_InitTmp] & MG_USB_MODE_MASK))
        {
					case MG_USB_MODE_RX_ISO_TX_BKINT:
						 USB_EndpointMode_Select(USB_EPX , EP_RX_ISO_TX_BKINT);
						 break;
					case MG_USB_MODE_RX_BKINT_TX_ISO:
						 USB_EndpointMode_Select(USB_EPX , EP_RX_BKINT_TX_ISO);
						 break;
					case MG_USB_MODE_RX_TX_ISO:
						 USB_EndpointMode_Select(USB_EPX , EP_RX_ISO_TX_ISO);
						 break;
					case MG_USB_MODE_RX_TX_BKINT:
					default:
						 USB_EndpointMode_Select(USB_EPX , EP_RX_BKINT_TX_BKINT);
						 break;
        }
    }
    //===================================================
    //USB LPM Receive Disable
    USB_LPMhandshakeMode_Select(USB_LPM_DISABLE);
    //===================================================
    //USB Interrupt Config
    #if MG_USB_LPM_EN == 1
        USB_IT_Config(( USB_IT_EP0 | USB_IT_BUS | USB_IT_BUS_SUSF | USB_IT_BUS_RSTF | USB_IT_BUS_RSMF | USB_IT_LPM) , ENABLE);
    #else
        USB_IT_Config(( USB_IT_EP0 | USB_IT_BUS | USB_IT_BUS_SUSF | USB_IT_BUS_RSTF | USB_IT_BUS_RSMF) , ENABLE);      
    #endif
    USB_ITEA_Cmd(ENABLE);
    NVIC_EnableIRQ(USB_IRQn);
    
    //====================================================
    //Control Parameter inital.
    Ep0.USBStatus          = USB_STATUS_DEFAULT;
    Ep0.ConfigurationValue = 0;
    //=====================================================
    //USB Connect to Bus (Enable DP pull-up R
    USB_Connect_Cmd(ENABLE);
 
}
/**
 *******************************************************************************
 * @brief	    Read data from RX SRAM of the endpoint.
 * @details     
 * @param[in]   EPX      : ( USB_EP0 ~ USB_EP7) Select control which endpoint register.
 * @param[in]   bRBuffer : The pointer is save data  buffer.
 * @param[in]   bRXShift : Starting receive data byte from RX SRAM of the endpoint.
 * @param[in]   bRXCnt   : Total receive data size.
 * @return      
 * @exception   No
 * @note        RX SRAM address of the endpoint have to set.
 *******************************************************************************
 */ 
void API_USBSerial_ReadEndpointData( USB_EP_Struct* EPX, uint8_t *bRBuffer , uint32_t bRXShift , uint32_t bRXCnt)
{
    uint8_t  USB_REP_Tmp;
    uint8_t *USB_EP_RAM;
    
    USB_EP_RAM = (uint8_t*)((0x30000000 + EPX->RX.H[0] + bRXShift));
    
    for( USB_REP_Tmp = 0; USB_REP_Tmp <bRXCnt ; USB_REP_Tmp ++)
    {
        bRBuffer[USB_REP_Tmp] =  USB_EP_RAM[USB_REP_Tmp];
    }
}

/**
 *******************************************************************************
 * @brief	    Write data to TX SRAM of the endpoint.
 * @details     
 * @param[in]   EPX      : ( USB_EP0 ~ USB_EP7) Select control which endpoint register.
 * @param[in]   btBuffer : The pointer is data source.
 * @param[in]   bTXShift : Write address is that shift address from the TX start SRAM address.
 * @param[in]   bTXCnt   : Write total data size.
 * @return      
 * @exception   No
 * @note        TX SRAM address of the endpoint have to set.              
 *******************************************************************************
 */ 
void API_USBSerial_WriteEndpointData( USB_EP_Struct* EPX, __I uint8_t *btBuffer , uint32_t bTXShift , uint8_t bTXCnt )
{ 
    uint8_t bEPTX_Tmp;
    uint8_t *USB_EP_RAM;
  
    USB_EP_RAM = (uint8_t*)(0x30000000 + EPX->TX.H[0] + bTXShift);
    
    
    for ( bEPTX_Tmp=0 ; bEPTX_Tmp<bTXCnt ; bEPTX_Tmp++ ) 
    {
        USB_EP_RAM[bEPTX_Tmp] = btBuffer[bEPTX_Tmp];
    }
}
/**
 *******************************************************************************
 * @brief	    Write a constant value to TX SRAM of the endpoint.
 * @details 
 * @param[in]   EPX      : ( USB_EP0 ~ USB_EP7) Select control which endpoint register.
 * @param[in]   ConstData: Constant value.
 * @param[in]   cTXShift : Write address is that shift address from the TX start SRAM address.
 * @param[in]   cTXCnt   : Write total data size.
 * @return      
 * @exception   No
 * @note        TX SRAM address of the endpoint have to set.              
 *******************************************************************************
 */ 
void API_USBSerial_WriteEndpointConstData( USB_EP_Struct* EPX, uint8_t ConstData , uint32_t cTXShift , uint8_t cTXCnt )
{ 
    uint8_t cEPTX_Tmp;
    uint8_t *USB_EP_RAM;
  
    USB_EP_RAM = (uint8_t*)(0x30000000 + EPX->TX.H[0] + cTXShift);
    
    for ( cEPTX_Tmp=0 ; cEPTX_Tmp < cTXCnt ; cEPTX_Tmp++ ) 
    {
        USB_EP_RAM[cEPTX_Tmp] = ConstData;
    }
}    
/**
 *******************************************************************************
 * @brief	   Write a byte to TX SRAM of the endpoint. 
 * @details     
 * @param[in]   EPX      : ( USB_EP0 ~ USB_EP7) Select control which endpoint register.
 * @param[in]   sData    : Write data.
 * @param[in]   shift    : Write address is that shift address from the TX start SRAM address.
 * @return      
 * @exception   No
 * @note        TX SRAM address of the endpoint have to set.               
 *******************************************************************************
 */ 
void API_USBSerial_WriteEndpointSingleData( USB_EP_Struct* EPX, uint8_t sData , uint8_t shift)
{
    uint8_t *USB_EP_RAM;
    
    USB_EP_RAM = (uint8_t*)(0x30000000 + EPX->TX.H[0]);
    
    USB_EP_RAM[shift] = sData;
}

/**
 *******************************************************************************
 * @brief	   USB interrupt handle function.
 * @details     
 * @return      
 * @exception   
 * @note                     
 *******************************************************************************
 */
#if 1
void API_USBSerial_IRQ( void )
{ 
    uint32_t        USBIRQ_Status;
    uint32_t        URBEPIRQ_Status1;
    uint8_t         USBIRQ_Tmp;

    //=========================================================================
    //Get USB Interrupt Flag
    USBIRQ_Status       =  USB_GetITAllFlagStatus();

    //=========================================================================
    //USB Bus event handle
    if((USBIRQ_Status & USB_IT_BUS)!=0 )                                                      
    { 
        //---------------------------------------------------------------------
        //Detect Bus Suspend 
        if((USBIRQ_Status & USB_IT_BUS_SUSF)==USB_IT_BUS_SUSF)                                 
        {
            USB_ClearITFlag(USB_IT_BUS_SUSF | USB_IT_BUS);
            
            Ep0.USBStatus |= USB_STATUS_BUS_SUSPEND;
            
            // To do......
        }
        else
        { 
            //---------------------------------------------------------------------
            //Detect Bus Reset.
            if((USBIRQ_Status & USB_IT_BUS_RSTF)==USB_IT_BUS_RSTF)                                
            { 
                USB_ClearITFlag(USB_IT_BUS_RSTF);
                USBIRQ_Tmp = 0x80;

                while( USBIRQ_Tmp  < 228)                                  /*!< By changing the parameter (128 ~ 255) to modify Reset debounce. */
                {
                    if(__DRV_USB_GETBUS_STATUS() & USB_BUS_SE0_STA)
                    {
                        USBIRQ_Tmp = USBIRQ_Tmp + 1;
                    }
                    else
                    {
                        USBIRQ_Tmp = 0;
                        break;
                    }                        
                }
                if( USBIRQ_Tmp != 0)
                {
                    //API_COM_Init();
                    //API_USBSerial_Inital();
                    if( NULL != g_UsbFun.pfUsbInit )
                    {
                        (*g_UsbFun.pfUsbInit)();
                    }

                    Ep0.USBStatus |= USB_STATUS_BUS_RESET;
                    // To do......
                }
            }
            //---------------------------------------------------------------------
            //Detect Bus Resume 
            else if((USBIRQ_Status & USB_IT_BUS_RSMF)==USB_IT_BUS_RSMF)                         
            { 
                USB_ClearITFlag(USB_IT_BUS_RSMF);
                
                Ep0.USBStatus |= USB_STATUS_BUS_RESUME;
                // To do......
            }
            //---------------------------------------------------------------------
            //Detect USB bus change in STOP mode
            else if((USBIRQ_Status & USB_IT_BUS_RWKF) == USB_IT_BUS_RWKF)
            {
                
                
                USB_ClearITFlag(USB_IT_BUS_RWKF);
                USB_IT_Config( USB_IT_BUS_RWKF , DISABLE);
                
                // To do......
            }             
        }
    }
    //=========================================================================
    //ACK response to LPM
    #if MG_USB_LPM_EN == 1
        if( USBIRQ_Status & USB_IT_LPM)
        {
            Ep0.LPM_BLE = USB_GetLPMBESL();
            
            if(USB_GetLPMbRemoteWake()!=0)
            {
                Ep0.USBStatus |= USB_STATUS_RWEN_MASK;
            }
            else
            {
                Ep0.USBStatus &= (~USB_STATUS_RWEN_MASK);
            }
            Ep0.USBStatus = Ep0.USBStatus | USB_STATUS_BUS_SUSPEND;
            
            USB_ClearITFlag(USB_IT_LPM);
        }
    #endif
    //=========================================================================
    //Endpoint handle.
    else  
    {   
        //=====================================================================
        //Endpoint 1 Transmit
        if((USBIRQ_Status & USB_IT_EP1)==USB_IT_EP1)
        {
            USB_ClearEndpointFlag(USB_EP1,USB_EP_FLAG_TXDONE);
            COM.COM_USB_StatusUpstream_Busy = 0;
        }
        //=====================================================================
        //Endpoint 2 Transmit
        if((USBIRQ_Status & USB_IT_EP2)==USB_IT_EP2)
        {
            USB_ClearEndpointFlag(USB_EP2,USB_EP_FLAG_TXDONE);
            
            COM.COM_USB_DataUpstream_Busy = 0;           
        }
        //=====================================================================
        //Endpoint 0 control
        if((USBIRQ_Status & USB_IT_EP0)==USB_IT_EP0)
        {
            URBEPIRQ_Status1 = USB_GetEndpointFlagStatus(USB_EP0);
            
            if((URBEPIRQ_Status1 & USB_EP_FLAG_TXDONE)==USB_EP_FLAG_TXDONE)
            {
                USB_ClearEndpointFlag(USB_EP0,USB_EP_FLAG_TXDONE);
                API_USBSerial_ControlRead();
            }
            else if((URBEPIRQ_Status1 & USB_EP_FLAG_RXDONE)==USB_EP_FLAG_RXDONE)
            {
                USB_ClearEndpointFlag(USB_EP0,USB_EP_FLAG_RXDONE);
                API_USBSerial_ControlWrite();
            }
        }
        //=====================================================================
        //Endpoint 3 Receive
        if((USBIRQ_Status & USB_IT_EP3)==USB_IT_EP3)
        {
            USB_ClearEndpointFlag(USB_EP3,USB_EP_FLAG_RXDONE);
            
            API_USBSerial_ReceiveDownstreamData(); 
        }
    }	  
}
#endif

#if 0
void API_USBSerial_IRQ( void )
{ 
    uint32_t        USBIRQ_Status;
    uint32_t        URBEPIRQ_Status1;
    uint8_t         USBIRQ_Tmp;

    //=========================================================================
    //Get USB Interrupt Flag
    USBIRQ_Status       =  USB_GetITAllFlagStatus();

    //=========================================================================
    //USB Bus event handle
    if((USBIRQ_Status & USB_IT_BUS)!=0 )                                                      
    { 
        //---------------------------------------------------------------------
        //Detect Bus Suspend 
        if((USBIRQ_Status & USB_IT_BUS_SUSF)==USB_IT_BUS_SUSF)                                 
        {
            USB_ClearITFlag(USB_IT_BUS_SUSF | USB_IT_BUS);
            
            Ep0.USBStatus |= USB_STATUS_BUS_SUSPEND;
            
            // To do......
        }
        else
        { 
            //---------------------------------------------------------------------
            //Detect Bus Reset.
            if((USBIRQ_Status & USB_IT_BUS_RSTF)==USB_IT_BUS_RSTF)                                
            { 
                USB_ClearITFlag(USB_IT_BUS_RSTF);
                USBIRQ_Tmp = 0x80;

                while( USBIRQ_Tmp  < 228)                                  /*!< By changing the parameter (128 ~ 255) to modify Reset debounce. */
                {
                    if(__DRV_USB_GETBUS_STATUS() & USB_BUS_SE0_STA)
                    {
                        USBIRQ_Tmp = USBIRQ_Tmp + 1;
                    }
                    else
                    {
                        USBIRQ_Tmp = 0;
                        break;
                    }                        
                }
                if( USBIRQ_Tmp != 0)
                {
                    //API_USBSerial_Init();
                    //API_USBSerial_Inital();
                    if( NULL != g_UsbFun.pfUsbInit )
                    {
                        (*g_UsbFun.pfUsbInit)();
                    }

                    Ep0.USBStatus |= USB_STATUS_BUS_RESET;
                    // To do......
                }
            }
            //---------------------------------------------------------------------
            //Detect Bus Resume 
            else if((USBIRQ_Status & USB_IT_BUS_RSMF)==USB_IT_BUS_RSMF)                         
            { 
                USB_ClearITFlag(USB_IT_BUS_RSMF);
                
                Ep0.USBStatus |= USB_STATUS_BUS_RESUME;
                // To do......
            }
            //---------------------------------------------------------------------
            //Detect USB bus change in STOP mode
            else if((USBIRQ_Status & USB_IT_BUS_RWKF) == USB_IT_BUS_RWKF)
            {
                
                
                USB_ClearITFlag(USB_IT_BUS_RWKF);
                USB_IT_Config( USB_IT_BUS_RWKF , DISABLE);
                
                // To do......
            }             
        }
    }
    //=========================================================================
    //ACK response to LPM
    #if MG_USB_LPM_EN == 1
        if( USBIRQ_Status & USB_IT_LPM)
        {
            Ep0.LPM_BLE = USB_GetLPMBESL();
            
            if(USB_GetLPMbRemoteWake()!=0)
            {
                Ep0.USBStatus |= USB_STATUS_RWEN_MASK;
            }
            else
            {
                Ep0.USBStatus &= (~USB_STATUS_RWEN_MASK);
            }
            Ep0.USBStatus = Ep0.USBStatus | USB_STATUS_BUS_SUSPEND;
            
            USB_ClearITFlag(USB_IT_LPM);
        }
    #endif
    //=========================================================================
    //Endpoint handle.
    else  
    {   
        //=====================================================================
        //Endpoint 1 Transmit
        if((USBIRQ_Status & USB_IT_EP1)==USB_IT_EP1)
        {
            USB_ClearEndpointFlag(USB_EP1,USB_EP_FLAG_TXDONE);
            
            g_UsbEP1Ctr.Status &= (~USBA_Status_UpdateReport);
            API_USBSerial_SetUpstreamBusyStatue(0);
            //COM.COM_USB_StatusUpstream_Busy = 0;
        }
        //=====================================================================
        //Endpoint 2 Transmit
        if((USBIRQ_Status & USB_IT_EP2)==USB_IT_EP2)
        {
            USB_ClearEndpointFlag(USB_EP2,USB_EP_FLAG_TXDONE);

            g_UsbEP1Ctr.Status &= (~USBA_Status_UpdateReport); 

            API_USBSerial_SetDataUpstream_Busy(0);
            //COM.COM_USB_DataUpstream_Busy = 0;           
        }
        //=====================================================================
        //Endpoint 0 control
        if((USBIRQ_Status & USB_IT_EP0)==USB_IT_EP0)
        {
            URBEPIRQ_Status1 = USB_GetEndpointFlagStatus(USB_EP0);
            
            if((URBEPIRQ_Status1 & USB_EP_FLAG_TXDONE)==USB_EP_FLAG_TXDONE)
            {
                USB_ClearEndpointFlag(USB_EP0,USB_EP_FLAG_TXDONE);
                
                //API_USBSerial_ControlRead();
                if( g_UsbFun.pfControlRead != NULL )
                {
                    (*g_UsbFun.pfControlRead)();
                }
            }
            else if((URBEPIRQ_Status1 & USB_EP_FLAG_RXDONE)==USB_EP_FLAG_RXDONE)
            {
                USB_ClearEndpointFlag(USB_EP0,USB_EP_FLAG_RXDONE);

                //API_USBSerial_ControlWrite();
                if( g_UsbFun.pfControlWrite != NULL )
                {
                    (*g_UsbFun.pfControlWrite)();
                }
            }
        }
        //=====================================================================
        //Endpoint 3 Receive
        if((USBIRQ_Status & USB_IT_EP3)==USB_IT_EP3)
        {
            USB_ClearEndpointFlag(USB_EP3,USB_EP_FLAG_RXDONE);
            
            API_USBSerial_ReceiveDownstreamData(); 
        }
    }
}

#endif

/**
 *******************************************************************************
 * @brief	   EP0 receiving data.
 * @details     
 * @return      
 * @exception  No 
 * @note            
 *******************************************************************************
 */ 
static void API_USBSerial_Endpoint0_ReadData( void )
{ 
    uint16_t BLen, tmp;
    
    //==============================================================================
    //Recing SETUP token.
    tmp = __DRV_USB_GETSETUP_STATUS();
    if ( tmp & ( USB_EP0_STOVW | USB_EP0_EDOVW ))                  // Setup Token
    { 
        Ep0.DataStage = SETUPSTAGE;
        while(1)
        { 
            tmp = __DRV_USB_GETSETUP_STATUS();
            
            do{ 
                tmp = __DRV_USB_GETSETUP_STATUS();
            }while(tmp & USB_EP0_STOVW);                           // waiting STOVE = 0

            do{                                        
                tmp = __DRV_USB_GETSETUP_STATUS();         
            }while(!( tmp & USB_EP0_EDOVW ));                      // waiting EDOVW = 1                                        


            __DRV_USB_CLEAR_EDOVW();
            USB_ClearEndpointFlag(USB_EP0,USB_EP_FLAG_RXDONE);

            BLen = USB_GetEndpointRXSize(USB_EP0);
                                         
            API_USBSerial_ReadEndpointData(USB_EP0 , Ep0.RxTx , 0 , BLen);

            tmp = __DRV_USB_GETSETUP_STATUS();
            if (!(tmp & ( USB_EP0_STOVW | USB_EP0_EDOVW )))
                break;
        }

        USB_SetEndpointStatus(USB_EP0, EP_RX_VALID_TX_NAK);
        __DRV_USB_CLEAR_RXSETUP();

        Ep0.All = BLen;                                             
        
    }
    //=============================================================================
    else if( Ep0.DataStage == CLASS_DATASTAGE)
    {        
        BLen      = (uint8_t)USB_GetEndpointRXData( USB_EP0 , Ep0.RxTx, ENABLE);
        Ep0.All   = Ep0.All - BLen;
        
        if( BLen !=0)
        {
            if( API_USBSerial_SetLineCoding(&Ep0.RxTx[0])== COM_FAILURE)
            {
                Ep0.DataStage = STATUSSTAGE;
                USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                return;
            }                
        }
        if( Ep0.All == 0)
        {
            USB_SetEndpointTXData( USB_EP0 , Ep0.RxTx, 0);
            Ep0.DataStage = STATUSSTAGE;
        }
    }
    //=============================================================================
    //Receing data.
    else                                                                                      
    {
        Ep0.DataStage = STATUSSTAGE;
        USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);    
    }                              
}

/**
 *******************************************************************************
 * @brief	   This request returns status for the specified recipient. 
 * @details     
 * @return      
 * @exception  No
 * @note                 
 *******************************************************************************
 */ 
static void API_USBSerial_Get_Status( void )
{ 
    uint8_t   tmp;
    uint16_t  USB_Status;
     
    Ep0.All = 2;                                                                                                          // Only 2 byte transfer to the host
                                                                                                                          
    Ep0.RxTx[1] = 0;                                                                                                      
    switch( Ep0.RxTx[0] & 0x03 )                                                                                          // Request Type ( Reserve low 2 bit )
    {                                                                                                                     
        case DEVICEREQUEST:                                                                                               
                              if ( (Ep0.USBStatus & USB_STATUS_RWEN_MASK) == USB_STATUS_RWEN_ENABLE )                     // Check Remote wakeup enabled or not
                              {                                                                                           
                                   Ep0.RxTx[0] = 0x02;                                                                    // Return Function Remove Wake-up Enable
                              }                                                                                           
                              else                                                                                        
                              {                                                                                           
                                   Ep0.RxTx[0] = 0x00;                                                                    // Return Function Remove Wake-up Disable                                                     
                              }
                              break;                                                                     
        case ENDPOINTREQUEST:  
                              tmp = (Ep0.RxTx[4] & 0x0F);

                              switch(tmp)
                              {
                                  case 1:
                                          USB_Status = USB_GetEndpointStatus(USB_EP1);
                                          break;
                                  case 2:
                                          USB_Status = USB_GetEndpointStatus(USB_EP2);
                                          break;
                                  case 3:
                                          USB_Status = USB_GetEndpointStatus(USB_EP3);
                                          break;
                                  default:
                                          USB_Status = 0;
                                          break;
                              }
                              if((USB_Status & USB_EP0CR1_TXSTL0_mask_h1) || (USB_Status & USB_EP0CR1_RXSTL0_mask_h1))
                              {
                                  Ep0.RxTx[0] = 0x01;                                                                     // if EndPoint Rx/Tx STAL then set EndPoint Halt
                              }
                              else
                              {
                                  Ep0.RxTx[0] = 0x00;                                                                     // else seting this EndPoint Avaliable for Rx/Tx 
                              }
                              
                              break;
        case INTERFACEREQUEST: 
        default:              
                              USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                              break; 
    }
} 

/**
 *******************************************************************************
 * @brief	    Clear Feature.
 * @details     This request is used to clear or disable a specific feature.
 * @return      
 * @exception   No
 * @note                   
 *******************************************************************************
 */ 
static void API_USBSerial_ClearFeature( void )
{ 
    switch( Ep0.RxTx[0] & 0x03 )                                                                     // Request Type ( Reserve low 2 bit )
    { 
        case DEVICEREQUEST:    if ( Ep0.RxTx[2] == DEVICE_REMOTE_WAKEUP )
                               {
                                   Ep0.USBStatus &= ((uint32_t)(~USB_STATUS_RWEN_MASK));             // Disable the Device Remote Wakeup function
                               }
                               else
                               {   
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               }
                               break;                                                       
        case ENDPOINTREQUEST:                                                                        // Disable Endpoint Halt.
                               if ( Ep0.RxTx[2] == ENDPOINT_HALT )
                               { 
                                   switch((Ep0.RxTx[4] & 0x0F))
                                   {
                                       case 1:
                                               USB_TriggerEndpointRst(USB_EP1,EP_RST_TX_RX);
                                               USB_SetEndpointINSequenceBit(USB_EP1,0);
                                               USB_SetEndpointOUTSequenceBit(USB_EP1,0);
                                               USB_SetEndpointStatus(USB_EP1, EP_RX_DISABLE_TX_NAK);
                                               break;
                                       case 2:
                                               USB_TriggerEndpointRst(USB_EP2,EP_RST_TX_RX);
                                               USB_SetEndpointINSequenceBit(USB_EP2,0);
                                               USB_SetEndpointOUTSequenceBit(USB_EP2,0);
                                               USB_SetEndpointStatus(USB_EP2, EP_RX_DISABLE_TX_NAK);
                                               break;
                                       case 3:
                                               USB_TriggerEndpointRst(USB_EP3,EP_RST_TX_RX);
                                               USB_SetEndpointINSequenceBit(USB_EP3,0);
                                               USB_SetEndpointOUTSequenceBit(USB_EP3,0);
                                               USB_SetEndpointStatus(USB_EP3,EP_RX_VALID_TX_DISABLE);
                                               break;
                                       default:
                                               break;
                                   }
                               }
                               else
                               { 
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               }
                               break;
        case INTERFACEREQUEST: 
        default:               
                               USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               break;
    }
}

/**
 *******************************************************************************
 * @brief	    Set feature.
 * @details     This request is used to set or enable a specific feature
 * @return      
 * @exception   No
 * @note                     
 *******************************************************************************
 */
static void API_USBSerial_SetFeature( void )
{ 

    switch( Ep0.RxTx[0] & 0x03 )                                                                      // Request Type ( Reserve low 2 bit )
    { 
        case DEVICEREQUEST:    
                               if ( Ep0.RxTx[2] == DEVICE_REMOTE_WAKEUP )
                               {
                                   Ep0.USBStatus |= USB_STATUS_RWEN_MASK;                             // Endpoint the Device Remote Wakeup function
                               }
                               else
                               { 
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               }
                               break;                                                                 // Enable Endpoint Halt.
        case ENDPOINTREQUEST:                                                 
                               if ( Ep0.RxTx[2] == ENDPOINT_HALT )
                               { 
                                   switch((Ep0.RxTx[4] & 0x0F))
                                   {
                                       case 1:
                                               USB_SetEndpointStatus(USB_EP1, EP_RX_STALL_TX_STALL);
                                               break;
                                       case 2:
                                               USB_SetEndpointStatus(USB_EP2, EP_RX_STALL_TX_STALL);
                                               break;
                                       case 3:
                                               USB_SetEndpointStatus(USB_EP3, EP_RX_STALL_TX_STALL); 
                                               break;
                                       default:
                                               break;
                                   }
                               }
                               else
                               { 
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);
                               }
                               break;
        case INTERFACEREQUEST: 
        default:               
                               USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL); 
                               break; 
    }
}  

/**
 *******************************************************************************
 * @brief	   Get Descriptor. 
 * @details    This request returns the specified descriptor if the descriptor exists.
 * @return      
 * @exception  No
 * @note                     
 *******************************************************************************
 */
static void API_USBSerial_GetDescriptor( void )
{ 
    ctype WLen;
  
    WLen.W    = 0;                                  
    Ep0.All = ((uint32_t)((Ep0.RxTx[7] << 8) + Ep0.RxTx[6]));

    //=======================================================================================
    //Descriptor Type : High byte of the wValue field.
    switch( Ep0.RxTx[3] )	
    { 
        //------------------------------------------------------------------------------------------------
        //Device Descriptor :
        case DEVICE_DESCRIPTOR:      
                                      Ep0.Buf   = Serial_USB_DEVICE_DESCRIPTOR;
                                      WLen.B[0] = Ep0.Buf[0];
                                      break;
        //------------------------------------------------------------------------------------------------
        //Configuration Descriptor :
        case CONFIGURATION_DESCRIPTOR: 
                                      //------------------------------------------------------------------
                                      //*. Descriptor Index : Low byte of the wValue field.
                                      //*. The sample only one configuration.
                                      Ep0.Buf   = Serial_USB_CONFIGURATION_DESCRIPTOR;
                                      WLen.B[1] = Ep0.Buf[3];
                                      WLen.B[0] = Ep0.Buf[2];
                                      break;
        //------------------------------------------------------------------------------------------------
        //String Descriptor :
        case STRING_DESCRIPTOR:        
                                      //------------------------------------------------------------------
                                      //*. Descriptor Index : Low byte of the wValue field.
                                      switch( Ep0.RxTx[2] )
                                      { 
                                          case 0:  
                                                   Ep0.Buf   = Serial_USB_STRING_DESCRIPTOR;
                                                   WLen.B[0] = Ep0.Buf[0];
                                                   break;
                                          //-------------------------------------------------------------
                                          //* Index define refer to device descriptor.
                                          case 1:  
                                                   #if MF_STRING_INDEX == 1
                                                       if ( Serial_USB_DEVICE_DESCRIPTOR[14] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = Serial_Manufacturer_Descriptor;
                                                           WLen.B[0]     = MFS_LEN;
                                                           break;
                                                       }
                                                   #elif PD_STRING_INDEX == 1
                                                       if ( Serial_USB_DEVICE_DESCRIPTOR[15] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = Serial_Product_Descriptor;
                                                           WLen.B[0]     = PDS_LEN;
                                                           break;
                                                       }
                                                   #elif SN_STRING_INDEX == 1
                                                       if ( Serial_USB_DEVICE_DESCRIPTOR[16] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = Serial_SerialNumber_Descriptor;
                                                           WLen.B[0]     = SNS_LEN;
                                                           break;
                                                       }
                                                   #endif
                                                   
                                                    
                                                   Ep0.DataStage = STATUSSTAGE;       
                                                   
                                                   break;
                                          case 2:  
                                                   #if PD_STRING_INDEX == 2
                                                       if ( Serial_USB_DEVICE_DESCRIPTOR[15] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = Serial_Product_Descriptor;
                                                           WLen.B[0]     = PDS_LEN;
                                                           break;
                                                       }
                                                   #elif SN_STRING_INDEX == 2
                                                       if ( Serial_USB_DEVICE_DESCRIPTOR[16] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = Serial_SerialNumber_Descriptor;
                                                           WLen.B[0]     = SNS_LEN;
                                                           break;
                                                       }
                                                   #endif
                                                   
                                                    
                                                   Ep0.DataStage = STATUSSTAGE;       
                                                   
                                                   break;
                                          case 3:  
                                                   #if SN_STRING_INDEX == 3
                                                       if ( Serial_USB_DEVICE_DESCRIPTOR[16] )
                                                       {
                                                           Ep0.DataStage = DATASTAGE_STRING0;
                                                           Ep0.Buf       = Serial_SerialNumber_Descriptor;
                                                           WLen.B[0]     = SNS_LEN;
                                                           break;
                                                       }
                                                   #endif
                                                   
                                                   Ep0.DataStage = STATUSSTAGE;       
                                                   
                                                   break;
                                          default: 
                                                   Ep0.DataStage = STATUSSTAGE;
                                                   break;
                                    }
                                    Ep0.Tmp = WLen.B[0];
                                    break;
        //-------------------------------------------------------------------------------------------------
        //BOS Descriptor.
        #if MG_USB_LPM_EN == 1
        case BOS_DESCRIPTOR:
                                    Ep0.Buf   = Serial_USB_BOS_DESCRIPTOR;
                                    WLen.B[0] = Ep0.Buf[2];
                                    break;
        #endif
        //-------------------------------------------------------------------------------------------------                                                             
    	default:                      
                                    Ep0.DataStage = STATUSSTAGE;
                                    break;
    }
  
    if ( Ep0.All > WLen.W )
    {
        Ep0.All = WLen.W;
    }
}
/**
 *******************************************************************************
 * @brief	   Set Configuration 
 * @details    This request sets the device configuration.
 * @return      
 * @exception  No 
 * @note       The sample code only support one configuration.          
 *******************************************************************************
 */                              
static void API_USBSerial_SetConfiguration( void )
{ 
    USB_EP_Struct*  USB_EPX;
    uint8_t         USBConfig_Tmp;
    
    
    Ep0.ConfigurationValue =  Ep0.RxTx[2];

    if(Ep0.ConfigurationValue == 1)
    { 
        for( USBConfig_Tmp = 1; USBConfig_Tmp < 8; USBConfig_Tmp ++)
        {
            USB_EPX = ((USB_EP_Struct*) USB_EP_TABLE[0][USBConfig_Tmp]);  
            USB_IT_Config( USB_EP_TABLE[1][USBConfig_Tmp],ENABLE); 
            
            switch( (EPn_InitaStatus_TABLE[USBConfig_Tmp] & MG_USBEP_OPEN_MASK) )
            {
                case MG_USBEP_RX_OPEN:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_RXDONE) , ENABLE); 
                                         USB_SetEndpointStatus(USB_EPX , EP_RX_VALID); 
                                         break;
                case MG_USBEP_TX_OPEN: 
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_TXDONE) , ENABLE); 
                                         USB_SetEndpointStatus(USB_EPX , EP_TX_NAK);
                                         break;
                case MG_USBEP_RX_TX_OPEN:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_TXDONE | USB_EP_IE_RXDONE) , ENABLE); 
                                         USB_SetEndpointStatus(USB_EPX , EP_RX_VALID_TX_NAK);
                                         break;
                case MG_USBEP_DB_RX_OPEN:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_DBUFFER_RXDONE) , ENABLE); 
                                         USB_SetDoubleBufferEndpointStatus(USB_EPX , EP_DB_RXBUFALL_VALID);
                                         break;
                case MG_USBEP_DB_TX_OPEN:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_DBUFFER_TXDONE) , ENABLE); 
                                         USB_SetDoubleBufferEndpointStatus(USB_EPX,EP_DB_TXBUFALL_NAK);
                                         break;
                default:
                                         USB_EndpintIT_Config( USB_EPX , (USB_EP_IE_TXDONE | USB_EP_IE_RXDONE) , DISABLE); 
                                         USB_IT_Config( USB_EP_TABLE[1][USBConfig_Tmp],DISABLE); 
                                         USB_SetEndpointStatus(USB_EPX , EP_RX_DISABLE_TX_DISABLE);
                                         break;     
            }
        }
        //======================================================
        //LPM Control.
        #if MG_USB_LPM_EN == 1
            USB_LPMhandshakeMode_Select(USB_LPM_ACK);
        #endif
        //======================================================
        //USB enumeration PASS
        Ep0.USBStatus |= USB_STATUS_EMULATION_OK;                             // Emulation Flow pass
        
        
        
    }
    else
    {
        USB_SetEndpointStatus(USB_EP1 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP2 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP3 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP4 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP5 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP6 , EP_RX_DISABLE_TX_DISABLE);
        USB_SetEndpointStatus(USB_EP7 , EP_RX_DISABLE_TX_DISABLE);
    }
        
    USB_SetEndpointTXSize(USB_EP0, 0);
    USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                          // USB will return ACK immediately when receive IN transaction
}
/**
 *******************************************************************************
 * @brief	    Set Interface.
 * @details     
 * @return      
 * @exception   
 * @note                      
 *******************************************************************************
 */
static void API_USBSerial_SetInterface( void )
{ 
    switch( Ep0.RxTx[4] )
    { 
        case 0: 
        case 1:            
                 if ( Ep0.RxTx[2] > 0 )                                          
                 {
                     USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);        
                 }
                 else
                 { 
                     USB_SetEndpointTXSize(USB_EP0, 0);
                     USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);
                 }
                 break;
        default: 
                 USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);            
                 break;
    }
}
/**
 *******************************************************************************
 * @brief	    Get Interface.
 * @details     
 * @return      
 * @exception   
 * @note                    
 *******************************************************************************
 */
static void API_USBSerial_GetInterface( void )
{ 
    Ep0.All  = 1;
    switch( Ep0.RxTx[4] )
    { 
        case 0:  
        case 1:
                 Ep0.RxTx[0] = 0;                                                 // For Interface1 ( HID )
                 break;
        default: 
                 USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);            // Set Rx/Tx STAL 
                 break;
    }
}

/**
 *******************************************************************************
 * @brief	   Control USB EP0 Transmit (Host EP0 IN).
 * @details     
 * @return      
 * @exception   
 * @note                     
 *******************************************************************************
 */
static void API_USBSerial_ControlRead( void )                                          // Host In , USB Out ( Only for EP0 )
{ 
    uint8_t USB_CtrlRdBLen;

    if ( Ep0.DataStage == DATASTAGE )                                             // In DATASTAGE we should move Data to TXFIFO
    { 
        if ( Ep0.All > EP0_PACKET_SIZE )
        {
            USB_CtrlRdBLen = EP0_PACKET_SIZE;
        }
        else
        {
            USB_CtrlRdBLen = (uint8_t)Ep0.All;
    	}
        API_USBSerial_WriteEndpointData( USB_EP0 , Ep0.Buf , 0 , USB_CtrlRdBLen );

        USB_SetEndpointTXSize(USB_EP0, USB_CtrlRdBLen);
        USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                               // USB will return ACK immediately when receive IN transaction
        Ep0.All -= USB_CtrlRdBLen;                                                 // Calculated the Remain Data size
        Ep0.Buf   += USB_CtrlRdBLen;                                               // Move Buffer Address in Right position
    }
    else if(Ep0.DataStage == CLASS_DATASTAGE)
    {
         if( Ep0.All > EP0_PACKET_SIZE)
         {
             USB_CtrlRdBLen = EP0_PACKET_SIZE;
         }
         else
         {
             USB_CtrlRdBLen = (uint8_t)Ep0.All;
         }
         
         API_USBSerial_GetLineCoding(&Ep0.RxTx[0]);
         USB_SetEndpointTXData( USB_EP0 , Ep0.Buf, USB_CtrlRdBLen);
     
         Ep0.All = Ep0.All -  USB_CtrlRdBLen;
         Ep0.Buf = Ep0.Buf + USB_CtrlRdBLen;         
    }
    else if(Ep0.DataStage == DATASTAGE_STRING0)
    {
        Ep0.DataStage  = DATASTAGE_STRING1;
        
        API_USBSerial_WriteEndpointData( USB_EP0 , &Ep0.Tmp , 0 , 1 );
        Ep0.Tmp        = STRING_DESCRIPTOR;
        API_USBSerial_WriteEndpointData( USB_EP0 , &Ep0.Tmp , 1 , 1 );
        USB_CtrlRdBLen = 2;
        Ep0.All        = Ep0.All - 2;
        
        Ep0.Tmp        = 0;
        
        while( (USB_CtrlRdBLen < MG_USB_EP0_DSIZE) && (Ep0.All!=0))
        {
            if( ( USB_CtrlRdBLen % 2)==0)
            {
                API_USBSerial_WriteEndpointData( USB_EP0 , Ep0.Buf , USB_CtrlRdBLen , 1 );
                Ep0.Buf += 1;
            }
            else
            {
                API_USBSerial_WriteEndpointData( USB_EP0 , &Ep0.Tmp , USB_CtrlRdBLen , 1 );
            }
            
            Ep0.All -= 1;
            USB_CtrlRdBLen = USB_CtrlRdBLen + 1;
        }

        USB_SetEndpointTXSize(USB_EP0, USB_CtrlRdBLen);
        USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                                                                          
    }
    else if(Ep0.DataStage == DATASTAGE_STRING1)
    {
        USB_CtrlRdBLen = 0;
        Ep0.Tmp        = 0;
        
        while( (USB_CtrlRdBLen < MG_USB_EP0_DSIZE) && (Ep0.All!=0))
        {
            if( ( USB_CtrlRdBLen % 2)==0)
            {
                API_USBSerial_WriteEndpointData( USB_EP0 , Ep0.Buf , USB_CtrlRdBLen , 1 );
                Ep0.Buf += 1;
            }
            else
            {
                API_USBSerial_WriteEndpointData( USB_EP0 , &Ep0.Tmp , USB_CtrlRdBLen , 1 );
            }
            
            Ep0.All -= 1;
            USB_CtrlRdBLen = USB_CtrlRdBLen + 1;
        }

        USB_SetEndpointTXSize(USB_EP0, USB_CtrlRdBLen);
        USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);
    }
    else
    { 
        USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);                       // Set Rx/Tx STAL 
        if ( Ep0.DataStage == SETADDRESS )                                          // Different from other STATUSSTAGE(importent)
        { 
            __DRV_USB_SETADDRESS(Ep0.Tmp);
        }
    }
}

/**
 *******************************************************************************
 * @brief	   USB standard request.
 * @details     
 * @return      
 * @exception   
 * @note                     
 *******************************************************************************
 */
static void API_USBSerial_StandardRequest( void )
{ 
   if( Ep0.RxTx[0] & GET_REQUEST)
   {
       switch( Ep0.RxTx[1] )                                                                    // Request Code
       { 
           case GET_DESCRIPTOR:    
                                   Ep0.DataStage = DATASTAGE;
                                   API_USBSerial_GetDescriptor();
                                   API_USBSerial_ControlRead();
                                   break;
           case GET_CONFIGURATION: 
                                   Ep0.DataStage = DATASTAGE;
                                   Ep0.RxTx[0] = Ep0.ConfigurationValue;                        // This value get from SET_CONFIGURATION transaction
                                   Ep0.All = 1;                                                 // Only 1 byte transfer to the host
                                   API_USBSerial_ControlRead();
                                   break;
           case GET_STATUS:       
                                   Ep0.DataStage = DATASTAGE;
                                   API_USBSerial_Get_Status();
                                   API_USBSerial_ControlRead();
                                   break;
           case GET_INTERFACE:     
                                   Ep0.DataStage = DATASTAGE;
                                   API_USBSerial_GetInterface();
                                   API_USBSerial_ControlRead();
                                   break;
           case SYNCH_FRAME:       
                                   Ep0.DataStage = STATUSSTAGE;
                                   USB_SetEndpointTXSize(USB_EP0, 0);
                                   USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                 // USB will return ACK immediately when receive IN transaction
                                   Ep0.All = 0;
                                   break;
           default:                
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);        // Set Rx/Tx STAL 
                                   break;         
       }
   }
   else
   {
       switch( Ep0.RxTx[1] )                                                                    // Request Code
       { 
           case SET_ADDRESS:       
                                   Ep0.DataStage = SETADDRESS;                                  // Different from other STATUSSTAGE
                                   Ep0.Tmp = Ep0.RxTx[2];
                                   USB_SetEndpointTXSize(USB_EP0, 0);
                                   USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                 // USB will return ACK immediately when receive IN transaction
                                   break;
           case SET_CONFIGURATION: 
                                   Ep0.DataStage = STATUSSTAGE;
                                   API_USBSerial_SetConfiguration();                                     
                                   break;
           case CLEAR_FRATURE:		
                                   Ep0.DataStage = STATUSSTAGE;  
                                   API_USBSerial_ClearFeature();
                                   USB_SetEndpointTXSize(USB_EP0, 0);
                                   USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                 // USB will return ACK immediately when receive IN transaction
                                   break;
           case SET_FEATURE:       
                                   Ep0.DataStage = STATUSSTAGE;
                                   API_USBSerial_SetFeature();
                                   USB_SetEndpointTXSize(USB_EP0, 0);
                                   USB_SetEndpointStatus(USB_EP0, EP_TX_VALID);                 // USB will return ACK immediately when receive IN transaction
                                   break;
           case SET_INTERFACE:     
                                   Ep0.DataStage = STATUSSTAGE;
                                   API_USBSerial_SetInterface();
                                   break;
           case SET_DESCRIPTOR:
           default:                
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);        // Set Rx/Tx STAL 
                                   break;         
       }
   }
}

/**
 *******************************************************************************
 * @brief	   USB Class Request 
 * @details     
 * @return      
 * @exception   
 * @note                     
 *******************************************************************************
 */
static void API_USBSerial_ClassRequest( void )
{ 
    switch( Ep0.RxTx[1])  
    {
        case SET_LINE_CODING:     
                                    Ep0.DataStage = CLASS_DATASTAGE;
                                    Ep0.All       = Ep0.RxTx[7];
                                    Ep0.All       <<= 8;
                                    Ep0.All      = Ep0.All + Ep0.RxTx[6];
                                    break;
        case GET_LINE_CODING: 
                                    Ep0.DataStage = CLASS_DATASTAGE;
                                    Ep0.All       = 7;
                                    API_USBSerial_ControlRead();
                                    break;
        case SET_CONTROL_LINE_STATE:   
                                    Ep0.DataStage = STATUSSTAGE;
                                    API_USBSerial_SetControlLineState(Ep0.RxTx);
                                    USB_SetEndpointTXData( USB_EP0, Ep0.RxTx , 0);
                                    break;
        case SET_BREAK:
                                    Ep0.DataStage = STATUSSTAGE;
                                    API_USBSerial_SendBreak(Ep0.RxTx);
                                    USB_SetEndpointTXData( USB_EP0, Ep0.RxTx , 0);
                                    break;
        default:           
                                    Ep0.DataStage = STATUSSTAGE;
                                    USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);       
                                    break; 
    }
}

/**
 *******************************************************************************
 * @brief	   USB EP0 handle for receive data or SETUP. 
 * @details     
 * @return      
 * @exception   
 * @note                      
 *******************************************************************************
 */
static void API_USBSerial_ControlWrite( void )                                                 // Host Out , USB In ( Only for EPO )
{                                                                                                                                                                       
    Ep0.Buf = Ep0.RxTx;                                                                   // Move Buffer address to RxTx[8] array , Use for USB_CtrlRd();
    API_USBSerial_Endpoint0_ReadData();                                              // Move Rx Data to RxTxBuf buffer
    if ( Ep0.DataStage == SETUPSTAGE )                                                        
    {	                                                                                  
        Ep0.All = 0;                                                                      
        switch( Ep0.RxTx[0] & REQUEST_TYPE_MASK )                                         // Request Type
        {
            case STANDARD_REQUEST: 
                                   API_USBSerial_StandardRequest();
                                   break;
            case CLASS_REQUEST:    
                                   API_USBSerial_ClassRequest();
                                   break;
            default:               
                                   USB_SetEndpointStatus(USB_EP0, EP_RX_STALL_TX_STALL);   // Set Rx/Tx STAL 
                                   break;                       
        }
    }    
}

int API_USBSerial_IsEmulationOK(void)
{
   return  ( (Ep0.USBStatus & USB_STATUS_EMULATION_MASK) == USB_STATUS_EMULATION_OK);
}




static void API_USBSerial_Event(void)
{
    uint32_t API_USBD_Event;
    
    
    API_USBD_Event = Ep0.USBStatus & USB_STATUS_BUS_MASK;
    
    if( API_USBD_Event != 0)
    {
        switch( API_USBD_Event)
        {
            //============================================================================================
            // During handling the ohter functions USB bus happen suspend status. 
            case USB_STATUS_BUS_SUSPEND:
								Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_SUSPEND));
								// To do......
								
								USB_IT_Config( USB_IT_BUS_RWKF , ENABLE);               /*!< Enable USB Bus event wakeup interrupt in STOP mode.*/ 

								STOP_WFI();                                             /*!< IC into STOP mode*/
								
								break;
            //============================================================================================
            //Detect USB Bus no supsend in STOP mode. 
            case USB_STATUS_BUS_BUSEVENT_WAKEUP:
								Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_BUSEVENT_WAKEUP));
								
								// To do......
								break;
            //============================================================================================
            //During handling the other functions extern wakeup signal happen.
            case USB_STATUS_BUS_EXTIEVENT_WAKEUP:
								Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~USB_STATUS_BUS_EXTIEVENT_WAKEUP));
								//To do......
								break;
            //============================================================================================
            //During handling the ohter function USB bus happen resume status.
            case (USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESUME):
            case (USB_STATUS_BUS_RESUME):
								Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~(USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESUME)));
								// To do......
								break;
            //============================================================================================
            case (USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESET):
            case USB_STATUS_BUS_RESET:
								Ep0.USBStatus = Ep0.USBStatus & ((uint32_t)(~(USB_STATUS_BUS_BUSEVENT_WAKEUP | USB_STATUS_BUS_RESET)));
								// To do...
								
								break;
            default:
								// To do......
								break;
        }
    
    }
    if( (Ep0.USBStatus & USB_STATUS_EMULATION_MASK) == USB_STATUS_EMULATION_OK)
    {
        // To do......
    }
}



#endif  //#if !defined(USBCON)  


