



 /**
 ******************************************************************************
 *
 * @file        MG32x02z_USBD_USBSerialDescriptor.h
 * @brief       The USBD Descriptor's h file.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.00
 * @date        2020/09/11
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef _MG32X02Z_USBD_USBSERIALDESCRIPTOR_H_
#define _MG32X02Z_USBD_USBSERIALDESCRIPTOR_H_

#include "MG32x02z.h"
#include "MG32x02z_USB_Init.h"




////////////////////////////////////////////////////////////////////////////////////////////////


/**
 * @name USB Class Codes
 *   		
 */ 
///@{

//--------------------------------------------------------------------------------
//Defined Class Codes (USB-IF Last Update: January 7, 2022)
#define bDeviceClass_InterfaceDescriptors          0x00         /*!< Use class information in the Interface Descriptors.*/
#define bDeviceClass_CDC                           0x02         /*!< Communications and CDC Control.*/      
#define bDeviceClass_Hub                           0x09
#define bDeviceClass_BillboardDeviceClass          0x11
#define bDeviceClass_DiagnosticDevice              0xDC
#define bDeviceClass_Miscellaneous                 0xEF
#define bDeviceClass_VendorSpecific                0xFF

//-------------------------------------------------------------------------------- 
//Defined Class Codes (USB-IF Last Update: January 7, 2022)                            
#define bInterfaceClass_Audio                      0x01
#define bInterfaceClass_CDC                        0x02         /*!< Communications and CDC Control.*/      
#define bInterfaceClass_HID                        0x03         /*!< HID(Human Interface Device).*/
#define bInterfaceClass_Physical                   0x05
#define bInterfaceClass_Image                      0x06
#define bInterfaceClass_Printer                    0x07
#define bInterfaceClass_MassStorage                0x08
#define bInterfaceClass_CDCData                    0x0A
#define bInterfaceClass_SmartCard                  0x0B
#define bInterfaceClass_ContentSecurity            0x0D
#define bInterfaceClass_Video                      0x0E
#define bInterfaceClass_PersonalHealthcare         0x0F
#define bInterfaceClass_AudioVideoDevices          0x10
#define bInterfaceClass_USBTypeC_BridgeClass       0x12
#define bInterfaceClass_I3CDeviceClass             0x3C
#define bInterfaceClass_DiagnosticDevice           0xDC
#define bInterfaceClass_WirelessController         0xE0
#define bInterfaceClass_Miscellaneous              0xEF
#define bInterfaceClass_ApplicationSpecific        0xFE
#define bInterfaceClass_VendorSpecific             0xFF 

///@}




////////////////////////////////////////////////////////////////////////////////////////////////













/*Mouse Status*/
#define USBA_Status_Idle                0x00                       /*!< Mouse state is idle*/
#define USBA_Status_Init                0x80                       /*!< Mouse state is initializing.*/
#define USBA_Status_UpdateReport        0x40                       /*!< Mouse update data to host.*/
#define USBA_Status_BNTReportChange     0x01                       /*!< Mouse button data of report change.*/
#define USBA_Status_SensorReportChange  0x02                       /*!< Mouse sensor data of report change.*/
#define USBA_Status_WheelReportChange   0x04                       /*!< Mouse wheel data of report change.*/

#define USBA_Status_ReportChange        (USBA_Status_BNTReportChange    | \
                                         USBA_Status_SensorReportChange | \
                                         USBA_Status_WheelReportChange)           /*Mouse report data change mask*/



/**
 * @name Cosumer Descriptor Define.
 *   		
 */ 
///@{

#define FKB_TOTALFUNCTION    0x14


#define    HID_REPORT_LENGTH sizeof(HID_REPORT)




#define    EP3_PACKET_SIZE        64                                      /*!< Maximum packet size for EP3.*/ 



#define    HID0_HID_REPORT_LENGTH sizeof(Serial_USB_INTERFACE0_HID_REPORT)       /*!< USB HID0 Descriptor data size.*/
#define    HID1_HID_REPORT_LENGTH sizeof(Serial_USB_INTERFACE1_HID_REPORT)       /*!< USB HID1 Descriptor data size.*/

    

#define USB_CONFIGURATION_DESC_SIZE        9                  /*!< USB Configuration descriptor data size. */
#define USB_INTERFACE_DESC_SIZE            9                  /*!< USB Interface descriptor data size. */
#define USB_HID_DESC_SIZE                  9                  /*!< USB HID descriptor data size. */
#define USB_HEADER_DESC_SIZE               5                  /*!< USB Header Descriptor data size in CS interface descriptor.*/
#define USB_ABSTRACT_DESC_SIZE             4                  /*!< USB Abstract Descriptor data size in CS interface descriptor.*/
#define USB_UNION_DESC_SIZE                5                  /*!< USB Union Descriptor data size in CS interface descriptor.*/
#define USB_CALLMANAGEMENT_DESC_SIZE       5                  /*!< USB Call Management Descriptor data size in CS interface descriptor.*/
#define USB_ENDPOINT_DESC_SIZE             7                  /*!< USB Endpoint descriptor data size. */


#define USB_CONFIGURATION_TOTAOL_INTERFACE  2                                                                                    /*!< Total interface in the configuration.*/

#define USB_CONFIGURATION_DESC_TOTAOSIZE   ((USB_CONFIGURATION_DESC_SIZE * 1) +  \
                                            (USB_INTERFACE_DESC_SIZE + (USB_HEADER_DESC_SIZE + USB_ABSTRACT_DESC_SIZE + USB_UNION_DESC_SIZE + USB_CALLMANAGEMENT_DESC_SIZE) + USB_ENDPOINT_DESC_SIZE) +\
                                            (USB_INTERFACE_DESC_SIZE + USB_ENDPOINT_DESC_SIZE * 2))          

   

#define KB_FUNHID_ID_FKB         1                             /*!< HID Multimedia ID.*/
#define KB_FUNHID_ID_SYSTEM      2                             /*!< HID System power control ID.*/

 
extern const uint8_t Serial_USB_INTERFACE0_HID_REPORT[];              /*!< HID report of interface0 .*/
extern const uint8_t Serial_USB_INTERFACE1_HID_REPORT[];              /*!< HID report of interface1.*/
extern const uint8_t Serial_USB_DEVICE_DESCRIPTOR[];                  /*!< Device Descriptor.*/
extern const uint8_t Serial_USB_CONFIGURATION_DESCRIPTOR[];           /*!< Configuration Descriptor.*/
extern const uint8_t Serial_USB_INTERFACE0_DESCRIPTOR[];              /*!< Interface0 descriptor.*/
extern const uint8_t Serial_USB_INTERFACE0_HID_DESCRIPTOR[];          /*!< HID descriptor of interface0.*/
extern const uint8_t Serial_USB_INTERFACE0_IN_ENDPOINT_DESCRIPTOR[];  /*!< Endpoint descriptor of interface0.*/
extern const uint8_t Serial_USB_INTERFACE1_DESCRIPTOR[];              /*!< Interface1 descriptor.*/
extern const uint8_t Serial_USB_INTERFACE1_HID_DESCRIPTOR[];          /*!< HID descriptor of interface1.*/
extern const uint8_t Serial_USB_INTERFACE1_IN_ENDPOINT_DESCRIPTOR[];  /*!< Endpoint descriptor of interface1.*/
extern const uint8_t Serial_USB_STRING_DESCRIPTOR[];                  /*!< String descriptor.*/


#if MF_STRING == 1
    #define MFS_LEN (sizeof(MANUFACTURER_DESCRIPTOR)*2)        /*!< Manufacture descriptor size.*/
    
    extern const uint8_t Serial_Manufacturer_Descriptor[];            /*!< Manufacture string descriptor.*/
#endif

#if PD_STRING == 1
    #define PDS_LEN (sizeof(PRODUCT_DESCRIPTOR)*2)             /*!< Product descriptor size.*/
    
    extern const uint8_t Serial_Product_Descriptor[];                 /*!< Product string descriptor.*/
#endif

#if SN_STRING == 1
    #define SNS_LEN (sizeof(SERIALNUMBER_DESCRIPTOR)*2)        /*!< Serial number descriptor size.*/
    
    extern const uint8_t Serial_SerialNumber_Descriptor[];            /*!< Serial number string descriptor.*/
#endif

#if MG_USB_LPM_EN == 1
extern const uint8_t Serial_USB_BOS_DESCRIPTOR[];                     /*!< BOS descriptor.*/
extern const uint8_t Serial_USB_EXT_DESCRIPTOR[];                     /*!< Device capabilty descriptor.*/
#endif

///@}












////////////////////////////////////////////////////////////////////////////////////////////////////////////////






#include "MG32x02z.h"
#include "MG32x02z__ExtraStruct.h"
#include "MG32x02z_USB_DRV.h"
#include "MG32x02z_USB_Init.h"


/**
 * @name	============== Data type  ==============
 *   		
 */ 
///@{

#define    HIBYTE( V1 )     ((uint8_t)((V1) >> 8))                           /*!<Get high byte (8 ~ 15 bit) of 16 bit data.*/
#define    LOBYTE( V1 )     ((uint8_t)((V1) & 0xFF))                         /*!<Get low byte (8 ~ 15 bit) of 16 bit data.*/

///@}

/**
 * @name	============== USB protocal Relationship ==============
 *   		
 */ 
///@{    
//------------------------------------------------
//Standard Request Code ( bRequest)
#define    GET_STATUS          0                                              /*!< This request returns status for the specified recipient.*/
#define    CLEAR_FRATURE       1                                              /*!< This request is used to clear or disable a specific feature.*/
#define    SET_FEATURE         3                                              /*!< This request is used to set or enable a specific feature.*/
#define	   SET_ADDRESS         5                                              /*!< This request sets the device address for all future device accesses.*/
#define    GET_DESCRIPTOR      6                                              /*!< This request returns the specified descriptor if the descriptor exists.*/
#define    SET_DESCRIPTOR      7                                              /*!< This request is iptional and may be used to update existing descriptors or new descriptors may be added.*/
#define    GET_CONFIGURATION   8                                              /*!< This request returns the current device configuration value.*/
#define    SET_CONFIGURATION   9                                              /*!< This request sets the device configuration.*/
#define    GET_INTERFACE       10                                             /*!< This request returns the selected alternate setting for the specified interface.*/
#define    SET_INTERFACE       11                                             /*!< The request allows the host to select an alternate setting for the specified interface.*/
#define    SYNCH_FRAME         12                                             /*!< The request is used to set and then report an endpoint's synchronization frame.*/
//------------------------------------------------
// HID Request Codes
#define    GET_REPORT          0x01                                           /*!< The GET_REPORT request allows the host to receive a report via the Control pipe.*/
#define    GET_IDLE            0x02                                           /*!< The GET_IDLE request reads the current idle rate for a particular input report.*/
#define    GET_PROTOCOL        0x03                                           /*!< The GET_PROTOCOL request reads which protocol is currently active.*/
#define    SET_REPORT          0x09                                           /*!< The SET_REPORT request allows the host to send a report to the device, possibly setting the state of input
                                                                                   , output , or feature controls.*/
#define    SET_IDLE            0x0A                                           /*!< The SET_IDLE request silences a particular report on the Interrupt IN pipe until a new event occurs or the
                                                                                   specified amount of time passes.*/
#define    SET_PROTOCOL        0x0B                                           /*!< The SET_PROTOCOL switches between the boot protocol and the report protocol.*/

//------------------------------------------------
//Request Data transfer direction of bmRequestType
#define    GET_REQUEST         0x80                                           /*!< Device to Host.*/
#define    SET_REQUEST         0x00                                           /*!< Host to Device.*/

//------------------------------------------------
//Type of bmRequestType 
#define    REQUEST_TYPE_MASK    0x60                                          /*!< Request Type Mask.*/
#define    STANDARD_REQUEST     0x00                                          /*!< Standard Request Type.*/
#define    CLASS_REQUEST        0x20                                          /*!< Class Request Type.*/
#define    VENDOR_REQUEST       0x40                                          /*!< Vendor Request Type.*/

//------------------------------------------------
//Recipient of bmRequestType 
#define    DEVICEREQUEST        0x00                                          /*!< Device.*/
#define    INTERFACEREQUEST     0x01                                          /*!< Interface.*/
#define    ENDPOINTREQUEST      0x02                                          /*!< Endpoint.*/

//-------------------------------------------------
//Feature Selectors in Standard Feature Selectors
#define    DEVICE_REMOTE_WAKEUP 0x01                                          /*!< Device Remote wakeup.*/
#define    ENDPOINT_HALT        0x00                                          /*!< Endpoint Halt.*/

//------------------------------------------------
//Descriptor Type in Standard Request Code                                                            
#define    DEVICE_DESCRIPTOR           0x01                                   /*!<Device Descriptor.*/
#define    CONFIGURATION_DESCRIPTOR    0x02                                   /*!<Configuration Descriptor.*/
#define    STRING_DESCRIPTOR           0x03                                   /*!<String Descriptor.*/
#define    INTERFACE_DESCRIPTOR        0x04                                   /*!<Interface Descriptor.*/
#define    ENDPOINT_DESCRIPTOR         0x05                                   /*!<Endpoint Descriptor.*/
#define    DEVICE_QUALIFIER_DESCRIPTOR 0x06                                   /*!<Device Qualifier Descriptor.*/
#define    BOS_DESCRIPTOR              0x0F                                   /*!<Binary Device Object Store(BOS) Descriptor.*/
#define    DEVICE_CAPABILTY_DESCRIPTOR 0x10                                   /*!<Device Capablity Descriptor.*/

#define    CS_INTERFACE_DESCRIPTOR     0x24                                   /*!<Class-Specific Interface Descriptor.*/

//------------------------------------------------
//Descriptor Type in Class Request Code ( HID)
#define    HID_DESCRIPTOR              0x21                                   /*!< Class Descriptor : HID.*/
#define    HID_REPORT                  0x22                                   /*!< Class Descriptor : Report.*/
#define    HID_PHYSICAL_DESCRIPTOR     0x23                                   /*!< Class Descriptor : Physical descriptor.*/

//------------------------------------------------
//Direction of bEndpointAddress in Endpoint Descriptor.
#define USB_EP_OUT                              0x00                          /*!< OUT Endpoint.*/
#define USB_EP_IN                               0x80                          /*!< IN Endpoint.*/

//------------------------------------------------
//The endpoint number of bEndpointAddress in Endpoint Descriptor.
#define USB_EP_0                                0x00                          /*!< Endpoint number is 0.*/
#define USB_EP_1                                0x01                          /*!< Endpoint number is 1.*/
#define USB_EP_2                                0x02                          /*!< Endpoint number is 2.*/
#define USB_EP_3                                0x03                          /*!< Endpoint number is 3.*/
#define USB_EP_4                                0x04                          /*!< Endpoint number is 4.*/
#define USB_EP_5                                0x05                          /*!< Endpoint number is 5.*/
#define USB_EP_6                                0x06                          /*!< Endpoint number is 6.*/
#define USB_EP_7                                0x07                          /*!< Endpoint number is 7.*/
#define USB_EP_8                                0x08                          /*!< Endpoint number is 8.*/
#define USB_EP_9                                0x09                          /*!< Endpoint number is 9.*/
#define USB_EP_10                               0x0A                          /*!< Endpoint number is 10.*/
#define USB_EP_11                               0x0B                          /*!< Endpoint number is 11.*/
#define USB_EP_12                               0x0C                          /*!< Endpoint number is 12.*/
#define USB_EP_13                               0x0D                          /*!< Endpoint number is 13.*/
#define USB_EP_14                               0x0E                          /*!< Endpoint number is 14.*/
#define USB_EP_15                               0x0F                          /*!< Endpoint number is 15.*/

//------------------------------------------------
//Transfer Type of bmAttributes in Endpoint Descriptor.
#define USB_EP_CONTROL                          0x00                          /*!< Transfer Type is Control.*/
#define USB_EP_ISOCHRONOUS                      0x01                          /*!< Transfer Type is Isochronous.*/
#define USB_EP_BULK                             0x02                          /*!< Transfer Type is Bulk.*/
#define USB_EP_INTERRUPT                        0x03                          /*!< Transfer Type is Interrupt.*/

//------------------------------------------------
//Synchronization Type of bmAttributes in Endpoint Descriptor.
#define USB_EP_NO_SYNC                          0x00                          /*!< Synchronization Type is No Synchronization Type.*/              
#define USB_EP_ASYNC                            0x04                          /*!< Synchronization Type is Asynchronous.*/
#define USB_EP_ADAPTIVE                         0x08                          /*!< Synchronization Type is Adaptive.*/
#define USB_EP_SYNC                             0x0C                          /*!< Synchronization Type is Synchronous.*/

//------------------------------------------------
//Usage Type of bmAttributes in Endpoint Descriptor.
#define USB_EP_DATA                             0x00                          /*!< Usage Type is data endpoint. */
#define USB_EP_FEEDBACK                         0x10                          /*!< Usage Type is feedback endpoint.*/
#define USB_EP_IMPLICIT                         0x20                          /*!< Usage Type is implicit feedback data endpoint.*/
///@}    
    

/**
 * @name	========= Language IDs==============
 *   		
 */ 
///@{   

#define LANGUAGEID_CHINESE_TW                   0x0404
#define LANGUAGEID_ENGLISH_US                   0x0409
#define LANGUAGEID_JAPANESE                     0x0411
#define LANGUAGEID_KOREAN                       0x0412
#define LAGNUAGEID_CHINESE_PRC                  0x0804
#define LAGNUAGEID_CHINESE_HK_SAR_PRC           0x0C04
#define LAGNUAGEID_CHINESE_SINGAPORE            0x1004

///@}
  
    
    
/**
 * @name	========= USB Software Status Control Relationship==============
 *   		
 */ 
///@{     

 /*! @struct USBCTR_TypeDef
    @brief   USB software control and Endpoint0 relationship struct.
*/ 
                                     

//------------------------------------------------
// USBStatus Control Relationship Define.
#define    USB_STATUS_DEFAULT                           0x00000000            /*!<USB software status default value.*/
#define    USB_STATUS_EMULATION_MASK                    0x80000000            /*!<Emulation status mask of USB software status .*/
    #define    USB_STATUS_EMULATION_OK                            0x80000000  /*!<Emulation status of USB software status is success.*/
    #define    USB_STATUS_EMULATION_NO                            0x00000000  /*!<Emulation status of USB software status is not yet successful.*/
#define    USB_STATUS_RWEN_MASK                         0x40000000            /*!<Remote wakeup function mask of USB software status.*/
    #define    USB_STATUS_RWEN_ENABLE                             0x40000000  /*!<Remote wakeup enable.*/
    #define    USB_STATUS_RWEN_DISABLE                            0x00000000  /*!<Remote wakeup disable.*/
#define    USB_STATUS_BUS_MASK                          0x00FF0000            /*!<USB Bus status mask of USB software status.*/
    #define    USB_STATUS_BUS_ACT                                 0x00000000  /*!<USB Bus Active.*/
    #define    USB_STATUS_BUS_RESET                               0x00010000  /*!<USB Bus Reset.*/
    #define    USB_STATUS_BUS_SUSPEND                             0x00020000  /*!<USB Bus Suspend.*/
    #define    USB_STATUS_BUS_RESUME                              0x00040000  /*!<USB Bus Resume.*/
    #define    USB_STATUS_BUS_EXTIEVENT_WAKEUP                    0x00080000  /*!<External signal wakeup device.*/
    #define    USB_STATUS_BUS_BUSEVENT_WAKEUP                     0x00100000  /*!<Bus event wakeup devic.*/

//------------------------------------------------
// DataStage Control Relationship Define.
#define    SETUPSTAGE          0xF0
#define    DATASTAGE           0x5A
#define    DATASTAGE_SRP       0x5B
#define    DATASTAGE_GRP       0x5C
#define    DATASTAGE_STRING0   0x5D
#define    DATASTAGE_STRING1   0x5E
#define    STATUSSTAGE         0xA5
#define    SETADDRESS          0x55     
  
#define    CLASS_DATASTAGE     0xAA    

 
    
    

#endif






