/**
 ******************************************************************************
 *
 * @file        MG32x02z_EMB.h
 *
 * @brief       MG32x02z EMB Register Definitions Header File
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.22 (Register File Date : 2022_0815)
 * @date        2022/08/25 15:14 (H File Generated Date)
 * @author      HeadCodeGen V1.42
 * @copyright   Copyright (c) 2022 Megawin Technology Co., Ltd.
 *              All rights reserved.
 *
 * Important!   This file is generated by code generator. Do not edit!
 *
 ******************************************************************************
 */

#ifndef _MG32x02z_EMB_H
#define _MG32x02z_EMB_H
#define _MG32x02z_EMB_H_VER                         122     /*!< File Version */

#include "MG32x02z.h"

#if !(_MG32x02z_H_VER == _MG32x02z_EMB_H_VER)
    #error "_MG32x02z_EMB_H - Main/Module Version Mismatch !"
#endif

/**
 ******************************************************************************
 *
 * @struct      EMB_Struct
 *              EMB  [Module Structure Typedef]
 *
 ******************************************************************************
 */
typedef struct
{
    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t  BUSYF         :1;     //[0] EMB write/read access busy flag.
            __IO uint8_t  BWEF          :1;     //[1] EMB bus byte-write error flag. (set by hardware and clear by software writing 1)
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  WPEF          :1;     //[2] EMB bus write-protect error detect flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __IO uint8_t  IAEF          :1;     //[3] EMB bus access illegal address error detection flag
                                        //0 = Normal (No event occurred)
                                        //1 = Happened (reset event happened)
            __I  uint8_t                :4;     //[7..4] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }STA;                               /*!< STA        ~ Offset[0x00]  EMB status register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  IEA           :1;     //[0] EMB controller interrupt all enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BWE_IE        :1;     //[1] EMB bus byte-write error detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WPE_IE        :1;     //[2] EMB bus write-protect error detect interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  IAE_IE        :1;     //[3] EMB bus access illegal address error detection interrupt enable.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :4;     //[7..4] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint8_t                :8;     //[23..16] 
            __I  uint8_t                :8;     //[31..24] 
        }MBIT;
    }INT;                               /*!< INT        ~ Offset[0x04]  EMB interrupt enable register */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __I  uint8_t                :4;     //[3..0] 
            __IO uint8_t  CK_PSC        :3;     //[6..4] EMB output clock MCLK prescaler. The value range 0~7 is indicated divider 1~8.
            __I  uint8_t                :1;     //[7] 
            __I  uint8_t                :8;     //[15..8] 
            __I  uint16_t               :16;    //[31..16] 
        }MBIT;
    }CLK;                               /*!< CLK        ~ Offset[0x08]  EMB clock source register */

    __I uint32_t  RESERVED0;            /*!< RESERVED0  ~ Offset[0x0C]  Reserved */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  EN            :1;     //[0] EMB controller enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  WEN           :1;     //[1] EMB write access enable bit. 
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BW_EN         :1;     //[2] EMB bus byte-write access enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  SYNC_EN       :1;     //[3] EMB synchronous transaction enable bit
                                        //0 = Async (asynchronous access)
                                        //1 = Sync (synchronous access)
            __I  uint8_t                :2;     //[5..4] 
            __I  uint8_t                :1;     //[6] 
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  BUS_DSIZE     :1;     //[8] EMB bus access data size.
                                        //0x0 = 8-bit
                                        //0x1 = 16-bit
            __IO uint8_t  MAM1_EN       :1;     //[9] EMB internal memory address A-1 signal output enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BUS_MDS       :1;     //[10] EMB address and data bus mode select.
                                        //0 = Multiplex
                                        //1 = Separated
            __IO uint8_t  ADR_TWO       :1;     //[11] EMB two address phase timing mode enable
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ADR_SEL       :2;     //[13..12] EMB bus address range select
                                        //0x0 = 16bit :17bit if EMB_MAM1_EN is enabled
                                        //0x1 = 24bit :25bit if EMB_MAM1_EN is enabled
                                        //0x2 = 30bit
                                        //0x3 = Reserved
            __I  uint8_t                :1;     //[14] 
            __I  uint8_t                :1;     //[15] 
            __IO uint8_t  CE_MDS        :2;     //[17..16] EMB MCE signal mode select.
                                        //0x0 = CE : chip enable signal
                                        //0x1 = ALE : same as ALE timing
                                        //0x2 = ALE2 : 2nd phase address latch enable
                                        //0x3 = Reserved
            __I  uint8_t                :1;     //[18] 
            __I  uint8_t                :1;     //[19] 
            __I  uint8_t                :1;     //[20] 
            __I  uint8_t                :3;     //[23..21] 
            __IO uint8_t  ALE2_MDS      :1;     //[24] EMB MALE2 signal mode select. When EMB_MAM1_SEL=ALES, this register bit is no effect.
                                        //0x0 = ALE2 : 2nd phase address latch enable
                                        //0x1 = ALE : same as ALE timing
            __I  uint8_t                :1;     //[25] 
            __IO uint8_t  OE_CTL        :1;     //[26] EMB MOE control timing select.
                                        //0x0 = TOGGLE : high-to-low change
                                        //0x1 = LOW : drive low during read access
            __IO uint8_t  WE_CTL        :1;     //[27] EMB MWE control timing select.
                                        //0x0 = TOGGLE : high-to-low change
                                        //0x1 = LOW : drive low during write access
            __I  uint8_t                :3;     //[30..28] 
            __IO uint8_t  DMA_EN        :1;     //[31] Direct memory access enable.
                                        //0 = Disable
                                        //1 = Enable
        }MBIT;
    }CR0;                               /*!< CR0        ~ Offset[0x10]  EMB control register 0 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  CE_INV        :1;     //[0] EMB MCE output inverse enable bit. The hardware active level is default logic low.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ALE_INV       :1;     //[1] EMB MALE output inverse enable bit. The hardware active level is default logic high.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ALE2_INV      :1;     //[2] EMB MALE2 output inverse enable bit. The hardware active level is default logic high.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CLK_INV       :1;     //[3] EMB MCLK clock output inverse enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[4] 
            __I  uint8_t                :3;     //[7..5] 
            __IO uint8_t  MA_SWAP       :1;     //[8] EMB MA[15:0] signals Msb/Lsb swap enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MAD_SWAP      :1;     //[9] EMB MAD[15:0] signals Msb/Lsb swap enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  MAD_BSWAP     :1;     //[10] EMB MAD[15:8] and MAD[7:0] signals byte swap enable bit.
                                        //0 = Disable
                                        //1 = Enable
            __I  uint8_t                :1;     //[11] 
            __IO uint8_t  MAM1_SEL      :2;     //[13..12] EMB internal memory address A-1 signal output pin select.
                                        //0x0 = No : not output A-1 signal
                                        //0x1 = Reserved
                                        //0x2 = MBW1
                                        //0x3 = MALE2
            __I  uint8_t                :2;     //[15..14] 
            __IO uint8_t  CE_SWEN       :1;     //[16] EMB MCE signal output software control enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  CE_SWO        :1;     //[17] EMB MCE signal software control output data bit.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  ALE_SWEN      :1;     //[18] EMB MALE signal output software control enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ALE_SWO       :1;     //[19] EMB MALE signal software control output data bit.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  ALE2_SWEN     :1;     //[20] EMB MALE2 signal output software control enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  ALE2_SWO      :1;     //[21] EMB MALE2 signal software control output data bit.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  BW0_SWEN      :1;     //[22] EMB BW0 signal output software control enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BW0_SWO       :1;     //[23] EMB BW0 signal software control output data bit.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __IO uint8_t  BW1_SWEN      :1;     //[24] EMB BW0 signal output software control enable bit
                                        //0 = Disable
                                        //1 = Enable
            __IO uint8_t  BW1_SWO       :1;     //[25] EMB BW0 signal software control output data bit.
                                        //0 = 0 (Output 0)
                                        //1 = 1 (Output 1)
            __I  uint8_t                :2;     //[27..26] 
            __IO uint8_t  OE_MUX        :2;     //[29..28] MOE output signal select.
                                        //0x0 = OE : EMB Output Enable signal
                                        //0x1 = TM10 : TM10_CKO
                                        //0x2 = TM16 : TM16_CKO
                                        //0x3 = TM20 : TM20_CKO
            __IO uint8_t  WE_MUX        :2;     //[31..30] MWE output signal select.
                                        //0x0 = WE : EMB Write Enable signal
                                        //0x1 = TM10 : TM10_CKO
                                        //0x2 = TM16 : TM16_CKO
                                        //0x3 = TM20 : TM20_CKO
        }MBIT;
    }CR1;                               /*!< CR1        ~ Offset[0x14]  EMB control register 1 */

    union
    {
        __IO  uint32_t  W;
        __IO  uint16_t  H[2];
        __IO  uint8_t   B[4];
        struct
        {
            __IO uint8_t  ALES          :1;     //[0] EMB SRAM/NOR bus ALE/ALE2 setup time
            __I  uint8_t                :3;     //[3..1] 
            __IO uint8_t  ALEW          :3;     //[6..4] EMB SRAM/NOR bus ALE/ALE2 pulse width
            __I  uint8_t                :1;     //[7] 
            __IO uint8_t  ALEH          :1;     //[8] EMB SRAM/NOR bus ALE/ALE2 hold time
            __I  uint8_t                :3;     //[11..9] 
            __IO uint8_t  ACCS          :1;     //[12] EMB SRAM/NOR bus data access setup time
            __I  uint8_t                :3;     //[15..13] 
            __IO uint8_t  ACCW          :4;     //[19..16] EMB SRAM/NOR bus data access time
            __IO uint8_t  ACCH          :1;     //[20] EMB SRAM/NOR bus data write access hold time
            __I  uint8_t                :3;     //[23..21] 
            __IO uint8_t  IDLE          :2;     //[25..24] EMB SRAM/NOR bus idle time between two successive cycles
            __I  uint8_t                :2;     //[27..26] 
            __I  uint8_t                :4;     //[31..28] 
        }MBIT;
    }CR2;                               /*!< CR2        ~ Offset[0x18]  EMB control register 2 */

} EMB_Struct;

/**
 ******************************************************************************
 *
 * @name        EMB  [Base Address/Type]
 *
 ******************************************************************************
 */
///@{
#define EMB_Base                        ((uint32_t)0x4D020000)              /*!< External Memory Bus Controller */
#define EMB                             ((EMB_Struct*) EMB_Base)
///@}

/**
 ******************************************************************************
 *
 * @name        EMB  [Register Definitions]
 *
 ******************************************************************************
 */
/**
 ******************************************************************************
 * @name        EMB_STA  [register's definitions]
 *              Offset[0x00]  EMB status register (0x4D020000)
 ******************************************************************************
 */
///@{
#define EMB_STA_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EMB_STA */
#define EMB_STA_IAEF_mask_w                         ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EMB_STA_IAEF_mask_h0                        ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EMB_STA_IAEF_mask_b0                        ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EMB_STA_IAEF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EMB_STA_IAEF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EMB_STA_IAEF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EMB_STA_IAEF_happened_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Happened of 32bit */
#define EMB_STA_IAEF_happened_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Happened of 16bit */
#define EMB_STA_IAEF_happened_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Happened of 8bit */

#define EMB_STA_WPEF_mask_w                         ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EMB_STA_WPEF_mask_h0                        ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EMB_STA_WPEF_mask_b0                        ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EMB_STA_WPEF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EMB_STA_WPEF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EMB_STA_WPEF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EMB_STA_WPEF_happened_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(1):Happened of 32bit */
#define EMB_STA_WPEF_happened_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Happened of 16bit */
#define EMB_STA_WPEF_happened_b0                    ((uint8_t )0x04)        /*!< Bit Value =(1):Happened of 8bit */

#define EMB_STA_BWEF_mask_w                         ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EMB_STA_BWEF_mask_h0                        ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EMB_STA_BWEF_mask_b0                        ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_STA_BWEF_normal_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Normal of 32bit */
#define EMB_STA_BWEF_normal_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Normal of 16bit */
#define EMB_STA_BWEF_normal_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Normal of 8bit */
#define EMB_STA_BWEF_happened_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Happened of 32bit */
#define EMB_STA_BWEF_happened_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Happened of 16bit */
#define EMB_STA_BWEF_happened_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Happened of 8bit */

#define EMB_STA_BUSYF_mask_w                        ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EMB_STA_BUSYF_mask_h0                       ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EMB_STA_BUSYF_mask_b0                       ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EMB_STA_BUSYF_shift_w                       (0)                     /*!< Bit Shift of 32bit */
#define EMB_STA_BUSYF_shift_h0                      (0)                     /*!< Bit Shift of 16bit */
#define EMB_STA_BUSYF_shift_b0                      (0)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EMB_INT  [register's definitions]
 *              Offset[0x04]  EMB interrupt enable register (0x4D020004)
 ******************************************************************************
 */
///@{
#define EMB_INT_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EMB_INT */
#define EMB_INT_IAE_IE_mask_w                       ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EMB_INT_IAE_IE_mask_h0                      ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EMB_INT_IAE_IE_mask_b0                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EMB_INT_IAE_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_INT_IAE_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_INT_IAE_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_INT_IAE_IE_enable_w                     ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_INT_IAE_IE_enable_h0                    ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_INT_IAE_IE_enable_b0                    ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_INT_WPE_IE_mask_w                       ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EMB_INT_WPE_IE_mask_h0                      ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EMB_INT_WPE_IE_mask_b0                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EMB_INT_WPE_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_INT_WPE_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_INT_WPE_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_INT_WPE_IE_enable_w                     ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_INT_WPE_IE_enable_h0                    ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_INT_WPE_IE_enable_b0                    ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_INT_BWE_IE_mask_w                       ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EMB_INT_BWE_IE_mask_h0                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EMB_INT_BWE_IE_mask_b0                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_INT_BWE_IE_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_INT_BWE_IE_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_INT_BWE_IE_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_INT_BWE_IE_enable_w                     ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_INT_BWE_IE_enable_h0                    ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_INT_BWE_IE_enable_b0                    ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_INT_IEA_mask_w                          ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EMB_INT_IEA_mask_h0                         ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EMB_INT_IEA_mask_b0                         ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EMB_INT_IEA_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_INT_IEA_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_INT_IEA_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_INT_IEA_enable_w                        ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_INT_IEA_enable_h0                       ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_INT_IEA_enable_b0                       ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EMB_CLK  [register's definitions]
 *              Offset[0x08]  EMB clock source register (0x4D020008)
 ******************************************************************************
 */
///@{
#define EMB_CLK_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EMB_CLK */
#define EMB_CLK_CK_PSC_mask_w                       ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define EMB_CLK_CK_PSC_mask_h0                      ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define EMB_CLK_CK_PSC_mask_b0                      ((uint8_t )0x70)        /*!< Bit Mask of 8bit */
#define EMB_CLK_CK_PSC_shift_w                      (4)                     /*!< Bit Shift of 32bit */
#define EMB_CLK_CK_PSC_shift_h0                     (4)                     /*!< Bit Shift of 16bit */
#define EMB_CLK_CK_PSC_shift_b0                     (4)                     /*!< Bit Shift of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EMB_CR0  [register's definitions]
 *              Offset[0x10]  EMB control register 0 (0x4D020010)
 ******************************************************************************
 */
///@{
#define EMB_CR0_default                             ((uint32_t)0x00000000)  /*!< Reg Reset Default Value */

/* Bit fields of EMB_CR0 */
#define EMB_CR0_DMA_EN_mask_w                       ((uint32_t)0x80000000)  /*!< Bit Mask of 32bit */
#define EMB_CR0_DMA_EN_mask_h1                      ((uint16_t)0x8000)      /*!< Bit Mask of 16bit */
#define EMB_CR0_DMA_EN_mask_b3                      ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EMB_CR0_DMA_EN_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR0_DMA_EN_disable_h1                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR0_DMA_EN_disable_b3                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR0_DMA_EN_enable_w                     ((uint32_t)0x80000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR0_DMA_EN_enable_h1                    ((uint16_t)0x8000)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR0_DMA_EN_enable_b3                    ((uint8_t )0x80)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR0_WE_CTL_mask_w                       ((uint32_t)0x08000000)  /*!< Bit Mask of 32bit */
#define EMB_CR0_WE_CTL_mask_h1                      ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EMB_CR0_WE_CTL_mask_b3                      ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EMB_CR0_WE_CTL_toggle_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):TOGGLE of 32bit */
#define EMB_CR0_WE_CTL_toggle_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):TOGGLE of 16bit */
#define EMB_CR0_WE_CTL_toggle_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):TOGGLE of 8bit */
#define EMB_CR0_WE_CTL_low_w                        ((uint32_t)0x08000000)  /*!< Bit Value =(0x1):LOW of 32bit */
#define EMB_CR0_WE_CTL_low_h1                       ((uint16_t)0x0800)      /*!< Bit Value =(0x1):LOW of 16bit */
#define EMB_CR0_WE_CTL_low_b3                       ((uint8_t )0x08)        /*!< Bit Value =(0x1):LOW of 8bit */

#define EMB_CR0_OE_CTL_mask_w                       ((uint32_t)0x04000000)  /*!< Bit Mask of 32bit */
#define EMB_CR0_OE_CTL_mask_h1                      ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EMB_CR0_OE_CTL_mask_b3                      ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EMB_CR0_OE_CTL_toggle_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):TOGGLE of 32bit */
#define EMB_CR0_OE_CTL_toggle_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):TOGGLE of 16bit */
#define EMB_CR0_OE_CTL_toggle_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):TOGGLE of 8bit */
#define EMB_CR0_OE_CTL_low_w                        ((uint32_t)0x04000000)  /*!< Bit Value =(0x1):LOW of 32bit */
#define EMB_CR0_OE_CTL_low_h1                       ((uint16_t)0x0400)      /*!< Bit Value =(0x1):LOW of 16bit */
#define EMB_CR0_OE_CTL_low_b3                       ((uint8_t )0x04)        /*!< Bit Value =(0x1):LOW of 8bit */

#define EMB_CR0_ALE2_MDS_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define EMB_CR0_ALE2_MDS_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EMB_CR0_ALE2_MDS_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EMB_CR0_ALE2_MDS_ale2_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):ALE2 of 32bit */
#define EMB_CR0_ALE2_MDS_ale2_h1                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):ALE2 of 16bit */
#define EMB_CR0_ALE2_MDS_ale2_b3                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):ALE2 of 8bit */
#define EMB_CR0_ALE2_MDS_ale_w                      ((uint32_t)0x01000000)  /*!< Bit Value =(0x1):ALE of 32bit */
#define EMB_CR0_ALE2_MDS_ale_h1                     ((uint16_t)0x0100)      /*!< Bit Value =(0x1):ALE of 16bit */
#define EMB_CR0_ALE2_MDS_ale_b3                     ((uint8_t )0x01)        /*!< Bit Value =(0x1):ALE of 8bit */

#define EMB_CR0_CE_MDS_mask_w                       ((uint32_t)0x00030000)  /*!< Bit Mask of 32bit */
#define EMB_CR0_CE_MDS_mask_h1                      ((uint16_t)0x0003)      /*!< Bit Mask of 16bit */
#define EMB_CR0_CE_MDS_mask_b2                      ((uint8_t )0x03)        /*!< Bit Mask of 8bit */
#define EMB_CR0_CE_MDS_ce_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):CE of 32bit */
#define EMB_CR0_CE_MDS_ce_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):CE of 16bit */
#define EMB_CR0_CE_MDS_ce_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0x0):CE of 8bit */
#define EMB_CR0_CE_MDS_ale_w                        ((uint32_t)0x00010000)  /*!< Bit Value =(0x1):ALE of 32bit */
#define EMB_CR0_CE_MDS_ale_h1                       ((uint16_t)0x0001)      /*!< Bit Value =(0x1):ALE of 16bit */
#define EMB_CR0_CE_MDS_ale_b2                       ((uint8_t )0x01)        /*!< Bit Value =(0x1):ALE of 8bit */
#define EMB_CR0_CE_MDS_ale2_w                       ((uint32_t)0x00020000)  /*!< Bit Value =(0x2):ALE2 of 32bit */
#define EMB_CR0_CE_MDS_ale2_h1                      ((uint16_t)0x0002)      /*!< Bit Value =(0x2):ALE2 of 16bit */
#define EMB_CR0_CE_MDS_ale2_b2                      ((uint8_t )0x02)        /*!< Bit Value =(0x2):ALE2 of 8bit */

#define EMB_CR0_ADR_SEL_mask_w                      ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define EMB_CR0_ADR_SEL_mask_h0                     ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EMB_CR0_ADR_SEL_mask_b1                     ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EMB_CR0_ADR_SEL_16bit_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):16bit of 32bit */
#define EMB_CR0_ADR_SEL_16bit_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0x0):16bit of 16bit */
#define EMB_CR0_ADR_SEL_16bit_b1                    ((uint8_t )0x00)        /*!< Bit Value =(0x0):16bit of 8bit */
#define EMB_CR0_ADR_SEL_24bit_w                     ((uint32_t)0x00001000)  /*!< Bit Value =(0x1):24bit of 32bit */
#define EMB_CR0_ADR_SEL_24bit_h0                    ((uint16_t)0x1000)      /*!< Bit Value =(0x1):24bit of 16bit */
#define EMB_CR0_ADR_SEL_24bit_b1                    ((uint8_t )0x10)        /*!< Bit Value =(0x1):24bit of 8bit */
#define EMB_CR0_ADR_SEL_30bit_w                     ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):30bit of 32bit */
#define EMB_CR0_ADR_SEL_30bit_h0                    ((uint16_t)0x2000)      /*!< Bit Value =(0x2):30bit of 16bit */
#define EMB_CR0_ADR_SEL_30bit_b1                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):30bit of 8bit */

#define EMB_CR0_ADR_TWO_mask_w                      ((uint32_t)0x00000800)  /*!< Bit Mask of 32bit */
#define EMB_CR0_ADR_TWO_mask_h0                     ((uint16_t)0x0800)      /*!< Bit Mask of 16bit */
#define EMB_CR0_ADR_TWO_mask_b1                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EMB_CR0_ADR_TWO_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR0_ADR_TWO_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR0_ADR_TWO_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR0_ADR_TWO_enable_w                    ((uint32_t)0x00000800)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR0_ADR_TWO_enable_h0                   ((uint16_t)0x0800)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR0_ADR_TWO_enable_b1                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR0_BUS_MDS_mask_w                      ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EMB_CR0_BUS_MDS_mask_h0                     ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EMB_CR0_BUS_MDS_mask_b1                     ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EMB_CR0_BUS_MDS_multiplex_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Multiplex of 32bit */
#define EMB_CR0_BUS_MDS_multiplex_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Multiplex of 16bit */
#define EMB_CR0_BUS_MDS_multiplex_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Multiplex of 8bit */
#define EMB_CR0_BUS_MDS_separated_w                 ((uint32_t)0x00000400)  /*!< Bit Value =(1):Separated of 32bit */
#define EMB_CR0_BUS_MDS_separated_h0                ((uint16_t)0x0400)      /*!< Bit Value =(1):Separated of 16bit */
#define EMB_CR0_BUS_MDS_separated_b1                ((uint8_t )0x04)        /*!< Bit Value =(1):Separated of 8bit */

#define EMB_CR0_MAM1_EN_mask_w                      ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EMB_CR0_MAM1_EN_mask_h0                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EMB_CR0_MAM1_EN_mask_b1                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_CR0_MAM1_EN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR0_MAM1_EN_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR0_MAM1_EN_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR0_MAM1_EN_enable_w                    ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR0_MAM1_EN_enable_h0                   ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR0_MAM1_EN_enable_b1                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR0_BUS_DSIZE_mask_w                    ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EMB_CR0_BUS_DSIZE_mask_h0                   ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EMB_CR0_BUS_DSIZE_mask_b1                   ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EMB_CR0_BUS_DSIZE_8_bit_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):8-bit of 32bit */
#define EMB_CR0_BUS_DSIZE_8_bit_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0x0):8-bit of 16bit */
#define EMB_CR0_BUS_DSIZE_8_bit_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0x0):8-bit of 8bit */
#define EMB_CR0_BUS_DSIZE_16_bit_w                  ((uint32_t)0x00000100)  /*!< Bit Value =(0x1):16-bit of 32bit */
#define EMB_CR0_BUS_DSIZE_16_bit_h0                 ((uint16_t)0x0100)      /*!< Bit Value =(0x1):16-bit of 16bit */
#define EMB_CR0_BUS_DSIZE_16_bit_b1                 ((uint8_t )0x01)        /*!< Bit Value =(0x1):16-bit of 8bit */

#define EMB_CR0_SYNC_EN_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EMB_CR0_SYNC_EN_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EMB_CR0_SYNC_EN_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EMB_CR0_SYNC_EN_async_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Async of 32bit */
#define EMB_CR0_SYNC_EN_async_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Async of 16bit */
#define EMB_CR0_SYNC_EN_async_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Async of 8bit */
#define EMB_CR0_SYNC_EN_sync_w                      ((uint32_t)0x00000008)  /*!< Bit Value =(1):Sync of 32bit */
#define EMB_CR0_SYNC_EN_sync_h0                     ((uint16_t)0x0008)      /*!< Bit Value =(1):Sync of 16bit */
#define EMB_CR0_SYNC_EN_sync_b0                     ((uint8_t )0x08)        /*!< Bit Value =(1):Sync of 8bit */

#define EMB_CR0_BW_EN_mask_w                        ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EMB_CR0_BW_EN_mask_h0                       ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EMB_CR0_BW_EN_mask_b0                       ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EMB_CR0_BW_EN_disable_w                     ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR0_BW_EN_disable_h0                    ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR0_BW_EN_disable_b0                    ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR0_BW_EN_enable_w                      ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR0_BW_EN_enable_h0                     ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR0_BW_EN_enable_b0                     ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR0_WEN_mask_w                          ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EMB_CR0_WEN_mask_h0                         ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EMB_CR0_WEN_mask_b0                         ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_CR0_WEN_disable_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR0_WEN_disable_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR0_WEN_disable_b0                      ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR0_WEN_enable_w                        ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR0_WEN_enable_h0                       ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR0_WEN_enable_b0                       ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR0_EN_mask_w                           ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EMB_CR0_EN_mask_h0                          ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EMB_CR0_EN_mask_b0                          ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EMB_CR0_EN_disable_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR0_EN_disable_h0                       ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR0_EN_disable_b0                       ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR0_EN_enable_w                         ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR0_EN_enable_h0                        ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR0_EN_enable_b0                        ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EMB_CR1  [register's definitions]
 *              Offset[0x14]  EMB control register 1 (0x4D020014)
 ******************************************************************************
 */
///@{
#define EMB_CR1_default                             ((uint32_t)0x00000006)  /*!< Reg Reset Default Value */

/* Bit fields of EMB_CR1 */
#define EMB_CR1_WE_MUX_mask_w                       ((uint32_t)0xC0000000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_WE_MUX_mask_h1                      ((uint16_t)0xC000)      /*!< Bit Mask of 16bit */
#define EMB_CR1_WE_MUX_mask_b3                      ((uint8_t )0xC0)        /*!< Bit Mask of 8bit */
#define EMB_CR1_WE_MUX_we_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):WE of 32bit */
#define EMB_CR1_WE_MUX_we_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):WE of 16bit */
#define EMB_CR1_WE_MUX_we_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0x0):WE of 8bit */
#define EMB_CR1_WE_MUX_tm10_w                       ((uint32_t)0x40000000)  /*!< Bit Value =(0x1):TM10 of 32bit */
#define EMB_CR1_WE_MUX_tm10_h1                      ((uint16_t)0x4000)      /*!< Bit Value =(0x1):TM10 of 16bit */
#define EMB_CR1_WE_MUX_tm10_b3                      ((uint8_t )0x40)        /*!< Bit Value =(0x1):TM10 of 8bit */
#define EMB_CR1_WE_MUX_tm16_w                       ((uint32_t)0x80000000)  /*!< Bit Value =(0x2):TM16 of 32bit */
#define EMB_CR1_WE_MUX_tm16_h1                      ((uint16_t)0x8000)      /*!< Bit Value =(0x2):TM16 of 16bit */
#define EMB_CR1_WE_MUX_tm16_b3                      ((uint8_t )0x80)        /*!< Bit Value =(0x2):TM16 of 8bit */
#define EMB_CR1_WE_MUX_tm20_w                       ((uint32_t)0xC0000000)  /*!< Bit Value =(0x3):TM20 of 32bit */
#define EMB_CR1_WE_MUX_tm20_h1                      ((uint16_t)0xC000)      /*!< Bit Value =(0x3):TM20 of 16bit */
#define EMB_CR1_WE_MUX_tm20_b3                      ((uint8_t )0xC0)        /*!< Bit Value =(0x3):TM20 of 8bit */

#define EMB_CR1_OE_MUX_mask_w                       ((uint32_t)0x30000000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_OE_MUX_mask_h1                      ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EMB_CR1_OE_MUX_mask_b3                      ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EMB_CR1_OE_MUX_oe_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):OE of 32bit */
#define EMB_CR1_OE_MUX_oe_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0x0):OE of 16bit */
#define EMB_CR1_OE_MUX_oe_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0x0):OE of 8bit */
#define EMB_CR1_OE_MUX_tm10_w                       ((uint32_t)0x10000000)  /*!< Bit Value =(0x1):TM10 of 32bit */
#define EMB_CR1_OE_MUX_tm10_h1                      ((uint16_t)0x1000)      /*!< Bit Value =(0x1):TM10 of 16bit */
#define EMB_CR1_OE_MUX_tm10_b3                      ((uint8_t )0x10)        /*!< Bit Value =(0x1):TM10 of 8bit */
#define EMB_CR1_OE_MUX_tm16_w                       ((uint32_t)0x20000000)  /*!< Bit Value =(0x2):TM16 of 32bit */
#define EMB_CR1_OE_MUX_tm16_h1                      ((uint16_t)0x2000)      /*!< Bit Value =(0x2):TM16 of 16bit */
#define EMB_CR1_OE_MUX_tm16_b3                      ((uint8_t )0x20)        /*!< Bit Value =(0x2):TM16 of 8bit */
#define EMB_CR1_OE_MUX_tm20_w                       ((uint32_t)0x30000000)  /*!< Bit Value =(0x3):TM20 of 32bit */
#define EMB_CR1_OE_MUX_tm20_h1                      ((uint16_t)0x3000)      /*!< Bit Value =(0x3):TM20 of 16bit */
#define EMB_CR1_OE_MUX_tm20_b3                      ((uint8_t )0x30)        /*!< Bit Value =(0x3):TM20 of 8bit */

#define EMB_CR1_BW1_SWO_mask_w                      ((uint32_t)0x02000000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_BW1_SWO_mask_h1                     ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EMB_CR1_BW1_SWO_mask_b3                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_CR1_BW1_SWO_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define EMB_CR1_BW1_SWO_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define EMB_CR1_BW1_SWO_0_b3                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define EMB_CR1_BW1_SWO_1_w                         ((uint32_t)0x02000000)  /*!< Bit Value =(1):1 of 32bit */
#define EMB_CR1_BW1_SWO_1_h1                        ((uint16_t)0x0200)      /*!< Bit Value =(1):1 of 16bit */
#define EMB_CR1_BW1_SWO_1_b3                        ((uint8_t )0x02)        /*!< Bit Value =(1):1 of 8bit */

#define EMB_CR1_BW1_SWEN_mask_w                     ((uint32_t)0x01000000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_BW1_SWEN_mask_h1                    ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EMB_CR1_BW1_SWEN_mask_b3                    ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EMB_CR1_BW1_SWEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_BW1_SWEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_BW1_SWEN_disable_b3                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_BW1_SWEN_enable_w                   ((uint32_t)0x01000000)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_BW1_SWEN_enable_h1                  ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_BW1_SWEN_enable_b3                  ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_BW0_SWO_mask_w                      ((uint32_t)0x00800000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_BW0_SWO_mask_h1                     ((uint16_t)0x0080)      /*!< Bit Mask of 16bit */
#define EMB_CR1_BW0_SWO_mask_b2                     ((uint8_t )0x80)        /*!< Bit Mask of 8bit */
#define EMB_CR1_BW0_SWO_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define EMB_CR1_BW0_SWO_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define EMB_CR1_BW0_SWO_0_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define EMB_CR1_BW0_SWO_1_w                         ((uint32_t)0x00800000)  /*!< Bit Value =(1):1 of 32bit */
#define EMB_CR1_BW0_SWO_1_h1                        ((uint16_t)0x0080)      /*!< Bit Value =(1):1 of 16bit */
#define EMB_CR1_BW0_SWO_1_b2                        ((uint8_t )0x80)        /*!< Bit Value =(1):1 of 8bit */

#define EMB_CR1_BW0_SWEN_mask_w                     ((uint32_t)0x00400000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_BW0_SWEN_mask_h1                    ((uint16_t)0x0040)      /*!< Bit Mask of 16bit */
#define EMB_CR1_BW0_SWEN_mask_b2                    ((uint8_t )0x40)        /*!< Bit Mask of 8bit */
#define EMB_CR1_BW0_SWEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_BW0_SWEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_BW0_SWEN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_BW0_SWEN_enable_w                   ((uint32_t)0x00400000)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_BW0_SWEN_enable_h1                  ((uint16_t)0x0040)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_BW0_SWEN_enable_b2                  ((uint8_t )0x40)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_ALE2_SWO_mask_w                     ((uint32_t)0x00200000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_ALE2_SWO_mask_h1                    ((uint16_t)0x0020)      /*!< Bit Mask of 16bit */
#define EMB_CR1_ALE2_SWO_mask_b2                    ((uint8_t )0x20)        /*!< Bit Mask of 8bit */
#define EMB_CR1_ALE2_SWO_0_w                        ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define EMB_CR1_ALE2_SWO_0_h1                       ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define EMB_CR1_ALE2_SWO_0_b2                       ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define EMB_CR1_ALE2_SWO_1_w                        ((uint32_t)0x00200000)  /*!< Bit Value =(1):1 of 32bit */
#define EMB_CR1_ALE2_SWO_1_h1                       ((uint16_t)0x0020)      /*!< Bit Value =(1):1 of 16bit */
#define EMB_CR1_ALE2_SWO_1_b2                       ((uint8_t )0x20)        /*!< Bit Value =(1):1 of 8bit */

#define EMB_CR1_ALE2_SWEN_mask_w                    ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_ALE2_SWEN_mask_h1                   ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EMB_CR1_ALE2_SWEN_mask_b2                   ((uint8_t )0x10)        /*!< Bit Mask of 8bit */
#define EMB_CR1_ALE2_SWEN_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_ALE2_SWEN_disable_h1                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_ALE2_SWEN_disable_b2                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_ALE2_SWEN_enable_w                  ((uint32_t)0x00100000)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_ALE2_SWEN_enable_h1                 ((uint16_t)0x0010)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_ALE2_SWEN_enable_b2                 ((uint8_t )0x10)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_ALE_SWO_mask_w                      ((uint32_t)0x00080000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_ALE_SWO_mask_h1                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EMB_CR1_ALE_SWO_mask_b2                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EMB_CR1_ALE_SWO_0_w                         ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define EMB_CR1_ALE_SWO_0_h1                        ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define EMB_CR1_ALE_SWO_0_b2                        ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define EMB_CR1_ALE_SWO_1_w                         ((uint32_t)0x00080000)  /*!< Bit Value =(1):1 of 32bit */
#define EMB_CR1_ALE_SWO_1_h1                        ((uint16_t)0x0008)      /*!< Bit Value =(1):1 of 16bit */
#define EMB_CR1_ALE_SWO_1_b2                        ((uint8_t )0x08)        /*!< Bit Value =(1):1 of 8bit */

#define EMB_CR1_ALE_SWEN_mask_w                     ((uint32_t)0x00040000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_ALE_SWEN_mask_h1                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EMB_CR1_ALE_SWEN_mask_b2                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EMB_CR1_ALE_SWEN_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_ALE_SWEN_disable_h1                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_ALE_SWEN_disable_b2                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_ALE_SWEN_enable_w                   ((uint32_t)0x00040000)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_ALE_SWEN_enable_h1                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_ALE_SWEN_enable_b2                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_CE_SWO_mask_w                       ((uint32_t)0x00020000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_CE_SWO_mask_h1                      ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EMB_CR1_CE_SWO_mask_b2                      ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_CR1_CE_SWO_0_w                          ((uint32_t)0x00000000)  /*!< Bit Value =(0):0 of 32bit */
#define EMB_CR1_CE_SWO_0_h1                         ((uint16_t)0x0000)      /*!< Bit Value =(0):0 of 16bit */
#define EMB_CR1_CE_SWO_0_b2                         ((uint8_t )0x00)        /*!< Bit Value =(0):0 of 8bit */
#define EMB_CR1_CE_SWO_1_w                          ((uint32_t)0x00020000)  /*!< Bit Value =(1):1 of 32bit */
#define EMB_CR1_CE_SWO_1_h1                         ((uint16_t)0x0002)      /*!< Bit Value =(1):1 of 16bit */
#define EMB_CR1_CE_SWO_1_b2                         ((uint8_t )0x02)        /*!< Bit Value =(1):1 of 8bit */

#define EMB_CR1_CE_SWEN_mask_w                      ((uint32_t)0x00010000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_CE_SWEN_mask_h1                     ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EMB_CR1_CE_SWEN_mask_b2                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EMB_CR1_CE_SWEN_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_CE_SWEN_disable_h1                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_CE_SWEN_disable_b2                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_CE_SWEN_enable_w                    ((uint32_t)0x00010000)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_CE_SWEN_enable_h1                   ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_CE_SWEN_enable_b2                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_MAM1_SEL_mask_w                     ((uint32_t)0x00003000)  /*!< Bit Mask of 32bit */
#define EMB_CR1_MAM1_SEL_mask_h0                    ((uint16_t)0x3000)      /*!< Bit Mask of 16bit */
#define EMB_CR1_MAM1_SEL_mask_b1                    ((uint8_t )0x30)        /*!< Bit Mask of 8bit */
#define EMB_CR1_MAM1_SEL_no_w                       ((uint32_t)0x00000000)  /*!< Bit Value =(0x0):No of 32bit */
#define EMB_CR1_MAM1_SEL_no_h0                      ((uint16_t)0x0000)      /*!< Bit Value =(0x0):No of 16bit */
#define EMB_CR1_MAM1_SEL_no_b1                      ((uint8_t )0x00)        /*!< Bit Value =(0x0):No of 8bit */
#define EMB_CR1_MAM1_SEL_mbw1_w                     ((uint32_t)0x00002000)  /*!< Bit Value =(0x2):MBW1 of 32bit */
#define EMB_CR1_MAM1_SEL_mbw1_h0                    ((uint16_t)0x2000)      /*!< Bit Value =(0x2):MBW1 of 16bit */
#define EMB_CR1_MAM1_SEL_mbw1_b1                    ((uint8_t )0x20)        /*!< Bit Value =(0x2):MBW1 of 8bit */
#define EMB_CR1_MAM1_SEL_male2_w                    ((uint32_t)0x00003000)  /*!< Bit Value =(0x3):MALE2 of 32bit */
#define EMB_CR1_MAM1_SEL_male2_h0                   ((uint16_t)0x3000)      /*!< Bit Value =(0x3):MALE2 of 16bit */
#define EMB_CR1_MAM1_SEL_male2_b1                   ((uint8_t )0x30)        /*!< Bit Value =(0x3):MALE2 of 8bit */

#define EMB_CR1_MAD_BSWAP_mask_w                    ((uint32_t)0x00000400)  /*!< Bit Mask of 32bit */
#define EMB_CR1_MAD_BSWAP_mask_h0                   ((uint16_t)0x0400)      /*!< Bit Mask of 16bit */
#define EMB_CR1_MAD_BSWAP_mask_b1                   ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EMB_CR1_MAD_BSWAP_disable_w                 ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_MAD_BSWAP_disable_h0                ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_MAD_BSWAP_disable_b1                ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_MAD_BSWAP_enable_w                  ((uint32_t)0x00000400)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_MAD_BSWAP_enable_h0                 ((uint16_t)0x0400)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_MAD_BSWAP_enable_b1                 ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_MAD_SWAP_mask_w                     ((uint32_t)0x00000200)  /*!< Bit Mask of 32bit */
#define EMB_CR1_MAD_SWAP_mask_h0                    ((uint16_t)0x0200)      /*!< Bit Mask of 16bit */
#define EMB_CR1_MAD_SWAP_mask_b1                    ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_CR1_MAD_SWAP_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_MAD_SWAP_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_MAD_SWAP_disable_b1                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_MAD_SWAP_enable_w                   ((uint32_t)0x00000200)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_MAD_SWAP_enable_h0                  ((uint16_t)0x0200)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_MAD_SWAP_enable_b1                  ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_MA_SWAP_mask_w                      ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EMB_CR1_MA_SWAP_mask_h0                     ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EMB_CR1_MA_SWAP_mask_b1                     ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EMB_CR1_MA_SWAP_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_MA_SWAP_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_MA_SWAP_disable_b1                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_MA_SWAP_enable_w                    ((uint32_t)0x00000100)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_MA_SWAP_enable_h0                   ((uint16_t)0x0100)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_MA_SWAP_enable_b1                   ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_CLK_INV_mask_w                      ((uint32_t)0x00000008)  /*!< Bit Mask of 32bit */
#define EMB_CR1_CLK_INV_mask_h0                     ((uint16_t)0x0008)      /*!< Bit Mask of 16bit */
#define EMB_CR1_CLK_INV_mask_b0                     ((uint8_t )0x08)        /*!< Bit Mask of 8bit */
#define EMB_CR1_CLK_INV_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_CLK_INV_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_CLK_INV_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_CLK_INV_enable_w                    ((uint32_t)0x00000008)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_CLK_INV_enable_h0                   ((uint16_t)0x0008)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_CLK_INV_enable_b0                   ((uint8_t )0x08)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_ALE2_INV_mask_w                     ((uint32_t)0x00000004)  /*!< Bit Mask of 32bit */
#define EMB_CR1_ALE2_INV_mask_h0                    ((uint16_t)0x0004)      /*!< Bit Mask of 16bit */
#define EMB_CR1_ALE2_INV_mask_b0                    ((uint8_t )0x04)        /*!< Bit Mask of 8bit */
#define EMB_CR1_ALE2_INV_disable_w                  ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_ALE2_INV_disable_h0                 ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_ALE2_INV_disable_b0                 ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_ALE2_INV_enable_w                   ((uint32_t)0x00000004)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_ALE2_INV_enable_h0                  ((uint16_t)0x0004)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_ALE2_INV_enable_b0                  ((uint8_t )0x04)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_ALE_INV_mask_w                      ((uint32_t)0x00000002)  /*!< Bit Mask of 32bit */
#define EMB_CR1_ALE_INV_mask_h0                     ((uint16_t)0x0002)      /*!< Bit Mask of 16bit */
#define EMB_CR1_ALE_INV_mask_b0                     ((uint8_t )0x02)        /*!< Bit Mask of 8bit */
#define EMB_CR1_ALE_INV_disable_w                   ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_ALE_INV_disable_h0                  ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_ALE_INV_disable_b0                  ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_ALE_INV_enable_w                    ((uint32_t)0x00000002)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_ALE_INV_enable_h0                   ((uint16_t)0x0002)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_ALE_INV_enable_b0                   ((uint8_t )0x02)        /*!< Bit Value =(1):Enable of 8bit */

#define EMB_CR1_CE_INV_mask_w                       ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EMB_CR1_CE_INV_mask_h0                      ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EMB_CR1_CE_INV_mask_b0                      ((uint8_t )0x01)        /*!< Bit Mask of 8bit */
#define EMB_CR1_CE_INV_disable_w                    ((uint32_t)0x00000000)  /*!< Bit Value =(0):Disable of 32bit */
#define EMB_CR1_CE_INV_disable_h0                   ((uint16_t)0x0000)      /*!< Bit Value =(0):Disable of 16bit */
#define EMB_CR1_CE_INV_disable_b0                   ((uint8_t )0x00)        /*!< Bit Value =(0):Disable of 8bit */
#define EMB_CR1_CE_INV_enable_w                     ((uint32_t)0x00000001)  /*!< Bit Value =(1):Enable of 32bit */
#define EMB_CR1_CE_INV_enable_h0                    ((uint16_t)0x0001)      /*!< Bit Value =(1):Enable of 16bit */
#define EMB_CR1_CE_INV_enable_b0                    ((uint8_t )0x01)        /*!< Bit Value =(1):Enable of 8bit */

///@}
/**
 ******************************************************************************
 * @name        EMB_CR2  [register's definitions]
 *              Offset[0x18]  EMB control register 2 (0x4D020018)
 ******************************************************************************
 */
///@{
#define EMB_CR2_default                             ((uint32_t)0x00100100)  /*!< Reg Reset Default Value */

/* Bit fields of EMB_CR2 */
#define EMB_CR2_IDLE_mask_w                         ((uint32_t)0x03000000)  /*!< Bit Mask of 32bit */
#define EMB_CR2_IDLE_mask_h1                        ((uint16_t)0x0300)      /*!< Bit Mask of 16bit */
#define EMB_CR2_IDLE_mask_b3                        ((uint8_t )0x03)        /*!< Bit Mask of 8bit */

#define EMB_CR2_ACCH_mask_w                         ((uint32_t)0x00100000)  /*!< Bit Mask of 32bit */
#define EMB_CR2_ACCH_mask_h1                        ((uint16_t)0x0010)      /*!< Bit Mask of 16bit */
#define EMB_CR2_ACCH_mask_b2                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define EMB_CR2_ACCW_mask_w                         ((uint32_t)0x000F0000)  /*!< Bit Mask of 32bit */
#define EMB_CR2_ACCW_mask_h1                        ((uint16_t)0x000F)      /*!< Bit Mask of 16bit */
#define EMB_CR2_ACCW_mask_b2                        ((uint8_t )0x0F)        /*!< Bit Mask of 8bit */

#define EMB_CR2_ACCS_mask_w                         ((uint32_t)0x00001000)  /*!< Bit Mask of 32bit */
#define EMB_CR2_ACCS_mask_h0                        ((uint16_t)0x1000)      /*!< Bit Mask of 16bit */
#define EMB_CR2_ACCS_mask_b1                        ((uint8_t )0x10)        /*!< Bit Mask of 8bit */

#define EMB_CR2_ALEH_mask_w                         ((uint32_t)0x00000100)  /*!< Bit Mask of 32bit */
#define EMB_CR2_ALEH_mask_h0                        ((uint16_t)0x0100)      /*!< Bit Mask of 16bit */
#define EMB_CR2_ALEH_mask_b1                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

#define EMB_CR2_ALEW_mask_w                         ((uint32_t)0x00000070)  /*!< Bit Mask of 32bit */
#define EMB_CR2_ALEW_mask_h0                        ((uint16_t)0x0070)      /*!< Bit Mask of 16bit */
#define EMB_CR2_ALEW_mask_b0                        ((uint8_t )0x70)        /*!< Bit Mask of 8bit */

#define EMB_CR2_ALES_mask_w                         ((uint32_t)0x00000001)  /*!< Bit Mask of 32bit */
#define EMB_CR2_ALES_mask_h0                        ((uint16_t)0x0001)      /*!< Bit Mask of 16bit */
#define EMB_CR2_ALES_mask_b0                        ((uint8_t )0x01)        /*!< Bit Mask of 8bit */

///@}

#endif  // _MG32x02z_EMB_H

/*----------------------------------------------------------------------------*/
/*                         End of file MG32x02z_EMB.h                         */
/*----------------------------------------------------------------------------*/
