#include <TimerOne.h>

// This example creates a PWM signal with 25 kHz carrier.
//

const int fanPin = 43;

void setup(void)
{
  Timer1.initialize(40);  // 40 us = 25 kHz
  Serial.begin(9600);
}

void loop(void)
{
  // slowly increase the PWM fan speed
  //
  for (float dutyCycle = 30.0; dutyCycle < 100.0; dutyCycle++) {
    Serial.print("PWM Fan, Duty Cycle = ");
    Serial.println(dutyCycle);
    Timer1.pwm(fanPin, (dutyCycle / 100) * 1023);
    delay(500);
  }
}
