/*
  main.cpp - Main loop for Arduino sketches
  Copyright (c) 2023 megawin Technology Co..  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#define ARDUINO_MAIN
#include "Arduino.h"
#include "MG32x02z_ChipInit.h"
#include "MG32x02z_URT_MID.h"
#include "MG32x02z_CSC_Init.h"

#include "shell.h"



#ifdef __cplusplus
 extern "C" {
#endif



//#include "MG32x02z_USB_DRV.h"

int fputc(int ch, FILE *f __attribute__((unused)));

#if 0
// Force init to be called *first*, i.e. before static object allocation.
// Otherwise, statically allocated objects that need HAL may fail.
__attribute__((constructor(101))) void premain()
{
    // Required by FreeRTOS, see http://www.freertos.org/RTOS-Cortex-M3-M4.html
#ifdef NVIC_PRIORITYGROUP_4
    HAL_NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_4);
#endif
#if (__CORTEX_M == 0x07U)
    // Defined in CMSIS core_cm7.h
#ifndef I_CACHE_DISABLED
    SCB_EnableICache();
#endif
#ifndef D_CACHE_DISABLED
    SCB_EnableDCache();
#endif
#endif

    init();
}

#endif


// Weak empty variant initialization function.
// May be redefined by variant files.

// Initialize C library
extern "C" void __libc_init_array(void);

extern "C"  void Usb_StateHandler(void);

void InitUartPerconstruction(void)
{
    HardwareSerial* lp = NULL;
    megawin_Uart_init();
    lp = lp;
    lp = NULL;

#if 1
#if defined(HWSERIAL0)
    lp = (HardwareSerial*) new HardwareSerial( &mURT0,  
                                                 ARDUINO_PIN_UART0_RX,
                                                 ARDUINO_PIN_UART0_TX, 
                                                 URT0_IRQn );
    if( lp == NULL )
    {
        return;
    }
    memcpy( (void*)&Serial, (void*)lp, sizeof(HardwareSerial) );
    delete lp;
    lp = NULL;
    Serial.begin(DEFAULT_INIT_BAUDRATE);
#endif

#if defined(HWSERIAL1)
    lp = (HardwareSerial*) new HardwareSerial( &mURT1, 
                                              ARDUINO_PIN_UART1_RX,
                                              ARDUINO_PIN_UART1_TX, 
                                              URT123_IRQn );
    if( lp == NULL )
    {
        return;
    }
    memcpy( (void*)&Serial1, (void*)lp, sizeof(HardwareSerial) );
    delete lp;
    lp = NULL;
    Serial1.begin( DEFAULT_INIT_BAUDRATE );
#endif

#if defined(HWSERIAL2)
    lp = (HardwareSerial*) new HardwareSerial( &mURT2,  
                                              ARDUINO_PIN_UART2_RX,
                                              ARDUINO_PIN_UART2_TX, 
                                              URT123_IRQn );
    if( lp == NULL )
    {
        return;
    }
    memcpy( (void*)&Serial2, (void*)lp, sizeof(HardwareSerial) );
    delete lp;
    lp = NULL;
    Serial2.begin( DEFAULT_INIT_BAUDRATE );
#endif

#if defined(URT3)&defined(HWSERIAL3)
    lp = (HardwareSerial*) new HardwareSerial( &mURT3,
                                              ARDUINO_PIN_UART3_RX,
                                              ARDUINO_PIN_UART3_TX, 
                                              URT123_IRQn );
    if( lp == NULL )
    {
        return;
    }
    memcpy( (void*)&Serial3, (void*)lp, sizeof(HardwareSerial) );
    delete lp;
    lp = NULL;
    Serial3.begin( DEFAULT_INIT_BAUDRATE );
#endif

#if defined(HWSERIAL4)
    lp = (HardwareSerial*) new HardwareSerial( &mURT4,  
                                              ARDUINO_PIN_UART4_RX,
                                              ARDUINO_PIN_UART4_TX, 
                                              URT4x_IRQn );
    if( lp == NULL )
    {
        return;
    }
    memcpy( (void*)&Serial4, (void*)lp, sizeof(HardwareSerial) );
    delete lp;
    lp = NULL;
    Serial4.begin( DEFAULT_INIT_BAUDRATE );
#endif

#if defined(HWSERIAL5)
    lp = (HardwareSerial*) new HardwareSerial( &mURT5,  
                                              ARDUINO_PIN_UART5_RX,
                                              ARDUINO_PIN_UART5_TX, 
                                              URT4x_IRQn );
    if( lp == NULL )
    {
        return;
    }
    memcpy( (void*)&Serial5, (void*)lp, sizeof(HardwareSerial) );
    delete lp;
    lp = NULL;
    Serial5.begin( DEFAULT_INIT_BAUDRATE );
#endif

#if defined(HWSERIAL6)
    lp = (HardwareSerial*) new HardwareSerial( &mURT6, 
                                              ARDUINO_PIN_UART6_RX,
                                              ARDUINO_PIN_UART6_TX, 
                                              URT4x_IRQn );
    if( lp == NULL )
    {
        return;
    }
    memcpy( (void*)&Serial6, (void*)lp, sizeof(HardwareSerial) );
    delete lp;
    lp = NULL;
    Serial6.begin( DEFAULT_INIT_BAUDRATE );
#endif

#if defined(HWSERIAL7)
    lp = (HardwareSerial*) new HardwareSerial( &mURT7,  
                                              ARDUINO_PIN_UART7_RX,
                                              ARDUINO_PIN_UART7_TX, 
                                              URT4x_IRQn );
    if( lp == NULL )
    {
        return;
    }
    memcpy( (void*)&Serial7, (void*)lp, sizeof(HardwareSerial) );
    delete lp;
    lp = NULL;
    Serial7.begin( DEFAULT_INIT_BAUDRATE );
#endif

#endif
}




/*
 * \brief Main entry point of Arduino application
 */

int main()
{
    init();

    InitUartPerconstruction();
    initVariant();

    MID_Delay(10);

    __libc_init_array();

#if defined(USBCON)
//    USBDevice.init();
//    USBDevice.attach();
#endif

    setup();
    
    #if defined(SHELL_DEBUG)
    DebugShell.Init( &Serial );
    #endif

    for(;;) 
    {
        #if defined(SHELL_DEBUG)
        DebugShell.Run();
        #endif

        Usb_StateHandler();

#if defined(CORE_CALLBACK)
        CoreCallback();
#endif

        loop();

        if (serialEventRun)
        {
            serialEventRun();   
        }
    }

    return 0;
}



#ifdef __cplusplus
}
#endif




