/**
 ******************************************************************************
 *
 ******************************************************************************
 * @file    interrupt.H
 * @author  cuij
 * @version V1.0.0
 * @date    11-01-2023
 * @brief   The  code is that use adapted to Arduino interface
 *
 * @par         Project
 *              MG32x02z
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2023 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
  ******************************************************************************
  Copyright (c) 2023 megawin Technology Co., Ltd. All rights reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __INTERRUPT_H
#define __INTERRUPT_H

/* Includes ------------------------------------------------------------------*/
#include "MG32x02z.h"
#include "system_MG32x02z.h"
#include "MG32x02z_CSC_Init.h"
#include "MG32x02z_GPIO_MID.h"
#include "MG32x02z_EXIC_MID.h"
#include "MG32x02z_EXIC_DRV.h"
//#include "hw_config.h"

#ifdef __cplusplus
 extern "C" {
#endif

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
// void MID_EXIC_AFCallback( EXIC_HandleTypeDef* MEXIC_PX);
// void MID_EXIC_OFCallback( EXIC_HandleTypeDef* MEXIC_PX );


void megawin_ExicInterruptSet(  uint16_t  AdrIdx,  void (*callback)(void),    uint32_t mode );

void megawin_ExicInterruptEnablePort( GPIO_Struct *port );
void megawin_ExicInterruptDisable( uint16_t  AdrIdx );

void Megawin_EXIC_Init(void);



#ifdef __cplusplus
}
#endif










#ifdef __cplusplus
 extern "C" {
#endif



#ifdef __cplusplus
}
#endif





#endif /* __INTERRUPT_H */

/*********COPYRIGHT(c) 2022 megawin Technology Co., Ltd *****END OF FILE****/


