#ifndef  _USBSERIAL_DEF_H_
#define  _USBSERIAL_DEF_H_

 
#include "MG32x02z.h" 

#define    EP0_PACKET_SIZE        8                                       /*!< Maximum packet size for EP0.*/
#define    EP1_PACKET_SIZE        64                                      /*!< Maximum packet size for EP1.*/
#define    EP2_PACKET_SIZE        64                                      /*!< Maximum packet size for EP2.*/
#define    EP3_PACKET_SIZE        64                                      /*!< Maximum packet size for EP3.*/ 


typedef struct
{    
    uint8_t    Flag;                                                /*!< Set by Host setting occur .*/
    uint8_t    StopBit;                                             /*!< Stop bit.*/
    uint8_t    Parity;                                              /*!< Parity bit type.*/
    uint8_t    DataBit;                                             /*!< Data bits.*/
    ctype      BaudRate;                                            /*!< Data terminal rate ,in bits per second.*/
}COM_LineCoding_TypeDef;


typedef struct
{    
    uint8_t   Flag;                                                   /*!< The flag is that receive SetControlLineState request.*/
    uint8_t   __Padding;                                              /*!< Reserved byte.*/
    union
    {
        __IO uint16_t  H;
        __IO uint8_t   B[2];
        struct
        {
            __IO uint8_t DTE_EN               : 1;                    /*!< Indicates to DCE if DTE is present or not. This signal corresponds to V.24 signal 108/2 and RS-232 signal DTR.
                                                                               0 - Not Present.
                                                                               1 - Present.
                                                                      */
            __IO uint8_t CarrierControl_EN    : 1;                    /*!< Carrier control for half duplex moderns. This signal corresponds to V.24 signal 105 and RS-232 siganl RTS.
                                                                               0 - Deactivate carrier
                                                                               1 - Activate carrier
                                                                           The device ignores the value of this bit when operating in full duplex mode.
                                                                      */
            __IO uint8_t                      : 6;                    /*! RESERVED (Reset to zero) .*/
            __IO uint8_t                      : 8;                    /*! RESERVED (Reset to zero) .*/
        }MBIT;
    }ControlSignalBitmp;
}COM_LineState_TypeDef;



typedef struct
{    
    uint8_t   Flag;                                                    /*!< The flag is that receive SEND_BREAK request.*/
    uint8_t   __Padding;                                               /*!< Reserved byte.*/
    union
    {
        __IO uint16_t  H;
        __IO uint8_t   B[2];
    }DurationTime;                                                     /*!< The value field contains the length of time , in milliseconds , of the break singal.
                                                                            If the value contains a value of FFFFh, then the device will send a break until another 
                                                                            SendBreak request is received with the value of 0000h.
                                                                       */
}COM_SendBreak_TypeDef;



typedef struct
{    
    uint8_t                COM_USB_StatusUpstream_Busy;            /*!< The flag is that the device is transmitting COM status .*/
                           
    uint8_t                COM_USB_DataUpstream_Busy;              /*!< The flag is that the device is transmitting data to USB. */
    uint8_t                COM_USB_DataUpstream_OverrunFlag;       /*!< The flag is that the device software RX buffer overflow.*/
                           
    uint8_t                COM_USB_DataDownstream_Busy;            /*!< The flag is that the device is transmitting data to URT*/
    uint32_t               COM_USB_DataDownstream_Size;            /*!< The URT TX transmit data size in this time.*/
    
    COM_LineCoding_TypeDef LineCoding;                             /*!< Line coding relationship parameter.*/
    COM_LineState_TypeDef  LineState;                              /*!< Line state relationship parameter.*/
    COM_SendBreak_TypeDef  SendBreak;                              /*!< Send break relationship parameter*/
    
#if API_COM_BRIDGE_DEVICE == API_COM_BRIDGE_DEVICE_UART
    uint8_t                COM_Status_EP_SRAM[10];                 /*!< Serial state save SRAM address.*/
    uint8_t                Status;                                 /*!< Serial state */
    uint8_t                __Padding[1];                           /*!< Reserved byte.*/
#endif
    
    
}COM_TypeDef;


#endif

