///////////////////////////////////////////////////
//
//	FILE:		MPC82x54_SPI_Slave.A51
//	AUTHOR:		Neo (Hsin-Chih Lin)
//	COPYRIGHT:	(c) Megawin Technology Co., Ltd.
//	CREATED:	2007.10.04
//	PURPOSE:	Demo SPI Function
//
///////////////////////////////////////////////////
//#define DEBUG
#ifdef DEBUG
#include "DEBUG.INC"
#endif
#define MEGAWINIC	MPC82G516
#define MPC82x54	1
#define MPC82G516	2
#if (MEGAWINIC==MPC82G516)
#include "REG_MPC82G516.INC"
#else
#include "REG_MPC82L54.INC"
#endif

	ORG		0000H	
	JMP		START
///////////////////////////////////////////////////
//
//	Function:SPI_Interrupt()
//	82G516 SPI interrupt table is 43H
//	82x54 SPI interrupt table is 2BH
//
///////////////////////////////////////////////////
#if (MEGAWINIC==MPC82G516)
	ORG		0043H
#else
	ORG		002BH
#endif
	JMP		SPI_INT
	ORG		0050H
///////////////////////////////////////////////////
//
//	MainLoop()
//
///////////////////////////////////////////////////
START:
#ifdef DEBUG
	MOV		SP,#02FH
	Debug_clear_LCD
#endif
	MOV		R0,#00H						//set R0 is data point
//  enable Interrupt
#if (MEGAWINIC==MPC82G516)
    MOV     IE,#080H
	MOV		AUXIE,#01H
#else
	MOV		IE,#0C0H
#endif
	MOV		SPCTL,#040H					//Set SPI to Slave
MAIN_LOOP:
	CJNE	R0,#010H,MAIN_LOOP
#ifdef DEBUG
	MOV		R0,#00h
SHOW_LOOP:
	MOVX	A,@R0
;	MOV		A,@R0
	Debug_show_msg_to_LCD ACC
	INC		R0
	CJNE	R0,#010H,SHOW_LOOP
	MOV		R0,#00H
#endif
	CLR		EA							//Disable Interrupt
	MOV		SPCTL,#0D0H					//Set SPI to Master
	MOV		R6,#00H
FOR_LOOP:
	CLR		P1.4
	MOV		SPDAT,R6
WAIT_TRANSMIT:
	MOV		A,SPSTAT
	CJNE	A,#080H,WAIT_TRANSMIT
	MOV		SPSTAT,#080H
	SETB	P1.4
	MOV		R5,#05AH
DELAY:
	NOP
	DJNZ	R5,DELAY
	INC		R6
	CJNE	R6,#010H,FOR_LOOP
	MOV		R0,#00H
LOOP:
    SJMP    LOOP
SPI_INT:
	MOV		SPSTAT,#080H
	MOV		A,SPDAT
	MOVX	@R0,A
;	MOV		@R0,SPDAT
	INC		R0
	RETI
	END
