///////////////////////////////////////////////////
//
//	FILE:		MPC82_PCA_Capture_Demo.A51
//	AUTHOR:		Neo (Hsin-Chih Lin)
//	COPYRIGHT:	(c) Megawin Technology Co., Ltd.
//	CREATED:	2008.5.20
//	PURPOSE:	Demo PCA_Capture Function
//
///////////////////////////////////////////////////
#include "REG_MPC82G516.INC"

//#define DEBUG
#ifdef DEBUG
#include "debug.inc"
#endif

invert_count    EQU     00H
i               EQU     01H
capture_high    EQU     10H
capture_low     EQU     20H
save_count      EQU     30H

    ORG		0000H	
    JMP		START
    ORG	    0053H
    JMP     PCA_INTERRUPT
    ORG		60H

///////////////////////////////////////////////////
//
//  Function:Main()
//  Purpose :PCA capture demo software
//
///////////////////////////////////////////////////
START:
#ifdef DEBUG
    MOV     SP,#40H
    Debug_clear_LCD
#endif
    MOV     invert_count,#010H
    LCALL   Initial
LOOP:
    MOV     R7,i
    INC     i
    MOV     A,R7
    SETB    C
    SUBB    A,invert_count
    JC      LOOP
    CPL     P3.4
    MOV     A,#05H
    ADD     A,invert_count
    MOV     invert_count,A
    CLR     A
    MOV     i,A
    SJMP    LOOP
///////////////////////////////////////////////////
//
//	Function:Initial()
//  Purpose :Initial PCA parameter
//
///////////////////////////////////////////////////
Initial:
    MOV     CMOD,#02H
    MOV     CCAPM0,#011H
    SETB    EA
    ORL     AUXIE,#04H
    ORL     CCON,#040H
    RET     
///////////////////////////////////////////////////
//
//	Function:PCA_Interrupt()
//  Purpose :Save capture count 
//
///////////////////////////////////////////////////
PCA_INTERRUPT:
    PUSH    ACC
    PUSH    B
    PUSH    DPH
    PUSH    DPL
    PUSH    PSW
    MOV     PSW,#08H
    CLR     EA
    MOV     CCON,#00H
    MOV     CL,#00H
    MOV     CH,#00H
    MOV     A,#LOW capture_high
    ADD     A,save_count
    MOV     R0,A
    MOV     @R0,CCAP0H
    MOV     A,#LOW capture_low
    ADD     A,save_count
    MOV     R0,A
    MOV     @R0,CCAP0L
    INC     save_count
#ifdef DEBUG
    MOV     A,save_count
    XRL     A,#08H
    JNZ     NO_SHOW_MSG
    MOV     i,A
SHOW_MSG:
    MOV     A,#LOW capture_high
    ADD     A,i
    MOV     R0,A
    MOV     A,@R0
    Debug_show_msg_to_LCD A
    MOV     A,#LOW capture_low
    ADD     A,i
    MOV     R0,A
    MOV     A,@R0
    Debug_show_msg_to_LCD A
    INC     i
    MOV     A,i
    CLR     C
    SUBB    A,#08H
    JC      SHOW_MSG
    Debug_set_breakpoint #01H
NO_SHOW_MSG:
#endif
    SETB    EA
    ORL     CCON,#040H
    POP     PSW
    POP     DPL
    POP     DPH
    POP     B
    POP     ACC
    RETI    
    END
