///////////////////////////////////////////////////
//
//  FILE:       MPC82_PCA_Capture_Demo.c
//  AUTHOR:	    Neo (Hsin-Chih Lin)
//  COPYRIGHT:  (c) Megawin Technology Co., Ltd.
//  CREATED:    2009/7/10
//  PURPOSE:    Demo PCA_Capture Function
//  VERSION:    1.1
//
///////////////////////////////////////////////////

#define MPC82G516
//#define MPC82x54

#ifdef MPC82G516
#include "REG_MPC82G516.H"
#else
#include "REG_MPC82L54.H"
#endif
//#define DEBUG
#ifdef DEBUG
#include "debug.h"
#endif

void Initial();
///////////////////////////////////////////////////
//
//  Function:Main()
//  Purpose :PCA capture demo software
//
///////////////////////////////////////////////////
void Main()
{
    unsigned char invert_count,i;
#ifdef DEBUG
    Debug_clear_LCD();
#endif
    invert_count = 0x10;
    Initial();
	while (1) 
    {
        if(i++ > invert_count)
        {
            P34 = !P34;
            invert_count += 0x5;
            i = 0;
        }
    }
}
///////////////////////////////////////////////////
//
//	Function:Initial()
//  Purpose :Initial PCA parameter
//
///////////////////////////////////////////////////
void Initial()
{
//  CMOD	=	0x00;				//Set PCA Mode (PCA clock source as OSC/12)
    CMOD	=	0x02;				//Set PCA Mode (PCA clock source as OSC/2)
//  CMOD	=	0x04;				//Set PCA Mode (PCA clock source as Timer 0-Overflow)
//  CMOD	=	0x06;				//Set PCA Mode (PCA clock source as ECI(P3.4))
	CCAPM0	=	0x11;				//Configure PCA Module0 to Capture(negative-edge) and Interrupt 
//	CCAPM1	=	0x21;				//Configure PCA Module1 to Capture(positive-edge) and Interrupt 
//	CCAPM2	=	0x31;				//Configure PCA Module2 to Capture(transition) and Interrupt 
//	CCAPM3	=	0x21;				//Configure PCA Module3 to Capture and Interrupt 
//	CCAPM4	=	0x21;				//Configure PCA Module4 to Capture and Interrupt (Only for MPC82G516)
//	CCAPM5	=	0x21;				//Configure PCA Module5 to Capture and Interrupt (Only for MPC82G516)
    EA      =   0x01;               //Enable All Interrupt
#ifdef MPC82G516
    AUXIE   |=  0x04;               //Enable PCA Interrupt
#else
    EPCALVD =   0x01;               //Enable PCA and LVD Interrupt
#endif
    CCON    |=  0x40;               //Start PCA Counter
}
///////////////////////////////////////////////////
//
//	Function:PCA_Interrupt()
//  Purpose :Save capture count 
//
///////////////////////////////////////////////////
unsigned char capture_high[8],capture_low[8],save_count=0;
#ifdef MPC82x54
void PCA_Interrupt() interrupt 6 using 1
#else
void PCA_Interrupt() interrupt 10 using 1
#endif
{
#ifdef DEBUG
    unsigned char i;
#endif
    EA      =   0;
    CCON    =   0x00;               //Stop PCA Counter and clear PCA interrupt flag
    CH = CL =   0;
    capture_high[save_count] = CCAP0H;
    capture_low[save_count] = CCAP0L;
    save_count++;
#ifdef DEBUG
    if(save_count==0x08)            //When save 8 capture show out and stop.
    {
        for(i=0;i<8;i++)
        {
            Debug_show_msg_to_LCD(capture_high[i]);
            Debug_show_msg_to_LCD(capture_low[i]);
        }
        Debug_set_breakpoint(1);
    }
#endif
    EA      =   1;
    CCON    |=  0x40;               //Start PCA Counter
}
