;*** Functions used by other modules ***

;For Keil A51, $INCLUDE (G516Flash.inc), to use the following macros:
;
;    (1) G516Flash_enable XTAL_freq
;    (2) G516Flash_disable
;    (3) G516Flash_mass_erase
;    (4) G516Flash_page_erase page_addrH,page_addrL
;    (5) G516Flash_byte_program byte_addrH,byte_addrL,data_to_be_programmed
;    (6) G516Flash_byte_read byte_addrH,byte_addrL,data_to_be_returned

;! Note: The R5, R6 and R7 are dedicated for the arguments passing, the user
;        should not use these registers for other use.

;------------------------------------------------------------------------------
; Macro Definition
;------------------------------------------------------------------------------
;macro-1: enable the Flash
;
G516Flash_enable MACRO XTAL_freq
         MOV    R7,XTAL_freq
         CALL   _FlashG516_enable
         ENDM

;macro-2: disable the Flash
;
G516Flash_disable MACRO
         CALL   FlashG516_disable
         ENDM

;macro-3: erase ALL the Flash
;
G516Flash_mass_erase MACRO
         CALL   FlashG516_mass_erase
         ENDM

;macro-4: erase one-page (512 bytes) in the Flash
;
G516Flash_page_erase MACRO addrH,addrL
         MOV    R6,addrH ;page address, High-byte
         MOV    R7,addrL ;page address, Low-byte
         CALL   _FlashG516_page_erase
         ENDM

;macro-5: program data to Flash
;
G516Flash_byte_program MACRO addrH,addrL,src
         MOV    R6,addrH ;byte address, High-byte
         MOV    R7,addrL ;byte address, Low-byte
         MOV    R5,src   ;data
         CALL   _FlashG516_byte_program
         ENDM

;macro-6: read byte from Flash
;
G516Flash_byte_read MACRO addrH,addrL,dst
         MOV    R6,addrH ;byte address, High-byte
         MOV    R7,addrL ;byte address, Low-byte
         CALL   _FlashG516_byte_read
         MOV    dst,R7   ;data returned
         ENDM

;------------------------------------------------------------------------------
; Function Declaration
;------------------------------------------------------------------------------

EXTRN    CODE   (_FlashG516_enable)
EXTRN    CODE   (FlashG516_disable)
EXTRN    CODE   (FlashG516_mass_erase)
EXTRN    CODE   (_FlashG516_page_erase)
EXTRN    CODE   (_FlashG516_byte_program)
EXTRN    CODE   (_FlashG516_byte_read)

