
#define		uCHAR	unsigned char
#define		uINT	unsigned short
#define		uLONG	unsigned long

#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00


#include "REG_MG84FG516.H"
#include "delay.H"
#include "debug.H"

uCHAR	ADC_H;
uCHAR	ADC_L;
uCHAR	tmp;
uCHAR	i;




void PageP_Write( uCHAR Addr , uCHAR Data )
  { ISPCR = ISP_ENABLE;
    IFADRH = 0x00;
    IFADRL = Addr;
    IFD = Data;
    IFMT = 0x04;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;
  }

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	ISPCR = ISP_ENABLE;
    IFADRH = 0x00;
    IFADRL = Addr;
    IFMT = 0x05;
    SCMD = 0x46;
    SCMD = 0xB9;
	Data = IFD;
    ISPCR = ISP_DISABLE;
	
	return Data;
}

void Timer3_Initial(void)
{
	SFRPI = 0x01;
	T3CON = 0x00;
	T3MOD = 0x00;
	RCAP3H = 0xFE;
	RCAP3L = 0xE3;
	TH3 = 0xFE;
	TL3 = 0xE3;
	TR3 = 1;
	SFRPI = 0x00;
}

void ADC_Initial(void)
{
	ADCON0 = 0x80;						//enable ADC and select channel P1.0
	ADCFG0 = 0xF0;						//ADC clk is T3 Over flow, ADRJ = 1
//	ADCFG0 = 0xB0;						//ADC clk is Sysclk / 64, ADRJ = 1
	
	P1AIO = 0xFF;						//configure P1 as input only mode
}

void Select_Input_Ch0(void)
{
	ADCON0 &= 0xF0;
}

void Select_Input_Ch1(void)
{
	ADCON0 &= 0xF0;
	ADCON0 |= 0x01;
}

void Select_Input_Ch2(void)
{
	ADCON0 &= 0xF0;
	ADCON0 |= 0x02;
}

void Select_Input_Ch3(void)
{
	ADCON0 &= 0xF0;
	ADCON0 |= 0x03;
}

void Select_Input_Ch4(void)
{
	ADCON0 &= 0xF0;
	ADCON0 |= 0x04;
}

void Select_Input_Ch5(void)
{
	ADCON0 &= 0xF0;
	ADCON0 |= 0x05;
}

void Select_Input_Ch6(void)
{
	ADCON0 &= 0xF0;
	ADCON0 |= 0x06;
}

void Select_Input_Ch7(void)
{
	ADCON0 &= 0xF0;
	ADCON0 |= 0x07;
}

void ADC_Start(void)
{
	ADCON0 |= 0x08;						//start AD conversion
	while(!(ADCON0 & 0x10));			//wait AD conversion finish
	ADCON0 &= 0xEF;						//Clear ADC interrupt flag
}

void main(void)
{
    CKCON0 |= 0x40;                              //ENCKM
	Timer3_Initial();
	ADC_Initial();
	Select_Input_Ch0();
	delay_ms(3);
	
	tmp = PageP_Read(0x44);						//PCON2
	tmp |= 0x80;								//HSE
	PageP_Write(0x44, tmp);
	
	tmp = PageP_Read(0x40);						//CKCON2
	tmp &= ~0x04;
	tmp |= 0x08;
	PageP_Write(0x40, tmp);
	i = 30;
	
	while(i)
	{
		
		ADC_Start();
		ADC_H = ADCDH;					//get ADC value
		ADC_L = ADCDL;
		Select_Input_Ch1();
		dbg_show_msg_to_PC(ADC_H);
		dbg_show_msg_to_PC(ADC_L);

		ADC_Start();
		ADC_H = ADCDH;					//get ADC value
		ADC_L = ADCDL;
		Select_Input_Ch2();
		dbg_show_msg_to_PC(ADC_H);
		dbg_show_msg_to_PC(ADC_L);

		ADC_Start();
		ADC_H = ADCDH;					//get ADC value
		ADC_L = ADCDL;
		Select_Input_Ch3();
		dbg_show_msg_to_PC(ADC_H);
		dbg_show_msg_to_PC(ADC_L);

		ADC_Start();
		ADC_H = ADCDH;					//get ADC value
		ADC_L = ADCDL;
		Select_Input_Ch4();
		dbg_show_msg_to_PC(ADC_H);
		dbg_show_msg_to_PC(ADC_L);

		ADC_Start();
		ADC_H = ADCDH;					//get ADC value
		ADC_L = ADCDL;
		Select_Input_Ch5();
		dbg_show_msg_to_PC(ADC_H);
		dbg_show_msg_to_PC(ADC_L);

		ADC_Start();
		ADC_H = ADCDH;					//get ADC value
		ADC_L = ADCDL;
		Select_Input_Ch6();
		dbg_show_msg_to_PC(ADC_H);
		dbg_show_msg_to_PC(ADC_L);

		ADC_Start();
		ADC_H = ADCDH;					//get ADC value
		ADC_L = ADCDL;
		Select_Input_Ch7();
		dbg_show_msg_to_PC(ADC_H);
		dbg_show_msg_to_PC(ADC_L);

		ADC_Start();
		ADC_H = ADCDH;					//get ADC value
		ADC_L = ADCDL;
		Select_Input_Ch0();
		dbg_show_msg_to_PC(ADC_H);
		dbg_show_msg_to_PC(ADC_L);


		i --;
	}
	
	while(1);
}
