

#define		uCHAR	unsigned char
#define		uINT	unsigned short
#define		uLONG	unsigned long

#include "REG_MG84FG516.H"


#define		T0_1MSL				0x18                  // ( 65536 - 1000 )%256 in 12Mhz
#define		T0_1MSH				0xFC                  // ( 65536 - 1000 )/256 in 12Mhz

#define		ISP_ENABLE			0x80
#define		ISP_DISABLE			0x00

uCHAR T0Cnt;

void PageP_Write( uCHAR Addr , uCHAR Data )
  { ISPCR = ISP_ENABLE;
    IFADRH = 0x00;
    IFADRL = Addr;
    IFD = Data;
    IFMT = 0x04;
    SCMD = 0x46;
    SCMD = 0xB9;
    ISPCR = ISP_DISABLE;
  }

uCHAR PageP_Read(uCHAR	Addr)
{
	uCHAR	Data;

	ISPCR = ISP_ENABLE;
    IFADRH = 0x00;
    IFADRL = Addr;
    IFMT = 0x05;
    SCMD = 0x46;
    SCMD = 0xB9;
	Data = IFD;
    ISPCR = ISP_DISABLE;
	
	return Data;
}

void Delay_Xms( uCHAR X )
{
	TR0 = 0;                                   // Disable Timer0

	T0Cnt = X;                                   // X*1ms = Xms

	TL0 = T0_1MSL;
	TH0 = T0_1MSH;
	TR0 = 1;                                   // Enable Timer0
	while( T0Cnt );
}

void INT_TIMER0(void) interrupt 1 using 1        // Timer0 Interrupt
{
	TR0 = 0;                                   // Disable Timer0

	if ( T0Cnt )
	{
		T0Cnt--;
		TL0 = T0_1MSL;
		TH0 = T0_1MSH;
		TR0 = 1;                               // Enable Timer0
	}
}
void Initial_UART1(void)						//Baud Rate 115200bps
{
	S1CFG = 0x1C;								//S1TR, S1MOD1, S1TX12 = 1;
	SFRPI = 0x01;
	S1CON = 0x50;
	S1BRT = 243;
	SFRPI = 0x00;

	P1M0 = 0x08;								//add I/O push-pull high, this is strong pull-high.
}

void MCU_Run_24MHz(void)
{
	uCHAR	tmp;
	
	tmp = PageP_Read(0x44);						//PCON2
	tmp |= 0x80;								//HSE
	PageP_Write(0x44, tmp);
	
	tmp = PageP_Read(0x40);						//CKCON2
	tmp |= 0x04;
	PageP_Write(0x40, tmp);						//MCU run 24MHz

}

void UART1_Send_Byte(uCHAR dta)
{
	SFRPI = 0x01;
	S1BUF = dta;
	while(TI1 == 0);
	TI1 = 0;
	SFRPI = 0x00;
}

void main()
{

    TMOD = 0x01;                                 // Set Timer0/1 in Mode1/2 ( 16/8 bit )
    ET0 = 1;                                     // Enable Timer0 interrupt
	
    CKCON0 |= 0x40;                              //ENCKM
	EA = 1;
	
	Delay_Xms(5);

	MCU_Run_24MHz();

	Initial_UART1();
	UART1_Send_Byte(0x5A);


	while(1);
}
