/**
  ******************************************************************************
 *
 * @file        Sample_MID_TM20_8bitx2_OC.c
 *
 * @brief       Initial TM20 8bitx2 output compare mode
 *
 * @par         Project
 *              MG32
 * @version     V1.13
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_TM_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static TM_HandleTypeDef    mTM20;

/* Private function prototypes -----------------------------------------------*/
void Sample_MID_TM20_8bitx2_OC(void);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    Initial TM20 8bitx2 output compare mode.
 * @details     1.initial TM20 for 10-bit resolution of 8Bitx2 OC.
 *    \n        2.clock initial.
 *    \n        3.Pin initial for OC 2's complment (Channel-0~1).
 *    \n        4.Enable OC output with Non-Blocking mode.
 *    \n        5.Update duty cycle.
 * @return      None
 *******************************************************************************
 */
void Sample_MID_TM20_8bitx2_OC(void)
{  
    TM_ClockConfigTypeDef CKConfig;
    TM_OC_InitTypeDef   sConfig;

    // make sure :
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //  Select CK_PLLI Divider = CK_HS/2
    //  Select CK_PLL Multiplication factor = CK_PLLIx16
    //  Select CK_PLLO Divider = CK_PLL/4
    //Select CK_MAIN Source = CK_PLLO
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->TM20 = Enable
	
    //==Set GPIO init 
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOC->PC0,PC2
    //GPIO port initial is 0xFFFF
    //PC0,PC2 mode is PPO
    //PC0,PC2 function TM20_OC00/TM20_OC10
    
    //==Set GPIO init 
    //MG32_GPIO_Init.h(Configuration Wizard)->Use GPIOC->PC8,PC9
    //GPIO port initial is 0xFFFF
    //PC8,PC9 mode is PP0
    //PC8,PC9 function TM20_OC0H/TM20_OC1H
    
    // ------------------------------------------------------------------------
    // 1.initial TM20 for 10-bit resolution of 8Bitx2 OC.
    // ------------------------------------------------------------------------
    mTM20.Instance                  = TM20;
    mTM20.Init.TM_CounterMode       = TM_CASCADE_UP;
    mTM20.Init.TM_Period            = 1023;
    mTM20.Init.TM_Prescaler         = 0;
    MID_TM_8Bx2OC_Init(&mTM20);
    
    // ------------------------------------------------------------------------
    // 2.clock initial.
    // ------------------------------------------------------------------------
    CKConfig.TM_ClockSource         = TM_INTERNAL_CLOCK;
    CKConfig.TM_ExternalClockSource = 0;
    CKConfig.TM_INTClockDivision    = TM_INTERNALCLOCK_DIVDER_DIV1;
    CKConfig.TM_InternalClockSource = TM_INTERNALCLOCK_PROC;
    MID_TM_ConfigClockSource(&mTM20, &CKConfig);  

    // ------------------------------------------------------------------------
    // 3.Pin initial for PWM 2's complment (Channel-0~2).
    // ------------------------------------------------------------------------
    MID_TM_OC_Struct_Init(&sConfig);
    sConfig.OCMode  = TM_CH_8bitx2_OutputCompare;
    sConfig.Pulse   = 0x11AA;                           // duty cycle of channel0
    MID_TM_OC_ConfigChannel(&mTM20, &sConfig, MID_TM_Channel0);

    sConfig.Pulse   = 0x44EE;                           // duty cycle of channel1
    MID_TM_OC_ConfigChannel(&mTM20, &sConfig, MID_TM_Channel1);
    
    // ------------------------------------------------------------------------
    // 4.Enable OC output with Non-Blocking mode.
    // ------------------------------------------------------------------------
    MID_TM_8Bx2OC_Start(&mTM20, MID_TM_Channel0);       // Non-Blocking mode     
    MID_TM_8Bx2OC_Start(&mTM20, MID_TM_Channel1);       // Non-Blocking mode
    
    // to do ...


    
    // ------------------------------------------------------------------------
    // 5.Update duty cycle.
    // ------------------------------------------------------------------------
    __DRV_TM_SET_COMPARE_B(&mTM20, MID_TM_Channel0, 0x44EE);
    __DRV_TM_SET_COMPARE_B(&mTM20, MID_TM_Channel1, 0x11AA);



}


