/**
  ******************************************************************************
 *
 * @file        Sample_MID_TM00_Period.c
 *
 * @brief       TM00 period entry interrupt.
 *
 * @par         Project
 *              MG32
 * @version     V1.12
 * @date        2021/05/27
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
* @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 ******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32_TM_MID.h"
#include "RTE_Components.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static TM_HandleTypeDef mTM00;

/* Private function prototypes -----------------------------------------------*/
void Sample_MID_TM00_Period(void);
void TM0x_IRQHandler(void);
void MID_TM_PeriodElapsedCallback(TM_HandleTypeDef* mTM);

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    TM00 period entry interrupt.
 * @details     1.Initial TM00. 
 *    \n        2.Initial clock.
 *    \n        3.Enable TM00 and IT.
 * @return      None
 *******************************************************************************
 */
void Sample_MID_TM00_Period(void)
{  
    TM_ClockConfigTypeDef CKConfig;

    // make sure :
    
    //===Set CSC init====
    //MG32_CSC_Init.h(Configuration Wizard)
    //Select CK_HS source = CK_IHRCO
    //Select IHRCO = 12M
    //  Select CK_PLLI Divider = CK_HS/2
    //  Select CK_PLL Multiplication factor = CK_PLLIx16
    //  Select CK_PLLO Divider = CK_PLL/4
    //Select CK_MAIN Source = CK_PLLO
    //Configure PLL->Select APB Prescaler = CK_MAIN/1
    //Configure Peripheral On Mode Clock->TM00 = Enable
	    
    // ------------------------------------------------------------------------
    // 1.Initial TM00. 
    // ------------------------------------------------------------------------
    mTM00.Instance                  = TM00;
    mTM00.Init.TM_CounterMode       = TM_CASCADE_UP;
    mTM00.Init.TM_Period            = 25;
    mTM00.Init.TM_Prescaler         = 25;
    MID_TM_Base_Init(&mTM00);
    
    // ------------------------------------------------------------------------
    // 2.Initial clock.
    // ------------------------------------------------------------------------
    CKConfig.TM_ClockSource         = TM_INTERNAL_CLOCK;
    CKConfig.TM_ExternalClockSource = 0;
    CKConfig.TM_INTClockDivision    = TM_INTERNALCLOCK_DIVDER_DIV1;
    CKConfig.TM_InternalClockSource = TM_INTERNALCLOCK_PROC;
    MID_TM_ConfigClockSource(&mTM00, &CKConfig);  

    // ------------------------------------------------------------------------
    // 3.Enable TM00 and IT.
    // ------------------------------------------------------------------------
    #ifndef MG32_TM00_IRQ_
        NVIC_EnableIRQ(TM0x_IRQn);
    #endif
    
    MID_TM_Base_Start_IT(&mTM00);

}
/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
#ifndef MG32_TM00_IRQ_
void TM0x_IRQHandler(void)
{
    // ------------------------------------------------------------------------
    // TM00 ISR
    MID_TM_IRQHandler(&mTM00);
}
#endif

/**
 *******************************************************************************
 * @brief       Period elapsed callback in non blocking mode.
 * @param[in]   mTM : pointer to a TM_HandleTypeDef
 * @return      None
 *******************************************************************************
 */
void MID_TM_PeriodElapsedCallback(TM_HandleTypeDef* mTM)
{
    // to do ...
    UNUSED(mTM);

}




